<?php
add_filter( 'keystone_theme_options', function( $setup ) {

    $fields = array(
        'shop_page_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Shop Page', 'keystone-framework' ),
            'submenu' => esc_html__( 'Shop Page', 'keystone-framework' ),
        ),
        'woo_subtitle' => array(
            'type' => 'textarea',
            'label' => esc_html__( 'Shop Subtitle', 'keystone-framework' ),
            'description' => esc_html__( 'Enter a subtitle text for the shop page. Visible only on the main shop page.', 'keystone-framework' ),
            'submenu' => esc_html__( 'Shop Page', 'keystone-framework' ),
         ),
        'woo_catalog_style' => array(
            'type' => 'radio',
            'label' => esc_html__( 'Product Box Style', 'keystone-framework' ),
            'description' => esc_html__( 'Select the product box design.', 'keystone-framework' ),
            'options' => array(
                'wc-style-minimal' => esc_html__( 'Minimal', 'keystone-framework' ),
                'wc-style-detailed' => esc_html__( 'Detailed', 'keystone-framework' ),
            ),
            'value' => 'wc-style-detailed',
            'submenu' => esc_html__( 'Shop Page', 'keystone-framework' ),
        ),
        'woo_products_number' => array(
            'type' => 'range_slider',
            'label' => esc_html__( 'Products per Page', 'keystone-framework' ),
            'min' => 1,
            'max' => 40,
            'step' => 1,
            'value' => 9,
            'description' => esc_html__( 'How many products should be shown per page?', 'keystone-framework' ),
            'submenu' => esc_html__( 'Shop Page', 'keystone-framework' ),
        ),
        'woo_shop_columns' => array(
            'type' => 'range_slider',
            'label' => esc_html__( 'Products per Row', 'keystone-framework' ),
            'min' => 2,
            'max' => 4,
            'step' => 1,
            'value' => 2,
            'description' => esc_html__( 'How many products should be shown per row?', 'keystone-framework' ),
            'submenu' => esc_html__( 'Shop Page', 'keystone-framework' ),
        ),
        'woo_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Shop Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display the Shop Sidebar on shop and archive pages.', 'keystone-framework' ),
            'value' => true,
            'group' => 'started',
            'submenu' => esc_html__( 'Shop Page', 'keystone-framework' ),
        ),
        'woo_sidebar_position' => array(
            'label' => esc_html__( 'Sidebar Position', 'keystone-framework' ),
            'type' => 'radio',
            'options' => array(
                'sidebar-left' => esc_html__( 'Left', 'keystone-framework' ),
                'sidebar-right' => esc_html__( 'Right', 'keystone-framework' ),
            ),
            'value' => 'sidebar-right',
            'dependency' => array(
                'key' => 'woo_sidebar',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Shop Page', 'keystone-framework' ),
        ),
        'woo_sticky_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Sticky Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to keep the sidebar sticky as users scroll.', 'keystone-framework' ),
            'value' => true,
            'dependency' => array(
                'key' => 'woo_sidebar',
                'value' => 'not_empty'
            ),
            'group' => 'ended',
            'submenu' => esc_html__( 'Shop Page', 'keystone-framework' ),
        ),
        'single_product_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Single Product', 'keystone-framework' ),
            'submenu' => esc_html__( 'Single Product', 'keystone-framework' ),
        ),
        'woo_single_image_position' => array(
            'label' => esc_html__( 'Product Image Position', 'keystone-framework' ),
            'description' => esc_html__( 'Select the product image position.', 'keystone-framework' ),
            'type' => 'radio',
            'options' => array(
                'product-image-left' => esc_html__( 'Left', 'keystone-framework' ),
                'product-image-right' => esc_html__( 'Right', 'keystone-framework' ),
            ),
            'value' => 'product-image-left',
            'submenu' => esc_html__( 'Single Product', 'keystone-framework' ),
        ),
        'woo_single_related_number' => array(
            'type' => 'range_slider',
            'label' => esc_html__( 'Number of Related Products', 'keystone-framework' ),
            'description' => esc_html__( 'Select the number of related products.', 'keystone-framework' ),
            'min' => 2,
            'max' => 4,
            'step' => 1,
            'value' => 3,
            'submenu' => esc_html__( 'Single Product', 'keystone-framework' ),
        ),
        'woo_single_social' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Social Sharing Buttons', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display social sharing buttons.', 'keystone-framework' ),
            'description' => esc_html__( 'Display social sharing buttons.', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Single Product', 'keystone-framework' ),
        ),
        'woo_single_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Product Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display the Product Sidebar on product pages.', 'keystone-framework' ),
            'value' => true,
            'group' => 'started',
            'submenu' => esc_html__( 'Single Product', 'keystone-framework' ),
        ),
        'woo_single_sidebar_position' => array(
            'label' => esc_html__( 'Sidebar Position', 'keystone-framework' ),
            'type' => 'radio',
            'options' => array(
                'sidebar-left' => esc_html__( 'Left', 'keystone-framework' ),
                'sidebar-right' => esc_html__( 'Right', 'keystone-framework' ),
            ),
            'value' => 'sidebar-right',
            'dependency' => array(
                'key' => 'woo_single_sidebar',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Single Product', 'keystone-framework' ),
        ),
        'woo_single_sticky_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Sticky Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to keep the sidebar sticky as users scroll.', 'keystone-framework' ),
            'value' => true,
            'dependency' => array(
                'key' => 'woo_single_sidebar',
                'value' => 'not_empty'
            ),
            'group' => 'ended',
            'submenu' => esc_html__( 'Single Product', 'keystone-framework' ),
        ),
    );

    $customFields = array(
        'name' => esc_html__( 'WooCommerce', 'keystone-framework' ),
        'icon' => 'lnricons-bag',
        'fields' => $fields
    );

    $setup[ 'woocommerce' ] = $customFields;

    return $setup;

}, 10, 1 );
