<?php
namespace KeyStone;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$license_key = License\Admin::get_license_key();
$masked_license_key = License\Admin::get_masked_license_key();
$client_name = License\Admin::get_client_name();

$check_connection = License\API::check_connection();
$connection_status = false;
if ( !is_wp_error( $check_connection ) ) {
	if ( $check_connection['status'] ) {
		$connection_status = true;
	}
}

?>

<div class="ksadmin-panel-column ksadmin-activate-column">
    <div class="activation-notice">
		<h3>
			<span class="dashboard-icon lnricons-lock"></span><?php echo esc_html__( 'License Settings', 'keystone-framework' ); ?>
		</h3>
        <?php if ( empty( $license_key ) ) : ?>
			<?php if ( $connection_status ) : ?>
				<p><span class="expired"><?php echo esc_html__( 'Register your theme license key.', 'keystone-framework' ); ?></span></p>
				<hr>
				<?php if ( keystone_theme_requires_license() ) : ?>
				<p>
					<?php printf(
						esc_html__( 'You\'re almost there! Register %1$s to access theme updates, install premium plugins, and import demo content.', 'keystone-framework' ),
						Utils::get_parent_theme_name()
					); ?>
				</p>
			<?php else : ?>
				<p>
					<?php printf(
						esc_html__( '%1$s is fully unlocked, However the purchase code is required for auto updates and 6 month support from Keystone Themes.', 'keystone-framework' ),
						Utils::get_parent_theme_name()
					); ?>
				</p>
			<?php endif; ?>
				<span class="support-badge expired"><?php echo esc_html__( 'Unregistered', 'keystone-framework' ); ?></span>
			<?php else: ?>
				<p><span class="expired"><?php echo esc_html__( 'Could not connect to API server. Please open a ', 'keystone-framework' ); ?><a href="https://keystonethemes.authordesk.app/login" target="_blank"><?php echo esc_html__( 'support ticket', 'keystone-framework' ); ?></a>.</span></p>
			<?php endif; ?>
        <?php else : ?>
			<p><span class="active"><?php echo esc_html__( 'Your license is registered.', 'keystone-framework' ); ?></span></p>
			<hr>
            <p><?php echo esc_html__( 'Need to deactivate your license for any reason?', 'keystone-framework' ); ?></p>
			<span class="support-badge active"><?php echo esc_html__( 'Registered', 'keystone-framework' ); ?></span>
        <?php endif; ?>
    </div>

	<?php if ( $connection_status ) : ?>
		<form class="keystone-activation-form" method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
			<?php wp_nonce_field( 'keystone-license' ); ?>
			
			<?php if ( empty( $license_key ) ) : ?>
				
				<input type="hidden" name="action" value="keystone_activate_license"/>

				<p class="activation-form-field license-code-field">
					<label for="keystone-license-code"><?php echo esc_html__( 'Envato Purchase Code', 'keystone-framework' ); ?></label>
					<input id="keystone-license-code" class="regular-text" name="keystone_license_code" type="text" value="" required>
					<span class="description"><?php echo esc_html__( 'How to find your', 'keystone-framework' ); ?> <a href="https://keystonethemes.com/help-center/general/purchase-code/" target="_blank"><?php echo esc_html__( 'Envato Purchase Code', 'keystone-framework' ); ?></a>.</span>
				</p>
				<p class="activation-form-field envato-username-field">
					<label for="keystone-client-name"><?php echo esc_html__( 'Envato Username', 'keystone-framework' ); ?></label>
					<input id="keystone-client-name" class="regular-text" name="keystone_client_name" type="text" value="" required>
					<span class="description"><?php echo esc_html__( 'How to find your', 'keystone-framework' ); ?> <a href="https://keystonethemes.com/help-center/general/envato-username/" target="_blank"><?php echo esc_html__( 'Envato Username', 'keystone-framework' ); ?></a>.</span>
				</p>
				<p class="activation-form-field submit-field">
					<input type="submit" value="<?php echo esc_html__( 'Register', 'keystone-framework' ); ?>" class="button">
				</p>
			<?php else : ?>

				<input type="hidden" name="action" value="keystone_deactivate_license"/>

				<input id="keystone-license-code" class="regular-text disabled-field" type="text" value="<?php echo esc_attr( $masked_license_key ); ?>" disabled/>
				
				<input type="submit" class="button" value="<?php esc_attr_e( 'Deactivate', 'keystone-framework' ); ?>"/>
			<?php endif; ?>
		</form>
	<?php endif; ?>
</div>