<?php
namespace KeyStone\Compatibility;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'bbPress' ) ) {
	return;
}

class KeyStone_bbPress {
	
	private static $instance;
	
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	
	public function __construct() {
		
		add_action( 'widgets_init', [ $this, 'register_widget_location' ], 15 );
		
	}
	
	public function register_widget_location() {
		register_sidebar(
			apply_filters(
				'keystone_bbpress_sidebar',
				array(
					'name' => esc_html__( 'bbPress Sidebar', 'keystone-framework' ),
					'id' => 'bbpress-sidebar',
					'description' => '',
					'before_widget' => '<section id="%1$s" class="widget keystone-widget %2$s">',
					'after_widget' => '</section>',
					'before_title' => '<h4 class="widget-title">',
					'after_title' => '</h4>',
				)
			)
		);
	}
}
KeyStone_bbPress::instance();