<?php

function overwrite_elementor_library_template() {
    if ( is_singular( 'elementor_library' ) ) {

        /* Remove keystone-container markup */
        remove_action( 'keystone_content_top', 'keystone_container_top_markup', 20 );
        remove_action( 'keystone_content_bottom', 'keystone_container_bottom_markup' );

        /* Hide single post title */
        add_filter( 'keystone_blog_single_show_page_title', '__return_false' );

        /* Remove htumbnail image */
        remove_action( 'keystone_single_entry_content_top', 'keystone_blog_featured_item', 20 );

        /* Hide post meta */
        remove_action( 'keystone_single_entry_content_top', 'keystone_display_post_meta', 15 );

        /* Hide sidebar */
        add_filter( 'keystone_show_sidebar', '__return_false' );

        /* Hide social sharing buttons */
        remove_action( 'keystone_single_entry_content_top', [ KeyStone\Plugin::instance()->theme_features, 'get_social_sharing_markup' ] );

        /* Hide post navigation */
        remove_action( 'keystone_single_entry_content_bottom', 'keystone_single_post_navigation', 20 );
    }
}
add_action( 'wp', 'overwrite_elementor_library_template', 15 );
