<?php

use KeyStone\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function keystone_404_page_title( $value ) {
    if ( '' != Utils::get_option( 'error_page_title' ) ) {
        $value = Utils::get_option( 'error_page_title' );
    }
    return $value;
}
add_filter( '404_page_title_hook', 'keystone_404_page_title' );

function keystone_404_page_subtitle( $value ) {
    if ( '' != Utils::get_option( 'error_page_subtitle' ) ) {
        $value = Utils::get_option( 'error_page_subtitle' );
    }
    return $value;
}
add_filter( '404_page_subtitle_hook', 'keystone_404_page_subtitle' );

// Hide blog page title bar
function keystone_hide_blog_title_bar() {
    if ( is_home() && get_option( 'page_for_posts' ) ) {
        if ( Utils::get_option( 'blog_hide_title_bar' ) == true ) {
            remove_action( 'keystone_content_top', 'keystone_display_page_title' );
        }
    }
}
add_action( 'wp', 'keystone_hide_blog_title_bar' );

// Hide signle blog post featured image
function keystone_hide_blog_featured_image() {
    if ( Utils::get_option( 'blog_single_hide_featured_image' ) == true ) {
        remove_action( 'keystone_single_entry_content_top', 'keystone_blog_featured_item', 20 );
    }
}
add_action( 'init', 'keystone_hide_blog_featured_image' );