<?php
/**
 *
 * @author RadiusTheme
 * @since 1.6
 * @version 1.0.2
 *
 */

defined( 'ABSPATH' ) || die();

final class RtAjaxTemplateFileLoader {

	public function __construct() {
		add_action( 'wp_ajax_nopriv_load_template', [ $this, 'load_template' ] );
		add_action( 'wp_ajax_load_template', [ $this, 'load_template' ] );
	}

	/**
	 * Prevent directory traversal and invalid file names.
	 */
	/**
	 * Check if template path is safe
	 */
	private function rt_is_safe_path_value( $value ) {
		$value = preg_replace( '/[\x00-\x1F\x7F]/', '', $value );
		if ( preg_match( '/\.\.|\\\\/', $value ) ) {
			return false;
		}
		if ( ! preg_match( '/^[A-Za-z0-9._\-\/]+$/', $value ) ) {
			return false;
		}
		return true;
	}

	/**
	 * Load template via AJAX
	 */
	public function load_template() {
		$template = isset($_REQUEST['template']) ? sanitize_text_field($_REQUEST['template']) : '';
		$part     = isset($_REQUEST['part']) ? sanitize_text_field($_REQUEST['part']) : '';
		if ( ! $this->rt_is_safe_path_value( $template ) || ! $this->rt_is_safe_path_value( $part ) ) {
			wp_die( 'Invalid template or part.' );
		}
		if ( $template && $part ) {
			wc_get_template_part( 'ajax/' . $template, $part );
		}
		wp_die();
	}
}

new RtAjaxTemplateFileLoader();
