<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Metro;

use \Redux;

$opt_name = Constants::$theme_options;

Redux::setSection( $opt_name,
	array(
		'title'   => 'Footer',
		'id'      => 'footer_section',
		'heading' => '',
		'icon'    => 'el el-caret-down',
		'fields'  => array(

			array(
				'id'       => 'mail_chimp_layout',
				'type'     => 'switch',
				'title'    => 'Display Footer MailChimp Area',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => false,
			),
			array(
				'id'       => 'mail_chimp_styles',
				'type'     => 'select',
				'title'    => 'MailChimp Layouts',
				'options'  => array(
					'1' => 'Style 1',
					'2' => 'Style 2',
					'3' => 'Style 3',
				),
				'default'  => '1',
				'required' => array( 'mail_chimp_layout', 'equals', true )
			),

			array(
				'id'       => 'mail_chimp_bgcolor',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Primary Color',
				'default'  => '#ffffff',
				'required' => array( 'mail_chimp_styles', 'equals', '1' )
			),

			array(
				'id'       => 'mail_chimp_bgimg',
				'type'     => 'media',
				'title'    => 'Mail Chimp Image',
				'default'  => array(
					'url'=> Helper::get_img( 'mail-chimp-banner.jpg' )
				),
				'required' => array( 'mail_chimp_styles', 'equals', '2' )
			),

			array(
				'id'       => 'mail_shortcode',
				'type'     => 'text',
				'title'    => 'Enter Mail Chimp Shortcode',
				'default'  => '[contact-form-7 id="1141" title="Newsletter 1"]',
				'required' => array( 'mail_chimp_layout', 'equals', true )
			),

			array(
				'id'       => 'footer_area',
				'type'     => 'switch',
				'title'    => 'Display Footer Area',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),

			array(
				'id'       => 'copyright_area',
				'type'     => 'switch',
				'title'    => 'Display Copyright Area',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'copyright_text',
				'type'     => 'textarea',
				'title'    => 'Copyright Text',
				'default'  => sprintf(
					'&copy; Copyright Metro %s. Designed and Developed by <a target="_blank" href="%s" rel="nofollow">RadiusTheme</a>',
					date('Y'),
					esc_url( Constants::$theme_author_uri )
				),
				'required' => array( 'copyright_area', 'equals', true )
			),
			array(
				'id'       => 'social_icons',
				'type'     => 'switch',
				'title'    => 'Display Social Icons',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
				'required' => array( 'copyright_area', 'equals', true )
			),
			array(
				'id'       => 'payment_icons',
				'type'     => 'switch',
				'title'    => 'Display Payment Icons',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => false,
				'required' => array( 'copyright_area', 'equals', true )
			),
			array(
				'id'       => 'payment_img',
				'type'     => 'gallery',
				'title'    => 'Payment Icons Gallery',
				'required' => array( 'payment_icons', 'equals', true )
			),
			array(
				'id'       => 'footer_bottom_styles',
				'type'     => 'select',
				'title'    => 'Copyright Layouts',
				'options'  => array(
					'1' => 'Style 1',
					'2' => 'Style 2',
				),
				'default'  => '1',
				'required' => array( 'payment_icons', 'equals', true )
			),

			array(
				'id'       => 'footer_area_style',
				'type'     => 'switch',
				'title'    => 'Footer Dark Style',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => false,
			),

		)
	)
);
