<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Metro;

use \Redux;

$opt_name = Constants::$theme_options;

Redux::setSection( $opt_name,
	array(
		'title'   => 'General',
		'id'      => 'general_section',
		'heading' => '',
		'icon'    => 'el el-network',
		'fields'  => array(

			array(
				'id'       => 'logo_type',
				'type'     => 'switch',
				'title'    => 'Logo type',
				'on'       => 'Text',
				'off'      => 'Image',
			),

			array(
				'id'       => 'logo',
				'type'     => 'media',
				'title'    => 'Main Logo',
				'default'  => array(
					'url'=> Helper::get_img( 'logo-dark.png' )
				),
				'required' => array( 'logo_type', '!=', true )
			),

			array(
				'id'       => 'logo_text',
				'type'     => 'text',
				'title'    => 'Logo label',
				'default'  => 'Metro',
				'required' => array( 'logo_type', '=', true )
			),

			array(
				'id'       => 'logo_typo',
				'type'     => 'typography',
				'title'    => 'Logo typography',
				'text-align'  => false,
				'output' => array( '.main-header .logo' ),
				'required' => array( 'logo_type', '=', true )
			),

			array(
				'id'       => 'mobile_logo_typo',
				'type'     => 'typography',
				'title'    => 'Mobile Logo typography',
				'text-align'  => false,
				'output' => array( '.mean-bar .logo' ),
				'required' => array( 'logo_type', '=', true )
			),

			array(
				'id'       => 'logo_light',
				'type'     => 'media',
				'title'    => 'Light Logo',
				'default'  => array(
					'url'=> Helper::get_img( 'logo-light.png' )
				),
				'subtitle' => 'Used when Transparent Header is enabled',
				'required' => array( 'logo_type', '!=', true )
			),

			array(
				'id'       => 'logo_width',
				'type'     => 'select',
				'title'    => 'Logo Area Width',
				'subtitle' => 'Width is defined by the number of bootstrap columns. Please note, navigation menu width will be decreased with the increase of logo width',
				'options'  => array(
					'1' => '1 Column',
					'2' => '2 Column',
					'3' => '3 Column',
					'4' => '4 Column',
				),
				'default'  => '3',
			),
			array(
				'id'       => 'logo_height',
				'type'     => 'slider',
				'title'    => 'Logo Height',
				'subtitle' => 'Maximum height of logo. Recommended value is: 53',
				'default'  => 53,
				'min'      => 0,
				'step'     => 1,
				'max'      => 700,
				'required' => array( 'logo_type', '!=', true )
			),
			array(
				'id'       => 'breadcrumb',
				'type'     => 'switch',
				'title'    => 'Breadcrumb',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'preloader',
				'type'     => 'switch',
				'title'    => 'Preloader',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'preloader_image',
				'type'     => 'media',
				'title'    => 'Preloader Image',
				'subtitle' => 'Please upload your choice of preloader image. Transparent GIF format is recommended',
				'default'  => array(
					'url'=> Helper::get_img( 'preloader.gif' )
				),
				'required' => array( 'preloader', 'equals', true )
			),
			array(
				'id'       => 'back_to_top',
				'type'     => 'switch',
				'title'    => 'Back to Top Arrow',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'p_search_enable',
				'type'     => 'switch',
				'title'    => 'Enable Product Search for whole site',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => false,
			),
		)
	)
);
