<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Metro;

use \Redux;

$opt_name = Constants::$theme_options;

function rdtheme_redux_post_type_fields( $prefix ){
	return array(
		'layout' => array(
			'id'       => $prefix. '_layout',
			'type'     => 'button_set',
			'title'    => 'Layout',
			'options'  => array(
				'left-sidebar'  => 'Left Sidebar',
				'full-width'    => 'Full Width',
				'right-sidebar' => 'Right Sidebar',
			),
			'default'  => 'right-sidebar'
		),
		'sidebar' => array(
			'id'       => $prefix. '_sidebar',
			'type'     => 'select',
			'title'    => 'Custom Sidebar',
			'options'  => Helper::custom_sidebar_fields(),
			'default'  => 'sidebar',
			'required' => array( $prefix. '_layout', '!=', 'full-width' ),
		),
		'top_bar' => array(
			'id'       => $prefix. '_top_bar',
			'type'     => 'select',
			'title'    => 'Top Bar',
			'options'  => array(
				'default' => 'Default',
				'on'      => 'Enabled',
				'off'     => 'Disabled',
			),
			'default'  => 'default',
		),
		'top_bar_style' => array(
			'id'       => $prefix. '_top_bar_style',
			'type'     => 'select',
			'title'    => 'Top Bar Layout',
			'options'  => array(
				'default' => 'Default',
				'1'       => 'Layout 1',
				'2'       => 'Layout 2',
				'3'       => 'Layout 3',
				'4'       => 'Layout 4',
			),
			'default'  => 'default',
			'required' => array( $prefix. '_top_bar', '!=', 'off' )
		),
		'header_style' => array(
			'id'       => $prefix. '_header_style',
			'type'     => 'select',
			'title'    => 'Header Layout',
			'options'  => array(
				'default' => 'Default',
				'1'       => 'Layout 1',
				'2'       => 'Layout 2',
				'3'       => 'Layout 3',
				'4'       => 'Layout 4',
				'5'       => 'Layout 5',
				'6'       => 'Layout 6',
			),
			'default'  => 'default',
		),
		'banner' => array(
			'id'       => $prefix. '_banner',
			'type'     => 'select',
			'title'    => 'Banner',
			'options'  => array(
				'default' => 'Default',
				'on'      => 'Enabled',
				'off'     => 'Disabled',
			),
			'default'  => 'default',
		),
		'breadcrumb' => array(
			'id'       => $prefix. '_breadcrumb',
			'type'     => 'select',
			'title'    => 'Breadcrumb',
			'options'  => array(
				'default' => 'Default',
				'on'      => 'Enabled',
				'off'     => 'Disabled',
			),
			'default'  => 'default',
			'required' => array( $prefix. '_banner', '!=', 'off' )
		),
		'bgtype' => array(
			'id'       => $prefix. '_bgtype',
			'type'     => 'select',
			'title'    => 'Banner Background Type',
			'options'  => array(
				'default' => 'Default',
				'bgcolor' => 'Background Color',
				'bgimg'   => 'Background Image',
			),
			'default'  => 'default',
			'required' => array( $prefix. '_banner', '!=', 'off' )
		),
		'bgimg' => array(
			'id'       => $prefix. '_bgimg',
			'type'     => 'media',
			'title'    => 'Banner Background Image',
			'default'  => '',
			'required' => array( $prefix. '_bgtype', '=', 'bgimg' ),
		),
		'bgcolor' => array(
			'id'       => $prefix. '_bgcolor',
			'type'     => 'color',
			'title'    => 'Banner Background Color',
			'validate' => 'color',
			'transparent' => false,
			'default'  => '',
			'required' => array( $prefix. '_bgtype', '=', 'bgcolor' ),
		),
		'footer_area_style' => array(
			'id'       => $prefix. '_footer_area_style',
			'type'     => 'select',
			'title'    => 'Display Footer Dark',
			'options'  => array(
				'default' => 'Default',
				'on'      => 'Enabled',
				'off'     => 'Disabled',
			),
			'default'  => 'default',
		),
	);
}

Redux::setSection( $opt_name, array(
	'title' => 'Layout Defaults',
	'id'    => 'layout_defaults',
	'icon'  => 'el el-th',
) );

// Page
$rdtheme_page_fields = rdtheme_redux_post_type_fields( 'page' );
$rdtheme_page_fields['layout']['default'] = 'full-width';
Redux::setSection( $opt_name, array(
	'title'      => 'Page',
	'id'         => 'pages_section',
	'subsection' => true,
	'fields'     => $rdtheme_page_fields
) );

// Post Archive
$rdtheme_post_archive_fields = rdtheme_redux_post_type_fields( 'blog' );
Redux::setSection( $opt_name, array(
	'title'      => 'Blog / Archive',
	'id'         => 'blog_section',
	'subsection' => true,
	'fields'     => $rdtheme_post_archive_fields
) );

// Single Post
$rdtheme_single_post_fields = rdtheme_redux_post_type_fields( 'single_post' );
Redux::setSection( $opt_name, array(
	'title'      => 'Post Single',
	'id'         => 'single_post_section',
	'subsection' => true,
	'fields'     => $rdtheme_single_post_fields
) );

// Search
$rdtheme_search_fields = rdtheme_redux_post_type_fields( 'search' );
Redux::setSection( $opt_name, array(
	'title'      => 'Search Layout',
	'id'         => 'search_section',
	'subsection' => true,
	'fields'     => $rdtheme_search_fields
) );

// Error 404 Layout
$rdtheme_error_fields = rdtheme_redux_post_type_fields( 'error' );
unset($rdtheme_error_fields['layout']);
$rdtheme_error_fields['banner']['default'] = 'off';
Redux::setSection( $opt_name, array(
	'title'      => 'Error 404 Layout',
	'id'         => 'error_section',
	'subsection' => true,
	'fields'     => $rdtheme_error_fields
) );

// WooCommerce
if ( class_exists( 'WooCommerce' ) ) {
	$rdtheme_shop_archive_fields = rdtheme_redux_post_type_fields( 'shop' );
	Redux::setSection( $opt_name, array(
		'title'      => 'Shop',
		'id'         => 'shop_section',
		'subsection' => true,
		'fields'     => $rdtheme_shop_archive_fields
	) );

	$rdtheme_product_fields = rdtheme_redux_post_type_fields( 'product' );
	$rdtheme_product_fields['layout']['default'] = 'full-width';
	Redux::setSection( $opt_name, array(
		'title'      => 'Product',
		'id'         => 'product_section',
		'subsection' => true,
		'fields'     => $rdtheme_product_fields
	) );
}

// Dokan
if ( function_exists( 'dokan' ) ) {
	$rdtheme_store_fields = rdtheme_redux_post_type_fields( 'store' );
	Redux::setSection( $opt_name, array(
		'title'      => 'Store',
		'id'         => 'store_section',
		'subsection' => true,
		'fields'     => $rdtheme_store_fields
	) );
}
