<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Metro;

use \Redux;
$opt_name = Constants::$theme_options;

Redux::setSection( $opt_name,
    array(
        'title' => 'WooCommerce Settings',
        'id'    => 'wc_secttings',
        'icon'  => 'el el-shopping-cart',
    )
);

Redux::setSection( $opt_name,
    array(
        'title'   => 'Shop Page',
        'id'      => 'wc_sec_shop',
        'subsection' => true,
        'fields'  => array(
            array(
                'id'       => 'wc_product_layout',
                'type'     => 'select',
                'title'    =>  'Product Block Style',
                'options'  => array(
                    '1' =>  'Style 1',
                    '2' =>  'Style 2',
                    '3' =>  'Style 3',
                    '4' =>  'Style 4',
                    '5' =>  'Style 5',
                    '6' =>  'Style 6',
                    '7' =>  'Style 7',
                    '8' =>  'Style 8',
                    '9' =>  'Style 9',
                    '10' =>  'Style 10',
                    '12' =>  'Style 12',
                ),
                'default'  => '1',
            ),

            array(
                'id'       => 'wc_product_columns_update',
                'type'     => 'switch',
                'title'    =>  'Product Columns Update',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),

            array(
                'id'       => 'wc_desktops_product_columns',
                'type'     => 'select',
                'title'    =>  'Desktops Product Columns',
                'options'  => array(
                    '12' =>  '1 Col',
                    '6'  =>  '2 Col',
                    '4'  =>  '3 Col',
                    '3'  =>  '4 Col',
                    '2'  =>  '6 Col',
                ),
                'required' => array( 'wc_product_columns_update', 'equals', true ),
                'default'  => '4',
            ),

            array(
                'id'       => 'wc_tab_product_columns',
                'type'     => 'select',
                'title'    =>  'Tab Product Columns',
                'options'  => array(
                    '12' =>  '1 Col',
                    '6'  =>  '2 Col',
                    '4'  =>  '3 Col',
                    '3'  =>  '4 Col',
                    '2'  =>  '6 Col',
                ),
                'default'  => '6',
            ),
            array(
                'id'       => 'wc_mobile_product_columns',
                'type'     => 'select',
                'title'    =>  'Mobile Product Columns',
                'options'  => array(
                    '12' =>  '1 Col',
                    '6'  =>  '2 Col',
                    '4'  =>  '3 Col',
                    '3'  =>  '4 Col',
                    '2'  =>  '6 Col',
                ),
                'default'  => '12',
            ),
 
            array(
                'id'       => 'product_img_size',
                'type'     => 'select',
                'title'    =>  'Product image size',
                'options'  => Helper::rt_thumb_size(),
                'default'  => 'woocommerce_thumbnail'
            ),

             array(
                'id'       => 'wc_shop_Product_img_size',
                'type'     => 'switch',
                'title'    =>  'Product Columns Images 100% ',
                'on'       =>  'Enabled',
                'off'      =>  'Disabled',
                'default'  => true,
            ),


            array(
                'id'       => 'wc_num_product',
                'type'     => 'text',
                'title'    =>  'Number of Products Per Page',
                'default'  => '9',
            ),
            array(
                'id'       => 'wc_pagination',
                'type'     => 'button_set',
                'title'    =>  'Pagination Type',
                'options'  => array(
                    'numbered'        =>  'Numbered',
                    'load-more'       =>  'Load More',
                    'infinity-scroll' =>  'Infinity Scroll',
                ),
                'default'  => 'numbered'
            ),
            array(
                'id'       => 'wc_sale_label',
                'type'     => 'button_set',
                'title'    =>  'Sale Product Label',
                'options'  => array(
                    'percentage' =>  'Percentage',
                    'text'       =>  'Text',
                ),
                'default'  => 'percentage'
            ),
            array(
                'id'       => 'wc_shop_cat',
                'type'     => 'switch',
                'title'    =>  'Category',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
            array(
                'id'       => 'wc_shop_review',
                'type'     => 'switch',
                'title'    =>  'Review Star',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
            array(
                'id'       => 'wc_shop_wishlist_icon',
                'type'     => 'switch',
                'title'    =>  'Wishlist Icon',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
                'subtitle' =>  'Plugin "YITH WooCommerce Wishlist" must be enabled to use this feature',
            ),
            array(
                'id'       => 'wc_shop_quickview_icon',
                'type'     => 'switch',
                'title'    =>  'Quickview Icon',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
                'subtitle' =>  'Plugin "YITH WooCommerce Quick View" must be enabled to use this feature',
            ),

            array(
                'id'       => 'wc_shop_compare_icon',
                'type'     => 'switch',
                'title'    =>  'Compare Icon',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
                'subtitle' =>  'Plugin "YITH WooCommerce Compare" must be enabled to use this feature',
            ),

            array(
                'id' => 'metro_search_auto_suggest_status',
                'type' => 'switch',
                'title' => 'Header Autosuggest Product Search',

                'default' => true,
                'on' => 'Enable',
                'off' => 'Disable',
            ),
            array(
                'id' => 'metro_search_img_status',
                'type' => 'switch',
                'title' => 'Header Autosuggest Product Search With Image',
                'default' => true,
                'on' => 'Enable',
                'off' => 'Disable',
            ),
            array(
                'id' => 'metro_search_auto_suggest_limit',
                'type' => 'text',
                'title' => 'Autosuggest Limit',

                'default' => '10'
            ),
            array(
                'id'       => 'metro_wc_product_archive_slide_or_alternate',
                'type'     => 'button_set',
                'title'    =>  'Product Archive Style',
                'options'  => array(
                    'slide' =>  'Gallery Slide',
                    'alternate' =>  'Gallery Alternate',
                ),
                'default'  => 'slide',
            ),
            array(
                'id'       => 'metro_wc_product_filter_type',
                'type'     => 'button_set',
                'title'    =>  'Product Filter Type',
                'options'  => array(
                    'ajax' =>  'Ajax',
                    'regular' =>  'Regular',
                ),
                'default'  => 'regular',
            ),
            array(
                'id'       => 'metro_wc_product_filter_ajax_preloader',
                'type'     => 'media',
                'title'    =>  'Ajax Preloader',
                'default'  => array(
                    'url' => Helper::get_img('metro-ajax-loader.gif')
                ),
            ),
            array(
                'id' => 'metro_wc_top_widget',
                'type' => 'switch',
                'title' => 'Enable top widget on shop page for filters.',
                'default' => false,
                'on' => 'Enable',
                'off' => 'Disable',
            ),

        )
    )
);

Redux::setSection( $opt_name,
    array(
        'title'   =>  'Product Page',
        'id'      => 'wc_sec_product',
        'subsection' => true,
        'fields'  => array(
            array(
                'id'       => 'wc_single_product_layout',
                'type'     => 'select',
                'title'    =>  'Layout',
                'options'  => array(
                    '1' =>  'Default',
                    '2' =>  'Layout 2',
                    '3' =>  'Layout 3',
                ),
                'default'  => '1',
            ),
            array(
                'id'       => 'wc_show_excerpt',
                'type'     => 'switch',
                'title'    =>  "Show excerpt when short description doesn't exist",
                'on'       =>  'Enabled',
                'off'      =>  'Disabled',
                'default'  => true,
            ),
            array(
                'id'       => 'wc_cats',
                'type'     => 'switch',
                'title'    =>  'Categories',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
            array(
                'id'       => 'wc_tags',
                'type'     => 'switch',
                'title'    =>  'Tags',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
            array(
                'id'       => 'wc_social',
                'type'     => 'switch',
                'title'    =>  'Display Social Sharing',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
            array(
                'id'      => 'wc_share',
                'type'    => 'checkbox',
                'class'   => 'redux-custom-inline',
                'title'   =>  'Social Sharing Icons',
                'options' => array(
                    'facebook'  => 'Facebook',
                    'twitter'   => 'Twitter',
                    'linkedin'  => 'Linkedin',
                    'pinterest' => 'Pinterest',
                    'tumblr'    => 'Tumblr',
                    'reddit'    => 'Reddit',
                    'vk'        => 'Vk',
                ),
                'default' => array(
                    'facebook'  => '1',
                    'twitter'   => '1',
                    'linkedin'  => '1',
                    'pinterest' => '1',
                    'tumblr'    => '0',
                    'reddit'    => '1',
                    'vk'        => '0',
                ),
                'required' => array( 'wc_social', '=', true )
            ),
            array(
                'id'       => 'wc_product_quickview_icon',
                'type'     => 'switch',
                'title'    =>  'Quickview Icon',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
                'subtitle' =>  'Plugin "YITH WooCommerce Quick View" must be enabled to use this feature',
            ),
            array(
                'id'       => 'wc_product_compare_icon',
                'type'     => 'switch',
                'title'    =>  'Compare Icon',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
                'subtitle' =>  'Plugin "YITH WooCommerce Compare" must be enabled to use this feature',
            ),
            array(
                'id'       => 'wc_product_wishlist_icon',
                'type'     => 'switch',
                'title'    =>  'Wishlist Icon',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
                'subtitle' =>  'Plugin "YITH WooCommerce Wishlist" must be enabled to use this feature',
            ),
            array(
                'id'       => 'wc_related',
                'type'     => 'switch',
                'title'    =>  'Related Products',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),

            array(
                'id'       => 'wc_related_products',
                'type'     => 'slider',
                'title'    =>  'Number of related product',
                'default'  => 4,
                'min'      => 1,
                'max'      => 15,
                'required' => array( 'wc_related', '=', true )
            ),

            array(
                'id'       => 'wc_description',
                'type'     => 'switch',
                'title'    =>  'Description Tab',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
            array(
                'id'       => 'wc_reviews',
                'type'     => 'switch',
                'title'    =>  'Reviews Tab',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
            array(
                'id'       => 'wc_additional_info',
                'type'     => 'switch',
                'title'    =>  'Additional Information Tab',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
            array(
                'id'       => 'in_stock_avaibility',
                'type'     => 'switch',
                'title'    =>  'In stock Availability',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
        )
    )
);

Redux::setSection( $opt_name,
    array(
        'title'   =>  'Cart Page',
        'id'      => 'wc_sec_cart',
        'subsection' => true,
        'fields'  => array(
            array(
                'id'       => 'wc_cross_sell',
                'type'     => 'switch',
                'title'    =>  'Cross Sell Products',
                'on'       =>  'Show',
                'off'      =>  'Hide',
                'default'  => true,
            ),
        )
    )
);

do_action('rt_after_redux_options_loaded','metro');