const mix = require('laravel-mix');
const fs = require("fs-extra");
const path = require("path");
const cliColor = require("cli-color");
const emojic = require("emojic");
const wpPot = require('wp-pot');
const archiver = require("archiver");
const min = mix.inProduction() ? '.min' : '';

const package_path = path.resolve(__dirname);
const package_slug = path.basename(path.resolve(package_path));
const temDirectory = package_path + "/temp";

mix.options({
    terser: {
        extractComments: false,
    },
    processCssUrls: false
});

if (process.env.npm_config_package) {

    mix.then(function () {
        const copyTo = path.resolve(`${temDirectory}/${package_slug}`);
        // Select All file then paste on list
        let includes = [
            'assets',
            'dokan',
            'inc',
            'languages',
            'plugin-bundle',
            'sample-data',
            'shopbuilder',
            'src',
            'template-parts',
            'templates',
            'woocommerce',
            '404.php',
            'comments.php',
            'footer.php',
            'functions.php',
            'header.php',
            'index.php',
            'page.php',
            'screenshot.png',
            'search.php',
            'sidebar.php',
            'single.php',
            'style.css',
            'wpml-config.xml',
            `${package_slug}.php`];
        fs.ensureDir(copyTo, function (err) {
            if (err) return console.error(err);
            includes.map(include => {
                fs.copy(`${package_path}/${include}`, `${copyTo}/${include}`, function (err) {
                    if (err) return console.error(err);
                    console.log(cliColor.white(`=> ${emojic.smiley}  ${include} copied...`));
                })
            });
            console.log(cliColor.white(`=> ${emojic.whiteCheckMark}  Build directory created`));
        });
    });

    return;
}

if ((!process.env.npm_config_block && !process.env.npm_config_package) && (process.env.NODE_ENV === 'development' || process.env.NODE_ENV === 'production')) {

    if (mix.inProduction()) {
        let languages = path.resolve('languages');
        fs.ensureDir(languages, function (err) {
            if (err) return console.error(err); // if file or folder does not exist
            wpPot({
                package: 'Metro Theme',
                bugReport: '',
                src: '**/*.php',
                domain: 'metro',
                destFile: `languages/metro.pot`
            });
        });

    }

}

if (process.env.npm_config_zip) {
    const destinationPath = `${temDirectory}/${package_slug}.zip`;
       const output = fs.createWriteStream(destinationPath);
       const archive = archiver('zip', {zlib: {level: 9}});
       output.on('close', function () {
           console.log(archive.pointer() + ' total bytes');
           console.log('Archive has been finalized and the output file descriptor has closed.');
           fs.removeSync(`${temDirectory}/${package_slug}`);
       });
       output.on('end', function () {
           console.log('Data has been drained');
       });
       archive.on('error', function (err) {
           throw err;
       });

       archive.pipe(output);
       archive.directory(`${temDirectory}/${package_slug}`, package_slug);
       archive.finalize();
}