<?php
if ( ! function_exists( 'themesflat_body_classes' ) ) {
	add_filter( 'body_class', 'themesflat_body_classes' );

	function themesflat_body_classes( $classes ) {	
		$custom_page_class = themesflat_meta('custom_page_class');

		$classes[] = $custom_page_class;

		/**
		 * layout version
		 */
	    $layout_version = themesflat_get_opt('layout_version');
		$classes[] = $layout_version;

		/**
		 * Header Absolute
		 */
	    $header_absolute = themesflat_get_opt('header_absolute');
	    if (themesflat_get_opt_elementor('header_absolute') != '') {
		    $header_absolute = themesflat_get_opt_elementor('header_absolute');
		}
		if ( $header_absolute == 1 ) {
			$classes[] = 'header-absolute';
		}

		/**
		 * Header Sticky
		 */
		$header_sticky = themesflat_get_opt('header_sticky');
	    if (themesflat_get_opt_elementor('header_sticky') != '') {
		    $header_sticky = themesflat_get_opt_elementor('header_sticky');
		}		
		if ( $header_sticky == 1 ) {
			$classes[] = 'header_sticky';
		}

		/**
		 * Header Style
		 */
		$style_header = themesflat_get_opt('style_header');
		if (themesflat_get_opt_elementor('style_header') != '') {
		    $style_header = themesflat_get_opt_elementor('style_header');
		}
		$classes[] = $style_header;

		/**
		 * Blog Single Style
		 */
		$style_blog_single = themesflat_get_opt('style_blog_single');
		if (themesflat_get_opt_elementor('style_blog_single') != '') {
		    $style_blog_single = themesflat_get_opt_elementor('style_blog_single');
		}
		$classes[] = $style_blog_single;

		/**
		 * One Page
		 */
		$one_page = '';
		if (themesflat_get_opt_elementor('onepage_menu') == 1) {
		    $one_page = 'one-page-menu';
		}
		$classes[] = $one_page;

		/**
		 * Name Page
		 */	  
		 $slug = get_post_field( 'post_name', get_post() );  	
		if ( $slug != '' ) {
			$classes[] = 'class-name-page-'.$slug;
		}


		return $classes;
	}
}