<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => __( 'Category Menu', 'minimog' ),
	'desc'       => 'Display a category menu on site header. This feature only supported for Header Style 06, 08, 10, 11',
	'id'         => 'category_menu',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'     => 'section_start_header_category_general',
			'type'   => 'tm_heading',
			'title'  => __( 'General', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'header_category_menu_enable',
			'type'    => 'button_set',
			'title'   => __( 'Enable', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'header_category_menu_enable' ),
		),
		array(
			'id'      => 'header_category_menu_sticky_homepage',
			'type'    => 'button_set',
			'title'   => __( 'Sticky on homepage?', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'header_category_menu_sticky_homepage' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'header_category_menu_toggler_text',
			'title'       => __( 'Toggle Button Text', 'minimog' ),
			'description' => __( 'Leave blank to use default.', 'minimog' ),
			'default'     => '',
		),
		array(
			'id'     => 'section_start_header_category_dark_version',
			'type'   => 'tm_heading',
			'title'  => __( 'Header Dark Version', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_background_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_border_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Border', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_hover_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_hover_background_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Hover Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_hover_border_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Hover Border', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'     => 'section_start_header_category_light_version',
			'type'   => 'tm_heading',
			'title'  => __( 'Header Light Version', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_background_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_border_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Border', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_hover_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_hover_background_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Hover Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_hover_border_color',
			'type'        => 'color',
			'title'       => __( 'Toggler Hover Border', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'     => 'section_start_header_category_dropdown',
			'type'   => 'tm_heading',
			'title'  => __( 'Dropdown Menu', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'header_category_menu_background_color',
			'type'        => 'color',
			'title'       => __( 'Menu Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_border_color',
			'type'        => 'color',
			'title'       => __( 'Menu Border Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_color',
			'type'        => 'color',
			'title'       => __( 'Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_hover_color',
			'type'        => 'color',
			'title'       => __( 'Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_hover_background',
			'type'        => 'color',
			'title'       => __( 'Link Hover Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_arrow_color',
			'type'        => 'color',
			'title'       => __( 'Link Arrow Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_hover_arrow_color',
			'type'        => 'color',
			'title'       => __( 'Link Hover Arrow Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'      => 'header_category_menu_link_hover_shadow',
			'type'    => 'switch',
			'title'   => __( 'Link Hover Shadow', 'minimog' ),
			'default' => false,
		),
		array(
			'id'            => 'header_category_menu_link_rounded',
			'type'          => 'slider',
			'title'         => __( 'Link Hover Rounded', 'minimog' ),
			'default'       => 5,
			'min'           => 0,
			'step'          => 1,
			'max'           => 50,
			'display_value' => 'text',
		),
	),
) );
