<?php
$sidebar_positions   = Minimog_Helper::get_list_sidebar_positions();
$registered_sidebars = Minimog_Redux::instance()->get_registered_widgets_options();

Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => __( 'Archive Product', 'minimog' ),
	'id'         => 'archive_product',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'     => 'section_start_product_archive_header',
			'type'   => 'tm_heading',
			'title'  => __( 'Header Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'product_archive_header_type',
			'type'        => 'select',
			'title'       => __( 'Header Style', 'minimog' ),
			'description' => __( 'Select default header style that displays on archive product page.', 'minimog' ),
			'placeholder' => __( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Header::instance()->get_list( true ),
		),
		array(
			'id'          => 'product_archive_header_overlay',
			'type'        => 'select',
			'title'       => __( 'Header Overlay', 'minimog' ),
			'placeholder' => __( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Header::instance()->get_overlay_list(),
		),
		array(
			'id'          => 'product_archive_header_skin',
			'type'        => 'select',
			'title'       => __( 'Header Skin', 'minimog' ),
			'placeholder' => __( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Header::instance()->get_skin_list(),
		),
		array(
			'id'     => 'section_start_product_archive_title_bar',
			'type'   => 'tm_heading',
			'title'  => __( 'Title Bar Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'product_archive_title_bar_layout',
			'type'        => 'select',
			'title'       => __( 'Title Bar Style', 'minimog' ),
			'description' => __( 'Select default Title Bar that displays on all archive product (included cart, checkout, my-account...) pages.', 'minimog' ),
			'placeholder' => __( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Title_Bar::instance()->get_list( true ),
		),
		array(
			'type'    => 'text',
			'id'      => 'product_archive_title_bar_title',
			'title'   => __( 'Heading Text', 'minimog' ),
			'default' => __( 'Shop', 'minimog' ),
		),
		array(
			'id'     => 'section_start_product_archive_sidebar',
			'type'   => 'tm_heading',
			'title'  => __( 'Sidebar Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'product_archive_page_sidebar_1',
			'type'    => 'select',
			'title'   => __( 'Sidebar 1', 'minimog' ),
			'options' => $registered_sidebars,
			'default' => Minimog_Redux::get_default_setting( 'product_archive_page_sidebar_1' ),
		),
		array(
			'id'       => 'product_archive_off_sidebar',
			'type'     => 'button_set',
			'title'    => __( 'Sidebar 1 Off-Canvas', 'minimog' ),
			'options'  => array(
				'0'      => __( 'No', 'minimog' ),
				'1'      => __( 'Always', 'minimog' ),
				'mobile' => __( 'Only Mobile', 'minimog' ),
			),
			'default'  => Minimog_Redux::get_default_setting( 'product_archive_off_sidebar' ),
			'required' => array(
				[ 'product_archive_page_sidebar_1', '!=', 'none' ],
			),
		),
		array(
			'id'       => 'product_archive_page_sidebar_1_off_canvas_toggle_text',
			'type'     => 'text',
			'title'    => __( 'Sidebar 1 Toggle Text', 'minimog' ),
			'required' => array(
				[ 'product_archive_page_sidebar_1', '!=', 'none' ],
				[ 'product_archive_off_sidebar', '!=', '0' ],
			),
		),
		array(
			'id'      => 'product_archive_page_sidebar_2',
			'type'    => 'select',
			'title'   => __( 'Sidebar 2', 'minimog' ),
			'options' => $registered_sidebars,
			'default' => Minimog_Redux::get_default_setting( 'product_archive_page_sidebar_2' ),
		),
		array(
			'id'       => 'product_archive_page_sidebar_2_off_canvas_enable',
			'type'     => 'button_set',
			'title'    => __( 'Sidebar 2 Off-Canvas', 'minimog' ),
			'options'  => array(
				'0'      => __( 'No', 'minimog' ),
				'1'      => __( 'Always', 'minimog' ),
				'mobile' => __( 'Only Mobile', 'minimog' ),
			),
			'default'  => Minimog_Redux::get_default_setting( 'product_archive_page_sidebar_2_off_canvas_enable' ),
			'required' => array(
				[ 'product_archive_page_sidebar_2', '!=', 'none' ],
			),
		),
		array(
			'id'       => 'product_archive_page_sidebar_2_off_canvas_toggle_text',
			'type'     => 'text',
			'title'    => __( 'Sidebar 2 Toggle Text', 'minimog' ),
			'required' => array(
				[ 'product_archive_page_sidebar_2', '!=', 'none' ],
				[ 'product_archive_page_sidebar_2_off_canvas_enable', '!=', '0' ],
			),
		),
		array(
			'id'      => 'product_archive_page_sidebar_position',
			'type'    => 'button_set',
			'title'   => __( 'Sidebar Position', 'minimog' ),
			'options' => $sidebar_positions,
			'default' => Minimog_Redux::get_default_setting( 'product_archive_page_sidebar_position' ),
		),
		array(
			'id'             => 'product_archive_single_sidebar_width',
			'type'           => 'dimensions',
			'units'          => array( '%' ),
			'units_extended' => 'false',
			'title'          => __( 'Single Sidebar Width', 'minimog' ),
			'description'    => __( 'Controls the width of the sidebar when only one sidebar is present. Leave blank to use global setting.', 'minimog' ),
			'height'         => false,
			'default'        => array(
				'width' => 25,
			),
		),
		array(
			'id'             => 'product_archive_single_sidebar_offset',
			'type'           => 'dimensions',
			'units'          => array( 'px' ),
			'units_extended' => 'false',
			'title'          => __( 'Single Sidebar Offset', 'minimog' ),
			'description'    => __( 'Controls the offset of the sidebar when only one sidebar is present. Leave blank to use global setting.', 'minimog' ),
			'height'         => false,
			'default'        => array(
				'width' => 30,
			),
		),
		array(
			'id'      => 'product_archive_sidebar_style',
			'type'    => 'select',
			'title'   => __( 'Sidebar Style', 'minimog' ),
			'options' => Minimog_Sidebar::instance()->get_supported_style_options(),
			'default' => Minimog_Redux::get_default_setting( 'product_archive_sidebar_style' ),
		),
		array(
			'id'          => 'shop_archive_filtering',
			'type'        => 'button_set',
			'title'       => __( 'Filters Button', 'minimog' ),
			'description' => __( 'Show filters button that displays above products list. This button toggle sidebar 1.', 'minimog' ),
			'options'     => array(
				'0'             => __( 'Hide', 'minimog' ),
				'toolbar_left'  => __( 'Toolbar left', 'minimog' ),
				'toolbar_right' => __( 'Toolbar right', 'minimog' ),
			),
			'default'     => 'toolbar_right',
			'required'    => array(
				[ 'product_archive_off_sidebar', '=', '1' ],
			),
		),
		array(
			'id'     => 'section_start_product_archive_layout',
			'type'   => 'tm_heading',
			'title'  => __( 'Layout Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'shop_archive_site_layout',
			'type'    => 'select',
			'title'   => __( 'Site Layout', 'minimog' ),
			'options' => Minimog_Site_Layout::instance()->get_container_wide_list(),
			'default' => Minimog_Site_Layout::CONTAINER_WIDE,
		),
		array(
			'id'      => 'shop_archive_page_title',
			'type'    => 'button_set',
			'title'   => __( 'Page Title?', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_page_title' ),
		),
		array(
			'id'      => 'shop_archive_grid_style',
			'type'    => 'select',
			'title'   => __( 'Grid Style', 'minimog' ),
			'options' => Minimog_Woo::instance()->get_shop_loop_style_options(),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_grid_style' ),
		),
		array(
			'id'      => 'shop_archive_grid_caption_style',
			'type'    => 'select',
			'title'   => __( 'Caption Style', 'minimog' ),
			'options' => Minimog_Woo::instance()->get_shop_loop_caption_style_options(),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_grid_caption_style' ),
		),
		array(
			'id'            => 'shop_archive_number_item',
			'title'         => __( 'Number items', 'minimog' ),
			'description'   => __( 'Controls the number of products display on shop archive page', 'minimog' ),
			'type'          => 'slider',
			'default'       => 12,
			'min'           => 1,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'shop_archive_lg_columns',
			'title'         => __( 'Grid Columns', 'minimog' ),
			'type'          => 'slider',
			'default'       => 4,
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'shop_archive_lg_gutter',
			'title'         => __( 'Grid Gutter', 'minimog' ),
			'type'          => 'slider',
			'default'       => 30,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'shop_archive_md_columns',
			'title'         => __( 'Grid Columns (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 3,
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'shop_archive_md_gutter',
			'title'         => __( 'Grid Gutter (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 20,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'shop_archive_sm_columns',
			'title'         => __( 'Grid Columns (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 2,
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'shop_archive_sm_gutter',
			'title'         => __( 'Grid Gutter (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 16,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'     => 'section_start_product_archive_other_settings',
			'type'   => 'tm_heading',
			'title'  => __( 'Other Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'shop_archive_toolbar_position',
			'type'    => 'select',
			'title'   => __( 'Toolbar Position', 'minimog' ),
			'options' => [
				'above-content'         => __( 'Above Content', 'minimog' ),
				'above-content-sidebar' => __( 'Above Content & Sidebar', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_toolbar_position' ),
		),
		array(
			'id'      => 'shop_archive_result_count',
			'type'    => 'button_set',
			'title'   => __( 'Result Count', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_result_count' ),
		),
		array(
			'id'          => 'shop_archive_sorting',
			'type'        => 'button_set',
			'title'       => __( 'Sorting', 'minimog' ),
			'description' => __( 'Turn on to show sorting select options that displays above products list.', 'minimog' ),
			'options'     => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default'     => '1',
		),
		array(
			'id'      => 'shop_archive_pagination_type',
			'type'    => 'button_set',
			'title'   => __( 'Pagination Type', 'minimog' ),
			'options' => array(
				''          => __( 'Numbered list', 'minimog' ),
				'load-more' => __( 'Load more button', 'minimog' ),
				'infinite'  => __( 'Infinite scrolling', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_pagination_type' ),
		),
		array(
			'id'          => 'shop_archive_layout_switcher',
			'type'        => 'button_set',
			'title'       => __( 'Layout Switcher', 'minimog' ),
			'description' => __( 'Display layout switcher buttons that show above products list.', 'minimog' ),
			'options'     => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default'     => '1',
		),
		array(
			'id'          => 'shop_archive_hover_image',
			'type'        => 'button_set',
			'title'       => __( 'Hover Image', 'minimog' ),
			'description' => __( 'Turn on to show the first gallery image when hover', 'minimog' ),
			'options'     => array(
				'0' => __( 'None', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default'     => '1',
		),
		array(
			'id'          => 'shop_archive_compare',
			'type'        => 'button_set',
			'title'       => __( 'Compare', 'minimog' ),
			'description' => __( 'Turn on to display compare button', 'minimog' ),
			'options'     => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default'     => '1',
		),
		array(
			'id'          => 'shop_archive_wishlist',
			'type'        => 'button_set',
			'title'       => __( 'Wishlist', 'minimog' ),
			'description' => __( 'Turn on to display love button', 'minimog' ),
			'options'     => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default'     => '1',
		),
		array(
			'id'      => 'shop_archive_show_price',
			'type'    => 'button_set',
			'title'   => __( 'Product Price', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_show_price' ),
		),
		array(
			'id'      => 'shop_archive_show_variation',
			'type'    => 'button_set',
			'title'   => __( 'Product Variation', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_show_variation' ),
		),
		array(
			'id'      => 'shop_archive_show_category',
			'type'    => 'button_set',
			'title'   => __( 'Product Category', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_show_category' ),
		),
		array(
			'id'      => 'shop_archive_show_brand',
			'type'    => 'button_set',
			'title'   => __( 'Product Brand', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_show_brand' ),
		),
		array(
			'id'      => 'shop_archive_show_rating',
			'type'    => 'button_set',
			'title'   => __( 'Product Rating', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_show_rating' ),
		),
		array(
			'id'      => 'shop_archive_show_availability',
			'type'    => 'button_set',
			'title'   => __( 'Product Availability', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_show_availability' ),
		),
		array(
			'id'      => 'shop_archive_show_stock_bar',
			'type'    => 'button_set',
			'title'   => __( 'Product Stock Bar', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'shop_archive_show_stock_bar' ),
		),
	),
) );
