<?php
$sidebar_positions   = Minimog_Helper::get_list_sidebar_positions();
$registered_sidebars = Minimog_Redux::instance()->get_registered_widgets_options();

Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => __( 'Single Product', 'minimog' ),
	'id'         => 'single_product',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'     => 'section_start_single_product_header',
			'type'   => 'tm_heading',
			'title'  => __( 'Header Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'product_single_header_type',
			'type'        => 'select',
			'title'       => __( 'Header Style', 'minimog' ),
			'placeholder' => __( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Header::instance()->get_list( true ),
		),
		array(
			'id'          => 'product_single_header_overlay',
			'type'        => 'select',
			'title'       => __( 'Header Overlay', 'minimog' ),
			'placeholder' => __( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Header::instance()->get_overlay_list(),
		),
		array(
			'id'          => 'product_single_header_skin',
			'type'        => 'select',
			'title'       => __( 'Header Skin', 'minimog' ),
			'placeholder' => __( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Header::instance()->get_skin_list(),
		),
		array(
			'id'     => 'section_start_product_single_title_bar',
			'type'   => 'tm_heading',
			'title'  => __( 'Title Bar Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'product_single_title_bar_layout',
			'type'        => 'select',
			'title'       => __( 'Title Bar Style', 'minimog' ),
			'placeholder' => __( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Title_Bar::instance()->get_list( true ),
			'default'     => Minimog_Redux::get_default_setting( 'product_single_title_bar_layout' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'product_single_title_bar_title',
			'title'       => __( 'Heading Text', 'minimog' ),
			'description' => __( 'Leave blank to use post title.', 'minimog' ),
		),
		array(
			'id'     => 'section_start_product_single_sidebar',
			'type'   => 'tm_heading',
			'title'  => __( 'Sidebar Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'product_page_sidebar_1',
			'type'    => 'select',
			'title'   => __( 'Sidebar 1', 'minimog' ),
			'options' => $registered_sidebars,
			'default' => Minimog_Redux::get_default_setting( 'product_page_sidebar_1' ),
		),
		array(
			'id'      => 'product_page_sidebar_2',
			'type'    => 'select',
			'title'   => __( 'Sidebar 2', 'minimog' ),
			'options' => $registered_sidebars,
			'default' => Minimog_Redux::get_default_setting( 'product_page_sidebar_2' ),
		),
		array(
			'id'      => 'product_page_sidebar_position',
			'type'    => 'button_set',
			'title'   => __( 'Sidebar Position', 'minimog' ),
			'options' => $sidebar_positions,
			'default' => Minimog_Redux::get_default_setting( 'product_page_sidebar_position' ),
		),
		array(
			'id'             => 'product_page_single_sidebar_width',
			'type'           => 'dimensions',
			'units'          => array( '%' ),
			'units_extended' => 'false',
			'title'          => __( 'Single Sidebar Width', 'minimog' ),
			'description'    => __( 'Controls the width of the sidebar when only one sidebar is present. Leave blank to use global setting.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'product_page_single_sidebar_width' ),
		),
		array(
			'id'             => 'product_page_single_sidebar_offset',
			'type'           => 'dimensions',
			'units'          => array( 'px' ),
			'units_extended' => 'false',
			'title'          => __( 'Single Sidebar Offset', 'minimog' ),
			'description'    => __( 'Controls the offset of the sidebar when only one sidebar is present. Leave blank to use global setting.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'product_page_single_sidebar_offset' ),
		),
		array(
			'id'      => 'product_page_sidebar_style',
			'type'    => 'select',
			'title'   => __( 'Sidebar Style', 'minimog' ),
			'options' => Minimog_Sidebar::instance()->get_supported_style_options(),
			'default' => Minimog_Redux::get_default_setting( 'product_page_sidebar_style' ),
		),
		array(
			'id'     => 'section_start_product_single_layout',
			'type'   => 'tm_heading',
			'title'  => __( 'Layout Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'single_product_site_layout',
			'type'    => 'select',
			'title'   => __( 'Site Layout', 'minimog' ),
			'options' => Minimog_Site_Layout::instance()->get_container_wide_list(),
			'default' => Minimog_Redux::get_default_setting( 'single_product_site_layout' ),
		),
		array(
			'id'      => 'single_product_summary_layout',
			'type'    => 'select',
			'title'   => __( 'Product Summary Layout', 'minimog' ),
			'options' => Minimog_Site_Layout::instance()->get_container_wide_list(),
			'default' => Minimog_Redux::get_default_setting( 'single_product_summary_layout' ),
		),
		array(
			'id'      => 'single_product_images_style',
			'type'    => 'select',
			'title'   => __( 'Product Images Style', 'minimog' ),
			'options' => [
				'slider'   => __( 'Slider', 'minimog' ),
				'carousel' => __( 'Carousel', 'minimog' ),
				'grid'     => __( 'Grid', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_images_style' ),
		),
		array(
			'id'       => 'single_product_slider_vertical',
			'type'     => 'button_set',
			'title'    => __( 'Vertical Slider', 'minimog' ),
			'options'  => array(
				'0' => __( 'Horizontal', 'minimog' ),
				'1' => __( 'Vertical', 'minimog' ),
			),
			'default'  => Minimog_Redux::get_default_setting( 'single_product_slider_vertical' ),
			'required' => array(
				[ 'single_product_images_style', '=', 'slider' ],
			),
		),
		array(
			'id'       => 'single_product_slider_thumbnails_mobile_disable',
			'type'     => 'button_set',
			'title'    => __( 'Disable Slider Thumbnails On Mobile', 'minimog' ),
			'options'  => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default'  => Minimog_Redux::get_default_setting( 'single_product_slider_thumbnails_mobile_disable' ),
			'required' => array(
				[ 'single_product_images_style', '=', 'slider' ],
			),
		),
		array(
			'id'      => 'single_product_image_grid_to_slider_on_mobile',
			'type'    => 'button_set',
			'title'   => __( 'Grid to Slider On Mobile', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_image_grid_to_slider_on_mobile' ),
		),
		array(
			'id'          => 'single_product_image_grid_alternating',
			'type'        => 'select',
			'title'       => __( 'Grid Alternating?', 'minimog' ),
			'description' => __( 'Even rows has more or less than odd rows 1 column', 'minimog' ),
			'options'     => [
				'0'  => __( 'Disabled', 'minimog' ),
				'1'  => __( 'Normal Alternating', 'minimog' ),
				'-1' => __( 'Reverse Alternating', 'minimog' ),
			],
			'default'     => Minimog_Redux::get_default_setting( 'single_product_image_grid_alternating' ),
			'required'    => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_lg_columns',
			'title'         => __( 'Grid Columns', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_lg_columns' ),
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_lg_gutter',
			'title'         => __( 'Grid Gutter', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_lg_gutter' ),
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_md_columns',
			'title'         => __( 'Grid Columns (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_md_columns' ),
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_md_gutter',
			'title'         => __( 'Grid Gutter (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_md_gutter' ),
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_sm_columns',
			'title'         => __( 'Grid Columns (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_sm_columns' ),
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_sm_gutter',
			'title'         => __( 'Grid Gutter (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_sm_gutter' ),
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'      => 'single_product_images_wide',
			'type'    => 'select',
			'title'   => __( 'Product Images Wide', 'minimog' ),
			'options' => [
				'narrow'   => __( 'Narrow', 'minimog' ),
				'normal'   => __( 'Normal', 'minimog' ),
				'extended' => __( 'Extended', 'minimog' ),
				'wide'     => __( 'Wide', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_images_wide' ),
		),
		array(
			'id'      => 'single_product_images_offset',
			'type'    => 'select',
			'title'   => __( 'Product Images Offset', 'minimog' ),
			'options' => [
				'0'  => __( 'No Offset', 'minimog' ),
				'20' => sprintf( __( 'Offset %s', 'minimog' ), '20px' ),
				'30' => sprintf( __( 'Offset %s', 'minimog' ), '30px' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_images_offset' ),
		),
		array(
			'id'      => 'single_product_summary_offset',
			'type'    => 'select',
			'title'   => __( 'Product Summary Offset', 'minimog' ),
			'options' => [
				'0'  => __( 'No Offset', 'minimog' ),
				'20' => sprintf( __( 'Offset %s', 'minimog' ), '20px' ),
				'30' => sprintf( __( 'Offset %s', 'minimog' ), '30px' ),
				'40' => sprintf( __( 'Offset %s', 'minimog' ), '40px' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_summary_offset' ),
		),
		array(
			'id'      => 'single_product_sticky_enable',
			'type'    => 'button_set',
			'title'   => __( 'Sticky Images & Summary', 'minimog' ),
			'options' => array(
				'0' => __( 'None', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_sticky_enable' ),
		),
		array(
			'id'     => 'section_start_single_product_buy_now',
			'type'   => 'tm_heading',
			'title'  => __( 'Buy Now Button', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'single_product_buy_now_enable',
			'type'    => 'button_set',
			'title'   => __( 'Visibility', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_buy_now_enable' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'single_product_buy_now_text',
			'title'       => __( 'Button Text', 'minimog' ),
			'description' => __( 'Leave blank to use default.', 'minimog' ),
		),
		array(
			'id'     => 'section_start_single_product_trust_badge',
			'type'   => 'tm_heading',
			'title'  => __( 'Trust Badge', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'single_product_trust_badge_enable',
			'type'        => 'button_set',
			'title'       => __( 'Visibility', 'minimog' ),
			'description' => __( 'Turn on to display the trust badge below Add to cart button.', 'minimog' ),
			'options'     => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'single_product_trust_badge_enable' ),
		),
		array(
			'id'      => 'single_product_trust_badge_image',
			'type'    => 'media',
			'title'   => __( 'Image', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'single_product_trust_badge_image' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'single_product_trust_badge_text',
			'title'       => __( 'Text', 'minimog' ),
			'description' => __( 'Leave blank to use default.', 'minimog' ),
		),
		array(
			'id'     => 'section_start_product_single_other_settings',
			'type'   => 'tm_heading',
			'title'  => __( 'Other Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'single_product_sticky_bar_enable',
			'type'        => 'button_set',
			'title'       => __( 'Sticky Product', 'minimog' ),
			'description' => __( 'Turn on to show product sticky bar when scroll down.', 'minimog' ),
			'options'     => array(
				'0' => __( 'None', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'single_product_sticky_bar_enable' ),
		),
		array(
			'id'      => 'single_product_tabs_style',
			'type'    => 'button_set',
			'title'   => __( 'Product Tabs Style', 'minimog' ),
			'options' => array(
				'tabs'    => __( 'Tabs', 'minimog' ),
				'toggles' => __( 'Toggles', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_tabs_style' ),
		),
		array(
			'id'      => 'single_product_review_style',
			'type'    => 'select',
			'title'   => __( 'Product Reviews Style', 'minimog' ),
			'options' => [
				'01' => '01',
				'02' => '02',
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_review_style' ),
		),
		array(
			'id'      => 'product_content_position',
			'type'    => 'button_set',
			'title'   => __( 'Product Content Position', 'minimog' ),
			'options' => array(
				''              => __( 'In Product Data Tabs/Toggles', 'minimog' ),
				'below_summary' => __( 'Below Product Summary', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'product_content_position' ),
		),
		array(
			'id'      => 'single_product_short_description_enable',
			'type'    => 'button_set',
			'title'   => __( 'Short Description', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_short_description_enable' ),
		),
		array(
			'id'          => 'single_product_total_sales_enable',
			'type'        => 'button_set',
			'title'       => __( 'Total Sales', 'minimog' ),
			'description' => __( 'Turn on to show product total sales.', 'minimog' ),
			'options'     => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'single_product_total_sales_enable' ),
		),
		array(
			'id'      => 'single_product_low_stock_enable',
			'type'    => 'button_set',
			'title'   => __( 'Low stock bar', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_low_stock_enable' ),
		),
		array(
			'id'      => 'single_product_live_view_visitors_enable',
			'type'    => 'button_set',
			'title'   => __( 'Live view Visitors', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_live_view_visitors_enable' ),
		),
		array(
			'id'            => 'single_product_live_view_visitors_range',
			'type'          => 'slider',
			'title'         => __( 'Live View Visitors Range', 'minimog' ),
			'default'       => Minimog_Redux::get_default_setting( 'single_product_live_view_visitors_range' ),
			'min'           => 1,
			'step'          => 1,
			'max'           => 1000,
			'display_value' => 'text',
			'handles'       => 2,
		),
		array(
			'id'      => 'single_product_shipping_class_enable',
			'type'    => 'button_set',
			'title'   => __( 'Shipping Class Info', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_shipping_class_enable' ),
		),
		array(
			'id'      => 'single_product_shipping_estimated_enable',
			'type'    => 'button_set',
			'title'   => __( 'Shipping Estimated Info', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_shipping_estimated_enable' ),
		),
		array(
			'id'      => 'single_product_shipping_n_returns_enable',
			'type'    => 'button_set',
			'title'   => __( 'Free Shipping & Returns Info', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_shipping_n_returns_enable' ),
		),
		array(
			'id'      => 'single_product_meta_enable',
			'type'    => 'button_set',
			'title'   => __( 'Product Meta', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_meta_enable' ),
		),
		array(
			'id'      => 'single_product_categories_enable',
			'type'    => 'button_set',
			'title'   => __( 'Categories', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_categories_enable' ),
		),
		array(
			'id'      => 'single_product_tags_enable',
			'type'    => 'button_set',
			'title'   => __( 'Tags', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_tags_enable' ),
		),
		array(
			'id'          => 'single_product_brands_tab_enable',
			'type'        => 'button_set',
			'title'       => __( 'Brands Tab', 'minimog' ),
			'description' => __( 'Show product brand in tab', 'minimog' ),
			'options'     => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'single_product_brands_tab_enable' ),
		),
		array(
			'id'      => 'single_product_compare_enable',
			'type'    => 'button_set',
			'title'   => __( 'Compare Link', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_compare_enable' ),
		),
		array(
			'id'      => 'single_product_sharing_enable',
			'type'    => 'button_set',
			'title'   => __( 'Sharing', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_sharing_enable' ),
		),
		array(
			'id'     => 'section_start_single_product_product_loop',
			'type'   => 'tm_heading',
			'title'  => __( 'Product Loop', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'single_product_up_sells_enable',
			'type'    => 'button_set',
			'title'   => __( 'Up-sells Products', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_up_sells_enable' ),
		),
		array(
			'id'       => 'single_product_up_sells_position',
			'type'     => 'select',
			'title'    => __( 'Up-sells Products Position', 'minimog' ),
			'options'  => [
				'in_linked_product_tabs' => __( 'In Linked Product Tabs', 'minimog' ),
				'below_product_tabs'     => __( 'Below Product Tabs', 'minimog' ),
				'below_product_images'   => __( 'Below Product Images', 'minimog' ),
				'below_product_summary'  => __( 'Below Product Summary', 'minimog' ),
				'below_product_details'  => __( 'Below Product Details', 'minimog' ),
			],
			'default'  => Minimog_Redux::get_default_setting( 'single_product_up_sells_position' ),
			'required' => array(
				[ 'single_product_up_sells_enable', '=', '1' ],
			),
		),
		array(
			'id'      => 'single_product_related_enable',
			'type'    => 'button_set',
			'title'   => __( 'Related products', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_related_enable' ),
		),
		array(
			'id'       => 'single_product_related_position',
			'type'     => 'select',
			'title'    => __( 'Related Products Position', 'minimog' ),
			'options'  => [
				'below_product_tabs'     => __( 'Below Product Tabs', 'minimog' ),
				'in_linked_product_tabs' => __( 'In Linked Product Tabs', 'minimog' ),
				'below_product_summary'  => __( 'Below Product Summary', 'minimog' ),
			],
			'default'  => Minimog_Redux::get_default_setting( 'single_product_related_position' ),
			'required' => array(
				[ 'single_product_related_enable', '=', '1' ],
			),
		),
		array(
			'id'            => 'product_related_number',
			'title'         => __( 'Number related products', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'product_related_number' ),
			'min'           => 1,
			'max'           => 30,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_related_enable', '=', '1' ],
			),
		),
		array(
			'id'      => 'single_product_recent_viewed_enable',
			'type'    => 'button_set',
			'title'   => __( 'Recent viewed products', 'minimog' ),
			'options' => array(
				'0' => __( 'Hide', 'minimog' ),
				'1' => __( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_recent_viewed_enable' ),
		),
		array(
			'id'       => 'single_product_recent_viewed_position',
			'type'     => 'select',
			'title'    => __( 'Recent Viewed Products Position', 'minimog' ),
			'options'  => [
				'in_linked_product_tabs' => __( 'In Linked Product Tabs', 'minimog' ),
				'below_product_tabs'     => __( 'Below Product Tabs', 'minimog' ),
			],
			'default'  => Minimog_Redux::get_default_setting( 'single_product_recent_viewed_position' ),
			'required' => array(
				[ 'single_product_recent_viewed_enable', '=', '1' ],
			),
		),
		array(
			'id'            => 'recent_viewed_products_per_page',
			'title'         => __( 'Number recent viewed products', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'recent_viewed_products_per_page' ),
			'min'           => 1,
			'max'           => 30,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_recent_viewed_enable', '=', '1' ],
			),
		),
		array(
			'id'      => 'single_product_loop_style',
			'type'    => 'select',
			'title'   => __( 'Product Loop Style', 'minimog' ),
			'options' => Minimog_Woo::instance()->get_shop_loop_carousel_style_options(),
			'default' => Minimog_Redux::get_default_setting( 'single_product_loop_style' ),
		),
		array(
			'id'      => 'single_product_loop_caption_style',
			'type'    => 'select',
			'title'   => __( 'Caption Style', 'minimog' ),
			'options' => Minimog_Woo::instance()->get_shop_loop_caption_style_options(),
			'default' => Minimog_Redux::get_default_setting( 'single_product_loop_caption_style' ),
		),
		array(
			'id'            => 'single_product_loop_lg_columns',
			'title'         => __( 'Grid Columns', 'minimog' ),
			'type'          => 'slider',
			'default'       => 4,
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_lg_gutter',
			'title'         => __( 'Grid Gutter', 'minimog' ),
			'type'          => 'slider',
			'default'       => 30,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_md_columns',
			'title'         => __( 'Grid Columns (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 3,
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_md_gutter',
			'title'         => __( 'Grid Gutter (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 20,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_sm_columns',
			'title'         => __( 'Grid Columns (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 2,
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_sm_gutter',
			'title'         => __( 'Grid Gutter (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 16,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
	),
) );
