<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.7.0
 */

use Automattic\WooCommerce\Enums\ProductType;

defined( 'ABSPATH' ) || exit;

global $product;
$sku = $product->get_sku();
?>
<div class="entry-product-meta product_meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>

	<?php if ( wc_product_sku_enabled() && ( $sku || $product->is_type( ProductType::VARIABLE ) ) ) : ?>
		<div class="sku_wrapper meta-item">
			<label class="meta-label"><?php esc_html_e( 'Sku:', 'minimog' ); ?></label>
			<div class="meta-content">
				<span class="sku">
					<?php echo ! empty( $sku ) ? $sku : esc_html__( 'N/A', 'minimog' ); ?>
				</span>
			</div>
		</div>
	<?php endif; ?>

	<?php if ( '1' === Minimog::setting( 'single_product_categories_enable' ) ) : ?>
		<?php echo wc_get_product_category_list( $product->get_id(), ', ', '<div class="entry-product-categories meta-item"><label class="meta-label">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'minimog' ) . '</label><div class="meta-content">', '</div></div>' ); ?>
	<?php endif; ?>

	<?php if ( '1' === Minimog::setting( 'single_product_tags_enable' ) ) : ?>
		<?php echo wc_get_product_tag_list( $product->get_id(), ', ', '<div class="tagged_as meta-item"><label class="meta-label">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'minimog' ) . '</label><div class="meta-content">', '</div></div>' ); ?>
	<?php endif; ?>

	<?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>
