<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => __( 'General', 'minimog' ),
	'id'         => 'header_general',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'     => 'header_general_settings',
			'type'   => 'tm_heading',
			'title'  => __( 'General', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'global_header',
			'type'    => 'select',
			'title'   => __( 'Global Header Style', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'global_header' ),
			'options' => Minimog_Header::instance()->get_list(),
		),
		array(
			'id'      => 'global_header_overlay',
			'type'    => 'button_set',
			'title'   => __( 'Global Header Overlay', 'minimog' ),
			'options' => array(
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'global_header_overlay' ),
		),
		array(
			'id'      => 'global_header_skin',
			'type'    => 'button_set',
			'title'   => __( 'Global Header Skin', 'minimog' ),
			'options' => array(
				'dark'  => __( 'Dark', 'minimog' ),
				'light' => __( 'Light', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'global_header_skin' ),
		),
		array(
			'id'      => 'header_text',
			'type'    => 'textarea',
			'title'   => __( 'Text', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'header_text' ),
		),
		array(
			'id'      => 'header_info_list_secondary_style',
			'type'    => 'button_set',
			'title'   => __( 'Info List Style (Secondary)', 'minimog' ),
			'options' => array(
				''   => sprintf( __( 'Style %s', 'minimog' ), '01' ),
				'02' => sprintf( __( 'Style %s', 'minimog' ), '02' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'header_info_list_secondary_style' ),
		),
		array(
			'id'           => 'header_info_list_secondary',
			'type'         => 'repeater',
			'title'        => __( 'Info List (Secondary)', 'minimog' ),
			'item_name'    => __( 'Item', 'minimog' ),
			'bind_title'   => 'text',
			'group_values' => true,
			'fields'       => array(
				array(
					'id'    => 'text',
					'type'  => 'textarea',
					'title' => __( 'Title', 'minimog' ),
				),
				array(
					'id'    => 'sub_title',
					'type'  => 'text',
					'title' => __( 'Sub title', 'minimog' ),
				),
				array(
					'id'    => 'url',
					'type'  => 'text',
					'title' => __( 'Link Url', 'minimog' ),
				),
				array(
					'id'          => 'icon_class',
					'title'       => __( 'Icon CSS class', 'minimog' ),
					'description' => 'Input valid font-icon CSS classes. Leave it blank if to use below image/svg below.',
					'type'        => 'text',
				),
				array(
					'id'          => 'icon',
					'title'       => 'Icon',
					'type'        => 'media',
					'description' => 'Select an image or a svg file.',
					'compiler'    => 'true',
					'mode'        => false,
				),
				array(
					'id'          => 'item_class',
					'title'       => __( 'Item CSS class', 'minimog' ),
					'description' => 'Add custom CSS class to the item',
					'type'        => 'text',
				),
			),
			'default'      => [
				'Redux_repeater_data' => [
					[
						'title' => '',
					],
				],
				'text'                => [
					'Find a Store',
				],
				'sub_title'           => [
					'',
				],
				'url'                 => [
					'#',
				],
				'icon_class'          => [
					'fas fa-map-marker-alt',
				],
				'icon'                => [
					[
						'id'  => '',
						'url' => '',
					],
				],
				'item_class'          => [
					'',
				],
			],
		),
		array(
			'id'    => 'header_button_text',
			'type'  => 'text',
			'title' => __( 'Button Text', 'minimog' ),
		),
		array(
			'id'    => 'header_button_link',
			'type'  => 'text',
			'title' => __( 'Button Link', 'minimog' ),
		),
		array(
			'id'    => 'header_button_link_rel',
			'type'  => 'text',
			'title' => __( 'Button Link Relationship (XFN)', 'minimog' ),
		),
		array(
			'id'      => 'header_button_link_target',
			'type'    => 'button_set',
			'title'   => __( 'Open link in a new tab.', 'minimog' ),
			'options' => [
				'0' => __( 'No', 'minimog' ),
				'1' => __( 'Yes', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_button_link_target' ),
		),
		array(
			'id'      => 'header_button_style',
			'type'    => 'select',
			'title'   => __( 'Button Style', 'minimog' ),
			'options' => Minimog_Header::instance()->get_button_style(),
			'default' => Minimog_Redux::get_default_setting( 'header_button_style' ),
		),
		array(
			'id'             => 'header_height',
			'type'           => 'dimensions',
			'units'          => array( 'px', ),
			'units_extended' => false,
			'title'          => __( 'Header Min Height', 'minimog' ),
			'subtitle'       => __( 'Control min height of header in desktop device.', 'minimog' ),
			'width'          => false,
		),
		array(
			'id'                => 'header_style_navigation_typography',
			'type'              => 'typography',
			'title'             => __( 'Navigation Typography', 'minimog' ),
			'google'            => true,
			'font_family_clear' => true,
			'default'           => Minimog_Redux::get_default_setting( 'header_style_navigation_typography' ),
			'letter-spacing'    => true,
			'text-transform'    => true,
			'text-align'        => false,
			'preview'           => false,
			'color'             => false,
			'weights'           => Minimog_Redux::get_all_font_variants(),
		),
		array(
			'id'      => 'header_icons_style',
			'type'    => 'select',
			'title'   => __( 'Icon Style', 'minimog' ),
			'options' => [
				'text'        => __( 'Text', 'minimog' ),
				'icon-set-01' => sprintf( __( 'Icon set %s', 'minimog' ), '01' ),
				'icon-set-02' => sprintf( __( 'Icon set %s', 'minimog' ), '02' ),
				'icon-set-03' => sprintf( __( 'Icon set %s', 'minimog' ), '03' ),
				'icon-set-04' => sprintf( __( 'Icon set %s', 'minimog' ), '04' ),
				'icon-set-05' => sprintf( __( 'Icon set %s', 'minimog' ), '05' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_icons_style' ),
		),
		array(
			'id'      => 'header_icons_display',
			'type'    => 'button_set',
			'title'   => 'Icon Display',
			'options' => array(
				'icon' => 'Icon',
				'text' => 'Text on desktop',
			),
			'default' => Minimog_Redux::get_default_setting( 'header_icons_display' ),
		),
		array(
			'id'      => 'header_cart_icon_style',
			'type'    => 'select',
			'title'   => __( 'Mini Cart Icon', 'minimog' ),
			'options' => [
				'text'                 => __( 'Text', 'minimog' ),
				'icon-set-01'          => sprintf( __( 'Icon set %s', 'minimog' ), '01' ),
				'icon-set-02'          => sprintf( __( 'Icon set %s', 'minimog' ), '02' ),
				'icon-set-03'          => sprintf( __( 'Icon set %s', 'minimog' ), '03' ),
				'icon-set-04'          => sprintf( __( 'Icon set %s', 'minimog' ), '04' ),
				'icon-set-05'          => sprintf( __( 'Icon set %s', 'minimog' ), '05' ),
				'icon-circle-price-01' => __( 'Icon Circle - Price - 01', 'minimog' ),
				'icon-circle-price-02' => __( 'Icon Circle - Price - 02', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_cart_icon_style' ),
		),
		array(
			'id'      => 'header_cart_icon_display',
			'type'    => 'button_set',
			'title'   => 'Mini Cart Icon Display',
			'options' => array(
				'icon' => 'Icon',
				'text' => 'Text on desktop',
			),
			'default' => Minimog_Redux::get_default_setting( 'header_cart_icon_display' ),
		),
		array(
			'id'      => 'header_wishlist_icon_type',
			'type'    => 'button_set',
			'title'   => __( 'Wishlist Icon', 'minimog' ),
			'options' => [
				'star'  => __( 'Star', 'minimog' ),
				'heart' => __( 'Heart', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_wishlist_icon_type' ),
		),
		array(
			'id'      => 'header_icons_badge_size',
			'type'    => 'select',
			'title'   => __( 'Icon Badge Size', 'minimog' ),
			'options' => [
				'normal' => __( 'Normal', 'minimog' ),
				'large'  => __( 'Large', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_icons_badge_size' ),
		),
		array(
			'id'      => 'header_navigation_item_hover_style',
			'type'    => 'select',
			'title'   => __( 'Nav Item Hover Style', 'minimog' ),
			'options' => [
				''          => __( 'None', 'minimog' ),
				'thin-line' => __( 'Thin Underline', 'minimog' ),
				'line'      => __( 'Thick Underline', 'minimog' ),
				'wave'      => __( 'Wave', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_navigation_item_hover_style' ),
		),
		array(
			'id'      => 'header_search_form_style',
			'type'    => 'select',
			'title'   => __( 'Search Form Style', 'minimog' ),
			'options' => [
				'normal'                 => __( 'Default', 'minimog' ),
				'button-fill'            => __( 'Submit Button Fill', 'minimog' ),
				'thick-bottom-line'      => __( 'Thick Bottom Line', 'minimog' ),
				'thick-border'           => __( 'Thick Border', 'minimog' ),
				'thick-border-with-text' => __( 'Thick Border With Text', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_search_form_style' ),
		),

		array(
			'id'     => 'section_start_header_dark_skin',
			'type'   => 'tm_heading',
			'title'  => __( 'Header Dark Version', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'header_style_dark_background',
			'title'   => __( 'Background', 'minimog' ),
			'type'    => 'background',
			'default' => array(
				'background-color' => '#fff',
			),
		),
		array(
			'id'       => 'header_style_dark_box_shadow',
			'type'     => 'box_shadow',
			'title'    => __( 'Box Shadow', 'minimog' ),
			'subtitle' => __( 'Input box shadow for header', 'minimog' ),
			'class'    => 'field-header-shadow',
			'default'  => [
				'inset'        => false,
				'drop'         => true,
				'inset-shadow' => array(
					'checked'    => false,
					'color'      => '#ABABAB',
					'horizontal' => 0,
					'vertical'   => 0,
					'blur'       => 10,
					'spread'     => 0,
				),
				'drop-shadow'  => array(
					'checked'    => false,
					'color'      => 'rgba(0, 0, 0, 0.03)',
					'horizontal' => 0,
					'vertical'   => 4,
					'blur'       => 4,
					'spread'     => 0,
				),
			],
		),
		array(
			'id'          => 'header_style_dark_text_color',
			'type'        => 'color',
			'title'       => __( 'Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_link_color',
			'type'        => 'color',
			'title'       => __( 'Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_link_hover_color',
			'type'        => 'color',
			'title'       => __( 'Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_nav_link_color',
			'type'        => 'color',
			'title'       => __( 'Nav Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_nav_link_hover_color',
			'type'        => 'color',
			'title'       => __( 'Nav Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_nav_line_color',
			'type'        => 'color',
			'title'       => __( 'Nav Line Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_icon_color',
			'type'        => 'color',
			'title'       => __( 'Icon Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_icon_hover_color',
			'type'        => 'color',
			'title'       => __( 'Icon Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_icon_badge_text_color',
			'type'        => 'color',
			'title'       => __( 'Icon Badge Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_icon_badge_background_color',
			'type'        => 'color',
			'title'       => __( 'Icon Badge Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_tag_text_color',
			'type'        => 'color',
			'title'       => __( 'Tag Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_tag_bg_color',
			'type'        => 'color',
			'title'       => __( 'Tag Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_form_text_color',
			'type'        => 'color',
			'title'       => __( 'Form Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_form_background_color',
			'type'        => 'color',
			'title'       => __( 'Form Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_form_border_color',
			'type'        => 'color',
			'title'       => __( 'Form Border Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_form_submit_text_color',
			'type'        => 'color',
			'title'       => __( 'Form Submit Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'    => 'header_above_style_dark_background',
			'title' => __( 'Header Above Background', 'minimog' ),
			'type'  => 'background',
		),
		array(
			'id'          => 'header_above_style_dark_border_color',
			'type'        => 'color',
			'title'       => __( 'Header Above Border Bottom Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_above_style_dark_item_separator_color',
			'type'        => 'color',
			'title'       => __( 'Header Above Item Separator Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_above_style_dark_text_color',
			'type'        => 'color',
			'title'       => __( 'Header Above Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_above_style_dark_link_color',
			'type'        => 'color',
			'title'       => __( 'Header Above Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_above_style_dark_link_hover_color',
			'type'        => 'color',
			'title'       => __( 'Header Above Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'    => 'header_below_style_dark_border',
			'type'  => 'border',
			'title' => __( 'Header Below Border', 'minimog' ),
		),
		array(
			'id'    => 'header_below_style_dark_inner_border',
			'type'  => 'border',
			'title' => __( 'Header Below Inner Border', 'minimog' ),
		),

		// Light Version.
		array(
			'id'     => 'section_start_header_01_light_skin',
			'type'   => 'tm_heading',
			'title'  => __( 'Header Light Version', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'    => 'header_style_light_background',
			'title' => __( 'Background', 'minimog' ),
			'type'  => 'background',
		),
		array(
			'id'       => 'header_style_light_box_shadow',
			'type'     => 'box_shadow',
			'title'    => __( 'Box Shadow', 'minimog' ),
			'subtitle' => __( 'Input box shadow for header', 'minimog' ),
			'class'    => 'field-header-shadow',
			'default'  => [
				'inset'        => false,
				'drop'         => false,
				'inset-shadow' => array(
					'checked'    => false,
					'color'      => '#ABABAB',
					'horizontal' => 0,
					'vertical'   => 0,
					'blur'       => 10,
					'spread'     => 0,
				),
				'drop-shadow'  => array(
					'checked'    => false,
					'color'      => 'rgba(0, 0, 0, 0.03)',
					'horizontal' => 0,
					'vertical'   => 4,
					'blur'       => 4,
					'spread'     => 0,
				),
			],
		),
		array(
			'id'          => 'header_style_light_text_color',
			'type'        => 'color',
			'title'       => __( 'Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_link_color',
			'type'        => 'color',
			'title'       => __( 'Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_link_hover_color',
			'type'        => 'color',
			'title'       => __( 'Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_nav_link_color',
			'type'        => 'color',
			'title'       => __( 'Nav Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_nav_link_hover_color',
			'type'        => 'color',
			'title'       => __( 'Nav Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_nav_line_color',
			'type'        => 'color',
			'title'       => __( 'Nav Line Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_icon_color',
			'type'        => 'color',
			'title'       => __( 'Icon Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_icon_hover_color',
			'type'        => 'color',
			'title'       => __( 'Icon Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_icon_badge_text_color',
			'type'        => 'color',
			'title'       => __( 'Icon Badge Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_icon_badge_background_color',
			'type'        => 'color',
			'title'       => __( 'Icon Badge Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_tag_text_color',
			'type'        => 'color',
			'title'       => __( 'Tag Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_tag_bg_color',
			'type'        => 'color',
			'title'       => __( 'Tag Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_form_text_color',
			'type'        => 'color',
			'title'       => __( 'Form Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_form_background_color',
			'type'        => 'color',
			'title'       => __( 'Form Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_form_border_color',
			'type'        => 'color',
			'title'       => __( 'Form Border Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_form_submit_text_color',
			'type'        => 'color',
			'title'       => __( 'Form Submit Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'    => 'header_below_style_light_border',
			'type'  => 'border',
			'title' => __( 'Header Below Border', 'minimog' ),
		),
		array(
			'id'    => 'header_below_style_light_inner_border',
			'type'  => 'border',
			'title' => __( 'Header Below Inner Border', 'minimog' ),
		),
	),
) );
