<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => sprintf( __( 'Minimal %s', 'minimog' ), '01' ),
	'id'         => 'title_bar_minimal_01',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'             => 'title_bar_minimal_01_margin',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( 'em', 'px', '%' ),
			'units_extended' => true,
			'title'          => __( 'Margin', 'minimog' ),
			'top'            => false,
			'left'           => false,
			'right'          => false,
			'default'        => Minimog_Redux::get_default_setting( 'title_bar_minimal_01_margin' ),
		),
		array(
			'id'             => 'title_bar_minimal_01_breadcrumb_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => 'px',
			'units_extended' => false,
			'title'          => __( 'Breadcrumb Padding', 'minimog' ),
			'left'           => false,
			'right'          => false,
		),
		array(
			'id'             => 'title_bar_minimal_01_breadcrumb_min_height',
			'type'           => 'dimensions',
			'units'          => 'px',
			'units_extended' => false,
			'title'          => __( 'Breadcrumb Min Height', 'minimog' ),
			'width'          => false,
			'default'        => Minimog_Redux::get_default_setting( 'title_bar_minimal_01_breadcrumb_min_height' ),
		),
		array(
			'id'      => 'title_bar_minimal_01_text_align',
			'type'    => 'select',
			'title'   => __( 'Text Align', 'minimog' ),
			'options' => [
				'flex-start' => __( 'Left', 'minimog' ),
				'center'     => __( 'Center', 'minimog' ),
				'flex-end'   => __( 'Right', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'title_bar_minimal_01_text_align' ),
		),
		array(
			'id'          => 'title_bar_minimal_01_breadcrumb_text_color',
			'type'        => 'color',
			'title'       => __( 'Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'title_bar_minimal_01_breadcrumb_link_color',
			'type'        => 'color',
			'title'       => __( 'Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'title_bar_minimal_01_breadcrumb_link_hover_color',
			'type'        => 'color',
			'title'       => __( 'Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'title_bar_minimal_01_breadcrumb_separator_color',
			'type'        => 'color',
			'title'       => __( 'Separator Color', 'minimog' ),
			'color_alpha' => true,
		),
	),
) );
