class VamtamPostComments extends elementorModules.frontend.handlers.Base {

	onInit( ...args ) {
		super.onInit( ...args );

		this.checkHandleBtnUnderlineAnimation();
	}

	checkHandleBtnUnderlineAnimation() {
		const isEditor = jQuery( 'body' ).hasClass( 'elementor-editor-active' );

		if ( isEditor ) {
			// Editor.
			setTimeout( () => {
				this.handleBtnUnderlineAnimation();
			}, 2000 );
		} else {
			// Frontend.
			if ( document.readyState == 'complete' ) {
				// Forms that are added later in the page (popups).
				setTimeout(() => {
					this.handleBtnUnderlineAnimation();
				}, 25 );
			} else {
				// Page load (forms that are already on page).
				// load event cause form buttons are injected by js.
				jQuery( window ).on( 'load', () => {
					this.handleBtnUnderlineAnimation();
				} );
			}
		}
	}

	handleBtnUnderlineAnimation() {
		if ( ! this.$element.is( '[data-widget_type="post-comments.theme_comments"]' ) ) {
			return;
		}

		// Submit btn.
		const $submitInput = this.$element.find( '#submit' );

		// Submit btn.
		// We hide (from css) the submit input and create a submit button that can support the hover animation.
		if ( $submitInput.length ) {
			const submitText = $submitInput.val();

			const $submitBtn = jQuery( `
				<button class="elementor-button elementor-size-sm" type="submit">
					<span class="elementor-button-content-wrapper">
						<span class="vamtam-btn-text-wrap">
							<span class="elementor-button-text vamtam-btn-text">${submitText}</span>
						</span>
					</span>
				</button>
			` );

			$submitBtn.insertAfter( $submitInput );
		}

		// Add class on hover to trigger the animation.
		jQuery( this.$element ).on( 'mouseenter', 'a.comment-reply-link, .elementor-button[type="submit"]', ( e ) => {
			const $el = jQuery( e.target );
			if ( $el.hasClass( 'hovered' ) ) {
				return;
			}

			$el.addClass( 'hovered' );

			// This timeout is used as a guard to avoid flickering caused by very fast chnages of hover state.
			setTimeout(() => {
				$el.removeClass( 'hovered' );
			}, 600 );
		} );
	}
}


jQuery( window ).on( 'elementor/frontend/init', () => {
	if ( !elementorFrontend.elementsHandler || !elementorFrontend.elementsHandler.attachHandler ) {
		const addHandler = ( $element ) => {
			elementorFrontend.elementsHandler.addHandler( VamtamPostComments, {
				$element,
			} );
		};

		elementorFrontend.hooks.addAction( 'frontend/element_ready/post-comments.theme_comments', addHandler, 100 );
	} else {
		elementorFrontend.elementsHandler.attachHandler( 'post-comments', VamtamPostComments, 'theme_comments' );
	}
} );
