<?php
namespace VamtamElementor\Widgets\NavMenu;

use \ElementorPro\Modules\NavMenu\Widgets\Nav_Menu as Elementor_Nav_Menu;

// Extending the Nav Menu widget.

// Is Pro Widget.
if ( ! \VamtamElementorIntregration::is_elementor_pro_active() ) {
	return;
}

// Theme preferences.
if ( ! \Vamtam_Elementor_Utils::is_widget_mod_active( 'nav-menu' ) ) {
	return;
}

if ( vamtam_theme_supports( 'nav-menu--underline-anim' ) ) {
	function add_underline_anim_controls( $controls_manager, $widget ) {
		$global_default = \Vamtam_Elementor_Utils::get_theme_global_widget_option( 'underline_anim_default' );

		// Pointer.
		\Vamtam_Elementor_Utils::add_control_options( $controls_manager, $widget, 'pointer', [
			'options' => [
				'theme-underline' => __( 'Underline (Theme)', 'vamtam-elementor-integration' ),
			],
		] );

		if ( ! empty( $global_default ) ) {
			\Vamtam_Elementor_Utils::replace_control_options( $controls_manager, $widget, 'pointer', [
				'default' => 'theme-underline',
			] );
		}

		$widget->start_injection( [
			'of' => 'pointer',
		] );
		// Underline Width
		$widget->add_control(
			'vamtam_underline_width',
			[
				'label' => __( 'Underline Width', 'vamtam-elementor-integration' ),
				'type' => $controls_manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 10,
						'min' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} a.elementor-item' => '--vamtam-underline-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'pointer' => 'theme-underline',
				]
			]
		);
		// Underline Spacing
		$widget->add_control(
			'vamtam_underline_spacing',
			[
				'label' => __( 'Underline Spacing', 'vamtam-elementor-integration' ),
				'type' => $controls_manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
						'min' => 0,
					],
				],
				'selectors' => [
					'{{WRAPPER}} a.elementor-item' => '--vamtam-underline-spacing: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'pointer' => 'theme-underline',
				]
			]
		);
		$widget->end_injection();
	}

	function update_controls_style_tab_main_section( $controls_manager, $widget ) {
		// Menu item pointer hover color.
		\Vamtam_Elementor_Utils::add_control_options( $controls_manager, $widget, 'pointer_color_menu_item_hover', [
			'selectors' => [
				'{{WRAPPER}}' => '--vamtam-pointer-color-hover: {{VALUE}}',
			],
		] );

		// Menu item pointer active color.
		\Vamtam_Elementor_Utils::add_control_options( $controls_manager, $widget, 'pointer_color_menu_item_active', [
			'selectors' => [
				'{{WRAPPER}}' => '--vamtam-pointer-color-active: {{VALUE}}',
			],
		] );
	}

	// Style - Main Menu section
	function section_style_main_menu_before_section_end( $widget, $args ) {
		$controls_manager = \Elementor\Plugin::instance()->controls_manager;
		update_controls_style_tab_main_section( $controls_manager, $widget );
	}
	add_action( 'elementor/element/nav-menu/section_style_main-menu/before_section_end', __NAMESPACE__ . '\section_style_main_menu_before_section_end', 10, 2 );

	// Content - Layout section
	function section_layout_before_section_end( $widget, $args ) {
		$controls_manager = \Elementor\Plugin::instance()->controls_manager;
		add_underline_anim_controls( $controls_manager, $widget );
	}
	add_action( 'elementor/element/nav-menu/section_layout/before_section_end', __NAMESPACE__ . '\section_layout_before_section_end', 10, 2 );

	// Vamtam_Widget_Nav_Menu.
	function widgets_registered() {
		class Vamtam_Widget_Nav_Menu extends \ElementorPro\Modules\NavMenu\Widgets\Nav_Menu {
			public $extra_depended_scripts = [
				'vamtam-nav-menu',
			];

			// Extend constructor.
			public function __construct($data = [], $args = null) {
				parent::__construct($data, $args);

				$this->register_assets();

				$this->add_extra_script_depends();
			}

			// Register the assets the widget depends on.
			public function register_assets() {
				$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

				wp_register_script(
					'vamtam-nav-menu',
					VAMTAM_ELEMENTOR_INT_URL . 'assets/js/widgets/nav-menu/vamtam-nav-menu' . $suffix . '.js',
					[
						'elementor-frontend'
					],
					\VamtamElementorIntregration::PLUGIN_VERSION,
					true
				);
			}

			// Assets the widget depends upon.
			public function add_extra_script_depends() {
				// Scripts
				foreach ( $this->extra_depended_scripts as $script ) {
					$this->add_script_depends( $script );
				}
			}

			/*
				We override the get_script_depends method directly because Elementor's
				Nav_Menu class returns the array directly, like so:

					public function get_script_depends() {
						return [ 'smartmenus' ];
					}

				If this changes, we should update this and probably filter the script in the
				add_extra_script_depends method.
			*/
			public function get_script_depends() {
				$script_depends = [
					'smartmenus',
				];

				// Add our handler.
				$script_depends[] = 'vamtam-nav-menu';

				return $script_depends;
			}
		}

		// Replace current nav-menu widget with our extended version.
		$widgets_manager = \Elementor\Plugin::instance()->widgets_manager;
		$widgets_manager->unregister( 'nav-menu' );
		$widgets_manager->register( new Vamtam_Widget_Nav_Menu );
	}
	add_action( \Vamtam_Elementor_Utils::get_widgets_registration_hook(), __NAMESPACE__ . '\widgets_registered', 100 );
}
