<?php

/* Constantas
---------------*/

    define('MOBIMAX_ENOVATHEMES_TEMPPATH', get_template_directory_uri());
    define('MOBIMAX_ENOVATHEMES_IMAGES', MOBIMAX_ENOVATHEMES_TEMPPATH. "/images");
    define('ICL_DONT_LOAD_NAVIGATION_CSS', true);
    define('ICL_DONT_LOAD_LANGUAGE_SELECTOR_CSS', true);

    function mobimax_enovathemes_global_variables(){
        global $mobimax_enovathemes, $woocommerce, $post, $product, $wp_query, $query_string;
    }

/* Includes
---------------*/

    if (!class_exists('TGM_Plugin_Activation') && file_exists( get_template_directory() . '/includes/class-tgm-plugin-activation.php' ) ) {
        require_once(get_template_directory() . '/includes/class-tgm-plugin-activation.php');
    }

    if (defined( 'WPB_VC_VERSION' )) {
        require_once(get_template_directory() . '/includes/enovathemes_vc.php' );
    }

    require_once(get_template_directory() . '/includes/enovathemes-functions.php');
    require_once(get_template_directory() . '/includes/menu/custom-menu.php' );
    require_once(get_template_directory() . '/includes/dynamic-styles.php');

    if (class_exists('OCDI_Plugin')) {

        add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
        add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' );

        function mobimax_enovathemes_intro_text( $default_text ) {
            $default_text = '<br><br><div class="ocdi__intro-text custom-intro-text">
            <h2 class="about-description">
            '.esc_html__( "Importing demo data (post, pages, images, theme settings, ...) is the easiest way to setup your theme.", "mobimax" ).'
            '.esc_html__( "It will allow you to quickly edit everything instead of creating content from scratch.", "mobimax" ).'
            </h2>
            <hr>
            <h3>'.esc_html__( "Important things to know before starting demo import", "mobimax" ).'</h3><br><br>
            <ul>
            <li>'.esc_html__( "No existing posts, pages, categories, images, custom post types or any other data will be deleted or modified.", "mobimax" ).'</li>
            <li>'.esc_html__( "Posts, pages, images, widgets, menus and other theme settings will get imported.", "mobimax" ).'</li>
            <li>'.esc_html__( "Please click on the Import button only once and wait, it can take a couple of minutes.", "mobimax" ).'</li>
            <li>'.esc_html__( "If you want to change the homepage version after import, do not import another demo, go to WordPress settings >> Reading and choose different homepage version as your front-page.", "mobimax" ).'</li>
            <li>'.esc_html__( "If you want to import pages/posts/custom post type/menu etc. separately use regular WordPress importer", "mobimax" ).'</li>
            <li>'.esc_html__( "Sometimes not all widgets are displayed after the import, this is known issue, you will need to replace these plugins or re-save one more time", "mobimax" ).'</li>
            <li>'.esc_html__( "Sometimes not all images are imported during import process, this is known issue, you just need before import uncheck the 'Organize my uploads into month- and year-based folders' option from WordPress dashboard >> settings >> media", "mobimax" ).'</li>
            </ul>
            <hr>
            <h3>'.esc_html__( "What to do after import", "mobimax" ).'</h3><br><br>
            <ul>
            <li>'.esc_html__( "After import don't forget to import Revolution Slider separately from Revolution Slider settings page", "mobimax" ).'</li>
            <li>'.esc_html__( "All the images will be imported with original sizes without cropping. This way your import process will be quicker and your server will have less work to do. After the import completed go to the WordPress >> Tools and use the Regenerate thumbnails plugin to crop images to theme supported sizes.", "mobimax" ).'</li>
            <li>'.esc_html__( "Also change permalinks from default to whatever you want. (WordPress settings >> permalinks)", "mobimax" ).'</li>
            </ul>
            <hr>
            <h3>'.esc_html__( "Troubleshooting", "mobimax" ).'</h3><br>
            <p>'.esc_html__( "If you will have any issues with the import process, please update these option on your server (edit your php.ini file)", "mobimax" ).' </p>
            <ul class="code">
            <li>upload_max_filesize (256M)</li>
            <li>max_input_time (300)</li>
            <li>memory_limit (256M)</li>
            <li>max_execution_time (300)</li>
            <li>post_max_size (512M)</li>
            </ul>
            <p>'.esc_html__( "These defaults are not perfect and it depends on how large of an import you are making. So the bigger the import, the higher the numbers should be.", "mobimax" ).' </p>
            </div><br><br>';
            return $default_text;
        }
        add_filter( 'pt-ocdi/plugin_intro_text', 'mobimax_enovathemes_intro_text' );

        function mobimax_enovathemes_import_files() {
            return array(

                array(
                    'import_file_name'             => esc_html__('Full demo', 'mobimax'),
                    'categories'                   => array( 'General' ),
                    'local_import_file'            => trailingslashit( get_template_directory() ) . '/demo/all.xml',
                    'local_import_widget_file'     => trailingslashit( get_template_directory() ) . '/demo/widgets.wie',
                    'local_import_redux'           => array(
                        array(
                            'file_path'   => trailingslashit( get_template_directory() ) . '/demo/options.json',
                            'option_name' => 'mobimax_enovathemes',
                        ),
                    ),
                    'import_notice' => esc_html__( 'Import process can take up to 10 minutes, so please be patient and do not interrupt the import process', 'mobimax' ),
                ),

            );
        }
        add_filter( 'pt-ocdi/import_files', 'mobimax_enovathemes_import_files' );
    }

/* TGM
---------------*/

    add_action( 'tgmpa_register', 'mobimax_enovathemes_register_required_plugins' );
    function mobimax_enovathemes_register_required_plugins() {

        $plugins = array(

            array(
                'name'      => esc_html__('Contact Form 7', 'mobimax'),
                'slug'      => 'contact-form-7',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('One Click Demo Import', 'mobimax'),
                'slug'      => 'one-click-demo-import',
                'required'  => true
            ),
            array(
                'name'      => esc_html__('Regenerate Thumbnails', 'mobimax'),
                'slug'      => 'regenerate-thumbnails',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('WooCommerce', 'mobimax'),
                'slug'      => 'woocommerce',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('WPC Smart Compare for WooCommerce', 'mobimax'),
                'slug'      => 'woo-smart-compare',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('YITH WooCommerce Quick View', 'mobimax'),
                'slug'      => 'yith-woocommerce-quick-view',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('YITH WooCommerce Wishlist', 'mobimax'),
                'slug'      => 'yith-woocommerce-wishlist',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('AJAX Search for WooCommerce', 'mobimax'),
                'slug'      => 'ajax-search-for-woocommerce',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('YayCurrency – WooCommerce Multi-Currency Switcher', 'mobimax'),
                'slug'      => 'yaycurrency',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('Envato market master', 'mobimax'),
                'slug'      => 'envato-market',
                'source'    => get_template_directory() . '/plugins/envato-market.zip',
                'required'  => true,
                'dismissable' => true
            ),
            array(
                'name'      => esc_html__('WPBakery Visual Composer', 'mobimax'),
                'slug'      => 'js_composer',
                'source'    => get_template_directory() . '/plugins/js_composer.zip',
                'required'  => true,
                'version'   => '8.6.1'
            ),
            array(
                'name'      => esc_html__('Revolution slider', 'mobimax'),
                'slug'      => 'revslider',
                'source'    => get_template_directory() . '/plugins//revslider.zip',
                'required'  => true,
                'version'   => '6.7.37'
            ),
            array(
                'name'      => esc_html__('Enovathemes add-ons', 'mobimax'),
                'slug'      => 'enovathemes-addons',
                'source'    => get_template_directory() . '/plugins/enovathemes-addons.zip',
                'required'  => true,
                'version'   => '5.7'
            ),

        );

        $config = array(
            'id'                => 'mobimax',
            'default_path'      => '',                          // Default absolute path to pre-packaged plugins
            'parent_slug'       => 'themes.php',                // Default parent menu slug
            'capability'        => 'edit_theme_options',
            'menu'              => 'install-required-plugins',  // Menu slug
            'has_notices'       => true,                        // Show admin notices or not
            'dismissable'       => false,
            'is_automatic'      => false,                       // Automatically activate plugins after installation or not
            'message'           => '',                          // Message to output right before the plugins table
            'strings'           => array(
                'page_title'                                => esc_html__( 'Install Required Plugins', 'mobimax' ),
                'menu_title'                                => esc_html__( 'Install Plugins', 'mobimax' ),
                'installing'                                => esc_html__( 'Installing Plugin: %s', 'mobimax' ), // %1$s = plugin name
                'oops'                                      => esc_html__( 'Something went wrong with the plugin API.', 'mobimax' ),
                'notice_can_install_required'               => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'mobimax' ), // %1$s = plugin name(s)
                'notice_can_install_recommended'            => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'mobimax' ), // %1$s = plugin name(s)
                'notice_cannot_install'                     => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'mobimax' ), // %1$s = plugin name(s)
                'notice_can_activate_required'              => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'mobimax' ), // %1$s = plugin name(s)
                'notice_can_activate_recommended'           => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'mobimax' ), // %1$s = plugin name(s)
                'notice_cannot_activate'                    => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'mobimax' ), // %1$s = plugin name(s)
                'notice_ask_to_update'                      => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'mobimax' ), // %1$s = plugin name(s)
                'notice_cannot_update'                      => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'mobimax' ), // %1$s = plugin name(s)
                'install_link'                              => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'mobimax' ),
                'activate_link'                             => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'mobimax' ),
                'return'                                    => esc_html__( 'Return to Required Plugins Installer', 'mobimax' ),
                'plugin_activated'                          => esc_html__( 'Plugin activated successfully.', 'mobimax' ),
                'complete'                                  => esc_html__( 'All plugins installed and activated successfully. %s', 'mobimax' ), // %1$s = dashboard link
                'nag_type'                                  => 'updated' // Determines admin notice type - can only be 'updated' or 'error'
            )
        );

        tgmpa( $plugins, $config );

    }

/* Thumbnails
---------------*/

    if ( function_exists( 'add_theme_support' ) ) {

        add_theme_support( 'post-thumbnails');

        // Grid based
        add_image_size( 'mobimax_1200X720', 1200, 720, true );
        add_image_size( 'mobimax_1200X556', 1200, 556, true );
        add_image_size( 'mobimax_900X556', 900, 556, true );
        add_image_size( 'mobimax_600X370', 600, 370, true );
        add_image_size( 'mobimax_480X360', 400, 360, true );
        add_image_size( 'mobimax_480X480', 480, 480, true );
        add_image_size( 'mobimax_300X250', 300, 250, true );

        // Thumbnails
        add_image_size( 'mobimax_60X97', 60, 97, true );

    }

    function mobimax_enovathemes_custom_image_sizes( $sizes ) {

        $new_sizes = array();

        $added_sizes = get_intermediate_image_sizes();

        foreach( $added_sizes as $key => $value) {
            $new_sizes[$value] = $value;
        }

        $new_sizes = array_merge( $new_sizes, $sizes );

        return $new_sizes;
    }
    add_filter('image_size_names_choose', 'mobimax_enovathemes_custom_image_sizes', 11, 1);

/* Theme Config
---------------*/

    add_action('init', 'mobimax_enovathemes_init');
    function mobimax_enovathemes_init() {
        add_theme_support( 'html5', array( 'gallery', 'caption' ) );
        add_theme_support( 'post-formats', array( 'aside', 'audio', 'video', 'gallery', 'link', 'quote', 'status', 'chat') );
        add_theme_support( 'automatic-feed-links' );
        add_post_type_support( 'post', 'post-formats' );
        add_post_type_support( 'page', 'excerpt' );
        add_theme_support( 'align-wide' );
        add_theme_support( 'responsive-embeds' );
    }

    if ( ! isset( $content_width ) ) {$content_width = 1200;}

    if(function_exists('vc_set_as_theme')) vc_set_as_theme(true);

    add_action( 'after_setup_theme', 'mobimax_enovathemes_woocommerce_support' );
    function mobimax_enovathemes_woocommerce_support() {
        load_theme_textdomain('mobimax', get_template_directory() . '/languages');
        add_theme_support( 'woocommerce' );
        add_theme_support( 'title-tag' );
    }

    function mobimax_enovathemes_remove_redux_news() {
        remove_meta_box( 'redux_dashboard_widget', 'dashboard', 'side' );
    }
    add_action('wp_dashboard_setup', 'mobimax_enovathemes_remove_redux_news' );

    function mobimax_enovathemes_redux_menu_page_removing() {
        remove_submenu_page( 'tools.php', 'redux-about' );
    }
    add_action( 'admin_menu', 'mobimax_enovathemes_redux_menu_page_removing' );


    add_filter('body_class', 'mobimax_enovathemes_general_body_classes');
    function mobimax_enovathemes_general_body_classes($classes) {

            global $mobimax_enovathemes, $post;

            $et_img_preloader  = (isset($GLOBALS['mobimax_enovathemes']['img-preload']) && $GLOBALS['mobimax_enovathemes']['img-preload'] == 1) ? 'true' : 'false';
            $header_desktop_id = (isset($GLOBALS['mobimax_enovathemes']['header-desktop-id']) && !empty($GLOBALS['mobimax_enovathemes']['header-desktop-id'])) ? $GLOBALS['mobimax_enovathemes']['header-desktop-id'] : "default";

            $product_header_desktop_id = (isset($GLOBALS['mobimax_enovathemes']['product-desktop-id']) && !empty($GLOBALS['mobimax_enovathemes']['product-desktop-id'])) ? $GLOBALS['mobimax_enovathemes']['product-desktop-id'] : "none";

            $custom_class = array();
            $custom_class[] = "enovathemes";
            $custom_class[] = ($et_img_preloader == "true") ? 'preloader-active' : 'preloader-inactive';
            $custom_class[] = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll']) && $GLOBALS['mobimax_enovathemes']['custom-scroll'] == 1) ? 'custom-scroll-true' : 'custom-scroll-false';
            $custom_class[] = (isset($GLOBALS['mobimax_enovathemes']['layout']) && !empty($GLOBALS['mobimax_enovathemes']['layout']) ) ? 'layout-'.$GLOBALS['mobimax_enovathemes']['layout'] : ' layout-wide';

            if (class_exists('Woocommerce')){

                $wishlistpage = "false";
                if (defined('YITH_WCWL')) {
                    $wishlistpage = (is_page(get_option('yith_wcwl_wishlist_page_id'))) ? "true" : "false";
                }

                if (is_cart() || is_checkout()) {$custom_class[] = "cart-checkout";}
                if (is_account_page()) {$custom_class[] = "my-account";}
                if ($wishlistpage == "true"){$custom_class[] = "wishlist-page";}

                $woocommerce_shop_page_display = get_option( 'woocommerce_shop_page_display' );

                if ($woocommerce_shop_page_display === '') {
                    $custom_class[] = "woocommerce-layout-product";
                } elseif ($woocommerce_shop_page_display === 'subcategories') {
                    $custom_class[] = "woocommerce-layout-category";
                } elseif($woocommerce_shop_page_display === 'both') {
                    $custom_class[] = "woocommerce-layout-both";
                }

                if (class_exists('YITH_WCQV_Frontend')){

                    if (get_option('yith-wcqv-enable-mobile') == 'no') {
                       $custom_class[] = "woocommerce-quick-view-no-mob";
                    }

                }

            }

            if (!is_search()  && !is_404()) {

                $post_info = get_post(get_the_ID());

                if (!is_wp_error($post_info) && is_object($post_info)) {

                    $post_type   = $post_info->post_type;

                    if ($post_type == 'product') {
                        if ($header_desktop_id != "inherit") {
                            $header_desktop_id = $product_header_desktop_id;
                        }
                    }

                }

            }

            if (is_page()) {
                $page_header_desktop_id = get_post_meta( get_the_ID(), 'enovathemes_addons_desktop_header', true );
                if ($page_header_desktop_id != 'inherit') {
                    $header_desktop_id = $page_header_desktop_id;
                }
            }

            if ($header_desktop_id != "none" && $header_desktop_id != "default"){

                $et_header = new WP_Query(array(
                    'post_type'=> 'header',
                    'p'       => $header_desktop_id
                ));
                if($et_header->have_posts()){
                    while($et_header->have_posts()) { $et_header->the_post();

                            $type             = get_post_meta($header_desktop_id, 'enovathemes_addons_header_type', true);
                            $mobile           = get_post_meta($header_desktop_id, 'enovathemes_addons_mobile', true);
                            $tablet_portrait  = get_post_meta($header_desktop_id, 'enovathemes_addons_tablet_portrait', true);
                            $tablet_landscape = get_post_meta($header_desktop_id, 'enovathemes_addons_tablet_landscape', true);
                            $desktop          = get_post_meta($header_desktop_id, 'enovathemes_addons_desktop', true);
                            $sidebar_align    = get_post_meta($header_desktop_id, 'enovathemes_addons_sidebar_align', true);

                            $mobile           = (empty($mobile)) ? "false" : "true";
                            $tablet_portrait  = (empty($tablet_portrait)) ? "false" : "true";
                            $tablet_landscape = (empty($tablet_landscape)) ? "false" : "true";
                            $desktop          = (empty($desktop)) ? "false" : "true";

                            if ($type == "sidebar") {
                                $custom_class[] = "sidebar-navigation";
                                $custom_class[] = "sidebar-navigation-".$sidebar_align;
                            }

                            if ($mobile == "true") {$custom_class[] = "mobile-hide-important";}
                            if ($tablet_portrait == "true") {$custom_class[] = "tablet-portrait-hide-important";}
                            if ($tablet_landscape == "true") {$custom_class[] = "tablet-landscape-hide-important";}
                            if ($desktop == "true") {$custom_class[] = "desktop-hide-important";}
                    }
                }
                wp_reset_query();

            }

            if (is_singular('header')) {
                $type             = get_post_meta(get_the_ID(), 'enovathemes_addons_header_type', true);
                $sidebar_align    = get_post_meta(get_the_ID(), 'enovathemes_addons_sidebar_align', true);

                if ($type == "sidebar") {
                    $custom_class[] = "sidebar-navigation";
                    $custom_class[] = "sidebar-navigation-".$sidebar_align;
                }
            }

            $classes[] = implode(" ", $custom_class);

            return $classes;
    }

    // Allow shortcodes in Contact Form 7
    function mobimax_enovathemes_shortcodes_in_cf7( $form ) {
        $form = do_shortcode( $form );
        return $form;
    }
    add_filter( 'wpcf7_form_elements', 'mobimax_enovathemes_shortcodes_in_cf7' );


    /* Content filter
    /*------------*/

        add_filter( 'the_content', 'shortcode_unautop');


/* Theme actions
/*-------------*/

    /* Header
    ---------------*/

        function mobimax_enovathemes_header(){ ?>

            <?php

                global $mobimax_enovathemes;

                $header_desktop_id = (isset($GLOBALS['mobimax_enovathemes']['header-desktop-id']) && !empty($GLOBALS['mobimax_enovathemes']['header-desktop-id'])) ? $GLOBALS['mobimax_enovathemes']['header-desktop-id'] : "default";
                $header_mobile_id  = (isset($GLOBALS['mobimax_enovathemes']['header-mobile-id']) && !empty($GLOBALS['mobimax_enovathemes']['header-mobile-id'])) ? $GLOBALS['mobimax_enovathemes']['header-mobile-id'] : "default";

                $product_header_desktop_id = (isset($GLOBALS['mobimax_enovathemes']['product-desktop-id']) && !empty($GLOBALS['mobimax_enovathemes']['product-desktop-id'])) ? $GLOBALS['mobimax_enovathemes']['product-desktop-id'] : "default";
                $product_header_mobile_id  = (isset($GLOBALS['mobimax_enovathemes']['product-mobile-id']) && !empty($GLOBALS['mobimax_enovathemes']['product-mobile-id'])) ? $GLOBALS['mobimax_enovathemes']['product-mobile-id'] : "default";

                if (class_exists('SitePress') || function_exists('pll_the_languages')){

                    $current_lang = (function_exists('pll_the_languages')) ? pll_current_language() : ICL_LANGUAGE_CODE;

                    // WPML
                    $header_desktop_id_wpml = (isset($GLOBALS['mobimax_enovathemes']['header-desktop-id-wpml']) && !empty($GLOBALS['mobimax_enovathemes']['header-desktop-id-wpml'])) ? $GLOBALS['mobimax_enovathemes']['header-desktop-id-wpml'] : $header_desktop_id;
                    $header_mobile_id_wpml  = (isset($GLOBALS['mobimax_enovathemes']['header-mobile-id-wpml']) && !empty($GLOBALS['mobimax_enovathemes']['header-mobile-id-wpml'])) ? $GLOBALS['mobimax_enovathemes']['header-mobile-id-wpml'] : $header_mobile_id;

                    if ($header_desktop_id_wpml != $header_desktop_id && !empty($header_desktop_id_wpml)) {
                        $header_desktop_id_wpml = explode('|', $header_desktop_id_wpml);

                        $lang_header_obj = array();


                        foreach ($header_desktop_id_wpml as $wpml_lang_header) {
                            $lang_header_set = explode(":",$wpml_lang_header);
                            $lang_header_obj[$lang_header_set[0]] = $lang_header_set[1];
                        }

                        if (array_key_exists($current_lang,$lang_header_obj)) {
                            $header_desktop_id = $lang_header_obj[$current_lang];
                        }

                    }

                    if ($header_mobile_id_wpml != $header_mobile_id && !empty($header_mobile_id_wpml)) {
                        $header_mobile_id_wpml = explode('|', $header_mobile_id_wpml);

                        $lang_header_obj = array();

                        foreach ($header_mobile_id_wpml as $wpml_lang_header) {
                            $lang_header_set = explode(":",$wpml_lang_header);
                            $lang_header_obj[$lang_header_set[0]] = $lang_header_set[1];
                        }

                        if (array_key_exists($current_lang,$lang_header_obj)) {
                            $header_mobile_id = $lang_header_obj[$current_lang];
                        }

                    }
                }


                if (is_page()) {

                    $page_header_desktop_id = get_post_meta( get_the_ID(), 'enovathemes_addons_desktop_header', true );
                    $page_header_mobile_id  = get_post_meta( get_the_ID(), 'enovathemes_addons_mobile_header', true );

                    if ($page_header_desktop_id != "inherit" && !empty($page_header_desktop_id)) {
                        $header_desktop_id = $page_header_desktop_id;
                    }

                    if ($page_header_mobile_id != "inherit" && !empty($page_header_mobile_id)) {
                        $header_mobile_id = $page_header_mobile_id;
                    }

                }

                if (!is_search()  && !is_404()) {

                    $post_info = get_post(get_the_ID());

                    if (!is_wp_error($post_info) && is_object($post_info)) {

                        $post_type   = $post_info->post_type;

                        if ($post_type == 'product') {

                            if ($product_header_desktop_id != "inherit") {
                                $header_desktop_id = $product_header_desktop_id;
                            }

                            if ($product_header_mobile_id != "inherit") {
                                $header_mobile_id = $product_header_mobile_id;
                            }
                        }

                    }

                }

                if (is_404()) {

                    $header_desktop_id = 'none';
                    $header_mobile_id = 'none';

                }

                if ($header_desktop_id == $header_mobile_id && $header_desktop_id != "default") {
                    $header_mobile_id = "none";
                }

                if (class_exists('\Detection\MobileDetect')) {
                    $detect = new \Detection\MobileDetect;

                    if ($detect->isMobile() || $detect->isTablet()) {
                        if ($header_mobile_id != "none" && $header_mobile_id != "default" && function_exists('enovathemes_addons_header_html')) {
                            enovathemes_addons_header_html($header_mobile_id, 'mobile');
                        } elseif ($header_mobile_id == "default") {
                            mobimax_enovathemes_default_header('mobile');
                        }
                    } else {
                        if ($header_mobile_id != "none" && $header_mobile_id != "default" && function_exists('enovathemes_addons_header_html')) {
                            enovathemes_addons_header_html($header_mobile_id, 'mobile');
                        } elseif ($header_mobile_id == "default") {
                            mobimax_enovathemes_default_header('mobile');
                        }

                        if ($header_desktop_id != "none" && $header_desktop_id != "default" && function_exists('enovathemes_addons_header_html')) {
                            enovathemes_addons_header_html($header_desktop_id, 'desktop');
                        } elseif ($header_desktop_id == "default") {
                            mobimax_enovathemes_default_header('desktop');
                        }
                    }
                } else {
                    if ($header_mobile_id != "none" && $header_mobile_id != "default" && function_exists('enovathemes_addons_header_html')) {
                        enovathemes_addons_header_html($header_mobile_id, 'mobile');
                    } elseif ($header_mobile_id == "default") {
                        mobimax_enovathemes_default_header('mobile');
                    }

                    if ($header_desktop_id != "none" && $header_desktop_id != "default" && function_exists('enovathemes_addons_header_html')) {
                        enovathemes_addons_header_html($header_desktop_id, 'desktop');
                    } elseif ($header_desktop_id == "default") {
                        mobimax_enovathemes_default_header('desktop');
                    }
                }

            ?>

        <?php }
        add_action('mobimax_enovathemes_header', 'mobimax_enovathemes_header');

    /* Footer
    ---------------*/

        function mobimax_enovathemes_footer(){ ?>

            <?php

                global $mobimax_enovathemes;

                $footer_id         = (isset($GLOBALS['mobimax_enovathemes']['footer-id']) && !empty($GLOBALS['mobimax_enovathemes']['footer-id'])) ? $GLOBALS['mobimax_enovathemes']['footer-id'] : "default";
                $product_footer_id = (isset($GLOBALS['mobimax_enovathemes']['product-footer-id']) && !empty($GLOBALS['mobimax_enovathemes']['product-footer-id'])) ? $GLOBALS['mobimax_enovathemes']['product-footer-id'] : "none";

                if (class_exists('SitePress') || function_exists('pll_the_languages')){

                    $current_lang = (function_exists('pll_the_languages')) ? pll_current_language() : ICL_LANGUAGE_CODE;

                    // WPML
                    $footer_id_wpml = (isset($GLOBALS['mobimax_enovathemes']['footer-id-wpml']) && !empty($GLOBALS['mobimax_enovathemes']['footer-id-wpml'])) ? $GLOBALS['mobimax_enovathemes']['footer-id-wpml'] : $footer_id;

                    if ($footer_id_wpml != $footer_id && !empty($footer_id_wpml)) {
                        $footer_id_wpml = explode('|', $footer_id_wpml);

                        $lang_footer_obj = array();

                        foreach ($footer_id_wpml as $wpml_lang_footer) {
                            $lang_footer_set = explode(":",$wpml_lang_footer);
                            $lang_footer_obj[$lang_footer_set[0]] = $lang_footer_set[1];
                        }

                        if (array_key_exists($current_lang,$lang_footer_obj)) {
                            $footer_id = $lang_footer_obj[$current_lang];
                        }

                    }

                }

                if (is_page()) {
                    $page_footer_id = get_post_meta( get_the_ID(), 'enovathemes_addons_footer', true );

                    if ($page_footer_id != "inherit" && !empty($page_footer_id)) {
                        $footer_id = $page_footer_id;
                    }
                }

                if (!is_search()  && !is_404()) {

                    $post_info = get_post(get_the_ID());

                    if (!is_wp_error($post_info) && is_object($post_info)) {

                        $post_type   = $post_info->post_type;

                        if ($post_type == 'product') {

                            if ($product_footer_id != "inherit") {
                                $footer_id = $product_footer_id;
                            }
                        }

                    }

                }

                if (is_404()) {

                    $footer_id = 'none';

                }

                if ($footer_id != "none" && $footer_id != "default" && function_exists('enovathemes_addons_footer_html')) {
                    enovathemes_addons_footer_html($footer_id);
                } elseif ($footer_id == "default") {
                    mobimax_enovathemes_default_footer();
                }

            ?>

        <?php }
        add_action('mobimax_enovathemes_footer', 'mobimax_enovathemes_footer');

    /* Title section
    ---------------*/

        function mobimax_enovathemes_title_section(){ ?>

            <?php

                global $mobimax_enovathemes;

                $slider           = "none";
                $title_section_id = (isset($GLOBALS['mobimax_enovathemes']['title-section-id']) && !empty($GLOBALS['mobimax_enovathemes']['title-section-id'])) ? $GLOBALS['mobimax_enovathemes']['title-section-id'] : "default";
                $etp_title        = "";
                $etp_subtitle     = "";
                $author_text      = esc_html__('Author: %s','mobimax');
                $search_text      = esc_html__('Search','mobimax');
                $etp_breadcrumbs  = (function_exists('enovathemes_addons_breadcrumbs')) ? enovathemes_addons_breadcrumbs() : "";

                $blog_title_id         = (isset($GLOBALS['mobimax_enovathemes']['blog-title']) && !empty($GLOBALS['mobimax_enovathemes']['blog-title'])) ? $GLOBALS['mobimax_enovathemes']['blog-title'] : "default";
                $blog_title_text       = (isset($GLOBALS['mobimax_enovathemes']['blog-title-text']) && $GLOBALS['mobimax_enovathemes']['blog-title-text']) ? $GLOBALS['mobimax_enovathemes']['blog-title-text'] : 'Blog';
                $blog_subtitle_text    = (isset($GLOBALS['mobimax_enovathemes']['blog-subtitle-text']) && $GLOBALS['mobimax_enovathemes']['blog-subtitle-text']) ? $GLOBALS['mobimax_enovathemes']['blog-subtitle-text'] : '';

                $product_title_id      = (isset($GLOBALS['mobimax_enovathemes']['product-title']) && !empty($GLOBALS['mobimax_enovathemes']['product-title'])) ? $GLOBALS['mobimax_enovathemes']['product-title'] : "default";
                $product_title_text    = (isset($GLOBALS['mobimax_enovathemes']['product-title-text']) && $GLOBALS['mobimax_enovathemes']['product-title-text']) ? $GLOBALS['mobimax_enovathemes']['product-title-text'] : 'Shop';
                $product_subtitle_text = (isset($GLOBALS['mobimax_enovathemes']['product-subtitle-text']) && $GLOBALS['mobimax_enovathemes']['product-subtitle-text']) ? $GLOBALS['mobimax_enovathemes']['product-subtitle-text'] : '';

                if (class_exists('SitePress') || function_exists('pll_the_languages')){

                    $current_lang = (function_exists('pll_the_languages')) ? pll_current_language() : ICL_LANGUAGE_CODE;

                    // WPML
                    $title_section_id_wpml = (isset($GLOBALS['mobimax_enovathemes']['title-section-id-wpml']) && !empty($GLOBALS['mobimax_enovathemes']['title-section-id-wpml'])) ? $GLOBALS['mobimax_enovathemes']['title-section-id-wpml'] : $title_section_id;

                    if ($title_section_id_wpml != $title_section_id && !empty($title_section_id_wpml)) {
                        $title_section_id_wpml = explode('|', $title_section_id_wpml);

                        $lang_titlesection_obj = array();

                        foreach ($title_section_id_wpml as $wpml_lang_titlesection) {
                            $lang_titlesection_set = explode(":",$wpml_lang_titlesection);
                            $lang_titlesection_obj[$lang_titlesection_set[0]] = $lang_titlesection_set[1];
                        }

                        if (array_key_exists($current_lang,$lang_titlesection_obj)) {
                            $title_section_id = $lang_titlesection_obj[$current_lang];
                        }

                    }

                }

                /* Page
                ---------------*/

                    if (is_page()) {

                        $page_slider                 = get_post_meta( get_the_ID(), 'enovathemes_addons_slider', true );
                        $page_title_section_id       = get_post_meta( get_the_ID(), 'enovathemes_addons_title_section', true );
                        $page_title_section_subtitle = get_post_meta( get_the_ID(), 'enovathemes_addons_subtitle', true );

                        $etp_title     = get_the_title( get_the_ID() );
                        $etp_subtitle  = $page_title_section_subtitle;

                        if (!empty($page_slider)) {
                            $slider = $page_slider;
                        }

                        if ($page_title_section_id != "inherit" && !empty($page_title_section_id)) {
                            $title_section_id = $page_title_section_id;
                        }

                        if (!empty($page_title_section_subtitle)) {
                            $title_section_subtitle = $page_title_section_subtitle;
                        }

                    }

                /* Blog
                ---------------*/

                    if (is_home() || is_singular('post')) {
                        $etp_title     = $blog_title_text;
                        $etp_subtitle  = $blog_subtitle_text;
                        if ($blog_title_id != "inherit") {
                            $title_section_id = $blog_title_id;
                        }
                    }elseif (is_category()) {
                        $etp_title     = single_cat_title('', false);
                        $etp_subtitle  = $blog_subtitle_text;
                        if ($blog_title_id != "inherit") {
                            $title_section_id = $blog_title_id;
                        }
                    }elseif (is_tag()) {
                        $etp_title     = single_tag_title('', false);
                        $etp_subtitle  = $blog_subtitle_text;
                        if ($blog_title_id != "inherit") {
                            $title_section_id = $blog_title_id;
                        }
                    }elseif (is_day()) {
                        $etp_title     = get_the_date('F dS Y');
                        $etp_subtitle  = $blog_subtitle_text;
                        if ($blog_title_id != "inherit") {
                            $title_section_id = $blog_title_id;
                        }
                    }elseif (is_month()) {
                        $etp_title     = get_the_date('Y, F');
                        $etp_subtitle  = $blog_subtitle_text;
                        if ($blog_title_id != "inherit") {
                            $title_section_id = $blog_title_id;
                        }
                    }elseif (is_year()) {
                        $etp_title     = get_the_date('Y');
                        $etp_subtitle  = $blog_subtitle_text;
                        if ($blog_title_id != "inherit") {
                            $title_section_id = $blog_title_id;
                        }
                    }elseif (is_author()) {
                        $userdata      = get_userdata($GLOBALS['author']);
                        $author        = (!empty($userdata->first_name) && !empty($userdata->last_name)) ? esc_html($userdata->first_name)." ".esc_html($userdata->last_name) : $userdata->user_login;
                        $etp_title     = sprintf($author_text, $author);
                        $etp_subtitle  = $blog_subtitle_text;
                        if ($blog_title_id != "inherit") {
                            $title_section_id = $blog_title_id;
                        }
                    }elseif ( is_search()) {
                        $etp_title     = $search_text;
                        $etp_subtitle  = $blog_subtitle_text;
                        if ($blog_title_id != "inherit") {
                            $title_section_id = $blog_title_id;
                        }
                    }elseif ( is_tax() ) {
                        $etp_title     = single_cat_title('', false);
                        $etp_subtitle  = $blog_subtitle_text;
                        if ($blog_title_id != "inherit") {
                            $title_section_id = $blog_title_id;
                        }
                    }

                /*  CPT
                -------------------*/

                    if (!is_search()  && !is_404()) {

                        $post_info = get_post(get_the_ID());

                        if (!is_wp_error($post_info) && is_object($post_info)) {

                            $post_type   = $post_info->post_type;

                            if ($post_type == 'product') {

                                $etp_title     = $product_title_text;
                                $etp_subtitle  = $product_subtitle_text;
                                if ($product_title_id != "inherit") {
                                    $title_section_id = $product_title_id;
                                }

                                if ( is_tax() ) {
                                    $etp_title = single_cat_title('', false);
                                }
                            }

                        }

                    }

                if (is_404()) {
                    $title_section_id = "none";
                }
            ?>

            <?php if(shortcode_exists("rev_slider") && $slider != "none" && !empty($slider)): ?>
                <?php echo(do_shortcode('[rev_slider '.$slider.']')); ?>
            <?php else: ?>

                <?php
                    if ($title_section_id != "none" && $title_section_id != "default" && function_exists('enovathemes_addons_title_section_html')) {
                        enovathemes_addons_title_section_html($title_section_id, $etp_title, $etp_subtitle, $etp_breadcrumbs);
                    } elseif ($title_section_id == "default") {
                        mobimax_enovathemes_default_title_section($etp_title, $etp_subtitle, $etp_breadcrumbs);
                    }

                ?>

            <?php endif ?>

        <?php }
        add_action('mobimax_enovathemes_title_section', 'mobimax_enovathemes_title_section');

    /* Move top
    ---------------*/

        function mobimax_enovathemes_move_top(){ ?>
            <?php global $mobimax_enovathemes; ?>
            <?php if ((isset($GLOBALS['mobimax_enovathemes']['mtt']) && $GLOBALS['mobimax_enovathemes']['mtt'] == 1)): ?>
                <a id="to-top" href="#wrap"></a>
            <?php endif ?>
        <?php }
        add_action('mobimax_enovathemes_move_top', 'mobimax_enovathemes_move_top');

    /* Page comments
    ---------------*/

        function mobimax_enovathemes_page_comments(){
            if (class_exists('Woocommerce')){

                $add_comment_template = "true";

                $wishlistpage = "false";
                if (defined('YITH_WCWL')) {
                    $wishlistpage = (is_page(get_option('yith_wcwl_wishlist_page_id'))) ? "true" : "false";
                }

                if (is_cart() || is_checkout() || is_account_page() || is_wc_endpoint_url() || $wishlistpage == "true") {
                    $add_comment_template = "false";
                }

                if ($add_comment_template == "true") {
                    comments_template();
                }

            } else {

                $add_comment_template = "true";

                if ($add_comment_template == "true" &&  comments_open( get_the_ID() )) {
                    comments_template();
                }

            }
        }
        add_action('mobimax_enovathemes_after_page_body', 'mobimax_enovathemes_page_comments');

    /* Page container after/before
    ---------------*/

        function mobimax_enovathemes_woocommerce_page_container_before(){
            if (class_exists('Woocommerce')){

                $wishlistpage = "false";
                if (defined('YITH_WCWL')) {
                    $wishlistpage = (is_page(get_option('yith_wcwl_wishlist_page_id'))) ? "true" : "false";
                }

                if (is_cart() || is_checkout() || is_account_page() || is_wc_endpoint_url() || $wishlistpage == "true") {
                    echo '<div class="product-layout product-container-boxed">';
                }

            }
        }
        add_action('mobimax_enovathemes_before_page_container', 'mobimax_enovathemes_woocommerce_page_container_before');


        function mobimax_enovathemes_woocommerce_page_container_after(){
            if (class_exists('Woocommerce')){

                $wishlistpage = "false";
                if (defined('YITH_WCWL')) {
                    $wishlistpage = (is_page(get_option('yith_wcwl_wishlist_page_id'))) ? "true" : "false";
                }

                if (is_cart() || is_checkout() || is_account_page() || is_wc_endpoint_url() || $wishlistpage == "true") {
                    echo '</div>';
                }

            }
        }
        add_action('mobimax_enovathemes_after_page_container', 'mobimax_enovathemes_woocommerce_page_container_after');

/* Menu
---------------*/

    function mobimax_enovathemes_register_menu() {

        register_nav_menus(
            array(
              'header-menu' => esc_html__( 'Header menu', 'mobimax' ),
            )
        );

    }
    add_action( 'after_setup_theme', 'mobimax_enovathemes_register_menu' );

/* Widget areas
---------------*/

    add_action( 'widgets_init', 'mobimax_enovathemes_register_sidebars' );
    function mobimax_enovathemes_register_sidebars() {

        if ( function_exists( 'register_sidebar' ) ){

            global $mobimax_enovathemes;

            register_sidebar(
                array (
                'name'          => esc_html__( 'Blog widgets', 'mobimax'),
                'id'            => 'blog-widgets',
                'description'   => esc_html__('Add your blog widgets here. This is the main blog widget area. It is visible only in blog archive pages.', 'mobimax'),
                'class'         => 'blog-widgets',
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h5 class="widget_title">',
                'after_title'   => '</h5>' )
            );

            register_sidebar(
                array (
                'name'          => esc_html__( 'Blog single post page widgets', 'mobimax'),
                'id'            => 'blog-single-widgets',
                'description'   => esc_html__('Add your blog single post widgets here. This widget area is only visible in the single post page.', 'mobimax'),
                'class'         => 'blog-single-widgets',
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h5 class="widget_title">',
                'after_title'   => '</h5>' )
            );

            if (class_exists("Woocommerce")) {

                register_sidebar(
                    array (
                    'name'          => esc_html__( 'Shop widgets', 'mobimax'),
                    'id'            => 'shop-widgets',
                    'description'   => esc_html__('Add your shop widgets here. This widget area is visible in shop arhive pages only.', 'mobimax'),
                    'class'         => 'shop-widgets',
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<h5 class="widget_title">',
                    'after_title'   => '</h5>' )
                );

                register_sidebar(
                    array (
                    'name'          => esc_html__( 'Shop single post page widgets', 'mobimax'),
                    'id'            => 'shop-single-widgets',
                    'description'   => esc_html__('Add your shop single product widgets here. This widget area is only visible in single product page.', 'mobimax'),
                    'class'         => 'shop-single-widgets',
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<h5 class="widget_title">',
                    'after_title'   => '</h5>' )
                );

                register_sidebar(
                    array (
                    'name'          => esc_html__( 'Shop before products widget area', 'mobimax'),
                    'id'            => 'shop-top-widgets',
                    'description'   => esc_html__('Add your banners here', 'mobimax'),
                    'class'         => 'shop-top-widgets',
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<h5 class="widget_title">',
                    'after_title'   => '</h5>' )
                );

            }
        }
    }

/* Woo Commerce
---------------*/

    if (class_exists('Woocommerce')){

        /* Show user cars on order list
        ---------------*/

            add_filter( 'manage_edit-shop_order_columns', 'mobimax_enovathemes_add_new_order_admin_list_column' );

            function mobimax_enovathemes_add_new_order_admin_list_column( $columns ) {
                $columns['vehicle'] = 'Vehicle';
                return $columns;
            }

            add_action( 'manage_shop_order_posts_custom_column', 'mobimax_enovathemes_add_new_order_admin_list_column_content' );

            function mobimax_enovathemes_add_new_order_admin_list_column_content( $column ) {

                global $post;

                if ( 'vehicle' === $column ) {

                    $order = new WC_Order($post->ID);
                    $user_id = $order->get_user_id( );

                    $user_cars         = array();
                    $current_user_cars = get_user_meta( $user_id, 'enovathemes_addons_cars',true);

                    if (!empty($current_user_cars)) {
                        $current_user_cars = explode('|', $current_user_cars);
                        foreach ($current_user_cars as $car) {
                            array_push($user_cars, $car);
                        }
                    }

                    if (!empty($user_cars)) {

                        foreach ($user_cars as $car) {

                            $data_car = $car;

                            $car = explode(':', $car);

                            $car_obj = array();
                            $car_obj['make']  = $car[0];
                            $car_obj['model'] = $car[1];
                            $car_obj['year']  = $car[2];
                            $car_obj['trim']  = $car[3];

                            $make = get_term_by('id',$car_obj['make'],'product-make');
                            $model = get_term_by('id',$car_obj['model'],'product-model');
                            $trim = get_term_by('id',$car_obj['trim'],'product-trim');

                            if (is_object($make)) {$make = $make->name;}
                            if (is_object($model)) {$model = $model->name;}
                            if (is_object($trim)) {$trim = $trim->name;}

                            echo esc_html($make.', '.$model.', '.$car_obj['year'].', '.$trim);

                        }
                    }


                }
            }

        /* Show mini cart on cart and checkout
        ---------------*/

            add_filter( 'woocommerce_widget_cart_is_hidden', 'mobimax_enovathemes_always_show_cart', 40, 0 );
            function mobimax_enovathemes_always_show_cart() {
                return false;
            }

        /* Hide the default buttons of compare
        ---------------*/

            add_filter( 'filter_wooscp_button_archive', function() {
                return '0';
            } );
            add_filter( 'filter_wooscp_button_single', function() {
                return '0';
            } );

        /* Remove default styling
        ---------------*/

            add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

        /* Woocommerce gallery sypport
        ---------------*/

            add_action( 'after_setup_theme', 'mobimax_enovathemes_setup' );
            function mobimax_enovathemes_setup() {
                add_theme_support( 'wc-product-gallery-zoom' );
                add_theme_support( 'wc-product-gallery-lightbox' );
                add_theme_support( 'wc-product-gallery-slider' );
            }

        /* Woocommerce image sizes
        ---------------*/

            add_theme_support( 'woocommerce', array(
                'thumbnail_image_width'         => 600,
                'gallery_thumbnail_image_width' => 106,
                'single_image_width'            => 600,
            ));

            add_filter( 'woocommerce_get_image_size_gallery_thumbnail', 'mobimax_enovathemes_change_shop_thumbnail' );
            function mobimax_enovathemes_change_shop_thumbnail( $size ) {
                return array(
                    'width'  => 106,
                    'height' => 106,
                    'crop'   => 1,
                );
            }

        /* Add to cart
        ---------------*/

            add_filter('woocommerce_add_to_cart_fragments', 'mobimax_enovathemes_add_to_cart');
            function mobimax_enovathemes_add_to_cart( $fragments ) {

                global $woocommerce;

                ob_start(); ?>
                <a class="cart-contents" href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php echo esc_attr__('View your shopping cart', 'mobimax'); ?>">
                    <span class="cart-title"><?php echo esc_html__('My cart','mobimax'); ?></span>
                    <span class="cart-total"><?php echo mobimax_enovathemes_output_html($GLOBALS['woocommerce']->cart->get_total()); ?></span>
                    <span class="cart-info"><?php echo mobimax_enovathemes_output_html($GLOBALS['woocommerce']->cart->cart_contents_count); ?></span>
                </a>
                <?php

                $fragments['a.cart-contents'] = ob_get_clean();
                return $fragments;

            }

        /* Salve flash
        ---------------*/

            function mobimax_enovathemes_custom_product_sale_flash( $output, $post, $product ) {
                global $product;
                if($product->is_on_sale()) {
                    if($product->is_type( 'variable' ) )
                    {
                        $regular_price = $product->get_variation_regular_price();
                        $sale_price = $product->get_variation_price();
                    } else {
                        $regular_price = $product->get_regular_price();
                        $sale_price = $product->get_sale_price();
                    }

                    if (!$product->is_type( 'grouped' )) {

                        $percent_off = (($regular_price - $sale_price) / $regular_price) * 100;
                        if ($percent_off) {
                            return '<span class="onsale">-' . round($percent_off) . '%</span>';
                        }

                    }

                }
            }
            add_filter( 'woocommerce_sale_flash', 'mobimax_enovathemes_custom_product_sale_flash', 11, 3 );

        /* Custom placeholder
        ---------------*/

            add_action( 'init', 'mobimax_enovathemes_custom_placeholder' );
            function mobimax_enovathemes_custom_placeholder() {
                add_filter('woocommerce_placeholder_img_src', 'custom_woocommerce_placeholder_img_src');
                function custom_woocommerce_placeholder_img_src( $src ) {
                    $src = MOBIMAX_ENOVATHEMES_IMAGES . '/placeholder.png';
                    return $src;
                }
            }

        /* Shop loop
        ---------------*/

            remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
            remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
            remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
            remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
            remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

            /* Shop title
            ---------------*/

                add_filter( 'woocommerce_show_page_title' , 'mobimax_enovathemes_woo_hide_page_title' );
                function mobimax_enovathemes_woo_hide_page_title() {
                    return false;
                }

            /* Shop filter
            ---------------*/

                add_action( 'woocommerce_before_shop_loop', 'mobimax_enovathemes_before_shop_loop_open', 15 );
                function mobimax_enovathemes_before_shop_loop_open() {
                    global $mobimax_enovathemes;

                    $product_ajax_filter           = (isset($GLOBALS['mobimax_enovathemes']['product-filter']) && $GLOBALS['mobimax_enovathemes']['product-filter'] == 1) ? "true" : "false";
                    $products_per_page             = (isset($GLOBALS['mobimax_enovathemes']['product-per-page']) && !empty($GLOBALS['mobimax_enovathemes']['product-per-page'])) ? $GLOBALS['mobimax_enovathemes']['product-per-page'] : get_option( 'posts_per_page' );
                    $woocommerce_shop_page_display = get_option( 'woocommerce_shop_page_display' );
                    $paged                         = (get_query_var('page')) ? get_query_var('page') : 1; ?>

                    <?php

                        if ($product_ajax_filter == "true" && (!is_product_category() && !is_product_tag() && !is_search()) && $woocommerce_shop_page_display != "subcategories" && $woocommerce_shop_page_display != "both"){
                            if (function_exists('enovathemes_addons_term_filter')) {
                                echo '<div class="woocommerce-before-shop-loop filter et-clearfix">';
                                $options = array(
                                    'post_type'      => 'product',
                                    'term'           => 'product_cat',
                                    'posts_per_page' => $products_per_page,
                                    'shortcode'      => false,
                                    'order'          => '',
                                    'orderby'        => '',
                                );

                                echo enovathemes_addons_term_filter($options);

                                add_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
                                add_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
                            }
                        } else {
                            echo '<div class="woocommerce-before-shop-loop et-clearfix">';
                            add_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
                            add_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
                        }
                }

                add_action( 'woocommerce_before_shop_loop', 'mobimax_enovathemes_before_shop_loop_close', 40 );
                function mobimax_enovathemes_before_shop_loop_close() {?>

                    </div>

                <?php }

            /* Shop loop item
            ---------------*/

                remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
                remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );

                add_action( 'woocommerce_before_shop_loop_item', 'mobimax_enovathemes_loop_product_inner_open', 10 );
                function mobimax_enovathemes_loop_product_inner_open() { ?>

                    <?php
                        global $mobimax_enovathemes;
                        $product_image_effect = (isset($GLOBALS['mobimax_enovathemes']['product-image-effect']) && $GLOBALS['mobimax_enovathemes']['product-image-effect']) ? $GLOBALS['mobimax_enovathemes']['product-image-effect'] : "overlay-none";
                    ?>

                    <div class="post-inner et-item-inner et-clearfix">

                        <div class="post-inner-wrapper">

                            <?php if(get_option( 'woocommerce_enable_ajax_add_to_cart' ) === "yes"){ ?>
                                <div class="ajax-add-to-cart-loading"><div class="circle-loader"><div class="checkmark draw"></div></div></div>
                            <?php } ?>

                            <?php if ($product_image_effect == "transform"): ?>
                                <div class="overlay-hover">
                            <?php endif ?>

                <?php }

                    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
                    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
                    remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );

                    add_action( 'woocommerce_before_shop_loop_item_title', 'mobimax_enovathemes_loop_product_thumbnail', 10 );
                    function mobimax_enovathemes_loop_product_thumbnail() { ?>

                        <?php
                            global $post, $product, $mobimax_enovathemes;

                            $product_image_full   = (isset($GLOBALS['mobimax_enovathemes']['product-image-full']) && $GLOBALS['mobimax_enovathemes']['product-image-full'] == 1) ? "true" : "false";
                            $product_image_effect = (isset($GLOBALS['mobimax_enovathemes']['product-image-effect']) && $GLOBALS['mobimax_enovathemes']['product-image-effect']) ? $GLOBALS['mobimax_enovathemes']['product-image-effect'] : "overlay-none";

                            $product_id = $product->get_id();
                            $thumb_size = 'woocommerce_thumbnail';

                            if ($product_image_full == "true") {
                                $thumb_size = 'full';
                            }

                            $image_class = array();

                            $image_class[] = 'post-image';
                            $image_class[] = 'post-media';

                            if ($product_image_effect != "transform") {
                                $image_class[] = 'overlay-hover';
                            }

                        ?>

                        <?php if ( $product->is_on_sale() ) : ?>
                            <?php echo apply_filters( 'woocommerce_sale_flash', '<span class="onsale">' . esc_html__( 'Sale!', 'mobimax' ) . '</span>', $post, $product ); ?>
                        <?php endif;?>

                        <div class="<?php echo implode(' ', $image_class); ?>">

                            <?php if (defined('YITH_WCWL')): ?>
                                <?php  echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                            <?php endif ?>

                            <?php if (shortcode_exists('woosc')): ?>
                                <?php echo do_shortcode('[woosc id="'.$product_id.']'); ?>
                            <?php endif ?>

                            <?php if (class_exists('YITH_WCQV_Frontend')): ?>
                                <?php if (get_option('yith-wcqv-enable') == 'yes'): ?>
                                    <?php echo '<a href="#" class="et-button yith-wcqv-button product-single-button product-quick-view medium" data-product_id="' . $product_id . '" title="'.esc_attr__("Product quick view", 'mobimax').'">' . esc_html__("Quick view", 'mobimax') . '</a>'; ?>
                                <?php endif ?>
                            <?php endif ?>

                            <?php if ($product_image_effect != "overlay-none"): ?>
                                <?php echo mobimax_enovathemes_post_image_overlay($product_id); ?>
                                <div class="image-container visible">
                                    <div class="image-loading"></div>
                                    <div class="image-preloader"></div>
                                    <?php if (has_post_thumbnail()): ?>
                                        <?php echo wp_get_attachment_image(get_post_thumbnail_id( $product_id ), $thumb_size,false); ?>
                                    <?php else: ?>
                                        <?php echo wc_placeholder_img($thumb_size); ?>
                                    <?php endif ?>
                                </div>
                            <?php else: ?>
                                <a href="<?php the_permalink(); ?>" >
                                    <div class="product-image-gallery">
                                        <div class="image-container visible">
                                            <div class="image-loading"></div>
                                            <div class="image-preloader"></div>
                                            <?php if (has_post_thumbnail()): ?>
                                                <?php echo wp_get_attachment_image(get_post_thumbnail_id( $product_id ), $thumb_size,false); ?>
                                            <?php else: ?>
                                                <?php echo wc_placeholder_img($thumb_size); ?>
                                            <?php endif ?>
                                        </div>
                                        <?php $product_gallery_ids = $product->get_gallery_image_ids(); ?>
                                        <?php if (is_array($product_gallery_ids) && !empty($product_gallery_ids)): ?>
                                            <?php foreach ($product_gallery_ids as $image_id): ?>
                                                <?php echo wp_get_attachment_image($image_id,$thumb_size,false); ?>
                                            <?php endforeach ?>
                                        <?php endif ?>
                                    </div>
                                </a>
                            <?php endif ?>

                        </div>

                    <?php }

                    remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );

                    add_action( 'woocommerce_shop_loop_item_title', 'mobimax_enovathemes_loop_product_title', 10 );
                    function mobimax_enovathemes_loop_product_title($product_id) { ?>


                        <?php
                            global $mobimax_enovathemes, $product;
                            $product_title_excerpt = (isset($GLOBALS['mobimax_enovathemes']['product-title-excerpt']) && $GLOBALS['mobimax_enovathemes']['product-title-excerpt']) ? $GLOBALS['mobimax_enovathemes']['product-title-excerpt'] : "22";
                        ?>

                        <div class="post-body et-clearfix">
                            <div class="post-body-inner-wrap">
                                <div class="post-body-inner">
                                    <h6 class="post-title et-clearfix">
                                        <a href="<?php the_permalink(); ?>" title="<?php echo esc_attr__("Read more avbout", 'mobimax').' '.the_title_attribute( 'echo=0' ); ?>"><?php echo mb_strimwidth(the_title_attribute( 'echo=0' ),0,$product_title_excerpt,'...'); ?></a>
                                    </h6>

                                    <?php $rating_count = $product->get_rating_count(); ?>

                                    <?php if ($rating_count): ?>
                                        <div class="star-rating-wrap">
                                            <?php woocommerce_template_loop_rating(); ?>
                                            <span><?php echo esc_html($rating_count); ?></span>
                                        </div>
                                    <?php else: ?>
                                        <div class="star-rating-wrap">
                                            <div class="star-rating empty"></div>
                                        </div>
                                    <?php endif ?>


                    <?php }

                add_action( 'woocommerce_after_shop_loop_item', 'mobimax_enovathemes_loop_product_inner_close', 20 );
                function mobimax_enovathemes_loop_product_inner_close() { ?>

                                        <?php
                                            global $mobimax_enovathemes;
                                            $product_image_effect = (isset($GLOBALS['mobimax_enovathemes']['product-image-effect']) && $GLOBALS['mobimax_enovathemes']['product-image-effect']) ? $GLOBALS['mobimax_enovathemes']['product-image-effect'] : "overlay-none";
                                        ?>

                                    </div>
                                </div>
                            </div>

                            <?php if ($product_image_effect == "transform"): ?>
                                </div>
                            <?php endif ?>

                        </div>

                    </div>
                <?php }

            /* Shop navigation
            ---------------*/

                add_action('init','mobimax_enovathemes_woocommerce_pagination_init');
                function mobimax_enovathemes_woocommerce_pagination_init(){

                    global $mobimax_enovathemes;

                    $product_navigation = (isset($GLOBALS['mobimax_enovathemes']['product-navigation']) && $GLOBALS['mobimax_enovathemes']['product-navigation']) ? $GLOBALS['mobimax_enovathemes']['product-navigation'] : "pagination";

                    if ($product_navigation == 'loadmore' || $product_navigation == 'scroll') {
                        remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
                        add_action( 'woocommerce_after_shop_loop', 'mobimax_enovathemes_woocommerce_pagination', 10 );
                        function mobimax_enovathemes_woocommerce_pagination() {

                            global $mobimax_enovathemes;

                            $product_navigation = (isset($GLOBALS['mobimax_enovathemes']['product-navigation']) && $GLOBALS['mobimax_enovathemes']['product-navigation']) ? $GLOBALS['mobimax_enovathemes']['product-navigation'] : "pagination";

                            if (function_exists('enovathemes_addons_ajax_nav')) {
                                echo enovathemes_addons_ajax_nav($product_navigation,'product');
                            } else {
                                echo mobimax_enovathemes_post_nav_num('product');
                            }
                        }

                    }

                }

        /* Category
        ---------------*/

            function mobimax_enovathemes_category_class( $classes, $class, $category= null ){
                $classes[] = 'et-item post';
                return $classes;
            }
            add_filter( 'product_cat_class', 'mobimax_enovathemes_category_class', 10, 3 );

            remove_action( 'woocommerce_before_subcategory', 'woocommerce_template_loop_category_link_open', 10);
            remove_action( 'woocommerce_after_subcategory', 'woocommerce_template_loop_category_link_close', 10);

            remove_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10);
            add_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10);
            if ( ! function_exists( 'woocommerce_template_loop_category_title' ) ) {
                function woocommerce_template_loop_category_title( $category ) {

                        $filter_make  = (isset($_GET["make"]) && !empty($_GET["make"])) ? urldecode($_GET["make"]) : "";
                        $filter_model = (isset($_GET["model"]) && !empty($_GET["model"])) ? urldecode($_GET["model"]) : "";
                        $filter_year  = (isset($_GET["yr"]) && !empty($_GET["yr"])) ? urldecode($_GET["yr"]) : "";
                        $filter_trim  = (isset($_GET["trim"]) && !empty($_GET["trim"])) ? urldecode($_GET["trim"]) : "";

                        $category_link = get_term_link( $category->slug, 'product_cat' );

                        if (!empty($filter_make)) {
                            $category_link .= ('' === get_option( 'permalink_structure' )) ? '&make='.$filter_make : '?make='.$filter_make;
                        }

                        if (!empty($filter_model)) {
                            $category_link .= '&model='.$filter_model;
                        }

                        if (!empty($filter_year)) {
                            $category_link .= '&yr='.$filter_year;
                        }

                        if (!empty($filter_trim)) {
                            $category_link .= '&trim='.$filter_trim;
                        }

                    ?>
                    <h4 class="woocommerce-loop-category__title post-title">
                        <a href="<?php echo esc_url($category_link); ?>" title="<?php echo esc_attr__("View ", 'mobimax').' '.esc_attr( $category->name ); ?>">
                        <?php
                            echo esc_attr($category->name);
                            if ( $category->count > 0 ){
                                echo apply_filters( 'woocommerce_subcategory_count_html', ' <mark class="count">(' . $category->count . ')</mark>', $category );
                            }
                        ?>
                        </a>
                    </h4>
                    <a href="<?php echo esc_url($category_link); ?>" class="button"><?php echo esc_html__("View all","mobimax"); ?></a>
                <?php }
            }

            function mobimax_enovathemes_before_subcategory($category){ ?>
                <div class="post-inner et-item-inner et-clearfix">
                    <div class="post-inner-wrapper">
                        <div class="post-image post-media">

                            <?php

                                $filter_make  = (isset($_GET["make"]) && !empty($_GET["make"])) ? urldecode($_GET["make"]) : "";
                                $filter_model = (isset($_GET["model"]) && !empty($_GET["model"])) ? urldecode($_GET["model"]) : "";
                                $filter_year  = (isset($_GET["yr"]) && !empty($_GET["yr"])) ? urldecode($_GET["yr"]) : "";
                                $filter_trim  = (isset($_GET["trim"]) && !empty($_GET["trim"])) ? urldecode($_GET["trim"]) : "";

                                $category_link = get_term_link( $category->slug, 'product_cat' );

                                if (!empty($filter_make)) {
                                    $category_link .= ('' === get_option( 'permalink_structure' )) ? '&make='.$filter_make : '?make='.$filter_make;
                                }

                                if (!empty($filter_model)) {
                                    $category_link .= '&model='.$filter_model;
                                }

                                if (!empty($filter_year)) {
                                    $category_link .= '&yr='.$filter_year;
                                }

                                if (!empty($filter_trim)) {
                                    $category_link .= '&trim='.$filter_trim;
                                }

                            ?>

                            <a href="<?php echo esc_url($category_link); ?>" title="<?php echo esc_attr__("View ", 'mobimax').' '.esc_attr( $category->name ); ?>">
                                <div class="image-container visible">
                                    <div class="image-loading"></div>
                                    <div class="image-preloader"></div>
            <?php }
            add_filter( 'woocommerce_before_subcategory', 'mobimax_enovathemes_before_subcategory', 10, 2);



            add_filter( 'woocommerce_before_subcategory_title', 'mobimax_enovathemes_before_subcategory_title', 10, 2 );
            function mobimax_enovathemes_before_subcategory_title(){ ?>
                            </div>
                        </a>
                    </div>
                    <div class="post-body et-clearfix">
                        <div class="post-body-inner-wrap">
                            <div class="post-body-inner">
            <?php }

            add_filter( 'woocommerce_after_subcategory_title', 'mobimax_enovathemes_after_subcategory_title', 10, 2 );
            function mobimax_enovathemes_after_subcategory_title(){ ?>
                                </div>
                            </div>
                        </div>
                    </div>

            <?php }

            function mobimax_enovathemes_after_subcategory(){ ?>
                </div>
            <?php }
            add_filter( 'woocommerce_after_subcategory', 'mobimax_enovathemes_after_subcategory', 10, 2 );

            add_action('woocommerce_before_shop_loop','mobimax_enovathemes_woocommerce_maybe_show_product_subcategories',45);
            function mobimax_enovathemes_woocommerce_maybe_show_product_subcategories(){ ?>

                <?php

                global $wp_query;

                $display_type = woocommerce_get_loop_display_mode();
                $filter_make  = (isset($_GET["make"]) && !empty($_GET["make"])) ? urldecode($_GET["make"]) : "";

                if (!empty($filter_make) && function_exists('enovathemes_addons_list_taxonomy_hierarchy_filter')) {

                    $terms = enovathemes_addons_categories_exclude();

                    if (!empty($terms)) {

                        $product_post_size = (isset($GLOBALS['mobimax_enovathemes']['product-post-size']) && $GLOBALS['mobimax_enovathemes']['product-post-size']) ? $GLOBALS['mobimax_enovathemes']['product-post-size'] : "medium";
                        $product_sidebar   = (isset($GLOBALS['mobimax_enovathemes']['product-sidebar']) && $GLOBALS['mobimax_enovathemes']['product-sidebar']) ? $GLOBALS['mobimax_enovathemes']['product-sidebar'] : "none";

                        $columns = ($product_sidebar != "none") ? 4 : 5;

                        $filter_model = (isset($_GET["model"]) && !empty($_GET["model"])) ? urldecode($_GET["model"]) : "";
                        $filter_year  = (isset($_GET["yr"]) && !empty($_GET["yr"])) ? urldecode($_GET["yr"]) : "";
                        $filter_trim  = (isset($_GET["trim"]) && !empty($_GET["trim"])) ? urldecode($_GET["trim"]) : "";

                        $filter = '';

                        if (!empty($filter_make)) {
                            $filter .= ('' === get_option( 'permalink_structure' )) ? '&make='.$filter_make : '?make='.$filter_make;
                        }

                        if (!empty($filter_model)) {
                            $filter .= '&model='.$filter_model;
                        }

                        if (!empty($filter_year)) {
                            $filter .= '&yr='.$filter_year;
                        }

                        if (!empty($filter_trim)) {
                            $filter .= '&trim='.$filter_trim;
                        }

                        $default_title = esc_html__("Select a category...","mobimax");
                        $title         = (is_product_category()) ? $wp_query->get_queried_object()->name : $default_title;

                        $output = '<div class="shop-cat-list-filter">';
                            $output .= '<div class="shop-cat-list-title" data-default-title="'.esc_attr($default_title).'">'.esc_html($title).'<span></span></div>';
                            $output .= '<div class="shop-cat-list-wrapper">';
                                $output .= '<ul class="shop-cat-list column-'.esc_attr($columns).'">';
                                    $output .= enovathemes_addons_list_taxonomy_hierarchy_filter($terms,'product_cat',$filter);
                                $output .= '</ul>';
                            $output .= '</div>';
                        $output .= '</div>';
                        echo mobimax_enovathemes_output_html($output);
                    }
                }

                ?>

            <?php }


            add_action('woocommerce_before_shop_loop','mobimax_enovathemes_woocommerce_banner_area',40);
            function mobimax_enovathemes_woocommerce_banner_area(){ ?>

                <?php get_sidebar('shop-top'); ?>

            <?php }

        /* Single product
        ---------------*/

            add_action( 'woocommerce_before_single_product_summary', 'mobimax_enovathemes_single_product_wrapper_open', 5 );
            function mobimax_enovathemes_single_product_wrapper_open() {?>
                <div class="single-product-wrapper et-clearfix">
            <?php }

                remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );

                function mobimax_enovathemes_single_product_sale_flash() {
                    global $product;
                    if($product->is_on_sale()) {
                        if($product->is_type( 'variable' ) )
                        {

                            $variations = $product->get_available_variations();

                            $all_variation_prices = array();

                            foreach ($variations as $variation) {
                                $variation_prices = array();
                                $variation_prices['regular_price'] = $variation['display_regular_price'];
                                $variation_prices['sale_price']    = $variation['display_price'];

                                array_push($all_variation_prices, $variation_prices);
                            }

                            $all_regular_prices = array();
                            $all_sale_prices    = array();

                            foreach ($all_variation_prices as $variation_price) {
                                array_push($all_regular_prices, $variation_price['regular_price']);
                                array_push($all_sale_prices, $variation_price['sale_price']);
                            }

                            $regular_price = array_sum($all_regular_prices)/count($all_regular_prices);
                            $sale_price    = array_sum($all_sale_prices)/count($all_sale_prices);

                        } else {
                            $regular_price = $product->get_regular_price();
                            $sale_price    = $product->get_sale_price();
                        }

                        if (!$product->is_type( 'grouped' )) {

                            $off = get_woocommerce_currency_symbol().round(($regular_price - $sale_price),2);
                            echo '<span class="onsale"><span class="onsale-inner">' .esc_html__("Save","mobimax").' '.$off . '</span></span>';

                        }
                    }
                }
                add_filter( 'woocommerce_before_single_product_summary', 'mobimax_enovathemes_single_product_sale_flash', 15);

                add_action( 'woocommerce_single_product_summary', 'mobimax_enovathemes_single_product_before_title', 2 );
                function mobimax_enovathemes_single_product_before_title(){ ?>
                    <div class="single-title-wrapper et-clearfix">
                <?php }

                add_action( 'woocommerce_single_product_summary', 'mobimax_enovathemes_single_product_after_title', 6 );
                function mobimax_enovathemes_single_product_after_title(){ ?>
                    </div>
                <?php }

                add_action( 'woocommerce_before_add_to_cart_form', 'mobimax_enovathemes_single_product_stock_sale', 5 );
                function mobimax_enovathemes_single_product_stock_sale() {
                    global $product;

                    if ($product->get_manage_stock() && $product->get_stock_status() == "instock" && $product->get_total_sales()) {

                            $total_sales    = $product->get_total_sales();
                            $stock_quantity = $product->get_stock_quantity();
                            $percent        = ($total_sales/$stock_quantity)*100;

                    ?>
                        <div class="stock-level">
                            <?php if ($total_sales < $stock_quantity &&  shortcode_exists('et_progress')): ?>
                                <span class="already-sold"><?php echo esc_html__("Already sold:","mobimax").' '.mobimax_enovathemes_output_html($total_sales); ?></span>
                                <div class="et-progress single-product-progress">
                                    <div class="track-bar">
                                        <div class="bar" data-percentage="<?php echo esc_attr(round($percent)); ?>"></div>
                                        <div class="track"></div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <span class="already-sold"><?php echo esc_html__("Sold out","mobimax"); ?></span>
                            <?php endif ?>
                        </div>
                    <?php }

                    if($product->is_on_sale()) {

                        $date_on_sale_to = '';

                        if ($product->is_type( 'variable' ) ) {

                            $args = array(
                                'post_type'     => 'product_variation',
                                'post_status'   => array( 'private', 'publish' ),
                                'numberposts'   => -1,
                                'orderby'       => 'menu_order',
                                'order'         => 'asc',
                                'post_parent'   => $product->get_id()
                            );

                            $variations = get_posts( $args );


                            if ($variations) {
                                $all_variation_sale_dates = array();
                                foreach ( $variations as $variation ) {

                                    $sale_price_date_to = get_post_meta( $variation->ID , '_sale_price_dates_to', true );

                                    if (!empty($sale_price_date_to)) {
                                        array_push($all_variation_sale_dates, $sale_price_date_to);
                                    }

                                }

                                if (!empty($all_variation_sale_dates)) {
                                    $date_on_sale_to = max($all_variation_sale_dates);
                                    $date_on_sale_to = date('F j, Y H:i:s',$date_on_sale_to);
                                }

                            }

                        } else {
                            $date_on_sale_to = $product->get_date_on_sale_to();
                            if ($date_on_sale_to) {
                                $date_on_sale_to = $date_on_sale_to->format('F j, Y H:i:s');
                            }
                        }

                        if ($date_on_sale_to && shortcode_exists('et_timer')) {
                            echo '<p class="timer-label">'.esc_html__("Hurry up! Offer ends in:","mobimax").'</p>';
                            echo do_shortcode('[et_timer enddate="'.$date_on_sale_to.'" days="'.esc_html__("Days","mobimax").'" hours="'.esc_html__("Hours","mobimax").'" minutes="'.esc_html__("Minutes","mobimax").'" seconds="'.esc_html__("Seconds","mobimax").'"]');
                        }
                    }
                }

                add_action('init', 'mobimax_enovathemes_single_product');
                function mobimax_enovathemes_single_product(){

                    global $mobimax_enovathemes;

                    $product_single_social  = (isset($GLOBALS['mobimax_enovathemes']['product-single-social']) && $GLOBALS['mobimax_enovathemes']['product-single-social'] == 1) ? "true" : "false";

                    if ($product_single_social == "true") {
                        add_filter( 'woocommerce_product_meta_end', 'mobimax_enovathemes_woocommerce_product_meta_end', 5, 2 );
                        function mobimax_enovathemes_woocommerce_product_meta_end(){ ?>
                            <?php echo enovathemes_addons_post_social_share('styling-original-true'); ?>
                        <?php }
                    }

                }

                remove_action( 'woocommerce_review_before', 'woocommerce_review_display_gravatar', 10 );
                add_action( 'woocommerce_review_before', 'mobimax_enovathemes_woocommerce_review_display_gravatar', 10 );
                function mobimax_enovathemes_woocommerce_review_display_gravatar( $comment ) {
                    echo get_avatar( $comment, apply_filters( 'woocommerce_review_gravatar_size', '72' ), '' );
                }

            add_action( 'woocommerce_after_single_product_summary', 'mobimax_enovathemes_single_product_wrapper_close', 5 );
            function mobimax_enovathemes_single_product_wrapper_close() {?>
                </div>
            <?php }

        /* My account
        ---------------*/

            function mobimax_enovathemes_vehicle( $items ) {

                $items['vehicles'] = esc_html__( 'My vehicles', 'mobimax' );

                return $items;

            }

            add_filter( 'woocommerce_account_menu_items', 'mobimax_enovathemes_vehicle', 10, 1 );

            function mobimax_enovathemes_add_my_account_endpoint() {

                add_rewrite_endpoint( 'vehicles', EP_PAGES );

            }

            add_action( 'init', 'mobimax_enovathemes_add_my_account_endpoint' );

            function mobimax_enovathemes_information_endpoint_content() {
                if (is_user_logged_in()){

                    $output = "";

                    $shop_link = (function_exists('wc_get_page_id')) ? get_permalink( wc_get_page_id( 'shop' ) ) : '';

                    if ('' === get_option( 'permalink_structure' )) {
                        $shop_link = get_home_url().'?post_type=product';
                    }

                    $user_cars         = array();
                    $current_user      = wp_get_current_user();
                    $current_user_cars = get_user_meta( $current_user->ID, 'enovathemes_addons_cars',true);
                    $user_id           = $current_user->ID;

                    if (!empty($current_user_cars)) {
                        $current_user_cars = explode('|', $current_user_cars);
                        foreach ($current_user_cars as $car) {
                            array_push($user_cars, $car);
                        }
                    }

                    if (!empty($user_cars)) {

                        foreach ($user_cars as $car) {

                            $data_car = $car;

                            $car = explode(':', $car);

                            $car_obj = array();
                            $car_obj['make']  = $car[0];
                            $car_obj['model'] = $car[1];
                            $car_obj['year']  = $car[2];
                            $car_obj['trim']  = $car[3];

                            $car_link = $shop_link.'?make='.$car_obj['make'];
                            $car_link .= '&model='.$car_obj['model'];
                            $car_link .= '&yr='.$car_obj['year'];
                            $car_link .= '&trim='.urlencode($car_obj['trim']);

                            $make = get_term_by('id',$car_obj['make'],'product-make');
                            $model = get_term_by('id',$car_obj['model'],'product-model');
                            $trim = get_term_by('id',$car_obj['trim'],'product-trim');

                            $output .= '<li data-car="'.$data_car.'"><span class="remove ien-eclose-3"></span>';
                                $output .= '<a href="'.$car_link.'">';

                                    $output .= '<h6>';
                                        $output .= $car_obj['year'];
                                        if(is_object($make) && !is_wp_error($make)){
                                            $output .= ' '.$make->name.' ';
                                        }
                                        if(is_object($model) && !is_wp_error($model)){
                                            $output .= ' '.$model->name.' ';
                                        }
                                    $output .= '</h6>';

                                    if(is_object($trim) && !is_wp_error($trim)){
                                        $output .= '<span>'.$trim->name.'</span>';
                                    }

                                $output .= '</a>';
                            $output .= '</li>';

                        }
                    }

                    $class = "";

                    if (!empty($output)) {
                        $class = 'visible';
                    }

                    ?>
                        <div class="add-vehicle">
                            <div class="vehicle-header <?php echo esc_attr($class); ?>">
                                <h5><?php echo esc_html__('Vehicles', 'mobimax'); ?></h5>
                                <p><?php echo esc_html__('Click to find parts for the selected vehicle:', 'mobimax'); ?></p>
                            </div>
                            <ul class="user-vehicle-list dashboard">
                                <?php if (!empty($output)): ?>
                                    <?php echo mobimax_enovathemes_output_html($output); ?>
                                <?php endif ?>
                            </ul>
                        </div>
                    <?php
                }
            }

            add_action( 'woocommerce_account_vehicles_endpoint', 'mobimax_enovathemes_information_endpoint_content' );

            function mobimax_enovathemes_woo_my_account_order() {
                $myorder = array(
                    'dashboard'          => esc_html__( 'Dashboard', 'mobimax' ),
                    'vehicles'           => esc_html__( 'My vehicles', 'mobimax' ),
                    'orders'             => esc_html__( 'Orders', 'mobimax' ),
                    'downloads'          => esc_html__( 'Downloads', 'mobimax' ),
                    'edit-address'       => esc_html__( 'Addresses', 'mobimax' ),
                    'edit-account'       => esc_html__( 'Account details', 'mobimax' ),
                    'customer-logout'    => esc_html__( 'Logout', 'mobimax' ),
                );
                return $myorder;
            }
            add_filter ( 'woocommerce_account_menu_items', 'mobimax_enovathemes_woo_my_account_order' );

        /*  Add a custom taxonomy to WooCommerce import/export
        ---------------------*/

            if (defined('ENOVATHEMES_ADDONS')) {

                /* WooCommerce Export
                ---------------------*/

                    function mobimax_enovathemes_add_columns( $columns ) {
                        $columns[ 'vehicle' ]  = 'Vehicle';
                        return $columns;
                    }
                    add_filter( 'woocommerce_product_export_column_names', 'mobimax_enovathemes_add_columns' );
                    add_filter( 'woocommerce_product_export_product_default_columns', 'mobimax_enovathemes_add_columns' );

                    function mobimax_enovathemes_export_vehicle( $value, $product ) {

                        $terms  = get_terms( array( 'object_ids' => $product->get_ID(), 'taxonomy' => 'product-trim' ) );
                        $makes  = get_terms( array( 'object_ids' => $product->get_ID(), 'taxonomy' => 'product-make' ) );
                        $models = get_terms( array( 'object_ids' => $product->get_ID(), 'taxonomy' => 'product-model' ) );

                        $data        = array();
                        $make_array  = array();
                        $model_array = array();

                        if ( ! is_wp_error( $makes ) ) {
                            foreach ( (array) $makes as $term ) {
                                $make_array[$term->term_id] =  $term->name;
                            }
                        }

                        if ( ! is_wp_error( $models ) ) {
                            foreach ( (array) $models as $term ) {
                                $model_array[$term->term_id] =  $term->name;
                            }
                        }

                        if ( ! is_wp_error( $terms ) ) {
                            foreach ( (array) $terms as $term ) {
                                $trim_make  = get_term_meta($term->term_id,'enovathemes_addons_make',true);
                                $trim_model = get_term_meta($term->term_id,'enovathemes_addons_model',true);
                                $trim_year  = get_term_meta($term->term_id,'enovathemes_addons_year',true);

                                if (strpos($trim_year,',') !== false ) {
                                    $trim_year_multiple = explode(',', $trim_year);
                                    $trim_year_multiple = array_unique($trim_year_multiple);
                                    sort($trim_year_multiple);
                                    $trim_year = min($trim_year_multiple).'-'.max($trim_year_multiple);

                                }

                                $vehicle_data = array();

                                if (array_key_exists($trim_make, $make_array)) {
                                    $vehicle_data[] = $make_array[$trim_make];
                                }

                                if (array_key_exists($trim_model, $model_array)) {
                                    $vehicle_data[] = $model_array[$trim_model];
                                }

                                $vehicle_data[]= $trim_year;
                                $vehicle_data[]= $term->name;

                                $data[] =implode(', ', $vehicle_data);
                            }
                        }

                        if (!empty($data)) {
                            $data  = array_unique($data);
                            $value = implode('|', $data);
                        }

                        return $value;
                    }
                    add_filter( 'woocommerce_product_export_product_column_vehicle', 'mobimax_enovathemes_export_vehicle', 10, 2 );

                /* WooCommerce Import
                ---------------------*/

                    function mobimax_enovathemes_map_columns( $columns ) {
                        $columns[ 'vehicle' ]  = 'Vehicle';
                        return $columns;
                    }
                    add_filter( 'woocommerce_csv_product_import_mapping_options', 'mobimax_enovathemes_map_columns' );

                    function mobimax_enovathemes_add_columns_to_mapping_screen( $columns ) {
                        $columns['Vehicle']   = 'vehicle';
                        return $columns;
                    }
                    add_filter( 'woocommerce_csv_product_import_mapping_default_columns', 'mobimax_enovathemes_add_columns_to_mapping_screen' );

                    function mobimax_enovathemes_parse_taxonomy_explode( $parsed_data, $importer ) {

                        if ( ! empty( $parsed_data[ 'vehicle' ] ) ) {
                            $data = explode('|',$parsed_data[ 'vehicle' ]);
                            if ( is_array( $data ) ) {
                                unset( $parsed_data[ 'vehicle' ] );
                                $parsed_data[ 'vehicle' ] = array();
                                foreach ( $data as $vehicle_data ) {
                                    $parsed_data[ 'vehicle' ][] = $vehicle_data;
                                }
                            }
                        }

                        return $parsed_data;
                    }
                    add_filter( 'woocommerce_product_importer_parsed_data', 'mobimax_enovathemes_parse_taxonomy_explode', 10, 2 );

                    function mobimax_enovathemes_set_taxonomy( $product, $data ) {
                        if ( is_a( $product, 'WC_Product' ) ) {
                            if( ! empty( $data[ 'vehicle' ] ) ) {

                                $makes  = array();
                                $models = array();
                                $trim   = array();

                                $trim_data  = array();
                                $model_data = array();

                                if (is_array($data[ 'vehicle' ])) {
                                    foreach ($data[ 'vehicle' ] as $vehicle_data) {

                                        $vehicle_data = explode(", ", $vehicle_data);

                                        $model_data[$vehicle_data[1]] = $vehicle_data[0];

                                        array_push($makes, $vehicle_data[0]);
                                        array_push($models, $vehicle_data[1]);

                                        if (sizeof($vehicle_data) == 4) {
                                            $trim_data[$vehicle_data[3]]  = array($vehicle_data[0],$vehicle_data[1],$vehicle_data[2]);
                                            array_push($trim, $vehicle_data[3]);
                                        }

                                    }
                                } else {
                                    $vehicle_data = explode(", ", $data[ 'vehicle' ]);

                                        $model_data[$vehicle_data[1]] = $vehicle_data[0];

                                        array_push($makes, $vehicle_data[0]);
                                        array_push($models, $vehicle_data[1]);

                                        if (sizeof($vehicle_data) == 4) {
                                            $trim_data[$vehicle_data[3]]  = array($vehicle_data[0],$vehicle_data[1],$vehicle_data[2]);
                                            array_push($trim, $vehicle_data[3]);
                                        }
                                }



                                $makes  = array_unique($makes);
                                $models = array_unique($models);
                                $trim   = array_unique($trim);

                                if (!empty($makes)) {
                                    wp_set_object_terms( $product->get_id(),  (array) $makes, 'product-make' );
                                }

                                if (!empty($models)) {
                                    wp_set_object_terms( $product->get_id(),  (array) $models, 'product-model' );
                                }

                                if (!empty($trim)) {
                                    wp_set_object_terms( $product->get_id(),  (array) $trim, 'product-trim' );
                                }

                                $trim  = get_terms( array( 'object_ids' => $product->get_ID(), 'taxonomy' => 'product-trim' ) );
                                if ( ! is_wp_error( $trim ) && !empty($trim_data)) {
                                    foreach ( (array) $trim as $term ) {
                                        if (array_key_exists($term->name,$trim_data)) {

                                            $the_make = get_term_by('name',$trim_data[$term->name][0],'product-make');
                                            $the_model = get_term_by('name',$trim_data[$term->name][1],'product-model');

                                            if (!is_wp_error($the_make)) {
                                                update_term_meta( $term->term_id,'enovathemes_addons_make',$the_make->term_id);
                                            }

                                            if (!is_wp_error($the_model)) {
                                                update_term_meta( $term->term_id,'enovathemes_addons_model',$the_model->term_id);
                                            }

                                            update_term_meta( $term->term_id,'enovathemes_addons_year',str_replace(' ',',',$trim_data[$term->name][2]));
                                        }

                                    }
                                }

                                $model  = get_terms( array( 'object_ids' => $product->get_ID(), 'taxonomy' => 'product-model' ) );
                                if ( ! is_wp_error( $model ) && !empty($model_data)) {
                                    foreach ( (array) $model as $term ) {
                                        if (array_key_exists($term->name,$model_data)) {

                                            $the_make = get_term_by('name',$model_data[$term->name],'product-make');
                                            if (!is_wp_error($the_make)) {
                                                update_term_meta( $term->term_id,'enovathemes_addons_make',$the_make->term_id);
                                            }
                                        }

                                    }
                                }

                            }
                        }
                        return $product;
                    }
                    add_filter( 'woocommerce_product_import_inserted_product_object', 'mobimax_enovathemes_set_taxonomy', 10, 2 );


                /* WP All Import
                ---------------------*/

                    add_action( 'pmxi_saved_post', 'mobimax_enovathemes_saved_post', 10, 3 );
                    function mobimax_enovathemes_saved_post( $post_id, $xml_node, $is_update ) {
                        $txes_list = get_the_terms($post_id, 'product-trim');
                        if ( ! empty($txes_list) ){

                            $makes      = array();
                            $models     = array();
                            $model_data = array();
                            $trim_data  = array();

                            foreach ($txes_list as $trim){
                                $vehicle = explode(', ', $trim->name);

                                $model_data[$vehicle[1]] = $vehicle[0];

                                if (sizeof($vehicle) == 4) {
                                    $trim_data[$vehicle[3]]  = array($vehicle[0],$vehicle[1],$vehicle[2]);
                                    array_push($trims, $vehicle[3]);
                                }

                                array_push($makes, $vehicle[0]);
                                array_push($models, $vehicle[1]);

                                wp_update_term($trim->term_id, 'product-trim', array(
                                    'name' => $vehicle[3],
                                    'slug' => sanitize_title($vehicle[3])
                                ));

                            }

                            $makes  = array_unique($makes);
                            $models = array_unique($models);

                            if (!empty($makes)) {
                                wp_set_object_terms( $post_id,  (array) $makes, 'product-make' );
                            }
                            if (!empty($models)) {
                                wp_set_object_terms( $post_id,  (array) $models, 'product-model' );
                            }

                            $trim = get_the_terms($post_id, 'product-trim');

                            if ( ! is_wp_error( $trim ) && !empty($trim_data)) {
                                foreach ( (array) $trim as $term ) {
                                    if (array_key_exists($term->name,$trim_data)) {

                                        $the_make = get_term_by('name',$trim_data[$term->name][0],'product-make');
                                        $the_model = get_term_by('name',$trim_data[$term->name][1],'product-model');

                                        if (!is_wp_error($the_make)) {
                                            update_term_meta( $term->term_id,'enovathemes_addons_make',$the_make->term_id);
                                        }

                                        if (!is_wp_error($the_model)) {
                                            update_term_meta( $term->term_id,'enovathemes_addons_model',$the_model->term_id);
                                        }

                                        update_term_meta( $term->term_id,'enovathemes_addons_year',str_replace(' ',',',$trim_data[$term->name][2]));
                                    }

                                }
                            }

                            $model  = get_the_terms($post_id, 'product-model');;
                            if ( ! is_wp_error( $model ) && !empty($model_data)) {
                                foreach ( (array) $model as $term ) {
                                    if (array_key_exists($term->name,$model_data)) {

                                        $the_make = get_term_by('name',$model_data[$term->name],'product-make');
                                        if (!is_wp_error($the_make)) {
                                            update_term_meta( $term->term_id,'enovathemes_addons_make',$the_make->term_id);
                                        }
                                    }

                                }
                            }

                        }
                    }
            }

    }

/* Scripts
---------------*/

    function mobimax_enovathemes_scripts_styles_general() {

        global $mobimax_enovathemes;

        wp_enqueue_style('mobimax-style', get_stylesheet_uri() );

        wp_enqueue_style( 'mobimax-default-fonts', mobimax_enovathemes_fonts_url(), array(), '1.0.0' );

        if (isset($GLOBALS['mobimax_enovathemes']['disable-defaults']) && $GLOBALS['mobimax_enovathemes']['disable-defaults'] == 1) {
            wp_dequeue_style( 'mobimax-default-fonts' );
        }

        if ( is_singular() && get_option( 'thread_comments' ) ) {
            wp_enqueue_script( 'comment-reply' );
        }

        wp_enqueue_script( 'modernizr', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/modernizr.js', array(), false);

        if (isset($GLOBALS['mobimax_enovathemes']['smooth-scroll']) && $GLOBALS['mobimax_enovathemes']['smooth-scroll'] == 1) {
            wp_enqueue_script( 'smoothpagescroll', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/smoothPageScroll.min.js', array('jquery'), '', true);
        }

        // dequeue
        wp_dequeue_style( 'yith-wcwl-font-awesome' );
        wp_deregister_style( 'yith-wcwl-font-awesome' );
        wp_dequeue_style( 'woocommerce_prettyPhoto_css' );
        wp_deregister_style( 'woocommerce_prettyPhoto_css' );

    }

    function mobimax_enovathemes_scripts() {

        global $mobimax_enovathemes,$wp_query;

        if (isset($GLOBALS['mobimax_enovathemes']['google-map-api']) && !empty($GLOBALS['mobimax_enovathemes']['google-map-api'])) {
            wp_enqueue_script( 'mobimax-gmap', '//maps.google.com/maps/api/js?key='.esc_attr($GLOBALS['mobimax_enovathemes']['google-map-api']), array(), false);
        }

        wp_enqueue_script( 'imagesloaded');
        wp_enqueue_script( 'hoverIntent');

        wp_enqueue_script( 'plyr', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/plyr.min.js', array('jquery'), '', true);

        if (!is_admin()) {

            if (class_exists('Woocommerce')){
                wp_enqueue_script( 'wc-cart-fragments');
            }

            wp_enqueue_script( 'jquery-masonry');

            if (isset($GLOBALS['mobimax_enovathemes']['combine-scripts']) && $GLOBALS['mobimax_enovathemes']['combine-scripts'] == 1) {
                wp_enqueue_script( 'controller', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/controller-combined.js', array('jquery'), '', true);
            } else {
                wp_enqueue_script( 'nice-scroll', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/nice-scroll.js', array('jquery'), '', true);
                wp_enqueue_script( 'classie', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/classie.js', array('jquery'), '', true);
                wp_enqueue_script( 'waypoint', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/waypoint.js', array('jquery'), '', true);
                wp_enqueue_script( 'easing', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/easing.js', array('jquery'), '', true);
                wp_enqueue_script( 'mobile-events', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/mobile-events.js', array('jquery'), '', true);
                wp_enqueue_script( 'easy-pie-chart', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/easy-pie-chart.js', array('jquery'), '', true);
                wp_enqueue_script( 'flex-slider', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/flex-slider.js', array('jquery'), '', true);
                wp_enqueue_script( 'mousewheel', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/mousewheel.js', array('jquery'), '', true);
                wp_enqueue_script( 'from-to', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/from-to.js', array('jquery'), '', true);
                wp_enqueue_script( 'count-down', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/count-down.js', array('jquery'), '', true);
                wp_enqueue_script( 'tooltip', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/tooltip.js', array('jquery'), '', true);
                wp_enqueue_script( 'overlay-fluid', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/overlay-fluid.js', array('jquery'), '', true);
                wp_enqueue_script( 'nivolightbox', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/nivolightbox.js', array('jquery'), '', true);
                wp_enqueue_script( 'slick-carousel', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/slick-carousel.js', array('jquery'), '', true);
                wp_enqueue_script( 'footer-sticky', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/footer-sticky.js', array('jquery'), '', true);
                wp_enqueue_script( 'cookie', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/cookie.js', array('jquery'), '', true);
                wp_enqueue_script( 'typeit', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/typeit.js', array('jquery'), '', true);
                wp_enqueue_script( 'sticky-kit', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/sticky-kit.js', array('jquery'), '', true);
                wp_enqueue_script( 'owl-carousel', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/owl-carousel.js', array('jquery'), '', true);
                wp_enqueue_script( 'isotop', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/isotop.js', array('jquery'), '', true);
                wp_enqueue_script( 'photoswip', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/photoswip.js', array('jquery'), '', true);
                wp_enqueue_script( 'plyr', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/plyr.min.js', array('jquery'), '', true);
                wp_enqueue_script( 'controller', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/controller.js', array('jquery'), '', true);
            }

            $custom_scroll                    = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll']) && $GLOBALS['mobimax_enovathemes']['custom-scroll'] == 1) ? "true" : "false";
            $custom_scroll_cursorcolor        = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll-cursorcolor']) && !empty($GLOBALS['mobimax_enovathemes']['custom-scroll-cursorcolor'])) ? $GLOBALS['mobimax_enovathemes']['custom-scroll-cursorcolor'] : '#222222';
            $custom_scroll_railcolor          = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll-railcolor']) && !empty($GLOBALS['mobimax_enovathemes']['custom-scroll-railcolor'])) ? $GLOBALS['mobimax_enovathemes']['custom-scroll-railcolor'] : '#666666';
            $custom_scroll_cursoropacitymin   = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll-cursoropacitymin']) && !empty($GLOBALS['mobimax_enovathemes']['custom-scroll-cursoropacitymin'])) ? $GLOBALS['mobimax_enovathemes']['custom-scroll-cursoropacitymin'] : '100';
            $custom_scroll_cursoropacitymax   = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll-cursoropacitymax']) && !empty($GLOBALS['mobimax_enovathemes']['custom-scroll-cursoropacitymax'])) ? $GLOBALS['mobimax_enovathemes']['custom-scroll-cursoropacitymax'] : '100';
            $custom_scroll_cursorwidth        = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll-cursorwidth']) && !empty($GLOBALS['mobimax_enovathemes']['custom-scroll-cursorwidth'])) ? $GLOBALS['mobimax_enovathemes']['custom-scroll-cursorwidth'] : '10';
            $custom_scroll_cursorborderradius = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll-cursorborderradius']) && !empty($GLOBALS['mobimax_enovathemes']['custom-scroll-cursorborderradius'])) ? $GLOBALS['mobimax_enovathemes']['custom-scroll-cursorborderradius'] : '5';
            $custom_scroll_scrollspeed        = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll-scrollspeed']) && !empty($GLOBALS['mobimax_enovathemes']['custom-scroll-scrollspeed'])) ? $GLOBALS['mobimax_enovathemes']['custom-scroll-scrollspeed'] : '60';
            $custom_scroll_mousescrollstep    = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll-mousescrollstep']) && !empty($GLOBALS['mobimax_enovathemes']['custom-scroll-mousescrollstep'])) ? $GLOBALS['mobimax_enovathemes']['custom-scroll-mousescrollstep'] : '40';
            $custom_scroll_mousescrollstep    = (isset($GLOBALS['mobimax_enovathemes']['custom-scroll-mousescrollstep']) && !empty($GLOBALS['mobimax_enovathemes']['custom-scroll-mousescrollstep'])) ? $GLOBALS['mobimax_enovathemes']['custom-scroll-mousescrollstep'] : '40';

            $post_paged       = (get_query_var('page')) ? get_query_var('page') : 1;
            $post_max         = $wp_query->max_num_pages;
            $product_max      = (empty($product_per_page)) ? $wp_query->max_num_pages : ceil($wp_query->found_posts/$product_per_page);

            wp_localize_script(
                'controller',
                'controller_opt',
                array(
                    'customScroll'                   => $custom_scroll,
                    'customScrollCursorcolor'        => $custom_scroll_cursorcolor,
                    'customScrollRailcolor'          => $custom_scroll_railcolor,
                    'customScrollCursorOpacityMin'   => $custom_scroll_cursoropacitymin,
                    'customScrollCursorOpacityMax'   => $custom_scroll_cursoropacitymax,
                    'customScrollCursorWidth'        => $custom_scroll_cursorwidth,
                    'customScrollCursorBorderRadius' => $custom_scroll_cursorborderradius,
                    'customScrollScrollSpeed'        => $custom_scroll_scrollspeed,
                    'customScrollMouseScrollStep'    => $custom_scroll_mousescrollstep,
                    'postMax'                        => $post_max,
                    'productMax'                     => $product_max,
                    'postStartPage'                  => $post_paged,
                    'postNextLink'                   => next_posts($post_max, false),
                    'productNextLink'                => next_posts($product_max, false),
                    'filterMore'                     => esc_html__("More", 'mobimax'),
                    'filterLess'                     => esc_html__("Less", 'mobimax'),
                    'postNoText'                     => esc_html__("No more posts", 'mobimax'),
                    'productNoText'                  => esc_html__("No more products", 'mobimax'),
                    'postLoadingText'                => esc_html__("Loading posts", 'mobimax'),
                    'productLoadingText'             => esc_html__("Loading products", 'mobimax'),
                    'ajaxError'                      => esc_html__("Something went wrong, please try again later or contact the site administrator", "mobimax"),
                    'ajaxurl'                        => admin_url( 'admin-ajax.php', 'relative' ),
                )
            );

            if (is_page()) {

                $one_page = get_post_meta( get_the_ID(), 'enovathemes_addons_one_page', true );

                if ($one_page == "on") {

                    $one_page_speed  = ($GLOBALS['mobimax_enovathemes']['one-page-speed']) ? esc_js($GLOBALS['mobimax_enovathemes']['one-page-speed']) : 750;
                    $one_page_hash   = ($GLOBALS['mobimax_enovathemes']['one-page-hash'] && $GLOBALS['mobimax_enovathemes']['one-page-hash'] == 1) ? 'true' : 'false';
                    $one_page_filter = (isset($GLOBALS['mobimax_enovathemes']['one-page-filter']) && $GLOBALS['mobimax_enovathemes']['one-page-filter']) ? explode(',',esc_attr($GLOBALS['mobimax_enovathemes']['one-page-filter'])) : '';
                    $et_filter_array = array();

                    if (is_array($one_page_filter)) {
                        foreach ($one_page_filter as $filter) {
                            array_push($et_filter_array, '#'.$filter.' > a');
                        }
                    }

                    wp_enqueue_script( 'mobimax-single-page-nav', MOBIMAX_ENOVATHEMES_TEMPPATH.'/js/single-page-nav.js', array('jquery'), '', true);
                    wp_localize_script(
                        'mobimax-single-page-nav',
                        'single_page_nav_opt',
                        array(
                            'speed'       => $one_page_speed,
                            'hash'        => $one_page_hash,
                            'filterArray' => (!empty($et_filter_array)) ? implode(', ', $et_filter_array) : ''
                        )
                    );

                }
            }

        }

        if (is_admin()) {
            $screen = get_current_screen();
            if (class_exists('WPBakeryShortCodesContainer') && $screen->base != 'toplevel_page_revslider') {
                wp_enqueue_script( 'plugins', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/plugins-combined.js', array('jquery'), '', true);
            }
        }

    }

    function mobimax_enovathemes_admin_scripts_styles() {
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_script( 'wp-color-picker' );
        wp_enqueue_script( 'jquery-ui-draggable' );
        wp_enqueue_script( 'jquery-ui-droppable' );
        wp_enqueue_style( 'mobimax-admin', MOBIMAX_ENOVATHEMES_TEMPPATH . '/css/admin.css', false, '');
        wp_enqueue_script( 'mobimax-admin', MOBIMAX_ENOVATHEMES_TEMPPATH . '/js/admin.js', array('jquery'), '', true);
        wp_localize_script(
            'mobimax-admin',
            'admin_opt',
            array(
                'adminAJAXError' => esc_html__("Something went wrong, please contact the developer", 'mobimax'),
                'ajaxUrl'        => admin_url('admin-ajax.php'),
                'homeurl'        => esc_url(home_url('/')),
                'restUrlProduct' => rest_url('wp/v2/product'),
                'jsonUrl'        => rest_url('wp/v2/product-model'),
                'jsonUrl2'       => rest_url('wp/v2/product-trim'),
                'enovaRest'      => rest_url('enovathemes/v1/trim-model/'),
                'enovaRestMake'  => rest_url('enovathemes/v1/model-make/'),
            )
        );
        return;
    }

    add_action( 'wp_enqueue_scripts', 'mobimax_enovathemes_scripts_styles_general');
    add_action( 'wp_enqueue_scripts', 'mobimax_enovathemes_scripts');

    add_action('admin_enqueue_scripts','mobimax_enovathemes_scripts');
    add_action('admin_enqueue_scripts','mobimax_enovathemes_admin_scripts_styles');

    function mobimax_enovathemes_editor_styles() {
        wp_enqueue_style('mobimax-default-fonts', '//fonts.googleapis.com/css?family=Montserrat:300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i' );
        wp_enqueue_style( 'mobimax-editor-style', MOBIMAX_ENOVATHEMES_TEMPPATH . '/css/editor-style.css' );

    }
    add_action( 'enqueue_block_editor_assets', 'mobimax_enovathemes_editor_styles' );
?>
