<?php

/* vc defaults
---------------*/

	vc_remove_param('vc_section', 'full_width');
	vc_remove_param('vc_row', 'full_width');
	vc_remove_param('vc_row_inner', 'gap');
	vc_remove_param('vc_row', 'gap');
	vc_remove_param('vc_row', 'parallax');
	vc_remove_param('vc_row', 'parallax_image');
	vc_remove_param('vc_row', 'video_bg');
	vc_remove_param('vc_row', 'video_bg_url');
	vc_remove_param('vc_row', 'video_bg_parallax');
	vc_remove_param('vc_row', 'parallax_speed_bg');
	vc_remove_param('vc_row', 'parallax_speed_video');

/* vc_row
---------------*/

	/* defaults
	---------------*/

		vc_add_param('vc_row', array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Row stretch', 'mobimax' ),
			'param_name' => 'full_width',
			'value'      => array(
				esc_html__( 'No stretching', 'mobimax' )           => 'stretch_no',
				esc_html__( 'Stretch row and content', 'mobimax' ) => 'stretch_row_content',
			),
			'weight' => 1,
			'description' => esc_html__( '"No stretching" alignes the row with the main theme container, Stretch row and content" makes the row and content full width', 'mobimax' )
		));

		$column_gap_values = array(
			esc_html__('0px', 'mobimax')    => '0',
			esc_html__('2px', 'mobimax')    => '2',
			esc_html__('4px', 'mobimax')    => '4',
			esc_html__('8px', 'mobimax')    => '8',
			esc_html__('16px', 'mobimax')   => '16',
			esc_html__('24px', 'mobimax')   => '24',
			esc_html__('32px', 'mobimax')   => '32',
			esc_html__('40px', 'mobimax')   => '40',
			esc_html__('48px', 'mobimax')   => '48',
			esc_html__('56px', 'mobimax')   => '56',
			esc_html__('64px', 'mobimax')   => '64',
			esc_html__('72px', 'mobimax')   => '72',
			esc_html__('80px', 'mobimax')   => '80',
		);

		vc_add_param('vc_row', array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Columns gap', 'mobimax' ),
			'param_name' => 'gap',
			'weight'     => 1,
			'value'      => $column_gap_values,
			'std' => '24'
		));

		vc_add_param('vc_row_inner', array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Columns gap', 'mobimax' ),
			'param_name' => 'gap',
			'weight'     => 1,
			'value'      => $column_gap_values,
			'std' => '24'
		));

		vc_add_param('vc_row_inner', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Z index (integer without any string)', 'mobimax' ),
			'description'=> esc_html__( 'Higher value places the row on top', 'mobimax' ),
			'param_name' => 'z_index',
		));

		vc_add_param('vc_row_inner', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Height in px (without any string)', 'mobimax' ),
			'param_name' => 'row_height',
		));

		vc_add_param('vc_row_inner', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Height in px for sticky header version (without any string)', 'mobimax' ),
			'param_name' => 'row_height_sticky',
		));

		vc_add_param('vc_row_inner', array(
			'type'       => 'checkbox',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Hide on sticky header version?', 'mobimax' ),
			'param_name' => 'hide_row_sticky',
		));

		vc_add_param('vc_row_inner', array(
			'type'       => 'textfield',
			'heading'    => esc_html__('Element id','mobimax'),
			'group'      => esc_html__('Header builder','mobimax'),
			"class"      => "element-attr-hide",
			'param_name' => 'element_id',
			'value'      => '',
		));

		vc_add_param('vc_row_inner', array(
			'type'       => 'textarea',
			'heading'    => esc_html__('Element css','mobimax'),
			'group'      => esc_html__('Header builder','mobimax'),
			"class"      => "element-attr-hide",
			'param_name' => 'element_css',
			'value'      => '',
		));

	/* parallax
	---------------*/

		vc_add_param('vc_row', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Parallax background', 'mobimax' ),
			'param_name' => 'parallax',
			'group'      => esc_html__('Background options','mobimax'),
		));

		vc_add_param('vc_row', array(
			'type'       => 'attach_image',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Parallax image', 'mobimax' ),
			'param_name' => 'parallax_image',
			'dependency' => Array('element' => 'parallax', 'value' => 'true')
		));

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Parallax speed', 'mobimax' ),
			'param_name' => 'parallax_speed_bg',
			'description'=> esc_html__('Enter parallax speed ratio (Note: Default value is 1.5, min value is 1)','mobimax'),
			'dependency' => Array('element' => 'parallax', 'value' => 'true'),
			'default'    => '1.5'
		));

	/* video
	---------------*/

		vc_add_param('vc_row', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Background video', 'mobimax' ),
			'param_name' => 'video_bg',
			'group'      => esc_html__('Background options','mobimax'),
		));

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Background video mp4 file url', 'mobimax' ),
			'param_name' => 'video_bg_mp4',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Background video webm file url', 'mobimax' ),
			'param_name' => 'video_bg_webm',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Background video ogv file url', 'mobimax' ),
			'param_name' => 'video_bg_ogv',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_row', array(
			'type'       => 'attach_image',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Video overlay', 'mobimax' ),
			'param_name' => 'video_bg_overlay',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_row', array(
			'type'       => 'attach_image',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Video placeholder', 'mobimax' ),
			'param_name' => 'video_bg_placeholder',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_row', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Video parallax', 'mobimax' ),
			'param_name' => 'video_bg_parallax',
			'group'      => esc_html__('Background options','mobimax'),
			'dependency' => Array(
				'element' => 'video_bg', 'value' => 'true',

			)
		));

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Background video parallax speed', 'mobimax' ),
			'param_name' => 'video_bg_parallax_speed',
			'description'=> esc_html__('Enter parallax speed ratio (Note: Default value is 1.5, min value is 1)','mobimax'),
			'dependency' => Array(
				'element' => 'video_bg_parallax', 'value' => 'true',
			),
			'default'    => '1.5'
		));

	/* fixed
	---------------*/

		vc_add_param('vc_row', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Fixed background', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'fixed_bg',
		));

		vc_add_param('vc_row', array(
			'type'       => 'attach_image',
			'heading'    => esc_html__( 'Fixed background image', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'fixed_bg_image',
			'dependency' => Array('element' => 'fixed_bg', 'value' => 'true')
		));

	/* animated
	---------------*/

		vc_add_param('vc_row', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Animated background', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'animated_bg',
		));

		vc_add_param('vc_row', array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Animated background direction', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'animated_bg_dir',
			'value'     => array(
				esc_html__('Horizontal','mobimax')  => 'horizontal',
				esc_html__('Vertical','mobimax')  => 'vertical',
			),
			'dependency' => Array('element' => 'animated_bg', 'value' => 'true')
		));

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'heading'    => esc_html__( 'Animated background speed in ms (default is 35000)', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'animated_bg_speed',
			'dependency' => Array('element' => 'animated_bg', 'value' => 'true')
		));

		vc_add_param('vc_row', array(
			'type'       => 'attach_image',
			'heading'    => esc_html__( 'Animated background image', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'animated_bg_image',
			'dependency' => Array('element' => 'animated_bg', 'value' => 'true')
		));

	/* header buiilder tab
	---------------*/

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Height in px (without any string)', 'mobimax' ),
			'param_name' => 'row_height',
		));

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Z index (integer without any string)', 'mobimax' ),
			'description'=> esc_html__( 'Higher value places the row on top', 'mobimax' ),
			'param_name' => 'z_index',
		));

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Height in px for sticky header version (without any string)', 'mobimax' ),
			'param_name' => 'row_height_sticky',
		));

		vc_add_param('vc_row', array(
			'type'       => 'colorpicker',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Background color of sticky header version', 'mobimax' ),
			'param_name' => 'row_background_sticky',
		));

		vc_add_param('vc_row', array(
			'type'       => 'checkbox',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Hide from default header version?', 'mobimax' ),
			'param_name' => 'hide_row_default',
		));

		vc_add_param('vc_row', array(
			'type'       => 'checkbox',
			'group'      => esc_html__('Header builder','mobimax'),
			'heading'    => esc_html__( 'Hide on sticky header version?', 'mobimax' ),
			'param_name' => 'hide_row_sticky',
		));

		vc_add_param('vc_row', array(
			'type'       => 'textfield',
			'heading'    => esc_html__('Element id','mobimax'),
			'group'      => esc_html__('Header builder','mobimax'),
			"class"      => "element-attr-hide",
			'param_name' => 'element_id',
			'value'      => '',
		));

		vc_add_param('vc_row', array(
			'type'       => 'textarea',
			'heading'    => esc_html__('Element css','mobimax'),
			'group'      => esc_html__('Header builder','mobimax'),
			"class"      => "element-attr-hide",
			'param_name' => 'element_css',
			'value'      => '',
		));

	/* mobimax
	---------------*/

		vc_add_param('vc_row', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Top gradient border', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'top_gradient',
		));

		vc_add_param('vc_row', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Bottom gradient border', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'bottom_gradient',
		));

		vc_add_param('vc_row', array(
			'type'       => 'colorpicker',
			'heading'    => esc_html__( 'Gradient border color', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'gradient_color',
			'default'    => '#ffffff'
		));

/* vc_column
---------------*/

	vc_remove_param('vc_column', 'parallax');
	vc_remove_param('vc_column', 'parallax_image');
	vc_remove_param('vc_column', 'video_bg');
	vc_remove_param('vc_column', 'video_bg_url');
	vc_remove_param('vc_column', 'video_bg_parallax');
	vc_remove_param('vc_column', 'parallax_speed_bg');
	vc_remove_param('vc_column', 'parallax_speed_video');

	$animation_delay_values = array();

	for ($i=0; $i <= 2000; $i = $i + 50) {
		$animation_delay_values[$i.esc_html__('ms', 'mobimax')] = $i;
	}

	vc_add_param('vc_column', array(
		'type'       => 'dropdown',
		'heading'    => esc_html__( 'Animation delay in ms (example 300)', 'mobimax' ),
		'param_name' => 'animation_delay',
		'weight'     => 1,
		'value'      => $animation_delay_values
	));

	vc_add_param('vc_column', array(
		'type'       => 'dropdown',
		'heading'    => esc_html__( 'Text align', 'mobimax' ),
		'param_name' => 'text_align',
		'value'      => array(
			esc_html__('None','mobimax')   => 'none',
			esc_html__('Left','mobimax')   => 'left',
			esc_html__('Right','mobimax')  => 'right',
			esc_html__('Center','mobimax') => 'center'
		)
	));

	vc_add_param('vc_column', array(
		'type'       => 'checkbox',
		'heading'    => esc_html__( 'Shadow', 'mobimax' ),
		'group'      => esc_html__( 'Design Options', 'mobimax' ),
		'param_name' => 'shadow',
		'weight'     => 1,
		'value'      => ''
	));

	vc_add_param('vc_column', array(
		'type'       => 'crp',
		'heading'    => esc_html__( 'Responsive padding', 'mobimax' ),
		'group'      => esc_html__('Responsive Options','mobimax'),
		'param_name' => 'crp',
	));

	vc_add_param('vc_column', array(
		'type'       => 'textfield',
		'heading'    => esc_html__('Element id','mobimax'),
		"class"      => "element-attr-hide",
		'param_name' => 'element_id',
		'value'      => '',
	));

	vc_add_param('vc_column', array(
		'type'       => 'textarea',
		'heading'    => esc_html__('Element css','mobimax'),
		"class"      => "element-attr-hide",
		'param_name' => 'element_css',
		'value'      => '',
	));

	vc_add_param('vc_column_inner', array(
		'type'       => 'crp',
		'heading'    => esc_html__( 'Responsive padding', 'mobimax' ),
		'group'      => esc_html__('Responsive Options','mobimax'),
		'param_name' => 'crp',
	));

	vc_add_param('vc_column_inner', array(
		'type'       => 'textfield',
		'heading'    => esc_html__('Element id','mobimax'),
		"class"      => "element-attr-hide",
		'param_name' => 'element_id',
		'value'      => '',
	));

	vc_add_param('vc_column_inner', array(
		'type'       => 'textarea',
		'heading'    => esc_html__('Element css','mobimax'),
		"class"      => "element-attr-hide",
		'param_name' => 'element_css',
		'value'      => '',
	));

	/* parallax
	---------------*/

		vc_add_param('vc_column', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Parallax background', 'mobimax' ),
			'param_name' => 'parallax',
			'group'      => esc_html__('Background options','mobimax'),
		));

		vc_add_param('vc_column', array(
			'type'       => 'attach_image',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Parallax image', 'mobimax' ),
			'param_name' => 'parallax_image',
			'dependency' => Array('element' => 'parallax', 'value' => 'true')
		));

		vc_add_param('vc_column', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Parallax speed', 'mobimax' ),
			'param_name' => 'parallax_speed_bg',
			'description'=> esc_html__('Enter parallax speed ratio (Note: Default value is 1.5, min value is 1)','mobimax'),
			'dependency' => Array('element' => 'parallax', 'value' => 'true'),
			'default'    => '1.5'
		));

	/* video
	---------------*/

		vc_add_param('vc_column', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Background video', 'mobimax' ),
			'param_name' => 'video_bg',
			'group'      => esc_html__('Background options','mobimax'),
		));

		vc_add_param('vc_column', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Background video mp4 file url', 'mobimax' ),
			'param_name' => 'video_bg_mp4',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_column', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Background video webm file url', 'mobimax' ),
			'param_name' => 'video_bg_webm',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_column', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Background video ogv file url', 'mobimax' ),
			'param_name' => 'video_bg_ogv',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_column', array(
			'type'       => 'attach_image',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Video overlay', 'mobimax' ),
			'param_name' => 'video_bg_overlay',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_column', array(
			'type'       => 'attach_image',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Video placeholder', 'mobimax' ),
			'param_name' => 'video_bg_placeholder',
			'dependency' => Array('element' => 'video_bg', 'value' => 'true')
		));

		vc_add_param('vc_column', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Video parallax', 'mobimax' ),
			'param_name' => 'video_bg_parallax',
			'group'      => esc_html__('Background options','mobimax'),
			'dependency' => Array(
				'element' => 'video_bg', 'value' => 'true',

			)
		));

		vc_add_param('vc_column', array(
			'type'       => 'textfield',
			'group'      => esc_html__('Background options','mobimax'),
			'heading'    => esc_html__( 'Background video parallax speed', 'mobimax' ),
			'param_name' => 'video_bg_parallax_speed',
			'description'=> esc_html__('Enter parallax speed ratio (Note: Default value is 1.5, min value is 1)','mobimax'),
			'dependency' => Array(
				'element' => 'video_bg_parallax', 'value' => 'true',
			),
			'default'    => '1.5'
		));

	/* fixed
	---------------*/

		vc_add_param('vc_column', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Fixed background', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'fixed_bg',
		));

		vc_add_param('vc_column', array(
			'type'       => 'attach_image',
			'heading'    => esc_html__( 'Fixed background image', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'fixed_bg_image',
			'dependency' => Array('element' => 'fixed_bg', 'value' => 'true')
		));

	/* animated
	---------------*/

		vc_add_param('vc_column', array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Animated background', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'animated_bg',
		));

		vc_add_param('vc_column', array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Animated background direction', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'animated_bg_dir',
			'value'     => array(
				esc_html__('Horizontal','mobimax')  => 'horizontal',
				esc_html__('Vertical','mobimax')  => 'vertical',
			),
			'dependency' => Array('element' => 'animated_bg', 'value' => 'true')
		));

		vc_add_param('vc_column', array(
			'type'       => 'textfield',
			'heading'    => esc_html__( 'Animated background speed in ms (default is 35000)', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'animated_bg_speed',
			'dependency' => Array('element' => 'animated_bg', 'value' => 'true')
		));

		vc_add_param('vc_column', array(
			'type'       => 'attach_image',
			'heading'    => esc_html__( 'Animated background image', 'mobimax' ),
			'group'      => esc_html__('Background options','mobimax'),
			'param_name' => 'animated_bg_image',
			'dependency' => Array('element' => 'animated_bg', 'value' => 'true')
		));

/* vc_column_text
---------------*/

	vc_add_param('vc_column_text', array(
		'type'       => 'textfield',
		'heading'    => esc_html__('Element id','mobimax'),
		"class"      => "element-attr-hide",
		'param_name' => 'element_id',
		'value'      => '',
	));

	vc_add_param('vc_column_text', array(
		'type'       => 'textarea',
		'heading'    => esc_html__('Element css','mobimax'),
		"class"      => "element-attr-hide",
		'param_name' => 'element_css',
		'value'      => '',
	));

	vc_add_param('vc_column_text', array(
		'type'       => 'dropdown',
		'heading'    => esc_html__( 'Animation delay in ms (example 300)', 'mobimax' ),
		'param_name' => 'animation_delay',
		'weight'     => 1,
		'value'      => $animation_delay_values
	));

	function mobimax_enovathemes_remove_woocommerce() {
	    if (class_exists('Woocommerce')) {
	        vc_remove_element( 'recent_products' );
			vc_remove_element( 'featured_products' );
			vc_remove_element( 'product' );
			vc_remove_element( 'products' );
			vc_remove_element( 'product_category' );
			vc_remove_element( 'product_categories' );
			vc_remove_element( 'sale_products' );
			vc_remove_element( 'best_selling_products' );
			vc_remove_element( 'top_rated_products' );
			vc_remove_element( 'related_products' );
			vc_remove_element( 'product_attribute' );
	    }
	}
	add_action( 'vc_build_admin_page', 'mobimax_enovathemes_remove_woocommerce', 11 );
	add_action( 'vc_load_shortcode', 'mobimax_enovathemes_remove_woocommerce', 11 );

if (defined( 'ENOVATHEMES_ADDONS' )) {
	add_action( 'init', 'mobimax_enovathemes_integrateVC');
    function mobimax_enovathemes_integrateVC() {

    	global $mobimax_enovathemes;

		$main_color = (isset($GLOBALS['mobimax_enovathemes']['main-color']) && $GLOBALS['mobimax_enovathemes']['main-color']) ? $GLOBALS['mobimax_enovathemes']['main-color'] : '#e05c0b';

    	$google_fonts_family = array('Theme default');

		$google_fonts = enovathemes_addons_google_fonts();

		if (!is_wp_error( $google_fonts ) ) {

			foreach ( $google_fonts as $font ) {
				array_push($google_fonts_family, $font['family']);
			}

		}

    	$animation_delay_values = array();

		for ($i=0; $i <= 2000; $i = $i + 50) {
			$animation_delay_values[$i.esc_html__('ms', 'mobimax')] = $i;
		}

    	$order_by_values = array(
			esc_html__( 'Date', 'mobimax' ) => 'date',
			esc_html__( 'ID', 'mobimax' ) => 'ID',
			esc_html__( 'Author', 'mobimax' ) => 'author',
			esc_html__( 'Title', 'mobimax' ) => 'title',
			esc_html__( 'Modified', 'mobimax' ) => 'modified',
			esc_html__( 'Random', 'mobimax' ) => 'rand',
			esc_html__( 'Comment count', 'mobimax' ) => 'comment_count',
			esc_html__( 'Menu order', 'mobimax' ) => 'menu_order',
		);

		$order_way_values = array(
			esc_html__( 'Ascending', 'mobimax' ) => 'ASC',
			esc_html__( 'Descending', 'mobimax' ) => 'DESC',
		);

		$operator_values = array(
			esc_html__( 'IN', 'mobimax' ) => 'IN',
			esc_html__( 'NOT IN', 'mobimax' ) => 'NOT IN',
			esc_html__( 'AND', 'mobimax' ) => 'AND',
		);

		$animation_values = array(
			esc_html__('None', 'mobimax')     => 'none',
			esc_html__('Fade In', 'mobimax')  => 'fadeIn',
			esc_html__('Move Up', 'mobimax')  => 'moveUp',
		);

		$size_values_box = array(
			esc_html__('Small', 'mobimax')        => 'small',
			esc_html__('Medium', 'mobimax')       => 'medium',
			esc_html__('Large', 'mobimax')        => 'large'
		);

		$size_values_default = array(
			esc_html__('Small', 'mobimax')        => 'small',
			esc_html__('Medium', 'mobimax')       => 'medium',
			esc_html__('Large', 'mobimax')        => 'large'
		);

		$size_values_extra = array(
			esc_html__('Extra small', 'mobimax')  => 'extra-small',
			esc_html__('Small', 'mobimax')        => 'small',
			esc_html__('Medium', 'mobimax')       => 'medium',
			esc_html__('Large', 'mobimax')        => 'large',
			esc_html__('Extra large', 'mobimax')  => 'large-x',
			esc_html__('Extra Extra large', 'mobimax')  => 'large-xx'
		);

		$font_weight_values = array(
			'100'  => '100',
			'200'  => '200',
			'300'  => '300',
			'400'  => '400',
			'500'  => '500',
			'600'  => '600',
			'700'  => '700',
			'800'  => '800',
			'900'  => '900',
		);

		$font_size_values = array(esc_html__('Inherit', 'mobimax') => 'inherit');
		for ($i=0; $i <= 72; $i++) {
			$font_size_values[$i.esc_html__('px', 'mobimax')] = $i.'px';
		}

		$line_height_values = array(esc_html__('Inherit', 'mobimax') => 'inherit');
		for ($i=0; $i <= 80; $i++) {
			$line_height_values[$i.esc_html__('px', 'mobimax')] = $i.'px';
		}

		$align_values = array(
			esc_html__('Left','mobimax')   => 'left',
			esc_html__('Right','mobimax')  => 'right',
			esc_html__('Center','mobimax') => 'center'
		);

		$align_values_extended = array(
			esc_html__('None','mobimax')   => 'none',
			esc_html__('Left','mobimax')   => 'left',
			esc_html__('Right','mobimax')  => 'right',
			esc_html__('Center','mobimax') => 'center'
		);

		$logic_values = array(
			esc_html__('False','mobimax')   => 'false',
			esc_html__('True','mobimax')  => 'true',
		);

		$animation_type_values = array(
			esc_html__('Sequential','mobimax')  => 'sequential',
			esc_html__('Random','mobimax')      => 'random'
		);

		$image_size_values = array(
			'full'             => 'full',
			'thumbnail'        => 'thumbnail',
			'mobimax_1200X720' => 'mobimax_1200X720',
			'mobimax_1200X556' => 'mobimax_1200X556',
			'mobimax_900X556'  => 'mobimax_900X556',
			'mobimax_600X370'  => 'mobimax_600X370',
			'mobimax_480X360'  => 'mobimax_480X360',
			'mobimax_480X480'  => 'mobimax_480X480',
			'mobimax_300X250'  => 'mobimax_300X250',
		);

		$image_overlay_values = array(
			esc_html__('Overlay fade','mobimax') 						 => 'overlay-fade',
			esc_html__('Overlay fade with image zoom','mobimax')         => 'overlay-fade-zoom',
			esc_html__('Overlay fade with extreme image zoom','mobimax') => 'overlay-fade-zoom-extreme',
			esc_html__('Overlay move fluid','mobimax')                   => 'overlay-move',
			esc_html__('Transform','mobimax')                            => 'transform'
		);

		$image_caption_values = array(
			esc_html__('Caption up','mobimax') 					  => 'caption-up',
			esc_html__("Caption up and image up", 'mobimax') => "caption-up-image"
		);

		$layout_type_values = array(
			esc_html__('Grid', 'mobimax')     => 'grid',
			esc_html__('Carousel', 'mobimax') => 'carousel',
		);

		$gap_values = array();

		$gap_values_short = array(
			esc_html__('0px', 'mobimax') => 0,
			esc_html__('2px', 'mobimax') => 2,
			esc_html__('4px', 'mobimax') => 4,
			esc_html__('8px', 'mobimax') => 8,
			esc_html__('16px', 'mobimax') => 16,
			esc_html__('24px', 'mobimax') => 24,
			esc_html__('32px', 'mobimax') => 32,
			esc_html__('40px', 'mobimax') => 40,
		);

		for ($i=0; $i <= 80; $i = $i + 2) {
			$gap_values[$i.esc_html__('px', 'mobimax')] = $i;
		}

		$social_links_array = array(
			'youtube',
			'vk',
			'tripadvisor',
			'google',
			'linkedin',
			'facebook',
			'instagram',
			'twitter',
			'vimeo',
			'dribbble',
			'behance',
			'github',
			'skype',
			'pinterest',
			'email'
		);

		$menus = mobimax_enovathemes_get_all_menus();

		$menu_list = array("choose" => esc_html__('Choose','mobimax'));

		foreach ($menus as $menu => $attr) {
			$menu_list[$attr->slug] = $attr->name;
		}

		$menu_list = array_flip($menu_list);

		/* ELEMENTS
		---------------*/

			/* TYPOGRAPHY
			---------------*/

				/* et_heading
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Heading','mobimax'),
			    		'description'             => esc_html__('Add/animate heading','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_heading',
			    		'class'                   => 'et_heading font',
			    		'icon'                    => 'et_heading',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-heading.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-heading.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Title','mobimax'),
								'description'=> esc_html__('Do not use & in the text. If you want to highlight/style a separate word, wrap it inside the span like this <span class="highlight" style="color: #XXXXXX">word</span>. Use color/background styling options only. Also you can add additional classes like "box" "underline" "small"','mobimax'),
								'param_name' => 'content',
							),
							array(
								'param_name'=>'text_align',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Text align', 'mobimax'),
								'value'     => $align_values
							),
							array(
								'param_name'=>'type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Tag', 'mobimax'),
								'value'     => array(
									'H1'  => 'h1',
									'H2'  => 'h2',
									'H3'  => 'h3',
									'H4'  => 'h4',
									'H5'  => 'h5',
									'H6'  => 'h6',
									'p'   => 'p',
									'div' => 'div',
								),
								'std' => 'h1'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Link','mobimax'),
								'param_name' => 'link',
								'value'      => '',
							),
							array(
								'param_name'=>'target',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Target', 'mobimax'),
								'value'     => array(
									'_self'  => '_self',
									'_blank' => '_blank'
								)
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Text color','mobimax'),
								'param_name' => 'text_color',
								'value'      => '#212121',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Background color','mobimax'),
								'param_name' => 'background_color',
								'value'      => '',
							),
							array(
								'param_name'=>'font_family',
								'type'      => 'dropdown',
								'group'     => esc_html__('Typography', 'mobimax'),
								'heading'   => esc_html__('Font family', 'mobimax'),
								'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
								'value'     => $google_fonts_family,
							),
							array(
								'param_name'=>'font_weight',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Font weight', 'mobimax'),
								'group'     => esc_html__('Typography', 'mobimax'),
								'value'     => $font_weight_values,
							),
							array(
								'param_name'=>'font_subsets',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Font subsets', 'mobimax'),
								'group'     => esc_html__('Typography', 'mobimax'),
								'value'     => array(
									'latin' => 'latin',
								)
							),
							array(
								'type'       => 'textfield',
								'group'      => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Font size (without any string)','mobimax'),
								'param_name' => 'font_size',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
								'param_name' => 'letter_spacing',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Line height (without any string)','mobimax'),
								'param_name' => 'line_height',
								'value'      => ''
							),
							array(
								'type'       => 'dropdown',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Text transform','mobimax'),
								'param_name' => 'text_transform',
								'value'      => array(
									esc_html__('None','mobimax')       => 'none',
									esc_html__('Uppercase','mobimax')  => 'uppercase',
									esc_html__('Lowercase','mobimax')  => 'lowercase',
									esc_html__('Capitalize','mobimax') => 'capitalize',
								)
							),

							/* tablet
							---------------*/

								array(
									'param_name'=>'tablet_text_align',
									'type'      => 'dropdown',
									'group'      => esc_html__('Tablet','mobimax'),
									'heading'   => esc_html__('Text align', 'mobimax'),
									'value'      => array(
										esc_html__('Inherit','mobimax') => 'inherit',
										esc_html__('Left','mobimax')    => 'left',
										esc_html__('Right','mobimax')   => 'right',
										esc_html__('Center','mobimax')  => 'center',
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet landscape font size (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_landscape_font_size',
									'value'      => $font_size_values,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet landscape line height (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_landscape_line_height',
									'value'      => $line_height_values,
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet portrait font size (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_portrait_font_size',
									'value'      => $font_size_values,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet portrait line height (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_portrait_line_height',
									'value'      => $line_height_values,
								),

							/* mobile
							---------------*/

								array(
									'param_name'=>'mobile_text_align',
									'type'      => 'dropdown',
									'group'      => esc_html__('Mobile','mobimax'),
									'heading'   => esc_html__('Text align', 'mobimax'),
									'value'      => array(
										esc_html__('Inherit','mobimax') => 'inherit',
										esc_html__('Left','mobimax')    => 'left',
										esc_html__('Right','mobimax')   => 'right',
										esc_html__('Center','mobimax')  => 'center',
									)
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Font size (without any string)','mobimax'),
									'group'      => esc_html__('Mobile','mobimax'),
									'param_name' => 'mobile_font_size',
									'value'      => $font_size_values,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Line height (without any string)','mobimax'),
									'group'      => esc_html__('Mobile','mobimax'),
									'param_name' => 'mobile_line_height',
									'value'      => $line_height_values,
								),

							/* animation
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Animate','mobimax'),
									'group'      => 'Animation',
									'param_name' => 'animate',
								),

								array(
									'type'       => 'dropdown',
									'group'      => esc_html__('Animation','mobimax'),
									'heading'    => esc_html__('Animation type','mobimax'),
									'param_name' => 'animation_type',
									'value'     => array(
										esc_html__('Curtain left', 'mobimax')  		  => 'curtain-left',
										esc_html__('Curtain right', 'mobimax')  	  => 'curtain-right',
										esc_html__('Curtain top', 'mobimax')  		  => 'curtain-top',
										esc_html__('Curtain bottom', 'mobimax')  	  => 'curtain-bottom',
										esc_html__('Letter fly-in direct', 'mobimax') => 'letter-direct',
										esc_html__('Letter fly-in angle', 'mobimax')  => 'letter-angle',
										esc_html__('Words fly-in direct', 'mobimax')  => 'words-direct',
										esc_html__('Words fly-in angle', 'mobimax')   => 'words-angle',
									),
									'dependency' => Array('element' => 'animate', 'value' => 'true')
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Line/Curtain Color','mobimax'),
									'group'      => esc_html__('Animation','mobimax'),
									'param_name' => 'element_color',
									'value'      => $main_color,
									'dependency' => Array(
										'element' => 'animate', 'value' => 'true',
										'element' => 'animation_type', 'value' => array('curtain-left','curtain-right','curtain-top','curtain-bottom','line-appear')
									)
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Animation','mobimax'),
									'heading'    => esc_html__('Start delay in ms (enter only integer number)','mobimax'),
									'param_name' => 'start_delay',
									'value'      => '0',
									'dependency' => Array('element' => 'animate', 'value' => 'true')
								),

							/* parallax
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Parallax','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset X coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_x',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset Y coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_y',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Parallax speed radtio','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'description'=> esc_html__('The more the value is the slower the parallax effect is','mobimax'),
									'param_name' => 'parallax_speed',
									'value'     => array(
										'1'  => '1',
										'2'  => '2',
										'3'  => '3',
										'4'  => '4',
										'5'  => '5',
										'6'  => '6',
										'7'  => '7',
										'8'  => '8',
										'9'  => '9',
										'10' => '10',
										'11' => '11',
										'12' => '12',
										'13' => '13',
										'14' => '14',
										'15' => '15',
										'16' => '16',
										'17' => '17',
										'18' => '18',
										'19' => '19',
										'20' => '20'
									),
									'std' => '10',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Move on mouse move','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'move',
									'value'      => '',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'rp',
									'heading'    => esc_html__( 'Responsive parallax', 'mobimax' ),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'rp',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),

							/* margin
							---------------*/

								array(
									'type'       => 'margin',
									'group'      => esc_html__('Margin','mobimax'),
									'heading'    => esc_html__('Margin','mobimax'),
									'param_name' => 'margin',
									'value'      => ''
								),

							/* padding
							---------------*/

								array(
									'type'       => 'padding',
									'group'      => esc_html__('Padding','mobimax'),
									'heading'    => esc_html__('Padding','mobimax'),
									'param_name' => 'padding',
									'value'      => ''
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element font','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_font',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_typeit
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Typeit','mobimax'),
			    		'description'             => esc_html__('Add/animate typing','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_typeit',
			    		'class'                   => 'et_typeit font',
			    		'icon'                    => 'et_typeit',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-typeit.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-typeit.js',
			    		'params'                  => array(
			    			array(
								'param_name'=>'onlyfirst',
								'type'      => 'checkbox',
								'heading'   => esc_html__('Type only first word?', 'mobimax'),
								'value'     => ''
							),
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Typing first word','mobimax'),
								'description'=> esc_html__('The static first word that will always be visible','mobimax'),
								'param_name' => 'string_1',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Typing second word','mobimax'),
								'description'=> esc_html__('This will be typed','mobimax'),
								'param_name' => 'string_2',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Typing third word','mobimax'),
								'description'=> esc_html__('This will be typed','mobimax'),
								'param_name' => 'string_3',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Typing fourth word','mobimax'),
								'description'=> esc_html__('This will be typed','mobimax'),
								'param_name' => 'string_4',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Typing fifth word','mobimax'),
								'description'=> esc_html__('This will be typed','mobimax'),
								'param_name' => 'string_5',
							),
							array(
								'param_name'=>'text_align',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Text align', 'mobimax'),
								'value'     => $align_values
							),
							array(
								'param_name'=>'autostart',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Autostart', 'mobimax'),
								'value'     => $logic_values
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Start delay in ms (enter only integer number)','mobimax'),
								'param_name' => 'start_delay',
								'value'      => '0',
							),
							array(
								'param_name'=>'type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Tag', 'mobimax'),
								'value'     => array(
									'H1'  => 'h1',
									'H2'  => 'h2',
									'H3'  => 'h3',
									'H4'  => 'h4',
									'H5'  => 'h5',
									'H6'  => 'h6',
									'p'   => 'p',
									'div' => 'div',
								),
								'std' => 'h1'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Text color','mobimax'),
								'param_name' => 'text_color',
								'value'      => '#212121',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Background color','mobimax'),
								'param_name' => 'background_color',
								'value'      => '',
							),
							array(
								'param_name'=>'font_family',
								'type'      => 'dropdown',
								'group'     => esc_html__('Typography', 'mobimax'),
								'heading'   => esc_html__('Font family', 'mobimax'),
								'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
								'value'     => $google_fonts_family,
							),
							array(
								'param_name'=>'font_weight',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Font weight', 'mobimax'),
								'group'     => esc_html__('Typography', 'mobimax'),
								'value'     => $font_weight_values,
							),
							array(
								'param_name'=>'font_subsets',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Font subsets', 'mobimax'),
								'group'     => esc_html__('Typography', 'mobimax'),
								'value'     => array(
									'latin' => 'latin',
								)
							),
							array(
								'type'       => 'textfield',
								'group'      => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Font size (without any string)','mobimax'),
								'param_name' => 'font_size',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
								'param_name' => 'letter_spacing',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Line height (without any string)','mobimax'),
								'param_name' => 'line_height',
								'value'      => ''
							),
							array(
								'type'       => 'dropdown',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Text transform','mobimax'),
								'param_name' => 'text_transform',
								'value'      => array(
									esc_html__('None','mobimax')       => 'none',
									esc_html__('Uppercase','mobimax')  => 'uppercase',
									esc_html__('Lowercase','mobimax')  => 'lowercase',
									esc_html__('Capitalize','mobimax') => 'capitalize',
								)
							),

							/* tablet
							---------------*/

								array(
									'param_name'=>'tablet_text_align',
									'type'      => 'dropdown',
									'group'      => esc_html__('Tablet','mobimax'),
									'heading'   => esc_html__('Text align', 'mobimax'),
									'value'      => array(
										esc_html__('Inherit','mobimax') => 'inherit',
										esc_html__('Left','mobimax')    => 'left',
										esc_html__('Right','mobimax')   => 'right',
										esc_html__('Center','mobimax')  => 'center',
									)
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet landscape font size (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_landscape_font_size',
									'value'      => $font_size_values,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet landscape line height (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_landscape_line_height',
									'value'      => $line_height_values,
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet portrait font size (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_portrait_font_size',
									'value'      => $font_size_values,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet portrait line height (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_portrait_line_height',
									'value'      => $line_height_values,
								),

							/* mobile
							---------------*/

								array(
									'param_name'=>'mobile_text_align',
									'type'      => 'dropdown',
									'group'      => esc_html__('Mobile','mobimax'),
									'heading'   => esc_html__('Text align', 'mobimax'),
									'value'      => array(
										esc_html__('Inherit','mobimax') => 'inherit',
										esc_html__('Left','mobimax')    => 'left',
										esc_html__('Right','mobimax')   => 'right',
										esc_html__('Center','mobimax')  => 'center',
									)
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Font size (without any string)','mobimax'),
									'group'      => esc_html__('Mobile','mobimax'),
									'param_name' => 'mobile_font_size',
									'value'      => $font_size_values,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Line height (without any string)','mobimax'),
									'group'      => esc_html__('Mobile','mobimax'),
									'param_name' => 'mobile_line_height',
									'value'      => $line_height_values,
								),

							/* margin
							---------------*/

								array(
									'type'       => 'margin',
									'group'      => esc_html__('Margin','mobimax'),
									'heading'    => esc_html__('Margin','mobimax'),
									'param_name' => 'margin',
									'value'      => ''
								),

							/* padding
							---------------*/

								array(
									'type'       => 'padding',
									'group'      => esc_html__('Padding','mobimax'),
									'heading'    => esc_html__('Padding','mobimax'),
									'param_name' => 'padding',
									'value'      => ''
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element font','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_font',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_highlight_heading
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Highlight heading','mobimax'),
			    		'description'             => esc_html__('Add highlight heading','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_highlight_heading',
			    		'class'                   => 'et_highlight_heading font',
			    		'icon'                    => 'et_highlight_heading',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-highlight-heading.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-highlight-heading.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
							),
							array(
								'param_name'=>'text_align',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Text align', 'mobimax'),
								'value'     => $align_values
							),
							array(
								'param_name'=>'type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Tag', 'mobimax'),
								'value'     => array(
									'H1'  => 'h1',
									'H2'  => 'h2',
									'H3'  => 'h3',
									'H4'  => 'h4',
									'H5'  => 'h5',
									'H6'  => 'h6',
									'p'   => 'p',
									'div' => 'div',
								),
								'std' => 'h1'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Text color','mobimax'),
								'param_name' => 'text_color',
								'value'      => '#9a9a9a',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Border color','mobimax'),
								'param_name' => 'border_color',
								'value'      => $main_color,
							),
							array(
								'param_name'=>'font_family',
								'type'      => 'dropdown',
								'group'     => esc_html__('Typography', 'mobimax'),
								'heading'   => esc_html__('Font family', 'mobimax'),
								'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
								'value'     => $google_fonts_family,
							),
							array(
								'param_name'=>'font_weight',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Font weight', 'mobimax'),
								'group'     => esc_html__('Typography', 'mobimax'),
								'value'     => $font_weight_values,
							),
							array(
								'param_name'=>'font_subsets',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Font subsets', 'mobimax'),
								'group'     => esc_html__('Typography', 'mobimax'),
								'value'     => array(
									'latin' => 'latin',
								)
							),
							array(
								'type'       => 'textfield',
								'group'      => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Font size (without any string)','mobimax'),
								'param_name' => 'font_size',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
								'param_name' => 'letter_spacing',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Line height (without any string)','mobimax'),
								'param_name' => 'line_height',
								'value'      => ''
							),
							array(
								'type'       => 'dropdown',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Text transform','mobimax'),
								'param_name' => 'text_transform',
								'value'      => array(
									esc_html__('None','mobimax')       => 'none',
									esc_html__('Uppercase','mobimax')  => 'uppercase',
									esc_html__('Lowercase','mobimax')  => 'lowercase',
									esc_html__('Capitalize','mobimax') => 'capitalize',
								)
							),

							/* tablet
							---------------*/

								array(
									'param_name'=>'tablet_text_align',
									'type'      => 'dropdown',
									'group'      => esc_html__('Tablet','mobimax'),
									'heading'   => esc_html__('Text align', 'mobimax'),
									'value'      => array(
										esc_html__('Inherit','mobimax') => 'inherit',
										esc_html__('Left','mobimax')    => 'left',
										esc_html__('Right','mobimax')   => 'right',
										esc_html__('Center','mobimax')  => 'center',
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet landscape font size (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_landscape_font_size',
									'value'      => $font_size_values,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet landscape line height (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_landscape_line_height',
									'value'      => $line_height_values,
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet portrait font size (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_portrait_font_size',
									'value'      => $font_size_values,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Tablet portrait line height (without any string)','mobimax'),
									'group'      => esc_html__('Tablet','mobimax'),
									'param_name' => 'tablet_portrait_line_height',
									'value'      => $line_height_values,
								),

							/* mobile
							---------------*/

								array(
									'param_name'=>'mobile_text_align',
									'type'      => 'dropdown',
									'group'      => esc_html__('Mobile','mobimax'),
									'heading'   => esc_html__('Text align', 'mobimax'),
									'value'      => array(
										esc_html__('Inherit','mobimax') => 'inherit',
										esc_html__('Left','mobimax')    => 'left',
										esc_html__('Right','mobimax')   => 'right',
										esc_html__('Center','mobimax')  => 'center',
									)
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Font size (without any string)','mobimax'),
									'group'      => esc_html__('Mobile','mobimax'),
									'param_name' => 'mobile_font_size',
									'value'      => $font_size_values,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Line height (without any string)','mobimax'),
									'group'      => esc_html__('Mobile','mobimax'),
									'param_name' => 'mobile_line_height',
									'value'      => $line_height_values,
								),

							/* parallax
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Parallax','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset X coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_x',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset Y coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_y',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Parallax speed radtio','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'description'=> esc_html__('The more the value is the slower the parallax effect is','mobimax'),
									'param_name' => 'parallax_speed',
									'value'     => array(
										'1'  => '1',
										'2'  => '2',
										'3'  => '3',
										'4'  => '4',
										'5'  => '5',
										'6'  => '6',
										'7'  => '7',
										'8'  => '8',
										'9'  => '9',
										'10' => '10',
										'11' => '11',
										'12' => '12',
										'13' => '13',
										'14' => '14',
										'15' => '15',
										'16' => '16',
										'17' => '17',
										'18' => '18',
										'19' => '19',
										'20' => '20'
									),
									'std' => '10',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Move on mouse move','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'move',
									'value'      => '',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'rp',
									'heading'    => esc_html__( 'Responsive parallax', 'mobimax' ),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'rp',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),

							/* margin
							---------------*/

								array(
									'type'       => 'margin',
									'group'      => esc_html__('Margin','mobimax'),
									'heading'    => esc_html__('Margin','mobimax'),
									'param_name' => 'margin',
									'value'      => ''
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element font','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_font',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_blockquote
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Blockquote','mobimax'),
			    		'description'             => esc_html__('Add blockquote','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_blockquote',
			    		'class'                   => 'et_blockquote',
			    		'icon'                    => 'et_blockquote',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-blockquote.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-blockquote.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Content','mobimax'),
								'param_name' => 'text',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Author','mobimax'),
								'param_name' => 'author',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),

							/* margin
							---------------*/

								array(
									'type'       => 'margin',
									'group'      => esc_html__('Margin','mobimax'),
									'heading'    => esc_html__('Margin','mobimax'),
									'param_name' => 'margin',
									'value'      => ''
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element font','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_font',
									'value'      => '',
								),
			    		)
			    	));

			/* UI
			---------------*/

				/* et_menu
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Navigation menu','mobimax'),
			    		'description'             => esc_html__('Do not use with header builder','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_menu',
			    		'class'                   => 'et_menu font',
			    		'icon'                    => 'et_menu',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-menu.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-menu.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Menu name','mobimax'),
								'param_name' => 'menu',
								'value'      => $menu_list,
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Type','mobimax'),
								'param_name' => 'type',
								'value'      => array(
									esc_html__("Horizontal","mobimax") => 'horizontal',
									esc_html__("Vertical","mobimax")   => 'vertical'
								),
							),
							array(
								'param_name'=>'align',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Align', 'mobimax'),
								'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
								'value'     => $align_values_extended,
								'dependency' => Array('element' => 'type', 'value' => 'horizontal')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),

							/* top level
							---------------*/

								/* styling
								---------------*/

									array(
										'type'       => 'textfield',
										'heading'    => esc_html__('Space between menu items in px (without any string)','mobimax'),
										'group'      => 'Top level',
										'param_name' => 'menu_space',
										'value'      => '40',
									),

									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Submenu indicator','mobimax'),
										'group'      => 'Top level',
										'param_name' => 'submenu_indicator',
										'value'      => $logic_values
									),

									array(
										'type'       => 'colorpicker',
										'heading'    => esc_html__('Menu color','mobimax'),
										'group'      => 'Top level',
										'param_name' => 'menu_color',
										'value'      => '#212121',
									),

									array(
										'type'       => 'colorpicker',
										'heading'    => esc_html__('Menu color hover','mobimax'),
										'group'      => 'Top level',
										'param_name' => 'menu_color_hover',
										'value'      => $main_color,
									),

									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Menu hover effect','mobimax'),
										'group'      => 'Top level',
										'param_name' => 'menu_hover',
										'value'      => array(
											esc_html__('None','mobimax')      => 'none',
											esc_html__('Underline','mobimax') => 'underline',
											esc_html__('Overline','mobimax')  => 'overline',
											esc_html__('Outline','mobimax')   => 'outline',
											esc_html__('Box','mobimax')       => 'box',
											esc_html__('Fill','mobimax')      => 'fill',
										),
									),

									array(
										'type'       => 'colorpicker',
										'heading'    => esc_html__('Menu hover effect color','mobimax'),
										'group'      => 'Top level',
										'param_name' => 'menu_effect_color',
										'value'      => '',
										'dependency' => Array('element' => 'menu_hover', 'value' => array('underline','overline','outline','box','fill'))
									),

								/* typography
								---------------*/

									array(
										'param_name'=>'font_family',
										'type'      => 'dropdown',
										'group'     => esc_html__('Top level','mobimax'),
										'heading'   => esc_html__('Font family', 'mobimax'),
										'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
										'value'     => $google_fonts_family,
									),
									array(
										'param_name'=>'font_weight',
										'type'      => 'dropdown',
										'group'     => esc_html__('Top level','mobimax'),
										'heading'   => esc_html__('Font weight', 'mobimax'),
										'value'     => $font_weight_values,
										'std'       => '700'
									),
									array(
										'param_name'=>'font_subsets',
										'type'      => 'dropdown',
										'group'     => esc_html__('Top level','mobimax'),
										'heading'   => esc_html__('Font subsets', 'mobimax'),
										'value'      => array(
											'latin' => 'latin',
										)
									),
									array(
										'type'       => 'textfield',
										'heading'    => esc_html__('Font size (without any string)','mobimax'),
										'group'      => esc_html__('Top level','mobimax'),
										'param_name' => 'font_size',
										'value'      => '14',
									),
									array(
										'type'       => 'textfield',
										'group'      => esc_html__('Top level','mobimax'),
										'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
										'param_name' => 'letter_spacing',
										'value'      => '1'
									),
									array(
										'type'       => 'textfield',
										'group'      => esc_html__('Top level','mobimax'),
										'heading'    => esc_html__('Line height (without any string)','mobimax'),
										'param_name' => 'line_height',
										'value'      => ''
									),
									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Text transform','mobimax'),
										'group'      => 'Top level',
										'param_name' => 'text_transform',
										'value'      => array(
											esc_html__('None','mobimax')       => 'none',
											esc_html__('Uppercase','mobimax')  => 'uppercase',
											esc_html__('Lowercase','mobimax')  => 'lowercase',
											esc_html__('Capitalize','mobimax') => 'capitalize',
										)
									),

							/* submenu
							---------------*/

								/* styling
								---------------*/

									array(
										'type'       => 'colorpicker',
										'heading'    => esc_html__('Submenu color','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_color',
										'value'      => '#bdbdbd',
									),

									array(
										'type'       => 'colorpicker',
										'heading'    => esc_html__('Submenu color hover','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_color_hover',
										'value'      => '#ffffff',
									),

									array(
										'type'       => 'colorpicker',
										'heading'    => esc_html__('Submenu background color','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_back_color',
										'value'      => '#212121',
									),

									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Submenu shadow','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_shadow',
										'value'      => $logic_values
									),

									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Submenu indicator','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_submenu_indicator',
										'value'      => $logic_values
									),

									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Submenu items separator','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_separator',
										'value'      => $logic_values
									),

									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Submenu appear','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_appear_from',
										'value'      => array(
											esc_html__('From bottom','mobimax') => 'bottom',
											esc_html__('From top','mobimax')    => 'top'
										),
										'dependency' => Array('element' => 'type', 'value' => 'horizontal')
									),

									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Submenu appear effect','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_appear',
										'value'      => array(
											esc_html__('Appear','mobimax')    => 'none',
											esc_html__('Fade','mobimax')      => 'fade',
											esc_html__('Move','mobimax')      => 'move',
										),
									),

									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Submenu hover effect','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_hover',
										'value'      => array(
											esc_html__('None','mobimax')      => 'none',
											esc_html__('Line','mobimax')      => 'line',
											esc_html__('Dot','mobimax')       => 'dot',
											esc_html__('Outline','mobimax')   => 'outline',
											esc_html__('Box','mobimax')       => 'box',
											esc_html__('Fill','mobimax')      => 'fill',
										),
									),

									array(
										'type'       => 'colorpicker',
										'heading'    => esc_html__('Submenu hover effect color','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'submenu_effect_color',
										'value'      => '',
										'dependency' => Array('element' => 'submenu_hover', 'value' => array('line','dot','outline','box','fill'))
									),

								/* typography
								---------------*/

									array(
										'param_name'=>'subfont_family',
										'type'      => 'dropdown',
										'group'     => esc_html__('Submenu','mobimax'),
										'heading'   => esc_html__('Submenu font family', 'mobimax'),
										'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
										'value'     => $google_fonts_family,
									),
									array(
										'param_name'=>'subfont_weight',
										'type'      => 'dropdown',
										'group'     => esc_html__('Submenu','mobimax'),
										'heading'   => esc_html__('Submenu font weight', 'mobimax'),
										'value'     => $font_weight_values
									),
									array(
										'param_name'=>'subfont_subsets',
										'type'      => 'dropdown',
										'group'     => esc_html__('Submenu','mobimax'),
										'heading'   => esc_html__('Submenu font subsets', 'mobimax'),
										'value'      => array(
											'latin' => 'latin',
										)
									),
									array(
										'type'       => 'textfield',
										'heading'    => esc_html__('Submenu font size (without any string)','mobimax'),
										'group'      => esc_html__('Submenu','mobimax'),
										'param_name' => 'subfont_size',
										'value'      => '',
									),
									array(
										'type'       => 'textfield',
										'group'      => esc_html__('Submenu','mobimax'),
										'heading'    => esc_html__('Submenu letter spacing (without any string)','mobimax'),
										'param_name' => 'subletter_spacing',
										'value'      => ''
									),
									array(
										'type'       => 'dropdown',
										'heading'    => esc_html__('Submenu text transform','mobimax'),
										'group'      => 'Submenu',
										'param_name' => 'subtext_transform',
										'value'      => array(
											esc_html__('None','mobimax')       => 'none',
											esc_html__('Uppercase','mobimax')  => 'uppercase',
											esc_html__('Lowercase','mobimax')  => 'lowercase',
											esc_html__('Capitalize','mobimax') => 'capitalize',
										)
									),

							/* margin
							---------------*/

								array(
									'type'       => 'margin',
									'group'      => esc_html__('Margin','mobimax'),
									'heading'    => esc_html__('Margin','mobimax'),
									'param_name' => 'margin',
									'value'      => ''
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element font','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_font',
									'value'      => '',
								),

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element font','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'subelement_font',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_button
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Button','mobimax'),
			    		'description'             => esc_html__('Do not use with header builder','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_button',
			    		'class'                   => 'et_button',
			    		'icon'                    => 'et_button',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-button.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-button.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button text','mobimax'),
								'param_name' => 'button_text',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button link','mobimax'),
								'param_name' => 'button_link',
								'value'      => '',
							),
							array(
								'param_name'=>'target',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Target', 'mobimax'),
								'value'     => array(
									'_self'  => '_self',
									'_blank' => '_blank'
								)
							),
							array(
			    				'type'       => 'checkbox',
								'heading'    => esc_html__('Open link in modal window?', 'mobimax'),
								'param_name' => 'button_link_modal',
								'value'      => '',
							),
			    			array(
								'param_name'=>'button_size',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Button size', 'mobimax'),
								'value'     => $size_values_default,
								'std'       => 'medium'
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),

			    			/* typography
							---------------*/

								array(
									'param_name'=>'font_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Typography', 'mobimax'),
									'heading'   => esc_html__('Font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'font_weight',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Font weight', 'mobimax'),
									'group'     => esc_html__('Typography', 'mobimax'),
									'value'     => $font_weight_values,
								),
								array(
									'param_name'=>'font_subsets',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Font subsets', 'mobimax'),
									'group'     => esc_html__('Typography', 'mobimax'),
									'value'     => array(
										'latin' => 'latin',
									)
								),
				    			array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Button font size (without any string)','mobimax'),
									'group'      => esc_html__('Typography','mobimax'),
									'param_name' => 'button_font_size',
									'value'      => '',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Button letter spacing (without any string)','mobimax'),
									'group'      => esc_html__('Typography','mobimax'),
									'param_name' => 'button_letter_spacing',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Button line height (without any string)','mobimax'),
									'group'      => esc_html__('Typography','mobimax'),
									'param_name' => 'button_line_height',
									'value'      => ''
								),
								array(
									'type'       => 'dropdown',
									'group'   	 => esc_html__('Typography', 'mobimax'),
									'heading'    => esc_html__('Text transform','mobimax'),
									'param_name' => 'button_text_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									),
									'std' => 'none'
								),

							/* styling
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Button min width (without any string)','mobimax'),
									'group'      => esc_html__('Styling','mobimax'),
									'param_name' => 'button_min_width',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button color','mobimax'),
									'group'      => esc_html__('Styling','mobimax'),
									'param_name' => 'button_color',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button background color','mobimax'),
									'group'      => esc_html__('Styling','mobimax'),
									'param_name' => 'button_back_color',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button border color','mobimax'),
									'group'      => esc_html__('Styling','mobimax'),
									'param_name' => 'button_border_color',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Button border radius (without any string)','mobimax'),
									'group'      => esc_html__('Styling','mobimax'),
									'param_name' => 'button_border_radius',
									'value'      => '0'
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Button border width (without any string)','mobimax'),
									'group'      => esc_html__('Styling','mobimax'),
									'param_name' => 'button_border_width',
								),

								array(
				    				'type'       => 'checkbox',
									'heading'    => esc_html__('Button shadow ?', 'mobimax'),
									'group'      => esc_html__('Styling','mobimax'),
									'param_name' => 'button_shadow',
									'value'      => '',
								),

							/* icon
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Icon prefix','mobimax'),
									'group'      => esc_html__('Icon','mobimax'),
									'param_name' => 'icon_prefix',
									'value'      => '',
									'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Icon name','mobimax'),
									'group'      => esc_html__('Icon','mobimax'),
									'param_name' => 'icon_name',
									'value'      => '',
									'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
								),

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Icon size (without any string)','mobimax'),
									'group'      => esc_html__('Icon','mobimax'),
									'param_name' => 'icon_font_size',
									'value'      => '',
								),

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Icon margin (without any string)','mobimax'),
									'group'      => esc_html__('Icon','mobimax'),
									'param_name' => 'icon_margin',
									'value'      => '',
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Icon position','mobimax'),
									'group'      => esc_html__('Icon','mobimax'),
									'param_name' => 'icon_position',
									'value'      => array(
										esc_html__('Left','mobimax')  => 'left',
										esc_html__('Right','mobimax')  => 'right',
									)
								),

							/* hover
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button color hover','mobimax'),
									'group'      => esc_html__('Hover','mobimax'),
									'param_name' => 'button_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button background color hover','mobimax'),
									'group'      => esc_html__('Hover','mobimax'),
									'param_name' => 'button_back_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button border color hover','mobimax'),
									'group'      => esc_html__('Hover','mobimax'),
									'param_name' => 'button_border_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Hover animation','mobimax'),
									'group'      => esc_html__('Hover','mobimax'),
									'param_name' => 'animate_hover',
									'value'      => array(
										esc_html__('None','mobimax')  => 'none',
										esc_html__('Fill','mobimax')  => 'fill',
										esc_html__('Scale','mobimax') => 'scale',
										esc_html__('Glint','mobimax') => 'glint',
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Click animation','mobimax'),
									'group'      => esc_html__('Click','mobimax'),
									'param_name' => 'animate_click',
									'value'      => array(
										esc_html__('None','mobimax')  => 'none',
										esc_html__('Material','mobimax')  => 'material',
									)
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Smooth Click animation','mobimax'),
									'group'      => esc_html__('Click','mobimax'),
									'param_name' => 'click_smooth',
									'value'      => ''
								),

							/* animation
							---------------*/

								array(
					                'type'       => 'animation_style',
					                'heading'    => esc_html__('Animation','mobimax'),
									'group'      => esc_html__('Animation','mobimax'),
					                'param_name' => 'animation',
					                'weight'     => 0,
					            ),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__( 'Animation delay in ms (example 300)', 'mobimax' ),
									'group'      => esc_html__('Animation','mobimax'),
									'param_name' => 'animation_delay',
									'weight'     => 1,
									'value'      => $animation_delay_values
								),

							/* parallax
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Parallax','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset X coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_x',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset Y coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_y',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Parallax speed radtio','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'description'=> esc_html__('The more the value is the slower the parallax effect is','mobimax'),
									'param_name' => 'parallax_speed',
									'value'     => array(
										'1'  => '1',
										'2'  => '2',
										'3'  => '3',
										'4'  => '4',
										'5'  => '5',
										'6'  => '6',
										'7'  => '7',
										'8'  => '8',
										'9'  => '9',
										'10' => '10',
										'11' => '11',
										'12' => '12',
										'13' => '13',
										'14' => '14',
										'15' => '15',
										'16' => '16',
										'17' => '17',
										'18' => '18',
										'19' => '19',
										'20' => '20'
									),
									'std' => '10',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Move on mouse move','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'move',
									'value'      => '',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'rp',
									'heading'    => esc_html__( 'Responsive parallax', 'mobimax' ),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'rp',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element font','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_font',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_separator
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Separator','mobimax'),
						'description'             => esc_html__('Use this element to separate content','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_separator',
						'class'                   => 'et_separator',
						'icon'                    => 'et_separator',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-separator.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-separator.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Type','mobimax'),
								'param_name' => 'type',
								'value'      => array(
									esc_html__('solid','mobimax')  => 'solid',
									esc_html__('dotted','mobimax') => 'dotted',
									esc_html__('dashed','mobimax') => 'dashed',
								)
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Color','mobimax'),
								'param_name' => 'color',
								'value'      => '#e0e0e0'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Gap from top (without any string)','mobimax'),
								'param_name' => 'top',
								'value'      => '24'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Gap from bottom (without any string)','mobimax'),
								'param_name' => 'bottom',
								'value'      => '24'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Width (without any string, if you want 100% leave blank)','mobimax'),
								'param_name' => 'width',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Height (without any string, if you want 1px leave blank)','mobimax'),
								'param_name' => 'height',
								'value'      => ''
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Align','mobimax'),
								'param_name' => 'align',
								'value'      => $align_values
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Animate','mobimax'),
								'param_name' => 'animate',
								'value'      => $logic_values
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Animation delay in ms (without any string)','mobimax'),
								'param_name' => 'start_delay',
								'value'      => '',
								'dependency' => Array('element' => 'animate', 'value' => 'true')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),
							array(
								'type'       => 'rv',
								'heading'    => esc_html__( 'Responsive visibility', 'mobimax' ),
								'group'      => esc_html__('Responsive visibility','mobimax'),
								'param_name' => 'rv',
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

			    /* et_icon_separator
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Icon separator','mobimax'),
						'description'             => esc_html__('Use this element to separate content','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_icon_separator',
						'class'                   => 'et_icon_separator',
						'icon'                    => 'et_icon_separator',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon-separator.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon-separator.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon prefix','mobimax'),
								'param_name' => 'icon_prefix',
								'value'      => '',
								'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon name','mobimax'),
								'param_name' => 'icon_name',
								'value'      => '',
								'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
							),
							array(
								'param_name'=>'icon_size',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Icon size', 'mobimax'),
								'value'     => $size_values_default
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Separator color','mobimax'),
								'param_name' => 'color_sep',
								'value'      => '#e0e0e0'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'param_name' => 'color_icon',
								'value'      => $main_color
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Gap from top (without any string)','mobimax'),
								'param_name' => 'top',
								'value'      => '24'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Gap from bottom (without any string)','mobimax'),
								'param_name' => 'bottom',
								'value'      => '24'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Separator width (without any string)','mobimax'),
								'param_name' => 'width',
								'value'      => '120'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Height (without any string, if you want 1px leave blank)','mobimax'),
								'param_name' => 'height',
								'value'      => '1'
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Align','mobimax'),
								'param_name' => 'align',
								'value'      => $align_values
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

			    /* et_alert
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Alert','mobimax'),
						'description'             => esc_html__('Use this element for notifications','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_alert',
						'class'                   => 'et_alert',
						'icon'                    => 'et_alert',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Message type','mobimax'),
								'param_name' => 'type',
								'value'      => array(
									esc_html__('Note','mobimax')        => 'note',
									esc_html__('Success','mobimax')     => 'success',
									esc_html__('Warning','mobimax')     => 'warning',
									esc_html__('Error','mobimax')       => 'error',
									esc_html__('Information','mobimax') => 'information'
								)
							),
							array(
								'type'       => 'textarea',
								'param_name' => 'content',
								'value'      => 'Alert message content goes here'
							)
						)
					));

			    /* et_more_box
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('More box','mobimax'),
						'description'             => esc_html__('Insert click to open box with any content','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_more_box',
						'class'                   => 'et_more_box',
						'icon'                    => 'et_more_box',
						"as_parent"               => array('except' => 'vc_row, vc_section'),
	    				'content_element'         => true,
						"js_view"                 => 'VcColumnView',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-more-box.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-more-box.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Position','mobimax'),
								'param_name' => 'position',
								'value'      => array(
									esc_html__('From left bottom','mobimax')       => 'left',
									esc_html__('From right bottom','mobimax')  => 'right',
								),
								'std' => 'left'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'param_name' => 'icon_color',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'param_name' => 'icon_back_color',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Width in px (without any string)','mobimax'),
								'description'=> esc_html__('If you want the box to fit the available width of the column, leave blank','mobimax'),
								'param_name' => 'width',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Height in px (without any string)','mobimax'),
								'description'=> esc_html__('If you want the box to fit the available height of the column, leave blank','mobimax'),
								'param_name' => 'height',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),

							/* padding
							---------------*/

								array(
									'type'       => 'padding',
									'group'      => esc_html__('Padding','mobimax'),
									'heading'    => esc_html__('Padding','mobimax'),
									'param_name' => 'padding',
									'value'      => '48,48,48,48'
								),

								array(
									'type'       => 'crp',
									'heading'    => esc_html__( 'Responsive padding', 'mobimax' ),
									'group'      => esc_html__('Responsive Options','mobimax'),
									'param_name' => 'crp',
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

			    /* et_animate_box
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Animate box','mobimax'),
						'description'             => esc_html__('Insert animate box with any content','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_animate_box',
						'class'                   => 'et_animate_box',
						'icon'                    => 'et_animate_box',
						"as_parent"               => array('except' => 'vc_row, vc_section'),
	    				'content_element'         => true,
						"js_view"                 => 'VcColumnView',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-animate-box.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-animate-box.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Background color','mobimax'),
								'param_name' => 'color',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),

							/* padding
							---------------*/

								array(
									'type'       => 'padding',
									'group'      => esc_html__('Padding','mobimax'),
									'heading'    => esc_html__('Padding','mobimax'),
									'param_name' => 'padding',
									'value'      => '48,48,48,48'
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),

							/* parallax
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Parallax','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset X coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_x',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset Y coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_y',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Parallax speed radtio','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'description'=> esc_html__('The more the value is the slower the parallax effect is','mobimax'),
									'param_name' => 'parallax_speed',
									'value'     => array(
										'1'  => '1',
										'2'  => '2',
										'3'  => '3',
										'4'  => '4',
										'5'  => '5',
										'6'  => '6',
										'7'  => '7',
										'8'  => '8',
										'9'  => '9',
										'10' => '10',
										'11' => '11',
										'12' => '12',
										'13' => '13',
										'14' => '14',
										'15' => '15',
										'16' => '16',
										'17' => '17',
										'18' => '18',
										'19' => '19',
										'20' => '20'
									),
									'std' => '10',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Move on mouse move','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'move',
									'value'      => '',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'rp',
									'heading'    => esc_html__( 'Responsive parallax', 'mobimax' ),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'rp',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),

							/* curtain
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Curtain effect','mobimax'),
									'group'      => esc_html__('Curtain effect','mobimax'),
									'param_name' => 'curtain',
									'value'      => ''
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Curtain direction','mobimax'),
									'group'      => esc_html__('Curtain effect','mobimax'),
									'param_name' => 'curtain_direction',
									'value'      => array(
										esc_html__('Left to Right','mobimax') => 'left',
										esc_html__('Right to Left','mobimax') => 'right',
										esc_html__('Top to bottom','mobimax') => 'top',
										esc_html__('Bottom to top','mobimax') => 'bottom',
									),
									'dependency' => Array(
										'element' => 'curtain', 'value' => 'true'
									)
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Curtain color','mobimax'),
									'group'      => esc_html__('Curtain effect','mobimax'),
									'param_name' => 'curtain_color',
									'value'      => $main_color,
									'dependency' => Array(
										'element' => 'curtain', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__( 'Animation delay in ms (example 300)', 'mobimax' ),
									'group'      => esc_html__('Curtain effect','mobimax'),
									'param_name' => 'curtain_animation_delay',
									'value'      => $animation_delay_values,
									'dependency' => Array(
										'element' => 'curtain', 'value' => 'true'
									)
								),
						)
					));

			    /* et_icon
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Icon','mobimax'),
						'description'             => esc_html__('Insert icon','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_icon',
						'class'                   => 'et_icon',
						'icon'                    => 'et_icon',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon prefix','mobimax'),
								'param_name' => 'icon_prefix',
								'value'      => '',
								'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
							),
							array(
								'type'       => 'textfield',

								'heading'    => esc_html__('Icon name','mobimax'),
								'param_name' => 'icon_name',
								'value'      => '',
								'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
							),
			    			array(
								'param_name'=>'icon_size',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Size', 'mobimax'),
								'value'     => $size_values_extra,
								'std'       => 'medium'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'param_name' => 'icon_color',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'param_name' => 'icon_back_color',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'param_name' => 'icon_border_color',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon border radius (without any string)','mobimax'),
								'param_name' => 'icon_border_radius',
								'value'      => '0'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon border width (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

			    /* et_icon_list
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Icon list','mobimax'),
						'description'             => esc_html__('Insert icon list','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_icon_list',
						'class'                   => 'et_icon_list',
						'icon'                    => 'et_icon_list',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon-list.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon-list.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon prefix','mobimax'),
								'param_name' => 'icon_prefix',
								'value'      => '',
								'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
							),
							array(
								'type'       => 'textfield',

								'heading'    => esc_html__('Icon name','mobimax'),
								'param_name' => 'icon_name',
								'value'      => '',
								'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
							),
			    			array(
								'param_name'=>'icon_size',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Size', 'mobimax'),
								'value'     => $size_values_default,
								'std'       => 'medium'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'param_name' => 'icon_color',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'param_name' => 'icon_back_color',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'param_name' => 'icon_border_color',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon border radius (without any string)','mobimax'),
								'param_name' => 'icon_border_radius',
								'value'      => '0'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon border width (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Shadow','mobimax'),
								'param_name' => 'shadow',
								'value'      => ''
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('List items','mobimax'),
								'param_name' => 'content',
								'value'      => '',
								'description' => esc_html__('Use line break (press Enter) to separate between items','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

			    /* et_accordion
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Accordion','mobimax'),
			    		'description'             => esc_html__('Insert accordion','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_accordion',
			    		'class'                   => 'et_accordion',
			    		'icon'                    => 'et_accordion',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-accordion.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-accordion.js',
			    		'as_parent'               => array('only' => 'et_accordion_item'),
			    		'content_element'         => true,
			    		'show_settings_on_create' => true,
			    		'is_container'            => true,
			    		'js_view'                 => 'VcColumnView',
			    		'params'                  => array(
			    			array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Collapsible','mobimax'),
								'param_name' => 'collapsible',
								'value'      => $logic_values
							),
			    		)
			    	));


			    	vc_map(array(
						'name'                    => esc_html__('Accordion item','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_accordion_item',
						'class'                   => 'et_accordion_item',
						'icon'                    => 'et_accordion_item',
						'as_child'                => array('only' => 'et_accordion'),
	    				"as_parent"               => array('except' => 'vc_section'),
	    				'content_element'         => true,
						"js_view"                 => 'VcColumnView',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Open','mobimax'),
								'param_name' => 'open',
								'value'      => $logic_values
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon prefix','mobimax'),
								'param_name' => 'icon_prefix',
								'value'      => '',
								'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon name','mobimax'),
								'param_name' => 'icon_name',
								'value'      => '',
								'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
							),
							array(
			    				'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => ''
							)
						)
					));

			    /* et_tabs
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Tabs','mobimax'),
			    		'description'             => esc_html__('Insert tabs','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_tab',
			    		'class'                   => 'et_tab',
			    		'icon'                    => 'et_tab',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-tab.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-tab.js',
			    		'as_parent'               => array('only' => 'et_tab_item'),
			    		'content_element'         => true,
			    		'show_settings_on_create' => true,
			    		'is_container'            => true,
			    		'js_view'                 => 'VcColumnView',
			    		'params'                  => array(
			    			array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Type','mobimax'),
								'param_name' => 'type',
								'value'      => array(
									esc_html__('Horizontal','mobimax')  => 'horizontal',
									esc_html__('Vertical','mobimax')  => 'vertical',
								)
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Tabs center','mobimax'),
								'param_name' => 'center',
							),
			    		)
			    	));


			    	vc_map(array(
						'name'                    => esc_html__('Tab','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_tab_item',
						'class'                   => 'et_tab_item',
						'icon'                    => 'et_tab_item',
						'as_child'                => array('only' => 'et_tab'),
	    				"as_parent"               => array('except' => 'vc_section'),
	    				'content_element'         => true,
						"js_view"                 => 'VcColumnView',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Active','mobimax'),
							'param_name' => 'active',
							'value'      => array(
								'false' => 'false',
								'true'  => 'true'
							)
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Icon prefix','mobimax'),
							'param_name' => 'icon_prefix',
							'value'      => '',
							'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Icon name','mobimax'),
							'param_name' => 'icon_name',
							'value'      => '',
							'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
						),
						array(
		    				'type'       => 'textfield',
							'heading'    => esc_html__('Title','mobimax'),
							'param_name' => 'title',
							'value'      => ''
						),
						)
					));

			/* SOCIAL
			---------------*/

				/* et_social_icons
				---------------*/

					foreach ($social_links_array as $social) {
						vc_add_param('et_social_links', array(
							'type'       => 'textfield',
							'heading'    => ucfirst($social).' link',
							'param_name' => $social,
							'value'      => '',
							'weight' => 1
						));
					}

			    	vc_map(array(
						'name'                    => esc_html__('Social links','mobimax'),
			    		'description'             => esc_html__('Use to add social links','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_social_links',
			    		'class'                   => 'et_social_links',
			    		'icon'                    => 'et_social_links',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-social-links.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-social-links.js',
						'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),
							array(
								'param_name'=>'target',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Target', 'mobimax'),
								'value'     => array(
									'_self'  => '_self',
									'_blank' => '_blank'
								)
							),

							/* styling
							---------------*/

								array(
									'param_name'=>'shadow',
									'type'      => 'checkbox',
									'group'     => esc_html__('Styling','mobimax'),
									'heading'   => esc_html__('Shadow', 'mobimax'),
									'value'     => ''
								),

								array(
									'param_name'=>'styling_original',
									'type'      => 'dropdown',
									'group'     => esc_html__('Styling','mobimax'),
									'heading'   => esc_html__('Original styling', 'mobimax'),
									'value'     => $logic_values
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon color','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'icon_color',
									'value'      => '#616161',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon color hover','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'icon_color_hover',
									'value'      => '#212121',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon background color','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'icon_background_color',
									'value'      => '',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon background color hover','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'icon_background_color_hover',
									'value'      => '',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon border color','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'icon_border_color',
									'value'      => '',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon border color hover','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'icon_border_color_hover',
									'value'      => '',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Icon border width (without any string)','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'icon_border_width',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

				/* et_social_icons
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Social share','mobimax'),
			    		'description'             => esc_html__('Use to add social sharing','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_social_share',
			    		'class'                   => 'et_social_share',
			    		'icon'                    => 'et_social_share',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-social-share.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-social-share.js',
						'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),

							/* styling
							---------------*/

								array(
									'param_name'=>'shadow',
									'type'      => 'checkbox',
									'heading'   => esc_html__('Shadow', 'mobimax'),
									'value'     => ''
								),

								array(
									'param_name'=>'styling_original',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Original styling', 'mobimax'),
									'value'     => $logic_values
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon color','mobimax'),
									'param_name' => 'icon_color',
									'value'      => '#616161',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon color hover','mobimax'),
									'param_name' => 'icon_color_hover',
									'value'      => '#212121',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon background color','mobimax'),
									'param_name' => 'icon_background_color',
									'value'      => '',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon background color hover','mobimax'),
									'param_name' => 'icon_background_color_hover',
									'value'      => '',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon border color','mobimax'),
									'param_name' => 'icon_border_color',
									'value'      => '',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon border color hover','mobimax'),
									'param_name' => 'icon_border_color_hover',
									'value'      => '',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Icon border width (without any string)','mobimax'),
									'param_name' => 'icon_border_width',
									'dependency' => Array('element' => 'styling_original', 'value' => 'false')
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

				/* et_mailchimp
				---------------*/

	 				$list_array = enovathemes_addons_mailchimp_list();

	 				$list_values = array('' => "Choose list");

	 				if ( !is_wp_error( $list_array ) && is_array($list_array)){

	 					foreach ( $list_array as $list){
	 						$list_values[$list['id']] = $list['name'];
	 					}
	 				}

					$list_values = array_flip($list_values);

					if (empty($list_values)) {
						array_push($list_values, esc_html__('Mailchimp did not return any list','mobimax'));
					}

			    	vc_map(array(
			    		'name'                    => esc_html__('Mailchimp','mobimax'),
			    		'description'             => esc_html__('Use to add AJAX mailchimp subscribe','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_mailchimp',
			    		'class'                   => 'et_mailchimp',
			    		'icon'                    => 'et_mailchimp',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mailchimp.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mailchimp.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('List','mobimax'),
								'description'=> esc_html__('Make sure you have the Mailchimp API key and at least one list in your Mailchimp dashboard. Go to theme options >> general >> Mailchimp API key','mobimax'),
								'param_name' => 'list',
								'value'      => $list_values,
							),

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Text field color','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'text_color',
									'value'      => '#616161',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Text field color focus','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'text_color_focus',
									'value'      => '#616161',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Text field background color','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'text_background_color',
									'value'      => '#ffffff',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Text field background color focus','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'text_background_color_focus',
									'value'      => '#ffffff',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Text field border color','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'text_border_color',
									'value'      => '#e0e0e0',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Text field border color focus','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'text_border_color_focus',
									'value'      => '#bdbdbd',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button background color','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'button_background_color',
									'value'      => $main_color,
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button background color hover','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'button_background_color_hover',
									'value'      => '#212121',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button text color','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'button_color',
									'value'      => '#ffffff',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Button text color hover','mobimax'),
									'group'     => esc_html__('Styling','mobimax'),
									'param_name' => 'button_color_hover',
									'value'      => '#ffffff',
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

			/* SELFHOSTED
			---------------*/

				/* et_icon_box_container
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Icon box container','mobimax'),
						'description'             => esc_html__('Insert icon box container','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_icon_box_container',
						'class'                   => 'et_icon_box_container',
						'icon'                    => 'et_icon_box_container',
						"as_parent"               => array('only' => 'et_icon_box'),
	    				'content_element'         => true,
						"js_view"                 => 'VcColumnView',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon-box-container.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon-box-container.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Grid border color','mobimax'),
								'param_name' => 'border_color',
								'value'      => ''
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Shadow','mobimax'),
								'param_name' => 'shadow',
								'value'      => ''
							),
							array(
								'param_name'=>'columns',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Column', 'mobimax'),
								'value'     => array(
									'1'  => '1',
									'2'  => '2',
									'3'  => '3',
									'4'  => '4',
								)
							),
							array(
								'param_name'=>'gap',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Gap', 'mobimax'),
								'value'     => $gap_values
							),
							array(
								'param_name'=>'height',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Min height', 'mobimax'),
								'value'     => array(
									'0'      => '0',
									'100vh'  => '100vh',
									'70vh'   => '70vh',
									'60vh'   => '60vh',
									'50vh'   => '50vh',
									'custom'  => 'custom',
								)
							),
							array(
								'param_name'=>'custom-height',
								'type'      => 'textfield',
								'heading'   => esc_html__('Custom min height value (enter any value you need using all available units)', 'mobimax'),
								'value'     => '',
								'dependency' => Array(
									'element' => 'height', 'value' => 'custom',
								)
							),
							array(
								'param_name'=>'vertical_align',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Vertical align boxes', 'mobimax'),
								'value'     => array(
									'top'     => 'top',
									'middle'  => 'middle',
									'bottom'  => 'bottom',
								),
								'dependency' => Array(
									'element' => 'height', 'value' => array('100vh','70vh','60vh','50vh','custom'),
								)
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Box animation','mobimax'),
								'param_name' => 'animation',
								'value'      => array(
									esc_html__('None','mobimax')   => 'none',
									esc_html__('Fade','mobimax') => 'fadeIn',
									esc_html__('Move','mobimax') => 'moveUp',
								)
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Box animation type','mobimax'),
								'param_name' => 'animation_type',
								'value'      => $animation_type_values,
								'dependency' => Array(
									'element' => 'animation', 'value' => array('fadeIn','moveUp'),
								)
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

				/* et_icon_box
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Icon box','mobimax'),
						'description'             => esc_html__('Insert icon box','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_icon_box',
						'class'                   => 'et_icon_box',
						'icon'                    => 'et_icon_box',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon-box.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-icon-box.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon prefix','mobimax'),
								'param_name' => 'icon_prefix',
								'value'      => '',
								'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon name','mobimax'),
								'param_name' => 'icon_name',
								'value'      => '',
								'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
							),
			    			array(
								'param_name'=>'icon_size',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Icon size', 'mobimax'),
								'value'     => array(
									esc_html__('Small','mobimax')    => 'small',
									esc_html__('Medium','mobimax')   => 'medium',
									esc_html__('Large','mobimax')    => 'large',
									esc_html__('Large X','mobimax')  => 'large-x',
									esc_html__('Large XX','mobimax') => 'large-xx',
								),
								'std' => 'large'
							),
							array(
								'param_name'=>'icon_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Icon position', 'mobimax'),
								'value'     => array(
									esc_html__('Top','mobimax')  => 'top',
									esc_html__('Left','mobimax')  => 'left',
									esc_html__('Right','mobimax')  => 'right',
								),
							),
							array(
								'param_name'=>'icon_alignment',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Icon alignment', 'mobimax'),
								'value'     => $align_values,
								'dependency' => Array(
									'element' => 'icon_position', 'value' => 'top',
								)
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Hover animation','mobimax'),
								'param_name' => 'hover',
								'value'      => array(
									esc_html__('None','mobimax')      => 'none',
									esc_html__('Scale','mobimax')     => 'scale',
									esc_html__('Glint','mobimax')     => 'glint',
									esc_html__('Transform','mobimax') => 'transform',
									esc_html__('Ghost','mobimax')     => 'ghost',
								)
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),


							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'icon_color',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon color hover','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'icon_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon background color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'icon_back_color',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon background color hover','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'icon_back_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon border color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'icon_border_color',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Icon border color hover','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'icon_border_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Icon border radius (without any string)','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'icon_border_radius',
									'value'      => '0'
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Icon border width (without any string)','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'icon_border_width',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Title color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'title_color',
									'value'      => '#212121'
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Title color hover','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'title_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Content color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'text_color',
									'value'      => '#616161'
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Content color hover','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'text_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Box background color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'box_color',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Box background color hover','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'box_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Box border width (without any string)','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'box_border_width',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Box border color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'box_border_color',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Box border color hover','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'box_border_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Shadow','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'shadow',
									'value'      => ''
								),

							/* content
							---------------*/

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Title','mobimax'),
									'group'      => esc_html__('Content', 'mobimax'),
									'param_name' => 'title',
									'value'      => ''
								),
								array(
									'param_name'=>'title_tag',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Tag', 'mobimax'),
									'group'      => esc_html__('Content', 'mobimax'),
									'value'     => array(
										'H1'  => 'h1',
										'H2'  => 'h2',
										'H3'  => 'h3',
										'H4'  => 'h4',
										'H5'  => 'h5',
										'H6'  => 'h6',
										'p'   => 'p',
										'div' => 'div',
									),
									'std' => 'h4'
								),
								array(
									'type'       => 'textarea_html',
									'heading'    => esc_html__('Content','mobimax'),
									'group'      => esc_html__('Content', 'mobimax'),
									'param_name' => 'content',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Link','mobimax'),
									'group'      => esc_html__('Content', 'mobimax'),
									'param_name' => 'link',
									'value'      => ''
								),

							/* padding
							---------------*/

								array(
									'type'       => 'padding',
									'group'      => esc_html__('Padding','mobimax'),
									'heading'    => esc_html__('Padding','mobimax'),
									'param_name' => 'padding',
									'value'      => '48,32,48,32'
								),

							/* parallax
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Parallax','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset X coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_x',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset Y coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_y',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Parallax speed radtio','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'description'=> esc_html__('The more the value is the slower the parallax effect is','mobimax'),
									'param_name' => 'parallax_speed',
									'value'     => array(
										'1'  => '1',
										'2'  => '2',
										'3'  => '3',
										'4'  => '4',
										'5'  => '5',
										'6'  => '6',
										'7'  => '7',
										'8'  => '8',
										'9'  => '9',
										'10' => '10',
										'11' => '11',
										'12' => '12',
										'13' => '13',
										'14' => '14',
										'15' => '15',
										'16' => '16',
										'17' => '17',
										'18' => '18',
										'19' => '19',
										'20' => '20'
									),
									'std' => '10',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Move on mouse move','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'move',
									'value'      => '',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'rp',
									'heading'    => esc_html__( 'Responsive parallax', 'mobimax' ),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'rp',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

				/* et_step_box_container
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Step box container','mobimax'),
						'description'             => esc_html__('Insert step box container','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_step_box_container',
						'class'                   => 'et_step_box_container',
						'icon'                    => 'et_step_box_container',
						"as_parent"               => array('only' => 'et_step_box'),
	    				'content_element'         => true,
						"js_view"                 => 'VcColumnView',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-step-box-container.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-step-box-container.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Dot color','mobimax'),
								'param_name' => 'color',
								'value'      => $main_color
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Dot text color','mobimax'),
								'param_name' => 'text_color',
								'value'      => ''
							),
							array(
								'param_name'=>'columns',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Column', 'mobimax'),
								'value'     => array(
									'1'  => '1',
									'2'  => '2',
									'3'  => '3',
									'4'  => '4',
								)
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

				/* et_step_box
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Step box','mobimax'),
						'description'             => esc_html__('Insert step box','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_step_box',
						'class'                   => 'et_step_box',
						'icon'                    => 'et_step_box',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-step-box.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-step-box.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),


							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Title color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'title_color',
									'value'      => '#212121'
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Content color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'text_color',
									'value'      => '#616161'
								),

							/* content
							---------------*/

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Title','mobimax'),
									'group'      => esc_html__('Content', 'mobimax'),
									'param_name' => 'title',
									'value'      => ''
								),
								array(
									'param_name'=>'title_tag',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Tag', 'mobimax'),
									'group'      => esc_html__('Content', 'mobimax'),
									'value'     => array(
										'H1'  => 'h1',
										'H2'  => 'h2',
										'H3'  => 'h3',
										'H4'  => 'h4',
										'H5'  => 'h5',
										'H6'  => 'h6',
										'p'   => 'p',
										'div' => 'div',
									),
									'std' => 'h4'
								),
								array(
									'type'       => 'textarea_html',
									'heading'    => esc_html__('Content','mobimax'),
									'group'      => esc_html__('Content', 'mobimax'),
									'param_name' => 'content',
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

			    /* et_make_container
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Make container','mobimax'),
						'description'             => esc_html__('Vehicle makes container','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_make_container',
						'class'                   => 'et_make_container',
						'icon'                    => 'et_make_container',
						"as_parent"               => array('only' => 'et_make'),
	    				'content_element'         => true,
						"js_view"                 => 'VcColumnView',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-make-container.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-make-container.js',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Grid border color','mobimax'),
								'param_name' => 'border_color',
								'value'      => ''
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Shadow','mobimax'),
								'param_name' => 'shadow',
								'value'      => ''
							),
							array(
								'param_name'=>'icon_size',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Icon size', 'mobimax'),
								'value'     => array(
									esc_html__('Small','mobimax')    => 'small',
									esc_html__('Medium','mobimax')   => 'medium',
									esc_html__('Large','mobimax')    => 'large',
								),
								'std' => 'small'
							),
							array(
								'param_name'=>'columns',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Column', 'mobimax'),
								'value'     => array(
									'1'  => '1',
									'2'  => '2',
									'3'  => '3',
									'4'  => '4',
									'5'  => '5',
									'6'  => '6',
									'7'  => '7',
									'8'  => '8',
								),
								'std' => '8'
							),
							array(
								'param_name'=>'gap',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Gap', 'mobimax'),
								'value'     => $gap_values_short
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Box animation','mobimax'),
								'param_name' => 'animation',
								'value'      => array(
									esc_html__('None','mobimax')   => 'none',
									esc_html__('Fade','mobimax') => 'fadeIn',
									esc_html__('Move','mobimax') => 'moveUp',
								)
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Box animation type','mobimax'),
								'param_name' => 'animation_type',
								'value'      => $animation_type_values,
								'dependency' => Array(
									'element' => 'animation', 'value' => array('fadeIn','moveUp'),
								)
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

				/* et_make
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Make','mobimax'),
						'description'             => esc_html__('Insert make','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_make',
						'class'                   => 'et_make',
						'icon'                    => 'et_make',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-make.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-make.js',
						'show_settings_on_create' => true,
						'content_element'         => true,
			    		'as_child'                => array('only' => 'et_make_container'),
						'params'                  => array(

							array(
								'type'       => 'icon_make',
								'heading'    => esc_html__('Icon','mobimax'),
								'param_name' => 'icon',
							),

							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Custom make image','mobimax'),
								'param_name' => 'image',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),


							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Title color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'title_color',
									'value'      => '#212121'
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Title color hover','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'title_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Box background color','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'box_color',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Box background color hover','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'box_color_hover',
									'value'      => ''
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Shadow','mobimax'),
									'group'      => esc_html__('Styling', 'mobimax'),
									'param_name' => 'shadow',
									'value'      => ''
								),

							/* content
							---------------*/

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Title','mobimax'),
									'group'      => esc_html__('Content', 'mobimax'),
									'param_name' => 'title',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Link','mobimax'),
									'group'      => esc_html__('Content', 'mobimax'),
									'param_name' => 'link',
									'value'      => ''
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
						)
					));

				/* et_carousel
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Carousel','mobimax'),
			    		'description'             => esc_html__('Insert carousel with any content you want','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_carousel',
			    		'class'                   => 'et_carousel',
			    		'icon'                    => 'et_carousel',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-carousel.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-carousel.js',
			    		'show_settings_on_create' => true,
				    	'content_element'         => true,
						"js_view"                 => 'VcColumnView',
			    		'as_parent'               => array('only' => 'et_carousel_item'),
			    		'params'                  => array(
							array(
								'param_name'=>'columns',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Column', 'mobimax'),
								'value'     => array(
									'1'  => '1',
									'2'  => '2',
									'3'  => '3',
									'4'  => '4',
									'5'  => '5',
									'6'  => '6',
								)
							),
							array(
								'param_name'=>'gap',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Gap', 'mobimax'),
								'value'     => $gap_values_short
							),
							array(
								'param_name'=>'navigation_type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation type', 'mobimax'),
								'value'     => array(
									esc_html__('Only arrows','mobimax')  => 'only-arrows',
									esc_html__('Only bullets','mobimax')  => 'only-bullets',
									esc_html__('Both arrows and bullets','mobimax')  => 'both'
								)
							),
							array(
								'param_name'=>'arrows_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Arrows position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'navigation_type', 'value' => 'only-arrows'
								)
							),
							array(
								'param_name'=>'bullets_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Bullets position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'navigation_type', 'value' => 'only-bullets'
								)
							),
							array(
								'param_name'=>'navigation_visibility',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation visibility', 'mobimax'),
								'value'     => array(
									esc_html__('On mouseover','mobimax')  => 'mouseover',
									esc_html__('Always','mobimax')    => 'always',
								)
							),
							array(
								'param_name'=>'autoplay',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Autoplay', 'mobimax'),
								'value'     => $logic_values
							),
			    		)
			    	));

			    	vc_map(array(
			    		'name'                    => 'Carousel item',
			    		'description'             => esc_html__('Insert carousel item','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_carousel_item',
			    		'class'                   => 'et_carousel_item',
			    		'icon'                    => 'et_carousel_item',
			    		'show_settings_on_create' => false,
				    	'content_element'         => true,
			    		'as_child'                => array('only' => 'et_carousel'),
			    		"as_parent"               => array('except' => 'vc_section'),
						"js_view"                 => 'VcColumnView',
			    		'params'                  => array()
			    	));

			    /* et_pricing_table
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Pricing table','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'description'             => esc_html__('Use to display your service/product pricing','mobimax'),
			    		'base'                    => 'et_pricing_table',
			    		'icon'                    => 'et_pricing_table',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-pricing-table.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-pricing-table.js',
			    		'content_element'         => true,
			    		'params'                  => array(
			    			array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Color','mobimax'),
								'param_name' => 'color',
								'value'      => ''
							),
			    			array(
			    				'type'       => 'checkbox',
								'heading'    => esc_html__('Highlight', 'mobimax'),
								'param_name' => 'highlight',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Label','mobimax'),
								'param_name' => 'label',
								'value'      => ''
							),
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Currency','mobimax'),
								'param_name' => 'currency',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Price','mobimax'),
								'param_name' => 'price',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Plan','mobimax'),
								'param_name' => 'plan',
								'value'      => ''
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('List items','mobimax'),
								'param_name' => 'content',
								'value'      => '',
								'description' => esc_html__('Use line break (press Enter) to separate between items','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button text','mobimax'),
								'param_name' => 'button_text',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button link','mobimax'),
								'param_name' => 'button_link',
								'value'      => ''
							),
							array(
								'param_name'=>'target',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Target', 'mobimax'),
								'value'     => array(
									'_self'  => '_self',
									'_blank' => '_blank'
								)
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_testimonial
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Testimonial carousel container','mobimax'),
			    		'description'             => esc_html__('Add testimonials to carousel container','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_testimonial_container',
			    		'class'                   => 'et_testimonial_container',
			    		'icon'                    => 'et_testimonial_container',
			    		'show_settings_on_create' => true,
				    	'content_element'         => true,
			    		'js_view'                 => 'VcColumnView',
			    		'as_parent'               => array('only' => 'et_testimonial'),
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-testimonial-container.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-testimonial-container.js',
			    		'params'                  => array(
							array(
								'param_name'=>'columns',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Column', 'mobimax'),
								'value'     => array(
									'1'  => '1',
									'2'  => '2',
									'3'  => '3',
									'4'  => '4',
								)
							),
							array(
								'param_name'=>'gap',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Gap', 'mobimax'),
								'value'     => $gap_values_short
							),
							array(
								'param_name'=>'navigation_type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation type', 'mobimax'),
								'value'     => array(
									esc_html__('Only arrows','mobimax')  => 'only-arrows',
									esc_html__('Only bullets','mobimax')  => 'only-bullets',
									esc_html__('Both arrows and bullets','mobimax')  => 'both'
								)
							),
							array(
								'param_name'=>'arrows_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Arrows position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'navigation_type', 'value' => 'only-arrows'
								)
							),
							array(
								'param_name'=>'bullets_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Bullets position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'navigation_type', 'value' => 'only-bullets'
								)
							),
							array(
								'param_name'=>'navigation_visibility',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation visibility', 'mobimax'),
								'value'     => array(
									esc_html__('On mouseover','mobimax')  => 'mouseover',
									esc_html__('Always','mobimax')    => 'always',
								),
							),
							array(
								'param_name'=>'autoplay',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Autoplay', 'mobimax'),
								'value'     => $logic_values
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							)
			    		)
			    	));

			    	vc_map(array(
			    		'name'                    => esc_html__('Testimonial','mobimax'),
			    		'description'             => esc_html__('Add testimonial','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_testimonial',
			    		'class'                   => 'et_testimonial',
			    		'icon'                    => 'et_testimonial',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-testimonial.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-testimonial.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Content','mobimax'),
								'param_name' => 'text',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Author','mobimax'),
								'param_name' => 'author',
								'value'      => '',
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Rating','mobimax'),
								'param_name' => 'rating',
								'value'      => array(
									esc_html__('None','mobimax')      => 'none',
									esc_html__('Poor','mobimax')      => 'poor',
									esc_html__('Fair','mobimax')      => 'fair',
									esc_html__('Average','mobimax')   => 'average',
									esc_html__('Good','mobimax')      => 'good',
									esc_html__('Excellent','mobimax') => 'excellent',
								),
								'std' => 'excellent'
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Author image','mobimax'),
								'param_name' => 'image',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),
			    		)
			    	));

			    /* et_client
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Client container','mobimax'),
			    		'description'             => esc_html__('Add clients to container','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_client_container',
			    		'class'                   => 'et_client_container',
			    		'icon'                    => 'et_client_container',
			    		'show_settings_on_create' => true,
			    		'is_container'            => true,
				    	'content_element'         => true,
			    		'js_view'                 => 'VcColumnView',
			    		'as_parent'               => array('only' => 'et_client'),
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-client-container.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-client-container.js',
			    		'params'                  => array(
			    			array(
								'param_name'=>'type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Type', 'mobimax'),
								'value'     => array(
									esc_html__('Grid', 'mobimax')     => 'grid',
									esc_html__('Carousel', 'mobimax') => 'carousel',
								)
							),
							array(
								'param_name'=>'border',
								'type'      => 'checkbox',
								'heading'   => esc_html__('Border', 'mobimax'),
								'dependency'=> Array('element' => 'type', 'value' => 'grid')
							),
							array(
								'param_name'=>'columns',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Column', 'mobimax'),
								'value'     => array(
									'1'  => '1',
									'2'  => '2',
									'3'  => '3',
									'4'  => '4',
									'5'  => '5',
									'6'  => '6',
								)
							),
							array(
								'param_name'=>'gap',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Gap', 'mobimax'),
								'value'     => $gap_values_short
							),
							array(
								'param_name'=>'navigation_type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation type', 'mobimax'),
								'value'     => array(
									esc_html__('Only arrows','mobimax')  => 'only-arrows',
									esc_html__('Only bullets','mobimax')  => 'only-bullets',
									esc_html__('Both arrows and bullets','mobimax')  => 'both'
								),
								'dependency' => Array('element' => 'type', 'value' => 'carousel')
							),
							array(
								'param_name'=>'arrows_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Arrows position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'type', 'value' => 'carousel',
									'element' => 'navigation_type', 'value' => 'only-arrows'
								)
							),
							array(
								'param_name'=>'bullets_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Bullets position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'type', 'value' => 'carousel',
									'element' => 'navigation_type', 'value' => 'only-bullets'
								)
							),
							array(
								'param_name'=>'navigation_visibility',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation visibility', 'mobimax'),
								'value'     => array(
									esc_html__('On mouseover','mobimax')  => 'mouseover',
									esc_html__('Always','mobimax')    => 'always',
								),
								'dependency' => Array('element' => 'type', 'value' => array('carousel'))
							),
							array(
								'param_name'=>'autoplay',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Autoplay', 'mobimax'),
								'value'     => $logic_values,
								'dependency' => Array('element' => 'type', 'value' => 'carousel')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							)
			    		)
			    	));

			    	vc_map(array(
			    		'name'                    => esc_html__('Client','mobimax'),
			    		'description'             => esc_html__('Add client','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_client',
			    		'class'                   => 'et_client',
			    		'icon'                    => 'et_client',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-client.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-client.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Link','mobimax'),
								'param_name' => 'link',
								'value'      => '',
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Client image','mobimax'),
								'param_name' => 'image',
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Client image hover','mobimax'),
								'param_name' => 'image_hover',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Client background color','mobimax'),
								'param_name' => 'color',
								'value'      => '',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Client background color hover','mobimax'),
								'param_name' => 'color_hover',
								'value'      => '',
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

			    /* et_person
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Person carousel container','mobimax'),
			    		'description'             => esc_html__('Add persons to carousel container','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_person_container',
			    		'class'                   => 'et_person_container',
			    		'icon'                    => 'et_person_container',
			    		'show_settings_on_create' => true,
			    		'is_container'            => true,
				    	'content_element'         => true,
			    		'js_view'                 => 'VcColumnView',
			    		'as_parent'               => array('only' => 'et_person'),
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-person-container.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-person-container.js',
			    		'params'                  => array(
							array(
								'param_name'=>'columns',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Column', 'mobimax'),
								'value'     => array(
									'1'  => '1',
									'2'  => '2',
									'3'  => '3',
									'4'  => '4',
								)
							),
							array(
								'param_name'=>'gap',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Gap', 'mobimax'),
								'value'     => $gap_values_short
							),
							array(
								'param_name'=>'navigation_type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation type', 'mobimax'),
								'value'     => array(
									esc_html__('Only arrows','mobimax')  => 'only-arrows',
									esc_html__('Only bullets','mobimax')  => 'only-bullets',
									esc_html__('Both arrows and bullets','mobimax')  => 'both'
								)
							),
							array(
								'param_name'=>'arrows_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Arrows position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'navigation_type', 'value' => 'only-arrows'
								)
							),
							array(
								'param_name'=>'bullets_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Bullets position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'navigation_type', 'value' => 'only-bullets'
								)
							),
							array(
								'param_name'=>'navigation_visibility',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation visibility', 'mobimax'),
								'value'     => array(
									esc_html__('On mouseover','mobimax')  => 'mouseover',
									esc_html__('Always','mobimax')    => 'always',
								),
							),
							array(
								'param_name'=>'autoplay',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Autoplay', 'mobimax'),
								'value'     => $logic_values
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							)
			    		)
			    	));

			    	foreach ($social_links_array as $social) {
						vc_add_param('et_person', array(
							'type'       => 'textfield',
							'heading'    => ucfirst($social).' link',
							'group'      => esc_html__('Social','mobimax'),
							'param_name' => $social,
							'value'      => '',
						));
					}

			    	vc_map(array(
			    		'name'                    => esc_html__('Person','mobimax'),
			    		'description'             => esc_html__('Add person','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_person',
			    		'class'                   => 'et_person',
			    		'icon'                    => 'et_person',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-person.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-person.js',
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Name','mobimax'),
								'param_name' => 'name',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Image','mobimax'),
								'param_name' => 'image',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),
			    		)
			    	));

			    /* et_map
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Google map','mobimax'),
			    		'description'             => esc_html__('Inser google map','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_map',
			    		'class'                   => 'et_map',
			    		'icon'                    => 'et_map',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-map.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-map.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Google map zoom level (from 1 to 19 without any string)','mobimax'),
								'param_name' => 'zoom',
								'value'      => '18'
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Type','mobimax'),
								'param_name' => 'type',
								'value'      => array(
									esc_html__('Roadmap','mobimax')    => 'roadmap',
									esc_html__('Satellite','mobimax')  => 'satellite',
									esc_html__('Black','mobimax')      => 'black',
									esc_html__('Grey','mobimax')      => 'grey',
								)
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Width','mobimax'),
								'param_name' => 'width',
								'value'      => '100%'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Height','mobimax'),
								'param_name' => 'height',
								'value'      => '480px'
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Upload custom marker','mobimax'),
								'param_name' => 'marker',
								'value'      => ''
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__('X coordinate','mobimax'),
								'group'       => esc_html__('Location 1','mobimax'),
								'param_name'  => 'x_coords_1',
								'value'       => '',
								'description' => esc_html__('Use latitude coordinate for example 53.339381','mobimax'),
							),
			    			array(
								'type'        => 'textfield',
								'heading'     => esc_html__('Y coordinate','mobimax'),
								'group'       => esc_html__('Location 1','mobimax'),
								'param_name'  => 'y_coords_1',
								'value'       => '',
								'description' => esc_html__('Use longitude coordinate for example -6.260405','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'group'       => esc_html__('Location 1','mobimax'),
								'param_name' => 'title_1',
								'value'      => ''
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Image','mobimax'),
								'group'       => esc_html__('Location 1','mobimax'),
								'param_name' => 'image_1',
								'value'      => ''
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Content','mobimax'),
								'group'       => esc_html__('Location 1','mobimax'),
								'param_name' => 'content_1',
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__('X coordinate','mobimax'),
								'group'       => esc_html__('Location 2','mobimax'),
								'param_name'  => 'x_coords_2',
								'value'       => '',
								'description' => esc_html__('Use latitude coordinate for example 53.339381','mobimax'),
							),
			    			array(
								'type'        => 'textfield',
								'heading'     => esc_html__('Y coordinate','mobimax'),
								'group'       => esc_html__('Location 2','mobimax'),
								'param_name'  => 'y_coords_2',
								'value'       => '',
								'description' => esc_html__('Use longitude coordinate for example -6.260405','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'group'       => esc_html__('Location 2','mobimax'),
								'param_name' => 'title_2',
								'value'      => ''
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Image','mobimax'),
								'group'       => esc_html__('Location 2','mobimax'),
								'param_name' => 'image_2',
								'value'      => ''
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Content','mobimax'),
								'group'       => esc_html__('Location 2','mobimax'),
								'param_name' => 'content_2',
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__('X coordinate','mobimax'),
								'group'       => esc_html__('Location 3','mobimax'),
								'param_name'  => 'x_coords_3',
								'value'       => '',
								'description' => esc_html__('Use latitude coordinate for example 53.339381','mobimax'),
							),
			    			array(
								'type'        => 'textfield',
								'heading'     => esc_html__('Y coordinate','mobimax'),
								'group'       => esc_html__('Location 3','mobimax'),
								'param_name'  => 'y_coords_3',
								'value'       => '',
								'description' => esc_html__('Use longitude coordinate for example -6.260405','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'group'       => esc_html__('Location 3','mobimax'),
								'param_name' => 'title_3',
								'value'      => ''
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Image','mobimax'),
								'group'       => esc_html__('Location 3','mobimax'),
								'param_name' => 'image_3',
								'value'      => ''
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Content','mobimax'),
								'group'       => esc_html__('Location 3','mobimax'),
								'param_name' => 'content_3',
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__('X coordinate','mobimax'),
								'group'       => esc_html__('Location 4','mobimax'),
								'param_name'  => 'x_coords_4',
								'value'       => '',
								'description' => esc_html__('Use latitude coordinate for example 53.339381','mobimax'),
							),
			    			array(
								'type'        => 'textfield',
								'heading'     => esc_html__('Y coordinate','mobimax'),
								'group'       => esc_html__('Location 4','mobimax'),
								'param_name'  => 'y_coords_4',
								'value'       => '',
								'description' => esc_html__('Use longitude coordinate for example -6.260405','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'group'       => esc_html__('Location 4','mobimax'),
								'param_name' => 'title_4',
								'value'      => ''
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Image','mobimax'),
								'group'       => esc_html__('Location 4','mobimax'),
								'param_name' => 'image_4',
								'value'      => ''
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Content','mobimax'),
								'group'       => esc_html__('Location 4','mobimax'),
								'param_name' => 'content_4',
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__('X coordinate','mobimax'),
								'group'       => esc_html__('Location 5','mobimax'),
								'param_name'  => 'x_coords_5',
								'value'       => '',
								'description' => esc_html__('Use latitude coordinate for example 53.339381','mobimax'),
							),
			    			array(
								'type'        => 'textfield',
								'heading'     => esc_html__('Y coordinate','mobimax'),
								'group'       => esc_html__('Location 5','mobimax'),
								'param_name'  => 'y_coords_5',
								'value'       => '',
								'description' => esc_html__('Use longitude coordinate for example -6.260405','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'group'       => esc_html__('Location 5','mobimax'),
								'param_name' => 'title_5',
								'value'      => ''
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Image','mobimax'),
								'group'       => esc_html__('Location 5','mobimax'),
								'param_name' => 'image_5',
								'value'      => ''
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Content','mobimax'),
								'group'       => esc_html__('Location 5','mobimax'),
								'param_name' => 'content_5',
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_banner
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Popup banner','mobimax'),
			    		'description'             => esc_html__('Insert popup banner (if you want to have the popup in entire site, put the banner inside footer)','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_banner',
			    		'class'                   => 'et_banner',
			    		'icon'                    => 'et_banner',
			    		"as_parent"               => array('except' => 'vc_row, vc_section'),
						"js_view"                 => 'VcColumnView',
			    		"content_element"         => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-banner.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-banner.js',
			    		'params'                  => array(
			    			array(
			    				'type'       => 'checkbox',
								'heading'    => esc_html__('Hide on mobile', 'mobimax'),
								'param_name' => 'visible_mob',
								'value'      => '',
								'description'=> esc_html__('Check this option if you want to hide banner on mobile', 'mobimax'),
							),
							array(
			    				'type'       => 'checkbox',
								'heading'    => esc_html__('Hide on tablet', 'mobimax'),
								'param_name' => 'visible_tablet',
								'value'      => '',
								'description'=> esc_html__('Check this option if you want to hide tablet on mobile', 'mobimax'),
							),
							array(
			    				'type'       => 'checkbox',
								'heading'    => esc_html__('Use cookie', 'mobimax'),
								'param_name' => 'cookie',
								'value'      => '',
								'description'=> esc_html__('Toggle this option if you want to display your banner onces per visit session', 'mobimax'),
							),
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Delay in ms','mobimax'),
								'param_name' => 'delay',
								'value'      => '3000',
							),
							array(
								'param_name'=>'effect',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Effect', 'mobimax'),
								'value'     => array(
									esc_html__('Fade in and scale', 'mobimax') => 'fade-in-scale',
									esc_html__('Slide in right', 'mobimax')  	 => 'slide-in-right',
									esc_html__('Slide in bottom', 'mobimax')   => 'slide-in-bottom',
									esc_html__('3d flip horizontal', 'mobimax')=> 'flip-horizonatal',
									esc_html__('3d flip vertical', 'mobimax')  => 'flip-vertical'
								)
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Width in px','mobimax'),
								'param_name' => 'width',
								'value'      => '720',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Height in px','mobimax'),
								'param_name' => 'height',
								'value'      => '400',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Background color','mobimax'),
								'param_name' => 'back_color',
								'value'      => '#ffffff'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Border color','mobimax'),
								'param_name' => 'border_color',
								'value'      => ''
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Background image','mobimax'),
								'param_name' => 'back_img',
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Text align','mobimax'),
								'param_name' => 'text_align',
								'value'      => $align_values,
							),

							/* padding
							---------------*/

								array(
									'type'       => 'padding',
									'group'      => esc_html__('Padding','mobimax'),
									'heading'    => esc_html__('Padding','mobimax'),
									'param_name' => 'padding',
									'value'      => ''
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_tagline
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Tagline','mobimax'),
			    		'description'             => esc_html__('Insert tagline (if you want to have the tagline in entire site, put the tagline inside header)','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_tagline',
			    		'class'                   => 'et_tagline',
			    		'icon'                    => 'et_tagline',
			    		"content_element"         => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-tagline.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-tagline.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button text','mobimax'),
								'param_name' => 'button_text',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button link','mobimax'),
								'param_name' => 'button_link',
								'value'      => '',
							),
			    			array(
			    				'type'       => 'checkbox',
								'heading'    => esc_html__('Visible on mobile', 'mobimax'),
								'param_name' => 'visible_mob',
								'value'      => '',
								'description'=> esc_html__('Check this option if you want to display banner on mobile', 'mobimax'),
							),
							array(
			    				'type'       => 'checkbox',
								'heading'    => esc_html__('Visible on tablet', 'mobimax'),
								'param_name' => 'visible_tablet',
								'value'      => '',
								'description'=> esc_html__('Check this option if you want to display tablet on mobile', 'mobimax'),
							),
							array(
			    				'type'       => 'checkbox',
								'heading'    => esc_html__('Use cookie', 'mobimax'),
								'param_name' => 'cookie',
								'value'      => '',
								'description'=> esc_html__('Toggle this option if you want to display your banner onces per visit session', 'mobimax'),
							),
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Delay in ms','mobimax'),
								'param_name' => 'delay',
								'value'      => '3000',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Background color','mobimax'),
								'param_name' => 'back_color',
								'value'      => $main_color
							),
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Background image','mobimax'),
								'param_name' => 'back_img',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Title color','mobimax'),
								'param_name' => 'title_color',
								'value'      => '#ffffff'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button color','mobimax'),
								'param_name' => 'button_color',
								'value'      => $main_color
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button background color','mobimax'),
								'param_name' => 'button_background_color',
								'value'      => '#ffffff'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button color hover','mobimax'),
								'param_name' => 'button_color_hover',
								'value'      => '#ffffff'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button background color hover','mobimax'),
								'param_name' => 'button_background_color_hover',
								'value'      => '#212121'
							),

							/* padding
							---------------*/

								array(
									'type'       => 'padding',
									'group'      => esc_html__('Padding','mobimax'),
									'heading'    => esc_html__('Padding','mobimax'),
									'param_name' => 'padding',
									'value'      => '16,0,16,0'
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_ad
				---------------*/

			    	vc_map(array(
						'name'                    => esc_html__('Banner','mobimax'),
						'description'             => esc_html__('Insert banner','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_ad',
						'class'                   => 'et_ad',
						'icon'                    => 'et_ad',
						"as_parent"               => array('except' => 'vc_section'),
	    				'content_element'         => true,
						"js_view"                 => 'VcColumnView',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-ad.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-ad.js',
						'show_settings_on_create' => true,
						'params'                  => array(

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'group'      => esc_html__('Styling','mobimax'),
									'heading'    => esc_html__('Background color','mobimax'),
									'param_name' => 'back_color',
									'value'      => ''
								),
								array(
									'type'       => 'attach_image',
									'group'      => esc_html__('Styling','mobimax'),
									'heading'    => esc_html__('Background image','mobimax'),
									'param_name' => 'back_img',
									'value'      => ''
								),
								array(
									'type'       => 'dropdown',
									'group'      => esc_html__('Styling','mobimax'),
									'heading'    => esc_html__('Background image repeat','mobimax'),
									'param_name' => 'back_repeat',
									'value'      => array(
										esc_html__('No-repeat','mobimax') => 'no-repeat',
										esc_html__('Repeat x','mobimax')  => 'repeat-x',
										esc_html__('Repeat y','mobimax')  => 'repeat-y',
										esc_html__('Repeat','mobimax')    => 'repeat',
									)
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Styling','mobimax'),
									'heading'    => esc_html__('Background image position','mobimax'),
									'param_name' => 'back_position',
									'value'      => 'left top'
								),
								array(
									'type'       => 'dropdown',
									'group'      => esc_html__('Styling','mobimax'),
									'heading'    => esc_html__('Background image size','mobimax'),
									'param_name' => 'back_size',
									'value'      => array(
										esc_html__('Auto','mobimax')    => 'auto',
										esc_html__('Cover','mobimax')   => 'cover',
										esc_html__('Contain','mobimax') => 'contain',
									)
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Styling','mobimax'),
									'heading'    => esc_html__('Border width','mobimax'),
									'param_name' => 'border_width',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Styling','mobimax'),
									'heading'    => esc_html__('Border radius','mobimax'),
									'param_name' => 'border_radius',
									'value'      => ''
								),
								array(
									'type'       => 'colorpicker',
									'group'      => esc_html__('Styling','mobimax'),
									'heading'    => esc_html__('Border color','mobimax'),
									'param_name' => 'border_color',
									'value'      => ''
								),

								array(
									'type'       => 'checkbox',
									'group'      => esc_html__('Styling','mobimax'),
									'heading'    => esc_html__('Gradient','mobimax'),
									'param_name' => 'gradient',
									'value'      => ''
								),

							/* image
							---------------*/

								array(
									'type'       => 'attach_image',
									'group'      => esc_html__('Image','mobimax'),
									'heading'    => esc_html__('Image','mobimax'),
									'param_name' => 'img',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Image','mobimax'),
									'heading'    => esc_html__('Image offset x','mobimax'),
									'param_name' => 'img_x',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Image','mobimax'),
									'heading'    => esc_html__('Image offset y','mobimax'),
									'param_name' => 'img_y',
									'value'      => ''
								),

								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Image','mobimax'),
									'heading'    => esc_html__('Tablet Image offset x','mobimax'),
									'param_name' => 'tablet_img_x',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Image','mobimax'),
									'heading'    => esc_html__('Tablet Image offset y','mobimax'),
									'param_name' => 'tablet_img_y',
									'value'      => ''
								),

								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Image','mobimax'),
									'heading'    => esc_html__('Tablet landscape Image offset x','mobimax'),
									'param_name' => 'tablet_land_img_x',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Image','mobimax'),
									'heading'    => esc_html__('Tablet landscape Image offset y','mobimax'),
									'param_name' => 'tablet_land_img_y',
									'value'      => ''
								),

								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Image','mobimax'),
									'heading'    => esc_html__('Mobile Image offset x','mobimax'),
									'param_name' => 'mobile_img_x',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Image','mobimax'),
									'heading'    => esc_html__('Mobile Image offset y','mobimax'),
									'param_name' => 'mobile_img_y',
									'value'      => ''
								),

							/* hover
							---------------*/

								array(
									'type'       => 'checkbox',
									'group'      => esc_html__('Hover','mobimax'),
									'heading'    => esc_html__('Background image zoom','mobimax'),
									'param_name' => 'back_zoom',
									'value'      => ''
								),
								array(
									'type'       => 'checkbox',
									'group'      => esc_html__('Hover','mobimax'),
									'heading'    => esc_html__('Image transform','mobimax'),
									'param_name' => 'img_transform',
									'value'      => '',
									'dependency' => Array('element' => 'img', 'not_empty' => true)
								),
								array(
									'type'       => 'dropdown',
									'group'      => esc_html__('Hover','mobimax'),
									'heading'    => esc_html__('Image transform position','mobimax'),
									'param_name' => 'img_transform_pos',
									'value'      => array(
										esc_html__('To top','mobimax')    => 'top',
										esc_html__('To right','mobimax')  => 'right',
										esc_html__('To bottom','mobimax') => 'bottom',
										esc_html__('To left','mobimax')   => 'left',
									),
									'dependency' => Array('element' => 'img_transform', 'not_empty' => true)
								),
								array(
									'type'       => 'checkbox',
									'group'      => esc_html__('Hover','mobimax'),
									'heading'    => esc_html__('Gradient zoom','mobimax'),
									'param_name' => 'gradient_zoom',
									'value'      => '',
									'dependency' => Array('element' => 'gradient', 'not_empty' => true)
								),

							/* padding
							---------------*/

								array(
									'type'       => 'padding',
									'group'      => esc_html__('Padding','mobimax'),
									'heading'    => esc_html__('Padding','mobimax'),
									'param_name' => 'padding',
									'value'      => '48,48,48,48'
								),

							/* margin
							---------------*/

								array(
									'type'       => 'margin',
									'group'      => esc_html__('Margin','mobimax'),
									'heading'    => esc_html__('Margin','mobimax'),
									'param_name' => 'margin',
									'value'      => '0,0,0,0'
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),


						)
					));

					$banners = enovathemes_addons_banners();

					$banners_array = array(array('',esc_html__("Choose","mobimax")));

					if ($banners && !is_wp_error($banners)){
						foreach ($banners as $banner){
							$banners_array[$banner[1]] = $banner[0];
						}
					}

					vc_map(array(
						'name'                    => esc_html__('Banner select','mobimax'),
						'description'             => esc_html__('Select banner','mobimax'),
						'category'                => esc_html__('Enovathemes','mobimax'),
						'base'                    => 'et_ad_select',
						'class'                   => 'et_ad_select',
						'icon'                    => 'et_ad_select',
						'show_settings_on_create' => true,
						'params'                  => array(
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Select banner','mobimax'),
								'param_name' => 'banner',
								'value'      => $banners_array
							)
						)
					));

			/* MEDIA
			---------------*/

				/* et_image
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Image','mobimax'),
			    		'description'             => esc_html__('Insert/animate single image','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_image',
			    		'class'                   => 'et_image',
			    		'icon'                    => 'et_image',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-image.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-image.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
			    			array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Upload image','mobimax'),
								'param_name' => 'image',
							),
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
			    			array(
								'param_name'=>'size',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Size', 'mobimax'),
								'value'     => $image_size_values
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Image link','mobimax'),
								'param_name' => 'link',
								'value'      => '',
							),
							array(
								'param_name'=>'link_target',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Link target', 'mobimax'),
								'value'     => array(
									'_self'  => '_self',
									'_blank' => '_blank'
								),
								'dependency' => Array('element' => 'link', 'not_empty' => true)
							),
							array(
								'param_name'=>'alignment',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Alignment', 'mobimax'),
								'value'     => $align_values_extended
							),

							/* parallax
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Parallax','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset X coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_x',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset Y coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_y',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Parallax speed radtio','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'description'=> esc_html__('The more the value is the slower the parallax effect is','mobimax'),
									'param_name' => 'parallax_speed',
									'value'     => array(
										'1'  => '1',
										'2'  => '2',
										'3'  => '3',
										'4'  => '4',
										'5'  => '5',
										'6'  => '6',
										'7'  => '7',
										'8'  => '8',
										'9'  => '9',
										'10' => '10',
										'11' => '11',
										'12' => '12',
										'13' => '13',
										'14' => '14',
										'15' => '15',
										'16' => '16',
										'17' => '17',
										'18' => '18',
										'19' => '19',
										'20' => '20'
									),
									'std' => '10',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Move on mouse move','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'move',
									'value'      => '',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'rp',
									'heading'    => esc_html__( 'Responsive parallax', 'mobimax' ),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'rp',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),

							/* curtain
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Curtain effect','mobimax'),
									'group'      => esc_html__('Curtain effect','mobimax'),
									'param_name' => 'curtain',
									'value'      => ''
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Curtain direction','mobimax'),
									'group'      => esc_html__('Curtain effect','mobimax'),
									'param_name' => 'curtain_direction',
									'value'      => array(
										esc_html__('Left to Right','mobimax') => 'left',
										esc_html__('Right to Left','mobimax') => 'right',
										esc_html__('Top to bottom','mobimax') => 'top',
										esc_html__('Bottom to top','mobimax') => 'bottom',
									),
									'dependency' => Array(
										'element' => 'curtain', 'value' => 'true'
									)
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Curtain color','mobimax'),
									'group'      => esc_html__('Curtain effect','mobimax'),
									'param_name' => 'curtain_color',
									'value'      => '',
									'dependency' => Array(
										'element' => 'curtain', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__( 'Animation delay in ms (example 300)', 'mobimax' ),
									'group'      => esc_html__('Curtain effect','mobimax'),
									'param_name' => 'curtain_animation_delay',
									'value'      => $animation_delay_values,
									'dependency' => Array(
										'element' => 'curtain', 'value' => 'true'
									)
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_gallery
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Gallery','mobimax'),
			    		'description'             => esc_html__('Insert/animate gallery','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_gallery',
			    		'class'                   => 'et_gallery',
			    		'icon'                    => 'et_gallery',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-gallery.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-gallery.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
			    			array(
								'type'       => 'attach_images',
								'heading'    => esc_html__('Upload images','mobimax'),
								'param_name' => 'images',
							),
			    			array(
								'param_name'=>'size',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Size', 'mobimax'),
								'value'     => $image_size_values
							),
							array(
			    				'type'       => 'dropdown',
								'heading'    => esc_html__('Gallery type', 'mobimax'),
								'param_name' => 'type',
								'value'      => array(
									esc_html__('Grid/Masonry','mobimax')             => 'grid',
									esc_html__('Carousel','mobimax')                 => 'carousel',
									esc_html__('Carousel with thumbnails','mobimax') => 'carousel-thumbs',
								)
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Link to','mobimax'),
								'param_name' => 'link',
								'value'      => array(
									esc_html__('None','mobimax')       => 'none',
									esc_html__('Attachment','mobimax') => 'attach',
									esc_html__('Lightbox','mobimax')   => 'lightbox',
								)
							),
							array(
								'param_name'=>'columns',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Columns', 'mobimax'),
								'value'     => array(
									'1'  => '1',
									'2'  => '2',
									'3'  => '3',
									'4'  => '4',
									'5'  => '5',
									'6'  => '6',
									'7'  => '7',
									'8'  => '8',
									'9'  => '9',
									'10' => '10'
								),
								'dependency' => Array(
									'element' => 'type', 'value' => array('grid','carousel'),
								)
							),
							array(
								'param_name'=>'gap',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Gap', 'mobimax'),
								'value'     => array(
									esc_html__('0px', 'mobimax')    => '0',
									esc_html__('2px', 'mobimax')    => '2',
									esc_html__('4px', 'mobimax')    => '4',
									esc_html__('8px', 'mobimax')    => '8',
									esc_html__('16px', 'mobimax')   => '16',
									esc_html__('24px', 'mobimax')   => '24',
									esc_html__('32px', 'mobimax')   => '32',
									esc_html__('40px', 'mobimax')   => '40',
								),
								'dependency' => Array(
									'element' => 'type', 'value' => array('carousel','grid'),
								)
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Animation','mobimax'),
								'param_name' => 'animation',
								'value'      => array(
									esc_html__('None','mobimax')   => 'none',
									esc_html__('Fade','mobimax') => 'fadeIn',
									esc_html__('Move','mobimax') => 'moveUp',
								),
								'dependency' => Array(
									'element' => 'type', 'value' => array('grid'),
								)
							),
							array(
								'param_name'=>'navigation_type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation type', 'mobimax'),
								'value'     => array(
									esc_html__('Only arrows','mobimax')  => 'only-arrows',
									esc_html__('Only bullets','mobimax')  => 'only-bullets',
									esc_html__('Both arrows and bullets','mobimax')  => 'both'
								),
								'dependency' => Array(
									'element' => 'type', 'value' => array('carousel'),
								)
							),
							array(
								'param_name'=>'autoplay',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Autoplay', 'mobimax'),
								'value'     => $logic_values,
								'dependency' => Array(
									'element' => 'type', 'value' => array('carousel','carousel-thumbs'),
								)
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								)
			    		)
			    	));

				/* et_video
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Video','mobimax'),
			    		'description'             => esc_html__('Insert video (selfhosted, youtube, vimeo)','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_video',
			    		'class'                   => 'et_video',
			    		'icon'                    => 'et_video',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
			    			array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Modal','mobimax'),
								'param_name' => 'modal',
							),
			    			array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Poster','mobimax'),
								'param_name' => 'image',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('MP4 video file url','mobimax'),
								'param_name' => 'mp4',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Video embed url','mobimax'),
								'param_name' => 'embed',
								'value'      => '',
							)
			    		)
			    	));

			    /* et_audio
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Audio','mobimax'),
			    		'description'             => esc_html__('Insert audio','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_audio',
			    		'class'                   => 'et_audio',
			    		'icon'                    => 'et_audio',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('MP3 audio file url','mobimax'),
								'param_name' => 'mp3',
								'value'      => '',
							),
			    		)
			    	));

			/* INFOGRAPHICS
			---------------*/

				/* et_counter
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Counter','mobimax'),
			    		'description'             => esc_html__('Insert number counter','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_counter',
			    		'class'                   => 'et_counter',
			    		'icon'                    => 'et_counter',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-counter.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-counter.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Number','mobimax'),
								'param_name' => 'number',
								'value'      => '',
								'description' => esc_html__('Insert an integer value to count to','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'param_name'=>'type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Title tag', 'mobimax'),
								'value'     => array(
									'H1'  => 'h1',
									'H2'  => 'h2',
									'H3'  => 'h3',
									'H4'  => 'h4',
									'H5'  => 'h5',
									'H6'  => 'h6',
									'p'   => 'p',
									'div' => 'div',
								),
								'std' => 'h4'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Number postfix','mobimax'),
								'param_name' => 'number_postfix',
								'value'      => '',
								'description' => esc_html__('Insert any postfix you want %,$, etc.','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon prefix','mobimax'),
								'param_name' => 'icon_prefix',
								'value'      => '',
								'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon name','mobimax'),
								'param_name' => 'icon_name',
								'value'      => '',
								'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Value font-size','mobimax'),
								'param_name' => 'value_font_size',
								'value'      => array(
									esc_html__('14px', 'mobimax')  => '14px',
									esc_html__('16px', 'mobimax')  => '16px',
									esc_html__('18px', 'mobimax')  => '18px',
									esc_html__('20px', 'mobimax')  => '20px',
									esc_html__('24px', 'mobimax')  => '24px',
									esc_html__('32px', 'mobimax')  => '32px',
									esc_html__('40px', 'mobimax')  => '40px',
									esc_html__('48px', 'mobimax')  => '48px',
									esc_html__('56px', 'mobimax')  => '56px',
									esc_html__('64px', 'mobimax')  => '64px',
									esc_html__('72px', 'mobimax')  => '72px',
								),
								'std' => '72px'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Value color','mobimax'),
								'param_name' => 'value_color',
								'value'      => $main_color
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Title font-size','mobimax'),
								'param_name' => 'title_font_size',
								'value'      => array(
									esc_html__('14px', 'mobimax')  => '14px',
									esc_html__('16px', 'mobimax')  => '16px',
									esc_html__('18px', 'mobimax')  => '18px',
									esc_html__('20px', 'mobimax')  => '20px',
									esc_html__('24px', 'mobimax')  => '24px',
									esc_html__('32px', 'mobimax')  => '32px',
									esc_html__('40px', 'mobimax')  => '40px',
									esc_html__('48px', 'mobimax')  => '48px',
									esc_html__('56px', 'mobimax')  => '56px',
									esc_html__('64px', 'mobimax')  => '64px',
									esc_html__('72px', 'mobimax')  => '72px',
								),
								'std' => '24px'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Title color','mobimax'),
								'param_name' => 'title_color',
								'value'      => '#212121'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),

							/* parallax
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Parallax','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset X coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_x',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset Y coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_y',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Parallax speed radtio','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'description'=> esc_html__('The more the value is the slower the parallax effect is','mobimax'),
									'param_name' => 'parallax_speed',
									'value'     => array(
										'1'  => '1',
										'2'  => '2',
										'3'  => '3',
										'4'  => '4',
										'5'  => '5',
										'6'  => '6',
										'7'  => '7',
										'8'  => '8',
										'9'  => '9',
										'10' => '10',
										'11' => '11',
										'12' => '12',
										'13' => '13',
										'14' => '14',
										'15' => '15',
										'16' => '16',
										'17' => '17',
										'18' => '18',
										'19' => '19',
										'20' => '20'
									),
									'std' => '10',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Move on mouse move','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'move',
									'value'      => '',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'rp',
									'heading'    => esc_html__( 'Responsive parallax', 'mobimax' ),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'rp',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_progress
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Progress','mobimax'),
			    		'description'             => esc_html__('Insert progress bar','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_progress',
			    		'class'                   => 'et_progress',
			    		'icon'                    => 'et_progress',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-progress.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-progress.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon prefix','mobimax'),
								'param_name' => 'icon_prefix',
								'value'      => '',
								'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon name','mobimax'),
								'param_name' => 'icon_name',
								'value'      => '',
								'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Percentage','mobimax'),
								'param_name' => 'percentage',
								'value'      => '',
								'description' => esc_html__('Only integer value, without any string','mobimax'),
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Bar Color','mobimax'),
								'param_name' => 'bar_color',
								'value'      => $main_color
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Track Color','mobimax'),
								'param_name' => 'track_color',
								'value'      => '#e0e0e0'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Text color','mobimax'),
								'param_name' => 'text_color',
								'value'      => '#212121'
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

				/* et_circle_progress
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Progress','mobimax'),
			    		'description'             => esc_html__('Insert circle progress bar','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_circle_progress',
			    		'class'                   => 'et_circle_progress',
			    		'icon'                    => 'et_circle_progress',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-circle-progress.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-circle-progress.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
			    			array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'param_name' => 'size',
								'value'      => $size_values_default
							),
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'param_name'=>'type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Title tag', 'mobimax'),
								'value'     => array(
									'H1'  => 'h1',
									'H2'  => 'h2',
									'H3'  => 'h3',
									'H4'  => 'h4',
									'H5'  => 'h5',
									'H6'  => 'h6',
									'p'   => 'p',
									'div' => 'div',
								),
								'std' => 'h6'
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Value font-size','mobimax'),
								'param_name' => 'value_font_size',
								'value'      => array(
									esc_html__('14px', 'mobimax')  => '14px',
									esc_html__('16px', 'mobimax')  => '16px',
									esc_html__('18px', 'mobimax')  => '18px',
									esc_html__('20px', 'mobimax')  => '20px',
									esc_html__('24px', 'mobimax')  => '24px',
									esc_html__('32px', 'mobimax')  => '32px',
									esc_html__('40px', 'mobimax')  => '40px',
									esc_html__('48px', 'mobimax')  => '48px',
									esc_html__('56px', 'mobimax')  => '56px',
									esc_html__('64px', 'mobimax')  => '64px',
									esc_html__('72px', 'mobimax')  => '72px',
								),
								'std' => '48px'
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Title font-size','mobimax'),
								'param_name' => 'title_font_size',
								'value'      => array(
									esc_html__('14px', 'mobimax')  => '14px',
									esc_html__('16px', 'mobimax')  => '16px',
									esc_html__('18px', 'mobimax')  => '18px',
									esc_html__('20px', 'mobimax')  => '20px',
									esc_html__('24px', 'mobimax')  => '24px',
									esc_html__('32px', 'mobimax')  => '32px',
									esc_html__('40px', 'mobimax')  => '40px',
									esc_html__('48px', 'mobimax')  => '48px',
									esc_html__('56px', 'mobimax')  => '56px',
									esc_html__('64px', 'mobimax')  => '64px',
									esc_html__('72px', 'mobimax')  => '72px',
								),
								'std' => '18px'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon prefix','mobimax'),
								'param_name' => 'icon_prefix',
								'value'      => '',
								'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon name','mobimax'),
								'param_name' => 'icon_name',
								'value'      => '',
								'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Percentage','mobimax'),
								'param_name' => 'percentage',
								'value'      => '',
								'description' => esc_html__('Only integer value, without any string','mobimax'),
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Bar Color','mobimax'),
								'param_name' => 'bar_color',
								'value'      => $main_color
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Track Color','mobimax'),
								'param_name' => 'track_color',
								'value'      => '#e0e0e0'
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Text color','mobimax'),
								'param_name' => 'text_color',
								'value'      => '#212121'
							),

							/* parallax
							---------------*/

								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Parallax','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset X coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_x',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Offset Y coordinate','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'parallax_y',
									'value'      => '0',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Parallax speed radtio','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'description'=> esc_html__('The more the value is the slower the parallax effect is','mobimax'),
									'param_name' => 'parallax_speed',
									'value'     => array(
										'1'  => '1',
										'2'  => '2',
										'3'  => '3',
										'4'  => '4',
										'5'  => '5',
										'6'  => '6',
										'7'  => '7',
										'8'  => '8',
										'9'  => '9',
										'10' => '10',
										'11' => '11',
										'12' => '12',
										'13' => '13',
										'14' => '14',
										'15' => '15',
										'16' => '16',
										'17' => '17',
										'18' => '18',
										'19' => '19',
										'20' => '20'
									),
									'std' => '10',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'checkbox',
									'heading'    => esc_html__('Move on mouse move','mobimax'),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'move',
									'value'      => '',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),
								array(
									'type'       => 'rp',
									'heading'    => esc_html__( 'Responsive parallax', 'mobimax' ),
									'group'      => esc_html__('Parallax','mobimax'),
									'param_name' => 'rp',
									'dependency' => Array(
										'element' => 'parallax', 'value' => 'true'
									)
								),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

			    /* et_timer
				---------------*/

					vc_map(array(
			    		'name'                    => esc_html__('Timer','mobimax'),
			    		'description'             => esc_html__('Insert timer','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_timer',
			    		'class'                   => 'et_timer',
			    		'icon'                    => 'et_timer',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-timer.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-timer.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('End date to count to','mobimax'),
								'param_name' => 'enddate',
								'value'      => '',
								'description' => esc_html__('Use format : June 7, 2025 15:03:25','mobimax'),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Days label','mobimax'),
								'param_name' => 'days',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Hours label','mobimax'),
								'param_name' => 'hours',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Minutes label','mobimax'),
								'param_name' => 'minutes',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Seconds label','mobimax'),
								'param_name' => 'seconds',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Text color','mobimax'),
								'param_name' => 'text_color',
								'value'      => '#212121'
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

			/* OTHER
			---------------*/

				/* et_bullets
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Bulleted navigation','mobimax'),
			    		'description'             => esc_html__('Use only with One page layout active','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_bullets',
			    		'class'                   => 'et_bullets hbe',
			    		'icon'                    => 'et_bullets',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-bullets.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-bullets.js',
			    		'params'                  => array(

			    			array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Menu name','mobimax'),
								'param_name' => 'menu',
								'value'      => $menu_list,
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Extra class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('One page navigation offset in px (without any string)','mobimax'),
								'description'=> esc_html__('If you have sticky header on the page, you can set the offset','mobimax'),
								'param_name' => 'offset',
								'value'      => '0',
							),

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Bullet color','mobimax'),
									'group'      => 'Styling',
									'param_name' => 'bullet_color',
									'value'      => $main_color,
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Bullet color hover','mobimax'),
									'group'      => 'Styling',
									'param_name' => 'bullet_color_hover',
									'value'      => '#212121',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Bullets wrapper background color','mobimax'),
									'group'      => 'Styling',
									'param_name' => 'bullet_background_color',
									'value'      => '#ffffff',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Bullets wrapper border color','mobimax'),
									'group'      => 'Styling',
									'param_name' => 'bullet_border_color',
									'value'      => '#e0e0e0',
								),

							/* tooltip
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Tooltip color','mobimax'),
									'group'      => 'Styling',
									'param_name' => 'tooltip_color',
									'value'      => '#ffffff',
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Tooltip background color','mobimax'),
									'group'      => 'Styling',
									'param_name' => 'tooltip_background_color',
									'value'      => '#212121',
								),


							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),
			    		)
			    	));

			    /* et_gap
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Gap','mobimax'),
			    		'description'             => esc_html__('Insert space','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_gap',
			    		'class'                   => 'et_gap',
			    		'icon'                    => 'et_gap',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-gap.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-gap.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Gap size (without any string)','mobimax'),
								'param_name' => 'height',
								'value'      => '32'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Custom class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),
							array(
								'type'       => 'rv',
								'heading'    => esc_html__( 'Responsive visibility', 'mobimax' ),
								'group'      => esc_html__('Responsive visibility','mobimax'),
								'param_name' => 'rv',
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),

			    		)
			    	));

			    	vc_map(array(
			    		'name'                    => esc_html__('Inline gap','mobimax'),
			    		'description'             => esc_html__('Insert horizontal space','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_gap_inline',
			    		'class'                   => 'et_gap_inline',
			    		'icon'                    => 'et_gap_inline',
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-gap-inline.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-gap-inline.js',
			    		'params'                  => array(
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Gap size (without any string)','mobimax'),
								'param_name' => 'width',
								'value'      => '32'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Custom class','mobimax'),
								'param_name' => 'extra_class',
								'value'      => ''
							),
							array(
								'type'       => 'rv',
								'heading'    => esc_html__( 'Responsive visibility', 'mobimax' ),
								'group'      => esc_html__('Responsive visibility','mobimax'),
								'param_name' => 'rv',
							),

							/* element_css
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Element id','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_id',
									'value'      => '',
								),

								array(
									'type'       => 'textarea',
									'heading'    => esc_html__('Element css','mobimax'),
									"class"      => "element-attr-hide",
									'param_name' => 'element_css',
									'value'      => '',
								),

			    		)
			    	));

			/* WOOCOMMERCE
			---------------*/

				if (class_exists('Woocommerce')) {

					$cat_args = array(
						'orderby'    => 'name',
					    'order'      => 'asc',
					    'hide_empty' => false
					);

					$category_values = array();
					$category_list   = get_terms( 'product_cat', $cat_args );
					if(is_object($category_list)  && !empty($category_list)){

					    foreach ($category_list as $category) {
					    	if ($category->parent) {
					    		$category_values[' - '.$category->name] = $category->slug;
					    	} else {
					    		$category_values[$category->name] = $category->slug;
					    	}
					    }
					}

					$attributes = array(esc_html__("Choose","mobimax")=>'');

					if(function_exists('wc_get_attribute_taxonomies')){

						$attributes_tax = wc_get_attribute_taxonomies();
						foreach ( $attributes_tax as $attribute ) {
							$attributes[ $attribute->attribute_label ] = $attribute->attribute_name;
						}

					}

					$product_categories = array(
						esc_html__('All','mobimax')  => 'all',
					);

					$args = array(
					    'orderby'           => 'name',
					    'order'             => 'ASC',
					    'hide_empty'        => true,
					    'exclude'           => array(),
					    'exclude_tree'      => array(),
					    'number'            => '',
					    'fields'            => 'all',
					    'slug'              => '',
					    'parent'            => '',
					    'hierarchical'      => false,
					    'child_of'          => 0,
					    'get'               => '',
					    'name__like'        => '',
					    'description__like' => '',
					    'pad_counts'        => false,
					    'offset'            => '',
					    'search'            => '',
					    'cache_domain'      => 'core'
					);
					$tax_terms = get_terms('product_cat');

					if (count($tax_terms) != 0){
		            	foreach(get_terms('product_cat',$args) as $filter_term){
		        			$filter_children = get_term_children( $filter_term->term_id, 'product_cat' );
		        			if(is_array($filter_children) && !empty($filter_children)) {
		        				foreach ($filter_children as $filter_child) {
		        					$filter_child_obj = get_term($filter_child, 'product_cat');
		        				}
		        			}

		        			$product_categories[$filter_term->name] = $filter_term->slug;
			            }
					}
				}


				if (class_exists('Woocommerce')) {

					/* et_woo_products
					---------------*/

				    	vc_map(array(
				    		'name'                    => esc_html__('Woocommerce products','mobimax'),
				    		'description'             => esc_html__('Use this element to add different types of products','mobimax'),
				    		'category'                => array(esc_html__('Enovathemes','mobimax'),esc_html__('WooCommerce','mobimax')),
				    		'base'                    => 'et_woo_products',
				    		'class'                   => 'et_woo_products',
				    		'icon'                    => 'et_woo_products',
				    		'show_settings_on_create' => true,
				    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-woo.js',
				    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-woo.js',
				    		'params'                  => array(
				    			array(
									'param_name'=>'layout',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Layout', 'mobimax'),
									'value'     => array(
										esc_html__('Grid', 'mobimax')     => 'grid',
										esc_html__('List', 'mobimax')     => 'list',
										esc_html__('Carousel', 'mobimax') => 'carousel',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Product title minimum height (without any string)', 'mobimax'),
									'param_name' => 'product_title_minimum_height',
									'value'      => '',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Product title maximum height (without any string)', 'mobimax'),
									'param_name' => 'product_title_maximum_height',
									'value'      => '',
								),
								array(
									'param_name'=>'navigation_type',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Navigation type', 'mobimax'),
									'value'     => array(
										esc_html__('Only arrows','mobimax')  => 'only-arrows',
										esc_html__('Only bullets','mobimax')  => 'only-bullets',
										esc_html__('Both arrows and bullets','mobimax')  => 'both',
									),
									'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
								),
								array(
									'param_name'=>'arrows_position',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Arrows position', 'mobimax'),
									'value'     => array(
										esc_html__('Default','mobimax')  => 'default',
										esc_html__('Top right','mobimax')    => 'top-right',
										esc_html__('Top left','mobimax')     => 'top-left',
										esc_html__('Bottom right','mobimax') => 'bottom-right',
										esc_html__('Bottom left','mobimax')  => 'bottom-left'
									),
									'dependency' => Array(
										'element' => 'layout', 'value' => 'carousel',
										'element' => 'navigation_type', 'value' => 'only-arrows'
									)
								),
								array(
									'param_name'=>'bullets_position',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Bullets position', 'mobimax'),
									'value'     => array(
										esc_html__('Default','mobimax')  => 'default',
										esc_html__('Top right','mobimax')    => 'top-right',
										esc_html__('Top left','mobimax')     => 'top-left',
										esc_html__('Bottom right','mobimax') => 'bottom-right',
										esc_html__('Bottom left','mobimax')  => 'bottom-left'
									),
									'dependency' => Array(
										'element' => 'layout', 'value' => 'carousel',
										'element' => 'navigation_type', 'value' => 'only-bullets'
									)
								),
								array(
									'param_name'=>'navigation_visibility',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Navigation visibility', 'mobimax'),
									'value'     => array(
										esc_html__('On mouseover','mobimax')  => 'mouseover',
										esc_html__('Always','mobimax')    => 'always',
									),
									'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
								),
								array(
									'param_name'=>'autoplay',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Autoplay', 'mobimax'),
									'value'     => $logic_values,
									'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
								),
								array(
									'param_name' =>'animation_effect',
									'type'       => 'dropdown',
									'heading'    => esc_html__('Animation effect', 'mobimax'),
									'value'      => $animation_values,
									'dependency' => Array('element' => 'layout', 'value' => array('grid','list'))
								),
								array(
									'type' => 'dropdown',
									'heading'     => esc_html__( 'Size', 'mobimax' ),
									'value'       => $size_values_box,
									'param_name'  => 'columns',
									'save_always' => true,
									'dependency' => Array('element' => 'layout', 'value' => array('grid','list'))
								),
								array(
									'type' => 'dropdown',
									'heading'     => esc_html__( 'Columns', 'mobimax' ),
									'param_name'  => 'columns_list',
									'save_always' => true,
									'value'       => array(
										'1' => '1',
										'2' => '2',
									),
									'dependency' => Array(
										'element' => 'columns', 'value' => array('small','medium'),
										'element' => 'layout', 'value' => 'list',
									)
								),
								array(
									'type' => 'dropdown',
									'heading'     => esc_html__( 'Columns', 'mobimax' ),
									'param_name'  => 'columns_carousel',
									'save_always' => true,
									'value'       => array(
										'1' => '1',
										'2' => '2',
										'3' => '3',
										'4' => '4',
										'5' => '5'
									),
									'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
								),
								array(
									'type' => 'dropdown',
									'heading'     => esc_html__( 'Rows', 'mobimax' ),
									'param_name'  => 'rows_carousel',
									'save_always' => true,
									'value'       => array(
										'1' => '1',
										'2' => '2',
										'3' => '3',
										'4' => '4',
									),
									'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Quantity', 'mobimax' ),
									'value' => 12,
									'save_always' => true,
									'param_name' => "quantity",
									'description' => esc_html__( 'The "quantity" shortcode determines how many products to show', 'mobimax' ),
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Category', 'mobimax' ),
									'value' => '',
									'param_name' => 'category',
									'save_always' => true,
									'description' => esc_html__( 'Enter comma separated categories slugs if you want to show certain categories', 'mobimax' ),
									'dependency' => Array(
										'element' => 'type', 'value' => array('recent','featured','sale','best_selling','top_rated','attribute'),
									)
								),
								array(
									'type' => 'dropdown',
									'heading' => esc_html__( 'Operator', 'mobimax' ),
									'param_name' => 'operator',
									'value' => $operator_values,
									'save_always' => true,
									'description' => esc_html__( 'Select filter operator', 'mobimax' ),
									'dependency' => Array('element' => 'category', 'not_empty' => true)
								),
								array(
									'type' => 'dropdown',
									'heading' => esc_html__( 'Order by', 'mobimax' ),
									'param_name' => 'orderby',
									'value' => $order_by_values,
									'save_always' => true,
									'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'mobimax' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
								),
								array(
									'type' => 'dropdown',
									'heading' => esc_html__( 'Sort order', 'mobimax' ),
									'param_name' => 'order',
									'value' => $order_way_values,
									'save_always' => true,
									'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'mobimax' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
								),
								array(
									'param_name'=>'type',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Type', 'mobimax'),
									'value'     => array(
										esc_html__('Recent', 'mobimax')       => 'recent',
										esc_html__('Featured', 'mobimax')     => 'featured',
										esc_html__('Sale', 'mobimax')         => 'sale',
										esc_html__('Best selling', 'mobimax') => 'best_selling',
										esc_html__('Top rated', 'mobimax')    => 'top_rated',
										esc_html__('Attribute', 'mobimax')    => 'attribute',
										esc_html__('Related', 'mobimax')      => 'related',
										esc_html__('Custom', 'mobimax')       => 'custom',
									)
								),

								/* attribute
								---------------*/

									array(
										'type' => 'dropdown',
										'heading' => esc_html__( 'Attribute', 'mobimax' ),
										'param_name' => 'attribute',
										'value' => $attributes,
										'save_always' => true,
										'description' => esc_html__( 'List of product taxonomy attributes', 'mobimax' ),
										'dependency' => Array(
											'element' => 'type', 'value' => array('attribute'),
										)
									),
									array(
										'type' => 'textfield',
										'heading' => esc_html__( 'Filter', 'mobimax' ),
										'value' => '',
										'param_name' => 'filter',
										'save_always' => true,
										'description' => esc_html__( 'Taxonomy values', 'mobimax' ),
										'dependency' => Array(
											'element' => 'type', 'value' => array('attribute'),
										)
									),

								/* custom
								---------------*/

									array(
										'type' => 'textfield',
										'heading' => esc_html__( 'Products', 'mobimax' ),
										'value' => '',
										'param_name' => 'ids',
										'save_always' => true,
										'description' => esc_html__( 'Enter comma separated products ids', 'mobimax' ),
										'dependency' => Array(
											'element' => 'type', 'value' => array('custom'),
										)
									),

								/* element_css
								---------------*/

									array(
										'type'       => 'textfield',
										'heading'    => esc_html__('Element id','mobimax'),
										"class"      => "element-attr-hide",
										'param_name' => 'element_id',
										'value'      => '',
									),

									array(
										'type'       => 'textarea',
										'heading'    => esc_html__('Element css','mobimax'),
										"class"      => "element-attr-hide",
										'param_name' => 'element_css',
										'value'      => '',
									),
				    		)
				    	));

					/* et_woo_single_product
					---------------*/

				    	vc_map(array(
				    		'name'                    => esc_html__('Woocommerce single product','mobimax'),
				    		'description'             => esc_html__('Use this element to add different types of products with single view','mobimax'),
				    		'category'                => array(esc_html__('Enovathemes','mobimax'),esc_html__('WooCommerce','mobimax')),
				    		'base'                    => 'et_woo_single_product',
				    		'class'                   => 'et_woo_single_product',
				    		'icon'                    => 'et_woo_single_product',
				    		'show_settings_on_create' => true,
				    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-woo-single.js',
				    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-woo-single.js',
				    		'params'                  => array(
				    			array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Border color','mobimax'),
									'param_name' => 'color',
									'value'      => $main_color,
								),
								array(
									'param_name'=>'layout',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Layout', 'mobimax'),
									'value'     => array(
										esc_html__('Horizonal thumbnails','mobimax')  => 'down',
										esc_html__('Vertical thumbnails','mobimax')  => 'left',
									),
								),
								array(
									'param_name'=>'navigation_type',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Navigation type', 'mobimax'),
									'value'     => array(
										esc_html__('Only arrows','mobimax')  => 'only-arrows',
										esc_html__('Only bullets','mobimax')  => 'only-bullets',
										esc_html__('Both arrows and bullets','mobimax')  => 'both',
									),
								),
								array(
									'param_name'=>'navigation_visibility',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Navigation visibility', 'mobimax'),
									'value'     => array(
										esc_html__('On mouseover','mobimax')  => 'mouseover',
										esc_html__('Always','mobimax')    => 'always',
									)
								),
								array(
									'param_name'=>'autoplay',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Autoplay', 'mobimax'),
									'value'     => $logic_values,
								),
								array(
									'type' => 'dropdown',
									'heading' => esc_html__( 'Order by', 'mobimax' ),
									'param_name' => 'orderby',
									'value' => $order_by_values,
									'save_always' => true,
									'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'mobimax' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
								),
								array(
									'type' => 'dropdown',
									'heading' => esc_html__( 'Sort order', 'mobimax' ),
									'param_name' => 'order',
									'value' => $order_way_values,
									'save_always' => true,
									'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'mobimax' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Products', 'mobimax' ),
									'value' => '',
									'param_name' => 'ids',
									'save_always' => true,
									'description' => esc_html__( 'Enter comma separated products ids', 'mobimax' ),
									'dependency' => Array(
										'element' => 'type', 'value' => array('custom'),
									)
								),

								/* element_css
								---------------*/

									array(
										'type'       => 'textfield',
										'heading'    => esc_html__('Element id','mobimax'),
										"class"      => "element-attr-hide",
										'param_name' => 'element_id',
										'value'      => '',
									),
									array(
										'type'       => 'textarea',
										'heading'    => esc_html__('Element css','mobimax'),
										"class"      => "element-attr-hide",
										'param_name' => 'element_css',
										'value'      => '',
									),
				    		)
				    	));

					/* et_woo_categories
					---------------*/

						vc_map(array(
				    		'name'                    => esc_html__('Woocommerce categories','mobimax'),
				    		'description'             => esc_html__('Use this element to add product categories','mobimax'),
				    		'category'                => array(esc_html__('Enovathemes','mobimax'),esc_html__('WooCommerce','mobimax')),
				    		'base'                    => 'et_woo_categories',
				    		'class'                   => 'et_woo_categories',
				    		'icon'                    => 'et_woo_categories',
				    		'show_settings_on_create' => true,
				    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-woo-category.js',
				    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-woo-category.js',
				    		'params'                  => array(
				    			array(
									'param_name'=>'layout',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Layout', 'mobimax'),
									'value'     => array(
										esc_html__('Grid', 'mobimax')     => 'grid',
										esc_html__('List', 'mobimax')     => 'list',
										esc_html__('Carousel', 'mobimax') => 'carousel',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Product title minimum height (without any string)', 'mobimax'),
									'param_name' => 'product_title_minimum_height',
									'value'      => '',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Product title maximum height (without any string)', 'mobimax'),
									'param_name' => 'product_title_maximum_height',
									'value'      => '',
								),
								array(
									'param_name'=>'navigation_type',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Navigation type', 'mobimax'),
									'value'     => array(
										esc_html__('Only arrows','mobimax')  => 'only-arrows',
										esc_html__('Only bullets','mobimax')  => 'only-bullets',
										esc_html__('Both arrows and bullets','mobimax')  => 'both',
									),
									'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
								),
								array(
									'param_name'=>'arrows_position',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Arrows position', 'mobimax'),
									'value'     => array(
										esc_html__('Default','mobimax')  => 'default',
										esc_html__('Top right','mobimax')    => 'top-right',
										esc_html__('Top left','mobimax')     => 'top-left',
										esc_html__('Bottom right','mobimax') => 'bottom-right',
										esc_html__('Bottom left','mobimax')  => 'bottom-left'
									),
									'dependency' => Array(
										'element' => 'layout', 'value' => 'carousel',
										'element' => 'navigation_type', 'value' => 'only-arrows'
									)
								),
								array(
									'param_name'=>'bullets_position',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Bullets position', 'mobimax'),
									'value'     => array(
										esc_html__('Default','mobimax')  => 'default',
										esc_html__('Top right','mobimax')    => 'top-right',
										esc_html__('Top left','mobimax')     => 'top-left',
										esc_html__('Bottom right','mobimax') => 'bottom-right',
										esc_html__('Bottom left','mobimax')  => 'bottom-left'
									),
									'dependency' => Array(
										'element' => 'layout', 'value' => 'carousel',
										'element' => 'navigation_type', 'value' => 'only-bullets'
									)
								),
								array(
									'param_name'=>'navigation_visibility',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Navigation visibility', 'mobimax'),
									'value'     => array(
										esc_html__('On mouseover','mobimax')  => 'mouseover',
										esc_html__('Always','mobimax')    => 'always',
									),
									'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
								),
								array(
									'param_name'=>'autoplay',
									'type'      => 'dropdown',
									'heading'   => esc_html__('Autoplay', 'mobimax'),
									'value'     => $logic_values,
									'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
								),
								array(
									'param_name' =>'animation_effect',
									'type'       => 'dropdown',
									'heading'    => esc_html__('Animation effect', 'mobimax'),
									'value'      => $animation_values,
									'dependency' => Array('element' => 'layout', 'value' => array('grid','list'))
								),
								array(
									'type' => 'dropdown',
									'heading'     => esc_html__( 'Size', 'mobimax' ),
									'value'       => $size_values_box,
									'param_name'  => 'columns',
									'save_always' => true,
									'dependency' => Array('element' => 'layout', 'value' => array('grid','list'))
								),
								array(
									'type' => 'dropdown',
									'heading'     => esc_html__( 'Columns', 'mobimax' ),
									'param_name'  => 'columns_list',
									'save_always' => true,
									'value'       => array(
										'1' => '1',
										'2' => '2',
									),
									'dependency' => Array(
										'element' => 'columns', 'value' => array('small','medium'),
										'element' => 'layout', 'value' => 'list',
									)
								),
								array(
									'type' => 'dropdown',
									'heading'     => esc_html__( 'Columns', 'mobimax' ),
									'param_name'  => 'columns_carousel',
									'save_always' => true,
									'value'       => array(
										'1' => '1',
										'2' => '2',
										'3' => '3',
										'4' => '4',
										'5' => '5'
									),
									'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
								),
								array(
									'type' => 'textfield',
									'heading' => esc_html__( 'Category', 'mobimax' ),
									'value' => '',
									'param_name' => 'category',
									'save_always' => true,
									'description' => esc_html__( 'Enter comma separated category IDs if you want to show certain categories', 'mobimax' ),
								),
								array(
									'type' => 'dropdown',
									'heading' => esc_html__( 'Order by', 'mobimax' ),
									'param_name' => 'orderby',
									'value' => array(
										esc_html__( 'Date', 'mobimax' ) => 'date',
										esc_html__( 'ID', 'mobimax' ) => 'ID',
										esc_html__( 'Menu order', 'mobimax' ) => 'menu_order',
									),
									'save_always' => true,
									'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'mobimax' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
								),
								array(
									'type' => 'dropdown',
									'heading' => esc_html__( 'Sort order', 'mobimax' ),
									'param_name' => 'order',
									'value' => $order_way_values,
									'save_always' => true,
									'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'mobimax' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
								),

								/* element_css
								---------------*/

									array(
										'type'       => 'textfield',
										'heading'    => esc_html__('Element id','mobimax'),
										"class"      => "element-attr-hide",
										'param_name' => 'element_id',
										'value'      => '',
									),

									array(
										'type'       => 'textarea',
										'heading'    => esc_html__('Element css','mobimax'),
										"class"      => "element-attr-hide",
										'param_name' => 'element_css',
										'value'      => '',
									),
				    		)
				    	));

				}

			/* POSTS
			---------------*/

				/* et_posts
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Posts','mobimax'),
			    		'description'             => esc_html__('Use this element to add posts','mobimax'),
			    		'category'                => esc_html__('Enovathemes','mobimax'),
			    		'base'                    => 'et_posts',
			    		'class'                   => 'et_posts',
			    		'icon'                    => 'et_posts',
			    		'show_settings_on_create' => true,
			    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-post.js',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-post.js',
			    		'params'                  => array(
			    			array(
								'param_name'=>'layout',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Layout', 'mobimax'),
								'value'     => array(
									esc_html__('Grid', 'mobimax')     => 'grid',
									esc_html__('Chess', 'mobimax')     => 'chess',
									esc_html__('Carousel', 'mobimax') => 'carousel',
								)
							),
							array(
								'param_name'=>'columns',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Column', 'mobimax'),
								'value'     => array(
									'1'  => '1',
									'2'  => '2',
									'3'  => '3',
									'4'  => '4',
								),
								'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
							),
							array(
								'param_name'=>'image_full',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Image full', 'mobimax'),
								'value'     => $logic_values,
								'dependency' => Array('element' => 'layout', 'value' => array('grid'))
							),
							array(
								'param_name'=>'image_justify',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Justify post item width with post size', 'mobimax'),
								'description' => esc_html__('If active, post item width will be justified with the post size, but the height depends on image height.', 'mobimax'),
								'value'     => $logic_values,
								'dependency' => Array('element' => 'layout', 'value' => array('grid'))
							),
							array(
								'param_name'=>'navigation_type',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation type', 'mobimax'),
								'value'     => array(
									esc_html__('Only arrows','mobimax')  => 'only-arrows',
									esc_html__('Only bullets','mobimax')  => 'only-bullets',
									esc_html__('Both arrows and bullets','mobimax')  => 'both',
								),
								'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
							),
							array(
								'param_name'=>'arrows_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Arrows position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'layout', 'value' => 'carousel',
									'element' => 'navigation_type', 'value' => 'only-arrows'
								)
							),
							array(
								'param_name'=>'bullets_position',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Bullets position', 'mobimax'),
								'value'     => array(
									esc_html__('Default','mobimax')  => 'default',
									esc_html__('Top right','mobimax')    => 'top-right',
									esc_html__('Top left','mobimax')     => 'top-left',
									esc_html__('Bottom right','mobimax') => 'bottom-right',
									esc_html__('Bottom left','mobimax')  => 'bottom-left'
								),
								'dependency' => Array(
									'element' => 'layout', 'value' => 'carousel',
									'element' => 'navigation_type', 'value' => 'only-bullets'
								)
							),
							array(
								'param_name'=>'navigation_visibility',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Navigation visibility', 'mobimax'),
								'value'     => array(
									esc_html__('On mouseover','mobimax')  => 'mouseover',
									esc_html__('Always','mobimax')    => 'always',
								),
								'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
							),
							array(
								'param_name'=>'autoplay',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Autoplay', 'mobimax'),
								'value'     => $logic_values,
								'dependency' => Array('element' => 'layout', 'value' => array('carousel'))
							),
							array(
								'param_name' =>'animation_effect',
								'type'       => 'dropdown',
								'heading'    => esc_html__('Animation effect', 'mobimax'),
								'value'      => $animation_values,
								'dependency' => Array('element' => 'layout', 'value' => array('grid'))
							),
							array(
								'type' => 'textfield',
								'heading' => esc_html__( 'Quantity', 'mobimax' ),
								'value' => 12,
								'save_always' => true,
								'param_name' => "quantity",
								'description' => esc_html__( 'The "quantity" shortcode determines how many posts to show', 'mobimax' ),
							),
							array(
								'type' => 'textfield',
								'heading' => esc_html__( 'Category', 'mobimax' ),
								'value' => '',
								'param_name' => 'category',
								'save_always' => true,
								'description' => esc_html__( 'Enter comma separated categories slugs if you want to show certain categories', 'mobimax' ),
							),
							array(
								'type' => 'dropdown',
								'heading' => esc_html__( 'Operator', 'mobimax' ),
								'param_name' => 'operator',
								'value' => $operator_values,
								'save_always' => true,
								'description' => esc_html__( 'Select filter operator', 'mobimax' ),
								'dependency' => Array('element' => 'category', 'not_empty' => true)
							),
							array(
								'type' => 'dropdown',
								'heading' => esc_html__( 'Order by', 'mobimax' ),
								'param_name' => 'orderby',
								'value' => $order_by_values,
								'save_always' => true,
								'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'mobimax' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
							),
							array(
								'type' => 'dropdown',
								'heading' => esc_html__( 'Sort order', 'mobimax' ),
								'param_name' => 'order',
								'value' => $order_way_values,
								'save_always' => true,
								'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'mobimax' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
							),
							array(
								'type' => 'textfield',
								'heading' => esc_html__( 'Post excerpt length', 'mobimax' ),
								'value' => '104',
								'param_name' => 'excerpt',
							)
			    		)
			    	));

		/* HEADER BUILDER
		---------------*/

			$vc_menu_categories = array(
				esc_html__('Desktop header','mobimax'),
				esc_html__('Mobile header','mobimax'),
				esc_html__('Sidebar header','mobimax')
			);

			/* et_header_logo
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Header logo','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories,
		    		'base'                    => 'et_header_logo',
		    		'class'                   => 'et_header_logo hbe',
		    		'icon'                    => 'et_header_logo',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-logo.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-logo.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended,
							'default' => 'left'
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* static header
						---------------*/

							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Normal logo','mobimax'),
								'group'      => esc_html__('Default logo','mobimax'),
								'param_name' => 'logo',
							),

							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Retina logo (twice the width and height of normal logo)','mobimax'),
								'group'      => esc_html__('Default logo','mobimax'),
								'param_name' => 'retina_logo',
							),

						/* sticky header
						---------------*/

							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Normal logo','mobimax'),
								'group'      => esc_html__('Sticky logo','mobimax'),
								'param_name' => 'sticky_logo',
							),

							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__('Retina logo (twice the width and height of normal logo)','mobimax'),
								'group'      => esc_html__('Sticky logo','mobimax'),
								'param_name' => 'sticky_retina_logo',
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    		)
		    	));

			/* et_header_menu
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Header navigation menu','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories[0],
		    		'base'                    => 'et_header_menu',
		    		'class'                   => 'et_header_menu hbe font',
		    		'icon'                    => 'et_header_menu',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-menu.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-menu.js',
		    		'params'                  => array(
		    			array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Menu name','mobimax'),
							'param_name' => 'menu',
							'value'      => $menu_list,
							'default'    => 'choose'
						),
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('One page layout navigation','mobimax'),
							'description' => esc_html__('If you want yo use this menu as one page layout navigation, check this option.', 'mobimax'),
							'param_name' => 'one_page',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('One page navigation offset in px (without any string)','mobimax'),
							'param_name' => 'offset',
							'value'      => '0',
							'dependency' => Array('element' => 'one_page', 'value' => "true")
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* top level
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Space between menu items in px (without any string)','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_space',
									'value'      => '40',
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Items separator','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_separator',
									'value'      => $logic_values
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Items separator color','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_separator_color',
									'value'      => '#e0e0e0',
									'dependency' => Array('element' => 'menu_separator', 'value' => 'true')
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Items separator height (without any string)','mobimax'),
									'description'=> esc_html__('Leave blank if you want 100% height','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_separator_height',
									'value'      => '',
									'dependency' => Array('element' => 'menu_separator', 'value' => 'true')
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu indicator','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'submenu_indicator',
									'value'      => $logic_values
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color',
									'value'      => '#212121',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color hover','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color_hover',
									'value'      => $main_color,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Menu hover effect','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_hover',
									'value'      => array(
										esc_html__('None','mobimax')      => 'none',
										esc_html__('Underline','mobimax') => 'underline',
										esc_html__('Overline','mobimax')  => 'overline',
										esc_html__('Outline','mobimax')   => 'outline',
										esc_html__('Box','mobimax')       => 'box',
										esc_html__('Fill','mobimax')      => 'fill',
									),
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu hover effect color','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_effect_color',
									'value'      => '',
									'dependency' => Array('element' => 'menu_hover', 'value' => array('underline','overline','outline','box','fill'))
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'font_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'font_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font weight', 'mobimax'),
									'value'     => $font_weight_values,
									'std'       => '700'
								),
								array(
									'param_name'=>'font_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Font size (without any string)','mobimax'),
									'group'      => esc_html__('Top level','mobimax'),
									'param_name' => 'font_size',
									'value'      => '14',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Top level','mobimax'),
									'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
									'param_name' => 'letter_spacing',
									'value'      => '1'
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Text transform','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'text_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* submenu
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color',
									'value'      => '#bdbdbd',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color hover','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color_hover',
									'value'      => '#ffffff',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu background color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_back_color',
									'value'      => '#212121',
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu shadow','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_shadow',
									'value'      => $logic_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu indicator','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_submenu_indicator',
									'value'      => $logic_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu items separator','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_separator',
									'value'      => $logic_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu appear effect','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_appear',
									'value'      => array(
										esc_html__('Appear','mobimax')    => 'none',
										esc_html__('Fade','mobimax')      => 'fade',
										esc_html__('Move','mobimax')      => 'move',
										esc_html__('Fall','mobimax')      => 'fall',
									),
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu hover effect','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_hover',
									'value'      => array(
										esc_html__('None','mobimax')      => 'none',
										esc_html__('Underline','mobimax') => 'line',
										esc_html__('Dot','mobimax')       => 'dot',
										esc_html__('Outline','mobimax')   => 'outline',
										esc_html__('Box','mobimax')       => 'box',
										esc_html__('Fill','mobimax')      => 'fill',
									),
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu hover effect color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_effect_color',
									'value'      => '',
									'dependency' => Array('element' => 'submenu_hover', 'value' => array('line','dot','outline','box','fill'))
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'subfont_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'subfont_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font weight', 'mobimax'),
									'value'     => $font_weight_values
								),
								array(
									'param_name'=>'subfont_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Submenu font size (without any string)','mobimax'),
									'group'      => esc_html__('Submenu','mobimax'),
									'param_name' => 'subfont_size',
									'value'      => '',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Submenu','mobimax'),
									'heading'    => esc_html__('Submenu letter spacing (without any string)','mobimax'),
									'param_name' => 'subletter_spacing',
									'value'      => ''
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu text transform','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'subtext_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'subelement_font',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

						/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_megamenu
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Megamenu','mobimax'),
		    		'description'             => esc_html__('Use only with megamenu builder','mobimax'),
		    		'category'                => $vc_menu_categories[0],
		    		'base'                    => 'et_megamenu',
		    		'class'                   => 'et_megamenu hbe font',
		    		'icon'                    => 'et_megamenu',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-megamenu.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-megamenu.js',
		    		'params'                  => array(
		    			array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Menu name','mobimax'),
							'param_name' => 'menu',
							'value'      => $menu_list,
						),
						array(
							'param_name'=>'columns',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Column', 'mobimax'),
							'value'     => array(
								'1'  => '1',
								'2'  => '2',
								'3'  => '3',
								'4'  => '4',
								'5'  => '5',
								'6'  => '6'
							)
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* top level
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color',
									'value'      => '#212121',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color hover','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color_hover',
									'value'      => $main_color,
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Megamenu top level item border-bottom color','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'megamenu_border_color',
									'value'      => '#e0e0e0',
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'font_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'font_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font weight', 'mobimax'),
									'value'     => $font_weight_values,
									'std'       => '700'
								),
								array(
									'param_name'=>'font_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Font size (without any string)','mobimax'),
									'group'      => esc_html__('Top level','mobimax'),
									'param_name' => 'font_size',
									'value'      => '14',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Top level','mobimax'),
									'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
									'param_name' => 'letter_spacing',
									'value'      => '1'
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Text transform','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'text_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* submenu
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color',
									'value'      => '#bdbdbd',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color hover','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color_hover',
									'value'      => '#ffffff',
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu items separator','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_separator',
									'value'      => $logic_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu hover effect','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_hover',
									'value'      => array(
										esc_html__('None','mobimax')      => 'none',
										esc_html__('Uderline','mobimax')      => 'line',
										esc_html__('Dot','mobimax')       => 'dot',
										esc_html__('Outline','mobimax')   => 'outline',
										esc_html__('Box','mobimax')       => 'box',
										esc_html__('Fill','mobimax')      => 'fill',
									),
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu hover effect color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_effect_color',
									'value'      => '',
									'dependency' => Array('element' => 'submenu_hover', 'value' => array('line','dot','outline','box','fill'))
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'subfont_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'subfont_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font weight', 'mobimax'),
									'value'     => $font_weight_values
								),
								array(
									'param_name'=>'subfont_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Submenu font size (without any string)','mobimax'),
									'group'      => esc_html__('Submenu','mobimax'),
									'param_name' => 'subfont_size',
									'value'      => '',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Submenu','mobimax'),
									'heading'    => esc_html__('Submenu letter spacing (without any string)','mobimax'),
									'param_name' => 'subletter_spacing',
									'value'      => ''
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Submenu','mobimax'),
									'heading'    => esc_html__('Submenu line height (without any string)','mobimax'),
									'param_name' => 'subline_height',
									'value'      => ''
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu text transform','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'subtext_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => '32,0,16,0'
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'subelement_font',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    		)
		    	));

			/* et_megamenu_tab
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Megamenu tab','mobimax'),
		    		'description'             => esc_html__('Use only with megamenu builder','mobimax'),
		    		'category'                => $vc_menu_categories[0],
		    		'base'                    => 'et_megamenu_tab',
		    		'class'                   => 'et_megamenu_tab hbe font',
		    		'icon'                    => 'et_megamenu_tab',
		    		'as_parent'               => array('only' => 'et_megamenu_tab_item'),
		    		'content_element'         => true,
		    		'show_settings_on_create' => true,
		    		'is_container'            => true,
		    		'js_view'                 => 'VcColumnView',
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-megamenu-tab.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-megamenu-tab.js',
		    		'params'                  => array(
						array(
							'param_name'=>'size',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Tabs size', 'mobimax'),
							'value'     => $size_values_box
						),
						array(
							'param_name'=>'action',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Toggle on', 'mobimax'),
							'value'     => array(
								esc_html__('On click','mobimax')  => 'click',
								esc_html__('On hover','mobimax')  => 'hover',
							)
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Tabset background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'tabset_color',
								'value'      => '#f5f5f5',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Tab content background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'tab_content_color',
								'value'      => '#ffffff',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Menu color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'menu_color',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Menu color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'menu_color_hover',
								'value'      => $main_color,
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Menu hover effect','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'menu_hover',
								'value'      => array(
									esc_html__('None','mobimax')      => 'none',
									esc_html__('Uderline','mobimax')  => 'line',
									esc_html__('Dot','mobimax')       => 'dot',
									esc_html__('Outline','mobimax')   => 'outline',
									esc_html__('Box','mobimax')       => 'box',
									esc_html__('Fill','mobimax')      => 'fill',
								),
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Menu hover effect color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'menu_effect_color',
								'value'      => '',
								'dependency' => Array('element' => 'menu_hover', 'value' => array('line','dot','outline','box','fill'))
							),

						/* typography
						---------------*/

							array(
								'param_name'=>'font_family',
								'type'      => 'dropdown',
								'group'     => esc_html__('Typography','mobimax'),
								'heading'   => esc_html__('Font family', 'mobimax'),
								'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
								'value'     => $google_fonts_family,
							),
							array(
								'param_name'=>'font_weight',
								'type'      => 'dropdown',
								'group'     => esc_html__('Typography','mobimax'),
								'heading'   => esc_html__('Font weight', 'mobimax'),
								'value'     => $font_weight_values,
								'std'       => '700'
							),
							array(
								'param_name'=>'font_subsets',
								'type'      => 'dropdown',
								'group'     => esc_html__('Typography','mobimax'),
								'heading'   => esc_html__('Font subsets', 'mobimax'),
								'value'      => array(
									'latin' => 'latin',
								)
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Font size (without any string)','mobimax'),
								'group'      => esc_html__('Typography','mobimax'),
								'param_name' => 'font_size',
								'value'      => '14',
							),
							array(
								'type'       => 'textfield',
								'group'      => esc_html__('Typography','mobimax'),
								'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
								'param_name' => 'letter_spacing',
								'value'      => '1'
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Text transform','mobimax'),
								'group'      => 'Typography',
								'param_name' => 'text_transform',
								'value'      => array(
									esc_html__('None','mobimax')       => 'none',
									esc_html__('Uppercase','mobimax')  => 'uppercase',
									esc_html__('Lowercase','mobimax')  => 'lowercase',
									esc_html__('Capitalize','mobimax') => 'capitalize',
								)
							),

						/* padding
						---------------*/

							array(
								'type'       => 'padding',
								'group'      => esc_html__('Padding','mobimax'),
								'heading'    => esc_html__('Padding','mobimax'),
								'param_name' => 'padding',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

				vc_map(array(
					'name'                    => esc_html__('Megamenu tab item','mobimax'),
					'category'                => $vc_menu_categories[0],
					'base'                    => 'et_megamenu_tab_item',
					'class'                   => 'et_megamenu_tab_item hbe',
					'icon'                    => 'et_megamenu_tab_item',
					'as_child'                => array('only' => 'et_megamenu_tab'),
					"as_parent"               => array('except' => 'vc_section'),
					'content_element'         => true,
					"js_view"                 => 'VcColumnView',
					'show_settings_on_create' => true,
					'params'                  => array(
						array(
						'type'       => 'dropdown',
						'heading'    => esc_html__('Active','mobimax'),
						'param_name' => 'active',
						'value'      => array(
							'false' => 'false',
							'true'  => 'true'
						)
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__('Icon prefix','mobimax'),
						'param_name' => 'icon_prefix',
						'value'      => '',
						'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__('Icon name','mobimax'),
						'param_name' => 'icon_name',
						'value'      => '',
						'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__('Icon position','mobimax'),
						'param_name' => 'icon_position',
						'value'      => array(
							esc_html__('Left','mobimax')  => 'left',
							esc_html__('Right','mobimax')  => 'right',
						),
						'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
					),
					array(
	    				'type'       => 'textfield',
						'heading'    => esc_html__('Title','mobimax'),
						'param_name' => 'title',
						'value'      => ''
					),
					)
				));

			/* et_search_toggle
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Search toggle','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => array($vc_menu_categories[0],$vc_menu_categories[1]),
		    		'base'                    => 'et_search_toggle',
		    		'class'                   => 'et_search_toggle hbe',
		    		'icon'                    => 'et_search_toggle',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-search-toggle.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-search-toggle.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'icon_search',
								'heading'    => esc_html__('Icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon',
								'value'      => 'ien-esearch-15',
							),

							array(
								'type'       => 'icon_close',
								'heading'    => esc_html__('Close icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'close_icon',
								'value'      => 'ien-eclose-3',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon border width in px (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small (16px icon 32px icon box)','mobimax')  => 'small',
									esc_html__('Medium (20px icon 36px icon box)','mobimax') => 'medium',
									esc_html__('Large (24px icon 40px icon box)','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon size in px (without any string)','mobimax'),
								'param_name' => 'icon_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon box size in px (without any string)','mobimax'),
								'param_name' => 'icon_box_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

						/* searchbox
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Search box color','mobimax'),
								'group'      => 'Search box',
								'param_name' => 'search_color',
								'value'      => '#616161',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Search box background color','mobimax'),
								'group'      => 'Search box',
								'param_name' => 'search_background_color',
								'value'      => '#ffffff',
							),
							array(
								'param_name'=>'box_align',
								'group'      => 'Search box',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'      => array(
									esc_html__('Left','mobimax')  => 'left',
									esc_html__('Right','mobimax') => 'right',
								)
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    			/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_search_form
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Search form','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories,
		    		'base'                    => 'et_search_form',
		    		'class'                   => 'et_search_form hbe',
		    		'icon'                    => 'et_search_form',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-search-form.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-search-form.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'icon_search',
								'heading'    => esc_html__('Icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon',
								'value'      => 'ien-esearch-15',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
							),

						/* searchbox
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Search box width in px (without any string)','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_width',
								'value'      => '256',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Search box height in px (without any string)','mobimax'),
								'description'=> esc_html__('Minimum value is 32px','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_height',
								'value'      => '56',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Search box color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_color',
								'value'      => '#616161',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Search box background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_background_color',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Search box border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_border_color',
								'value'      => '#e0e0e0',
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

						/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_woo_search_form
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Woo search form','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories,
		    		'base'                    => 'et_woo_search_form',
		    		'class'                   => 'et_woo_search_form hbe',
		    		'icon'                    => 'et_woo_search_form',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-woo-search-form.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-woo-search-form.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'button_color',
								'value'      => '#ffffff',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'button_color_hover',
								'value'      => '#ffffff',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'button_background_color',
								'value'      => '#e05c0b',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'button_background_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'button_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'button_border_color_hover',
								'value'      => '',
							),

						/* searchbox
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Search box width in px (without any string)','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_width',
								'value'      => '620',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Search box height in px (without any string)','mobimax'),
								'description'=> esc_html__('Minimum value is 32px','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_height',
								'value'      => '48',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Search box color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_color',
								'value'      => '#616161',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Search box background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_background_color',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Search box border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'search_border_color',
								'value'      => '#e05c0b',
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

						/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_cart_toggle
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Cart toggle','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => array($vc_menu_categories[0],$vc_menu_categories[1]),
		    		'base'                    => 'et_cart_toggle',
		    		'class'                   => 'et_cart_toggle hbe',
		    		'icon'                    => 'et_cart_toggle',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-cart-toggle.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-cart-toggle.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'icon_cart',
								'heading'    => esc_html__('Icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon',
								'value'      => 'ien-ecart-35',
							),

							array(
								'type'       => 'icon_close',
								'heading'    => esc_html__('Close icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'close_icon',
								'value'      => 'ien-eclose-3',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

						/* cart info
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Cart info title color','mobimax'),
								'group'      => 'Cart info',
								'param_name' => 'cart_info_title_color',
								'value'      => '#e05c0b',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Cart info text color','mobimax'),
								'group'      => 'Cart info',
								'param_name' => 'cart_info_color',
								'value'      => '#616161',
							),


						/* cartbox
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Cart box product title color','mobimax'),
								'group'      => 'Cart box',
								'param_name' => 'cart_title_color',
								'value'      => '#212121',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Cart box text color','mobimax'),
								'group'      => 'Cart box',
								'param_name' => 'cart_color',
								'value'      => '#616161',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Cart box button color','mobimax'),
								'group'      => 'Cart box',
								'param_name' => 'cart_button_color',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Cart box button color hover','mobimax'),
								'group'      => 'Cart box',
								'param_name' => 'cart_button_color_hover',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Cart box button background color','mobimax'),
								'group'      => 'Cart box',
								'param_name' => 'cart_button_background_color',
								'value'      => $main_color,
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Cart box button background color hover','mobimax'),
								'group'      => 'Cart box',
								'param_name' => 'cart_button_background_color_hover',
								'value'      => '#212121',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Cart box background color','mobimax'),
								'group'      => 'Cart box',
								'param_name' => 'cart_background_color',
								'value'      => '#ffffff',
							),
							array(
								'param_name'=>'box_align',
								'type'      => 'dropdown',
								'group'      => 'Cart box',
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => array(
									esc_html__('Left','mobimax')  => 'left',
									esc_html__('Right','mobimax') => 'right',
								)
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

						/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_language_switcher
			---------------*/

				vc_map(array(
		    		'name'                    => esc_html__('Language switcher','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => array($vc_menu_categories[0],$vc_menu_categories[1]),
		    		'base'                    => 'et_language_switcher',
		    		'class'                   => 'et_language_switcher hbe',
		    		'icon'                    => 'et_language_switcher',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-language-switcher.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-language-switcher.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'icon_close',
								'heading'    => esc_html__('Close icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon',
								'value'      => 'ien-eclose-3',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon border width in px (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small (16px icon 32px icon box)','mobimax')  => 'small',
									esc_html__('Medium (20px icon 36px icon box)','mobimax') => 'medium',
									esc_html__('Large (24px icon 40px icon box)','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon size in px (without any string)','mobimax'),
								'param_name' => 'icon_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon box size in px (without any string)','mobimax'),
								'param_name' => 'icon_box_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

						/* submenu
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Submenu color','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_color',
								'value'      => '#bdbdbd',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Submenu color hover','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_color_hover',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Submenu background color','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_background_color',
								'value'      => '#212121',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Submenu background color hover','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_background_color_hover',
								'value'      => $main_color,
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Submenu  width in px (without any string)','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_width',
								'value'      => '200',
							),
							array(
								'param_name'=>'box_align',
								'group'      => 'Submenu',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => array(
									esc_html__('Center','mobimax')  => 'center',
									esc_html__('Left','mobimax')  => 'left',
									esc_html__('Right','mobimax') => 'right',
								)
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    			/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_currency_switcher
			---------------*/

				vc_map(array(
		    		'name'                    => esc_html__('Currency switcher','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => array($vc_menu_categories[0],$vc_menu_categories[1]),
		    		'base'                    => 'et_currency_switcher',
		    		'class'                   => 'et_currency_switcher hbe',
		    		'icon'                    => 'et_currency_switcher',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-currency-switcher.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-currency-switcher.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Text color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'text_color',
								'value'      => '#616161',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Text color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'text_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Highlighted currency color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'currency_color',
								'value'      => '#e05c0b',
							),

						/* submenu
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Submenu color','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_color',
								'value'      => '#bdbdbd',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Submenu color hover','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_color_hover',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Submenu background color','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_background_color',
								'value'      => '#212121',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Submenu background color hover','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_background_color_hover',
								'value'      => $main_color,
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Submenu  width in px (without any string)','mobimax'),
								'group'      => 'Submenu',
								'param_name' => 'submenu_width',
								'value'      => '200',
							),
							array(
								'param_name'=>'box_align',
								'group'      => 'Submenu',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => array(
									esc_html__('Center','mobimax')  => 'center',
									esc_html__('Left','mobimax')  => 'left',
									esc_html__('Right','mobimax') => 'right',
								)
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    			/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_login_toggle
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Front-end login','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => array($vc_menu_categories[0],$vc_menu_categories[1]),
		    		'base'                    => 'et_login_toggle',
		    		'class'                   => 'et_login_toggle hbe',
		    		'icon'                    => 'et_login_toggle',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-login-toggle.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-login-toggle.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('My account link','mobimax'),
							'param_name' => 'my_account_link',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Registration page link','mobimax'),
							'param_name' => 'registration_link',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Password recovery page','mobimax'),
							'param_name' => 'forgot_link',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'icon_user',
								'heading'    => esc_html__('Icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon',
								'value'      => 'ien-euser-1',
							),

							array(
								'type'       => 'icon_close',
								'heading'    => esc_html__('Close icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'close_icon',
								'value'      => 'ien-eclose-3',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon border width in px (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small (16px icon 32px icon box)','mobimax')  => 'small',
									esc_html__('Medium (20px icon 36px icon box)','mobimax') => 'medium',
									esc_html__('Large (24px icon 40px icon box)','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon size in px (without any string)','mobimax'),
								'param_name' => 'icon_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon box size in px (without any string)','mobimax'),
								'param_name' => 'icon_box_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

						/* loginbox
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box text color','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_color',
								'value'      => '#616161',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box link color','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_link_color',
								'value'      => '#e05c0b',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box background color','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_background_color',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box input border color','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_border_color',
								'value'      => '#e0e0e0',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box button color','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_button_color',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box button color hover','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_button_color_hover',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box button background color','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_button_background_color',
								'value'      => $main_color,
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box button background color hover','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_button_background_color_hover',
								'value'      => '#212121',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Login box button border width in px (without any string)','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_button_border_width',
								'value'      => '',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box button border color','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_button_border_color',
								'value'      => '',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Login box button border color hover','mobimax'),
								'group'      => 'Login box',
								'param_name' => 'login_button_border_color_hover',
								'value'      => '',
							),
							array(
								'param_name'=>'box_align',
								'type'      => 'dropdown',
								'group'     => 'Login box',
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => array(
									esc_html__('Left','mobimax')  => 'left',
									esc_html__('Right','mobimax') => 'right',
								)
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    			/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_header_slogan
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Slogan','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories,
		    		'base'                    => 'et_header_slogan',
		    		'class'                   => 'et_header_slogan hbe',
		    		'icon'                    => 'et_header_slogan',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-slogan.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-slogan.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Max width (without any string)','mobimax'),
							'param_name' => 'max_width',
							'value'      => '',
						),
						array(
							'type'       => 'textarea_html',
							'heading'    => esc_html__('Content','mobimax'),
							'param_name' => 'content',
							'value'      => '',
						),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    			/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_header_social_links
			---------------*/

				foreach ($social_links_array as $social) {
					vc_add_param('et_header_social_links', array(
						'type'       => 'textfield',
						'heading'    => ucfirst($social).' link',
						'param_name' => $social,
						'value'      => '',
						'weight' => 1
					));
				}

		    	vc_map(array(
					'name'                    => esc_html__('Social links','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories,
		    		'base'                    => 'et_header_social_links',
		    		'class'                   => 'et_header_social_links hbe',
		    		'icon'                    => 'et_header_social_links',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-social-links.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-social-links.js',
					'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),
						array(
							'param_name'=>'target',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Target', 'mobimax'),
							'value'     => array(
								'_self'  => '_self',
								'_blank' => '_blank'
							)
						),

						/* styling
						---------------*/

							array(
								'param_name'=>'styling_original',
								'type'      => 'dropdown',
								'group'     => esc_html__('Styling','mobimax'),
								'heading'   => esc_html__('Original styling', 'mobimax'),
								'value'     => $logic_values
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'     => esc_html__('Styling','mobimax'),
								'param_name' => 'icon_color',
								'value'      => '#616161',
								'dependency' => Array('element' => 'styling_original', 'value' => 'false')
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'     => esc_html__('Styling','mobimax'),
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
								'dependency' => Array('element' => 'styling_original', 'value' => 'false')
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'     => esc_html__('Styling','mobimax'),
								'param_name' => 'icon_background_color',
								'value'      => '',
								'dependency' => Array('element' => 'styling_original', 'value' => 'false')
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'     => esc_html__('Styling','mobimax'),
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
								'dependency' => Array('element' => 'styling_original', 'value' => 'false')
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'     => esc_html__('Styling','mobimax'),
								'param_name' => 'icon_border_color',
								'value'      => '',
								'dependency' => Array('element' => 'styling_original', 'value' => 'false')
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'     => esc_html__('Styling','mobimax'),
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
								'dependency' => Array('element' => 'styling_original', 'value' => 'false')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon border width (without any string)','mobimax'),
								'group'     => esc_html__('Styling','mobimax'),
								'param_name' => 'icon_border_width',
								'dependency' => Array('element' => 'styling_original', 'value' => 'false')
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small (16px icon 32px icon box)','mobimax')  => 'small',
									esc_html__('Medium (20px icon 36px icon box)','mobimax') => 'medium',
									esc_html__('Large (24px icon 40px icon box)','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon size in px (without any string)','mobimax'),
								'param_name' => 'icon_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon box size in px (without any string)','mobimax'),
								'param_name' => 'icon_box_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

						/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
					)
				));

			/* et_header_icon
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Header icon','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories,
		    		'base'                    => 'et_header_icon',
		    		'class'                   => 'et_header_icon hbe',
		    		'icon'                    => 'et_header_icon',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-icon.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-icon.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Icon prefix','mobimax'),
							'param_name' => 'icon_prefix',
							'value'      => '',
							'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
						),

						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Icon name','mobimax'),
							'param_name' => 'icon_name',
							'value'      => '',
							'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
						),

						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Icon link','mobimax'),
							'param_name' => 'icon_link',
							'value'      => '',
						),

						array(
							'param_name'=>'target',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Target', 'mobimax'),
							'value'     => array(
								'_self'  => '_self',
								'_blank' => '_blank'
							),
							'dependency' => Array('element' => 'icon_link', 'not_empty' => true)
						),

						/* styling
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon border width in px (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small (16px icon 32px icon box)','mobimax')  => 'small',
									esc_html__('Medium (20px icon 36px icon box)','mobimax') => 'medium',
									esc_html__('Large (24px icon 40px icon box)','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon size in px (without any string)','mobimax'),
								'param_name' => 'icon_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon box size in px (without any string)','mobimax'),
								'param_name' => 'icon_box_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    			/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_header_vertical_separator
			---------------*/

		    	vc_map(array(
					'name'                    => esc_html__('Vertical separator','mobimax'),
					'description'             => esc_html__('Use only with header builder','mobimax'),
					'category'                => $vc_menu_categories,
					'base'                    => 'et_header_vertical_separator',
		    		'class'                   => 'et_header_vertical_separator hbe',
		    		'icon'                    => 'et_header_vertical_separator',
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-vertical-separator.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-vertical-separator.js',
					'show_settings_on_create' => true,
					'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Type','mobimax'),
							'param_name' => 'type',
							'value'      => array(
								esc_html__('solid','mobimax')  => 'solid',
								esc_html__('dotted','mobimax') => 'dotted',
								esc_html__('dashed','mobimax') => 'dashed',
							)
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Color','mobimax'),
							'param_name' => 'color',
							'value'      => '#e0e0e0'
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Width (without any string, if you want 100% leave blank)','mobimax'),
							'param_name' => 'width',
							'value'      => ''
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Height (without any string, if you want 1px leave blank)','mobimax'),
							'param_name' => 'height',
							'value'      => ''
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => ''
						),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
					)
				));

			/* et_header_button
			---------------*/

				$megamenu_array = array( esc_html__( '-- Select -- ', 'mobimax' ) => '' );

				$query_options = array(
				    'post_type'           => 'megamenu',
				    'post_status'         => 'publish',
				    'ignore_sticky_posts' => 1,
				    'orderby'             => 'title',
				    'order'               => 'ASC',
				    'posts_per_page'      => -1,
				);

				// Fetch posts
				$megamenu_posts = get_posts( $query_options );

				if ( $megamenu_posts ) {
				    foreach ( $megamenu_posts as $post ) {
				        $megamenu_array[ get_the_title( $post->ID ) ] = $post->ID;
				    }
				}


				vc_map(array(
	    			'name'                    => esc_html__('Header button','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories,
		    		'base'                    => 'et_header_button',
		    		'class'                   => 'et_header_button hbe',
		    		'icon'                    => 'et_header_button',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-button.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-header-button.js',
		    		'show_settings_on_create' => true,
		    		'params'                  => array(
		    			array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),

						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Button text','mobimax'),
							'param_name' => 'button_text',
							'value'      => '',
						),

						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Button link','mobimax'),
							'param_name' => 'button_link',
							'value'      => '',
						),
						array(
							'param_name'=>'megamenu',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Show dropdown megamenu', 'mobimax'),
							'value'     => $megamenu_array
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Megamenu toggle on','mobimax'),
							'param_name' => 'submenu_toggle',
							'value'      => array(
								esc_html__('Hover','mobimax') => 'hover',
								esc_html__('Click','mobimax') => 'click',
							),
							'dependency' => Array('element' => 'megamenu', 'not_empty' => true)
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Megamenu appear effect','mobimax'),
							'param_name' => 'submenu_appear',
							'value'      => array(
								esc_html__('Appear','mobimax')    => 'none',
								esc_html__('Fade','mobimax')      => 'fade',
								esc_html__('Move','mobimax')      => 'move',
								esc_html__('Fall','mobimax')      => 'fall',
							),
							'dependency' => Array(
								array('element' => 'megamenu', 'not_empty' => true),
								array('element' => 'submenu_toggle', 'value' => 'hover')
							)
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Megamenu shadow','mobimax'),
							'param_name' => 'submenu_shadow',
							'value'      => $logic_values,
							'dependency' => Array('element' => 'megamenu', 'not_empty' => true)
						),
						array(
							'param_name'=>'target',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Target', 'mobimax'),
							'value'     => array(
								'_self'  => '_self',
								'_blank' => '_blank'
							)
						),
						array(
		    				'type'       => 'checkbox',
							'heading'    => esc_html__('Open link in modal window?', 'mobimax'),
							'param_name' => 'button_link_modal',
							'value'      => '',
						),

						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

		    			/* typography
						---------------*/

							array(
								'param_name'=>'font_family',
								'type'      => 'dropdown',
								'group'     => esc_html__('Typography', 'mobimax'),
								'heading'   => esc_html__('Font family', 'mobimax'),
								'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
								'value'     => $google_fonts_family,
							),
							array(
								'param_name'=>'font_weight',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Font weight', 'mobimax'),
								'group'     => esc_html__('Typography', 'mobimax'),
								'value'     => $font_weight_values,
							),
							array(
								'param_name'=>'font_subsets',
								'type'      => 'dropdown',
								'heading'   => esc_html__('Font subsets', 'mobimax'),
								'group'     => esc_html__('Typography', 'mobimax'),
								'value'     => array(
									'latin' => 'latin',
								)
							),
			    			array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button font size (without any string)','mobimax'),
								'group'      => esc_html__('Typography','mobimax'),
								'param_name' => 'button_font_size',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button letter spacing (without any string)','mobimax'),
								'group'      => esc_html__('Typography','mobimax'),
								'param_name' => 'button_letter_spacing',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button line height (without any string)','mobimax'),
								'group'      => esc_html__('Typography','mobimax'),
								'param_name' => 'button_line_height',
								'value'      => ''
							),
							array(
								'type'       => 'dropdown',
								'group'   	 => esc_html__('Typography', 'mobimax'),
								'heading'    => esc_html__('Text transform','mobimax'),
								'param_name' => 'button_text_transform',
								'value'      => array(
									esc_html__('None','mobimax')       => 'none',
									esc_html__('Uppercase','mobimax')  => 'uppercase',
									esc_html__('Lowercase','mobimax')  => 'lowercase',
									esc_html__('Capitalize','mobimax') => 'capitalize',
								)
							),

						/* styling
						---------------*/

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small','mobimax')  => 'small',
									esc_html__('Medium','mobimax') => 'medium',
									esc_html__('Large','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Button width in px (without any string)','mobimax'),
								'param_name' => 'width',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Button height in px (without any string)','mobimax'),
								'param_name' => 'height',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button color','mobimax'),
								'group'      => esc_html__('Styling','mobimax'),
								'param_name' => 'button_color',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button background color','mobimax'),
								'group'      => esc_html__('Styling','mobimax'),
								'param_name' => 'button_back_color',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button border color','mobimax'),
								'group'      => esc_html__('Styling','mobimax'),
								'param_name' => 'button_border_color',
								'value'      => ''
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button border radius (without any string)','mobimax'),
								'group'      => esc_html__('Styling','mobimax'),
								'param_name' => 'button_border_radius',
								'value'      => '0'
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Button border width (without any string)','mobimax'),
								'group'      => esc_html__('Styling','mobimax'),
								'param_name' => 'button_border_width',
							),

							array(
			    				'type'       => 'checkbox',
								'heading'    => esc_html__('Button shadow ?', 'mobimax'),
								'group'      => esc_html__('Styling','mobimax'),
								'param_name' => 'button_shadow',
								'value'      => '',
							),

						/* icon
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon prefix','mobimax'),
								'group'      => esc_html__('Icon','mobimax'),
								'param_name' => 'icon_prefix',
								'value'      => '',
								'description'=> esc_html__('If you want to use custom icons, you need to paste here the icon prefix, but if you want to use Fontawesome icons, leave this option blank','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon name','mobimax'),
								'group'      => esc_html__('Icon','mobimax'),
								'param_name' => 'icon_name',
								'value'      => '',
								'description'=> esc_html__('Add icon name, for example fa-gear. Make sure you did not forget about icon prefix option','mobimax')
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon size (without any string)','mobimax'),
								'group'      => esc_html__('Icon','mobimax'),
								'param_name' => 'icon_font_size',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Icon margin (without any string)','mobimax'),
								'group'      => esc_html__('Icon','mobimax'),
								'param_name' => 'icon_margin',
								'value'      => '',
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Icon position','mobimax'),
								'group'      => esc_html__('Icon','mobimax'),
								'param_name' => 'icon_position',
								'value'      => array(
									esc_html__('Left','mobimax')  => 'left',
									esc_html__('Right','mobimax')  => 'right',
								)
							),

						/* hover
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button color hover','mobimax'),
								'group'      => esc_html__('Hover','mobimax'),
								'param_name' => 'button_color_hover',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button background color hover','mobimax'),
								'group'      => esc_html__('Hover','mobimax'),
								'param_name' => 'button_back_color_hover',
								'value'      => ''
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Button border color hover','mobimax'),
								'group'      => esc_html__('Hover','mobimax'),
								'param_name' => 'button_border_color_hover',
								'value'      => ''
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Hover animation','mobimax'),
								'group'      => esc_html__('Hover','mobimax'),
								'param_name' => 'animate_hover',
								'value'      => array(
									esc_html__('None','mobimax')  => 'none',
									esc_html__('Fill','mobimax')  => 'fill',
									esc_html__('Scale','mobimax') => 'scale',
									esc_html__('Glint','mobimax') => 'glint',
								)
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Click animation','mobimax'),
								'group'      => esc_html__('Click','mobimax'),
								'param_name' => 'animate_click',
								'value'      => array(
									esc_html__('None','mobimax')  => 'none',
									esc_html__('Material','mobimax')  => 'material',
								)
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Smooth Click animation','mobimax'),
								'group'      => esc_html__('Click','mobimax'),
								'param_name' => 'click_smooth',
								'value'      => ''
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

		    			/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
	    		));

			/* et_align_container
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Align container','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => array($vc_menu_categories[1],$vc_menu_categories[2]),
		    		'base'                    => 'et_align_container',
		    		'class'                   => 'et_align_container',
		    		'icon'                    => 'et_align_container',
		    		'show_settings_on_create' => true,
		    		"as_parent"               => array('only' => 'et_gap, et_separator, et_woo_search_form, et_header_button, et_header_icon, et_header_social_links, et_header_slogan, et_search_form, et_header_logo'),
					"js_view"                 => 'VcColumnView',
		    		"content_element"         => true,
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Content align', 'mobimax'),
							'description' => esc_html__('Align any inside element', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),
		    		)
		    	));

		    /* et_vertical_align_top
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Vertical align top','mobimax'),
		    		'description'             => esc_html__('Use only with header builder for sidebar navigation header','mobimax'),
		    		'category'                => $vc_menu_categories[2],
		    		'base'                    => 'et_vertical_align_top',
		    		'class'                   => 'et_vertical_align_top',
		    		'icon'                    => 'et_vertical_align_top',
		    		'show_settings_on_create' => true,
		    		"as_parent"               => array('only' => 'et_gap, et_woo_search_form, et_separator, et_header_button, et_header_icon, et_header_social_links, et_header_slogan, et_search_form, et_header_logo, et_align_container, et_sidebar_menu'),
					"js_view"                 => 'VcColumnView',
		    		"content_element"         => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),
		    		)
		    	));

		    /* et_vertical_align_middle
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Vertical align middle','mobimax'),
		    		'description'             => esc_html__('Use only with header builder for sidebar navigation header','mobimax'),
		    		'category'                => $vc_menu_categories[2],
		    		'base'                    => 'et_vertical_align_middle',
		    		'class'                   => 'et_vertical_align_middle',
		    		'icon'                    => 'et_vertical_align_middle',
		    		'show_settings_on_create' => true,
		    		"as_parent"               => array('only' => 'et_gap, et_woo_search_form, et_separator, et_header_button, et_header_icon, et_header_social_links, et_header_slogan, et_search_form, et_header_logo, et_align_container, et_sidebar_menu'),
					"js_view"                 => 'VcColumnView',
		    		"content_element"         => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),
		    		)
		    	));

		    /* et_vertical_align_bottom
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Vertical align bottom','mobimax'),
		    		'description'             => esc_html__('Use only with header builder for sidebar navigation header','mobimax'),
		    		'category'                => $vc_menu_categories[2],
		    		'base'                    => 'et_vertical_align_bottom',
		    		'class'                   => 'et_vertical_align_bottom',
		    		'icon'                    => 'et_vertical_align_bottom',
		    		'show_settings_on_create' => true,
		    		"as_parent"               => array('only' => 'et_gap, et_woo_search_form, et_separator, et_header_button, et_header_icon, et_header_social_links, et_header_slogan, et_search_form, et_header_logo, et_align_container, et_sidebar_menu'),
					"js_view"                 => 'VcColumnView',
		    		"content_element"         => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),
		    		)
		    	));

			/* et_mobile_container
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Mobile container','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories[1],
		    		'base'                    => 'et_header_mobile_container',
		    		'class'                   => 'et_header_mobile_container',
		    		'icon'                    => 'et_header_mobile_container',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mobile-container.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mobile-container.js',
		    		"as_parent"               => array('only' => 'et_gap, et_heading, et_woo_search_form, et_separator, et_header_button, et_header_icon, et_header_social_links, et_header_slogan, et_search_form, et_mobile_menu, et_header_logo,et_align_container, et_mobile_close'),
					"js_view"                 => 'VcColumnView',
		    		"content_element"         => true,
		    		'params'                  => array(
						array(
							'param_name'=>'effect',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Appear from', 'mobimax'),
							'value'     => array(
								esc_html__('Left','mobimax')  => 'left',
								esc_html__('Right','mobimax') => 'right',
								esc_html__('Top','mobimax') => 'top',
							)
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'background_color',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Default text color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'text_color',
								'value'      => '#616161',
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Padding','mobimax'),
								'heading'    => esc_html__('Padding','mobimax'),
								'param_name' => 'margin',
								'value'      => '48,32,48,32'
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

		    /* et_mobile_toggle
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Mobile container toggle','mobimax'),
		    		'description'             => esc_html__('Use only with header builder to toggle the mobile container','mobimax'),
		    		'category'                => $vc_menu_categories[1],
		    		'base'                    => 'et_mobile_toggle',
		    		'class'                   => 'et_mobile_toggle hbe',
		    		'icon'                    => 'et_mobile_toggle',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mobile-toggle.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mobile-toggle.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'icon_menu',
								'heading'    => esc_html__('Icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon',
								'value'      => 'ien-emenu-1',
							),

							array(
								'type'       => 'icon_close',
								'heading'    => esc_html__('Close icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'close_icon',
								'value'      => 'ien-eclose-3',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon border width in px (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small (16px icon 32px icon box)','mobimax')  => 'small',
									esc_html__('Medium (20px icon 36px icon box)','mobimax') => 'medium',
									esc_html__('Large (24px icon 40px icon box)','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon size in px (without any string)','mobimax'),
								'param_name' => 'icon_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon box size in px (without any string)','mobimax'),
								'param_name' => 'icon_box_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    			/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_mobile_close
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Mobile container close','mobimax'),
		    		'description'             => esc_html__('Use only with header builder to close the mobile container','mobimax'),
		    		'category'                => $vc_menu_categories[1],
		    		'base'                    => 'et_mobile_close',
		    		'class'                   => 'et_mobile_close hbe',
		    		'icon'                    => 'et_mobile_close',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mobile-close.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mobile-close.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'icon_close',
								'heading'    => esc_html__('Icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon',
								'value'      => 'ien-eclose-3',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon border width in px (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small (16px icon 32px icon box)','mobimax')  => 'small',
									esc_html__('Medium (20px icon 36px icon box)','mobimax') => 'medium',
									esc_html__('Large (24px icon 40px icon box)','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon size in px (without any string)','mobimax'),
								'param_name' => 'icon_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon box size in px (without any string)','mobimax'),
								'param_name' => 'icon_box_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    		)
		    	));

			/* et_mobile_menu
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Mobile menu','mobimax'),
		    		'description'             => esc_html__('Use only with mobile container','mobimax'),
		    		'category'                => $vc_menu_categories[1],
		    		'base'                    => 'et_mobile_menu',
		    		'class'                   => 'et_mobile_menu font',
		    		'icon'                    => 'et_mobile_menu',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mobile-menu.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-mobile-menu.js',
		    		'params'                  => array(
		    			array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Menu name','mobimax'),
							'param_name' => 'menu',
							'value'      => $menu_list,
							'default'    => 'choose'
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Menu items separator color','mobimax'),
							'param_name' => 'separator_color',
							'value'      => '#e0e0e0',
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Text align','mobimax'),
							'param_name' => 'text_align',
							'value'      => $align_values,
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* top level
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color',
									'value'      => '#212121',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color hover','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color_hover',
									'value'      => $main_color,
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu background color hover','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_background_color_hover',
									'value'      => '',
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'font_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'font_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font weight', 'mobimax'),
									'value'     => $font_weight_values,
									'std'       => '700'
								),
								array(
									'param_name'=>'font_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Font size (without any string)','mobimax'),
									'group'      => esc_html__('Top level','mobimax'),
									'param_name' => 'font_size',
									'value'      => '14',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Menu items line height (without any string)','mobimax'),
									'group'      => esc_html__('Top level','mobimax'),
									'param_name' => 'line_height',
									'value'      => '24',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Top level','mobimax'),
									'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
									'param_name' => 'letter_spacing',
									'value'      => '1'
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Text transform','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'text_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* submenu
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color',
									'value'      => '#616161',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color hover','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color_hover',
									'value'      => $main_color,
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu background color hover','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_background_color_hover',
									'value'      => '',
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'subfont_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'subfont_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font weight', 'mobimax'),
									'value'     => $font_weight_values
								),
								array(
									'param_name'=>'subfont_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Submenu font size (without any string)','mobimax'),
									'group'      => esc_html__('Submenu','mobimax'),
									'param_name' => 'subfont_size',
									'value'      => '',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Submenu items line height (without any string)','mobimax'),
									'group'      => esc_html__('Submenu','mobimax'),
									'param_name' => 'subline_height',
									'value'      => '24',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Submenu','mobimax'),
									'heading'    => esc_html__('Submenu letter spacing (without any string)','mobimax'),
									'param_name' => 'subletter_spacing',
									'value'      => ''
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu text transform','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'subtext_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'subelement_font',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

			/* et_modal_container
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Modal container','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories[0],
		    		'base'                    => 'et_header_modal_container',
		    		'class'                   => 'et_header_modal_container',
		    		'icon'                    => 'et_header_modal_container',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-modal-container.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-modal-container.js',
		    		"as_parent"               => array('only' => 'et_gap, et_separator, et_header_button, et_header_icon, et_header_social_links, et_header_slogan, et_search_form, et_modal_menu, et_header_logo,et_align_container, et_modal_close'),
					"js_view"                 => 'VcColumnView',
		    		"content_element"         => true,
		    		'params'                  => array(
						array(
							'param_name'=>'effect',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Appear from', 'mobimax'),
							'value'     => array(
								esc_html__('Left','mobimax')  => 'left',
								esc_html__('Right','mobimax') => 'right',
								esc_html__('Top','mobimax') => 'top',
								esc_html__('Center','mobimax') => 'center',
							)
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'background_color',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Default text color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'text_color',
								'value'      => '#616161',
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Padding','mobimax'),
								'heading'    => esc_html__('Padding','mobimax'),
								'param_name' => 'margin',
								'value'      => '48,32,48,32'
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

		    /* et_modal_toggle
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Modal container toggle','mobimax'),
		    		'description'             => esc_html__('Use only with header builder to toggle the modal container','mobimax'),
		    		'category'                => $vc_menu_categories[0],
		    		'base'                    => 'et_modal_toggle',
		    		'class'                   => 'et_modal_toggle hbe',
		    		'icon'                    => 'et_modal_toggle',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-modal-toggle.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-modal-toggle.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'icon_menu',
								'heading'    => esc_html__('Icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon',
								'value'      => 'ien-emenu-1',
							),

							array(
								'type'       => 'icon_close',
								'heading'    => esc_html__('Close icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'close_icon',
								'value'      => 'ien-eclose-3',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon border width in px (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small (16px icon 32px icon box)','mobimax')  => 'small',
									esc_html__('Medium (20px icon 36px icon box)','mobimax') => 'medium',
									esc_html__('Large (24px icon 40px icon box)','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon size in px (without any string)','mobimax'),
								'param_name' => 'icon_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon box size in px (without any string)','mobimax'),
								'param_name' => 'icon_box_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    			/* visibility
						---------------*/

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from default header version?','mobimax'),
								'param_name' => 'hide_default',
								'value'      => '',
							),

							array(
								'type'       => 'checkbox',
								'group'    => esc_html__('Visibility','mobimax'),
								'heading'    => esc_html__('Hide from sticky header version?','mobimax'),
								'param_name' => 'hide_sticky',
								'value'      => '',
							),
		    		)
		    	));

			/* et_modal_close
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Modal container close','mobimax'),
		    		'description'             => esc_html__('Use only with header builder to close the modal container','mobimax'),
		    		'category'                => $vc_menu_categories[0],
		    		'base'                    => 'et_modal_close',
		    		'class'                   => 'et_modal_close hbe',
		    		'icon'                    => 'et_modal_close',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-modal-close.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-modal-close.js',
		    		'params'                  => array(
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'description' => esc_html__('!If you choose Center, do not forget to set the parent element text-align to center', 'mobimax'),
							'value'     => $align_values_extended
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'icon_close',
								'heading'    => esc_html__('Icon','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon',
								'value'      => 'ien-eclose-3',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color',
								'value'      => '#bdbdbd',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_color_hover',
								'value'      => '#212121',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon background color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_background_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color',
								'value'      => '',
							),

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Icon border color hover','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'icon_border_color_hover',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon border width in px (without any string)','mobimax'),
								'param_name' => 'icon_border_width',
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Size','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'size',
								'value'      => array(
									esc_html__('Small (16px icon 32px icon box)','mobimax')  => 'small',
									esc_html__('Medium (20px icon 36px icon box)','mobimax') => 'medium',
									esc_html__('Large (24px icon 40px icon box)','mobimax')  => 'large',
									esc_html__('Custom','mobimax')  => 'custom',
								),
								'std' => 'medium'
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon size in px (without any string)','mobimax'),
								'param_name' => 'icon_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

							array(
								'type'       => 'textfield',
								'group'      => 'Styling',
								'heading'    => esc_html__('Icon box size in px (without any string)','mobimax'),
								'param_name' => 'icon_box_size',
								'value'      => '',
								'dependency' => Array('element' => 'size', 'value' => 'custom')
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),

		    		)
		    	));

			/* et_modal_menu
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Modal menu','mobimax'),
		    		'description'             => esc_html__('Use only with modal container','mobimax'),
		    		'category'                => $vc_menu_categories[0],
		    		'base'                    => 'et_modal_menu',
		    		'class'                   => 'et_modal_menu font',
		    		'icon'                    => 'et_modal_menu',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-modal-menu.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-modal-menu.js',
		    		'params'                  => array(
		    			array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Menu name','mobimax'),
							'param_name' => 'menu',
							'value'      => $menu_list,
							'default'    => 'choose'
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Menu items separator color','mobimax'),
							'param_name' => 'separator_color',
							'value'      => '#e0e0e0',
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Text align','mobimax'),
							'param_name' => 'text_align',
							'value'      => $align_values,
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* top level
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color',
									'value'      => '#212121',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color hover','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color_hover',
									'value'      => $main_color,
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu background color hover','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_background_color_hover',
									'value'      => '',
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'font_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'font_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font weight', 'mobimax'),
									'value'     => $font_weight_values,
									'std'       => '700'
								),
								array(
									'param_name'=>'font_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Font size (without any string)','mobimax'),
									'group'      => esc_html__('Top level','mobimax'),
									'param_name' => 'font_size',
									'value'      => '32',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Menu items line height (without any string)','mobimax'),
									'group'      => esc_html__('Top level','mobimax'),
									'param_name' => 'line_height',
									'value'      => '48',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Top level','mobimax'),
									'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
									'param_name' => 'letter_spacing',
									'value'      => '1'
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Text transform','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'text_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* submenu
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color',
									'value'      => '#616161',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color hover','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color_hover',
									'value'      => $main_color,
								),
								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu background color hover','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_background_color_hover',
									'value'      => '',
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'subfont_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'subfont_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font weight', 'mobimax'),
									'value'     => $font_weight_values
								),
								array(
									'param_name'=>'subfont_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Submenu font size (without any string)','mobimax'),
									'group'      => esc_html__('Submenu','mobimax'),
									'param_name' => 'subfont_size',
									'value'      => '24',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Submenu items line height (without any string)','mobimax'),
									'group'      => esc_html__('Submenu','mobimax'),
									'param_name' => 'subline_height',
									'value'      => '32',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Submenu','mobimax'),
									'heading'    => esc_html__('Submenu letter spacing (without any string)','mobimax'),
									'param_name' => 'subletter_spacing',
									'value'      => '1'
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu text transform','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'subtext_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Margin','mobimax'),
								'heading'    => esc_html__('Margin','mobimax'),
								'param_name' => 'margin',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'subelement_font',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

			/* et_sidebar_container
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Sidebar container','mobimax'),
		    		'description'             => esc_html__('Use only with header builder','mobimax'),
		    		'category'                => $vc_menu_categories[2],
		    		'base'                    => 'et_header_sidebar_container',
		    		'class'                   => 'et_header_sidebar_container',
		    		'icon'                    => 'et_header_sidebar_container',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-sidebar-container.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-sidebar-container.js',
		    		"as_parent"               => array('only' => 'et_gap, et_woo_search_form, et_separator, et_header_button, et_header_icon, et_header_social_links, et_header_slogan, et_search_form, et_sidebar_menu, et_header_logo,et_align_container,et_vertical_align_top,et_vertical_align_middle,et_vertical_align_bottom'),
					"js_view"                 => 'VcColumnView',
		    		"content_element"         => true,
		    		'params'                  => array(

						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* styling
						---------------*/

							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Background color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'background_color',
								'value'      => '#ffffff',
							),
							array(
								'type'       => 'colorpicker',
								'heading'    => esc_html__('Default text color','mobimax'),
								'group'      => 'Styling',
								'param_name' => 'text_color',
								'value'      => '#616161',
							),

						/* margin
						---------------*/

							array(
								'type'       => 'margin',
								'group'      => esc_html__('Padding','mobimax'),
								'heading'    => esc_html__('Padding','mobimax'),
								'param_name' => 'margin',
								'value'      => '48,32,48,32'
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

		    /* et_sidebar_menu
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Sidebar navigation menu','mobimax'),
		    		'description'             => esc_html__('Use only with sidebar builder','mobimax'),
		    		'category'                => $vc_menu_categories[2],
		    		'base'                    => 'et_sidebar_menu',
		    		'class'                   => 'et_sidebar_menu hbe font',
		    		'icon'                    => 'et_sidebar_menu',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-sidebar-menu.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-sidebar-menu.js',
		    		'params'                  => array(
		    			array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Menu name','mobimax'),
							'param_name' => 'menu',
							'value'      => $menu_list,
							'default'    => 'choose'
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						/* top level
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color',
									'value'      => '#212121',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu color hover','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_color_hover',
									'value'      => $main_color,
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu indicator','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'submenu_indicator',
									'value'      => $logic_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Text align','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'tl_text_align',
									'value'      => $align_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Top level items separator','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'tl_separator',
									'value'      => $logic_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Menu hover effect','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_hover',
									'value'      => array(
										esc_html__('None','mobimax')      => 'none',
										esc_html__('Outline','mobimax')   => 'outline',
										esc_html__('Box','mobimax')       => 'box',
										esc_html__('Fill','mobimax')      => 'fill',
									),
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Menu hover effect color','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'menu_effect_color',
									'value'      => '',
									'dependency' => Array('element' => 'menu_hover', 'value' => array('outline','box','fill'))
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'font_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'font_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font weight', 'mobimax'),
									'value'     => $font_weight_values,
									'std'       => 'uppercase'
								),
								array(
									'param_name'=>'font_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Top level','mobimax'),
									'heading'   => esc_html__('Font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Font size (without any string)','mobimax'),
									'group'      => esc_html__('Top level','mobimax'),
									'param_name' => 'font_size',
									'value'      => '14',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Line height (without any string)','mobimax'),
									'group'      => esc_html__('Top level','mobimax'),
									'param_name' => 'line_height',
									'value'      => '24',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Top level','mobimax'),
									'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
									'param_name' => 'letter_spacing',
									'value'      => '1'
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Text transform','mobimax'),
									'group'      => 'Top level',
									'param_name' => 'text_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* submenu
						---------------*/

							/* styling
							---------------*/

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color',
									'value'      => '#bdbdbd',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu color hover','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_color_hover',
									'value'      => '#ffffff',
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu background color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_back_color',
									'value'      => '#212121',
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu shadow','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_shadow',
									'value'      => $logic_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu indicator','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_submenu_indicator',
									'value'      => $logic_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Text align','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'sub_text_align',
									'value'      => $align_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu items separator','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_separator',
									'value'      => $logic_values
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu appear effect','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_appear',
									'value'      => array(
										esc_html__('Appear','mobimax')    => 'none',
										esc_html__('Fade','mobimax')      => 'fade',
										esc_html__('Move','mobimax')      => 'move',
									),
								),

								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu hover effect','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_hover',
									'value'      => array(
										esc_html__('None','mobimax')      => 'none',
										esc_html__('Underline','mobimax') => 'line',
										esc_html__('Dot','mobimax')       => 'dot',
										esc_html__('Outline','mobimax')   => 'outline',
										esc_html__('Box','mobimax')       => 'box',
										esc_html__('Fill','mobimax')      => 'fill',
									),
								),

								array(
									'type'       => 'colorpicker',
									'heading'    => esc_html__('Submenu hover effect color','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'submenu_effect_color',
									'value'      => '',
									'dependency' => Array('element' => 'submenu_hover', 'value' => array('line','dot','outline','box','fill'))
								),

							/* typography
							---------------*/

								array(
									'param_name'=>'subfont_family',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font family', 'mobimax'),
									'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
									'value'     => $google_fonts_family,
								),
								array(
									'param_name'=>'subfont_weight',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font weight', 'mobimax'),
									'value'     => $font_weight_values
								),
								array(
									'param_name'=>'subfont_subsets',
									'type'      => 'dropdown',
									'group'     => esc_html__('Submenu','mobimax'),
									'heading'   => esc_html__('Submenu font subsets', 'mobimax'),
									'value'      => array(
										'latin' => 'latin',
									)
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Submenu font size (without any string)','mobimax'),
									'group'      => esc_html__('Submenu','mobimax'),
									'param_name' => 'subfont_size',
									'value'      => '',
								),
								array(
									'type'       => 'textfield',
									'heading'    => esc_html__('Submenu line height (without any string)','mobimax'),
									'group'      => esc_html__('Submenu','mobimax'),
									'param_name' => 'subline_height',
									'value'      => '',
								),
								array(
									'type'       => 'textfield',
									'group'      => esc_html__('Submenu','mobimax'),
									'heading'    => esc_html__('Submenu letter spacing (without any string)','mobimax'),
									'param_name' => 'subletter_spacing',
									'value'      => ''
								),
								array(
									'type'       => 'dropdown',
									'heading'    => esc_html__('Submenu text transform','mobimax'),
									'group'      => 'Submenu',
									'param_name' => 'subtext_transform',
									'value'      => array(
										esc_html__('None','mobimax')       => 'none',
										esc_html__('Uppercase','mobimax')  => 'uppercase',
										esc_html__('Lowercase','mobimax')  => 'lowercase',
										esc_html__('Capitalize','mobimax') => 'capitalize',
									)
								),

						/* padding
						---------------*/

							array(
								'type'       => 'padding',
								'group'      => esc_html__('Padding','mobimax'),
								'heading'    => esc_html__('Padding','mobimax'),
								'param_name' => 'padding',
								'value'      => ''
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'subelement_font',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

		/* TITLE SECTION
		---------------*/

			/* et_title_section_title
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Page title','mobimax'),
		    		'description'             => esc_html__('Use only with title section','mobimax'),
		    		'category'                => esc_html__('Title section','mobimax'),
		    		'base'                    => 'et_title_section_title',
		    		'class'                   => 'et_title_section_title font',
		    		'icon'                    => 'et_title_section_title',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-title-section-title.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-title-section-title.js',
		    		'params'                  => array(
		    			array(
							'type'       => 'textfield',
							"class"      => "element-attr-hide",
							'heading'    => esc_html__('Etp title','mobimax'),
							'param_name' => 'etp_title',
							'value'      => '',
						),
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'value'     => $align_values
						),
						array(
							'param_name'=>'text_align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Text align', 'mobimax'),
							'value'     => $align_values
						),
						array(
							'param_name'=>'type',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Tag', 'mobimax'),
							'value'     => array(
								'H1'  => 'h1',
								'H2'  => 'h2',
								'H3'  => 'h3',
								'H4'  => 'h4',
								'H5'  => 'h5',
								'H6'  => 'h6',
								'p'   => 'p',
								'div' => 'div',
							),
							'std' => 'h1'
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Text color','mobimax'),
							'param_name' => 'text_color',
							'value'      => '#212121',
						),

						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Background color','mobimax'),
							'param_name' => 'background_color',
							'value'      => '',
						),

						array(
							'param_name'=>'font_family',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Font family', 'mobimax'),
							'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
							'value'     => $google_fonts_family,
						),
						array(
							'param_name'=>'font_weight',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Font weight', 'mobimax'),
							'value'     => $font_weight_values,
						),
						array(
							'param_name'=>'font_subsets',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Font subsets', 'mobimax'),
							'value'      => array(
								'latin' => 'latin',
							)
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Font size (without any string)','mobimax'),
							'param_name' => 'font_size',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
							'param_name' => 'letter_spacing',
							'value'      => ''
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Line height (without any string)','mobimax'),
							'param_name' => 'line_height',
							'value'      => ''
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Text transform','mobimax'),
							'param_name' => 'text_transform',
							'value'      => array(
								esc_html__('None','mobimax')       => 'none',
								esc_html__('Uppercase','mobimax')  => 'uppercase',
								esc_html__('Lowercase','mobimax')  => 'lowercase',
								esc_html__('Capitalize','mobimax') => 'capitalize',
							)
						),

						/* tablet
						---------------*/

							array(
								'param_name'=>'tablet_align',
								'type'      => 'dropdown',
								'group'      => esc_html__('Tablet','mobimax'),
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => $align_values
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Tablet landscape font size (without any string)','mobimax'),
								'group'      => esc_html__('Tablet','mobimax'),
								'param_name' => 'tablet_landscape_font_size',
								'value'      => $font_size_values,
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Tablet landscape line height (without any string)','mobimax'),
								'group'      => esc_html__('Tablet','mobimax'),
								'param_name' => 'tablet_landscape_line_height',
								'value'      => $line_height_values,
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Tablet portrait font size (without any string)','mobimax'),
								'group'      => esc_html__('Tablet','mobimax'),
								'param_name' => 'tablet_portrait_font_size',
								'value'      => $font_size_values,
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Tablet portrait line height (without any string)','mobimax'),
								'group'      => esc_html__('Tablet','mobimax'),
								'param_name' => 'tablet_portrait_line_height',
								'value'      => $line_height_values,
							),

						/* mobile
						---------------*/

							array(
								'param_name'=>'mobile_align',
								'type'      => 'dropdown',
								'group'      => esc_html__('Mobile','mobimax'),
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => $align_values
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Font size (without any string)','mobimax'),
								'group'      => esc_html__('Mobile','mobimax'),
								'param_name' => 'mobile_font_size',
								'value'      => $font_size_values,
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Line height (without any string)','mobimax'),
								'group'      => esc_html__('Mobile','mobimax'),
								'param_name' => 'mobile_line_height',
								'value'      => $line_height_values,
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

			/* et_title_section_subtitle
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Page subtitle','mobimax'),
		    		'description'             => esc_html__('Use only with title section','mobimax'),
		    		'category'                => esc_html__('Title section','mobimax'),
		    		'base'                    => 'et_title_section_subtitle',
		    		'class'                   => 'et_title_section_subtitle font',
		    		'icon'                    => 'et_title_section_subtitle',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-title-section-subtitle.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-title-section-subtitle.js',
		    		'params'                  => array(
		    			array(
							'type'       => 'textfield',
							"class"      => "element-attr-hide",
							'heading'    => esc_html__('Etp title','mobimax'),
							'param_name' => 'etp_subtitle',
							'value'      => '',
						),
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'value'     => $align_values
						),
						array(
							'param_name'=>'text_align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Text align', 'mobimax'),
							'value'     => $align_values
						),
						array(
							'param_name'=>'type',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Tag', 'mobimax'),
							'value'     => array(
								'H1'  => 'h1',
								'H2'  => 'h2',
								'H3'  => 'h3',
								'H4'  => 'h4',
								'H5'  => 'h5',
								'H6'  => 'h6',
								'p'   => 'p',
								'div' => 'div',
							),
							'std' => 'p'
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Text color','mobimax'),
							'param_name' => 'text_color',
							'value'      => '#212121',
						),

						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Background color','mobimax'),
							'param_name' => 'background_color',
							'value'      => '',
						),

						array(
							'param_name'=>'font_family',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Font family', 'mobimax'),
							'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
							'value'     => $google_fonts_family,
						),
						array(
							'param_name'=>'font_weight',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Font weight', 'mobimax'),
							'value'     => $font_weight_values
						),
						array(
							'param_name'=>'font_subsets',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Font subsets', 'mobimax'),
							'value'      => array(
								'latin' => 'latin',
							)
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Font size (without any string)','mobimax'),
							'param_name' => 'font_size',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
							'param_name' => 'letter_spacing',
							'value'      => ''
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Line height (without any string)','mobimax'),
							'param_name' => 'line_height',
							'value'      => ''
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Text transform','mobimax'),
							'param_name' => 'text_transform',
							'value'      => array(
								esc_html__('None','mobimax')       => 'none',
								esc_html__('Uppercase','mobimax')  => 'uppercase',
								esc_html__('Lowercase','mobimax')  => 'lowercase',
								esc_html__('Capitalize','mobimax') => 'capitalize',
							)
						),

						/* tablet
						---------------*/

							array(
								'param_name'=>'tablet_align',
								'type'      => 'dropdown',
								'group'      => esc_html__('Tablet','mobimax'),
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => $align_values
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Tablet landscape font size (without any string)','mobimax'),
								'group'      => esc_html__('Tablet','mobimax'),
								'param_name' => 'tablet_landscape_font_size',
								'value'      => $font_size_values,
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Tablet landscape line height (without any string)','mobimax'),
								'group'      => esc_html__('Tablet','mobimax'),
								'param_name' => 'tablet_landscape_line_height',
								'value'      => $line_height_values,
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Tablet portrait font size (without any string)','mobimax'),
								'group'      => esc_html__('Tablet','mobimax'),
								'param_name' => 'tablet_portrait_font_size',
								'value'      => $font_size_values,
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Tablet portrait line height (without any string)','mobimax'),
								'group'      => esc_html__('Tablet','mobimax'),
								'param_name' => 'tablet_portrait_line_height',
								'value'      => $line_height_values,
							),

						/* mobile
						---------------*/

							array(
								'param_name'=>'mobile_align',
								'type'      => 'dropdown',
								'group'      => esc_html__('Mobile','mobimax'),
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => $align_values
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Font size (without any string)','mobimax'),
								'group'      => esc_html__('Mobile','mobimax'),
								'param_name' => 'mobile_font_size',
								'value'      => $font_size_values,
							),

							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Line height (without any string)','mobimax'),
								'group'      => esc_html__('Mobile','mobimax'),
								'param_name' => 'mobile_line_height',
								'value'      => $line_height_values,
							),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

			/* et_breadcrumbs
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Breadcrumbs','mobimax'),
		    		'description'             => esc_html__('Use only with title section','mobimax'),
		    		'category'                => esc_html__('Title section','mobimax'),
		    		'base'                    => 'et_breadcrumbs',
		    		'class'                   => 'et_breadcrumbs font',
		    		'icon'                    => 'et_breadcrumbs',
		    		'show_settings_on_create' => true,
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-breadcrumbs.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/et-breadcrumbs.js',
		    		'params'                  => array(
		    			array(
							'type'       => 'textfield',
							"class"      => "element-attr-hide",
							'heading'    => esc_html__('Etp breadcrumbs','mobimax'),
							'param_name' => 'etp_breadcrumbs',
							'value'      => '',
						),
						array(
							'param_name'=>'align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Align', 'mobimax'),
							'value'     => $align_values
						),
						array(
							'param_name'=>'text_align',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Text align', 'mobimax'),
							'value'     => $align_values
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Extra class','mobimax'),
							'param_name' => 'extra_class',
							'value'      => '',
						),

						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Text color','mobimax'),
							'param_name' => 'text_color',
							'value'      => '#616161',
						),

						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Separator color','mobimax'),
							'param_name' => 'separator_color',
							'value'      => '#616161',
						),

						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Background color','mobimax'),
							'param_name' => 'background_color',
							'value'      => '',
						),

						array(
							'param_name'=>'font_family',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Font family', 'mobimax'),
							'description' => esc_html__('800+ google fonts included. For preview click', 'mobimax').' <a href="//fonts.google.com/" target="_blank">'.esc_html__('here', 'mobimax').'</a>',
							'value'     => $google_fonts_family,
						),
						array(
							'param_name'=>'font_weight',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Font weight', 'mobimax'),
							'value'     => $font_weight_values
						),
						array(
							'param_name'=>'font_subsets',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Font subsets', 'mobimax'),
							'value'      => array(
								'latin' => 'latin',
							)
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Font size (without any string)','mobimax'),
							'param_name' => 'font_size',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Letter spacing (without any string)','mobimax'),
							'param_name' => 'letter_spacing',
							'value'      => ''
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Line height (without any string)','mobimax'),
							'param_name' => 'line_height',
							'value'      => ''
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Text transform','mobimax'),
							'param_name' => 'text_transform',
							'value'      => array(
								esc_html__('None','mobimax')       => 'none',
								esc_html__('Uppercase','mobimax')  => 'uppercase',
								esc_html__('Lowercase','mobimax')  => 'lowercase',
								esc_html__('Capitalize','mobimax') => 'capitalize',
							)
						),

						/* tablet
						---------------*/

							array(
								'param_name'=>'tablet_align',
								'type'      => 'dropdown',
								'group'      => esc_html__('Tablet','mobimax'),
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => $align_values
							),


						/* mobile
						---------------*/

							array(
								'param_name'=>'mobile_align',
								'type'      => 'dropdown',
								'group'      => esc_html__('Mobile','mobimax'),
								'heading'   => esc_html__('Align', 'mobimax'),
								'value'     => $align_values
							),


						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element font','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_font',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

		/* WIDGETS
		---------------*/

			/* widget_contact_form
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Fast contact form','mobimax'),
		    		'description'             => esc_html__('Use to add AJAX contact form','mobimax'),
		    		'category'                => esc_html__('WordPress Widgets','mobimax'),
		    		'base'                    => 'widget_contact_form',
		    		'class'                   => 'widget_contact_form',
		    		'icon'                    => 'widget_contact_form',
		    		'show_settings_on_create' => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Title','mobimax'),
							'param_name' => 'title',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Submit button text','mobimax'),
							'param_name' => 'submit_text',
							'value'      => 'Send',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Recipient','mobimax'),
							'param_name' => 'recipient',
							'value'      => get_option('admin_email'),
						),
		    		)
		    	));

		    /* widget_user_vehicle
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Add user vehicle','mobimax'),
		    		'description'             => esc_html__('Add vehicle form for customers','mobimax'),
		    		'category'                => esc_html__('WordPress Widgets','mobimax'),
		    		'base'                    => 'widget_user_vehicle',
		    		'class'                   => 'widget_user_vehicle',
		    		'icon'                    => 'widget_user_vehicle',
		    		'show_settings_on_create' => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Title','mobimax'),
							'param_name' => 'title',
							'value'      => '',
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Filter depth (Filtering level of details)','mobimax'),
							'param_name' => 'depth',
							'value'      => array(
								esc_html__('Make / Model / Year / Trim','mobimax') => 'trim',
								esc_html__('Make / Model','mobimax')   => 'model',
								esc_html__('Make','mobimax')   => 'make',
							),
							'std' => 'trim',
						),
		    		)
		    	));

		    /* widget_car_filter
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Car filter','mobimax'),
		    		'description'             => esc_html__('Filter products by make/model/trim','mobimax'),
		    		'category'                => esc_html__('WordPress Widgets','mobimax'),
		    		'base'                    => 'widget_car_filter',
		    		'class'                   => 'widget_car_filter',
		    		'icon'                    => 'widget_car_filter',
		    		'admin_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/widget-car-filter.js',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/widget-car-filter.js',
		    		'show_settings_on_create' => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Title','mobimax'),
							'param_name' => 'title',
							'value'      => esc_html__("Car filter","mobimax"),
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Use WooCommerce global attributes for filter','mobimax'),
							'param_name' => 'use_attrs',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Use hierarchy?','mobimax'),
							'description'=> esc_html__('Hierarchical filter attributes have a relationship between each other from left to right. Example: Make > Model > Year > Trim','mobimax'),
							'param_name' => 'hierarchy',
							'dependency' => Array('element' => 'use_attrs', 'value' => 'true')
						),
						array(
							'type'       => 'atts',
							'heading'    => esc_html__('Available attributes','mobimax'),
							'param_name' => 'atts',
							'value'      => '',
							'dependency' => Array('element' => 'use_attrs', 'value' => 'true')
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Type','mobimax'),
							'param_name' => 'type',
							'value'      => array(
								esc_html__('Horizontal','mobimax') => 'horizontal',
								esc_html__('Vertical','mobimax')   => 'vertical',
							),
							'std' => 'vertical'
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Enable search by VIN','mobimax'),
							'param_name' => 'vin',
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Filter depth (Filtering level of details)','mobimax'),
							'param_name' => 'depth',
							'value'      => array(
								esc_html__('Make / Model / Year / Trim','mobimax') => 'trim',
								esc_html__('Make / Model','mobimax')   => 'model',
								esc_html__('Make','mobimax')   => 'make',
							),
							'std' => 'trim',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Description','mobimax'),
							'param_name' => 'description',
							'value'      => esc_html__("Car parts for any car","mobimax"),
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Description background color','mobimax'),
							'param_name' => 'description_back',
							'value'      => '#ffc600',
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Filter background color','mobimax'),
							'param_name' => 'filter_back',
							'value'      => '#ffd800',
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Filter color','mobimax'),
							'param_name' => 'filter_color',
							'value'      => '#000000',
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Button background color','mobimax'),
							'param_name' => 'button_back',
							'value'      => '#d52b27',
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Button background color hover','mobimax'),
							'param_name' => 'button_back_hover',
							'value'      => '#000000',
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Button color','mobimax'),
							'param_name' => 'button_color',
							'value'      => '#ffffff',
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__('Button color hover','mobimax'),
							'param_name' => 'button_color_hover',
							'value'      => '#ffffff',
						),

						/* element_css
						---------------*/

							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Element id','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_id',
								'value'      => '',
							),

							array(
								'type'       => 'textarea',
								'heading'    => esc_html__('Element css','mobimax'),
								"class"      => "element-attr-hide",
								'param_name' => 'element_css',
								'value'      => '',
							),
		    		)
		    	));

		    /* widget_facebook
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Facebook like box','mobimax'),
		    		'description'             => esc_html__('Add facebook likebox','mobimax'),
		    		'category'                => esc_html__('WordPress Widgets','mobimax'),
		    		'base'                    => 'widget_facebook',
		    		'class'                   => 'widget_facebook',
		    		'icon'                    => 'widget_facebook',
		    		'show_settings_on_create' => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Title','mobimax'),
							'param_name' => 'title',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('App ID from the app dashboard','mobimax'),
							'param_name' => 'app_id',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('The URL of the Facebook Page','mobimax'),
							'param_name' => 'href',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Replace en_US with your locale, e.g., ru_RU for Russian (Russia)','mobimax'),
							'description' => esc_html__('You can change the language of the Page plugin by loading a localized version of the Facebook JavaScript SDK.','mobimax'),
							'param_name' => 'language_code',
							'value'      => 'en_US',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('The pixel width of the plugin. Min. is 180 & Max. is 500','mobimax'),
							'param_name' => 'width',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('The pixel height of the plugin. Min. is 70','mobimax'),
							'param_name' => 'height',
							'value'      => '',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Show timeline','mobimax'),
							'param_name' => 'timeline',
							'value'      => 'true',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Show events','mobimax'),
							'param_name' => 'events',
							'value'      => 'true',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Show messages','mobimax'),
							'param_name' => 'messages',
							'value'      => 'true',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Hide cover photo in the header','mobimax'),
							'param_name' => 'hide_cover',
							'value'      => 'false',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Show profile photos when friends like this','mobimax'),
							'param_name' => 'show_facepile',
							'value'      => 'false',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Use the small header instead','mobimax'),
							'param_name' => 'small_header',
							'value'      => 'false',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Try to fit inside the container width','mobimax'),
							'param_name' => 'adapt_container_width',
							'value'      => 'true',
						),

		    		)
		    	));

		    /* widget_flickr
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Flickr images','mobimax'),
		    		'description'             => esc_html__('Use to add images from flickr','mobimax'),
		    		'category'                => esc_html__('WordPress Widgets','mobimax'),
		    		'base'                    => 'widget_flickr',
		    		'class'                   => 'widget_flickr',
		    		'icon'                    => 'widget_flickr',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/widget-flickr.js',
		    		'show_settings_on_create' => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Title','mobimax'),
							'param_name' => 'title',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Number of photos to show','mobimax'),
							'param_name' => 'photos_number',
							'value'      => '6',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Flickr id','mobimax'),
							'description'=> esc_html__('For more infomration go:','mobimax').' '.'<a target="_blank" href="http://idgettr.com/">'.esc_html__( 'here', 'mobimax' ).'</a>',
							'param_name' => 'flickr_id',
							'value'      => '',
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Image size','mobimax'),
							'param_name' => 'image_size',
							'value'      => array(
								esc_html__('Small','mobimax')      => 'square',
								esc_html__('Thumbnails','mobimax') => 'thumb',
								esc_html__('Medium','mobimax')     => 'mid',
							),
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('Display','mobimax'),
							'param_name' => 'image_size',
							'value'      => array(
								esc_html__('Latest','mobimax') => 'latest',
								esc_html__('Random','mobimax') => 'random',
							),
						),
						array(
							'param_name'=>'columns_mob',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Columns mobile', 'mobimax'),
							'value'     => array(
								'1'  => '1',
								'2'  => '2',
								'3'  => '3',
								'4'  => '4',
								'5'  => '5',
								'6'  => '6',
								'7'  => '7',
								'8'  => '8',
								'9'  => '9',
								'10'  => '10'
							)
						),
						array(
							'param_name'=>'columns_tablet',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Columns tablet', 'mobimax'),
							'value'     => array(
								'1'  => '1',
								'2'  => '2',
								'3'  => '3',
								'4'  => '4',
								'5'  => '5',
								'6'  => '6',
								'7'  => '7',
								'8'  => '8',
								'9'  => '9',
								'10'  => '10'
							)
						),
						array(
							'param_name'=>'columns_desk',
							'type'      => 'dropdown',
							'heading'   => esc_html__('Columns desktop', 'mobimax'),
							'value'     => array(
								'1'  => '1',
								'2'  => '2',
								'3'  => '3',
								'4'  => '4',
								'5'  => '5',
								'6'  => '6',
								'7'  => '7',
								'8'  => '8',
								'9'  => '9',
								'10'  => '10'
							)
						),
		    		)

		    	));

		    /* widget_mailchimp
			---------------*/

 				$list_array = enovathemes_addons_mailchimp_list();

 				$list_values = array();

 				if ( !is_wp_error( $list_array ) && is_array($list_array)){

 					foreach ( $list_array as $list){
 						$list_values[$list['id']] = $list['name'];
 					}
 				}

				$list_values = array_flip($list_values);

				if (empty($list_values)) {
					array_push($list_values, esc_html__('Mailchimp did not return any list','mobimax'));
				}

		    	vc_map(array(
		    		'name'                    => esc_html__('Mailchimp','mobimax'),
		    		'description'             => esc_html__('Use to add AJAX mailchimp subscribe','mobimax'),
		    		'category'                => esc_html__('WordPress Widgets','mobimax'),
		    		'base'                    => 'widget_mailchimp',
		    		'class'                   => 'widget_mailchimp',
		    		'icon'                    => 'widget_mailchimp',
		    		'show_settings_on_create' => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Title','mobimax'),
							'param_name' => 'title',
							'value'      => '',
						),
						array(
							'type'       => 'textarea',
							'heading'    => esc_html__('Description','mobimax'),
							'param_name' => 'description',
							'value'      => '',
						),
						array(
							'type'       => 'dropdown',
							'heading'    => esc_html__('List','mobimax'),
							'description'=> esc_html__('Make sure you have the Mailchimp API key and at least one list in your Mailchimp dashboard. Go to theme options >> general >> Mailchimp API key','mobimax'),
							'param_name' => 'list',
							'value'      => $list_values,
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Show First Name field','mobimax'),
							'param_name' => 'first_name',
							'value'      => 'false',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Required?','mobimax'),
							'param_name' => 'required_first_name',
							'value'      => 'false',
							'dependency' => Array('element' => 'first_name', 'value' => 'true')
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Show Last Name field','mobimax'),
							'param_name' => 'last_name',
							'value'      => 'false',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Required?','mobimax'),
							'param_name' => 'required_last_name',
							'value'      => 'false',
							'dependency' => Array('element' => 'last_name', 'value' => 'true')
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Show phone field','mobimax'),
							'param_name' => 'phone',
							'value'      => 'false',
						),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__('Required?','mobimax'),
							'param_name' => 'required_phone',
							'value'      => 'false',
							'dependency' => Array('element' => 'phone', 'value' => 'true')
						),
		    		)
		    	));

			/* widget_posts
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Recent posts','mobimax'),
		    		'description'             => esc_html__('Use to add recent posts with image','mobimax'),
		    		'category'                => esc_html__('WordPress Widgets','mobimax'),
		    		'base'                    => 'widget_posts',
		    		'class'                   => 'widget_posts',
		    		'icon'                    => 'widget_posts',
		    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/widget-posts.js',
		    		'show_settings_on_create' => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Title','mobimax'),
							'param_name' => 'title',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Number of posts','mobimax'),
							'param_name' => 'number',
							'value'      => '',
						)
		    		)
		    	));

		    /* widget_login
			---------------*/

		    	vc_map(array(
		    		'name'                    => esc_html__('Login form','mobimax'),
		    		'description'             => esc_html__('Use to add front-end login form','mobimax'),
		    		'category'                => esc_html__('WordPress Widgets','mobimax'),
		    		'base'                    => 'widget_login',
		    		'class'                   => 'widget_login',
		    		'icon'                    => 'widget_login',
		    		'show_settings_on_create' => true,
		    		'params'                  => array(
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Title','mobimax'),
							'param_name' => 'title',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Registration page link','mobimax'),
							'param_name' => 'registration_link',
							'value'      => '',
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__('Password recovery page','mobimax'),
							'param_name' => 'forgot_link',
							'value'      => '',
						)
		    		)
		    	));

			if (class_exists('Woocommerce')) {

			    /* widget_filter_products_by_price
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Filter products by price','mobimax'),
			    		'description'             => esc_html__('Use to filter products by price','mobimax'),
			    		'category'                => esc_html__('WordPress Widgets','mobimax'),
			    		'base'                    => 'widget_filter_products_by_price',
			    		'class'                   => 'widget_filter_products_by_price',
			    		'icon'                    => 'widget_filter_products_by_price',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
			    		)
			    	));

			    /* widget_filter_products_by_attribute
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Filter products by attribute','mobimax'),
			    		'description'             => esc_html__('Use to filter products by attribute','mobimax'),
			    		'category'                => esc_html__('WordPress Widgets','mobimax'),
			    		'base'                    => 'widget_filter_products_by_attribute',
			    		'class'                   => 'widget_filter_products_by_attribute',
			    		'icon'                    => 'widget_filter_products_by_attribute',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Attribute','mobimax'),
								'param_name' => 'attribute',
								'value'      => $attributes
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Display type','mobimax'),
								'param_name' => 'display_type',
								'value'      => array(
									esc_html__('List','mobimax')     => 'list',
									esc_html__('Dropdown','mobimax') => 'dropdown',
								)
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Query type','mobimax'),
								'param_name' => 'query_type',
								'value'      => array(
									esc_html__('AND','mobimax') => 'AND',
									esc_html__('OR','mobimax')  => 'OR',
								)
							),
			    		)
			    	));

			    /* widget_filter_products_by_rating
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Average rating','mobimax'),
			    		'description'             => esc_html__('Use to filter products by rating','mobimax'),
			    		'category'                => esc_html__('WordPress Widgets','mobimax'),
			    		'base'                    => 'widget_filter_products_by_rating',
			    		'class'                   => 'widget_filter_products_by_rating',
			    		'icon'                    => 'widget_filter_products_by_rating',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
			    		)
			    	));

				/* widget_product_categories
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Product categories','mobimax'),
			    		'description'             => esc_html__('Woocommerce','mobimax'),
			    		'category'                => esc_html__('WordPress Widgets','mobimax'),
			    		'base'                    => 'widget_product_categories',
			    		'class'                   => 'widget_product_categories',
			    		'icon'                    => 'widget_product_categories',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/widget-product-categories.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Order by','mobimax'),
								'param_name' => 'orderby',
								'value'      => array(
									esc_html__('Category order','mobimax') => 'order',
									esc_html__('Name','mobimax') => 'name',
								),
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Show as dropdown','mobimax'),
								'param_name' => 'dropdown',
								'value'      => '1',
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Show product counts','mobimax'),
								'param_name' => 'count',
								'value'      => '1',
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Show hierarchy','mobimax'),
								'param_name' => 'hierarchical',
								'value'      => '1',
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Only show children of the current category','mobimax'),
								'param_name' => 'show_children_only',
								'value'      => '1',
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Hide empty categories','mobimax'),
								'param_name' => 'hide_empty',
								'value'      => '1',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Maximum depth','mobimax'),
								'param_name' => 'max_depth',
								'value'      => '',
							),
			    		)

			    	));

			    /* widget_products_by_rating
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Product by rating','mobimax'),
			    		'description'             => esc_html__('Woocommerce','mobimax'),
			    		'category'                => esc_html__('WordPress Widgets','mobimax'),
			    		'base'                    => 'widget_products_by_rating',
			    		'class'                   => 'widget_products_by_rating',
			    		'icon'                    => 'widget_products_by_rating',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/widget-products-by-rating.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Number of products to show','mobimax'),
								'param_name' => 'number',
								'value'      => '',
							),
			    		)

			    	));

			    /* widget_products
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Products','mobimax'),
			    		'description'             => esc_html__('Woocommerce','mobimax'),
			    		'category'                => esc_html__('WordPress Widgets','mobimax'),
			    		'base'                    => 'widget_products',
			    		'class'                   => 'widget_products',
			    		'icon'                    => 'widget_products',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/widget-products.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Number of products to show','mobimax'),
								'param_name' => 'number',
								'value'      => '',
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Show','mobimax'),
								'param_name' => 'show',
								'value'      => array(
									esc_html__('All products','mobimax') => '',
									esc_html__('Featured','mobimax') => 'featured',
									esc_html__('On-sale products','mobimax') => 'onsale',
								),
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Order by','mobimax'),
								'param_name' => 'orderby',
								'value'      => array(
									esc_html__('Date','mobimax') => 'date',
									esc_html__('Price','mobimax') => 'price',
									esc_html__('Random','mobimax') => 'random',
									esc_html__('Sales','mobimax') => 'sales',
								),
							),
							array(
								'type'       => 'dropdown',
								'heading'    => esc_html__('Order','mobimax'),
								'param_name' => 'order',
								'value'      => array(
									esc_html__('ASC','mobimax') => 'asc',
									esc_html__('DESC','mobimax') => 'desc',
								),
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Hide free products','mobimax'),
								'param_name' => 'hide_free',
								'value'      => '1',
							),
							array(
								'type'       => 'checkbox',
								'heading'    => esc_html__('Show hidden products','mobimax'),
								'param_name' => 'show_hidden',
								'value'      => '1',
							),
			    		)

			    	));

			    /* widget_recent_product_reviews
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Recent product reviews','mobimax'),
			    		'description'             => esc_html__('Woocommerce','mobimax'),
			    		'category'                => esc_html__('WordPress Widgets','mobimax'),
			    		'base'                    => 'widget_recent_product_reviews',
			    		'class'                   => 'widget_recent_product_reviews',
			    		'icon'                    => 'widget_recent_product_reviews',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/widget-products-reviews.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Number of products to show','mobimax'),
								'param_name' => 'number',
								'value'      => '',
							),
			    		)

			    	));

			    /* widget_recent_viewed_products
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Recent viewed products','mobimax'),
			    		'description'             => esc_html__('Woocommerce','mobimax'),
			    		'category'                => esc_html__('WordPress Widgets','mobimax'),
			    		'base'                    => 'widget_recent_viewed_products',
			    		'class'                   => 'widget_recent_viewed_products',
			    		'icon'                    => 'widget_recent_viewed_products',
			    		'front_enqueue_js'        => MOBIMAX_ENOVATHEMES_TEMPPATH .'/js/vc_elements/widget-products-viewed.js',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Number of products to show','mobimax'),
								'param_name' => 'number',
								'value'      => '',
							),
			    		)

			    	));

			    /* widget_product_tag_cloud
				---------------*/

			    	vc_map(array(
			    		'name'                    => esc_html__('Product tag cloud','mobimax'),
			    		'description'             => esc_html__('Woocommerce','mobimax'),
			    		'category'                => esc_html__('WordPress Widgets','mobimax'),
			    		'base'                    => 'widget_product_tag_cloud',
			    		'class'                   => 'widget_product_tag_cloud',
			    		'icon'                    => 'widget_product_tag_cloud',
			    		'show_settings_on_create' => true,
			    		'params'                  => array(
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__('Title','mobimax'),
								'param_name' => 'title',
								'value'      => '',
							)
			    		)

			    	));

		    }

	}

	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {

		class WPBakeryShortCode_et_Carousel extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Carousel_Item extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Accordion extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Accordion_Item extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Tab extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Tab_Item extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Testimonial_Container extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Client_Container extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Person_Container extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Banner extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Ad extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_More_Box extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Animate_Box extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Icon_Box_Container extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Make_Container extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Step_Box_Container extends WPBakeryShortCodesContainer {}

		class WPBakeryShortCode_et_Header_Sidebar_Container extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Header_Mobile_Container extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Header_Modal_Container extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Align_Container extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Vertical_Align_Top extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Vertical_Align_Middle extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Vertical_Align_Bottom extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Megamenu_Tab extends WPBakeryShortCodesContainer {}
		class WPBakeryShortCode_et_Megamenu_Tab_Item extends WPBakeryShortCodesContainer {}

	}

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_et_Make extends WPBakeryShortCode {}
	}
}

?>
