(function($){

    "use strict";

    function uniqueID() {return Math.floor((Math.random() * 1000000) + 1);}

    function isInArray(value, array) {return array.indexOf(value) > -1;}

    String.prototype.replaceAll = function(str1, str2, ignore) {
        return this.replace(new RegExp(str1.toString().replace(/([\/\,\!\\\^\$\{\}\[\]\(\)\.\*\+\?\|\<\>\-\&])/g,"\\$&"),(ignore?"gi":"g")),(typeof(str2)=="string")?str2.replace(/\$/g,"$$$$"):str2);
    }

    function iframeCSS(CSS){
        var iframe = $('#vc_inline-frame');
        if (typeof(iframe) != 'undefined' && iframe != null){
            iframe.ready(function() {
                CSS = CSS.replaceAll("dir-child*",">");
                iframe.contents().find("#dynamic-styles-inline-css").append(CSS);
            });
        }
    }

    function updateAttributes($this){

        var atts = [];

        var attributes = $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]').find('.sortable li');

        attributes.each(function(){
            atts.push($(this).data('attribute'));
        });

        $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]').find('input.atts').val(atts.join('|'))
    }

    function removeAttribute($this){

        $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]').find('.sortable li').each(function(){

            var li = $(this);

            li.find('.remove').on('click',function(){
                li.remove();
                updateAttributes($this);
            });
        });
    }

    function widgetSortableToggle($this){

        if ($this.is(':checked')) {

            $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]')
            .find('.draggable li')
            .draggable({
                connectToSortable: $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]').find('.sortable'),
                helper: "clone",
                revert: "invalid",
                start: function( event, ui ) {
                    $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]').find('.sortable').addClass('highlight');
                },
                stop: function( event, ui ) {
                    $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]').find('.sortable').removeClass('highlight');
                }
            })
            .disableSelection();

            $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]')
            .find('.sortable')
            .sortable({
                stop: function( event, ui ) {
                    updateAttributes($this);
                    removeAttribute($this);
                }
            })
            .disableSelection();

        }


    }
    

    function buildAttributes($this){

        var attributes = $this.find('input.atts').val();

        if (attributes.length) {

            attributes = attributes.split('|');

            for (var i = 0; i < attributes.length; i++) {

                var attributeArray = attributes[i].split(',');

                var li = '<li data-attribute="'+attributes[i]+'" class="draggable-item">'+attributeArray[1]+'<span class="remove" title="Remove attribute"></span></li>';

                $this.find('.sortable').append(li);
            }
           
        }
    }

    $( document ).ajaxComplete(function( event, xhr, settings ) {

        if (settings['type'] != 'POST') {return;}

        /* Prepare settings
        /*-------------*/

            var data = decodeURIComponent(settings['data']);

            data = data.split("&");

            var dataObj = [{}];

            for (var i = 0; i < data.length; i++) {
                var property = data[i].split("=");
                var key      = (property[0]);
                var value    = (property[1]);
                dataObj[key] = value;
            }

            var elementExists = Object.keys(dataObj).some(function(key) {
                return dataObj[key] === "widget_car_filter";
            });

        /* Edit element
        /*-------------*/

            if(dataObj['action'] == "vc_edit_form" && dataObj['tag'] == "widget_car_filter"){

                var edit_element = $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]');

                var element_css  = edit_element.find('textarea[name="element_css"]'),
                    element_id   = edit_element.find('input[name="element_id"]');

                var toggleAttributes = edit_element.find('input[name="use_attrs"]');

                widgetSortableToggle(toggleAttributes);

                toggleAttributes.on('change',function(){
                    widgetSortableToggle(toggleAttributes);
                });

                buildAttributes(edit_element);
                removeAttribute(toggleAttributes);
                
                $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"] .vc_ui-button-action[data-vc-ui-element="button-save"]').on('click',function(){

                    if ($('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]').length) {

                        var CSS = '';
                        var ID  = uniqueID();

                        edit_element = $('#vc_ui-panel-edit-element[data-vc-shortcode="widget_car_filter"]');

                        /* Top level
                        ---------------*/

                            var description_back  = edit_element.find('input[name="description_back"]').val(),
                                filter_back       = edit_element.find('input[name="filter_back"]').val(),
                                filter_color      = edit_element.find('input[name="filter_color"]').val(),
                                button_back       = edit_element.find('input[name="button_back"]').val(),
                                button_back_hover = edit_element.find('input[name="button_back_hover"]').val(),
                                button_color      = edit_element.find('input[name="button_color"]').val(),
                                button_color_hover= edit_element.find('input[name="button_color_hover"]').val();


                            if (description_back.length) {
                                CSS += '#car_filter_widget-'+ID+' .car-filter-description{background-color: '+description_back+';}';
                            }

                            if (filter_back.length) {
                                CSS += '#car_filter_widget-'+ID+' .et-car-filter, #car_filter_widget-'+ID+' .et-car-filter .vertical-vin-text{background-color: '+filter_back+';}';
                            }

                            if (filter_color.length) {
                                CSS += '#car_filter_widget-'+ID+' .et-car-filter {color: '+filter_color+';}';
                                CSS += '#car_filter_widget-'+ID+' .car-filter.vertical .vin-label:before {background-color: '+filter_color+';opacity:0.2;}';
                            }

                            if (button_back.length) {
                                CSS += '#car_filter_widget-'+ID+' .car-filter-button {background-color: '+button_back+';}';
                            }

                            if (button_back_hover.length) {
                                CSS += '#car_filter_widget-'+ID+' .car-filter-button:hover {background-color: '+button_back_hover+';}';
                            }

                            if (button_color.length) {
                                CSS += '#car_filter_widget-'+ID+' .car-filter-button {color: '+button_color+';}';
                            }

                            if (button_color_hover.length) {
                                CSS += '#car_filter_widget-'+ID+' .car-filter-button:hover {color: '+button_color_hover+';}';
                            }

                        element_id.val(ID);

                        if (CSS) {
                            element_css.text(CSS);
                            iframeCSS(CSS);
                            CSS = '';
                        }

                    }
                    
                });

                return;
            }

        
    });

})(jQuery);