<?php
include("wp-config.php");

// Update term meta
$makes_data  = array();
$models_data = array();

$makes = get_terms( array(
	'taxonomy' => 'product-make',
	'hide_empty' => false,
));

$models = get_terms( array(
	'taxonomy' => 'product-model',
	'hide_empty' => false,
));

$trims = get_terms( array(
	'taxonomy' => 'product-trim',
	'hide_empty' => false,
));

foreach ($makes as $term) {
	$makes_data[$term->name] = $term->term_id;
}

foreach ($models as $term) {
	$models_data[$term->name] = $term->term_id;
}

foreach ($models as $term) {
	$make = get_term_meta( $term->term_id,'enovathemes_addons_make');
	if (array_key_exists($make[0],$makes_data)) {
		update_term_meta( $term->term_id,'enovathemes_addons_make',$makes_data[$make[0]]);
		echo $term->name.' model updated!<br/>';
	}
}

foreach ($trims as $term) {
	$make  = get_term_meta( $term->term_id,'enovathemes_addons_make');
	$model = get_term_meta( $term->term_id,'enovathemes_addons_model');
	if (array_key_exists($make[0],$makes_data)) {
		update_term_meta( $term->term_id,'enovathemes_addons_make',$makes_data[$make[0]]);
	}
	if (array_key_exists($model[0],$models_data)) {
		update_term_meta( $term->term_id,'enovathemes_addons_model',$models_data[$model[0]]);
		echo $term->name.' trim updated!<br/>';
	}
}
?>
