<?php 
global $post;
$form_options			= get_option('wprc_form_settings');
$permissions			= get_option('wprc_permissions_settings');
$required_fields		= $form_options['required_fields'];
$reasons				= explode("\n", $form_options['report_reasons']);
$linksites            	= get_bloginfo('url'); 
$parse            		= parse_url($linksites); 
$host            		= $parse['host'];
?>

<div id="report_posts_modal" class="report_modal">
<div class="report_modal_content">

    <span class="report_close">&nbsp;</span>
	 
    <div class="title" style="font-weight: bold;text-align: center;"><?php echo $form_options['heading_title_report']; ?></div>
	
	<div class="wprc-content">
		
	<div class="line line-msg" style="display:none"><?php echo $form_options['thanks_message_report']; ?></div>

	<div class="wprc-message"></div>
		
	<div class="rs-msg"></div>
		
	<div class="wprc-form">
		<img class="loading-img" style="display:none;" src="<?php echo plugins_url( 'static/img/loading.gif' , dirname(__FILE__) ); ?>" />
		
		<?php if( $permissions['login_required'] && !is_user_logged_in() ){ ?>
		To report this post you need to <a href="<?php echo wp_login_url(); ?>" title="Login">login</a> first.
		<?php } else { ?>
		<div class="line line-input" style="display: none; ">
		  <label for="title" style="display: block; font-size: 14px; color: #333;margin: 10px 0;font-weight: 700;"><?php echo $form_options['title_post_report']; ?></label>
		  <input class="input" type="text" name="title" value="<?php the_title(); ?>" disabled>
		</div>
			
		<?php if($form_options['active_fields']['reporter_name']){ ?>
		<div class="line line-input">
		<label for="input-name-<?php echo $post->ID; ?>" style="display: block; font-size: 14px; color: #333;margin: 10px 0;font-weight: 700;"> <?php echo $form_options['nama_pengirim_report']; ?> <?php if($required_fields['reporter_name']): ?><strong style="color: red;"> * </strong><?php endif; ?></label>
		<input type="text" id="input-name-<?php echo $post->ID; ?>" class="input-name wprc-input" name="name" placeholder="Your name" />
		</div>
		<?php } ?>
					
		<?php if($form_options['active_fields']['reporter_email']){ ?>
		<div class="line line-input">
		<label for="input-email-<?php echo $post->ID; ?>" style="display: block; font-size: 14px; color: #333;margin: 10px 0;font-weight: 700;"> <?php echo $form_options['email_pengirim_report']; ?> <?php if($required_fields['reporter_email']): ?><strong style="color: red;"> * </strong><?php endif; ?> </label>
		<input type="text" id="input-email-<?php echo $post->ID; ?>" class="input-email wprc-input" name="email" placeholder="Your email" />
		</div>
		<?php } ?>
		
		<div class="line line-input">
		<label for="input-reason-<?php echo $post->ID; ?>" style="display: block; font-size: 14px; color: #333;margin: 10px 0;font-weight: 700;"> <?php echo $form_options['issues_report']; ?> <strong style="color: red;"> * </strong></label>
		<select id="input-reason-<?php echo $post->ID; ?>" class="input-reason">
		<?php foreach ($reasons as $key => $reason): ?>
		<option><?php echo esc_attr($reason); ?></option>
		<?php endforeach; ?>
		</select>
		</div>
		
		<?php if($form_options['active_fields']['details']){ ?>
		<div class="line line-input">
		<label for="input-details-<?php echo $post->ID; ?>" style="display: block; font-size: 14px; color: #333;margin: 10px 0;font-weight: 700;"> <?php echo $form_options['details_report']; ?> <?php if($required_fields['details']): ?><strong style="color: red;"> * </strong><?php endif; ?> </label>
		<textarea id="input-details-<?php echo $post->ID; ?>" class="input-details wprc-input" style="height: 55px;"></textarea>
		</div>
		<?php } ?>
					
		<div class="line">
		<input type="hidden" class="post-id" value="<?php echo $post->ID; ?>">
		<button type="button" class="wprc-submit submit" style="width: 100%; padding: 10px; background-color: var(--color_button); color: white; border: none; border-radius: 25px; font-size: 16px; display: flex; align-items: center; justify-content: center;"><?php echo $form_options['submit_button_text'] ?></button>
		</div>
		
		<?php } ?>
		
	</div>
	</div>
	
</div>
</div>

<style>
.report_modal {display: none;position: fixed;z-index: 30;padding-top: 100px;left: 0;top: 0;width: 100%;height: 100%;overflow: auto;background: rgba(0,0,0,.6);-webkit-backdrop-filter: saturate(180%) blur(10px);backdrop-filter: saturate(180%) blur(10px);}.report_modal_content {background-color: #fefefe;margin: auto;padding: 20px;border: 1px solid #888;width: 27%;border-radius: 2%;}.report_close {color: #aaaaaa;float: right;font-size: 28px;font-weight: bold;}.report_close:hover, .report_close:focus {color: #000;text-decoration: none;cursor: pointer;}
 
@media only screen and (max-width: 768px) {
	.report_modal_content { 
	  width: 80%!important; 
	}
	.report_modal {padding-top: 60px!important; }
}
.report_modal_content { 
	width: 25%; 
}
</style>
<script> 
var ReportModal	= document.getElementById('report_posts_modal');
var ReportBtn	= document.getElementById("report_posts");
var ReportClose = document.getElementsByClassName("report_close")[0];
ReportBtn.onclick = function () {
  ReportModal.style.display = "block";
};

ReportClose.onclick = function () {
  ReportModal.style.display = "none";
};

window.onclick = function (event) {
  if (event.target == ReportModal) {
    ReportModal.style.display = "none";
  }
};

$(document).ready(function() {
	$('#report_posts_modal').on('click', function(e) {
	  if(e.target == $(this)[0]) {
		$(this).hide(); // or hide()
	  }
	});
});

</script> 
 