<?php

namespace PHPSTORM_META {
    registerArgumentsSet(
        "locales",
        'en_US', 'af', 'am', 'ar', 'az_AZ',
        'be', 'bg', 'bn_BD', 'ca', 'cs_CZ', 'da_DK',
        'de_DE', 'el_GR', 'en_AU', 'en_CA', 'en_GB',
        'en_IN', 'en_SG', 'en_US', 'en_ZA', 'es_419',
        'es_ES', 'es_US', 'et', 'eu_ES', 'fa', 'fi_FI',
        'fil', 'fr_CA', 'fr_FR', 'gl_ES', 'hi_IN', 'hr',
        'hu_HU', 'hy_AM', 'id', 'is_IS', 'it_IT', 'iw_IL',
        'ja_JP', 'ka_GE', 'kk', 'km_KH', 'kn_IN', 'ko_KR',
        'ky_KG', 'lo_LA', 'lt', 'lv', 'mk_MK', 'ml_IN',
        'mn_MN', 'mr_IN', 'ms', 'my_MM', 'ne_NP', 'nl_NL',
        'no_NO', 'pl_PL', 'pt_BR', 'pt_PT', 'ro', 'ru_RU',
        'si_LK', 'sk', 'sl', 'sr', 'sv_SE', 'sw', 'ta_IN',
        'te_IN', 'th', 'tr_TR', 'uk', 'vi', 'zh_CN',
        'zh_HK', 'zh_TW', 'zu'
    );

    registerArgumentsSet(
        "locales_array",
        [
            'af', 'am', 'ar', 'az_AZ', 'be', 'bg', 'bn_BD', 'ca',
            'cs_CZ', 'da_DK','de_DE', 'el_GR', 'en_AU', 'en_CA', 'en_GB',
            'en_IN', 'en_SG', 'en_US', 'en_ZA', 'es_419', 'es_ES',
            'es_US', 'et', 'eu_ES', 'fa', 'fi_FI', 'fil', 'fr_CA',
            'fr_FR', 'gl_ES', 'hi_IN', 'hr', 'hu_HU', 'hy_AM', 'id',
            'is_IS', 'it_IT', 'iw_IL', 'ja_JP', 'ka_GE', 'kk', 'km_KH',
            'kn_IN', 'ko_KR', 'ky_KG', 'lo_LA', 'lt', 'lv', 'mk_MK',
            'ml_IN', 'mn_MN', 'mr_IN', 'ms', 'my_MM', 'ne_NP', 'nl_NL',
            'no_NO', 'pl_PL', 'pt_BR', 'pt_PT', 'ro', 'ru_RU', 'si_LK',
            'sk', 'sl', 'sr', 'sv_SE', 'sw', 'ta_IN', 'te_IN', 'th',
            'tr_TR', 'uk', 'vi', 'zh_CN', 'zh_HK', 'zh_TW', 'zu'
        ]
    );

    registerArgumentsSet(
        "countries",
        'us', 'af', 'ax', 'al', 'dz', 'as', 'ad', 'ao', 'ai',
        'aq', 'ag', 'ar', 'am', 'aw', 'ac', 'au', 'at', 'az',
        'bs', 'bh', 'bd', 'bb', 'by', 'be', 'bz', 'bj', 'bm',
        'bt', 'bo', 'ba', 'bw', 'br', 'io', 'vg', 'bn', 'bg',
        'bf', 'bi', 'kh', 'cm', 'ca', 'ic', 'cv', 'bq', 'ky',
        'cf', 'ea', 'td', 'cl', 'cn', 'cx', 'cc', 'co', 'km',
        'cg', 'cd', 'ck', 'cr', 'ci', 'hr', 'cu', 'cw', 'cy',
        'cz', 'dk', 'dg', 'dj', 'dm', 'do', 'ec', 'eg', 'sv',
        'gq', 'er', 'ee', 'sz', 'et', 'fk', 'fo', 'fj', 'fi',
        'fr', 'gf', 'pf', 'tf', 'ga', 'gm', 'ge', 'de', 'gh',
        'gi', 'gr', 'gl', 'gd', 'gp', 'gu', 'gt', 'gg', 'gn',
        'gw', 'gy', 'ht', 'hn', 'hk', 'hu', 'is', 'in', 'id',
        'ir', 'iq', 'ie', 'im', 'il', 'it', 'jm', 'jp', 'je',
        'jo', 'kz', 'ke', 'ki', 'xk', 'kw', 'kg', 'la', 'lv',
        'lb', 'ls', 'lr', 'ly', 'li', 'lt', 'lu', 'mo', 'mg',
        'mw', 'my', 'mv', 'ml', 'mt', 'mh', 'mq', 'mr', 'mu',
        'yt', 'mx', 'fm', 'md', 'mc', 'mn', 'me', 'ms', 'ma',
        'mz', 'mm', 'na', 'nr', 'np', 'nl', 'nc', 'nz', 'ni',
        'ne', 'ng', 'nu', 'nf', 'kp', 'mk', 'mp', 'no', 'om',
        'pk', 'pw', 'ps', 'pa', 'pg', 'py', 'pe', 'ph', 'pn',
        'pl', 'pt', 'xa', 'xb', 'pr', 'qa', 're', 'ro', 'ru',
        'rw', 'ws', 'sm', 'st', 'sa', 'sn', 'rs', 'sc', 'sl',
        'sg', 'sx', 'sk', 'si', 'sb', 'so', 'za', 'gs', 'kr',
        'ss', 'es', 'lk', 'bl', 'sh', 'kn', 'lc', 'mf', 'pm',
        'vc', 'sd', 'sr', 'sj', 'se', 'ch', 'sy', 'tw', 'tj',
        'tz', 'th', 'tl', 'tg', 'tk', 'to', 'tt', 'ta', 'tn',
        'tr', 'tm', 'tc', 'tv', 'um', 'vi', 'ug', 'ua', 'ae',
        'gb', 'us', 'uy', 'uz', 'vu', 'va', 've', 'vn', 'wf',
        'eh', 'ye', 'zm', 'zw'
    );

    registerArgumentsSet(
        'cache_ttl_sec',
        null,
        \DateInterval::createFromDateString('5 min'),
        \DateInterval::createFromDateString('10 min'),
        \DateInterval::createFromDateString('1 hour'),
        \DateInterval::createFromDateString('1 day'),
        60,
        60 * 5,
        60 * 60,
    );

    registerArgumentsSet(
        'sort',
        \Nelexa\GPlay\Enum\SortEnum::HELPFULNESS(),
        \Nelexa\GPlay\Enum\SortEnum::NEWEST(),
        \Nelexa\GPlay\Enum\SortEnum::RATING(),
    );

    registerArgumentsSet(
        'price',
        \Nelexa\GPlay\Enum\PriceEnum::ALL(),
        \Nelexa\GPlay\Enum\PriceEnum::FREE(),
        \Nelexa\GPlay\Enum\PriceEnum::PAID(),
    );

    registerArgumentsSet(
        'age',
        null,
        \Nelexa\GPlay\Enum\AgeEnum::FIVE_UNDER(),
        \Nelexa\GPlay\Enum\AgeEnum::SIX_EIGHT(),
        \Nelexa\GPlay\Enum\AgeEnum::NINE_UP(),
    );

    registerArgumentsSet(
        'category',
        \Nelexa\GPlay\Enum\CategoryEnum::GAME(),
        \Nelexa\GPlay\Enum\CategoryEnum::FAMILY(),
        \Nelexa\GPlay\Enum\CategoryEnum::ART_AND_DESIGN(),
        \Nelexa\GPlay\Enum\CategoryEnum::AUTO_AND_VEHICLES(),
        \Nelexa\GPlay\Enum\CategoryEnum::BEAUTY(),
        \Nelexa\GPlay\Enum\CategoryEnum::BOOKS_AND_REFERENCE(),
        \Nelexa\GPlay\Enum\CategoryEnum::BUSINESS(),
        \Nelexa\GPlay\Enum\CategoryEnum::COMICS(),
        \Nelexa\GPlay\Enum\CategoryEnum::COMMUNICATION(),
        \Nelexa\GPlay\Enum\CategoryEnum::DATING(),
        \Nelexa\GPlay\Enum\CategoryEnum::EDUCATION(),
        \Nelexa\GPlay\Enum\CategoryEnum::ENTERTAINMENT(),
        \Nelexa\GPlay\Enum\CategoryEnum::EVENTS(),
        \Nelexa\GPlay\Enum\CategoryEnum::FINANCE(),
        \Nelexa\GPlay\Enum\CategoryEnum::FOOD_AND_DRINK(),
        \Nelexa\GPlay\Enum\CategoryEnum::HEALTH_AND_FITNESS(),
        \Nelexa\GPlay\Enum\CategoryEnum::HOUSE_AND_HOME(),
        \Nelexa\GPlay\Enum\CategoryEnum::LIBRARIES_AND_DEMO(),
        \Nelexa\GPlay\Enum\CategoryEnum::LIFESTYLE(),
        \Nelexa\GPlay\Enum\CategoryEnum::MAPS_AND_NAVIGATION(),
        \Nelexa\GPlay\Enum\CategoryEnum::MEDICAL(),
        \Nelexa\GPlay\Enum\CategoryEnum::MUSIC_AND_AUDIO(),
        \Nelexa\GPlay\Enum\CategoryEnum::NEWS_AND_MAGAZINES(),
        \Nelexa\GPlay\Enum\CategoryEnum::PARENTING(),
        \Nelexa\GPlay\Enum\CategoryEnum::PERSONALIZATION(),
        \Nelexa\GPlay\Enum\CategoryEnum::PHOTOGRAPHY(),
        \Nelexa\GPlay\Enum\CategoryEnum::PRODUCTIVITY(),
        \Nelexa\GPlay\Enum\CategoryEnum::SHOPPING(),
        \Nelexa\GPlay\Enum\CategoryEnum::SOCIAL(),
        \Nelexa\GPlay\Enum\CategoryEnum::SPORTS(),
        \Nelexa\GPlay\Enum\CategoryEnum::TOOLS(),
        \Nelexa\GPlay\Enum\CategoryEnum::TRAVEL_AND_LOCAL(),
        \Nelexa\GPlay\Enum\CategoryEnum::VIDEO_PLAYERS(),
        \Nelexa\GPlay\Enum\CategoryEnum::ANDROID_WEAR(),
        \Nelexa\GPlay\Enum\CategoryEnum::WATCH_FACE(),
        \Nelexa\GPlay\Enum\CategoryEnum::WEATHER(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_ACTION(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_ADVENTURE(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_ARCADE(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_BOARD(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_CARD(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_CASINO(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_CASUAL(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_EDUCATIONAL(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_MUSIC(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_PUZZLE(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_RACING(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_ROLE_PLAYING(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_SIMULATION(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_SPORTS(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_STRATEGY(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_TRIVIA(),
        \Nelexa\GPlay\Enum\CategoryEnum::GAME_WORD(),
    );

    registerArgumentsSet(
        'limit',
        \Nelexa\GPlay\GPlayApps::UNLIMIT,
        50,
        100,
        150,
        200,
        250,
        300,
        350,
        400,
        500
    );

    expectedArguments(\Nelexa\GPlay\GPlayApps::__construct(), 0, argumentsSet("locales"));
    expectedArguments(\Nelexa\GPlay\GPlayApps::__construct(), 1, argumentsSet("countries"));
    expectedArguments(\Nelexa\GPlay\GPlayApps::setConcurrency(), 0, 4, 8, 1, 2, 3, 5, 6, 7, 9, 10, 11, 12);
    expectedArguments(\Nelexa\GPlay\GPlayApps::setProxy(), 0, null, 'socks5://', 'https://', 'http://', 'socks4://', 'socks4a://', 'socks5h://', 'socks5://127.0.0.1:9050');
    expectedArguments(\Nelexa\GPlay\GPlayApps::setCache(), 1, argumentsSet('cache_ttl_sec'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::setCacheTtl(), 0, argumentsSet('cache_ttl_sec'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getAppInfoForLocales(), 1, argumentsSet('locales_array'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getReviews(), 2, argumentsSet('sort'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getCategoriesForLocales(), 0, argumentsSet('locales_array'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getDeveloperInfoForLocales(), 1, argumentsSet('locales_array'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getSimilarApps(), 1, argumentsSet('limit'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::search(), 1, argumentsSet('limit'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::search(), 2, argumentsSet('price'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getListApps(), 1, argumentsSet('age'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getListApps(), 2, argumentsSet('limit'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getTopApps(), 1, argumentsSet('age'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getTopApps(), 2, argumentsSet('limit'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getNewApps(), 1, argumentsSet('age'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::getNewApps(), 2, argumentsSet('limit'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::saveGoogleImages(), 1, static function (\Nelexa\GPlay\Model\GoogleImage $image): string {
        $hash = $image->getHashUrl($hashAlgo = 'md5', $parts = 2, $partLength = 2);
        return 'path/to/screenshots/' . $hash . '.{ext}';
    });
    expectedReturnValues(\Nelexa\GPlay\GPlayApps::getDefaultLocale(), argumentsSet('locales'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::setDefaultLocale(), 0, argumentsSet("locales"));
    expectedReturnValues(\Nelexa\GPlay\GPlayApps::getDefaultCountry(), argumentsSet('countries'));
    expectedArguments(\Nelexa\GPlay\GPlayApps::setDefaultCountry(), 0, argumentsSet("countries"));

    expectedArguments(\Nelexa\GPlay\Model\AppId::__construct(), 1, argumentsSet("locales"));
    expectedArguments(\Nelexa\GPlay\Model\AppId::__construct(), 2, argumentsSet("countries"));
}
