<?php 
 

/*-----------------------------------------------------------------------------------*/
/*  Popular Home View Most widget
/*-----------------------------------------------------------------------------------*/
class list_all_cats extends WP_Widget {

	public function __construct(){
		$widget_ops = array(
			'classname'   => 'list_all_categories',
			'description' => __( 'Sidebar List All Categories Subparent images', THEMES_NAMES ),
		);
		parent::__construct( 'list_all_categories', __( '(MDR) Sidebar List All Categories', THEMES_NAMES ), $widget_ops );
	}
	
	public function widget( $args, $instance ){
		$widget_id			= $this->id_base . '-' . $this->number;
		 
		$title				= apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		global $opt_themes;
		 
		$terms = get_terms(array(
					'taxonomy'=> 'category', 
					'hide_empty' => false, 
					'order' => 'DESC'
		));       
                foreach ( $terms as $term ) {
					$subterms = get_terms(array(
					'taxonomy'=> 'category', 
					'hide_empty' => false, 
					'parent' => $term->term_id
					)); 
                    if ($term->parent == 0 ) { if ($subterms ) {
					?>
					<section id="<?php echo $widget_id; ?>" class="<?php 
					switch($opt_themes['themes_styles']){
						case 'moddroid':
							echo 'mb-2';
						break; 
						
						case 'modyolo':
							echo 'bg-white border rounded shadow-sm pt-3 px-2 px-md-3 mb-3';
						break; 
						
						case 'reborn':
							echo 'bg-white rounded pb-3 pt-3 px-2 mb-4 ';
						break; 
						
						default:
							echo 'mb-2';
						break;
					} ?> ">


					<?php 
					switch($opt_themes['themes_styles']){
						case 'moddroid':
						?>
						<h4 class="h5 font-weight-semibold mb-3">
						<a class="text-body border-bottom-2 border-secondary d-inline-block pb-1" href="<?php echo get_category_link( $term->term_id ); ?>"><?php echo $term->name; ?></a>
						</h4>
						<div class="row">
						
						<?php
						break; 
						
						case 'modyolo':
						?>
						<header class="d-flex align-items-end mb-3">
						<h2 class="h5 font-weight-semibold mb-0">
						<a class="text-body" href="<?php echo get_category_link( $term->term_id ); ?>">
						<?php echo $term->name; ?>		
						</a>
						</h2>
						<a class="btn btn-primary btn-sm ml-auto" href="<?php echo get_category_link( $term->term_id ); ?>"><?php _e('View More', TEXT_DOMAIN); ?></a>
						</header>
						<div class="row">
						<?php
						break; 
						
						case 'reborn':
						?>
						<div class="d-flex align-items-baseline justify-content-between ">
						<h2 class="h5 font-weight-semibold m-0 p-0 mb-3 "><?php echo $term->name; ?></h2>
						<a class="small text-truncate text-muted pr-2 " href="<?php echo get_category_link( $term->term_id ); ?>"><?php _e('View More', TEXT_DOMAIN); ?></a>
						</div>	 
						<div class="row">
						<?php
						break; 
						
						default:
						?>
						<h4 class="h5 font-weight-semibold mb-3">
						<a class="text-body border-bottom-2 border-secondary d-inline-block pb-1" href="<?php echo get_category_link( $term->term_id ); ?>"><?php echo $term->name; ?></a>
						</h4>
						<div class="row">
						<?php
						break;
					} ?> 


 
                    <?php } ?>
					
					<?php 
					global $wpdb, $post, $opt_themes, $wp_query;  
					foreach ($subterms as $key => $value) {
					$args = array(
						'post_type' 		=> 'post',
						'posts_per_page' 	=> 1,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field'    => 'term_id',
								'terms'    => $value->term_id,
							),
						),
					);
					$post_cats = new WP_Query($args);                      
					global $wpdb, $post, $opt_themes, $wp_query;                         
					while($post_cats-> have_posts()) : $post_cats-> the_post(); 	
					$linkgambar 	= wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'thumbnails', false, '' ); 
					?>
					<div class="col-6 mb-3">
					<a class="d-flex align-items-center position-relative aside-cat" href="<?php echo get_category_link( $value->term_id ); ?>" title="<?php echo $value->name; ?>">
					<?php if($instance['show_image']){?>
					<img class="rounded-circle flex-shrink-0 mr-2" style="font-size: 0; width: 2rem; height: 2rem;" src="<?php echo $linkgambar[0];?>" alt="<?php echo $value->name; ?>">
					<?php } ?>
					<span class="text-truncate text-body" style="min-width: 0;"><?php echo $value->name; ?></span>
					</a>
					</div> 
					<?php
					endwhile;  
					wp_reset_query(); 
					}
					?>
					 
					<?php 
					if ($subterms ) { ?>
					</div>                    
					 
                    <?php }} ?>
					</section>					
                    <?php } ?>
		 
 
		 
		
		<?php
		
		
	}

	public function update( $new_instance, $old_instance ){
		$instance		= $old_instance;
		$new_instance	= wp_parse_args(
			(array) $new_instance,
			array(
				'title'				=> '', 
				'show_image'		=> false, 
			)
		); 
		$instance['title']				= sanitize_text_field( $new_instance['title'] ); 
		$instance['show_image']	= (bool) $new_instance['show_image'];
		 
		return $instance;
	}

	public function form( $instance ){
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'title'			=> '', 
				'show_image'	=> true, 
			)
		);
		$title			= sanitize_text_field( $instance['title'] ); 
		$show_image		= (bool) $instance['show_image'];
		 
		?>
		<p class="info-notice danger"><?php _e( 'Home by Popular post', THEMES_NAMES ); ?> </p>
		<hr />
		<p>
			<label for="<?php echo esc_html( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title:', THEMES_NAMES ); ?></label>
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<hr /> 
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $show_image ); ?> id="<?php echo esc_html( $this->get_field_id( 'show_image' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'show_image' ) ); ?>" /><label for="<?php echo esc_html( $this->get_field_id( 'show_image' ) ); ?>"><?php _e( 'Show image ?', THEMES_NAMES ); ?></label>
		</p> 
        
		<?php
	}
	 
	
}
add_action(	'widgets_init',	function(){	register_widget( 'list_all_cats' );	});
