<?php
/*-----------------------------------------------------------------------------------*/
/*  Select Categorie Home widget
/*-----------------------------------------------------------------------------------*/ 
function selected_home_categorie_widgets() {
	/*
	https://wordpress.stackexchange.com/questions/310535/multiple-selection-for-wordpress-widget
	*/
    register_widget( 'selected_home_categories_widgets' );
}
add_action( 'widgets_init', 'selected_home_categorie_widgets' );

class selected_home_categories_widgets extends WP_Widget {

	function __construct() { 
	parent::__construct('selected_home_categories_widgets', __('(MDR) Category Selected  On Home', strtolower(THEMES_NAMES)), 
	array( 'description' => __( 'Selected Categorie On Home', strtolower(THEMES_NAMES) ), ) 
	);
	 
    }
 
	
	public function form( $instance ) {	
	$instance = wp_parse_args(
	(array) $instance,
	array(
	'title'	=> __( 'List Categorie', THEMES_NAMES ), 
	'title_button'	=> 'Show More',
	'title_link'	=> home_url( '/#your_link_categorie' ),  
	)
	);
	
    $title	= isset($instance[ 'title' ]) ? $instance[ 'title' ] : 'Categories';
    $instance['postCats']	= !empty($instance['postCats']) ? explode(",",$instance['postCats']) : array();
	$title_link	= $instance['title_link'];	 
	$title_button	= !empty( $instance['title_button'] ) ? $instance['title_button'] : ''; 
	
    ?>
	<p class="info-notice danger"><?php _e('Home Category by Selected', THEMES_NAMES); ?> </p>
	<hr />
    <p>
	<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title', THEMES_NAMES); ?></label>
	<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" style="width: 100%;" value="<?php echo $title; ?>"/>
    </p>
	<hr />
	<p>
	<label for="<?php echo $this->get_field_id( 'title_button' ); ?>"><?php _e('Button Title', THEMES_NAMES); ?></label>
	</p>
	<p>
	<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title_button' ); ?>" name="<?php echo $this->get_field_name( 'title_button' ); ?>" value="<?php echo esc_attr( $title_button ); ?>" />
	</p> 
	<hr />	
	<p>
	<label for="<?php echo esc_html( $this->get_field_id( 'title_link' ) ); ?>"><?php _e( 'Button Link Url:', THEMES_NAMES ); ?></label>
	</p>
	<p>
	<input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'title_link' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'title_link' ) ); ?>" type="text" value="<?php echo $title_link; ?>" />
	</p>
	<p>
	<?php _e('link url for button', THEMES_NAMES); ?> (example: <b><?php echo home_url( '/#your_link_categorie' ) ?></b> )
	</p>
	<p>
	<?php _e('leave blank if you dont want to show button', THEMES_NAMES); ?>
	</p>
	<hr />  
    <p>
	<label for="<?php echo $this->get_field_id( 'postCats' ); ?>"><?php _e( 'Select Categories you want to show:', THEMES_NAMES ); ?></label>
	<hr />
	<ul class="categorychecklist">
	
	<?php
	$args = array(
	'post_type'	=> 'post',
	'taxonomy'	=> 'category',
	);
	$terms = get_terms( $args ); 
	$i = 1;
	foreach( $terms as $id => $name ) { 
	$checked = "";
	if(in_array($name->name,$instance['postCats'])){
	$checked = "checked='checked'";
	}
	?>
	<li id="category-<?php echo $i; ?>">
	<label class="selectit">
	<input id="<?php echo $this->get_field_id('postCats'); ?>" name="<?php echo $this->get_field_name('postCats'); ?>[]" type="checkbox" value="<?php echo $name->name; ?>" <?php echo $checked; ?>><?php echo $name->name; ?>
	</label>
	</li>
	<?php $i++; } ?>
	</ul>
    </p>
	<hr /> 
    <?php

	}

	public function update( $new_instance, $old_instance ) {
	$instance	= $old_instance;
	$new_instance	= wp_parse_args(
	(array) $new_instance,
	array(
	'title'	=> '',
	'title_link'	=> '', 
	'title_button'	=> '', 
	)
	); 

    $instance[ 'title' ]	= strip_tags( $new_instance['title'] );
    $instance[ 'postCats' ]	= !empty($new_instance['postCats']) ? implode(",", $new_instance['postCats']) : 0;
	$instance[ 'title_link' ]	= $new_instance['title_link'];
	$instance[ 'title_button' ]	= $new_instance['title_button'];  
	 
    return $instance;
	}
 

	public function widget( $args, $instance ) {
    extract( $args );
	global $post, $opt_themes;
	$widget_id	= $this->id_base . '-' . $this->number;
	$before_widget	= '';
	$after_widget	= '';
    $title	= apply_filters( 'widget_title', $instance[ 'title' ] );
    $postCats	= $instance[ 'postCats' ];
    $categories_list	= explode(",", $postCats);	
	$more	= ( ! empty( $instance['more'] ) ) ? $instance['more'] : '';
	$link_title	= ( ! empty( $instance['link_title'] ) ) ? $instance['link_title'] : ''; 
	?> 
	<section class="mb-4"  id="<?php echo $widget_id; ?>">
	<header class="d-flex align-items-center mb-4">
	<h2 class="font-weight-bold mb-0">
	<a class="text-body" href="<?php echo $instance['title_link']; ?>"><?php echo $instance[ 'title' ]; ?></a>
	</h2>
	<?php if($instance['title_link']){ ?>
	<a class="btn btn-primary ml-auto" href="<?php echo $instance['title_link']; ?>"><?php echo $instance['title_button']; ?></a>
	<?php } ?>
	</header>
 
	<?php 
	$args		= array('post_type' => 'post','taxonomy' => 'category',);
	$terms		= get_terms( $args );
	?>
	<div class="row"> 
	<?php
	foreach ($categories_list as $cat) {
	foreach($terms as $term) {
	if($cat === $term->name) { ?>	
	<div class="col-4 col-md-3 col-lg-2 col-xl-2 mb-3">
	<a class="h6 font-weight-semibold text-truncate text-center text-body bg-white border rounded shadow-sm d-block p-2 mb-0" href="<?php echo get_term_link($term->slug, 'category'); ?>" title="<?php echo $term->name; ?>"><?php echo $term->name; ?></a>
	</div>
	<?php }
	}
	} 
	?> 
	</div>
	</section>  
    <?php
	}
}
 