<?php 

/*-----------------------------------------------------------------------------------*/
/*  Home Widget
/*-----------------------------------------------------------------------------------*/
class moddroid_homes_widget_ extends WP_Widget {
	
    public function __construct() {
        $widget_ops = array(
            'classname'   => 'moddroid-home-widgets',
            'description' => __( 'Post by Categories ', THEMES_NAMES ),
        );
        parent::__construct( 'moddroid-home-widgets', __( '(MDR) Category Post', THEMES_NAMES ), $widget_ops );
    }
    
    public function widget( $args, $instance ) {
		$widget_id			= $this->id_base . '-' . $this->number;
		$category_ids		= ( ! empty( $instance['category_ids'] ) ) ? array_map( 'absint', $instance['category_ids'] ) : array( 0 );
		$number_posts		= ( ! empty( $instance['number_posts'] ) ) ? absint( $instance['number_posts'] ) : absint( 5 ); 
		$link_title			= ( ! empty( $instance['link_title'] ) ) ? esc_url( $instance['link_title'] ) : '';
		$title_button		= ( ! empty( $instance['title_button'] ) ) ? $instance['title_button'] : '';
		$title				= apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		global $opt_themes;
		?> 

		<?php 
		switch($opt_themes['themes_styles']){
			case 'moddroid':
			?>
			<section class="mb-4" id="<?php echo $widget_id; ?>"> 
			<h2 class="h5 font-weight-semibold mb-3<?php if(!$instance['title_link']){ ?> border-bottom-2 border-secondary pb-1<?php } ?>">
			<?php if($instance['title_link']){ ?><a class="text-body border-bottom-2 border-secondary d-inline-block pb-1" href="<?php echo $instance['title_link']; ?>"><?php } ?><?php echo $title; ?><?php if($instance['title_link']){ ?></a><?php } ?>
			</h2>	
			<?php 
			break; 
			
			case 'modyolo':
			?>
			<section class="bg-white border rounded shadow-sm pt-3 px-2 px-md-3 mb-3" id="<?php echo $widget_id; ?>"> 
			<header class="d-flex align-items-end mb-3">
				<h2 class="h5 font-weight-semibold mb-0">
				<a class="text-body" href="<?php echo $instance['title_link']; ?>"><?php echo $title; ?></a>
				</h2>
				<?php if($instance['title_link']){?><a class="btn btn-primary btn-sm ml-auto" href="<?php echo $instance['title_link']; ?>"><?php echo $instance['title_button']; ?></a><?php } ?>
			</header>
			<?php 
			break; 
			
			case 'reborn':
			?>
			<section class="bg-white rounded pb-3 pt-3 px-2 px-md-3 mt-3 m-2" id="<?php echo $widget_id; ?>"> 
			<div class="d-flex align-items-baseline justify-content-between ">
			<h2 class="h5 font-weight-semibold m-0 p-0 mb-3 cate-title"><?php echo $title; ?></h2>
			<?php if($instance['title_button']){ ?><a class="small text-truncate text-muted pr-2 " href="<?php echo $instance['title_link']; ?>"><?php echo $instance['title_button']; ?></a><?php } ?>
			</div>
			<?php 
			break; 
			
			case 'liteapks':
			?>
			<section class="mb-4" id="<?php echo $widget_id; ?>">
			<header class="d-flex align-items-end mb-4">
			<h2 class="font-weight-bold mb-0">
			<a class="text-body" href="<?php echo $instance['title_link']; ?>"><?php echo $title; ?></a>
			</h2>
			<?php if($instance['title_button']){ ?><a class="btn btn-primary ml-auto" href="<?php echo $instance['title_link']; ?>"><?php echo $instance['title_button']; ?></a><?php } ?>
			</header>
			<?php 
			break; 
			
			default:
			?>
			<section class="mb-4" id="<?php echo $widget_id; ?>"> 		 
			<h2 class="h5 font-weight-semibold mb-3<?php if(!$instance['title_link']){ ?> border-bottom-2 border-secondary pb-1<?php } ?>">
			<?php if($instance['title_link']){ ?><a class="text-body border-bottom-2 border-secondary d-inline-block pb-1" href="<?php echo $instance['title_link']; ?>"><?php } ?><?php echo $title; ?><?php if($instance['title_link']){ ?></a><?php } ?>
			</h2>	
			<?php 
			break;
		} ?> 

 
		
		<?php 
		/* global $opt_themes;
		if($opt_themes['ex_themes_home_style_2_activate_']) { } else { echo $args['after_title']; } */
		
		if ( in_array( 0, $category_ids, true ) ) {
            $category_ids = array( 0 );
		}
		$args = array(
				'posts_per_page'			=> $number_posts,
				'post_type'					=> 'post',
				'no_found_rows'				=> true,
				'post_status'				=> 'publish', 
				'orderby'					=> $instance['orderby'],
				'update_post_term_cache'	=> false,
				'update_post_meta_cache'	=> false,
		);

		if ( ! in_array( 0, $category_ids, true ) ) {
			$args['category__in'] = $category_ids;
		} 
			
		if( $instance['orderby'] == 'views' ){
			$args = array(
				'posts_per_page'	=> $instance['number_posts'],
				'post_type'			=> 'post',
				'order'				=> 'DESC',
				'orderby'			=> 'meta_value_num',
				'meta_key'			=> 'post_views_count',
				'ignore_sticky_posts' => true
			);
		}

		if( $instance['orderby'] == 'rate' ){
			$args = array(
				'posts_per_page'	=> $instance['number_posts'],
				'post_type'			=> 'post',
				'meta_query' => array(
				'relation' => 'AND',
				'average_clause' => array(
					'key'     => 'rmp_avg_rating',
					'compare' => 'EXISTS',
				),
				'count_clause' => array(
					'key'     => 'rmp_vote_count',
					'compare' => 'EXISTS',
				),
				),
				'orderby'  => array(
					'average_clause' => 'DESC',
					'count_clause'   => 'DESC',
				),
				'ignore_sticky_posts' => true
			
			);
		}
		
		if( $instance['orderby'] == 'rategps' ){
			$args = array(
				'posts_per_page'	=> $instance['number_posts'],
				'post_type'			=> 'post',
				'meta_query' => array(
				'relation' => 'AND',
				'average_clause' => array(
					'key'     => 'wp_rated_GP',
					'compare' => 'EXISTS',
				),
				'count_clause' => array(
					'key'     => 'wp_ratings_GP',
					'compare' => 'EXISTS',
				),
				),
				'orderby'  => array(
					'average_clause' => 'DESC',
					'count_clause'   => 'DESC',
				),
				'ignore_sticky_posts' => true
			
			);
		}
		
		if( isset($instance['orderdate']) && $instance['orderdate'] != 'alltime' ){
				$year		= date('Y');
				$month		= absint( date('m') );
				$week		= absint( date('W') );
				
				$args['year']	= $year;

				if( $instance['orderdate'] == 'pastmonth' ){
					$args['monthnum'] = $month - 1;
				}
				if( $instance['orderdate'] == 'pastweek' ){
					$args['w'] = $week - 1;
				}
				if( $instance['orderdate'] == 'pastyear' ){
					unset( $args['year'] );
					$today = getdate();
					$args['date_query'] = array(
						array(
							'after' => $today[ 'month' ] . ' 1st, ' . ($today[ 'year' ] - 2)
						)
					);
				}
		}

		if( isset($instance['orderdate']) && $instance['orderdate'] == 'bydays' && isset($instance['days_amount']) ){
			$args['year'] = '';
			$days_amount = absint( $instance['days_amount'] ); 
			if( $days_amount > 0 ){
			$days_string = "-$days_amount days";
				$args['date_query'] = array(
					'after'		=> date('Y-m-d', strtotime( $days_string ) ),
					'inclusive'	=> true,
					'column'	=> 'post_date'
				);
			}
		}

        $rp = new WP_Query( apply_filters( 'moddroid_homes_widget__widget_posts_args', $args ) );
        ?>
		<div class="row">
            <?php
			while ( $rp->have_posts() ) :
			$rp->the_post(); 
			switch($opt_themes['themes_styles']){
				case 'moddroid':
				get_template_part('loop/item.mdr'); 
				break; 
				
				case 'modyolo':
				get_template_part('loop/item.mdy'); 
				break; 
				
				case 'reborn':
				get_template_part('loop/item.reborn'); 
				break; 
				
				case 'liteapks':
				get_template_part('loop/item.liteapks'); 
				break; 
				
				default:
				get_template_part('loop/item.mdr'); 
				break;
			}
			endwhile;
			wp_reset_postdata();
			?> 
 
		</div>  
			
			
			<?php 
		switch($opt_themes['themes_styles']){
			case 'moddroid':
			?>
			<a class="btn btn-light btn-block" href="<?php echo $instance['title_link']; ?>">
			<span class="align-middle"><?php echo $instance['title_button']; ?></span>
			<svg class="ml-1" height="16px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512">
				<path d="M24.707 38.101L4.908 57.899c-4.686 4.686-4.686 12.284 0 16.971L185.607 256 4.908 437.13c-4.686 4.686-4.686 12.284 0 16.971L24.707 473.9c4.686 4.686 12.284 4.686 16.971 0l209.414-209.414c4.686-4.686 4.686-12.284 0-16.971L41.678 38.101c-4.687-4.687-12.285-4.687-16.971 0z"></path>
			</svg>
			</a>
			<?php 
			break; 
			
			case 'modyolo':
			?>
			 
			<?php 
			break; 
			
			case 'reborn':
			?>
			<?php 
			break; 
			
			case 'liteapks':
			?>
			 
			<?php 
			break; 
			
			default:
			?>
			<a class="btn btn-light btn-block" href="<?php echo $instance['title_link']; ?>">
			<span class="align-middle"><?php echo $instance['title_button']; ?></span>
			<svg class="ml-1" height="16px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512">
				<path d="M24.707 38.101L4.908 57.899c-4.686 4.686-4.686 12.284 0 16.971L185.607 256 4.908 437.13c-4.686 4.686-4.686 12.284 0 16.971L24.707 473.9c4.686 4.686 12.284 4.686 16.971 0l209.414-209.414c4.686-4.686 4.686-12.284 0-16.971L41.678 38.101c-4.687-4.687-12.285-4.687-16.971 0z"></path>
			</svg>
			</a>
			<?php 
			break;
		} ?> 
		
		</section>		
		
		<?php  
	}

	public function update( $new_instance, $old_instance ){
		$instance		= $old_instance;
		$new_instance	= wp_parse_args(
			(array) $new_instance,
			array(
				'title'				=> '',
				'title_button'		=> '',
				'title_link'		=> '',
				'category_ids'		=> array( 0 ),
				'number_posts'		=> 3,  
				'orderby'			=> 'date',
				'orderdate'			=> 'alltime',
				'days_amount'		=> 30,
				'rate'				=> 'none',				
				'show_mod'			=> false,
				'show_version'		=> false,
				'show_count_rate'	=> false,
			)
		); 
		$instance['title']				= sanitize_text_field( $new_instance['title'] );
		$instance['title_button']		= sanitize_text_field( $new_instance['title_button'] );
		$instance['title_link']			= esc_url( $new_instance['title_link'] );
		$instance['category_ids']		= array_map( 'absint', $new_instance['category_ids'] );
		$instance['number_posts']		= absint( $new_instance['number_posts'] );
		$instance['orderby']			= $new_instance['orderby'];
		$instance['orderdate']			= $new_instance['orderdate'];
		$instance['days_amount']		= (int) $new_instance['days_amount'];
		$instance['rate']				= $new_instance['rate'];
		$instance['show_mod']			= (bool) $new_instance['show_mod'];
		$instance['show_version']		= (bool) $new_instance['show_version'];
		$instance['show_count_rate']	= (bool) $new_instance['show_count_rate'];
		
		if( in_array( 0, $instance['category_ids'], true ) ){
			$instance['category_ids'] = array( 0 );
		}
		return $instance;
	}

	public function form( $instance ){
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'title'				=> __( 'Post by Categorie', THEMES_NAMES ),
				'title_button'		=> __( 'Get More...', THEMES_NAMES ),
				'title_link'		=> home_url( '/your_link_categorie' ),
				'category_ids'		=> array( 0 ),
				'number_posts'		=> 3,  
				'orderby'			=> 'date',
				'orderdate'			=> 'alltime',
				'days_amount'		=> 30,
				'rate'				=> 'none',
				'show_mod'			=> true, 
				'show_version'		=> true,  
				'show_count_rate'	=> true, 
			)
		);
		$title						= sanitize_text_field( $instance['title'] );
		$title_button				= sanitize_text_field( $instance['title_button'] );
		$title_link					= $instance['title_link'];
		$category_ids				= array_map( 'absint', $instance['category_ids'] );
		$number_posts				= absint( $instance['number_posts'] );	
		$days_amount				= isset( $instance['days_amount'] ) ? absint( $instance['days_amount'] ) : 30;
		$show_mod					= (bool) $instance['show_mod'];
		$show_version				= (bool) $instance['show_version'];
		$show_count_rate			= (bool) $instance['show_count_rate'];
 
		$categories					= get_categories(
			array(
				'hide_empty'		=> 0,
				'hierarchical'		=> 1,
			)
		);
		$number_of_cats				= count( $categories );
		$number_of_rows				= ( 10 > $number_of_cats ) ? $number_of_cats + 1 : 10;
		if( in_array( 0, $category_ids, true ) ){
			$category_ids			= array( 0 );
		}
		$selection_category			= sprintf(
			'<select name="%s[]" id="%s" class="cat-select widefat" multiple size="%d">',
			$this->get_field_name( 'category_ids' ),
			$this->get_field_id( 'category_ids' ),
			$number_of_rows
		);
		$selection_category .= "\n";

		$cat_list = array();
		if( 0 < $number_of_cats ){
			while( $categories ){
				if( 0 === $categories[0]->parent ){
					$current_entry = array_shift( $categories );
					$cat_list[] = array(
						'id'		=> absint( $current_entry->term_id ),
						'name'		=> esc_html( $current_entry->name ),
						'depth'		=> 0,
					);
					continue;
				}
				
				$parent_index = $this->get_cat_parent_index( $cat_list, $categories[0]->parent );
				if( false === $parent_index ){
					$current_entry = array_shift( $categories );
					$categories[] = $current_entry;
					continue;
				}

				$depth = $cat_list[ $parent_index ]['depth'] + 1;
				$new_index = $parent_index + 1;
				foreach( $cat_list as $entry ){
					if( $depth <= $entry['depth'] ){
						$new_index = $new_index++;
						continue;
					}

					$current_entry = array_shift( $categories );
					$end_array  = array_splice( $cat_list, $new_index );
					$cat_list[] = array(
						'id'    => absint( $current_entry->term_id ),
						'name'  => esc_html( $current_entry->name ),
						'depth' => $depth,
					);
					$cat_list   = array_merge( $cat_list, $end_array );
					break;
				} 
			} 

			$selected            = ( in_array( 0, $category_ids, true ) ) ? ' selected="selected"' : '';
			$selection_category .= "\t";
			$selection_category .= '<option value="0"' . $selected . '>' . __( 'All Categories', THEMES_NAMES ) . '</option>';
			$selection_category .= "\n";
			foreach( $cat_list as $category ){
				$cat_name            = apply_filters( 'gmr_list_cats', $category['name'], $category );
				$pad                 = ( 0 < $category['depth'] ) ? str_repeat( '&ndash;&nbsp;', $category['depth'] ) : '';
				$selection_category .= "\t";
				$selection_category .= '<option value="' . $category['id'] . '"';
				$selection_category .= ( in_array( $category['id'], $category_ids, true ) ) ? ' selected="selected"' : '';
				$selection_category .= '>' . $pad . $cat_name . '</option>';
				$selection_category .= "\n";
			}
		}

		$selection_category .= "</select>\n";
        ?>
		<p class="info-notice danger"><?php _e('Home Category Post', THEMES_NAMES); ?> </p>
		<hr />
		<p>
			<label for="<?php echo esc_html( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title:', THEMES_NAMES ); ?></label>
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<hr />
		
		<p>
            <label for="<?php echo esc_html( $this->get_field_id( 'title_button' ) ); ?>"><?php _e( 'Button Title :', THEMES_NAMES ); ?></label>
            <input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'title_button' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'title_button' ) ); ?>" type="text" value="<?php echo esc_attr( $title_button ); ?>" />
        </p>
		<hr />
		
		<p >
			<label for="<?php echo esc_html( $this->get_field_id( 'title_link' ) ); ?>"><?php _e( 'Button Url:', THEMES_NAMES ); ?></label>
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'title_link' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'title_link' ) ); ?>" type="text" value="<?php echo esc_attr( $title_link ); ?>" />
			<br />
			<small><?php _e( 'Target url for title', THEMES_NAMES ); ?> (example: <?php echo home_url( '/' ); ?>), <?php _e( 'leave blank if you want using title without link.', THEMES_NAMES ); ?></small>
		</p>
		<hr />
		<p>
			<label for="<?php echo esc_html( $this->get_field_id( 'category_ids' ) ); ?>"><?php _e( 'Selected categories', THEMES_NAMES ); ?></label>
			<?php echo $selection_category;  ?>
			<br />
			<small><?php _e( 'Click on the categories with pressed CTRL key to select multiple categories. If All Categories was selected then other selections will be ignored.', THEMES_NAMES ); ?></small>
		</p>
		<hr />
		<p>
			<label for="<?php echo esc_html( $this->get_field_id( 'number_posts' ) ); ?>"><?php _e( 'Number post', THEMES_NAMES ); ?></label>
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'number_posts' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'number_posts' ) ); ?>" type="number" value="<?php echo esc_attr( $number_posts ); ?>" />
		</p>  
		<hr />
		<p>
			<label for="<?php echo $this->get_field_id('orderby'); ?>"><?php _e('Mode:', THEMES_NAMES) ?> </label>
			<select id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>">
			<option <?php if ($instance['orderby'] == 'date') echo 'selected="selected"'; ?> value="date"><?php _e('Recent Posts', THEMES_NAMES); ?></option>
			<option <?php if ($instance['orderby'] == 'rand') echo 'selected="selected"'; ?> value="rand"><?php _e('Random Posts', THEMES_NAMES); ?></option>
			<option <?php if ($instance['orderby'] == 'modified') echo 'selected="selected"'; ?> value="modified"><?php _e('Recent Modified Post', THEMES_NAMES); ?></option>
			<option <?php if ($instance['orderby'] == 'views') echo 'selected="selected"'; ?> value="views"><?php _e('Post views', THEMES_NAMES); ?></option>			
			<option <?php if ($instance['orderby'] == 'rate') echo 'selected="selected"'; ?> value="rate"><?php _e('Post Rate by User (Just Working For Reborns Styles)', THEMES_NAMES); ?></option>
			<option <?php if ($instance['orderby'] == 'rategps') echo 'selected="selected"'; ?> value="rategps"><?php _e('Post Rate by Play Store (Just Working For Reborns Styles)', THEMES_NAMES); ?></option>
			</select>
		</p>
		<hr />
		<div class="mdn-select-day">
		<p>
			<label for="<?php echo $this->get_field_id('orderdate'); ?>"><?php _e('Date:', THEMES_NAMES) ?> </label>
				<select id="<?php echo $this->get_field_id('orderdate'); ?>" name="<?php echo $this->get_field_name('orderdate'); ?>">
				<option <?php if ($instance['orderdate'] == 'alltime') echo 'selected="selected"'; ?> value="alltime"><?php _e('All Time', THEMES_NAMES); ?></option>
				<option <?php if ($instance['orderdate'] == 'pastyear') echo 'selected="selected"'; ?> value="pastyear"><?php _e('Past Year', THEMES_NAMES); ?></option>
				<option <?php if ($instance['orderdate'] == 'pastmonth') echo 'selected="selected"'; ?> value="pastmonth"><?php _e('Past Month', THEMES_NAMES); ?></option>
				<option <?php if ($instance['orderdate'] == 'pastweek') echo 'selected="selected"'; ?> value="pastweek"><?php _e('Past Week', THEMES_NAMES); ?></option>
				<option <?php if ($instance['orderdate'] == 'bydays') echo 'selected="selected"'; ?> value="bydays"><?php _e('Last "X" days', THEMES_NAMES); ?></option>
				</select>
		</p>
		<p class="mdn-days <?php echo $this->get_field_id('orderdate'); ?> <?php if ($instance['orderdate'] != 'bydays') echo 'hidden'; ?>">
			<label for="<?php echo $this->get_field_id('days_amount'); ?>"><?php _e( 'Number of last days to filter:', THEMES_NAMES); ?></label>
			<input id="<?php echo $this->get_field_id('days_amount'); ?>" name="<?php echo $this->get_field_name('days_amount'); ?>" type="text" value="<?php echo $days_amount; ?>" size="1" />
		</p>
		</div>
		<hr />
		<p style="display:none">
			<label for="<?php echo $this->get_field_id('rate'); ?>"><?php _e('Show Rate:', THEMES_NAMES) ?> </label>
			<select id="<?php echo $this->get_field_id('rate'); ?>" name="<?php echo $this->get_field_name('rate'); ?>">
			<option <?php if ($instance['rate'] == 'none') echo 'selected="selected"'; ?> value="none"><?php _e('disable', THEMES_NAMES); ?></option>
			<option <?php if ($instance['rate'] == 'rate') echo 'selected="selected"'; ?> value="rate"><?php _e('Rate by user', THEMES_NAMES); ?></option> 
			<option <?php if ($instance['rate'] == 'rate_gp') echo 'selected="selected"'; ?> value="rate_gp"><?php _e('Rate by PlayStore', THEMES_NAMES); ?></option> 
			</select>
		</p>
		<p style="display:none"> <?php _e('Just Working For Reborns Styles', THEMES_NAMES); ?> </p>
		<hr  style="display:none" />		
		<p style="display:none">
			<input class="checkbox" type="checkbox" <?php checked( $show_mod ); ?> id="<?php echo esc_html( $this->get_field_id( 'show_mod' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'show_mod' ) ); ?>" /><label for="<?php echo esc_html( $this->get_field_id( 'show_mod' ) ); ?>"><?php _e('Show Mod ?', THEMES_NAMES ); ?></label>
		</p>
		<p style="display:none"> <?php _e('Just Working For Reborns Styles', THEMES_NAMES ); ?> </p>
		<hr  style="display:none"/>
		<p style="display:none">
			<input class="checkbox" type="checkbox" <?php checked( $show_version ); ?> id="<?php echo esc_html( $this->get_field_id( 'show_version' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'show_version' ) ); ?>" /><label for="<?php echo esc_html( $this->get_field_id( 'show_version' ) ); ?>"><?php _e( 'Show Version ?', THEMES_NAMES ); ?></label>
		</p>
		<p style="display:none"> <?php _e('Just Working For Reborns Styles', THEMES_NAMES ); ?> </p>
		<hr  style="display:none"/>		
		<p style="display:none">
			<input class="checkbox" type="checkbox" <?php checked( $show_count_rate ); ?> id="<?php echo esc_html( $this->get_field_id( 'show_count_rate' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'show_count_rate' ) ); ?>" /><label for="<?php echo esc_html( $this->get_field_id( 'show_count_rate' ) ); ?>"><?php _e( 'Show Count Rate ?', THEMES_NAMES ); ?></label>
		</p>
		<p style="display:none"> <?php _e('Just Working For Reborns Styles', THEMES_NAMES ); ?> </p>
		<hr  style="display:none">
		
		<script>
			(function($){
			$(document).ready(function(){
				$('.mdn-select-day').each(function(){
					var container = $(this);
					container.find('select').on('change', function(){
						var value = $(this).val();
						if( value == 'bydays' ){
							container.find('.mdn-days').show();
						}else{
							container.find('.mdn-days').hide();
						}
					});
				});
			});
		})(jQuery);
		</script>
        
        <?php
    }
 
    private function get_cat_parent_index( $arr, $id ) {
        $len = count( $arr );
        if ( 0 === $len ) {
            return false;
        }
        $id = absint( $id );
        for ( $i = 0; $i < $len; $i++ ) {
            if ( $id === $arr[ $i ]['id'] ) {
                return $i;
            }
        }
        return false;
    }
     
    
}
add_action('widgets_init', function() { register_widget( 'moddroid_homes_widget_' ); } );

