<?php

/*-----------------------------------------------------------------------------------*/
/*  Popular Home View Most widget
/*-----------------------------------------------------------------------------------*/
class sidebar_related extends WP_Widget {

	public function __construct(){
		$widget_ops = array(
			'classname'   => 'sidebar-related',
			'description' => __( THEMES_NAMES.' Sidebar Related Post Widget for Single', THEMES_NAMES ),
		);
		parent::__construct( 'sidebar-related', __( '(MDR) Sidebar Related Post', THEMES_NAMES ), $widget_ops );
	}
	
	public function widget( $args, $instance ){
		$widget_id			= $this->id_base . '-' . $this->number; 
		global $opt_themes;
				
		/*
		https://codeless.co/wordpress-related-posts-without-plugin/
		*/ 
		  $terms			= get_the_terms( get_the_ID(), 'category' );
		  if ( empty( $terms ) ) $terms = array();
		  $term_list		= wp_list_pluck( $terms, 'slug' );
		  $related_args		= array(
			'post_type'			=> 'post',
			'posts_per_page'	=> $instance['number_posts'],
			'post_status'		=> 'publish',
			'post__not_in'		=> array( get_the_ID() ),
			'orderby'			=> $instance['orderby'],
			'tax_query'			=> array(
			  array(
				'taxonomy'		=> 'category',
				'field'			=> 'slug',
				'terms'			=> $term_list
			  )
			)
		  );
		  
		if( $instance['orderby'] == 'views' ){
			$related_args = array(
			'post_type'			=> 'post',
			'posts_per_page'	=> $instance['number_posts'],
			'post_status'		=> 'publish',
			'post__not_in'		=> array( get_the_ID() ),
			'order'				=> 'DESC',
			'orderby'			=> 'meta_value_num',
			'meta_key'			=> 'post_views_count',
			'tax_query'			=> array(
			  array(
				'taxonomy'		=> 'category',
				'field'			=> 'slug',
				'terms'			=> $term_list
			  )
			) 
			);
		}
		 

		$categorys		= get_the_terms( get_the_ID(), 'category' );  
		
		$rp = new WP_Query( apply_filters( 'related_post_sidebar_widget_posts_args', $related_args ) );
		 
		
		global $cl_from_element;
		$cl_from_element['is_related'] = true;		 
		if ( $rp->have_posts() ) :  
		switch($opt_themes['themes_styles']){
			case 'moddroid':
			?>
			<section class="mb-2"> 
			<h2 class="h5 font-weight-semibold mb-3 text-body border-bottom-2 border-secondary d-inline-block pb-1"><?php if($instance['show_cats_name']){ ?><?php echo $categorys[0]->name; ?> - <?php } ?><?php echo $instance['title']; ?> </h2> 
			<?php 
			break; 
			
			case 'modyolo':
			?>
			<section class="bg-white border rounded shadow-sm pt-3 px-2 px-md-3 mb-3">
			<header class="d-flex align-items-end mb-3">
			<h2 class="h5 font-weight-semibold mb-0"> 
			<?php echo $instance['title']; ?>	 
			</h2> 
			</header>
			<?php 
			break; 
			
			case 'reborn':
			?> 
			<section class="bg-white rounded pb-3 pt-3 px-2 mb-4 ">
			
			<div class="d-flex align-items-baseline justify-content-between ">
			<h2 class="h5 font-weight-semibold m-0 p-0 mb-3 "><?php echo $instance['title']; ?> </h2> 
			</div>
			<?php 
			break; 
			
			case 'liteapks':
			?> 
			<section class="mb-4">
			<h4 class="h4 font-weight-bold mb-3"><?php if($instance['show_cats_name']){ ?><?php echo $categorys[0]->name; ?> - <?php } ?><?php echo $instance['title']; ?></h4> 
			<?php 
			break; 
			
			default:
			?>
			<section class="mb-2">
			<h2 class="h5 font-weight-semibold mb-3 text-body border-bottom-2 border-secondary d-inline-block pb-1"><?php echo $instance['title']; ?></h2> 
			<?php 
			break;
		} ?>  
		
		<?php $i = 0;
        while ( $rp->have_posts() ) : $rp->the_post();
       
		global $wpdb, $post, $opt_themes; 
			$sizes					=	get_post_meta( $post->ID, 'wp_sizes', true ); 
			$sizes_alt				=	get_post_meta( $post->ID, 'wp_sizes_GP', true );
			if ( $sizes === FALSE or $sizes == '' ) $sizes = $sizes_alt; 
		 
		switch($opt_themes['themes_styles']){
			case 'moddroid':
			?> 
			<div class="mb-4">
			<a class="d-flex position-relative archive-post" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
			<div class="flex-shrink-0 mr-2">
			<?php if($opt_themes['hotlink']) {?>
			<img width="65" height="65" src="<?php echo get_post_meta( $post->ID, 'wp_poster_GP', true ); ?>=s65" class="rounded " alt="<?php the_title(); ?>" >
			<?php } else { ?>
			<?php the_post_thumbnail('full', array('class' => ' rounded ')); ?>
			<?php } ?>
			</div>
			<div style="min-width: 0;">
			<h3 class="h5 font-size-body font-weight-normal text-body text-truncate w-100 mb-1"><?php if (get_post_meta( $post->ID, 'wp_title_GP', true )) { if($opt_themes['app_name_on']) { echo ucwords(get_post_meta( $post->ID, 'wp_title_GP', true )); } else { echo the_title(); } } else { echo the_title(); } ?></h3>
			<div class="small text-truncate text-muted d-flex align-items-center">
			 
			<svg class="svg-4 align-middle mr-1" fill="var(--color_svg)" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M8 256C8 119 119 8 256 8s248 111 248 248-111 248-248 248S8 393 8 256zm292 116V256h70.9c10.7 0 16.1-13 8.5-20.5L264.5 121.2c-4.7-4.7-12.2-4.7-16.9 0l-115 114.3c-7.6 7.6-2.2 20.5 8.5 20.5H212v116c0 6.6 5.4 12 12 12h64c6.6 0 12-5.4 12-12z"></path></svg>
			<?php if (get_post_meta( $post->ID, 'wp_version', true )) { echo trim(get_post_meta( $post->ID, 'wp_version', true )); } else { echo trim(get_post_meta( $post->ID, 'wp_version_GP', true )); } ?>
			<span class="mx-1">·</span>
			<span class="text-truncate"><?php _e($opt_themes['exthemes_MODAPK'], TEXT_DOMAIN); ?>&nbsp;<?php echo trim(strip_tags(limit_words(get_post_meta( $post->ID, 'wp_mods', true ), '3'))) ?></span>
			</div>
			 
			</div>
			</a>
			</div>
			<?php
			break; 
			
			case 'modyolo':
			?>
			<div class=" mb-3">
			<a class="text-body border rounded overflow-hidden d-block h-100 position-relative archive-post" href="<?php the_permalink() ?>" title="<?php if (get_post_meta( $post->ID, 'wp_title_GP', true )) { if($opt_themes['app_name_on']) { echo ucwords(get_post_meta( $post->ID, 'wp_title_GP', true )); } else { echo the_title(); } } else { echo the_title(); } ?>">
			<div class="d-flex" style="padding: 0.5rem;">
			<div class="flex-shrink-0 mr-2" style="width: 3.75rem;">
			
			<?php if($opt_themes['hotlink']) {?>
			<img width="65" height="65" src="<?php echo get_post_meta( $post->ID, 'wp_poster_GP', true ); ?>=s65" class="rounded " alt="<?php the_title(); ?>" >
			<?php } else { ?>
			<?php the_post_thumbnail('full', array('class' => ' rounded ')); ?>
			<?php } ?>
			</div>
			<div style="min-width: 0;">
			<h3 class="h6 font-weight-semibold text-truncate w-100" style="margin-bottom: 2px;"><?php if (get_post_meta( $post->ID, 'wp_title_GP', true )) { if($opt_themes['app_name_on']) { echo ucwords(get_post_meta( $post->ID, 'wp_title_GP', true )); } else { echo the_title(); } } else { echo the_title(); } ?></h3>

			<div class="small text-truncate text-muted">
			<svg class="svg-6 svg-muted mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M567.938 243.908L462.25 85.374A48.003 48.003 0 0 0 422.311 64H153.689a48 48 0 0 0-39.938 21.374L8.062 243.908A47.994 47.994 0 0 0 0 270.533V400c0 26.51 21.49 48 48 48h480c26.51 0 48-21.49 48-48V270.533a47.994 47.994 0 0 0-8.062-26.625zM162.252 128h251.497l85.333 128H376l-32 64H232l-32-64H76.918l85.334-128z"></path></svg>
			<span class="align-middle"><?php if (get_post_meta( $post->ID, 'wp_version', true )) { echo trim(get_post_meta( $post->ID, 'wp_version', true )); } else { echo trim(get_post_meta( $post->ID, 'wp_version_GP', true )); } ?></span>
			<?php if( $sizes){?>
			<span class="align-middle"> + </span>
			<span class="align-middle"><?php echo $sizes; ?></span>
			<?php } ?>
			</div>
			
			<div class="small text-truncate text-muted">
			<svg class="svg-6 svg-muted mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M501.1 395.7L384 278.6c-23.1-23.1-57.6-27.6-85.4-13.9L192 158.1V96L64 0 0 64l96 128h62.1l106.6 106.6c-13.6 27.8-9.2 62.3 13.9 85.4l117.1 117.1c14.6 14.6 38.2 14.6 52.7 0l52.7-52.7c14.5-14.6 14.5-38.2 0-52.7zM331.7 225c28.3 0 54.9 11 74.9 31l19.4 19.4c15.8-6.9 30.8-16.5 43.8-29.5 37.1-37.1 49.7-89.3 37.9-136.7-2.2-9-13.5-12.1-20.1-5.5l-74.4 74.4-67.9-11.3L334 98.9l74.4-74.4c6.6-6.6 3.4-17.9-5.7-20.2-47.4-11.7-99.6.9-136.6 37.9-28.5 28.5-41.9 66.1-41.2 103.6l82.1 82.1c8.1-1.9 16.5-2.9 24.7-2.9zm-103.9 82l-56.7-56.7L18.7 402.8c-25 25-25 65.5 0 90.5s65.5 25 90.5 0l123.6-123.6c-7.6-19.9-9.9-41.6-5-62.7zM64 472c-13.2 0-24-10.8-24-24 0-13.3 10.7-24 24-24s24 10.7 24 24c0 13.2-10.7 24-24 24z"></path></svg>
			<span class="align-middle"> <?php _e($opt_themes['exthemes_MODAPK'], TEXT_DOMAIN); ?>&nbsp;<?php echo trim(strip_tags(get_post_meta( $post->ID, 'wp_mods', true ))) ?></span>
			</div>
			</div>
			</div>
			</a>
			</div>
			<?php
			break; 
			
			case 'reborn':
			?>
			<div class="mb-4">
			<a class="position-relative archive-post--remove app-container" href="<?php the_permalink() ?>" title="<?php if (get_post_meta( $post->ID, 'wp_title_GP', true )) { if($opt_themes['app_name_on']) { echo ucwords(get_post_meta( $post->ID, 'wp_title_GP', true )); } else { echo the_title(); } } else { echo the_title(); } ?>">
			<div class="flex-shrink-0">
			
			<?php if($opt_themes['hotlink']) {?>
			<img width="65" height="65" src="<?php echo get_post_meta( $post->ID, 'wp_poster_GP', true ); ?>=s65" class="app-logo " alt="<?php the_title(); ?>" >
			<?php } else { ?>
			<?php the_post_thumbnail('full', array('class' => ' app-logo ')); ?>
			<?php } ?>
			 
			</div>
			<div class="app-info">
			<h3 class="h5 font-weight-semibold w-100 app-title"><?php if (get_post_meta( $post->ID, 'wp_title_GP', true )) { if($opt_themes['app_name_on']) { echo ucwords(get_post_meta( $post->ID, 'wp_title_GP', true )); } else { echo the_title(); } } else { echo the_title(); } ?></h3>
			<div class="text-truncate text-muted app-desc">			
			<?php 
			if( $instance['show_mod']){ ?>
			<?php if(get_post_meta( $post->ID, 'wp_mods', true )) { ?>
			<span class="clamp-1 w-100"><?php echo trim(strip_tags(limit_words(get_post_meta( $post->ID, 'wp_mods', true ), '3'))) ?></span>
			<?php } else { ?><span class="clamp-1 w-100"> <?php echo $mod_gps_alt; ?></span><?php } ?>
			<?php } if( $instance['rate'] == 'none' ){
			} else if( $instance['rate'] == 'rate_gp' ){ ?>			
			<div class="Stars" style="--rating:<?php if($rate_GP){ echo $rate_GP; } else { ?>0<?php } ?>;" aria-label="Rating of this product is <?php if($rate_GP){ echo $rate_GP; } else { ?>0<?php } ?> out of 5">
			<?php if ($instance['show_count_rate']) { ?>
			<div class="rmp-results-widget__avg-rating"><span class="js-rmp-avg-rating"><?php echo $rate_GP; ?></span></div>
			<div class="rmp-results-widget__vote-count">(<span class="js-rmp-vote-count"><?php echo $ratings_GP; ?></span>)</div>
			<?php } ?>
			</div>			
			<?php } else if (shortcode_exists( 'ratemypost-result' )) { ?>
			<span class="byuser-sidebar pt-2 clamp-1 w-100"><?php echo do_shortcode( '[ratemypost-result]' ); ?> </span> 
			<?php } ?>
			</div>
			</div>
			<div class="app-get">
			<span class="get-button"><?php echo $opt_themes['mdr_text_get']; ?></span>
			<?php if($instance['show_version']){ ?><span class="app-version text-truncate"> <svg class="mr-1" xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" viewBox="0 0 16 16">
			<path fill-rule="evenodd" d="M1 8a7 7 0 1 0 14 0A7 7 0 0 0 1 8zm15 0A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-7.5 3.5a.5.5 0 0 1-1 0V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11.5z"></path>
			</svg> <?php if (get_post_meta( $post->ID, 'wp_version', true )) { echo trim(get_post_meta( $post->ID, 'wp_version', true )); } else { echo trim(get_post_meta( $post->ID, 'wp_version_GP', true )); } ?></span><?php } ?>
			</div>
			</a>
			</div>
			<?php
			break; 
			
			case 'liteapks':
			?> 
			<a class="text-body bg-white border rounded shadow-sm overflow-hidden d-block h-100 mb-3 position-relative archive-post" href="<?php the_permalink() ?>" title="<?php if (get_post_meta( $post->ID, 'wp_title_GP', true )) { if($opt_themes['app_name_on']) { echo ucwords(get_post_meta( $post->ID, 'wp_title_GP', true )); } else { echo the_title(); } } else { echo the_title(); } ?>">
			<div class="d-flex" style="padding: 0.75rem;">
			<div class="flex-shrink-0" style="width: 4rem; margin-right: 0.75rem;">
			
			<?php if($opt_themes['hotlink']) {?>
			<img width="65" height="65" src="<?php echo get_post_meta( $post->ID, 'wp_poster_GP', true ); ?>=s65" class="rounded " alt="<?php the_title(); ?>" >
			<?php } else { ?>
			<?php the_post_thumbnail('full', array('class' => ' rounded ')); ?>
			<?php } ?>
			</div>
			<div style="min-width: 0;">
			<h3 class="h6 font-weight-semibold text-truncate w-100 mb-1"><?php if (get_post_meta( $post->ID, 'wp_title_GP', true )) { if($opt_themes['app_name_on']) { echo ucwords(get_post_meta( $post->ID, 'wp_title_GP', true )); } else { echo the_title(); } } else { echo the_title(); } ?></h3>
			<div class="small text-truncate text-muted">
			<svg class="svg-6 svg-secondary mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M567.938 243.908L462.25 85.374A48.003 48.003 0 0 0 422.311 64H153.689a48 48 0 0 0-39.938 21.374L8.062 243.908A47.994 47.994 0 0 0 0 270.533V400c0 26.51 21.49 48 48 48h480c26.51 0 48-21.49 48-48V270.533a47.994 47.994 0 0 0-8.062-26.625zM162.252 128h251.497l85.333 128H376l-32 64H232l-32-64H76.918l85.334-128z"></path></svg>
			<span class="align-middle"><?php if (get_post_meta( $post->ID, 'wp_version', true )) { echo trim(get_post_meta( $post->ID, 'wp_version', true )); } else { echo trim(get_post_meta( $post->ID, 'wp_version_GP', true )); } ?></span>
			<?php if( $sizes){?>
			<span class="align-middle"> + </span>
			<span class="align-middle"><?php echo $sizes; ?></span>
			<?php } ?>
			</div>
			<div class="small text-truncate text-muted">
			<svg class="svg-6 svg-secondary mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M501.1 395.7L384 278.6c-23.1-23.1-57.6-27.6-85.4-13.9L192 158.1V96L64 0 0 64l96 128h62.1l106.6 106.6c-13.6 27.8-9.2 62.3 13.9 85.4l117.1 117.1c14.6 14.6 38.2 14.6 52.7 0l52.7-52.7c14.5-14.6 14.5-38.2 0-52.7zM331.7 225c28.3 0 54.9 11 74.9 31l19.4 19.4c15.8-6.9 30.8-16.5 43.8-29.5 37.1-37.1 49.7-89.3 37.9-136.7-2.2-9-13.5-12.1-20.1-5.5l-74.4 74.4-67.9-11.3L334 98.9l74.4-74.4c6.6-6.6 3.4-17.9-5.7-20.2-47.4-11.7-99.6.9-136.6 37.9-28.5 28.5-41.9 66.1-41.2 103.6l82.1 82.1c8.1-1.9 16.5-2.9 24.7-2.9zm-103.9 82l-56.7-56.7L18.7 402.8c-25 25-25 65.5 0 90.5s65.5 25 90.5 0l123.6-123.6c-7.6-19.9-9.9-41.6-5-62.7zM64 472c-13.2 0-24-10.8-24-24 0-13.3 10.7-24 24-24s24 10.7 24 24c0 13.2-10.7 24-24 24z"></path></svg>
			<span class="align-middle"> <?php _e($opt_themes['exthemes_MODAPK'], TEXT_DOMAIN); ?>&nbsp;<?php echo trim(strip_tags(get_post_meta( $post->ID, 'wp_mods', true ))) ?></span>
			</div>
			</div>
			</div>
			</a>
			
			<?php
			break;
			
			default:
			?>
			<div class="mb-4">
			<a class="d-flex position-relative archive-post" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
			<div class="flex-shrink-0 mr-2">
			<?php if($opt_themes['hotlink']) {?>
			<img width="65" height="65" src="<?php echo get_post_meta( $post->ID, 'wp_poster_GP', true ); ?>=s65" class="rounded " alt="<?php the_title(); ?>" >
			<?php } else { ?>
			<?php the_post_thumbnail('full', array('class' => ' rounded ')); ?>
			<?php } ?>
			</div>
			<div style="min-width: 0;">
			<h3 class="h5 font-size-body font-weight-normal text-body text-truncate w-100 mb-1"><?php if (get_post_meta( $post->ID, 'wp_title_GP', true )) { if($opt_themes['app_name_on']) { echo ucwords(get_post_meta( $post->ID, 'wp_title_GP', true )); } else { echo the_title(); } } else { echo the_title(); } ?></h3>
			<div class="small text-truncate text-muted d-flex align-items-center">
			 
			<svg class="svg-4 align-middle mr-1" fill="var(--color_svg)" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M8 256C8 119 119 8 256 8s248 111 248 248-111 248-248 248S8 393 8 256zm292 116V256h70.9c10.7 0 16.1-13 8.5-20.5L264.5 121.2c-4.7-4.7-12.2-4.7-16.9 0l-115 114.3c-7.6 7.6-2.2 20.5 8.5 20.5H212v116c0 6.6 5.4 12 12 12h64c6.6 0 12-5.4 12-12z"></path></svg>
			<?php if (get_post_meta( $post->ID, 'wp_version', true )) { echo trim(get_post_meta( $post->ID, 'wp_version', true )); } else { echo trim(get_post_meta( $post->ID, 'wp_version_GP', true )); } ?>
			<span class="mx-1">·</span>
			<span class="text-truncate"><?php _e($opt_themes['exthemes_MODAPK'], TEXT_DOMAIN); ?>&nbsp;<?php echo trim(strip_tags(limit_words(get_post_meta( $post->ID, 'wp_mods', true ), '3'))) ?></span>
			</div>
			 
			</div>
			</a>
			</div>
			<?php
			break;
		} ?> 
        <?php
          
		if( $i == 2 )
		break;
		endwhile;
		?>
 
		</section>
		<?php endif; 

		wp_reset_query();
		$cl_from_element['is_related'] = false;
		?>
		 
		 
		
		<?php
		  
	}

	public function update( $new_instance, $old_instance ){
		$instance		= $old_instance;
		$new_instance	= wp_parse_args(
			(array) $new_instance,
			array(
			'title'				=> '', 
			'number_posts'		=> 5,  
			'show_cats_name'	=> false, 
			'orderby'			=> 'date',
			)
		); 
		$instance['title']			= sanitize_text_field( $new_instance['title'] ); 
		$instance['number_posts']	= absint( $new_instance['number_posts'] ); 
		$instance['show_cats_name']	= (bool) $new_instance['show_cats_name'];
		$instance['orderby']		= $new_instance['orderby'];
		 
		return $instance;
	}

	public function form( $instance ){
		$instance = wp_parse_args(
			(array) $instance,
			array(
			'title'				=> __( 'Related', THEMES_NAMES ), 
			'number_posts'		=> 5,   
			'show_cats_name'	=> true,  
			'orderby'			=> 'date',
			)
		);
		$title					= sanitize_text_field( $instance['title'] ); 
		$number_posts			= absint( $instance['number_posts'] );	
		$show_cats_name			= (bool) $instance['show_cats_name']; 
		 
		?>
		<p class="info-notice danger"><?php _e( 'Sidebar Post by Related post', THEMES_NAMES ); ?> </p>
		<hr />
		<p>
			<label for="<?php echo esc_html( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title:', THEMES_NAMES ); ?></label>
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<hr />
		 
		<p>
			<label for="<?php echo esc_html( $this->get_field_id( 'number_posts' ) ); ?>"><?php _e( 'Number post', THEMES_NAMES ); ?></label>
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id( 'number_posts' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'number_posts' ) ); ?>" type="number" value="<?php echo esc_attr( $number_posts ); ?>" />
		</p> 
		<hr />	
		
		<p>
			<label for="<?php echo $this->get_field_id('orderby'); ?>"><?php _e('Mode:', THEMES_NAMES) ?> </label>
			<select id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>">
			<option <?php if ($instance['orderby'] == 'date') echo 'selected="selected"'; ?> value="date"><?php _e('Recent Posts', THEMES_NAMES); ?></option>
			<option <?php if ($instance['orderby'] == 'rand') echo 'selected="selected"'; ?> value="rand"><?php _e('Random Posts', THEMES_NAMES); ?></option>
			<option <?php if ($instance['orderby'] == 'modified') echo 'selected="selected"'; ?> value="modified"><?php _e('Recent Modified date', THEMES_NAMES); ?></option>
			<option <?php if ($instance['orderby'] == 'views') echo 'selected="selected"'; ?> value="views"><?php _e('Post views', THEMES_NAMES); ?></option>			
			 
			</select>
		</p>
		<hr />
		
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $show_cats_name ); ?> id="<?php echo esc_html( $this->get_field_id( 'show_cats_name' ) ); ?>" name="<?php echo esc_html( $this->get_field_name( 'show_cats_name' ) ); ?>" /><label for="<?php echo esc_html( $this->get_field_id( 'show_cats_name' ) ); ?>"><?php _e( 'Show Category Name ?', THEMES_NAMES ); ?></label>
		</p> 
		<?php
	}
	 
	
}
add_action(	'widgets_init',	function(){	register_widget( 'sidebar_related' );	});
