<?php
if(!class_exists('Bzotech_MegaItemController'))
{
    class Bzotech_MegaItemController{

        static function _init()
        {
            if(function_exists('bzotech_reg_post_type'))
            {
                add_action('init',array(__CLASS__,'_add_post_type'));
            }
        }

        static function _add_post_type()
        {
            $labels = array(
                'name'               => esc_html__('Mega Page','bw-monki'),
                'singular_name'      => esc_html__('Mega Page','bw-monki'),
                'menu_name'          => esc_html__('Mega Page','bw-monki'),
                'name_admin_bar'     => esc_html__('Mega Page','bw-monki'),
                'add_new'            => esc_html__('Add New','bw-monki'),
                'add_new_item'       => esc_html__( 'Add New Mega Page','bw-monki' ),
                'new_item'           => esc_html__( 'New Mega Page', 'bw-monki' ),
                'edit_item'          => esc_html__( 'Edit Mega Page', 'bw-monki' ),
                'view_item'          => esc_html__( 'View Mega Page', 'bw-monki' ),
                'all_items'          => esc_html__( 'All Mega Page', 'bw-monki' ),
                'search_items'       => esc_html__( 'Search Mega Page', 'bw-monki' ),
                'parent_item_colon'  => esc_html__( 'Parent Mega Page:', 'bw-monki' ),
                'not_found'          => esc_html__( 'No Mega Page found.', 'bw-monki' ),
                'not_found_in_trash' => esc_html__( 'No Mega Page found in Trash.', 'bw-monki' )
            );

            $args = array(
                'labels'             => $labels,
                'public'             => true,
                'publicly_queryable' => true,
                'show_ui'            => true,
                'show_in_menu'       => true,
                'query_var'          => true,
                'rewrite'            => array( 'slug' => 'bzotech_mega_item' ),
                'capability_type'    => 'post',
                'has_archive'        => true,
                'hierarchical'       => false,
                'menu_position'      => null,
                'menu_icon'          => get_template_directory_uri() . "/assets/admin/image/megamenu-icon.png",
                'supports'           => array( 'title', 'editor', 'revisions' )
            );

            bzotech_reg_post_type('bzotech_mega_item',$args);
        }
    }

    Bzotech_MegaItemController::_init();

}