<?php
    /**
     * ReduxFramework Barebones Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
    // Redux help function    
    if(!function_exists('bzotech_switch_redux_option')){
        function bzotech_switch_redux_option(){
            $bzotech_option_name = bzotech_get_option_name();
            // Basic Settings
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'Basic Settings', 'bw-monki' ),
                'id'               => 'basic',
                'icon'             => 'el el-home'
            ) );
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'General', 'bw-monki' ),
                'id'               => 'basic-general',
                'subsection'       => true,
                'fields'           => array(
                    
                    array(
                        'id'       => 'bzotech_header_page',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Header Page', 'bw-monki' ),
                        'desc'     => esc_html__( 'Select the header style. To edit/create header content, go to "Header Page" in Admin Dashboard. Note: this setting is applied for all pages; for single page setting, please go to each page to config.', 'bw-monki' ),
                        //Must provide key => value pairs for select options
                        'options'  => bzotech_list_post_type('bzotech_header'),
                        'default'  => ''
                    ),
                    array(
                        'id'       => 'bzotech_footer_page',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Footer Page', 'bw-monki' ),
                        'desc'     => esc_html__( 'Select the footer style. To edit/create footer content, go to "Footer Page" in Admin Dashboard. Note: this setting is applied for all pages; for single page setting, please go to each page to config."', 'bw-monki' ),
                        //Must provide key => value pairs for select options
                        'options'  => bzotech_list_post_type('bzotech_footer'),
                        'default'  => ''
                    ),
                    array(
                        'id'       => 'bzotech_show_breadrumb',
                        'type'     => 'switch',
                        'title'    => esc_html__( 'Breadcrumb', 'bw-monki' ),
                        'desc' => esc_html__( 'Show or hide the breadcrumb.', 'bw-monki' ),
                        'default'  => false,
                    ),
                    array(
                        'id'          => 'bzotech_bg_breadcrumb',
                        'type'        => 'media',
                        'title'       => esc_html__('Breadcrumb background image','bw-monki'),
                        'desc'        => 'Select image.',
                        'url'          => false,
                        'required'   =>  array(
                            array('bzotech_show_breadrumb','=','1'),
                            array('breadcrumb_page','=',''),
                        ), 
                    ),

                    array(
                        'id'       => 'breadcrumb_page',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Custom breadcrumb page', 'bw-monki' ),
                        'desc'     => esc_html__( 'Select the custom breadcrumb page.', 'bw-monki' ),
                        //Must provide key => value pairs for select options
                        'options'  => bzotech_list_post_type('bzotech_mega_item'),
                        'default'  => '',
                        'required'   =>  array('bzotech_show_breadrumb','=','1'),
                    ),

                    array(
                        'id'       => 'bzotech_404_page',
                        'type'     => 'select',
                        'title'    => esc_html__( '404 Page', 'bw-monki' ),
                        'desc'     => esc_html__( 'Select Mega Page inserts to the 404 page.', 'bw-monki' ),
                        //Must provide key => value pairs for select options
                        'options'  => bzotech_list_post_type('bzotech_mega_item'),
                        'default'  => ''
                    ),
                    array( 
                        'id'       => 'bzotech_404_page_style',
                        'type'     => 'select',
                        'title'    => esc_html__( '404 Style', 'bw-monki' ),
                        'desc'     => esc_html__( 'Choose a style to display.', 'bw-monki' ),
                        //Must provide key => value pairs for select options
                        'options'  => array(
                            ''           => esc_html__('Default','bw-monki'),
                            'full-width' => esc_html__('FullWidth','bw-monki'),
                        ),
                        'default'  => '',
                        'required' => array('bzotech_404_page','not','')
                    ),

                )
            ) );
            
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'Preload', 'bw-monki' ),
                'id'               => 'preload-general',
                'subsection'       => true,
                'fields'           => array(
                    array(
                        'id'       => 'show_preload',
                        'type'     => 'switch',
                        'title'    => esc_html__( 'Preload', 'bw-monki' ),
                        'desc'     => esc_html__( 'Turn on or off the preload option.', 'bw-monki' ),
                        'default'  => false,
                    ),
                    array(
                        'id'          => 'preload_bg',
                        'type'        => 'color_rgba',
                        'title'       => esc_html__('Background color','bw-monki'),
                        'desc'        => esc_html__( 'Select the default preload background color.', 'bw-monki' ),
                        'required'    => array('show_preload','=',true),
                    ),
                    array(
                        'id'          => 'preload_style',
                        'type'        => 'select',
                        'title'       => esc_html__('Preload style','bw-monki'),
                        'default'     => 'style2',
                        'options'     => array(
                            '' =>  esc_html__('Style 1','bw-monki'),
                            'style2' =>  esc_html__('Style 2','bw-monki'),
                            'style3' =>  esc_html__('Style 3','bw-monki'),
                            'style4' =>  esc_html__('Style 4','bw-monki'),
                            'style5' =>  esc_html__('Style 5','bw-monki'),
                            'style6' =>  esc_html__('Style 6','bw-monki'),
                            'style7' =>  esc_html__('Style 7','bw-monki'),
                            'custom-image' =>  esc_html__('Custom image','bw-monki'),
                        ),
                        'desc'        => esc_html__( 'Select the preload style.', 'bw-monki' ),
                        'required'    => array('show_preload','=',true),
                    ),
                    array(
                        'id'          => 'preload_image',
                        'type'        => 'media',
                        'title'       => esc_html__('Preload image','bw-monki'),
                        'desc'        => 'Select image.',
                        'url'          => false,
                        'required'   =>  array('preload_style','=','custom-image'),
                    ),
                )
            ) );
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'Other', 'bw-monki' ),
                'id'               => 'other-general',
                'subsection'       => true,
                'fields'           => array(
                    array(
                        'id'        => 'show_scroll_top',
                        'type'        => 'select',
                        'options'     => array(
                            '' =>  esc_html__('Off','bw-monki'),
                            '1' =>  esc_html__('Style 1','bw-monki'),
                            '2' =>  esc_html__('Style 2','bw-monki'),
                        ),
                        'title'     => esc_html__('Scroll to Top button', 'bw-monki'),
                        'desc'      => esc_html__('Show or hide scroll to top button.', 'bw-monki'),
                        'default'   => ''
                    ),
                    array(
                        'id'        => 'show_wishlist_notification',
                        'type'      => 'switch',
                        'title'     => esc_html__('Wislist notififcation', 'bw-monki'),
                        'desc'      => esc_html__('Show or hide notification after adding product to wishlist.', 'bw-monki'),
                        'default'   => false
                    ),
                    array(
                        'id'        => 'show_too_panel',
                        'type'      => 'switch',
                        'title'     => esc_html__('Tool panel', 'bw-monki'),
                        'desc'      => esc_html__('Show or hide sidebar tool panels.', 'bw-monki'),
                        'default'   => false
                    ),
                    array(
                        'id'          => 'tool_panel_page',
                        'type'        => 'select',
                        'title'       => esc_html__( 'Choose tool panel page', 'bw-monki' ),
                        'desc'        => esc_html__( 'Choose a mega page to display.', 'bw-monki' ),
                        'options'     => bzotech_list_post_type('bzotech_mega_item'),
                        'required'   =>  array('show_too_panel','=',true),
                    ),
                    array(
                        'id'          => 'after_append_footer',
                        'type'        => 'select',
                        'title'       => esc_html__( 'Append content after footer', 'bw-monki' ),
                        'desc'        => esc_html__( 'Choose a mega page content append to after main content of footer', 'bw-monki' ),
                        'options'     => bzotech_list_post_type('bzotech_mega_item'),
                    ),
                    array(
                        'id'          => 'body_bg',
                        'type'        => 'color_rgba',
                        'title'       => esc_html__('Body background color','bw-monki'),
                        'desc'        => esc_html__( 'Change the default body background color.', 'bw-monki' ),
                    ),
                    array(
                        'id'          => 'body_typo',
                        'type'        => 'typography',
                        'title'       => esc_html__('Body typography','bw-monki'),
                        'desc'        => esc_html__( 'Custom the body font.', 'bw-monki' ),
                    ),
                    array(
                        'id'          => 'title_typo',
                        'type'        => 'typography',
                        'title'       => esc_html__('Title typography','bw-monki'),
                        'desc'        => esc_html__( 'Custom font in Title.', 'bw-monki' ),
                        'font-weight'=>false,
                        'font-size'=>false,
                        'color'=>true,
                        'line-height'=>false,
                        'text-align'=>false,
                        'subsets'=>false,
                    ),
                    array(
                        'id'          => 'main_color',
                        'type'        => 'color_rgba',
                        'title'       => esc_html__('Main color','bw-monki'),
                        'desc'        => esc_html__( 'Change the website main color.', 'bw-monki' ),
                    ),
                    array(
                        'id'          => 'main_color2',
                        'type'        => 'color_rgba',
                        'title'       => esc_html__('Main color 2','bw-monki'),
                        'desc'        => esc_html__( 'Change main color 2 of your site.', 'bw-monki' ),
                    ),
                    array(
                        'id'          => 'bzotech_thumbnail_default',
                        'type'        => 'media',
                        'title'       => esc_html__('Thumbnail default','bw-monki'),
                        'desc'        => 'Select image default.',
                        'url'          => false,
                    ),
                    array(
                        'id'          => 'bzotech_page_style',
                        'type'        => 'select',
                        'title'       => esc_html__('Page Style','bw-monki'),
                        'default'     => '',
                        'options'     => array(
                            'page-content-df' =>  esc_html__('Default','bw-monki'),
                            'page-content-box' =>  esc_html__('Page boxed','bw-monki'),
                        ),
                        'desc'        => esc_html__( 'Select the default style for pages.', 'bw-monki' ),
                    ),
                    array(
                        'id'          => 'container_width',
                        'type'        => 'text',
                        'title'       => esc_html__('Custom container width (px)','bw-monki'),
                        'desc'        => esc_html__( 'Set width for the website container. Default is 1650px.', 'bw-monki' ),
                    ),
                     array(
                        'id'          => 'post_single_share',
                        'title'       => esc_html__('Show social share box','bw-monki'),
                        'type'        => 'checkbox',
                        'options'  => array(
                            'post' => esc_html__('Post','bw-monki'),
                            'page' => esc_html__('Page','bw-monki'),
                            'product' => esc_html__('Product','bw-monki'),
                        ),
                        'desc'        => esc_html__( 'Select to show social share box for post, page or product pages.', 'bw-monki' ),
                    ),
                    array(
                        'id'          => 'post_single_share_list',
                        'title'       => esc_html__('Custom social share box','bw-monki'),
                        'type'        => 'repeater',
                        'fields'    => array( 
                            array(
                                'id'       => 'title',
                                'type'     => 'text',
                                'title'    => esc_html__( 'Title', 'bw-monki' ),
                            ),
                            array(
                                'id'          => 'social',
                                'title'       => esc_html__('Social','bw-monki'),
                                'type'        => 'select',
                                'options'     => array(
                                    'total'    => esc_html__('Total share','bw-monki'),
                                    'facebook'  => esc_html__('Facebook','bw-monki'),
                                    'twitter' => esc_html__('Twitter','bw-monki'),
                                    'pinterest' => esc_html__('Pinterest','bw-monki'),
                                    'linkedin' => esc_html__('Linkedin','bw-monki'),
                                    'tumblr' => esc_html__('Tumblr','bw-monki'),
                                    'envelope' => esc_html__('Mail','bw-monki'),
                                ),
                                
                            ),
                            array(
                                'id'          => 'number',
                                'title'       => esc_html__('Show number','bw-monki'),
                                'type'        => 'switch',
                                'default'         => '0',
                            ),
                        ),
                    ),
                    
                    array(
                        'id'        => 'session_page',
                        'type'      => 'switch',
                        'title'     => esc_html__('Session option', 'bw-monki'),
                        'default'   => false
                    ),
                    
                    array(
                        'id'        => 'image_down_size',
                        'type'      => 'switch',
                        'title'     => esc_html__('Image down size', 'bw-monki'),
                        'default'   => true,
                        'desc'        => esc_html__( 'Enable this feature to crop images to the parameters you set everywhere. Note that after croppeing the images, you should turn it off to increase web speed', 'bw-monki' ),
                    ),
                )
            ) );
            // End Basic Settings
            // Layout Settings
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'Layout Settings', 'bw-monki' ),
                'id'               => 'layout',
                'icon'             => 'el el-indent-left',
                'fields'           => array(
                    array(
                        'id'          => 'bzotech_sidebar_position_page',
                        'type'        => 'select',
                        'title'       => esc_html__('Page sidebar position','bw-monki'),
                        'desc'        => esc_html__('Set the sidebar position for the website  pages.','bw-monki'),
                        'options'     => array(
                            'no'    => esc_html__('No Sidebar','bw-monki'),
                            'left'  => esc_html__('Left','bw-monki'),
                            'right' => esc_html__('Right','bw-monki'),
                        ),
                        'default'     => ''
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_page',
                        'type'        => 'select',
                        'title'       => esc_html__('Select Sidebar','bw-monki'),
                        'data'        => 'sidebars',
                        'required'    => array(
                            array('bzotech_sidebar_position_page','not','no'),
                            array('bzotech_sidebar_position_page','not',''),
                        ),
                        'desc'        => esc_html__('Select the sidebar to display for the website page.','bw-monki'),
                        'default'     => ''
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_style_page',
                        'type'        => 'select',
                        'title'       => esc_html__('Sidebar style','bw-monki'),
                        'desc'        => esc_html__('Select the sidebar style for the website page.','bw-monki'),
                        'options'     => array(
                            'default'    => esc_html__('Default','bw-monki'),
                            'style2'  => esc_html__('Style2','bw-monki'),
                        ),
                        'required'    => array(
                            array('bzotech_sidebar_position_page','not','no'),
                            array('bzotech_sidebar_position_page','not',''),
                        ), 
                        'default'     => 'default'
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_position_page_archive',
                        'type'        => 'select',
                        'title'       => esc_html__('Select archives page sidebar','bw-monki'),
                        'desc'        => esc_html__('Select the sidebar to display for the archives page.','bw-monki'),
                        'options'     => array(
                            'no'    => esc_html__('No Sidebar','bw-monki'),
                            'left'  => esc_html__('Left','bw-monki'),
                            'right' => esc_html__('Right','bw-monki'),
                        ),
                        'default'     => 'right'
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_page_archive',
                        'type'        => 'select',
                        'title'       => esc_html__('Select sidebar','bw-monki'),
                        'data'        => 'sidebars',
                        'required'    => array(
                            array('bzotech_sidebar_position_page_archive','not','no'),
                            array('bzotech_sidebar_position_page_archive','not',''),
                        ),
                        'desc'        => esc_html__('Select the sidebar to display for the archive page.','bw-monki'),
                        'default'     => 'blog-sidebar'
                    ),
                     array(
                        'id'          => 'bzotech_sidebar_style_archive',
                        'type'        => 'select',
                        'title'       => esc_html__('Sidebar style','bw-monki'),
                        'desc'        => esc_html__('Select the sidebar style for the archive page.','bw-monki'),
                        'options'     => array(
                            'default'    => esc_html__('Default','bw-monki'),
                            'style2'  => esc_html__('Style2','bw-monki'),
                        ),
                        'required'    => array(
                            array('bzotech_sidebar_position_page_archive','not','no'),
                            array('bzotech_sidebar_position_page_archive','not',''),
                        ), 
                        'default'     => 'default'
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_position_page_search',
                        'type'        => 'select',
                        'title'       => esc_html__('Search page sidebar position','bw-monki'),
                        'desc'        => esc_html__('Set the sidebar position for the search page.','bw-monki'),
                        'options'     => array(
                            'no'    => esc_html__('No Sidebar','bw-monki'),
                            'left'  => esc_html__('Left','bw-monki'),
                            'right' => esc_html__('Right','bw-monki'),
                        )
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_page_search',
                        'type'        => 'select',
                        'title'       => esc_html__('Select sidebar','bw-monki'),
                        'data'        => 'sidebars',
                        'required'    => array(
                            array('bzotech_sidebar_position_page_search','not','no'),
                            array('bzotech_sidebar_position_page_search','not',''),
                        ),
                        'desc'        => esc_html__('Select the sidebar to display for the search page.','bw-monki'),
                    ),    
                    array(
                        'id'          => 'bzotech_sidebar_style_search',
                        'type'        => 'select',
                        'title'       => esc_html__('Sidebar style','bw-monki'),
                        'desc'        => esc_html__('Select the sidebar style for the search page','bw-monki'),
                        'options'     => array(
                            'default'    => esc_html__('Default','bw-monki'),
                            'style2'  => esc_html__('Style2','bw-monki'),
                        ),
                        'required'    => array(
                            array('bzotech_sidebar_position_page_search','not','no'),
                            array('bzotech_sidebar_position_page_search','not',''),
                        ), 
                        'default'     => 'default'
                    ),          
                    array(
                        'id'          => 'bzotech_add_sidebar',
                        'title'       => esc_html__('Add SideBar','bw-monki'),
                        'type'        => 'repeater',
                        'default'     => '',
                        'fields'    => array( 
                            array(
                                'id'       => 'title',
                                'type'     => 'text',
                                'title'    => esc_html__( 'Title', 'bw-monki' ),
                            ),
                            array(
                                'id'          => 'widget_title_heading',
                                'type'        => 'select',
                                'title'       => esc_html__('Set widget heading style','bw-monki'),
                                'default'     => 'h3',
                                'options'     => array(
                                    'h1' => esc_html__('H1','bw-monki'),
                                    'h2' => esc_html__('H2','bw-monki'),
                                    'h3' => esc_html__('H3','bw-monki'),
                                    'h4' => esc_html__('H4','bw-monki'),
                                    'h5' => esc_html__('H5','bw-monki'),
                                    'h6' => esc_html__('H6','bw-monki'),
                                )
                            )
                            
                        ),
                    ),
                )
            ) );
            // End Layout Settings
 
         
            if(class_exists("woocommerce")){
                // Shop
                Redux::setSection( $bzotech_option_name, array(
                    'title'            => esc_html__( 'Shop', 'bw-monki' ),
                    'id'               => 'shop',
                    'icon'             => 'el el-shopping-cart'
                ) );
                Redux::setSection( $bzotech_option_name, array(
                    'title'            => esc_html__( 'General', 'bw-monki' ),
                    'id'               => 'general-shop',
                    'subsection'       => true,
                    'fields'           => array(
                       
                        array(
                            'id'          => 'bzotech_sidebar_position_woo',
                            'type'        => 'select',
                            'title'       => esc_html__('Sidebar position','bw-monki'),
                            'desc'        => esc_html__('Select the sidebar position for the WooCommerce pages (Shop, Checkout, Cart, My Account, Product category/tag/taxonomy page...). Left, Right, or No sidebar.','bw-monki'),
                            'options'     => array(
                                'no'    => esc_html__('No Sidebar','bw-monki'),
                                'left'  => esc_html__('Left','bw-monki'),
                                'right' => esc_html__('Right','bw-monki'),
                            ),
                            'default'  => 'right'
                        ),
                        array(
                            'id'          => 'bzotech_sidebar_woo',
                            'type'        => 'select',
                            'title'       => esc_html__('Select sidebar','bw-monki'),
                            'data'        => 'sidebars',
                            'required'    => array(
                                array('bzotech_sidebar_position_woo','not','no'),
                                array('bzotech_sidebar_position_woo','not',''),
                            ),
                            'desc'        => esc_html__('Select the sidebar to display for WooCommerce pages','bw-monki'),
                            'default'  => 'blog-sidebar'
                        ),
                        array(
                            'id'          => 'bzotech_sidebar_style_woo',
                            'type'        => 'select',
                            'title'       => esc_html__('Sidebar style','bw-monki'),
                            'desc'        => esc_html__('Select the sidebar style for the shop page','bw-monki'),
                            'options'     => array(
                                'default'    => esc_html__('Default','bw-monki'),
                                'style2'  => esc_html__('Style2','bw-monki'),
                            ),
                            'required'    => array(
                                array('bzotech_sidebar_position_woo','not','no'),
                                array('bzotech_sidebar_position_woo','not',''),
                            ), 
                            'default'     => 'default'
                        ),   
                        array(
                            'id'          => 'shop_default_style',
                            'type'        => 'select',
                            'title'       => esc_html__('Default style','bw-monki'),
                            'desc'=>esc_html__('Set the default style for the shop page: list view or grid view.','bw-monki'),
                            'options'     => array(                        
                                'grid'  => esc_html__('Grid','bw-monki'),
                                'list'  => esc_html__('List','bw-monki'),
                            ),
                            'default'  => 'grid'
                        ),
                        array(
                            'id'          => 'shop_gap_product',
                            'type'        => 'select',
                            'title'       => esc_html__('Gap products','bw-monki'),
                            'desc'=>esc_html__('Set the space between the items on the shop page.','bw-monki'),
                            'options'     => array(                        
                                ''          => esc_html__('Default','bw-monki'),
                                'gap-0'     => esc_html__('0','bw-monki'),
                                'gap-5'     => esc_html__('5px','bw-monki'),
                                'gap-10'    => esc_html__('10px','bw-monki'),
                                'gap-15'    => esc_html__('15px','bw-monki'),
                                'gap-20'    => esc_html__('20px','bw-monki'),
                                'gap-30'    => esc_html__('30px','bw-monki'),
                                'gap-40'    => esc_html__('40px','bw-monki'),
                                'gap-50'    => esc_html__('50px','bw-monki'),
                            ),
                        ),
                        array(
                            'id'          => 'woo_shop_number',
                            'type'        => 'slider',
                            'title'       => esc_html__('Product number','bw-monki'),
                            'min'         => 0,
                            'max'         => 999,
                            'step'        => 1,
                            'default'     => 12,
                            'desc'        => esc_html__('Set the number of product to display per page. Default is 12.','bw-monki')
                        ),
                        array(
                            'id'          => 'sv_set_time_woo',
                            'type'        => 'slider',
                            'title'       => esc_html__('New product','bw-monki'),
                            'min'         => 0,
                            'max'         => 999,
                            'step'        => 1,
                            'default'     => 0,
                            'desc'        => esc_html__('Set time for new products. Unit is day. Default is 0.','bw-monki')
                        ),
                        array(
                            'id'          => 'shop_style',
                            'type'        => 'select',
                            'title'       => esc_html__('Shop pagination','bw-monki'),
                            'desc'=>esc_html__('Select the pagination style for the shop page.','bw-monki'),
                            'options'     => array(
                                ''          => esc_html__('Default','bw-monki'),
                                'load-more' => esc_html__('Load more','bw-monki'),
                            )
                        ),
                        array(
                            'id'          => 'shop_ajax',
                            'type'        => 'switch',
                            'title'       => esc_html__('Shop ajax','bw-monki'),
                            'default'     => false,
                            'desc'        => esc_html__('Enable or disable ajax process for the shop page.','bw-monki'),
                            'default'     => false
                        ),
                        array(
                            'id'          => 'shop_thumb_animation',
                            'type'        => 'select',
                            'title'       => esc_html__('Thumbnail animation','bw-monki'),
                            'desc'        => esc_html__('Set the animation for product thumnail.','bw-monki'),
                            'options'     => bzotech_get_product_thumb_animation()
                        ),
                        array(
                            'id'          => 'shop_number_filter',
                            'type'        => 'switch',
                            'title'       => esc_html__('Show number filter','bw-monki'),
                            'desc'        => esc_html__('Show or hide number filter on shop page.','bw-monki'),
                            'default'     => false,
                        ),
                        array(
                            'id'          => 'shop_number_filter_list',
                            'type'        => 'repeater',
                            'title'       => esc_html__('Add number list for filter','bw-monki'),
                            'desc'        => esc_html__('Add the number list to filter on the shop page.','bw-monki'),
                            'fields'      => array(
                                array(
                                    'id'          => 'number',
                                    'type'        => 'text',
                                    'title'       => esc_html__('Number','bw-monki'),
                                ),
                            ),
                            'required'   => array('shop_number_filter','not',false),
                            'default'  => ''
                        ),
                        array(
                            'id'          => 'shop_type_filter',
                            'type'        => 'switch',
                            'title'       => esc_html__('Show type filter','bw-monki'),
                            'desc'        => esc_html__('Show or hide type filter (list/grid) on the shop page.','bw-monki'),
                            'default'     => false,
                        ),
                        array(
                            'id'          => 'shop_order_filter',
                            'type'        => 'switch',
                            'title'       => esc_html__('Show order filter','bw-monki'),
                            'desc'        => esc_html__('Show or hide order filter on the shop page.','bw-monki'),
                            'default'     => false,
                        ),

                        array(
                            'id'          => 'shop_attribute_color',
                            'title'       => esc_html__('Show color attribute','bw-monki'),
                            'desc'        => esc_html__('Show or hide color attribute on the product list.','bw-monki'),
                            'type'        => 'switch',
                            'section'     => 'option_woo',
                            'default'     => false,
                        ),
                        array(
                            'id'          => 'show_quick_view',
                            'title'       => esc_html__('Quick view button','bw-monki'),
                            'type'        => 'switch',
                            'section'     => 'option_woo',
                            'default'     => false,
                        ),
                        array(
                            'id'          => 'quick_view_style',
                            'title'       => esc_html__('Quick view style','bw-monki'),
                            'type'        => 'select',
                            'section'     => 'option_woo',
                            'desc'        => esc_html__('Select the style for quickview.','bw-monki'),
                            'default'         => '',
                            'condition'   => 'show_quick_view:is(1)',
                            'options'     => array(
                                ''          => esc_html__('Default','bw-monki'),
                                'load-more' => esc_html__('Style 1 (default)','bw-monki'),
                            )
                        ),
                    )
                ) );
                
                Redux::setSection( $bzotech_option_name, array(
                    'title'            => esc_html__( 'List View Settings', 'bw-monki' ),
                    'id'               => 'list-shop',
                    'subsection'       => true,
                    'fields'           => array(
                        array(
                            'id'          => 'shop_list_size',
                            'type'        => 'text',
                            'title'       => esc_html__('Custom thumbnail size','bw-monki'),
                            'desc'        => esc_html__('Set the thumbnail size to crop in px. Format: [width]x[height]. For example 300x300.','bw-monki')
                        ),
                        array(
                            'id'          => 'shop_list_item_style',
                            'type'        => 'select',
                            'title'       => esc_html__('Item style','bw-monki'),
                            'desc'        => esc_html__('Select the item style.','bw-monki'),
                            'options'     => bzotech_get_product_list_style()
                        ),
                    )
                ) );

                Redux::setSection( $bzotech_option_name, array(
                    'title'            => esc_html__( 'Grid View Settings', 'bw-monki' ),
                    'id'               => 'grid-shop',
                    'subsection'       => true,
                    'fields'           => array(
                        array(
                            'id'          => 'shop_grid_column',
                            'type'        => 'select',
                            'title'       => esc_html__('Grid column','bw-monki'),
                            'default'     => '3',
                            'desc'        => esc_html__('Select the number of column to show.','bw-monki'),
                            'options'     => array(
                                '2'     => esc_html__('2 column','bw-monki'),
                                '3'     => esc_html__('3 column','bw-monki'),
                                '4'     => esc_html__('4 column','bw-monki'),
                                '5'     => esc_html__('5 column','bw-monki'),
                                '6'     => esc_html__('6 column','bw-monki'),
                                '7'     => esc_html__('7 column','bw-monki'),
                                '8'     => esc_html__('8 column','bw-monki'),
                                '9'     => esc_html__('9 column','bw-monki'),
                                '10'    => esc_html__('10 column','bw-monki'),
                            )
                        ),
                        array(
                            'id'          => 'shop_grid_size',
                            'type'        => 'text',
                            'title'       => esc_html__('Custom thumbnail size','bw-monki'),
                            'desc'        => esc_html__('Set the thumbnail size to crop in px. Format: [width]x[height]. For example 300x300.','bw-monki')
                        ),
                        array(
                            'id'          => 'shop_grid_item_style',
                            'type'        => 'select',
                            'title'       => esc_html__('Item style','bw-monki'),
                            'desc'        => esc_html__('Select the item style.','bw-monki'),
                            'options'     => bzotech_get_product_style()
                        ),
                        array(
                            'id'       => 'item_thumbnail',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Thumbnail', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the thumbnail.', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_quickview',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Quickview', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the quickview.', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_title',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Title', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the title.', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_rate',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Rate', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the rate.', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_button',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Button add to cart', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the button add to cart .', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_label',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Label', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the label (Label sale, label new...).', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_countdown',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Countdown price', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the countdown by reduced price.', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_brand',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Show Brand', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the Brand.', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_gallery_hover',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Show Gallery Images', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the Gallery Images.', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_flash_sale',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Flash Sale', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the Flash Sale bar.', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'       => 'item_attributes',
                            'type'     => 'select',
                            'title'    => esc_html__( 'Attributes of product data variable', 'bw-monki' ),
                            'desc' => esc_html__( 'Show or hide the Flash Sale bar.', 'bw-monki' ),
                            'default'  => '',
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'yes'  => esc_html__('Show','bw-monki'),
                                'no'  => esc_html__('Hide','bw-monki'),
                            )
                        ),
                        array(
                            'id'          => 'shop_grid_type',
                            'type'        => 'select',
                            'title'       => esc_html__('Grid display','bw-monki'),
                            'desc'        => esc_html__('Select the grid style.','bw-monki'),
                            'options'     => array(
                                ''              => esc_html__('Default','bw-monki'),
                                'grid-masonry'  => esc_html__('Masonry','bw-monki'),
                            )
                        ),
                    )
                ) );

                Redux::setSection( $bzotech_option_name, array(
                    'title'            => esc_html__( 'Advanced', 'bw-monki' ),
                    'id'               => 'advanced-shop',
                    'subsection'       => true,
                    'fields'           => array(
                        array(
                            'id'          => 'cart_page_style',
                            'type'        => 'select',
                            'title'       => esc_html__('Cart display','bw-monki'),
                            'desc'        => esc_html__('Select the cart style.','bw-monki'),
                            'options'     => array(
                                ''          => esc_html__('Default','bw-monki'),
                                'style2'    => esc_html__('Style 2','bw-monki'),
                            )
                        ),
                        array(
                            'id'          => 'checkout_page_style',
                            'type'        => 'select',
                            'title'       => esc_html__('Checkout display','bw-monki'),
                            'desc'        => esc_html__('Select the checkout style.','bw-monki'),
                            'options'     => array(
                                ''          => esc_html__('Default','bw-monki'),
                                'style2'    => esc_html__('Style 2','bw-monki'),
                            )
                        ),
                        array(
                            'id'          => 'bzotech_header_page_woo',
                            'type'        => 'select',
                            'title'       => esc_html__( 'WooCommerce page header', 'bw-monki' ),
                            'desc'        => esc_html__( 'Select the header style. To edit/create header content, go to Header Page in Admin Dashboard.
Note: this setting is applied for all pages; for single page setting, please go to each page to config.', 'bw-monki' ),
                            'options'     => bzotech_list_post_type('bzotech_header')
                        ),
                        array(
                            'id'          => 'bzotech_footer_page_woo',
                            'type'        => 'select',
                            'title'       => esc_html__( 'WooCommerce page footer', 'bw-monki' ),
                            'desc'        => esc_html__( 'Select the footer style. To edit/create footer content, go to Footer Page in Admin Dashboard.
Note: this setting is applied for all pages; for single page setting, please go to each page to config.', 'bw-monki' ),
                            'options'     => bzotech_list_post_type('bzotech_footer')
                        ),
                        array(
                            'id'          => 'before_append_woo',
                            'type'        => 'select',
                            'title'       => esc_html__('Append content before WooCommerce page','bw-monki'),
                            'options'     => bzotech_list_post_type('bzotech_mega_item'),
                            'desc'        => esc_html__('Choose a mega page content append to before main content of page/post.','bw-monki'),
                        ),
                        array(
                            'id'          => 'after_append_woo',
                            'type'        => 'select',
                            'title'       => esc_html__('Append content after WooCommerce page','bw-monki'),
                            'options'     => bzotech_list_post_type('bzotech_mega_item'),
                            'desc'        => esc_html__('Choose a mega page content append to after main content of page/post.','bw-monki'),
                        ),
                        array(
                            'id'          => 'brand_woo',
                            'type'        => 'switch',
                            'title'       => esc_html__('Shop brand','bw-monki'),
                            'desc'        => esc_html__('Enable or disable brand function.','bw-monki'),
                            'default'     => 'false'
                        ),
                    )
                ) );
                // End Shop

                // Product
                Redux::setSection( $bzotech_option_name, array(
                    'title'            => esc_html__( 'Product', 'bw-monki' ),
                    'id'               => 'product',
                    'icon'             => 'el el-briefcase'
                ) );
                Redux::setSection( $bzotech_option_name, array(
                    'title'            => esc_html__( 'General', 'bw-monki' ),
                    'id'               => 'general-product',
                    'subsection'       => true,
                    'fields'           => array(
                    array(
                        'id'          => 'sv_style_woo_single',
                        'title'       => esc_html__('Product detail style','bw-monki'),
                        'type'        => 'select',
                        'section'     => 'option_product',
                        'default'         => 'style-gallery-horizontal',
                        'desc'        => esc_html__('Select style for the product detail.','bw-monki'),
                        'options'     => array(
                                'style-gallery-horizontal'=> esc_html__('Style 1 (Gallery horizontal )','bw-monki'),
                                'style-gallery-vertical' => esc_html__('Style 2 (Gallery vertical)','bw-monki'),
                                'sticky-style1' => esc_html__('Style 3 (Gallery sticky)','bw-monki'),
                                'sticky-style2' => esc_html__('Style 4 (Gallery sticky)','bw-monki'),
                                'sticky-style3' => esc_html__('Style 5 (Gallery sticky)','bw-monki'),
                                'style-gallery-horizontal2' => esc_html__('Style 6 (Gallery horizontal 2)','bw-monki'),
                                'style-gallery-vertical2' => esc_html__('Style 7 (Gallery vertical 2)','bw-monki'),
                            )
                        ),
                        array(
                            'id'          => 'sv_sidebar_position_woo_single',
                            'type'        => 'select',
                            'title'       => esc_html__('Sidebar position','bw-monki'),
                            'desc'        => esc_html__('Select the sidebar position for the single product page.','bw-monki'),
                            'default'         => 'no',
                            'options'     => array(
                                'no'    => esc_html__('No Sidebar','bw-monki'),
                                'left'  => esc_html__('Left','bw-monki'),
                                'right' => esc_html__('Right','bw-monki'),
                            ),
                        ),
                        array(
                            'id'          => 'sv_sidebar_woo_single',
                            'type'        => 'select',
                            'title'       => esc_html__('Select sidebar','bw-monki'),
                            'data'        => 'sidebars',
                            'required'    => array(
                                array('sv_sidebar_position_woo_single','not','no'),
                                array('sv_sidebar_position_woo_single','not',''),
                            ),
                            'desc'        => esc_html__('Select the sidebar for single product page.','bw-monki'),
                        ),
                        array(
                            'id'          => 'bzotech_sidebar_style_woo_single',
                            'type'        => 'select',
                            'title'       => esc_html__('Sidebar style','bw-monki'),
                            'desc'        => esc_html__('Select the sidebar style for the single product page.','bw-monki'),
                            'options'     => array(
                                'default'    => esc_html__('Default','bw-monki'),
                                'style2'  => esc_html__('Style2','bw-monki'),
                            ),
                            'required'    => array(
                                array('sv_sidebar_position_woo_single','not','no'),
                                array('sv_sidebar_position_woo_single','not',''),
                            ), 
                            'default'     => 'default'
                        ),  
                        array(
                            'id'          => 'product_image_zoom',
                            'type'        => 'select',
                            'title'       => esc_html__('Image zoom','bw-monki'),
                            'desc'        => esc_html__('Select the image zoom style.','bw-monki'),
                            'options'     => array(
                                ''              => esc_html__('None','bw-monki'),
                                'zoom-style1'   => esc_html__('Zoom 1','bw-monki'),
                                'zoom-style2'   => esc_html__('Zoom 2','bw-monki'),
                                'zoom-style3'   => esc_html__('Zoom 3','bw-monki'),
                                'zoom-style4'   => esc_html__('Zoom 4','bw-monki'),
                            )
                        ),
                        array(
                            'id'          => 'product_gallery_size',
                            'type'        => 'text',
                            'title'       => esc_html__('Custom gallery size','bw-monki'),
                            'desc'        => esc_html__('Set the gallery size to crop in px. Format: [width]x[height]. For example 300x300.','bw-monki')
                        ),
                        array(
                            'id'          => 'product_tab_detail',
                            'type'        => 'select',
                            'title'       => esc_html__('Product tab style','bw-monki'),
                            'desc'        => esc_html__('Select the product tab style.','bw-monki'),
                            'default'         => 'tab-product-accordion',
                            'options'     => array(
                                'tab-product-horizontal'=> esc_html__("Tab style horizontal", 'bw-monki'),
                                'tab-product-vertical'=> esc_html__("Tab style vertical", 'bw-monki'),
                                'tab-product-accordion'=> esc_html__("Tab style accordion", 'bw-monki'),
                            )
                        ),
                        array(
                            'id'          => 'show_excerpt',
                            'type'        => 'switch',
                            'title'       => esc_html__('Show excerpt','bw-monki'),
                            'default'     => true
                        ),
                    )
                ) );

                Redux::setSection( $bzotech_option_name, array(
                    'title'            => esc_html__( 'Extra Display', 'bw-monki' ),
                    'id'               => 'display-product',
                    'subsection'       => true,
                    'fields'           => array(
                       array(
                            'id'          => 'share_whatsapp',
                            'type'        => 'switch',
                            'title'       => esc_html__('Button share on WhatsApp','bw-monki'),
                            'default'     => false
                        ),
                       array(
                            'id'          => 'show_latest',
                            'type'        => 'switch',
                            'title'       => esc_html__('Show latest products','bw-monki'),
                            'default'     => false
                        ),
                        array(
                            'id'          => 'show_upsell',
                            'type'        => 'switch',
                            'title'       => esc_html__('Show upsell products','bw-monki'),
                            'default'     => false
                        ),
                        array(
                            'id'          => 'show_related',
                            'type'        => 'switch',
                            'title'       => esc_html__('Show related products','bw-monki'),
                            'section'     => 'option_product',
                            'default'     => false
                        ),
                        array(
                            'id'          => 'bzotech_product_sticky_addcart',
                            'type'        => 'switch',
                            'title'       => esc_html__('Sticky add to cart','bw-monki'),
                            'section'     => 'option_product',
                            'default'     => false
                        ),
                        array(
                            'id'          => 'show_single_number',
                            'type'        => 'slider',
                            'title'       => esc_html__('Show single number','bw-monki'),
                            'min'         => '1',
                            'max'         => '100',
                            'step'        => '1',
                            'default'     => '6'
                        ),
                        array(
                            'id'          => 'show_single_size',
                            'type'        => 'text',
                            'title'       => esc_html__('Show single size','bw-monki'),
                            'desc'        => esc_html__('Set the size for related, upsell products thumbnail. Format: [width]x[height]. For example 300x300.','bw-monki'),
                        ),
                        array(
                            'id'          => 'show_single_itemres',
                            'type'        => 'text',
                            'title'       => esc_html__('Custom item devices','bw-monki'),
                            'desc'        => esc_html__('Set the number of related, upsell products for different screen size in px. Format is width:value and separate by ",". Example is 0:2,600:3,1000:4. Default is auto.','bw-monki'),
                        ),
                        array(
                            'id'          => 'show_single_item_style',
                            'type'        => 'select',
                            'title'       => esc_html__('Single item style','bw-monki'),
                            'desc'        => esc_html__('Select the item style.','bw-monki'),
                            'options'     => bzotech_get_product_style()
                        ),
                    )
                ) );

                Redux::setSection( $bzotech_option_name, array(
                    'title'            => esc_html__( 'Advanced', 'bw-monki' ),
                    'id'               => 'advanced-product',
                    'subsection'       => true,
                    'fields'           => array(
                       array(
                            'id'          => 'before_append_woo_single',
                            'type'        => 'select',
                            'title'       => esc_html__('Append content before product page','bw-monki'),
                            'options'     => bzotech_list_post_type('bzotech_mega_item'),
                            'desc'        => esc_html__('Choose a mega page content append to before main content of page/post.','bw-monki'),
                        ),
                        array(
                            'id'          => 'before_append_tab',
                            'type'        => 'select',
                            'title'       => esc_html__('Append content before product tab','bw-monki'),
                            'options'     => bzotech_list_post_type('bzotech_mega_item'),
                            'desc'        => esc_html__('Choose a mega page content append to before product tab.','bw-monki'),
                        ),
                        array(
                            'id'          => 'after_append_tab',
                            'type'        => 'select',
                            'title'       => esc_html__('Append content after product tab','bw-monki'),
                            'options'     => bzotech_list_post_type('bzotech_mega_item'),
                            'desc'        => esc_html__('Choose a mega page content append to before product tab.','bw-monki'),
                        ),
                        array(
                            'id'          => 'after_append_woo_single',
                            'type'        => 'select',
                            'title'       => esc_html__('Append content after product page','bw-monki'),
                            'options'     => bzotech_list_post_type('bzotech_mega_item'),
                            'desc'        => esc_html__('Choose a mega page content append to after main content of page/post.','bw-monki'),
                        ),
                        array(
                            'id'          => 'append_content_summary',
                            'type'        => 'select',
                            'title'       => esc_html__('Append content in summary','bw-monki'),
                            'options'     => bzotech_list_post_type('bzotech_mega_item'),
                            'desc'        => esc_html__('Choose a mega page content append to after main content of product summary.','bw-monki'),
                        ),

                        array(
                            'id'          => 'content_summary_pos',
                            'type'        => 'slider',
                            'desc'        => esc_html__('Set a position for the content to be added to the product summary','bw-monki'),
                            'title'       => esc_html__('Set a position for the content to be added','bw-monki'),
                            'min'         => '1',
                            'max'         => '100',
                            'step'        => '1',
                            'default'     => '60',
                            'required'    => array(
                                array('append_content_summary','not','')
                            ), 
                        ),
                    )
                ) );
                // End Product
            };
            // Blog & Post
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'Blog & Post', 'bw-monki' ),
                'id'               => 'blog-post',
                'icon'             => 'el el-website'
            ) );
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'General', 'bw-monki' ),
                'id'               => 'blog-general',
                'subsection'       => true,
                'fields'           => array(
                                 
                    array(
                        'id'          => 'before_append_post',
                        'type'        => 'select',
                        'title'       => esc_html__('Append content before post/blog/archive page','bw-monki'),
                        'options'     => bzotech_list_post_type('bzotech_mega_item'),
                        'desc'        => esc_html__('Choose a mega page content append to before main content of post/blog/archive page.','bw-monki'),
                    ),
                    array(
                        'id'          => 'after_append_post',
                        'type'        => 'select',
                        'title'       => esc_html__('Append content after post/blog/archive page','bw-monki'),
                        'options'     => bzotech_list_post_type('bzotech_mega_item'),
                        'desc'        => esc_html__('Choose a mega page content append to after main content of post/blog/archive page.','bw-monki'),
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_position_blog',
                        'type'        => 'select',
                        'title'       => esc_html__('Sidebar position','bw-monki'),
                        'desc'        => esc_html__('Select the sidebar position for the blog page.','bw-monki'),
                        'options'     => array(
                            'no'    => esc_html__('No Sidebar','bw-monki'),
                            'left'  => esc_html__('Left','bw-monki'),
                            'right' => esc_html__('Right','bw-monki'),
                        ),
                        'default'     => 'right'
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_blog',
                        'type'        => 'select',
                        'title'       => esc_html__('Select sidebar','bw-monki'),
                        'data'        => 'sidebars',
                        'required'    => array(
                            array('bzotech_sidebar_position_blog','not','no'),
                            array('bzotech_sidebar_position_blog','not',''),
                        ), 
                        'desc'        => esc_html__('Select the sidebar to display for the blog pages.','bw-monki'),
                    ),
                     array(
                        'id'          => 'bzotech_sidebar_style_blog',
                        'type'        => 'select',
                        'title'       => esc_html__('Sidebar style','bw-monki'),
                        'desc'        => esc_html__('Select the sidebar style for the blog page.','bw-monki'),
                        'options'     => array(
                            'default'    => esc_html__('Default','bw-monki'),
                            'style2'  => esc_html__('Style2','bw-monki'),
                        ),
                        'required'    => array(
                            array('bzotech_sidebar_position_blog','not','no'),
                            array('bzotech_sidebar_position_blog','not',''),
                        ), 
                        'default'     => 'default'
                    ),
                    array(
                        'id'          => 'blog_default_style',
                        'type'        => 'select',
                        'title'       => esc_html__('Default blog view style','bw-monki'),
                        'desc'        =>esc_html__('Select the default blog view style: list view or grid view.','bw-monki'),
                        'options'     => array(
                            'list'  => esc_html__('List','bw-monki'),
                            'grid'  => esc_html__('Grid','bw-monki'),
                        ),
                        'default'     => 'list',
                    ),
                    array(
                        'id'          => 'blog_style',
                        'type'        => 'select',
                        'title'       => esc_html__('Pagination','bw-monki'),
                        'desc'        => esc_html__('Select the blog pagination style.','bw-monki'),
                        'options'     => array(
                            ''          => esc_html__('Default','bw-monki'),
                            'load-more' =>esc_html__('Load more','bw-monki'),
                        )
                    ),
                    array(
                        'id'          => 'blog_number_filter',
                        'type'        => 'switch',
                        'title'       => esc_html__('Show number filter','bw-monki'),
                        'desc'        => esc_html__('Show/hide number filter on blog page.','bw-monki'),
                        'default'     => false,
                    ),
                    array(
                        'id'          => 'blog_number_filter_list',
                        'title'       => esc_html__('Add list number filter','bw-monki'),
                        'type'        => 'repeater',
                        'desc'        => esc_html__('Add custom list number to filter on the blog page.','bw-monki'),
                        'fields'    => array( 
                            array(
                                'id'       => 'title',
                                'type'     => 'text',
                                'title'    => esc_html__( 'Title', 'bw-monki' ),
                            ),
                            array(
                                'id'          => 'number',
                                'type'        => 'text',
                                'title'       => esc_html__('Number','bw-monki'),
                            ),
                        ),
                        'required'   => array('blog_number_filter','not', false),
                    ),
                    array(
                        'id'          => 'blog_type_filter',
                        'type'        => 'switch',
                        'title'       => esc_html__('Show type filter','bw-monki'),
                        'desc'        => esc_html__('Show or hide type filter (list/grid) on blog page.','bw-monki'),
                        'default'     => false,
                    ),
                    array(
                        'id'          => 'blog_order_filter',
                        'type'        => 'switch',
                        'title'       => esc_html__('Show order filter','bw-monki'),
                        'desc'        => esc_html__('Show or hide order filter on blog page.','bw-monki'),
                        'default'     => false,
                    ),
                    

                )
            ) );
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'List View Settings', 'bw-monki' ),
                'id'               => 'blog-list',
                'subsection'       => true,
                'fields'           => array(
                    
                   
                    array(
                        'id'          => 'post_list_item_style',
                        'type'        => 'select',
                        'title'       => esc_html__('Item style','bw-monki'),
                        'desc'        => esc_html__('Select the item style (Default: Style 1).','bw-monki'),
                        'options'     => bzotech_get_post_list_style()
                    ),



                    array(
                        'id'       => 'item_thumbnail_post_list',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Thumbnail', 'bw-monki' ),
                        'desc' => esc_html__( 'Show or hide the thumbnail. (Default: by Item style)', 'bw-monki' ),
                        'default'  => '',
                        'options'     => array(
                            ''              => esc_html__('Default','bw-monki'),
                            'yes'  => esc_html__('Show','bw-monki'),
                            'no'  => esc_html__('Hide','bw-monki'),
                        )
                    ),
                    array(
                        'id'          => 'post_list_size',
                        'type'        => 'text',
                        'title'       => esc_html__('Custom list thumbnail size','bw-monki'),
                        'desc'        => esc_html__('Set the thumbnail size to crop in px. Format: [width]x[height]. For example 300x300.','bw-monki'),
                        'required'    => array('item_thumbnail_post_list','!=','no'),
                    ),
                    array(
                        'id'       => 'item_title_post_list',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Title', 'bw-monki' ),
                        'desc' => esc_html__( 'Show or hide the title. (Default: by Item style)', 'bw-monki' ),
                        'default'  => '',
                        'options'     => array(
                            ''              => esc_html__('Default','bw-monki'),
                            'yes'  => esc_html__('Show','bw-monki'),
                            'no'  => esc_html__('Hide','bw-monki'),
                        )
                    ),
                    array(
                        'id'          => 'item_meta_post_list',
                        'type'        => 'select',
                        'options'     => array(
                           ''     => esc_html__( 'Default', 'bw-monki' ),
                            'yes'      => esc_html__( 'yes', 'bw-monki' ),
                            'no'      => esc_html__( 'No', 'bw-monki' ),
                        ),
                        'title'       => esc_html__('Show meta data','bw-monki'),
                        'desc'        => esc_html__('Add meta post. (Default: by Item style)','bw-monki'),
                        'default'     => '',
                    ),
                    array(
                        'id'          => 'item_meta_select_post_list',
                        'type'        => 'select',
                        'multi'=>  true,
                        'title'       => esc_html__('Meta list','bw-monki'),
                        'options'     => array(
                           'author'     => esc_html__( 'Author', 'bw-monki' ),
                            'date'      => esc_html__( 'Date', 'bw-monki' ),
                            'cats'      => esc_html__( 'Categories', 'bw-monki' ),
                            'tags'      => esc_html__( 'Tags', 'bw-monki' ),
                            'comments'  => esc_html__( 'Comments', 'bw-monki' ),
                            'views'     => esc_html__( 'Total views', 'bw-monki' ),
                        ),
                        'desc'        => esc_html__('Show or hide meta data (author, date, comments, categories, tags) on blog page.','bw-monki'),
                        'required'    => array('item_meta_post_list','!=','no'),
                    ),
                    
                    array(
                        'id'       => 'item_excerpt_post_list',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Excerpt', 'bw-monki' ),
                        'desc' => esc_html__( 'Show or hide the excerpt. (Default: by Item style)', 'bw-monki' ),
                        'default'  => '',
                        'options'     => array(
                            ''              => esc_html__('Default','bw-monki'),
                            'yes'  => esc_html__('Show','bw-monki'),
                            'no'  => esc_html__('Hide','bw-monki'),
                        )
                    ),
                    array(
                        'id'          => 'post_list_excerpt',
                        'type'        => 'slider',
                        'title'       => esc_html__('Substring excerpt','bw-monki'),
                        'min'         => 0,
                        'max'         => 999,
                        'step'        => 1,
                        'default'     => 999,
                        'desc'        => esc_html__('Set the number of character to get from excerpt content. Default is 999. Note: This value only applies on items that supports to show excerpt.','bw-monki'),
                        'required'    => array('item_excerpt_post_list','!=','no'),
                    ),
                    array(
                        'id'       => 'item_button_post_list',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Button', 'bw-monki' ),
                        'desc' => esc_html__( 'Show or hide the button. (Default: by Item style)', 'bw-monki' ),
                        'default'  => '',
                        'options'     => array(
                            ''              => esc_html__('Default','bw-monki'),
                            'yes'  => esc_html__('Show','bw-monki'),
                            'no'  => esc_html__('Hide','bw-monki'),
                        )
                    ),
                )
            ) );
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'Grid View Settings', 'bw-monki' ),
                'id'               => 'blog-grid',
                'subsection'       => true,
                'fields'           => array(
                    array(
                        'id'          => 'post_grid_column',
                        'type'        => 'select',
                        'title'       => esc_html__('Grid column','bw-monki'),
                        'default'     => '3',
                        'desc'=>esc_html__('Choose a style to active display','bw-monki'),
                        'options'     => array(
                            '2' => esc_html__('2 column','bw-monki'),
                            '3' =>esc_html__('3 column','bw-monki'),
                            '4' =>esc_html__('4 column','bw-monki'),
                            '5' =>esc_html__('5 column','bw-monki'),
                            '6' =>esc_html__('6 column','bw-monki'),
                        )
                    ),
                    array(
                        'id'          => 'post_grid_item_style',
                        'type'        => 'select',
                        'title'       => esc_html__('Item style','bw-monki'),
                        'desc'        =>esc_html__('Select the item style.','bw-monki'),
                        'options'     => bzotech_get_post_style()
                    ),
                    array(
                        'id'          => 'post_grid_type',
                        'type'        => 'select',
                        'title'       => esc_html__('Display style','bw-monki'),
                        'desc'        =>esc_html__('Select the grid display style.','bw-monki'),
                        'options'     => array(
                            ''  => esc_html__('Default','bw-monki'),
                            'grid-masonry'  => esc_html__('Masonry','bw-monki'),
                            )
                    ),
                    array(
                        'id'       => 'item_thumbnail_post',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Thumbnail', 'bw-monki' ),
                        'desc' => esc_html__( 'Show or hide the thumbnail. (Default: by Item style)', 'bw-monki' ),
                        'default'  => '',
                        'options'     => array(
                            ''              => esc_html__('Default','bw-monki'),
                            'yes'  => esc_html__('Show','bw-monki'),
                            'no'  => esc_html__('Hide','bw-monki'),
                        )
                    ),
                    array(
                        'id'          => 'post_grid_size',
                        'type'        => 'text',
                        'title'       => esc_html__('Custom thumbnail size','bw-monki'),
                        'desc'        => esc_html__('Set the thumbnail size to crop in px. Format: [width]x[height]. For example 300x300.','bw-monki'),
                        'required'    => array('item_thumbnail_post','!=','no'),
                    ),
                    array(
                        'id'       => 'item_title_post',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Title', 'bw-monki' ),
                        'desc' => esc_html__( 'Show or hide the title. (Default: by Item style)', 'bw-monki' ),
                        'default'  => '',
                        'options'     => array(
                            ''              => esc_html__('Default','bw-monki'),
                            'yes'  => esc_html__('Show','bw-monki'),
                            'no'  => esc_html__('Hide','bw-monki'),
                        )
                    ),
                    array(
                        'id'          => 'item_meta_post',
                        'type'        => 'select',
                        'options'     => array(
                           ''     => esc_html__( 'Default', 'bw-monki' ),
                            'yes'      => esc_html__( 'yes', 'bw-monki' ),
                            'no'      => esc_html__( 'No', 'bw-monki' ),
                        ),
                        'title'       => esc_html__('Show meta data','bw-monki'),
                        'desc'        => esc_html__('Add meta post. (Default: by Item style)','bw-monki'),
                        'default'     => '',
                    ),
                    array(
                        'id'          => 'item_meta_select_post',
                        'type'        => 'select',
                        'multi'=>  true,
                        'title'       => esc_html__('Meta list','bw-monki'),
                        'options'     => array(
                           'author'     => esc_html__( 'Author', 'bw-monki' ),
                            'date'      => esc_html__( 'Date', 'bw-monki' ),
                            'cats'      => esc_html__( 'Categories', 'bw-monki' ),
                            'tags'      => esc_html__( 'Tags', 'bw-monki' ),
                            'comments'  => esc_html__( 'Comments', 'bw-monki' ),
                            'views'     => esc_html__( 'Total views', 'bw-monki' ),
                        ),
                        'desc'        => esc_html__('Show or hide meta data (author, date, comments, categories, tags) on blog page.','bw-monki'),
                        'required'    => array('item_meta_post','!=','no'),
                    ),
                    
                    array(
                        'id'       => 'item_excerpt_post',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Excerpt', 'bw-monki' ),
                        'desc' => esc_html__( 'Show or hide the excerpt. (Default: by Item style)', 'bw-monki' ),
                        'default'  => '',
                        'options'     => array(
                            ''              => esc_html__('Default','bw-monki'),
                            'yes'  => esc_html__('Show','bw-monki'),
                            'no'  => esc_html__('Hide','bw-monki'),
                        )
                    ),
                    array(
                        'id'          => 'post_grid_excerpt',
                        'type'        => 'slider',
                        'title'       => esc_html__('Substring excerpt','bw-monki'),
                        'min'         => 0,
                        'max'         => 999,
                        'step'        => 1,
                        'default'     => 999,
                        'desc'        => esc_html__('Set the number of character to get from excerpt content. Default is 999. Note: This value only applies on items that supports to show excerpt.','bw-monki')
                    ),
                    array(
                        'id'       => 'item_button_post',
                        'type'     => 'select',
                        'title'    => esc_html__( 'Button', 'bw-monki' ),
                        'desc' => esc_html__( 'Show or hide the button. (Default: by Item style)', 'bw-monki' ),
                        'default'  => '',
                        'options'     => array(
                            ''              => esc_html__('Default','bw-monki'),
                            'yes'  => esc_html__('Show','bw-monki'),
                            'no'  => esc_html__('Hide','bw-monki'),
                        )
                    ),
                )
            ) );
            Redux::setSection( $bzotech_option_name, array(
                'title'            => esc_html__( 'Post Detail Settings', 'bw-monki' ),
                'id'               => 'blog-post-detail',
                'subsection'       => true,
                'fields'           => array(                    
                    array(
                        'id'          => 'bzotech_style_post_detail',
                        'type'        => 'select',
                        'title'       => esc_html__('Single post style','bw-monki'),
                        'options'     => array(
                            'style1'    => esc_html__('Default','bw-monki'),
                            'style2'    => esc_html__('Style 2','bw-monki'),
                        ),
                        'default'  => 'style1'
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_position_post',
                        'type'        => 'select',
                        'title'       => esc_html__('Sidebar position','bw-monki'),
                        'desc'        => esc_html__('Select the sidebar position for the single post page.','bw-monki'),
                        'options'     => array(
                            'no'    => esc_html__('No Sidebar','bw-monki'),
                            'left'  => esc_html__('Left','bw-monki'),
                            'right' => esc_html__('Right','bw-monki'),
                        ),
                        'default'  => 'right'
                    ),
                    array(
                        'id'          => 'bzotech_sidebar_post',
                        'type'        => 'select',
                        'title'       => esc_html__('Select sidebar','bw-monki'),
                        'data'        => 'sidebars',
                        'required'    => array(
                            array('bzotech_sidebar_position_post','not','no'),
                            array('bzotech_sidebar_position_post','not',''),
                        ),                   
                        'desc'        => esc_html__('Select the sidebar to display for the single post page.','bw-monki'),
                        'default'     => 'blog-sidebar'
                    ),

                    array(
                        'id'          => 'bzotech_sidebar_style_post',
                        'type'        => 'select',
                        'title'       => esc_html__('Sidebar style','bw-monki'),
                        'desc'        => esc_html__('Select the sidebar style for the post page.','bw-monki'),
                        'options'     => array(
                            'default'    => esc_html__('Default','bw-monki'),
                            'style2'  => esc_html__('Style2','bw-monki'),
                        ),
                        'required'    => array(
                            array('bzotech_sidebar_position_post','not','no'),
                            array('bzotech_sidebar_position_post','not',''),
                        ), 
                        'default'     => 'default'
                    ),
                    array(
                        'id'          => 'before_append_post_detail',
                        'title'       => esc_html__('Append content before post detail','bw-monki'),
                        'type'        => 'select',
                        'options'     => bzotech_list_post_type('bzotech_mega_item'),
                        'desc'        => esc_html__('Choose a mega page content append to before main content of post detail.','bw-monki'),
                    ),
                    array(
                        'id'          => 'after_append_post_detail',
                        'title'       => esc_html__('Append content after post detail','bw-monki'),
                        'type'        => 'select',
                        'options'     => bzotech_list_post_type('bzotech_mega_item'),
                        'desc'        => esc_html__('Choose a mega page content append to after main content of post detail.','bw-monki'),
                    ),
                    array(
                        'id'          => 'post_single_thumbnail',
                        'type'        => 'switch',
                        'title'       => esc_html__('Show thumbnail/media','bw-monki'),
                        'desc'        => 'Show/hide thumbnail image, gallery, media on post detail.',
                        'default'     => true,
                    ),                
                    array(
                        'id'          => 'post_single_size',
                        'title'       => esc_html__('Custom single image size','bw-monki'),
                        'type'        => 'text',
                        'desc'        => esc_html__('Enter size thumbnail to crop. [width]x[height]. Example is 300x300.','bw-monki'),
                        'required'    => array('post_single_thumbnail','=',true),
                    ),
                    array(
                        'id'          => 'post_single_meta',
                        'type'        => 'select',
                        'options'     => array(
                           ''     => esc_html__( 'Default', 'bw-monki' ),
                            'yes'      => esc_html__( 'yes', 'bw-monki' ),
                            'no'      => esc_html__( 'No', 'bw-monki' ),
                        ),
                        'title'       => esc_html__('Show meta data','bw-monki'),
                        'desc'        => esc_html__('Show or hide meta data (author, date, comments, categories, tags) on post detail.','bw-monki'),
                        'default'     => '',

                    ),
                     array(
                        'id'          => 'single_item_meta_select',
                        'type'        => 'select',
                        'multi'=>  true,
                        'title'       => esc_html__('Meta list','bw-monki'),
                        'options'     => array(
                           'author'     => esc_html__( 'Author', 'bw-monki' ),
                            'date'      => esc_html__( 'Date', 'bw-monki' ),
                            'cats'      => esc_html__( 'Categories', 'bw-monki' ),
                            'tags'      => esc_html__( 'Tags', 'bw-monki' ),
                            'comments'  => esc_html__( 'Comments', 'bw-monki' ),
                            'views'     => esc_html__( 'Total views', 'bw-monki' ),
                        ),
                        'required'    => array('post_single_meta','=','yes'),
                    ),
                    array(
                        'id'          => 'post_single_author',
                        'type'        => 'switch',
                        'title'       => esc_html__('Author','bw-monki'),
                        'desc'        => esc_html__('Show or hide author information in the post detail.','bw-monki' ),
                        'default'     => false,
                    ),
                    array(
                        'id'          => 'post_single_navigation',
                        'type'        => 'switch',
                        'title'       => esc_html__('Post navigation','bw-monki'),
                        'desc'        => esc_html__('Show or hide navigation to next or previous post in the post detail.','bw-monki' ),
                        'default'     => false,
                    ),
                    // Related section
                    array(
                        'id'          => 'post_single_related',
                        'type'        => 'switch',
                        'title'       => esc_html__('Related post','bw-monki'),
                        'desc'        => esc_html__('Show or hide related post in the post detail.','bw-monki' ),
                        'default'     => false,
                    ),
                    array(
                        'id'          => 'post_single_related_title',
                        'type'        => 'text',
                        'title'       => esc_html__('Related title','bw-monki'),
                        'desc'        => esc_html__('Enter title of related section.','bw-monki'),
                        'required'    => array('post_single_related','=',true),
                    ),
                    array(
                        'id'          => 'post_single_related_number',
                        'type'        => 'text',
                        'title'       => esc_html__('Related number post','bw-monki'),
                        'desc'        => esc_html__('Enter number of related post to display.','bw-monki'),
                        'required'    => array('post_single_related','=',true),
                    ),
                    array(
                        'id'          => 'post_single_related_item',
                        'type'        => 'text',
                        'title'       => esc_html__('Related custom number item responsive','bw-monki'),
                        'desc'        => esc_html__('Enter item for screen width(px) format is width:value and separate values by ",". Example is 0:2,600:3,1000:4. Default is auto.','bw-monki'),
                        'required'    => array('post_single_related','=',true),
                    ),
                    array(
                        'id'          => 'post_single_related_item_style',
                        'type'        => 'select',
                        'title'       => esc_html__('Related item style','bw-monki'),
                        'desc'        =>esc_html__('Choose a style to active display','bw-monki'),
                        'options'     => bzotech_get_post_style(),
                        'required'    => array('post_single_related','=',true),
                    ),
                )
            ) );
            // Blog & Post

            

           
        }
    }
    // End Redux help function
    // This is your option name where all the Redux data is stored.

    $bzotech_option_name = bzotech_get_option_name();

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $bzotech_option_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Theme Options', 'bw-monki' ),
        'page_title'           => esc_html__( 'Theme Options', 'bw-monki' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => 'AIzaSyBFxhycc63fWy_uk126zW8KPtkD3Bay0jI',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => true,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        

        // OPTIONAL -> Give you extra features
        'page_priority'        => 59,//29
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        'menu_icon'            => get_template_directory_uri().'/assets/admin/image/logo.png',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_options_object' => false,
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

      

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/BZOTech',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://twitter.com/BzoTech',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.youtube.com/@bzotech9150',
        'title' => 'Find us on Youtube',
        'icon'  => 'el el-youtube'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.linkedin.com/in/bzotech/',
        'title' => 'Follow us on Linkedin',
        'icon'  => 'el el-linkedin'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.pinterest.com/Bzo_Tech',
        'title' => 'Follow us on Pinterest',
        'icon'  => 'el el-pinterest'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.instagram.com/bzotech/',
        'title' => 'Follow us on Instagram',
        'icon'  => 'el el-instagram'
    );
    Redux::setArgs( $bzotech_option_name, $args );

    /*
     * ---> END ARGUMENTS
     */    
    
    bzotech_switch_redux_option();


