<?php
/**
 * Edit account form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

defined( 'ABSPATH' ) || exit;

if ( apply_filters( 'stm_is_rental_two', false ) ) {
	do_action( 'smt_mcr_account_form_edit_template', $user );
} else {
	do_action( 'woocommerce_before_edit_account_form' ); ?>

	<form class="woocommerce-EditAccountForm edit-account" action="" method="post" <?php do_action( 'woocommerce_edit_account_form_tag' ); ?> >

		<?php do_action( 'woocommerce_edit_account_form_start' ); ?>

		<?php if ( apply_filters( 'stm_is_rental', false ) ) : ?>
		<fieldset>
			<legend><?php esc_html_e( 'Account Settings', 'motors' ); ?></legend>
			<?php endif; ?>

			<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
				<label for="account_first_name"><?php esc_html_e( 'First name', 'motors' ); ?>&nbsp;<span class="required">*</span></label>
				<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_first_name" id="account_first_name" autocomplete="given-name" value="<?php echo esc_attr( $user->first_name ); ?>"/>
			</p>
			<p class="woocommerce-form-row woocommerce-form-row--last form-row form-row-last">
				<label for="account_last_name"><?php esc_html_e( 'Last name', 'motors' ); ?>&nbsp;<span class="required">*</span></label>
				<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_last_name" id="account_last_name" autocomplete="family-name" value="<?php echo esc_attr( $user->last_name ); ?>"/>
			</p>
			<div class="clear"></div>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="account_display_name"><?php esc_html_e( 'Display name', 'motors' ); ?>&nbsp;<span class="required">*</span></label>
				<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_display_name" id="account_display_name" value="<?php echo esc_attr( $user->display_name ); ?>"/> <span><em><?php esc_html_e( 'This will be how your name will be displayed in the account section and in reviews', 'motors' ); ?></em></span>
			</p>
			<div class="clear"></div>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="account_email"><?php esc_html_e( 'Email address', 'motors' ); ?>&nbsp;<span class="required">*</span></label>
				<input type="email" class="woocommerce-Input woocommerce-Input--email input-text" name="account_email" id="account_email" autocomplete="email" value="<?php echo esc_attr( $user->user_email ); ?>"/>
			</p>

			<?php if ( apply_filters( 'stm_is_rental', false ) ) : ?>
		</fieldset>
	<?php endif; ?>

		<?php
		/**
		 * Hook where additional fields should be rendered.
		 *
		 * @since 8.7.0
		 */
		do_action( 'woocommerce_edit_account_form_fields' );
		?>

		<fieldset>
			<legend><?php esc_html_e( 'Password change', 'motors' ); ?></legend>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<?php if ( apply_filters( 'stm_is_rental', false ) ) : ?>
					<label for="password_current"><?php esc_html_e( 'Current password', 'motors' ); ?>
						<span class="stm-label-small"><?php esc_html_e( ' (leave blank to leave unchanged)', 'motors' ); ?></span>
					</label>
				<?php else : ?>
					<label for="password_current"><?php esc_html_e( 'Current password (leave blank to leave unchanged)', 'motors' ); ?></label>
				<?php endif; ?>
				<input type="password" class="woocommerce-Input woocommerce-Input--password input-text" name="password_current" id="password_current"/>
			</p>
			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<?php if ( apply_filters( 'stm_is_rental', false ) ) : ?>
					<label for="password_1"><?php esc_html_e( 'New password', 'motors' ); ?>
						<span class="stm-label-small"><?php esc_html_e( ' (leave blank to leave unchanged)', 'motors' ); ?></span>
					</label>
				<?php else : ?>
					<label for="password_1"><?php esc_html_e( 'New password (leave blank to leave unchanged)', 'motors' ); ?></label>
				<?php endif; ?>
				<input type="password" class="woocommerce-Input woocommerce-Input--password input-text" name="password_1" id="password_1"/>
			</p>
			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="password_2"><?php esc_html_e( 'Confirm new password', 'motors' ); ?></label>
				<input type="password" class="woocommerce-Input woocommerce-Input--password input-text" name="password_2" id="password_2"/>
			</p>
		</fieldset>
		<div class="clear"></div>

		<?php do_action( 'woocommerce_edit_account_form' ); ?>

		<p>
			<?php wp_nonce_field( 'save_account_details', 'save-account-details-nonce' ); ?>
			<input type="submit" class="woocommerce-Button button" name="save_account_details" value="<?php esc_attr_e( 'Save changes', 'motors' ); ?>"/>
			<input type="hidden" name="action" value="save_account_details"/>
		</p>

		<?php do_action( 'woocommerce_edit_account_form_end' ); ?>
	</form>

	<?php
	do_action( 'woocommerce_after_edit_account_form' );
}
?>
