<?php

/**
 * Class for all wcboost wishlist template modification
 *
 * @version 1.0
 */

/**
 * Ajaxify update count wishlist
 *
 * @since 1.0
 *
 * @param array $fragments
 *
 * @return array
 */
function update_wishlist_count($data) {
	$data['.menu-item-wishlist .mini-yith-counter'] = '<span class="mini-yith-counter">'.\WCBoost\Wishlist\Helper::get_wishlist()->count_items() . '</span>';

	return $data;
}

add_filter( 'wcboost_wishlist_add_to_wishlist_fragments', 'update_wishlist_count', 10, 1 );

/**
 * Change button view text
 *
 * @return void
 */
function wishlist_button_view_text() {
	return esc_html__( 'Browse wishlist', 'mrbara' );
}

add_filter( 'wcboost_wishlist_button_view_text', 'wishlist_button_view_text' );

/**
 * Wishlist array
 *
 * @since 1.0.0
 *
 * @return array
 */
function wishlist_args($args) {
	if( $key = array_search( 'button', $args['class'] ) ) {
		unset( $args['class'][$key] );
	}

	return $args;
}

add_filter( 'wcboost_wishlist_button_template_args', 'wishlist_args', 20, 3 );

/**
 * Wishlist table
 *
 * @return void
 */
function wishlist_table( $item, $item_key, $wishlist ) {
	$_product = $item->get_product();
	$default_columns  = [
		'price'    => 'yes',
		'stock'    => 'yes',
		'quantity' => 'no',
		'date'     => 'no',
		'purchase' => 'yes',
	];

	$columns = get_option( 'wcboost_wishlist_table_columns' , $default_columns );
	$columns = wp_parse_args( $columns, $default_columns );
	?>
		<?php if( isset( $columns['price'] ) && $columns['price'] == 'yes' ) : ?>
			<div class="product-price hidden-lg hidden-md">
				<span class="label"><?php esc_html_e( 'Price', 'mrbara' ); ?></span>
				<span class="price"><?php echo wp_kses_post( $_product->get_price_html() ); ?></span>
			</div>
		<?php endif; ?>

		<?php if( isset( $columns['stock'] ) && $columns['stock'] == 'yes' ) : ?>
			<div class="product-stock-status hidden-lg hidden-md">
				<span class="label"><?php esc_html_e( 'Stock', 'mrbara' ); ?></span>
				<?php
				$availability = $_product->get_availability();
				printf( '<span class="%s">%s</span>', esc_attr( $availability['class'] ), $availability['availability'] ? esc_html( $availability['availability'] ) : esc_html__( 'In Stock', 'mrbara' ) );
				?>
			</div>
		<?php endif; ?>

		<?php if ( isset( $columns['date'] ) && $columns['date'] == 'yes' ) : ?>
			<div class="product-date hidden-lg hidden-md">
				<?php echo esc_html( $item->get_date_added()->format( get_option( 'date_format' ) ) ); ?>
			</div>
		<?php endif; ?>
	<?php
}

add_action( 'wcboost_wishlist_after_item_name', 'wishlist_table', 10, 3 );