$(document).ready(function ($) {
    const ajaxurl = get_strings.ajax_url;
    const sb_options = get_strings;
    const loading = $("#sb_loading");
    let uploadedImages = 0;
    let isImageRequired = sb_options.images_required_on_ad_post;
    var is_rtl_check = sb_options.is_rtl;
    is_rtl = false;

    if (is_rtl_check === "1") {
        is_rtl = true;
    }

    $('.tax-show-more').on('click', function () {
        $(this).hide();
        var $showIt = $('.show_it');
        if ($showIt.length) {
            $showIt.removeClass('no-display');
        }
    });

    setTimeout(function () {
        $("body").addClass("loaded");
    }, 3000);

    // brand carousel
    $('.brand-carousel').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 10,
        nav: false,
        dots: false,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: false,
        responsive: {
            0: {
                items: 1
            }, 576: {
                items: 3
            }, 992: {
                items: 5
            }, 1200: {
                items: 6
            }
        }
    });

    $('.owl-carousel-main-hero-4').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 10,
        nav: false,
        dots: false,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: true,
        responsive: {
            0: {
                items: 1
            },
            576: {
                items: 1
            },
            992: {
                items: 1
            },
            1200: {
                items: 1
            }
        }
    });

    if ($("#car-dealer-hero-form").length > 0) {
        var dataContainer = $('#taxonomy-data');
        var taxonomy = dataContainer.data('taxonomy');
        var ajaxUrl = dataContainer.data('ajax-url');
        var selectModelText = dataContainer.data('select-model-text');
        var selectVariantText = dataContainer.data('select-variant-text');

        $('#make').on('change.select2', function () {
            loading.show();
            var parent_id = $(this).val();
            if (parent_id) {
                $.ajax({
                    url: ajaxUrl,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'get_child_terms',
                        parent: parent_id,
                        taxonomy: taxonomy
                    },
                    success: function (response) {
                        loading.hide();
                        if (response.success) {
                            var options = '<option value="">' + selectModelText + '</option>';
                            $.each(response.data, function (index, term) {
                                options += '<option value="' + term.term_id + '">' + term.name + '</option>';
                            });
                            $('#model').html(options).prop('disabled', false);
                            $('#variant').html('<option value="">' + selectVariantText + '</option>').prop('disabled', true);
                        }
                    }
                });
            } else {
                $('#model').html('<option value="">' + selectModelText + '</option>').prop('disabled', true);
                $('#variant').html('<option value="">' + selectVariantText + '</option>').prop('disabled', true);
            }
        });

        // When a Model is selected, load its child terms into the Variant select
        $('#model').on('change.select2', function () {
            loading.show();
            var parent_id = $(this).val();
            if (parent_id) {
                $.ajax({
                    url: ajaxUrl,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'get_child_terms',
                        parent: parent_id,
                        taxonomy: taxonomy
                    },
                    success: function (response) {
                        loading.hide();
                        if (response.success) {
                            var options = '<option value="">' + selectVariantText + '</option>';
                            $.each(response.data, function (index, term) {
                                options += '<option value="' + term.term_id + '">' + term.name + '</option>';
                            });
                            $('#variant').html(options).prop('disabled', false);
                        }
                    }
                });
            } else {
                $('#variant').html('<option value="">' + selectVariantText + '</option>').prop('disabled', true);
            }
        });

        $('#car-dealer-hero-form').on('submit', function (e) {
            var selectedCatId = '';
            if ($('#variant').val()) {
                selectedCatId = $('#variant').val();
            } else if ($('#model').val()) {
                selectedCatId = $('#model').val();
            } else if ($('#make').val()) {
                selectedCatId = $('#make').val();
            }
            $('#cat_id_hidden').val(selectedCatId);
        });
    }

    $('.carousel-team-style-1').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 10,
        nav: false,
        dots: false,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: false,
        responsive: {
            0: {
                items: 1
            }, 576: {
                items: 3
            }, 992: {
                items: 4
            }, 1200: {
                items: 4
            }
        }
    });

    // Pets carousel
    $('.pet-category-carousel').owlCarousel({
        loop: false,
        rtl: is_rtl,
        margin: 30,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        autoplayTimeout: 5000,
        autoplayHoverPause: false,
        responsive: {
            0: {
                items: 2,
                margin: 10,
            }, 420: {
                items: 2,
                margin: 10,
            }, 576: {
                items: 3,
                margin: 10,
            }, 992: {
                items: 5,
                margin: 20,
            }, 1200: {
                items: 6,
                margin: 20,
            }, 1400: {
                items: 6
            }
        }
    });

    // Ads carousel
    $('.adt-ads-carousel').each(function () {
        var $carousel = $(this);
        var columns = parseInt($carousel.data('columns')) || 4;

        $carousel.owlCarousel({
            loop: false,
            rtl: is_rtl,
            margin: 30,
            nav: true,
            navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
            dots: false,
            autoplayTimeout: 5000,
            autoplayHoverPause: false,
            responsive: {
                0: {
                    items: 2,
                    margin: 10,
                },
                576: {
                    items: Math.min(2, columns),
                    margin: 20,
                },
                768: {
                    items: Math.min(3, columns),
                    margin: 20,
                },
                992: {
                    items: Math.min(3, columns),
                    margin: 20,
                },
                1200: {
                    items: Math.min(3, columns),
                },
                1400: {
                    items: columns
                }
            }
        });
    });

    $('.adt-ads-carousel-widgets').each(function () {
        var $carousel = $(this);
        var columns = parseInt($carousel.data('columns')) || 4;
        var mobileColumns = parseInt($carousel.data('mobile-columns')) || 1;

        $carousel.owlCarousel({
            loop: false,
            rtl: is_rtl,
            margin: 36,
            nav: true,
            navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
            dots: false,
            autoplayTimeout: 5000,
            autoplayHoverPause: false,
            responsive: {
                0: {
                    items: mobileColumns,
                    margin: 10,
                },
                500: {
                    items: mobileColumns,
                    margin: 10,
                },
                576: {
                    items: Math.min(2, columns),
                    margin: 20,
                },
                768: {
                    items: Math.min(3, columns),
                    margin: 20,
                },
                992: {
                    items: Math.min(3, columns)
                },
                1200: {
                    items: Math.min(4, columns)
                },
                1400: {
                    items: columns
                }
            }
        });
    });

    // Ads carousel
    $('.adt-ads-sub-carousel').each(function () {
        const $carousel = $(this);
        const columnCount = parseInt($carousel.data('columns')) || 4;
        const mobileColumns = parseInt($carousel.data('mobile-columns')) || 4;

        $carousel.owlCarousel({
            loop: false,
            rtl: is_rtl,
            margin: 20,
            nav: true,
            navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
            dots: false,
            autoplayTimeout: 5000,
            autoplayHoverPause: false,
            responsive: {
                0: {
                    items: mobileColumns,
                    margin: 10
                },
                500: {
                    items: mobileColumns,
                    margin: 10
                },
                576: {
                    items: Math.min(columnCount, 2)
                },
                768: {
                    items: Math.min(columnCount, 3)
                },
                992: {
                    items: Math.min(columnCount, 4)
                },
                1200: {
                    items: Math.min(columnCount, 2)
                },
                1400: {
                    items: Math.min(columnCount, 3)
                }
            }
        });
    });

    // Category Mini carousel
    $('.category-mini-carousel').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 10,
        nav: false,
        dots: false,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: false,
        responsive: {
            0: {
                items: 2
            }, 576: {
                items: 3
            }, 992: {
                items: 5
            }, 1200: {
                items: 7
            }, 1400: {
                items: 9
            }
        }
    });

    // Mini Ads carousel
    $('.adt-mini-ads-carousel').each(function () {
        const $carousel = $(this);
        const mobileColumns = parseInt($carousel.data('mobile-columns')) || 4;

        $carousel.owlCarousel({
            loop: false,
            rtl: is_rtl,
            margin: 20,
            nav: true,
            navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
            dots: false,
            autoplayTimeout: 5000,
            autoplayHoverPause: false,
            responsive: {
                0: {
                    items: mobileColumns,
                    margin: 10,
                }, 576: {
                    items: mobileColumns
                }, 768: {
                    items: 3
                }, 992: {
                    items: 3
                }, 1200: {
                    items: 4
                }, 1400: {
                    items: 5
                }
            }
        });
    });

    // Vendor Mini Ads carousel
    $('.adt-vendor-mini-ads-carousel').owlCarousel({
        loop: false,
        rtl: is_rtl,
        margin: 20,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        autoplayTimeout: 5000,
        autoplayHoverPause: false,
        responsive: {
            0: {
                items: 1
            },
            576: {
                items: 3
            },
            768: {
                items: 4
            },
            992: {
                items: 3
            },
            1200: {
                items: 3
            },
            1400: {
                items: 3
            }
        }
    });

    // Find categories Carousel
    $('.adt-find-by-categories-carousel').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 36,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: false,
        responsive: {
            0: {
                items: 2,
                margin: 10
            },
            420: {
                items: 2,
                margin: 10
            },
            576: {
                items: 3,
                margin: 20
            },
            768: {
                items: 4,
                margin: 20
            },
            992: {
                items: 5
            },
            1200: {
                items: 6
            }
        }
    });

    // Property image Carousel
    $('.adt-property-ads-carousel').owlCarousel({
        loop: false,
        rtl: is_rtl,
        margin: 36,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        responsive: {
            0: {
                items: 1
            },
            576: {
                items: 2,
                margin: 20,
            },
            768: {
                items: 3,
                margin: 20,
            },
            992: {
                items: 3,
            },
            1200: {
                items: 4
            }
        }
    })

    $('.adt-property-ads-carousel-widgets').each(function () {
        var $carousel = $(this);
        var columns = parseInt($carousel.data('columns')) || 4;
        var mobileColumns = parseInt($carousel.data('mobile-columns')) || 1;

        $carousel.owlCarousel({
            loop: false,
            rtl: is_rtl,
            margin: 36,
            nav: true,
            navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
            dots: false,
            responsive: {
                0: {
                    items: mobileColumns,
                    margin: 10,
                },
                500: {
                    items: mobileColumns,
                    margin: 10,
                },
                576: {
                    items: Math.min(2, columns),
                    margin: 20,
                },
                768: {
                    items: Math.min(3, columns),
                    margin: 20,
                },
                992: {
                    items: Math.min(3, columns)
                },
                1200: {
                    items: Math.min(4, columns)
                },
                1400: {
                    items: columns
                }
            }
        });
    });

    // Property image Carousel
    $('.adt-property-img-carousel').owlCarousel({
        loop: false,
        rtl: is_rtl,
        margin: 0,
        nav: true,
        dots: false,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });

    // Car Category Carousel
    $('.adt-car-category-carousel').each(function () {
        var $carousel = $(this);
        var mobileColumns = parseInt($carousel.data('mobile-columns')) || 1;
        $carousel.owlCarousel({
            loop: true,
            rtl: is_rtl,
            margin: 36,
            nav: true,
            navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
            dots: false,
            responsive: {
                0: {
                    items: mobileColumns,
                    margin: 10
                },
                576: {
                    items: mobileColumns
                },
                768: {
                    items: 4
                },
                992: {
                    items: 5
                },
                1200: {
                    items: 6
                }
            }
        });
    });

    $('#showMoreCategories').on('click', function () {
        $('.hidden-category').slideDown();
        $(this).hide();
        $('#showLessCategories').show();
    });
    $('#showLessCategories').on('click', function () {
        $('.hidden-category').slideUp();
        $(this).hide();
        $('#showMoreCategories').show();
    });

    // Car Ad Carousel
    $('.adt-car-ad-carousel').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 0,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });

    // Category type Carousel
    $('.adt-category-types-carousel').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 0,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        responsive: {
            0: {
                items: 2
            },
            576: {
                items: 2
            },
            768: {
                items: 4
            },
            992: {
                items: 7
            },
            1200: {
                items: 9
            },
            1400: {
                items: 12
            }
        }
    });

    // Place Detail Carousel
    $('.adt-place-detail-carousel').owlCarousel({
        loop: false,
        rtl: is_rtl,
        margin: 0,
        items: 1,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
    });

    // Popular Place Carousel
    $('.adt-popular-place-carousel').owlCarousel({
        loop: false,
        rtl: is_rtl,
        margin: 36,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        responsive: {
            0: {
                items: 1
            },
            576: {
                items: 2
            },
            768: {
                margin: 20,
                items: 3
            },
            992: {
                items: 3
            },
            1200: {
                margin: 20,
                items: 5
            },
            1400: {
                items: 5
            }
        }
    });

    // Popular Place Carousel
    $('.adt-event-list-carousel').owlCarousel({
        loop: false,
        rtl: is_rtl,
        margin: 36,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        responsive: {
            0: {
                items: 1
            },
            576: {
                items: 2
            },
            768: {
                margin: 20,
                items: 3
            },
            992: {
                items: 3
            },
            1200: {
                margin: 20,
                items: 4
            },
            1400: {
                items: 4
            }
        }
    });

    // Category type Carousel
    $('.adt-category-types-carousel-2').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 0,
        center: true,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: true,
        responsive: {
            0: {
                items: 2,
                nav: true
            },
            400: {
                items: 3,
                nav: true
            },
            576: {
                items: 2,
                nav: true
            },
            768: {
                items: 3,
                nav: true
            },
            992: {
                items: 6,
                nav: true
            },
            1200: {
                items: 7,
                nav: true
            },
            1400: {
                items: 8,
                nav: true
            }
        }
    });

    // Cyber Product Mini Carousel
    $('.cyber-products-mini-carousel').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 10,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: true,
        responsive: {
            0: {
                items: 1
            },
            400: {
                items: 2
            },
            576: {
                items: 2
            },
            768: {
                items: 3
            },
            992: {
                items: 2
            },
            1200: {
                items: 2,
                margin: 20
            },
            1400: {
                items: 2.9
            }
        }
    });

    // Cyber Sale Product Carousel
    $('.cyber-sale-products-carousel').owlCarousel({
        rtl: is_rtl,
        loop: false,
        margin: 5,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        responsive: {
            0: {
                items: 1
            },
            400: {
                items: 2
            },
            576: {
                items: 2
            },
            768: {
                items: 3
            },
            992: {
                items: 4
            },
            1200: {
                items: 4
            },
            1400: {
                items: 5
            }
        }
    });

    // Masonry grid js
    if($('#masonry-grid').length > 0) {
        var $grid = $('#masonry-grid');
        $grid.masonry({
            itemSelector: '.masonry-item',
            columnWidth: '.masonry-item',
            percentPosition: true
        });
    }

    $('.default-select').select2();

    $('[data-toggle="tooltip"]').tooltip({
        html: true
    });

    $(".search-all-filters, .close-sidebar").on("click", function (e) {
        e.preventDefault();
        $('.search-all-filters').toggleClass('active');
        $('.all-filters-sidebar.adt-ads-filter-sidebar').toggleClass('open');
    });

    $(".mobile-filters-btn a, a.filter-close-btn").on("click", function () {
        $(".mobile-filters").toggleClass("active");
    });

    if ($(".adt-ads-range-slider").length) {
        let $servicesRange = $(".adt-ads-range-slider");
        let $servicesInputFrom = $(".adt-ads-input-from");
        let $servicesInputTo = $(".adt-ads-input-to");
        let $minValueSpan = $('#min_price');
        let $maxValueSpan = $('#max_price');
        let instance;

        let min = (typeof price_widget !== 'undefined' && price_widget !== null && price_widget.min_price !== undefined)
            ? price_widget.min_price
            : "";

        let max = (typeof price_widget !== 'undefined' && price_widget !== null && price_widget.max_price !== undefined)
            ? price_widget.max_price
            : "";

        let from = $servicesInputFrom.val() ? parseInt($servicesInputFrom.val()) : min;
        let to = $servicesInputTo.val() ? parseInt($servicesInputTo.val()) : max;

        $servicesRange.ionRangeSlider({
            skin: "round",
            type: "double",
            min: min,
            max: max,
            from: from,
            to: to,
            hide_from_to: true,
            hide_min_max: true,
            onStart: updateInputs,
            onChange: updateInputs,
        });

        instance = $servicesRange.data("ionRangeSlider");

        function updateInputs(data) {
            from = data.from;
            to = data.to;

            $servicesInputFrom.prop("value", from);
            $servicesInputTo.prop("value", to);
            $minValueSpan.text(from);
            $maxValueSpan.text(to);
            $('#min_selected').val(from);
            $('#max_selected').val(to);
        }

        $servicesInputFrom.on("input", function () {
            let val = $(this).prop("value");

            if (val < min) {
                val = min;
            } else if (val > to) {
                val = to;
            }

            instance.update({
                from: val
            });
        });

        $servicesInputTo.on("input", function () {
            let val = $(this).prop("value");

            if (val < from) {
                val = from;
            } else if (val > max) {
                val = max;
            }

            instance.update({
                to: val
            });
        });
    }


    // price slider for top bar search
    var $priceSlider = $("#price-slider-topbar-search");

    if ($priceSlider.length > 0 && $.fn.ionRangeSlider) {
        $priceSlider.ionRangeSlider({
            skin: "round",
            type: "double",
            grid: false,
            min: 0,
            max: 10000,
            from: 0,
            to: 5400,
            prefix: "$",
            hide_min_max: true,
        });
    }

    // Ad Carousel
    let sync1 = $("#sync1");
    let sync2 = $("#sync2");
    let slidesPerPage1 = 4;
    let syncedSecondary = true;

    sync1.owlCarousel({
        items: 1,
        slideSpeed: 2000,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        autoplay: true,
        autoplayTimeout: sb_options.auto_slide_time,
        dots: false,
        loop: true,
        rtl: is_rtl,
        responsiveRefreshRate: 200,
    }).on('changed.owl.carousel', syncPosition1);

    if ($("#sync2").length > 0) {
        sync2
            .on('initialized.owl.carousel', function () {
                sync2.find(".owl-item").eq(0).addClass("current");
            })
            .owlCarousel({
                rtl: is_rtl,
                items: 6,
                margin: 14,
                dots: false,
                nav: false,
                smartSpeed: 200,
                slideSpeed: 500,
                slideBy: slidesPerPage1,
                responsiveRefreshRate: 100
            }).on('click', '.owl-item', function (e) {
            let number = $(this).index();
            sync1.data('owl.carousel').to(number, 300, true);
        });
    }

    $(document).ready(function () {
        if ($('[data-fancybox="gallery"]').length !== 0) {
            $('[data-fancybox="gallery"]').fancybox({
                loop: true,
                buttons: [
                    "zoom",
                    "close"
                ]
            });
        }
    });

    function syncPosition1(el) {
        let count = el.item.count - 1;
        let current = Math.round(el.item.index - (el.item.count / 2) - .5);

        if (current < 0) {
            current = count;
        }
        if (current > count) {
            current = 0;
        }

        if ($("#sync2").length > 0) {
            sync2
                .find(".owl-item")
                .removeClass("current")
                .eq(current)
                .addClass("current");
            let onscreen = sync2.find('.owl-item.active').length - 1;
            let start = sync2.find('.owl-item.active').first().index();
            let end = sync2.find('.owl-item.active').last().index();

            if (current > end) {
                sync2.data('owl.carousel').to(current, 100, true);
            }
            if (current < start) {
                sync2.data('owl.carousel').to(current - onscreen, 100, true);
            }
        }
    }

    // Multivendor product detail carousel
    let sync3 = $("#sync3");
    let sync4 = $("#sync4");
    let slidesPerPage2 = 4;

    sync3.owlCarousel({
        items: 1, slideSpeed: 2000, nav: false, autoplay: false, dots: false, loop: true, responsiveRefreshRate: 200,
    }).on('changed.owl.carousel', syncPosition3);

    sync4
        .on('initialized.owl.carousel', function () {
            sync4.find(".owl-item").eq(0).addClass("current");
        })
        .owlCarousel({
            items: 4,
            rtl: is_rtl,
            margin: 25,
            dots: false,
            nav: false,
            smartSpeed: 200,
            slideSpeed: 500,
            slideBy: slidesPerPage2,
            responsiveRefreshRate: 100
        }).on('changed.owl.carousel', syncPosition4);

    function syncPosition3(el) {
        let count = el.item.count - 1;
        let current = Math.round(el.item.index - (el.item.count / 2) - .5);

        if (current < 0) {
            current = count;
        }
        if (current > count) {
            current = 0;
        }

        sync4
            .find(".owl-item")
            .removeClass("current")
            .eq(current)
            .addClass("current");
        let onscreen = sync4.find('.owl-item.active').length - 1;
        let start = sync4.find('.owl-item.active').first().index();
        let end = sync4.find('.owl-item.active').last().index();

        if (current > end) {
            sync4.data('owl.carousel').to(current, 100, true);
        }
        if (current < start) {
            sync4.data('owl.carousel').to(current - onscreen, 100, true);
        }
    }

    function syncPosition4(el) {
        if (syncedSecondary) {
            let number = el.item.index;
            sync3.data('owl.carousel').to(number, 100, true);
        }
    }

    sync4.on("click", ".owl-item", function (e) {
        e.preventDefault();
        let number = $(this).index();
        sync3.data('owl.carousel').to(number, 300, true);
    });


    $('.ad-content-item').click(function (event) {
        $('.ad-content-item').removeClass('active');
        $(this).addClass('active');
        $('html, body').animate({
            scrollTop: $($.attr(this, 'href')).offset().top
        }, 500);
        event.preventDefault();
    });

    // Multivendors Ads carousel
    $('.adt-multivendor-ads-carousel').each(function () {
        var $owl = $(this);
        var cols = parseInt($owl.data('columns')) || 4;
        $owl.owlCarousel({
            loop: false,
            rtl: $('html').attr('dir') === 'rtl',
            margin: 5,
            nav: true,
            navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
            dots: false,
            responsive: {
                0: {items: 1},
                576: {items: Math.min(2, cols)},
                768: {items: Math.min(3, cols)},
                992: {items: Math.min(4, cols)},
                1200: {items: cols}
            }
        });
    });

    // Multivendors Ads carousel
    $('.adt-multivendor-mini-ctg-carousel').owlCarousel({
        loop: true,
        rtl: is_rtl,
        margin: 20,
        nav: true,
        navText: ["<i class='fa fa-chevron-left'></i>", "<i class='fa fa-chevron-right'></i>"],
        dots: false,
        autoplayTimeout: 5000,
        autoplayHoverPause: false,
        responsive: {
            0: {
                items: 2
            }, 450: {
                items: 3
            }, 576: {
                items: 3
            }, 768: {
                items: 5
            }, 992: {
                items: 6
            }, 1200: {
                items: 8
            }, 1400: {
                items: 9
            }
        }
    });

    // Nice Scroll for Bids list
    if ($(".review-list-wrapper").length > 0) {
        $(".review-list-wrapper").niceScroll();
    }

    if ($(".bids-list-wrapper").length > 0) {
        $(".bids-list-wrapper").niceScroll();
    }


    let isInitializing = false;

    function initializeSelectedCategories() {
        if (typeof preselectedCategories !== 'undefined') {
            loading.show();
            isInitializing = true;
            let selectedCategoryIds = [...preselectedCategories.categories];
            let level = 1;

            async function handleCategoryLevels(parentId, level) {
                await fetchPreSelectedChildCategories(parentId, level);
                let selectId = 'ad_post_child_category_select_' + level;
                let select = $('#' + selectId);

                if (select.length && selectedCategoryIds.length > 0) {
                    let selectedId = selectedCategoryIds.shift();
                    select.val(selectedId);

                    if (selectedCategoryIds.length > 0) {
                        let nextLevel = level + 1;
                        let nextParentId = select.val();
                        await handleCategoryLevels(nextParentId, nextLevel);
                    }
                }
            }

            let topSelect = $('#ad_post_category_select');

            if (selectedCategoryIds.length > 0) {
                let firstSelected = selectedCategoryIds.shift();
                topSelect.val(firstSelected);
                checkCategorySelection();
                $('#child-category-container').empty();

                let isUpdate = "";
                if ($("#is_update").length > 0) {
                    isUpdate = $("#is_update").val();
                }
                $.post(ajaxurl, {
                    action: "sb_get_sub_cat",
                    cat_id: firstSelected,
                    is_update: isUpdate,
                }).done(function (response) {
                    if (response.success !== false) {
                        let selected_packages = response?.data?.selected_packages || "";
                        if (selected_packages !== "" && selected_packages !== null) {
                            $(".package-label").show();
                            $("#ad_post_packages_container").html(selected_packages);
                        }
                    } else {
                        toastr.error(response?.data?.message, "", {
                            timeOut: 5000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                        });
                    }
                }).fail(function (error) {
                    console.error('Error fetching selected packages:', error);
                });

                (async () => {
                    // await fetchChildCategories(firstSelected, level);
                    await handleCategoryLevels(firstSelected, level + 1);

                    let lastSelectedCategory = getLastSelectedCategory();
                    await saveSelectedCategory(lastSelectedCategory);
                    updateSelectedCategoriesDisplay();

                    loading.hide();
                    isInitializing = false;
                })();

            } else {
                loading.hide();
                isInitializing = false;
            }
        }
    }

    function fetchPreSelectedChildCategories(parentId, level) {
        let selectId = 'ad_post_child_category_select_' + level;
        let select = $('#' + selectId);

        if (select.length === 0) {
            $('#child-category-container').append('<div id="child-category-div-' + level + '">' +
                '<select name="' + selectId + '" id="' + selectId + '" class="default-select child-category-select" data-level="' + level + '">' +
                '<option value="">' + sb_options.select_option + '</option>' +
                '</select>' +
                '</div>');
            select = $('#' + selectId);
        } else {
            select.empty();
            select.append('<option value="">' + sb_options.select_option + '</option>');
        }

        return $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'get_child_categories',
                parent_id: parentId
            }
        }).then(response => {
            if (response.success) {
                let categories = response.data;
                $.each(categories, function (index, category) {
                    select.append('<option value="' + category.term_id + '">' + category.name + '</option>');
                });

                select.parent().show();
                select.select2();
                return Promise.resolve();
            } else {
                $('#child-category-div-' + level).remove();
                return Promise.resolve();
            }
        }).catch(error => {
            console.error('Error fetching child categories:', error);
            return Promise.reject(error);
        });
    }

    initializeSelectedCategories();

    function initializeAfterResponse() {
        $('select').select2();
        if ($("#ad_post_price_type").length > 0) {
            $("#ad_post_price_type").select2();

            $("#ad_post_price_type").on('change.select2', function () {
                let priceType = $("#ad_post_price_type").val();

                if (priceType == 'free' || priceType == "no_price" || priceType == "on_call") {
                    $(".ad_price_container").hide();
                    $(".price_range_container").hide();
                    $("#ad_price").removeAttr('required data-parsley-required');
                } else if (priceType == 'range') {
                    $(".ad_price_container").hide();
                    $(".price_range_container").show();
                    $("#ad_price_from, #ad_price_to").attr('required', 'required').attr('data-parsley-required', 'true');
                    $("#ad_price").removeAttr('required data-parsley-required');
                } else {
                    $(".ad_price_container").show();
                    $(".price_range_container").hide();
                    $("#ad_price").attr('required', 'required').attr('data-parsley-required', 'true');
                    $("#ad_price_from, #ad_price_to").removeAttr('required data-parsley-required');
                }
            });

            $("#ad_post_price_type").trigger('change.select2');
        }

        if ($("#ad_price").length > 0) {
        }

        function updateRadioStyles() {
            $("input[type=radio][name=ad_type]").each(function () {
                $("label[for='" + $(this).attr("id") + "']").css({
                    "color": "", "background-color": "", "border": ""
                });
            });

            $("input[type=radio][name=ad_type]:checked").each(function () {
                $("label[for='" + $(this).attr("id") + "']").css({
                    "color": "#fff", "background-color": sb_options.main_btn_color, "border": sb_options.main_btn_color
                });
            });
        }

        updateRadioStyles();

        $("#ad_type").on("change", "input[type=radio][name=ad_type]", function () {
            updateRadioStyles();
        });

        $("#warranty").on("change", "input[type=radio][name=ad_warranty]", function () {
            $("input[type=radio][name=ad_warranty]").each(function () {
                $("label[for='" + $(this).attr("id") + "']").css({
                    "color": "", "background-color": "", "border": ""
                });
            });

            $("input[type=radio][name=ad_warranty]:checked").each(function () {
                $("label[for='" + $(this).attr("id") + "']").css({
                    "color": "#fff", "background-color": sb_options.main_btn_color, "border": sb_options.main_btn_color
                });
            });
        });

        $("#condition").on("change", "input[type=radio][name=ad_condition]", function () {
            $("input[type=radio][name=ad_condition]").each(function () {
                $("label[for='" + $(this).attr("id") + "']").css({
                    "color": "", "background-color": "", "border": ""
                });
            });

            $("input[type=radio][name=ad_condition]:checked").each(function () {
                $("label[for='" + $(this).attr("id") + "']").css({
                    "color": "#fff", "background-color": sb_options.main_btn_color, "border": sb_options.main_btn_color
                });
            });
        });

        $('.adt-ads-range-slider').each(function () {
            let $slider = $(this);
            let min = parseFloat($slider.data('min'));
            let max = parseFloat($slider.data('max'));
            let step = parseFloat($slider.data('step'));
            let from = parseFloat($slider.data('from'));
            let to = parseFloat($slider.data('to'));

            $slider.ionRangeSlider({
                skin: 'round',
                type: 'double',
                min: min,
                max: max,
                step: step,
                from: from,
                to: to,
                hide_from_to: true,
                hide_min_max: true,
                onChange: function (data) {
                    let sliderId = $slider.attr('id');
                    let baseId = sliderId.replace('_slider', '');
                    let safeBaseId = $.escapeSelector(baseId);

                    $('#' + safeBaseId + '_min_display').text(data.from);
                    $('#' + safeBaseId + '_max_display').text(data.to);
                    $('#' + safeBaseId + '_min').val(data.from);
                    $('#' + safeBaseId + '_max').val(data.to);
                }
            });
        });
    }

    $("input[type=radio][name=ad_warrenty]").change(function () {

        $("input[type=radio][name=ad_warrenty]").each(function () {
            $("label[for=\'" + $(this).attr("id") + "\']").css({
                "color": "", "background-color": "", "border": ""
            });
        });

        if ($(this).is(":checked")) {
            $("label[for=\'" + $(this).attr("id") + "\']").css({
                "color": "#fff", "background-color": sb_options.main_btn_color, "border": sb_options.main_btn_color
            });
        }
    });

    $("input[type=radio][name=s-size]").change(function () {

        $("input[type=radio][name=s-size]").each(function () {
            $("label[for=\'" + $(this).attr("id") + "\']").css({
                "color": "", "background-color": "", "border": ""
            });
        });

        // Apply styles to the checked label
        if ($(this).is(":checked")) {
            $("label[for=\'" + $(this).attr("id") + "\']").css({
                "color": "#fff", "background-color": sb_options.main_btn_color, "border": sb_options.main_btn_color
            });
        }
    });

    $("input[type=radio][name=ad_condition]").change(function () {

        $("input[type=radio][name=ad_condition]").each(function () {
            $("label[for=\'" + $(this).attr("id") + "\']").css({
                "color": "", "background-color": "", "border": ""
            });
        });

        // Apply styles to the checked label
        if ($(this).is(":checked")) {
            $("label[for=\'" + $(this).attr("id") + "\']").css({
                "color": "#fff", "background-color": "#ff002e", "border": "1px solid #ff002e"
            });
        }
    });

    const classifiedButtons = document.querySelectorAll('.classified-nav-link');

    if (classifiedButtons.length > 0) {
        classifiedButtons.forEach(button => {
            button.addEventListener('click', function () {
                classifiedButtons.forEach(btn => {
                    btn.classList.remove('active');
                    btn.style.backgroundColor = '';
                });

                this.classList.add('active');
                this.style.backgroundColor = 'black';
            });
        });
    }

    $("#fav_product_btn").on('click', function () {
        $(".product-favourite-sb").slideToggle("slow");
    });

    async function saveSelectedCategory(lastSelectedCategory) {
        const adID = $("#ad_post_id_on_update").val();
        loading.show();
        await $.ajax({
            url: ajaxurl, type: 'POST', data: {
                action: 'save_selected_category',
                category_id: lastSelectedCategory.id,
                category_name: lastSelectedCategory.name.trim(),
                post_id: adID
            }, success: function (response) {
                if (response.success) {
                    $('#cat_temp_meta').val(response.data.id);
                    $('#selected-category-name').val(response.data.name);
                    $('#cat_template_html').html(response.data.category_template_html);
                    if (response.data.condition_and_value_fields) {
                        $("#ad_condition_and_warranty_box").html(response.data.condition_and_value_fields);
                    } else if(response.data.condition_and_value_fields == "") {
                        $("#ad_condition_and_warranty_box").html("");
                    }
                    if (response.data.tags_and_video_fields) {
                        $("#tags_and_video_link_box").html(response.data.tags_and_video_fields);
                    } else if(response.data.tags_and_video_fields == "") {
                        $("#tags_and_video_link_box").html("");
                    }
                    if (response.data.image_field) {
                        $(".ad_post_image_container").html(response.data.image_field);
                    }
                    if (response.data.custom_fields_html && response.data.custom_fields_html.length > 0) {
                        $("#custom_field_container").html(
                            `<h3>${sb_options.additional_fields_text}</h3>` + response.data.custom_fields_html
                        );
                    }

                    if (response.data.no_template_selected && response.data.default_template_on) {
                        if (response.data.default_template_html) {
                            $("#cat_template_html").html(response.data.default_template_html);
                        }

                        if (response.data.more_options) {
                            if (response.data.more_options.ad_images_on === 0) {
                                $(".ad_post_image_container").remove();
                            }
                            if (response.data.more_options.default_template_warranty_and_condition != "") {
                                $("#ad_condition_and_warranty_box").html(response.data.more_options.default_template_warranty_and_condition);
                            }
                            if (response.data.more_options.default_template_image_container != "") {
                                $(".ad_post_image_container").html(response.data.more_options.default_template_image_container);
                            }
                        }
                    }

                    if (response.data.default_template_on === false || sb_options.sb_default_adpost_template_on != "1") {
                        if(response.data.image_field !== "") {
                            adforest_dropzone_image();
                        }
                    }

                    if (sb_options.sb_default_adpost_template_on == "1" && response.data.default_template_on && sb_options.sb_default_adpost_template_images == "1") {
                        adforest_dropzone_image();
                    }
                    initializeAfterResponse();
                    if ($("#dropzone_video").length > 0) {
                        adforest_dropzone_video();
                    }
                    adforest_inputTags();
                    loading.hide();
                } else {
                    toastr.error('Error saving category.');
                }
				
				
			
				
				
				
				
				
				
				
            }, error: function (error) {
                loading.hide();
                toastr.error('Error saving category.');
            }
        });
        loading.hide();
    }

    function updateSelectedCategoriesDisplay() {
        let selectedCategories = [];

        let mainCategorySelect = $('#ad_post_category_select');
        if (mainCategorySelect.val()) {
            selectedCategories.push(mainCategorySelect.find('option:selected').text().trim());
        }

        $('.child-category-select').each(function () {
            let selectedText = $(this).find('option:selected').text().trim();
            if ($(this).val() && selectedText !== "Select Option") {
                selectedCategories.push(selectedText);
            }
        });

        let displayText = selectedCategories.join(' > ');

        let container = $('.ad-post-selected-categories');
        container.empty();

        if (displayText) {
            $('<div class="selected-category-path">' + displayText + '</div>').hide().appendTo(container).fadeIn(300);
        }

        let mobileContainer = $('.ad-post-selected-categories-mobile');
        mobileContainer.empty();

        if (displayText) {
            $('<div class="selected-category-path">' + displayText + '</div>').hide().appendTo(mobileContainer).fadeIn(300);
        }
    }

    $('#ad_post_category_select').on('change', async function () {
        if (isInitializing) return;

        checkCategorySelection();
        loading.show();
        let parentId = $(this).val();
        let level = 1;

        $('#child-category-container').empty();
        let isUpdate = "";
        if ($("#is_update").length > 0) {
            isUpdate = $("#is_update").val();
        }
        $.post(ajaxurl, {
            action: "sb_get_sub_cat",
            cat_id: parentId,
            is_update: isUpdate,
        }).done(function (response) {
            if (response.success === false) {
                loading.hide();
                toastr.error(response?.data?.message, response?.data?.title, {
                    timeOut: 5000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                });

                if (response?.data?.redirect) {
                    window.location.href = response.data.redirect;
                }
            } else {
                let selected_packages = response?.data?.selected_packages || "";
                if (selected_packages !== "" && selected_packages !== null) {
                    $(".package-label").show();
                    $("#ad_post_packages_container").html(selected_packages);
                }
            }
        });

        if (parentId) {
            await fetchChildCategories(parentId, level);
        }

        let lastSelectedCategory = getLastSelectedCategory();
        await saveSelectedCategory(lastSelectedCategory);
        updateSelectedCategoriesDisplay();
        loading.hide();
    });

    $(document).on('change', '.child-category-select', async function () {
        if (isInitializing) return;
        loading.show();
        let parentId = $(this).val();
        let level = $(this).data('level') + 1;

        if ($("#alert_category").length > 0) {
            $("#alert_category").val(parentId);
        }

        $('#child-category-container').find('div').filter(function () {
            return $(this).attr('id').split('-')[3] >= level;
        }).remove();

        if (parentId) {
            await fetchChildCategories(parentId, level);
        }

        let lastSelectedCategory = getLastSelectedCategory();
        saveSelectedCategory(lastSelectedCategory);
        updateSelectedCategoriesDisplay();
    });

    if ($("#adforest_login_user").length > 0) {
        $("#adforest_login_user").parsley().on("field:validated", function () {
            let ok = $(".parsley-error").length === 0;
        })
    }

    $("#adforest_login_user").on("submit", function (e) {
        const form = $(this);
        const button = $("#adforest_login_button");
        const is_captcha = $("#is_captcha").val();
        const spinner = button.find('#login-spinner-icon');

        e.preventDefault();

        if (form.parsley().isValid()) {
            button.prop('disabled', true);
            loading.show();

            let google_recaptcha_type = sb_options.google_recaptcha_type;

            google_recaptcha_type = typeof google_recaptcha_type !== "undefined" ? google_recaptcha_type : "v2";
            let google_recaptcha_site_key = sb_options.google_recaptcha_site_key;

            if (google_recaptcha_type === "v3" && google_recaptcha_site_key !== "undefined" && google_recaptcha_site_key !== "" && is_captcha === 'yes') {
                grecaptcha.ready(function () {
                    try {
                        grecaptcha
                            .execute(google_recaptcha_site_key, {action: "contact_form"})
                            .then(function (token) {
                                jQuery("#adforest_login_user").prepend('<input type="hidden" name="g-recaptcha-response" value="' + token + '">');

                                jQuery.post(ajaxurl, {
                                    action: "sb_google_captcha3_verification", token: token,
                                }, function (result) {
                                    result = JSON.parse(result);
                                    if (result.success) {
                                        $.post(ajaxurl, {
                                            action: "sb_login_user",
                                            security: $("#sb-login-token").val(),
                                            sb_data: form.serialize(),
                                        }).done(function (response) {
                                            button.prop('disabled', false);
                                            loading.hide();
                                            if ($.trim(response) == "1") {
                                                $("#sb_login_redirect").show();
                                                toastr.success("Redirecting...", "", {
                                                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                                                })
                                                window.location = sb_options.sb_after_login_page;
                                            } else {
                                                $("#sb_login_submit").show();
                                                button.prop('disabled', false);
                                                loading.hide();
                                                toastr.error(response, "", {
                                                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                                                });
                                            }
                                        }).fail(function () {
                                            button.prop('disabled', false);
                                            loading.hide();
                                        });
                                    } else {
                                        loading.hide();
                                        $("#sb_register_submit").show();
                                        toastr.error(result.msg, "", {
                                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                                        });
                                    }
                                });
                            });
                    } catch (err) {
                        let google_recaptcha_error_text = jQuery("#google_recaptcha_error_text").val();
                        google_recaptcha_error_text = typeof google_recaptcha_error_text !== "undefined" ? google_recaptcha_error_text : err;
                        jQuery("#sb_loading").hide();
                        toastr.error(google_recaptcha_error_text, "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    }
                })
            } else {
                $.post(ajaxurl, {
                    action: "sb_login_user", security: $("#sb-login-token").val(), sb_data: form.serialize(),
                }).done(function (response) {
                    button.prop('disabled', false);
                    loading.hide();
                    if ($.trim(response) == "1") {
                        $("#sb_login_redirect").show();
                        toastr.success("Redirecting...", "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        })
                        window.location = sb_options.sb_after_login_page;
                    } else {
                        $("#sb_login_submit").show();
                        button.prop('disabled', false);
                        loading.hide();
                        toastr.error(response, "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    }
                }).fail(function () {
                    button.prop('disabled', false);
                    loading.hide();
                });
            }
        }
    });

    if ($("#sb-forgot-form").length > 0) {
        $("#sb_forgot_msg").hide();
        $("#sb-forgot-form")
            .parsley()
            .on("field:validated", function () {
                var ok = $(".parsley-error").length === 0;
            })

        $("#sb-forgot-form").on('submit', function (e) {
            const form = $(this);
            $("#sb_forgot_submit").hide();
            $("#sb_forgot_msg").show();
            loading.show();
            $.post(ajaxurl, {
                action: "sb_forgot_password", security: $("#sb-forgot-pass-token").val(), sb_data: form.serialize(),
            }).done(function (response) {
                loading.hide();
                $("#sb_forgot_msg").hide();
                if ($.trim(response) == "1") {
                    $("#sb_forgot_submit").show();
                    $("#sb_forgot_email").val("");
                    toastr.success($("#adforest_forgot_msg").val(), "", {
                        timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                    });
                    $("#forgot_password_modal").modal("hide");
                } else {
                    $("#sb_forgot_submit").show();
                    toastr.error(response, "", {
                        timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                    });
                }
            }).fail(function () {
                $("#sb_forgot_submit").show();
                $("#sb_forgot_email").val("");
                toastr.error("NONCE ERROR", "", {
                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                });
            });
            return false;
        })
    }

    $("#show_more").on("click", function () {
        $("#cat-half-text").hide();
        $("#cat-full-text").show();
    });
    /*Register user*/
    if ($("#adforest-signup-form").length > 0) {
        $("#sb_register_msg").hide();
        $("#sb_register_redirect").hide();
        $("#adforest-signup-form")
            .parsley()
            .on("field:validated", function () {
                let ok = $(".parsley-error").length === 0;
            })
        $("#adforest-signup-form")
            .on("submit", function (e) {
                e.preventDefault();
                let form = $(this);
                loading.show();
                let google_recaptcha_type = sb_options.google_recaptcha_type;
                google_recaptcha_type = typeof google_recaptcha_type !== "undefined" ? google_recaptcha_type : "v2";
                let google_recaptcha_site_key = sb_options.google_recaptcha_site_key;
                if (google_recaptcha_type === "v3" && google_recaptcha_site_key !== "undefined" && google_recaptcha_site_key !== "") {
                    grecaptcha.ready(function () {
                        try {
                            grecaptcha
                                .execute(google_recaptcha_site_key, {action: "register_form"})
                                .then(function (token) {
                                    form.prepend('<input type="hidden" name="g-recaptcha-response" value="' + token + '">');
                                    jQuery.post(ajaxurl, {
                                        action: "sb_google_captcha3_verification",
                                        token: token
                                    }, function (result) {
                                        result = JSON.parse(result);
                                        if (result.success) {
                                            $("#sb_register_submit").hide();
                                            $("#sb_register_msg").show();
                                            $.post(ajaxurl, {
                                                action: "sb_register_user",
                                                security: $("#sb-register-token").val(),
                                                sb_data: form.serialize(),
                                            })
                                                .done(function (response) {
                                                    loading.hide();
                                                    $("#sb_register_msg").hide();
                                                    if ($.trim(response) == "1") {
                                                        $("#sb_register_redirect").show();
                                                        window.location = sb_options.sb_after_login_page;
                                                    } else if ($.trim(response) === "2" || $.trim(response) === 2) {
                                                        $(".resend_email").show();
                                                        toastr.success(sb_options.verify_account_msg, "", {
                                                            timeOut: 4000,
                                                            closeButton: true,
                                                            positionClass: "toast-top-right",
                                                        });
                                                    } else if ($.trim(response) == "3") {
                                                        toastr.success($("#admin_verify_account").val(), "", {
                                                            timeOut: 4000,
                                                            closeButton: true,
                                                            positionClass: "toast-top-right",
                                                        });
                                                    } else {
                                                        $("#sb_register_submit").show();
                                                        toastr.error(response, "", {
                                                            timeOut: 4000,
                                                            closeButton: true,
                                                            positionClass: "toast-top-right",
                                                        });
                                                    }
                                                })
                                                .fail(function () {
                                                    loading.hide();
                                                    $("#sb_register_msg").hide();
                                                    $("#sb_register_submit").show();
                                                    toastr.error($("#_nonce_error").val(), "", {
                                                        timeOut: 4000,
                                                        closeButton: true,
                                                        positionClass: "toast-top-right",
                                                    });
                                                });
                                        } else {
                                            loading.hide();
                                            $("#sb_register_submit").show();
                                            toastr.error(result.msg, "", {
                                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                                            });
                                        }
                                    });
                                });
                        } catch (err) {
                            var google_recaptcha_error_text = jQuery("#google_recaptcha_error_text").val();
                            google_recaptcha_error_text = typeof google_recaptcha_error_text !== "undefined" ? google_recaptcha_error_text : err;
                            jQuery("#sb_loading").hide();
                            toastr.error(google_recaptcha_error_text, "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                        }
                    });
                } else {
                    $("#sb_register_submit").hide();
                    $("#sb_register_msg").show();
                    $.post(ajaxurl, {
                        action: "sb_register_user", security: $("#sb-register-token").val(), sb_data: form.serialize(),
                    })
                        .done(function (response) {
                            loading.hide();
                            $("#sb_register_msg").hide();

                            if ($.trim(response) == "1") {
                                $("#sb_register_redirect").show();
                                window.location = sb_options.sb_after_login_page;
                            } else if ($.trim(response) === "2" || $.trim(response) === 2) {
                                $(".resend_email").show();
                                toastr.success(sb_options.verify_account_msg, "", {
                                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                                });
                            } else if ($.trim(response) == "3") {
                                toastr.success($("#admin_verify_account").val(), "", {
                                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                                });
                            } else {
                                $("#sb_register_submit").show();
                                toastr.error(response, "", {
                                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                                });
                            }
                        })
                        .fail(function () {
                            loading.hide();
                            $("#sb_register_msg").hide();
                            $("#sb_register_submit").show();
                            toastr.error($("#_nonce_error").val(), "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                        });
                }
                return false;
            });
    }
    /*Register user*/

    /*Resend Email*/
    $("#resend_email").on("click", function () {
        var usr_email = $("#sb_reg_email").val();
        $.post(ajaxurl, {
            action: "sb_resend_email",
            usr_email: usr_email,
        }).done(function (response) {
            toastr.success($("#verify_account_msg").val(), "", {
                timeOut: 4000,
                closeButton: true,
                positionClass: "toast-top-right",
            });
            $(".resend_email").hide();
            $(".contact_admin").show();
        });
    });

    if (sb_options.facebook_key != "" && sb_options.google_key != "") {
        hello.init(
            {facebook: sb_options.facebook_key, google: sb_options.google_key},
            {redirect_uri: sb_options.redirect_uri}
        );
    } else if (sb_options.facebook_key != "" && sb_options.google_key == "") {
        hello.init(
            {facebook: sb_options.facebook_key},
            {redirect_uri: sb_options.redirect_uri}
        );
    } else if (sb_options.google_key != "" && sb_options.facebook_key == "") {
        hello.init(
            {google: sb_options.google_key},
            {redirect_uri: sb_options.redirect_uri}
        );
    }
    $(".social-item a.btn-social").on("click", function () {
        hello.on("auth.login", function (auth) {
            $("#sb_loading").show();
            hello(auth.network)
                .api("me")
                .then(function (r) {
                    if (
                        $("#get_action").val() == "login" ||
                        $("#get_action").val() == "register"
                    ) {
                        var access_token = hello(auth.network).getAuthResponse()
                            .access_token;
                        var sb_network = hello(auth.network).getAuthResponse().network;
                        $.post(ajaxurl, {
                            action: "sb_social_login",
                            access_token: access_token,
                            sb_network: sb_network,
                            security: $("#sb-social-login-nonce").val(),
                            email: r.email,
                            key_code: $("#nonce").val(),
                        })
                            .done(function (response) {
                                var get_r = response.split("|");
                                if ($.trim(get_r[0]) == "1") {
                                    $("#nonce").val(get_r[1]);
                                    if ($.trim(get_r[2]) == "1") {
                                        toastr.success(get_r[3], "", {
                                            timeOut: 4000,
                                            closeButton: true,
                                            positionClass: "toast-top-right",
                                        });
                                        window.location = sb_options.sb_after_login_page;
                                    } else {
                                        toastr.error(get_r[3], "", {
                                            timeOut: 4000,
                                            closeButton: true,
                                            positionClass: "toast-top-right",
                                        });
                                    }
                                } else {
                                    toastr.error(get_r[3], "", {
                                        timeOut: 4000,
                                        closeButton: true,
                                        positionClass: "toast-top-right",
                                    });
                                }
                            })
                            .fail(function () {
                                $("#sb_loading").hide();
                                toastr.error($("#_nonce_error").val(), "", {
                                    timeOut: 4000,
                                    closeButton: true,
                                    positionClass: "toast-top-right",
                                });
                            });
                    } else {
                        $("#sb_reg_name").val(r.name);
                        $("#sb_reg_email").val(r.email);
                    }
                    $("#sb_loading").hide();
                });
        });
    });

    $(document).ready(function () {
        $('#search_hero_3_type_list input[type="radio"]').on('change', function () {
            $('#search_hero_3_type_list label').css({
                'background-color': '#f6f6f6',
                'color': '#6d6d6d'
            });

            if ($(this).is(':checked')) {
                $(this).next('label').css({
                    'background-color': sb_options.main_btn_color,
                    'color': sb_options.main_btn_hover_color_text
                });
            }
        });
    });

    // AD POST //
    $('.next-btn').on('click', function (event) {
        event.preventDefault();
        if (!$(this).hasClass('btn-adpost-start')) {
            $('html, body').scrollTop(0);
        }
        let isValid = true;

        if ($("#ad_post_category_select").length > 0 && $("#ad_post_category_select").val() === "") {
            isValid = false;
            toastr.error($("#select_cat_first").val(), "", {
                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
            });
        }
        const isUpdate = new URLSearchParams(window.location.search).has('id');

        if (!isUpdate && sb_options.pay_per_post_option != 1) {
            const isAdminAllowed = sb_options.admin_allow_unlimited_ads != 1;
            const isNotAdmin = sb_options.is_current_user_admin == "not_admin";

            if ((isNotAdmin || isAdminAllowed) && $('input.ads-package-radio:checked').length === 0) {
                isValid = false;
            }
        }

        $("[id^='ad_post_child_category_select_']").each(function () {
            const $childCategory = $(this);
            if ($childCategory.val() === "" && sb_options.sub_cat_option_select == 1) {
                isValid = false;
                toastr.error(sb_options.not_sub_cat_text, "", {
                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                });
                return false;
                disableNavLinks();
            } else {
                enableNavLinks();
            }
        });

        if (isValid) {
            let $active = $('.nav-pills .nav-link.active');
            let next = $active.closest('button').next('button');

            if (next.length > 0) {
                next.tab('show');
            }
        }
    });

    $('.prev-btn').on('click', function (event) {
        event.preventDefault();
        $('html, body').scrollTop(0);
        let $active = $('.nav-pills .nav-link.active');
        let $prev = $active.closest('button').prev('button');

        if ($prev.length > 0) {
            $prev.tab('show');
        }
    });

    // AD POST //

    async function fetchChildCategories(parentId, level) {
        await $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'get_child_categories',
                parent_id: parentId
            },
            success: function (response) {
                if (response.success) {
                    let categories = response.data;
                    let selectId = 'ad_post_child_category_select_' + level;
                    let select = $('#' + selectId);

                    if (select.length === 0) {
                        $('#child-category-container').append('<div id="child-category-div-' + level + '">' +
                            '<select name="' + selectId + '" id="' + selectId + '" class="default-select child-category-select" data-level="' + level + '">' +
                            '<option value="">' + sb_options.select_option + '</option>' +
                            '</select>' +
                            '</div>');
                        select = $('#' + selectId);
                    } else {
                        select.empty();
                        select.append('<option value="">' + sb_options.select_option + '</option>');
                    }

                    $.each(categories, function (index, category) {
                        select.append('<option value="' + category.term_id + '">' + category.name + '</option>');
                    });

                    select.parent().show();
                    select.select2();
                } else {
                    $('#child-category-div-' + level).remove();
                }
            },
            error: function (error) {
                console.log(error);
            }
        });
    }

    // Function to get the last selected category
    function getLastSelectedCategory() {
        let lastSelectedCategory = {id: null, name: ''};

        let mainCategorySelect = $('#ad_post_category_select');
        if (mainCategorySelect.val()) {
            lastSelectedCategory.id = mainCategorySelect.val();
            lastSelectedCategory.name = mainCategorySelect.find('option:selected').text();
        }

        $('.child-category-select').each(function () {
            if ($(this).val()) {
                lastSelectedCategory.id = $(this).val();
                lastSelectedCategory.name = $(this).find('option:selected').text();
            }
        });

        return lastSelectedCategory;
    }

    function disableNavLinks() {
        $('.ad-post-tabs button').each(function () {
            if (!$(this).hasClass('active')) {
                $(this).prop('disabled', true);
                $(this).css('color', '#c4c4c4');
            }
        });
    }

    function enableNavLinks() {
        $('.ad-post-tabs button').prop('disabled', false);
        $('.ad-post-tabs button').css('color', '#555555');
    }

    function checkCategorySelection() {
        if ($('#ad_post_category_select').val() === '') {
            disableNavLinks();
            return false;
        } else {
            enableNavLinks();
            return true;
        }
    }

    checkCategorySelection();

    $('.nav-link[data-tab-target]').on('click', function (event) {
        if (!checkCategorySelection()) {
            event.preventDefault();
            event.stopPropagation();
        }
    });

    if ($("#adforest-ad-post-form").length > 0) {
        $("#adforest-ad-post-form")
            .parsley()
            .on("field:validated", function () {
                const $field = $(this.$element);
                const $tab = $field.closest('.tab-pane');
                const tabId = $tab.attr('id');
                const $navLink = $('[data-bs-target="#' + tabId + '"]');

                if (this.validationResult !== true) {
                    $navLink.addClass('has-warning');
                } else {
                    $navLink.removeClass('has-warning');
                }
            })
            .on("form:error", function () {
                $(".ad_errors").show();
                $(".parsley-errors-list").show();

                const errorMessages = [];
                const tabsWithErrors = [];

                $(".tab-pane").each(function () {
                    const $tab = $(this);
                    const tabId = $tab.attr('id');
                    const $navLink = $('[data-bs-target="#' + tabId + '"]');
                    const tabTitle = $navLink.text().trim() || 'Tab';

                    if ($tab.find('.parsley-error').length > 0) {
                        $navLink.addClass('has-warning');
                        tabsWithErrors.push(tabTitle);

                        $tab.find('.parsley-error').each(function () {
                            const $errorField = $(this);
                            const fieldLabel = $errorField.closest('.form-group, .label-box').find('label').text().trim();

                            $errorField.find('.parsley-errors-list li').each(function () {
                                const errorText = $(this).text().trim();
                                if (errorText && fieldLabel) {
                                    errorMessages.push(`${fieldLabel}: ${errorText}`);
                                } else if (errorText) {
                                    errorMessages.push(errorText);
                                }
                            });
                        });
                    }
                });

                if (tabsWithErrors.length > 0) {
                    let toastrTitle = sb_options.form_validation_error;
                    let toastrMessage = "";

                    if (tabsWithErrors.length === 1) {
                        toastrTitle = `${sb_options.error_in} ${tabsWithErrors[0]}`;

                        if (errorMessages.length > 0) {
                            if (errorMessages.length === 1) {
                                toastrMessage = errorMessages[0];
                            } else if (errorMessages.length <= 3) {
                                toastrMessage = errorMessages.join('<br>');
                            } else {
                                toastrMessage = `${errorMessages.length} ${sb_options.fields_need_attention}`;
                            }
                        } else {
                            toastrMessage = sb_options.fill_all_fields;
                        }
                    } else {
                        toastrTitle = sb_options.multiple_validation_errors;
                        toastrMessage = `${sb_options.check_following_tabs}: ${tabsWithErrors.join(', ')}`;
                    }

                    toastr.error(
                        toastrMessage,
                        toastrTitle,
                        {
                            timeOut: 8000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                            escapeHtml: false,
                            progressBar: true
                        }
                    );

                    if (tabsWithErrors.length > 0) {
                        const firstErrorTabId = $(".tab-pane").filter(function () {
                            return $(this).find('.parsley-error').length > 0;
                        }).first().attr('id');

                        if (firstErrorTabId) {
                            const $firstErrorNavLink = $('[data-bs-target="#' + firstErrorTabId + '"]');
                            if ($firstErrorNavLink.length > 0) {
                                setTimeout(() => {
                                    $firstErrorNavLink.tab('show');

                                    const $firstErrorField = $('#' + firstErrorTabId).find('.parsley-error').first();
                                    if ($firstErrorField.length > 0) {
                                        $('html, body').animate({
                                            scrollTop: $firstErrorField.offset().top - 100
                                        }, 500);
                                    }
                                }, 300);
                            }
                        }
                    }
                } else {
                    toastr.error(
                        "Please fill in all required fields correctly",
                        "Form Validation Error",
                        {
                            timeOut: 5000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                        }
                    );
                }
            })

        function getFormValidationErrors() {
            const errors = [];
            const tabErrors = {};

            $("#adforest-ad-post-form").find('.parsley-error').each(function () {
                const $field = $(this);
                const $tab = $field.closest('.tab-pane');
                const tabId = $tab.attr('id');
                const tabTitle = $('[data-bs-target="#' + tabId + '"]').text().trim() || 'Unknown Tab';
                const fieldName = $field.attr('name') || $field.attr('id') || 'Unknown Field';
                const fieldLabel = $field.closest('.form-group, .label-box').find('label').text().trim() || fieldName;

                if (!tabErrors[tabTitle]) {
                    tabErrors[tabTitle] = [];
                }

                $field.find('.parsley-errors-list li').each(function () {
                    const errorText = $(this).text().trim();
                    if (errorText) {
                        tabErrors[tabTitle].push({
                            field: fieldLabel,
                            error: errorText
                        });
                    }
                });
            });

            return tabErrors;
        }

        function showCustomValidationToastr() {
            const errors = getFormValidationErrors();
            const tabNames = Object.keys(errors);

            if (tabNames.length === 0) {
                return;
            }

            if (tabNames.length === 1) {
                const tabName = tabNames[0];
                const tabErrors = errors[tabName];

                let message = '';
                if (tabErrors.length === 1) {
                    message = `${tabErrors[0].field}: ${tabErrors[0].error}`;
                } else if (tabErrors.length <= 3) {
                    message = tabErrors.map(err => `${err.field}: ${err.error}`).join('<br>');
                } else {
                    message = `${tabErrors.length} fields in ${tabName} need attention`;
                }

                toastr.error(message, `Error in ${tabName}`, {
                    timeOut: 8000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                    escapeHtml: false,
                    progressBar: true
                });
            } else {
                toastr.error(
                    `Please check the following sections: ${tabNames.join(', ')}`,
                    "Multiple Validation Errors",
                    {
                        timeOut: 8000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                        progressBar: true
                    }
                );
            }
        }

        $('#ad_country').on('change', function () {
            $(this).parsley().validate();
        });

        $("#adforest-ad-post-form").on('submit', function (event) {
            event.preventDefault();
            if (isImageRequired == 1 && uploadedImages === 0) {
                toastr.error(sb_options.images_required_error, "", {
                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                });
                return;
            }
            if (!checkCategorySelection()) {
                return;
            } else {
                loading.show();
                $.post(ajaxurl, {
                    action: "sb_ad_posting",
                    security: $("#adforest-post-token").val(),
                    sb_data: $("form#adforest-ad-post-form").serialize(),
                    is_update: $("#is_update").val(),
                }).done(function (response) {
                    loading.hide();
                    if ($.trim(response) == "0") {
                        toastr.error(sb_options.not_logged_in, "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    } else if ($.trim(response) == "1") {
                        toastr.error($("#ad_limit_msg").val(), "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                        // window.location = $("#adforest_packages_page").val();
                    } else if ($.trim(response) == "img_req") {
                        toastr.error(sb_options.required_images, "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    } else if ($.trim(response) == "2") {
                        toastr.error(sb_options.demo_mode, "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    } else if ($.trim(response) == "10") {
                        toastr.error(sb_options.select_package, "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    } else if ($.trim(response) == "11") {
                        toastr.error(sb_options.val_not_found, "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    } else if ($.trim(response) == "no_product_pay_per_post") {
                        toastr.error(sb_options.pay_per_post_option_no_products, "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    } else {
                        if ($("#is_update").val() != "undefined" && $("#is_update").val() != "") {
                            toastr.success(sb_options.ad_update_success, "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                        } else {
                            toastr.success(sb_options.ad_posted, "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                        }
                        window.location = response;
                    }
                })
                    .fail(function () {
                        loading.hide();
                        // toastr.error($("#_nonce_error").val(), "", {
                        toastr.error(sb_options._nonce_error, "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    });
                return false;
            }
        })
    }

    $('.toggle-contact-number').on('click', function () {
        loading.show();
        let $this = $(this);
        let adId = $this.data('ad-id');
        let $phoneNumberSpan = $this.siblings('.phone-number');
        let $phoneNumberSpan2 = $this.siblings('.style_2_ph');

        $.post(ajaxurl, {
            action: "sb_display_phone_num_user", ad_id: adId,
        }).done(function (response) {
            response = response.trim();
            let res = response.split("|");
            if (res[0] === '1') {
                $phoneNumberSpan.html(res[1]);
                $phoneNumberSpan2.html(res[1]);
                $this.css('pointer-events', 'none').css('opacity', '0.5');
            } else {
                toastr.error(res[1], "", {
                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                });
            }
            loading.hide();
        });
    });

    $('.click-to-view_ph').on('click', function () {
        loading.show();
        let user_id = jQuery(this).data("user_id");
        let nonce = jQuery(this).data("nonce");
        let $phoneNumber = $(this).siblings('.phone-number');

        $.post(ajaxurl, {
            action: "sb_display_phone_num_profile",
            user_id: user_id,
            nonce: nonce
        }).done(function (response) {
            loading.hide();
            let get_r = response.split("|");
            if ($.trim(get_r[0]) == "1") {
                $phoneNumber.show();
                $phoneNumber.html(get_r[1]);
                $phoneNumber.is(':visible') ? $('.click-to-view_ph').hide() : $('.click-to-view_ph').show();
            } else {
                toastr.error(get_r[1], "", {
                    timeOut: 4000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                });
            }
        }).fail(function(response) {
            loading.hide();
            toastr.error("You need to login first.", "Request failed", {
                timeOut: 4000,
                closeButton: true,
                positionClass: "toast-top-right",
            });
        });
    });

    /* ============================
     * Pay Per Post ad Post adforest
     ==============================*/
    if ($("#pay_per_post_ad_form").length > 0) {
        $("#pay_per_post_ad_form").on("submit", function (e) {
            e.preventDefault();
            var package_id = $('input[name="package"]:checked').val();
            var pid = $("#pid").val();

            $("#sb_loading").show();
            $.post(ajaxurl, {
                action: "pay_per_post_ad_posting",
                security: $("#sb-post-ppp-token").val(),
                package_id: package_id,
                pay_per_post_id: pid,
            }).done(function (response) {

                if (true === response.success) {
                    $("#sb_loading").show();
                    toastr.success(response.data.message, "", {
                        timeOut: 8000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                        showMethod: "slideDown",
                        hideMethod: "slideUp",
                    });
                    if (response.data.url) {
                        location.replace(response.data.url);
                    } else {
                        setTimeout(function () {
                            location.reload(true);
                            $("#sb_loading").show();
                        }, 600);
                    }
                } else {
                    $(".loader-outer").hide();
                    toastr.error(response.data.message, "", {
                        timeOut: 8000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                        showMethod: "slideDown",
                        hideMethod: "slideUp",
                    });
                }
            });
        });
    }

    /* ============================
     * Feature ad Pad adforest
     ==============================*/
    if ($("#feature_ad_form").length > 0) {
        $("#feature_ad_form").on("submit", function (e) {
            event.preventDefault();
            var package = $('input[name="package"]:checked').val();
            var pid = $("#pid").val();

            $("#sb_loading").show();
            $.post(ajaxurl, {
                action: "feature_ad_posting",
                security: $("#sb-post-feature-token").val(),
                package_id: package,
                featured_id: pid,
            }).done(function (response) {
                if (true === response.success) {
                    $("#sb_loading").show();
                    toastr.success(response.data.message, "", {
                        timeOut: 8000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                        showMethod: "slideDown",
                        hideMethod: "slideUp",
                    });
                    if (response.data.url) {
                        location.replace(response.data.url);
                    } else {
                        setTimeout(function () {
                            location.reload(true);
                            $("#sb_loading").show();
                        }, 600);
                    }
                } else {
                    $(".loader-outer").hide();
                    toastr.error(response.data.message, "", {
                        timeOut: 8000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                        showMethod: "slideDown",
                        hideMethod: "slideUp",
                    });
                }
            });
        });
    }

    /* ============================
     * Bump up ad Pade adforest
     ==============================*/
    if ($("#bumup_ad_form").length > 0) {
        $("#bumup_ad_form").on("submit", function (e) {
            event.preventDefault();
            var package = $('input[name="package"]:checked').val();
            var pid = $("#pid").val();

            $("#sb_loading").show();
            $.post(ajaxurl, {
                action: "bumup_ad_posting",
                security: $("#sb-post-bumpup-token").val(),
                package_id: package,
                bump_up_id: pid,
            }).done(function (response) {

                if (true === response.success) {
                    $("#sb_loading").show();
                    toastr.success(response.data.message, "", {
                        timeOut: 8000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                        showMethod: "slideDown",
                        hideMethod: "slideUp",
                    });
                    if (response.data.url) {
                        location.replace(response.data.url);
                    } else {
                        setTimeout(function () {
                            location.reload(true);
                            $("#sb_loading").show();
                        }, 600);
                    }
                } else {
                    $(".loader-outer").hide();
                    toastr.error(response.data.message, "", {
                        timeOut: 8000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                        showMethod: "slideDown",
                        hideMethod: "slideUp",
                    });
                }
            });
        });
    }

    function adforest_dropzone_image() {
        if ($("#img_dropzone").get(0).dropzone) return;

        if ($("#img_dropzone").length) {
            Dropzone.autoDiscover = false;
            let is_update_val = $("#is_update").val();
            let images_ajax_callback = `${ajaxurl}?action=upload_ad_images&is_update=${is_update_val}`;

            if (ajaxurl.indexOf("?lang=") !== -1) {
                images_ajax_callback = `${ajaxurl}?action=upload_ad_images&is_update=${is_update_val}`;
            }

            let acceptedFileTypes = "image/jpeg,image/png,image/jpg";
            let i = 0;
            let sb_max_files = typeof $("#sb_upload_limit").val() !== "undefined" && $("#sb_upload_limit").val() === "null" ? null : $("#sb_upload_limit").val();

            $("#img_dropzone").dropzone({
                timeout: 5000000,
                maxFilesize: 50000000,
                addRemoveLinks: true,
                paramName: "my_file_upload",
                maxFiles: sb_max_files,
                acceptedFiles: acceptedFileTypes,
                dictMaxFilesExceeded: $("#adforest_max_upload_reach").val(),
                url: images_ajax_callback,
                parallelUploads: 1,
                dictDefaultMessage: $("#dictDefaultMessage").val(),
                dictFallbackMessage: $("#dictFallbackMessage").val(),
                dictFallbackText: $("#dictFallbackText").val(),
                dictFileTooBig: $("#dictFileTooBig").val(),
                dictInvalidFileType: $("#dictInvalidFileType").val(),
                dictResponseError: $("#dictResponseError").val(),
                dictCancelUpload: $("#dictCancelUpload").val(),
                dictCancelUploadConfirmation: $("#dictCancelUploadConfirmation").val(),
                dictRemoveFile: $("#dictRemoveFile").val(),
                dictRemoveFileConfirmation: null,
                init: function () {
                    let thisDropzone = this;


                    $.post(ajaxurl, {
                        action: "get_uploaded_ad_images", is_update: is_update_val,
                    }).done(function (data) {
                        if (data && typeof data === "object" && Object.keys(data).length > 0) {
                            $.each(data, function (key, value) {
                                let mockFile = {name: value.dispaly_name, size: value.size};
                                thisDropzone.options.addedfile.call(thisDropzone, mockFile);
                                thisDropzone.options.thumbnail.call(thisDropzone, mockFile, value.name);
                                $("a.dz-remove:eq(" + i + ")").attr("data-dz-remove", value.id);
                                i++;
                                uploadedImages++;
                                $(".dz-progress").remove();
                            });
                        }
                        if (i > 0) $(".dz-message").hide(); else $(".dz-message").show();
                    });

                    this.on("addedfile", function () {
                        uploadedImages++;
                        $(".dz-message").hide();
                    });

                    this.on("removedfile", function (file) {
                        let img_id = file._removeLink.attributes[2].value;
                        if (img_id !== "") {
                            uploadedImages--; // Decrease the image count
                            if (i === 0) $(".dz-message").show();
                            $.post(ajaxurl, {
                                action: "delete_ad_image", img: img_id, is_update: is_update_val,
                            }).done(function (response) {
                                if ($.trim(response) === "1") {
                                    toastr.success("Image Removed Successfully.", "", {
                                        timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                                    });
                                }
                            });
                        }
                    });

                    this.on("success", function (file, responseText) {
                        let res_arr = responseText.split("|");
                        if ($.trim(res_arr[0]) !== "0") {
                            $("a.dz-remove:eq(" + i + ")").attr("data-dz-remove", responseText);
                            i++;
                            $(".dz-message").hide();
                        } else {
                            if (i === 0) $(".dz-message").show();
                            this.removeFile(file);
                            toastr.error(res_arr[1], "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                        }
                    });

                    this.on("maxfilesexceeded", function (file) {
                        toastr.error($("#max_upload_images").val(), "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                        this.removeFile(file);
                    });
                }
            });
        }
    }

    function adforest_dropzone_video() {
        if ($("#dropzone_video").get(0).dropzone) return;

        if ($("#dropzone_video").length) {
            let videoLogoUrl = $("#video_logo_url").val();
            Dropzone.autoDiscover = false;
            let video_ajax_callback =
                ajaxurl +
                "?action=upload_ad_videos&is_update=" +
                $("#is_update").val();
            if (ajaxurl.indexOf("?lang=") !== -1) {
                video_ajax_callback =
                    ajaxurl +
                    "&action=upload_ad_videos&is_update=" +
                    $("#is_update").val();
            }
            let acceptedFileTypes = "video/mp4,video/ogg,video/webm";
            let i = 0;
            let sb_max_files =
                typeof $("#sb_upload_video_limit").val() !== "undefined" &&
                $("#sb_upload_video_limit").val() === "null"
                    ? null
                    : $("#sb_upload_video_limit").val();

            $("#dropzone_video").dropzone({
                timeout: 5000000,
                maxFilesize: 50000000,
                addRemoveLinks: true,
                paramName: "my_single_video_upload",
                maxFiles: sb_max_files,
                acceptedFiles: acceptedFileTypes,
                dictMaxFilesExceeded: $("#adforest_max_upload_reach").val(),
                url: video_ajax_callback,
                parallelUploads: 1,
                dictDefaultMessage: $("#dictDefaultMessage").val(),
                dictFallbackMessage: $("#dictFallbackMessage").val(),
                dictFallbackText: $("#dictFallbackText").val(),
                dictFileTooBig: $("#dictFileTooBig").val(),
                dictInvalidFileType: $("#dictInvalidFileType").val(),
                dictResponseError: $("#dictResponseError").val(),
                dictCancelUpload: $("#dictCancelUpload").val(),
                dictCancelUploadConfirmation: $("#dictCancelUploadConfirmation").val(),
                dictRemoveFile: $("#dictRemoveFile").val(),
                dictRemoveFileConfirmation: null,
                init: function () {
                    let thisDropzone = this;

                    // Fetch previously uploaded Videos if any
                    $.post(ajaxurl, {
                        action: "get_uploaded_video",
                        is_update: $("#is_update").val(),
                    }).done(function (data) {
                        if (typeof data !== "undefined" && data !== 0) {
                            $.each(data, function (key, value) {
                                let mockFile = {
                                    name: value.video_name,
                                    size: value.video_size,
                                };
                                thisDropzone.options.addedfile.call(thisDropzone, mockFile);
                                thisDropzone.options.thumbnail.call(
                                    thisDropzone,
                                    mockFile,
                                    videoLogoUrl
                                );
                                $("a.dz-remove:eq(" + i + ")").attr(
                                    "data-dz-remove",
                                    value.video_id
                                );
                                i++;
                                $(".dz-progress").remove();
                            });
                        }
                        if (i > 0) $(".dz-message").hide();
                        else $(".dz-message").show();
                    });

                    this.on("addedfile", function (file) {
                        $(".dz-message").hide();
                    });
                    this.on("success", function (file, responseText) {
                        let res_arr = responseText.split("|");
                        if ($.trim(res_arr[0]) !== "0") {
                            $("a.dz-remove:eq(" + i + ")").attr(
                                "data-dz-remove",
                                responseText
                            );
                            i++;
                            $(".dz-message").hide();
                        } else {
                            if (i === 0) $(".dz-message").show();
                            this.removeFile(file);
                            toastr.error(res_arr[1], "", {
                                timeOut: 4000,
                                closeButton: true,
                                positionClass: "toast-top-right",
                            });
                        }
                    });
                    this.on("removedfile", function (file) {
                        let img_id = file._removeLink.attributes[2].value;
                        if (img_id !== "") {
                            i--;
                            if (i === 0) $(".dz-message").show();
                            $.post(ajaxurl, {
                                action: "delete_upload_video",
                                video: img_id,
                                is_update: $("#is_update").val(),
                            }).done(function (response) {
                                if ($.trim(response) === "1") {
                                    /*this.removeFile(file);*/
                                }
                            });
                        }
                    });
                    this.on("maxfilesexceeded", function (file) {
                        toastr.error($("#adforest_max_upload_reach").val(), "", {
                            timeOut: 4000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                        });
                        this.removeFile(file);
                    });
                },
            });
        }
    }

    /* ad post on create ad ID for ad title */
    $("#ad_title").on("blur", function () {
        if ($("#is_update").val() === "") {
            $.post(ajaxurl, {
                action: "create_ad_id_for_title", title: $("#ad_title").val(), is_update: $("#is_update").val(),
            }).done(function (response) {
            });
        }
    });

    $(".make_feature_admin_unlimited").on("click", function () {
        let adId = $(this).attr('data-ad-id');
		loading.show();
        $.post(ajaxurl, {
            action: "make_ad_featured_admin",
            ad_id: adId,
        }).done(function (response) {
			loading.hide();
            if (response.success) {
                toastr.success(response.data.message || "Ad marked as featured successfully!");
                setTimeout(function () {
                    location.reload();
                }, 1500);
            } else {
                toastr.error(response.data.message || "Something went wrong.");
            }
        }).fail(function () {
			loading.hide();
            toastr.error("AJAX request failed.");
        });
    });

    /* ad post on create ad ID for ad title */

    function adforest_inputTags() {
        let total_tags = $("#tags_count").val();
        if (typeof total_tags === "undefined" || total_tags == "") {
            total_tags = 0;
        }
        if ($("#tags").length !== "undefined" && $("#tags").length > 0) {
            $("#tags").tagsInput({
                width: "100%", height: "5px;", defaultText: "", onAddTag: function (elem, elem_tags) {
                    total_tags = parseInt(total_tags) + 1;
                    if (total_tags > sb_options.adforest_tags_limit_val) {
                        alert(sb_options.adforest_tags_limit);
                        $(this).removeTag(elem);
                    }
                }, onRemoveTag: function () {
                    total_tags = parseInt(total_tags) - 1;
                },
            });
        }
        if ($("#is_update").val() == "" && $(".dynamic-form-date-fields").length > 0) {
            if ($(".dynamic-form-date-fields").length > 0) {
                $(".dynamic-form-date-fields").datepicker({
                    timepicker: false, dateFormat: "yyyy-mm-dd", language: {
                        days: [get_strings.Sunday, get_strings.Monday, get_strings.Tuesday, get_strings.Wednesday, get_strings.Thursday, get_strings.Friday, get_strings.Saturday,],
                        daysShort: [get_strings.Sun, get_strings.Mon, get_strings.Tue, get_strings.Wed, get_strings.Thu, get_strings.Fri, get_strings.Sat,],
                        daysMin: [get_strings.Su, get_strings.Mo, get_strings.Tu, get_strings.We, get_strings.Th, get_strings.Fr, get_strings.Sa,],
                        months: [get_strings.January, get_strings.February, get_strings.March, get_strings.April, get_strings.May, get_strings.June, get_strings.July, get_strings.August, get_strings.September, get_strings.October, get_strings.November, get_strings.December,],
                        monthsShort: [get_strings.Jan, get_strings.Feb, get_strings.Mar, get_strings.Apr, get_strings.May, get_strings.Jun, get_strings.Jul, get_strings.Aug, get_strings.Sep, get_strings.Oct, get_strings.Nov, get_strings.Dec,],
                        today: get_strings.Today,
                        clear: get_strings.Clear,
                        dateFormat: "mm/dd/yyyy",
                    },
                });
            }
        }
    }

    $("#ad_bidding").on("change", function () {
        if ($("#ad_bidding").val() == "1") {
            $(".biddind_div").show();
        } else {
            $(".biddind_div").hide();
        }
    });
    $("#ad_bidding_date").datepicker({
        timepicker: true,
        dateFormat: "yy-mm-dd",
        timeFormat: "hh:ii:00",
        language: {
            days: [
                sb_options.Sunday,
                sb_options.Monday,
                sb_options.Tuesday,
                sb_options.Wednesday,
                sb_options.Thursday,
                sb_options.Friday,
                sb_options.Saturday,
            ],
            daysShort: [
                sb_options.Sun,
                sb_options.Mon,
                sb_options.Tue,
                sb_options.Wed,
                sb_options.Thu,
                sb_options.Fri,
                sb_options.Sat,
            ],
            daysMin: [
                sb_options.Su,
                sb_options.Mo,
                sb_options.Tu,
                sb_options.We,
                sb_options.Th,
                sb_options.Fr,
                sb_options.Sa,
            ],
            months: [
                sb_options.January,
                sb_options.February,
                sb_options.March,
                sb_options.April,
                sb_options.May,
                sb_options.June,
                sb_options.July,
                sb_options.August,
                sb_options.September,
                sb_options.October,
                sb_options.November,
                sb_options.December,
            ],
            monthsShort: [
                sb_options.Jan,
                sb_options.Feb,
                sb_options.Mar,
                sb_options.Apr,
                sb_options.May,
                sb_options.Jun,
                sb_options.Jul,
                sb_options.Aug,
                sb_options.Sep,
                sb_options.Oct,
                sb_options.Nov,
                sb_options.Dec,
            ],
            today: sb_options.Today,
            clear: sb_options.Clear,
            firstDay: 0,
        },
        minDate: new Date(),
    });

    /* Ad Location */
    if ($("#ad_lat").length > 0) {
        let lat = $("#ad_lat").val();
        let lon = $("#ad_lon").val();
        let map_type = sb_options.adforest_map_type;
        if (map_type === "leafletjs_map") {
            /*For leafletjs map*/
            let map = L.map("itemMap").setView([lat, lon], 7);
            L.tileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", {
                attribution: "",
            }).addTo(map);
            L.marker([lat, lon]).addTo(map);
        } else if (map_type === "google_map") {
            /*For Google Map*/
            let map = "";
            let latlng = new google.maps.LatLng(lat, lon);
            let myOptions = {
                zoom: 13,
                center: latlng,
                scrollwheel: false,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
                size: new google.maps.Size(480, 240),
            };
            map = new google.maps.Map(document.getElementById("itemMap"), myOptions);
            let marker = new google.maps.Marker({
                map: map, position: latlng,
            });
        } else if (map_type === "map_box") {
            mapboxgl.accessToken = sb_options.map_box_token;
            let map = new mapboxgl.Map({
                container: "itemMap",
                style: "mapbox://styles/mapbox/streets-v11",
                center: [lon, lat],
                zoom: 9,
            });
            new mapboxgl.Marker().setLngLat([lon, lat]).addTo(map);
        }
    }

    $(".sb_show_pass").on("click", function (event) {
        event.preventDefault();

        var passwordField = $("input[name='sb_reg_password']");
        var iconField = $(".sb_show_pass i");
        if (passwordField.attr("type") == "text") {
            passwordField.attr("type", "password");
            iconField.addClass("fa-eye");
            iconField.removeClass("fa-eye-slash");
        } else if (passwordField.attr("type") == "password") {
            passwordField.attr("type", "text");
            iconField.removeClass("fa-eye");
            iconField.addClass("fa-eye-slash");
        }
    });

    $(".sb_show_pass2").on("click", function (event) {
        event.preventDefault();

        let passwordField = $("input[name='sb_reg_password_confirm']");
        let iconField = $(".sb_show_pass2 i");
        if (passwordField.attr("type") == "text") {
            passwordField.attr("type", "password");
            iconField.addClass("fa-eye");
            iconField.removeClass("fa-eye-slash");
        } else if (passwordField.attr("type") == "password") {
            passwordField.attr("type", "text");
            iconField.removeClass("fa-eye");
            iconField.addClass("fa-eye-slash");
        }
    });

    if ($("#file_attacher").length > 0) {
        let attachmentsDropzone = new Dropzone(document.getElementById("file_attacher"), {
            url: ajaxurl,
            autoProcessQueue: true,
            previewsContainer: "#attachment-wrapper", // Define the container to display the previews
            previewTemplate: '<span class="dz-preview dz-file-preview"><span class="dz-details"><span class="dz-filename"><i class="fa fa-link"></i>   <span data-dz-name></span></span>   <span class="dz-size" data-dz-size></span>   <i class="fa fa-times" style="cursor:pointer;font-size:15px;" data-dz-remove></i></span><span class="dz-progress"><span class="dz-upload" data-dz-uploadprogress></span></span><i class="ti ti-refresh ti-spin"></i></span>',
            clickable: "a.msgAttachFile",
            acceptedFiles: $("#provided_format").val(),
            maxFilesize: 15,
            maxFiles: 4,
        });

        attachmentsDropzone.on("sending", function () {
            $("#send_msg ,#send_ad_message").attr("disabled", true);
        });
        attachmentsDropzone.on("queuecomplete", function () {
            $("#send_msg, #send_ad_message").attr("disabled", false);
        });
    }

    /* Bidding System  */
    if ($("#sb_bid_ad").length > 0) {
        $("#sb_bid_ad")
            .parsley()
            .on("field:validated", function () {
                let ok = $(".parsley-error").length === 0;
            });

        $("#sb_bid_ad").on("submit", function (event) {
            event.preventDefault();
            let form = $(this);
            loading.show();
            $.post(ajaxurl, {
                action: "sb_submit_bid", security: $("#sb-bidding-token").val(), sb_data: form.serialize(),
            })
                .done(function (response) {
                    loading.hide();
                    let res_arr = response.split("|");
                    if ($.trim(res_arr[0]) != "0") {
                        toastr.success(res_arr[1], "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                        location.reload();
                    } else {
                        toastr.error(res_arr[1], "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    }
                })
                .fail(function () {
                    loading.hide();
                    toastr.error($("#_nonce_error").val(), "", {
                        timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                    });
                });
            return false;
        });
    }

    if ($("#input-21b").length > 0) {
        let star_rtl = false;
        if ($("#is_rtl").val() != "" && $("#is_rtl").val() == "1") {
            star_rtl = true;
        }
        $("#input-21b").rating({
            filledStar: '<i class="fill fas fa-star"></i>', emptyStar: '<i class="far fa-star"></i>', starCaptions: {
                1: sb_options.one, 2: sb_options.two, 3: sb_options.three, 4: sb_options.four, 5: sb_options.five,
            },
        });
    }

    $('.chat_toggler_popup').on('click', () => {
        let message = $('.chat_toggler_popup').attr('data-pt-title');
        if (typeof message !== "undefined") toastr.error(message, "", {
            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
        });
    })
    /*Send message to ad owner*/
    if ($("#send_message_pop").length > 0) {
        $("#send_message_pop")
            .parsley()
            .on("field:validated", function () {
            })

        $("#send_message_pop").on("submit", function (event) {
            event.preventDefault();
            let form = $(this);
            loading.show();
            let fd = new FormData();
            if ($("#file_attacher").length > 0) {
                let fileUpload = $("#file_attacher").get(0).dropzone;
                let files = fileUpload.files;
                for (let i = 0; i < files.length; i++) {
                    fd.append("message_file[]", files[i]);
                }
            }
            let sb_data = form.serialize();
            let security = $("#sb-msg-token").val();
            fd.append("action", "sb_send_message");
            fd.append("sb_data", sb_data);
            fd.append("security", security);
            loading.show();
            $.ajax({
                type: "POST",
                url: ajaxurl,
                data: fd,
                contentType: false,
                processData: false,
                success: function (response) {
                    loading.hide();
                    let get_r = response.split("|");
                    if ($.trim(get_r[0]) == "1") {
                        toastr.success(get_r[1], "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                        $("#sb_forest_message").val("");

                        if ($(".dz-preview").length > 0) {
                            Dropzone.forElement("#file_attacher").removeAllFiles(true);
                            $(".dz-preview").remove();
                            $(".dz-success").fadeOut("slow");
                        }
                        $(".close").trigger("click");
                    } else {
                        toastr.error(get_r[1], "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                        $(".close").trigger("click");
                        []
                    }
                },
                error: function () {
                    loading.hide();
                    toastr.error($("#_nonce_error").val(), "", {
                        timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                    });
                },
            });

            return false;
        });
    }

    /* Ad rating Logic */
    if ($("#ad_rating_form").length > 0) {
        $("#ad_rating_form").parsley().on("field:validated", function () {
            // Validation logic
        });
        $("#ad_rating_form").on("submit", function (event) {
            event.preventDefault();
            loading.show();
            let form = $(this);
            let fileInput = document.getElementById("files");
            let formSerialized = form.serialize();
            let formData = new FormData();
            formData.append("formdata", formSerialized);
            formData.append("action", "sb_ad_rating");
            if (fileInput !== null && fileInput.files.length > 0) {
                fileInput = $("#files")[0].files[0];
                formData.append("file", fileInput);
            }
            // Use Parsley.js to prevent form submission
            let parsleyForm = form.parsley();
            if (parsleyForm.isValid()) {
                $.post({
                    url: ajaxurl, type: "POST", data: formData, processData: false, contentType: false,
                })
                    .done(function (response) {
                        loading.hide();
                        let get_r = response.split("|");
                        if ($.trim(get_r[0]) == "1") {
                            toastr.success(get_r[1], "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                            location.reload();
                        } else {
                            toastr.error(get_r[1], "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                        }
                    })
                    .fail(function () {
                        loading.hide();
                        toastr.error($("#_nonce_error").val(), "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    });
            }
            return false; // Prevent default behavior
        });
    }

    $(".reply_ad_rating").on("click", function () {
        var p_comment_id = $(this).attr("data-comment_id");
        $("#reply_to_rating").html($(this).attr("data-commenter-name"));
        $("#parent_comment_id").val(p_comment_id);
    });

    /*Send message to ad owner*/
    if ($("#rating_reply_form").length > 0) {
        $("#rating_reply_form").parsley().on("field:validated", function () {
        });
        $("#rating_reply_form").on("submit", function () {
            loading.show();
            let form = $(this);
            $.post(ajaxurl, {
                action: "sb_ad_rating_reply", security: $("#sb-review-reply-token").val(), sb_data: form.serialize(),
            })
                .done(function (response) {
                    loading.hide();
                    var get_r = response.split("|");
                    if ($.trim(get_r[0]) == "1") {
                        toastr.success(get_r[1], "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                        location.reload();
                    } else {
                        toastr.error(get_r[1], "", {
                            timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                        });
                    }
                })
                .fail(function () {
                    loading.hide();
                    toastr.error($("#_nonce_error").val(), "", {
                        timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                    });
                });
            return false;
        });
    }

    /* Emoji Reaction Against Reviews  */
    $(".Emoji").on("click", function () {
        let reaction_id = $(this).data("reaction");
        let c_id = $(this).data("cid");
        $("#reaction-loader-" + c_id).show();
        $.post(ajaxurl, {
            action: "adforest_ads_rating_reaction", r_id: reaction_id, c_id: c_id,
        }).done(function (response) {
            $("#reaction-loader-" + c_id).hide();

            let get_r = response.split("|");
            if ($.trim(get_r[0]) == "0") {
                toastr.error($.trim(get_r[1]), "", {
                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                });
                return false;
            } else {
                if (reaction_id === 1) {
                    $(".emoji-count.likes-" + c_id).text(response);
                }
                if (reaction_id === 2) {
                    $(".emoji-count.loves-" + c_id).text(response);
                }
                if (reaction_id === 3) {
                    $(".emoji-count.wows-" + c_id).text(response);
                }
                if (reaction_id === 4) {
                    $(".emoji-count.angrys-" + c_id).text(response);
                }
            }
        });
        return false;
    });

    /*ad ads to favourite*/
    $(".ad_to_fav,.save-ad").on("click", function () {
        let $this = $(this);
        loading.show();
        $.post(ajaxurl, {
            action: "sb_fav_ad", ad_id: $(this).attr("data-adid"),
        }).done(function (response) {
            loading.hide();
            let get_p = response.split("|");
            if ($.trim(get_p[0]) == "1") {
                $this.addClass("ad-favourited");
                toastr.success(get_p[1], "", {
                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                });
                location.reload();
            } else {
                toastr.error(get_p[1], "", {
                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                });
            }
        });
    });

    /*Report Ad*/
    $("#sb_mark_it").on("click", function () {
        loading.show();
        $.post(ajaxurl, {
            action: "sb_report_ad",
            option: $("#report_option").val(),
            comments: $("#report_comments").val(),
            ad_id: $("#ad_id").val(),
        }).done(function (response) {
            loading.hide();
            let get_r = response.split("|");
            if ($.trim(get_r[0]) == "1") {
                toastr.success(get_r[1], "", {
                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                });
                $(".report-quote").modal("hide");
            } else {
                toastr.error(get_r[1], "", {
                    timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                });
                $(".report-quote").modal("hide");
            }
        });
    });

    /* Ad Custom Locations */
    $("#ad_country").on("change", function () {
        loading.show();
        $.post(ajaxurl, {
            action: "sb_get_sub_states", country_id: $("#ad_country").val(),
        }).done(function (response) {
            loading.hide();
            $("#ad_country_states").val("");
            $("#ad_country_cities").val("");
            $("#ad_country_towns").val("");
            if ($.trim(response) != "") {
                $("#ad_country_id").val($("#ad_cat").val());
                $("#ad_country_sub_div").show();
                $("#ad_country_states").html(response);
                $("#ad_country_sub_sub_sub_div").hide();
                $("#ad_country_sub_sub_div").hide();
            } else {
                $("#ad_country_sub_div").hide();
                $("#ad_cat_sub_sub_div").hide();
                $("#ad_country_sub_sub_div").hide();
                $("#ad_country_sub_sub_sub_div").hide();
            }
        });
    });
    /* Level 2 */
    $("#ad_country_states").on("change", function () {
        loading.show();
        $.post(ajaxurl, {
            action: "sb_get_sub_states", country_id: $("#ad_country_states").val(),
        }).done(function (response) {
            loading.hide();
            $("#ad_country_cities").val("");
            $("#ad_country_towns").val("");
            if ($.trim(response) != "") {
                $("#ad_country_id").val($("#ad_country_states").val());
                $("#ad_country_sub_sub_div").show();
                $("#ad_country_cities").html(response);
                $("#ad_country_sub_sub_sub_div").hide();
            } else {
                $("#ad_country_sub_sub_div").hide();
                $("#ad_country_sub_sub_sub_div").hide();
            }
        });
    });
    /* Level 3 */
    $("#ad_country_cities").on("change", function () {
        loading.show();
        $.post(ajaxurl, {
            action: "sb_get_sub_states", country_id: $("#ad_country_cities").val(),
        }).done(function (response) {
            loading.hide();
            $("#ad_country_towns").val("");
            if ($.trim(response) != "") {
                $("#ad_country_id").val($("#ad_country_cities").val());
                $("#ad_country_sub_sub_sub_div").show();
                $("#ad_country_towns").html(response);
            } else {
                $("#ad_country_sub_sub_sub_div").hide();
            }
        });
    });
    /* Ad Custom Locations */

    /* Contact from profile  */
    if ($("#user_contact_form").length > 0) {
        $("#user_contact_form")
            .parsley()
            .on("field:validated", function () {
                let ok = $(".parsley-error").length === 0;
            })
            .on("form:submit", function () {
                let adforest_ajax_url = ajaxurl;
                loading.show();

                let google_recaptcha_type = sb_options.google_recaptcha_type;

                google_recaptcha_type = typeof google_recaptcha_type !== "undefined" ? google_recaptcha_type : "v2";
                let google_recaptcha_site_key = sb_options.google_recaptcha_site_key;

                if (google_recaptcha_type === "v3" && google_recaptcha_site_key !== "undefined" && google_recaptcha_site_key !== "") {
                    grecaptcha.ready(function () {
                        try {
                            grecaptcha
                                .execute(google_recaptcha_site_key, {action: "contact_form"})
                                .then(function (token) {
                                    jQuery("#user_contact_form").prepend('<input type="hidden" name="g-recaptcha-response" value="' + token + '">');

                                    jQuery.post(adforest_ajax_url, {
                                        action: "sb_google_captcha3_verification", token: token,
                                    }, function (result) {
                                        result = JSON.parse(result);
                                        if (result.success) {
                                            $.post(adforest_ajax_url, {
                                                action: "sb_user_contact_form",
                                                receiver_id: $("#receiver_id").val(),
                                                sb_data: $("form#user_contact_form").serialize(),
                                            }).done(function (response) {
                                                loading.hide();
                                                let res_arr = response.split("|");
                                                if ($.trim(res_arr[0]) != "0") {
                                                    toastr.success(res_arr[1], "", {
                                                        timeOut: 4000,
                                                        closeButton: true,
                                                        positionClass: "toast-top-right",
                                                    });
                                                    location.reload();
                                                } else {
                                                    toastr.error(res_arr[1], "", {
                                                        timeOut: 4000,
                                                        closeButton: true,
                                                        positionClass: "toast-top-right",
                                                    });
                                                }
                                            });
                                        } else {
                                            loading.hide();
                                            $("#sb_register_submit").show();
                                            toastr.error(result.msg, "", {
                                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                                            });
                                        }
                                    });
                                });
                        } catch (err) {
                            let google_recaptcha_error_text = jQuery("#google_recaptcha_error_text").val();
                            google_recaptcha_error_text = typeof google_recaptcha_error_text !== "undefined" ? google_recaptcha_error_text : err;
                            jQuery("#sb_loading").hide();
                            toastr.error(google_recaptcha_error_text, "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                        }
                    });
                } else {
                    $.post(adforest_ajax_url, {
                        action: "sb_user_contact_form",
                        receiver_id: $("#receiver_id").val(),
                        sb_data: $("form#user_contact_form").serialize(),
                    }).done(function (response) {
                        loading.hide();
                        let res_arr = response.split("|");
                        if ($.trim(res_arr[0]) != "0") {
                            toastr.success(res_arr[1], "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                            location.reload();
                        } else {
                            toastr.error(res_arr[1], "", {
                                timeOut: 4000, closeButton: true, positionClass: "toast-top-right",
                            });
                        }
                    });
                }
                return false;
            });
    }

    $('#sort_sellers').on('change', function () {
        const selectedSort = $(this).val();
        const currentUrl = new URL(window.location.href);

        currentUrl.searchParams.set('sort', selectedSort);

        window.location.href = currentUrl.toString();
    });

    $('#sort_vendors').on('change', function () {
        const selectedSort = $(this).val();
        const currentUrl = new URL(window.location.href);

        currentUrl.searchParams.set('sort', selectedSort);

        window.location.href = currentUrl.toString();
    });

    $('#search_seller_form').on('submit', function (e) {
        e.preventDefault();
        loading.show();
        $('.adt-seller-cards-grid').html('');
        $('.sellers_found_heading').html('');
        $('.adt-custom-pagination').html('');

        let searchQuery = $('#search').val();
        let rating = $('#input-21b').val();

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'fetch_sellers',
                search: searchQuery,
                rating,
                paged: 1
            },
            success: function (response) {
                if (response.data.total_users > 0) {
                    $('.adt-seller-cards-grid').removeClass('nothing-found-search');
                    $('.adt-seller-cards-grid').html(response.data.html);
                    $('.sellers_found_heading').text(response.data.total_users + " Sellers Found:");
                    $('.adt-custom-pagination').html(response.data.pagination);
                } else {
                    $('.adt-seller-cards-grid').addClass('nothing-found-search');
                    $('.adt-seller-cards-grid').html(response.data.html);
                    $('.sellers_found_heading').text(response.data.total_users + " Sellers Found:");
                    $('.adt-custom-pagination').html(response.data.pagination);
                }
                loading.hide();
            }
        });
    });

    /* ======================
     * vendor favourites/un-favourites
     ========================*/
    $(".vendor_to_fav").on("click", function () {
        $(this).toggleClass("favourited_v");
        var status_class = $(this).hasClass("favourited_v");
        var status_code;
        if (status_class == true) {
            status_code = "true";
        } else {
            status_code = "false";
        }
        $("#sb_loading").show();
        $.post(ajaxurl, {
            action: "vendor_fav_ad",
            vendor_id: $(this).attr("data-vendorid"),
            status_code: status_code,
        }).done(function (response) {
            $("#sb_loading").hide();
            var get_p = response.split("|");
            if ($.trim(get_p[0]) == 1) {
                toastr.success(get_p[1], "", {
                    timeOut: 4000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                });
            } else if ($.trim(get_p[0]) == 0) {
                toastr.error(get_p[1], "", {
                    timeOut: 4000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                });
            }
        });
    });

    if ($("#vendro-owner-contact").length > 0) {
        $("#vendro-owner-contact")
            .parsley()
            .on("field:validated", function () {
                var ok = $(".parsley-error").length === 0;
            })
            .on("form:submit", function () {
                $("#sb_loading").show();
                $.post(ajaxurl, {
                    action: "sb_send_email_to_store_vendor",
                    sb_data: $("form.vendro-owner-contact").serialize(),
                    vendor_id: $("#vendor_id").val(),
                }).done(function (response) {
                    $("#sb_loading").hide();
                    var res_arr = response.split("|");

                    if ($.trim(res_arr[0]) != "0") {
                        toastr.success(res_arr[1], "", {
                            timeOut: 4000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                        });
                    } else {
                        toastr.error(res_arr[1], "", {
                            timeOut: 4000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                        });
                    }
                });
                return false;
            });
    }

    $(document).on('click', '.seller_pagination a.page-link', function (e) {
        e.preventDefault();
        let data_paged = $(this).attr('data-page');
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'fetch_sellers',
                search: $('#search').val(),
                paged: data_paged,
                rating: $('#input-21b').val(),
            },
            success: function (response) {
                $('.adt-seller-cards-grid').html(response?.data.html);
                $('.adt-ads-sort-box h3').text(response.data.total_users + " Sellers Found:");
                $('.adt-custom-pagination').html(response?.data.pagination);
            }
        });
    });

    $('#get-location').on('click', function () {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(showPosition, showError);
        } else {
            alert("Geolocation is not supported by this browser.");
        }
    });

    function showPosition(position) {
        loading.show();
        let lat = position.coords.latitude;
        let lng = position.coords.longitude;

        let pos = new google.maps.LatLng(lat, lng);
        let geocoder = new google.maps.Geocoder();
        geocoder
            .geocode({
                location: {
                    lat: lat,
                    lng: lng
                }
            })
            .then((response) => {
                loading.hide();
                $("#radius-search").val(response.results[0].formatted_address);
            });
    }

    function showError(error) {
        switch (error.code) {
            case error.PERMISSION_DENIED:
                alert("User denied the request for Geolocation.");
                break;
            case error.POSITION_UNAVAILABLE:
                alert("Location information is unavailable.");
                break;
            case error.TIMEOUT:
                alert("The request to get user location timed out.");
                break;
            case error.UNKNOWN_ERROR:
                alert("An unknown error occurred.");
                break;
        }
    }

    $("#you_current_location_text").click(function () {
        loading.show();
        $.ajax({
            url: "https://geolocation-db.com/jsonp",
            jsonpCallback: "callback",
            dataType: "jsonp",
            success: function (location) {
                loading.hide();
                $("#sb-radius-form #sb_user_address").val(
                    location.city + ", " + location.state + ", " + location.country_name
                );
                $("#sb_user_address").val(
                    location.city + ", " + location.state + ", " + location.country_name
                );
                var map_type = sb_options.adforest_map_type;
                if (map_type == "leafletjs_map") {
                    $("#sb_user_address_lat").val(location.latitude);
                    $("#sb_user_address_long").val(location.longitude);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                loading.hide();
                console.log("Request failed: " + textStatus + ", " + errorThrown);
                toastr.error("Failed to retrieve location. Please try again later.");
            }
        });
    });

    /* Validating Registration process */
    if ($('#sb-radius-form').length > 0) {
        $('#sb-radius-form').parsley().on('field:validated', function () {
            let ok = $('.parsley-error').length === 0;
        }).on('form:submit', function () {
        });
    }

    $('.category_click_link').on('click', function () {
        let cat_s_id = $(this).attr('data-cat-id');
        if (cat_s_id !== "") {
            $('#cat_id').val(cat_s_id);
            loading.show();
            $('#cats_response').html('');
            $.post(ajaxurl, {
                action: 'sb_get_sub_cat_search',
                cat_id: cat_s_id,
            }).done(function (response) {
                loading.hide();
                if ($.trim(response) === 'submit') {
                    $('#cat_modal').modal('hide');
                    $('#search_cats_w').submit();
                } else {
                    $('#cats_response').html(response);
                    $('#cat_modal').modal('show');
                }
            });
        }
    });

    $(document).on('click', '#ajax_cat', function () {
        loading.show();

        let cat_s_id = $(this).attr('data-cat-id');
        $('#cat_id').val(cat_s_id);
        $.post(ajaxurl, {
            action: 'sb_get_sub_cat_search',
            cat_id: cat_s_id,
        }).done(function (response) {
            loading.hide();
            if ($.trim(response) === 'submit') {
                $('#cat_modal').modal('hide');
                $('#search_cats_w').submit();
            } else {
                $('#cats_response').html(response)
            }
        });
    });

    $(document).on('click', '#ad-search-btn', function () {
        $('#search_cats_w').submit();
    });

    $(document).ready(function () {
        const urlParams = new URLSearchParams(window.location.search);
        const adTypeParam = urlParams.get('ad_type');
        if (adTypeParam) {
            $('input[type="radio"][value="' + adTypeParam + '"]').prop('checked', true);
        }
        $('input[type="radio"].submit-on-change').on('change', function () {
            $('#ad_type_form').submit();
        });
    });

    $(document).ready(function () {
        const urlParams = new URLSearchParams(window.location.search);
        const adConditionParam = urlParams.get('condition');
        if (adConditionParam) {
            $('input[type="radio"][value="' + adConditionParam + '"]').prop('checked', true);
        }
        $('input[type="radio"].submit-on-condition-change').on('change', function () {
            $('#ad_condition_form').submit();
        });
    });

    $(document).ready(function () {
        const urlParams = new URLSearchParams(window.location.search);
        const adWarrantyParam = urlParams.get('warranty');
        if (adWarrantyParam) {
            $('input[type="radio"][value="' + adWarrantyParam + '"]').prop('checked', true);
        }
        $('input[type="radio"].submit-on-warranty-change').on('change', function () {
            $('#ad_warranty_form').submit();
        });
    });

    $(document).ready(function () {
        const urlParams = new URLSearchParams(window.location.search);
        const adCurrencyParam = urlParams.get('ad_currency');
        if (adCurrencyParam) {
            $('input[type="radio"][value="' + adCurrencyParam + '"]').prop('checked', true);
        }
        $('input[type="radio"].submit-on-currency-change').on('change', function () {
            $('#ad_currency_form').submit();
        });
    });

    jQuery(document).ready(function ($) {
        $('#select-sort').on('select2:select', function () {
            $('#sort-form').submit();
        });

        let urlParams = new URLSearchParams(window.location.search);
        let selectedSort = urlParams.get('sort');

        if (selectedSort) {
            $('#select-sort').val(selectedSort);
        }
    });


    $(document).on('click', '.sb_make_feature_ad_detail_page', async function () {
        loading.show();
        adID = $(this).attr('data-aaa-id');
        let formId = "make_ad_featured";
        let ad_packages = await fetchAdPackages(ajaxurl, adID, formId);
        loading.hide();

        $.dialog({
            title: sb_options.select_package,
            content: ad_packages,
            theme: 'Material',
            closeIcon: true,
            animation: 'scale',
            type: 'blue',
        });
    });

    $(document).on('submit', '#make_ad_featured', function (e) {
        e.preventDefault();
        loading.show();

        let modalBtn = $(".feature_modal_btn");
        modalBtn.attr('disabled', true).text('Processing...');

        let ad_id = $(this).find('input[name="ad_id"]').val();
        let ads_package = $(this).find('input[name="ads_package"]:checked').val();

        $.ajax({
            url: ajaxurl,
            method: 'POST',
            data: {
                action: 'sb_make_featured_detail',
                ad_id: ad_id,
                ads_package: ads_package,
            },
            success: function (response) {
                modalBtn.attr('disabled', false).text('Submit');
                loading.hide();

                if (response.success) {
                    toastr.success(response.data.message, '', {
                        timeOut: 4000,
                        "closeButton": true,
                        "positionClass": "toast-top-right"
                    });
                    if (response.data.url) {
                        location.replace(response.data.url);
                    } else {
                        window.location.reload();
                    }
                } else {
                    toastr.error(response.data.message, '', {
                        timeOut: 4000,
                        "closeButton": true,
                        "positionClass": "toast-top-right"
                    });
                }
            },
            error: function (error) {
                modalBtn.attr('disabled', false).text('Submit');
                loading.hide();
                console.log("Error submitting form", error);
            }
        });
    });

    async function fetchAdPackages(adforest_ajax_url, adID, formId) {
        let result;
        try {
            result = await $.ajax({
                url: adforest_ajax_url,
                type: 'POST',
                data: {
                    action: 'load_feature_ad_modal',
                    adID,
                    formId
                }
            });
            return result;
        } catch (error) {
            console.error(error);
        }
    }

    $("select.submit_on_select").on("select2:select", function (e) {
        loading.show();
        $(this).closest("form").submit();
    });
    $(".submit_on_select").on("click", function () {
        loading.show();
        $(this).closest("form").submit();
    });

    jQuery(document).ready(function ($) {
        let loading = false;
        let loadingMode = $('#load-more-ads-btn').data('loading-mode');
        let searchQuery = $('#load-more-ads-btn').data('search-query');
        let adCount = $('#load-more-ads-btn').data('ad-count');
        let postsPerPage = $('#load-more-ads-btn').data('posts-per-page');
        let searchPageType = $('#load-more-ads-btn').data('search-page');
        let viewType = $('#load-more-ads-btn').data('view-type');
        let paged = 2;

        function loadMoreAds() {
            if (loading) return;
            loading = true;
            $("#sb_loading").show();

            $.ajax({
                type: 'POST',
                url: ajaxurl,
                data: {
                    action: 'load_more_ads',
                    search_query: JSON.stringify(searchQuery),
                    paged: paged,
                    view_type: viewType
                },
                beforeSend: function () {
                    if (loadingMode === 'show_more') {
                        $('#load-more-ads-btn').text('Loading...');
                    }
                },
                success: function (response) {
                    $("#sb_loading").hide();
                    if (response.trim() == '0') {
                        $('#no_more_ads_p').html(
                            '<div role="alert" class="alert alert-info alert-dismissible">' +
                            '<i class="fa fa-info-circle"></i>' +
                            '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>' +
                            sb_options.no_more_ads +
                            '</div>'
                        );
                        if (loadingMode === 'show_more') {
                            $('#load-more-ads-btn').text(sb_options.no_more_ads).prop('disabled', true).hide();
                        }
                    } else {
                        if (searchPageType === 'map') {
                            $('.search-ads-result-box').append(response);
                        }
                        if (viewType === 'list') {
                            $('.adt-search-ads-list').append(response);
                        } else {
                            $('.adt-search-ads-grid').append(response);
                        }
                        if (loadingMode === 'show_more') {
                            $('#load-more-ads-btn').text(sb_options.show_more_btn_text).show();
                        }
                        paged++;
                        loading = false;
                    }
                }
            });
        }

        if (loadingMode === 'show_more') {
            if (adCount < postsPerPage) {
                $('#load-more-ads-btn').hide();
            } else {
                $('#load-more-ads-btn').show();
            }
            $('#load-more-ads-btn').on('click', function () {
                loadMoreAds();
            });
        } else if (loadingMode === 'infinity_scroll') {
            $('#load-more-ads-btn').hide();
            $('.adt-search-ads-grid').on('scroll', function () {
                if ($(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight - 100) {
                    loadMoreAds();
                }
            });
            $('.adt-search-ads-list').on('scroll', function () {
                if ($(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight - 100) {
                    loadMoreAds();
                }
            });
            $('.search-content-side').on('scroll', function () {
                if ($(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight - 100) {
                    loadMoreAds();
                }
            });
        }
    });

    $('.reset-search').on('click', function () {
        $(this).closest('form')[0].reset();

        $('select[name="cat_id"]').val(null).trigger('change');
    });

    $('#topbar_categories').on('select2:select', (e) => {
        let selectedData = e.params.data;
        let cat_s_id = selectedData.element.getAttribute('data-cat-id');

        if (cat_s_id !== "" && typeof (cat_s_id) !== 'undefined' && cat_s_id !== null) {
            $('#cat_id').val(cat_s_id);
            loading.show();
            $('#cats_response').html('');
            $.post(ajaxurl, {
                action: 'sb_get_sub_cat_search',
                cat_id: cat_s_id,
            }).done(function (response) {
                loading.hide();
                if ($.trim(response) === 'submit') {
                    $('#cat_modal').modal('hide');
                    $('#search_cats_w').submit();
                } else {
                    $('#cats_response').html(response);
                    $('#cat_modal').modal('show');
                }
            });
        }
    })

    $('#topbar_countries').on('select2:select', (e) => {
        let selectedData = e.params.data;
        let country_s_id = selectedData.element.getAttribute('data-country-id');

        if (country_s_id !== "" && typeof (country_s_id) !== 'undefined' && country_s_id !== null) {
            $('#country_id').val(country_s_id);
            loading.show();
            $('#countries_response').html('');
            $.post(ajaxurl,
                {
                    action: 'get_related_cities',
                    country_id: country_s_id,
                }
            ).done(function (response) {
                loading.hide();
                if ($.trim(response) === 'submit') {
                    $('#search_countries').submit();
                } else {
                    $('#states_model').modal('show');
                    $('#countries_response').html(response);
                }
            });
        }
    })

    $(document).on('click', '#ajax_states', function () {
        loading.show();
        let cat_s_id = $(this).attr('data-country-id');
        $('#country_id').val(cat_s_id);
        $.post(ajaxurl, {
            action: 'get_related_cities',
            country_id: cat_s_id,
        }).done(function (response) {
            loading.hide();
            if ($.trim(response) === 'submit') {
                $('#search_countries').submit();
            } else {
                $('#countries_response').html(response);
            }
        });
    });
    $(document).on('click', '#country-btn', function () {
        $('#search_countries').submit();
    });

    $("#topbar_search_currency").on('select2:select', () => {
        $("#ad_currency_form").submit();
    })
    $("#topbar_ad_type").on('select2:select', () => {
        $("#ad_type_form").submit();
    })

    $("#ad-condition-topbar").on('select2:select', () => {
        $("#ad_condition_form").submit();
    })

    $("#ad-warranty-topbar").on('select2:select', () => {
        $("#ad_warranty_form").submit();
    })

    $('.adv-srch').on('click', function () {
        $('.hide_adv_search').slideToggle();

        if ($(this).find('i').hasClass('fa-times')) {
            $(this).html('Advance Search');
        } else {
            $(this).html('Close <i class="fa fa-times"></i>');
        }
    });

    /*initilize jquery text editor */
    let ad_html_switch = $("#adforest_ad_html").val();
    ad_html_switch = typeof ad_html_switch !== "undefined" && ad_html_switch == "1" ? true : false;
    if ($("#ad_description").length > 0) {
        if (ad_html_switch) {
            $("#ad_description").jqte({color: false});
        } else {
            $("#ad_description").jqte({
                link: false,
                unlink: false,
                formats: false,
                format: false,
                funit: false,
                fsize: false,
                fsizes: false,
                color: false,
                strike: false,
                source: false,
                sub: false,
                sup: false,
                indent: false,
                outdent: false,
                right: true,
                left: true,
                center: true,
                remove: false,
                rule: false,
                title: false,
            });
        }
    }

    /* ======================
     * Product favourites/un-favourites shop layout 5
     ========================*/
    $(".product_to_fav").on("click", function () {
        $(this).toggleClass("favourited");
        var status_class = $(this).hasClass("favourited");
        var status_code;
        if (status_class == true) {
            status_code = "true";
        } else {
            status_code = "false";
        }
        $("#sb_loading").show();
        $.post(ajaxurl, {
            action: "product_fav_add",
            product_id: $(this).attr("data-productId"),
            status_code: status_code,
        }).done(function (response) {
            $("#sb_loading").hide();
            var get_p = response.split("|");
            if ($.trim(get_p[0]) == 1) {
                toastr.success(get_p[1], "", {
                    timeOut: 4000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                });
            } else if ($.trim(get_p[0]) == 0) {
                toastr.error(get_p[1], "", {
                    timeOut: 4000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                });
            }
        });
    });

    $('#increase-quantity').on('click', function () {
        let quantity = $('#product-quantity');
        quantity.innerText = parseInt(quantity.innerText) + 1;
    });

    $('#decrease-quantity').on('click', function () {
        let quantity = $('#product-quantity');
        let currentQuantity = parseInt(quantity.innerText);
        if (currentQuantity > 1) {
            quantity.innerText = currentQuantity - 1;
        }
    });

    $('#product-review-form').on('submit', function (e) {
        loading.show();
        e.preventDefault();
        let formData = $(this).serialize();
        $.ajax({
            url: ajaxurl,
            type: "POST",
            data: formData,
            success: function (response) {
                loading.hide();
                if (response.success) {
                    toastr.success(response.data.message, '', {
                        timeOut: 4000,
                        "closeButton": true,
                        "positionClass": "toast-top-right"
                    });
                    $('#product-review-form')[0].reset();
                } else {
                    toastr.error(response.data.message, '', {
                        timeOut: 4000,
                        "closeButton": true,
                        "positionClass": "toast-top-right"
                    });
                }
            }
        });
    });

    let $quantity = $('#product-quantity');
    let defaultQty = parseInt($quantity.data('default-qty'), 10);
    let currentQty = defaultQty;

    $('#increase-quantity').on('click', function () {
        currentQty++;
        $quantity.text(currentQty);
    });

    $('#decrease-quantity').on('click', function () {
        if (currentQty > 1) {
            currentQty--;
            $quantity.text(currentQty);
        }
    });

    $('.custom_add_to_cart_button').on('click', function (e) {
        e.preventDefault();
        let productId = $(this).data('product-id');
        let qty = currentQty;
        $("#sb_loading").show();
        $.post(ajaxurl, {
            action: "sb_add_cart",
            product_id: productId,
            qty: qty,
        }).done(function (response) {
            $("#sb_loading").hide();
            let get_r = response.split("|");

            if ($.trim(get_r[0]) === "1") {
                toastr.success(get_r[1], "", {
                    timeOut: 4000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                });
                window.location = get_r[2];
            } else {
                toastr.error(get_r[1], "", {
                    timeOut: 4000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                });
                window.location = get_r[2];
            }
        });
    });

    $('.category-link').on('click', function (event) {
        event.preventDefault();

        let categoryId = $(this).data('category-id');
        let form = $('#shop-categories-select');
        let currentUrl = form.attr('action') || window.location.href;
        let newUrl = currentUrl.split('?')[0] + '?category_id=' + categoryId;

        window.location.href = newUrl;
    });

    if ($("#user_rating_form").length > 0) {
        $("#user_rating_form")
            .parsley()
            .on("field:validated", function () {
                let ok = $(".parsley-error").length === 0;
            });

        $("#user_rating_form").submit(function () {
            let form = $(this);
            // Ajax for Registration
            loading.show();
            $.post(ajaxurl, {
                action: "sb_post_user_rating",
                security: $("#sb-user-rating-token").val(),
                sb_data: form.serialize(),
            })
                .done(function (response) {
                    loading.hide();
                    let res_arr = response.split("|");
                    if ($.trim(res_arr[0]) != "0") {
                        toastr.success(res_arr[1], "", {
                            timeOut: 4000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                        });
                        location.reload();
                    } else {
                        toastr.error(res_arr[1], "", {
                            timeOut: 4000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                        });
                    }
                })
                .fail(function () {
                    loading.hide();
                    toastr.error($("#_nonce_error").val(), "", {
                        timeOut: 4000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                    });
                });
            return false;
        });
    }

    /* Back To Top */
    $(window).scroll(function () {
        var offset = 300,
            offset_opacity = 1200,
            scroll_top_duration = 700,
            $back_to_top = $(".cd-top");
        var ad_post_btn = $(".sticky-post-button");
        $(this).scrollTop() > offset
            ? ad_post_btn.addClass("sticky-post-button-visible")
            : ad_post_btn
                .removeClass("sticky-post-button-visible")
                .removeClass("sticky-post-button-fadeout");
        $(this).scrollTop() > offset
            ? $back_to_top.addClass("cd-is-visible")
            : $back_to_top.removeClass("cd-is-visible cd-fade-out");
        if ($(this).scrollTop() > offset_opacity) {
            $back_to_top.addClass("cd-fade-out");
            ad_post_btn.addClass("sticky-post-button-fadeout");
        }
    });
    $back_to_top = $(".cd-top");
    $(document).on("click", ".cd-top", function (event) {
        event.preventDefault();
        $("body,html").animate({scrollTop: 0}, 700);
    });
    /* Back To Top */

    $(".ad_alerts").click(function () {
        $("#sb_loading").show();
        $.post(ajaxurl, {
            action: "job_alert_subscription_check",
        }).done(function (response) {
            $("#sb_loading").hide();
            var res_arr = response.split("|");
            if ($.trim(res_arr[0]) != "0") {
                $("#ad_cat_sub_div").hide();
                $("#ad_cat_sub_sub_div").hide();
                $("#ad_cat_sub_sub_sub_div").hide();
                $("select").select2({
                    placeholder: sb_options.select_place_holder,
                    allowClear: true,
                    width: "100%",
                });

                $("#sb_loading").show();
                $("#ad-alert-subscribtion").modal("show");
                $("#sb_loading").hide();
            } else {
                toastr.error(res_arr[1], "", {
                    timeOut: 4000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                });
            }
        });
    });

    $(document).on("click", "#submit_alert", function () {
        $("#alert_job_form")
            .parsley()
            .on("field:validated", function () {
                let ok = $(".parsley-error").length === 0;
            })
            .on("form:submit", function () {
                $("#sb_loading").show();
                let formData = new FormData(document.querySelector("#alert_job_form"));
                formData.append('action', 'job_alert_subscription');

                $.ajax({
                    url: ajaxurl,
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function () {
                        $("#sb_loading").show();
                    },
                    success: function (response) {
                        $("#sb_loading").hide();
                        var res_arr = response.split("|");

                        if ($.trim(res_arr[0]) != "0") {
                            toastr.success(res_arr[1], "", {
                                timeOut: 4000,
                                closeButton: true,
                                positionClass: "toast-top-right",
                            });
                            $("#ad-alert-subscribtion").modal("hide");
                        } else {
                            toastr.error(res_arr[1], "", {
                                timeOut: 4000,
                                closeButton: true,
                                positionClass: "toast-top-right",
                            });
                        }
                    },
                    error: function () {
                        $("#sb_loading").hide();
                        toastr.error("An error occurred. Please try again.", "", {
                            timeOut: 4000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                        });
                    }
                });
                return false;
            });
    });

    $('#ad_alert_category_select').on('change', async function () {
        // checkCategorySelection();
        loading.show();
        let parentId = $(this).val();
        let level = 1;
        if ($("#alert_category").length > 0) {
            $("#alert_category").val($("#ad_alert_category_select").val());
        }

        $('#child-category-container').empty();

        if (parentId) {
            await fetchChildCategories(parentId, level);
        }
        loading.hide();
        // let lastSelectedCategory = getLastSelectedCategory();
        // saveSelectedCategory(lastSelectedCategory);

    });

    if ($(".send-message-to-author").length > 0) {
        $(".send-message-to-author")
            .parsley()
            .on("field:validated", function () {
                var ok = $(".parsley-error").length === 0;
            })
            .on("form:submit", function () {
                $("#sb_loading").show();
                var google_recaptcha_type = get_strings.google_recaptcha_type;
                google_recaptcha_type =
                    typeof google_recaptcha_type !== "undefined"
                        ? google_recaptcha_type
                        : "v2";
                var google_recaptcha_site_key = get_strings.google_recaptcha_site_key;

                if (
                    google_recaptcha_type == "v3" &&
                    google_recaptcha_site_key !== "undefined" &&
                    google_recaptcha_site_key != ""
                ) {
                    grecaptcha.ready(function () {
                        try {
                            var adforest_ajax_url = jQuery("#adforest_ajax_url").val();
                            grecaptcha
                                .execute(google_recaptcha_site_key, {action: "contact_form"})
                                .then(function (token) {
                                    jQuery("#user_contact_form").prepend(
                                        '<input type="hidden" name="g-recaptcha-response" value="' +
                                        token +
                                        '">'
                                    );
                                    jQuery.post(
                                        adforest_ajax_url,
                                        {
                                            action: "sb_google_captcha3_verification",
                                            token: token,
                                        },
                                        function (result) {
                                            result = JSON.parse(result);
                                            if (result.success) {
                                                $.post(adforest_ajax_url, {
                                                    action: "sb_send_message_to_author",
                                                    ad_id: $("#ad_id").val(),
                                                    sb_data: $("form.send-message-to-author").serialize(),
                                                }).done(function (response) {
                                                    $("#sb_loading").hide();
                                                    var res_arr = response.split("|");
                                                    if ($.trim(res_arr[0]) != "0") {
                                                        toastr.success(res_arr[1], "", {
                                                            timeOut: 4000,
                                                            closeButton: true,
                                                            positionClass: "toast-top-right",
                                                        });
                                                    } else {
                                                        toastr.error(res_arr[1], "", {
                                                            timeOut: 4000,
                                                            closeButton: true,
                                                            positionClass: "toast-top-right",
                                                        });
                                                    }
                                                });
                                            } else {
                                                $("#sb_loading").hide();
                                                $("#sb_register_submit").show();
                                                toastr.error(result.msg, "", {
                                                    timeOut: 4000,
                                                    closeButton: true,
                                                    positionClass: "toast-top-right",
                                                });
                                            }
                                        }
                                    );
                                });
                        } catch (err) {
                            var google_recaptcha_error_text = jQuery(
                                "#google_recaptcha_error_text"
                            ).val();
                            google_recaptcha_error_text =
                                typeof google_recaptcha_error_text !== "undefined"
                                    ? google_recaptcha_error_text
                                    : err;
                            jQuery("#sb_loading").hide();
                            toastr.error(google_recaptcha_error_text, "", {
                                timeOut: 4000,
                                closeButton: true,
                                positionClass: "toast-top-right",
                            });
                        }
                    });
                } else {
                    $.post(adforest_ajax_url, {
                        action: "sb_send_message_to_author",
                        ad_id: $("#ad_id").val(),
                        sb_data: $("form.send-message-to-author").serialize(),
                    }).done(function (response) {
                        $("#sb_loading").hide();
                        var res_arr = response.split("|");
                        if ($.trim(res_arr[0]) != "0") {
                            toastr.success(res_arr[1], "", {
                                timeOut: 4000,
                                closeButton: true,
                                positionClass: "toast-top-right",
                            });
                        } else {
                            toastr.error(res_arr[1], "", {
                                timeOut: 4000,
                                closeButton: true,
                                positionClass: "toast-top-right",
                            });
                        }
                    });
                }
                return false;
            });
    }

    if ($("#ad_post_page_get_packages_cat_based").length > 0) {
        let cat_id = $("#ad_post_page_get_packages_cat_based").val();
        let isUpdate = "";
        if ($("#is_update").length > 0) {
            isUpdate = $("#is_update").val();
        }
        $.post(ajaxurl, {
            action: "sb_get_sub_cat",
            cat_id: cat_id,
            is_update: isUpdate,
        }).done((response) => {
            let selected_packages = response?.data?.selected_packages || "";
            if (selected_packages !== "" && selected_packages !== null) {
                $("#purchase-package").html(selected_packages);
            }
        })
    }

    jQuery(document).ready(function ($) {
        // Get the sale end date from the data attribute
        const $countdownElement = $('#countdown-timer');
        const saleEndDate = $countdownElement.data('sale-end-date');

        // Parse the sale end date
        const endDate = new Date(saleEndDate).getTime();

        // Update countdown every second
        const updateCountdown = setInterval(function () {
            const now = new Date().getTime();
            const timeLeft = endDate - now;

            if (timeLeft > 0) {
                // Calculate days, hours, minutes, and seconds
                const days = Math.floor(timeLeft / (1000 * 60 * 60 * 24));
                const hours = Math.floor((timeLeft % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((timeLeft % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((timeLeft % (1000 * 60)) / 1000);

                // Update the UI
                $('#days').text(days);
                $('#hours').text(hours);
                $('#minutes').text(minutes);
                $('#seconds').text(seconds);
            } else {
                // If the countdown ends, stop the interval and show a message
                clearInterval(updateCountdown);
                $countdownElement.html("<li><strong>The sale has ended!</strong></li>");
            }
        }, 1000);
    });

    /* ============================
     * Delete ADS Rating adforest
     ==============================*/
    $(".ads_rating_dlt").on("click", function () {
        let confirmed = get_strings.confirm;
        let this_elem = $(this);
        $("#sb_loading").show();
        if (confirmed) {
            $.post(ajaxurl, {
                action: "ads_rating_delete",
                comment_id: $(this).attr("data-comment_id"),
                ad_id: $(this).attr("data-ad_id"),
            }).done(function (response) {
                $("#sb_loading").hide();
                let get_p = response.split("|");
                if ($.trim(get_p[0]) == 1) {
                    toastr.success(get_p[1], "", {
                        timeOut: 4000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                    });

                    this_elem.parents(".review-content").remove();
                } else if ($.trim(get_p[0]) == 0) {
                    toastr.error(get_p[1], "", {
                        timeOut: 4000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                    });
                }
            });
        }
    });

    jQuery(document).ready(function ($) {
        /* Reset Password*/
        if ($("#sb-reset-password-form").length > 0) {
            $("#sb_reset_password_modal").modal("show");
            $("#sb_reset_password_msg").hide();
            $("#sb-reset-password-form")
                .parsley()
                .on("field:validated", function () {
                    var ok = $(".parsley-error").length === 0;
                })
                .on("form:submit", function () {
                    if (
                        $("#sb_new_password").val() != $("#sb_confirm_new_password").val()
                    ) {
                        toastr.error($("#adforest_password_mismatch_msg").val(), "", {
                            timeOut: 4000,
                            closeButton: true,
                            positionClass: "toast-top-right",
                        });
                        return false;
                    }
                    $("#sb_reset_password_submit").hide();
                    $("#sb_reset_password_msg").show();
                    $("#sb_loading").show();
                    $.post(ajaxurl, {
                        action: "sb_reset_password",
                        security: $("#sb-reset-pass-token").val(),
                        sb_data: $("form#sb-reset-password-form").serialize(),
                    })
                        .done(function (response) {
                            $("#sb_loading").hide();
                            $("#sb_reset_password_msg").hide();

                            var get_r = response.split("|");
                            if ($.trim(get_r[0]) == "1") {
                                toastr.success(get_r[1], "", {
                                    timeOut: 4000,
                                    closeButton: true,
                                    positionClass: "toast-top-right",
                                });
                                $("#sb_reset_password_modal").modal("hide");
                                $("#sb_reset_password_submit").show();
                                window.location = $("#login_page").val();
                            } else {
                                $("#sb_reset_password_submit").show();
                                toastr.error(get_r[1], "", {
                                    timeOut: 4000,
                                    closeButton: true,
                                    positionClass: "toast-top-right",
                                });
                            }
                        })
                        .fail(function () {
                            $("#sb_loading").hide();
                            $("#sb_reset_password_msg").hide();
                            $("#sb_reset_password_submit").show();
                            toastr.error($("#_nonce_error").val(), "", {
                                timeOut: 4000,
                                closeButton: true,
                                positionClass: "toast-top-right",
                            });
                        });
                    return false;
                });
        }

        if (sb_options.msg_notification_on != "" && sb_options.msg_notification_on != 0 && sb_options.msg_notification_time != "") {
            if (sb_options.is_logged_in == "1") {
                setInterval(function () {
                    $.post(ajaxurl, {
                        action: "sb_check_messages",
                        new_msgs: $("#is_unread_msgs").val(),
                    }).done(function (response) {
                        var get_r = response.split("|");
                        if ($.trim(get_r[0]) == "1") {
                            toastr.success(get_r[1], "", {
                                timeOut: 5000,
                                closeButton: true,
                                positionClass: "toast-top-right",
                            });
                        }
                    });
                }, sb_options.msg_notification_time);
            }
        }
    });

    const blockUI = ($element) => {
        $element.block({
            message: null,
            overlayCSS: {
                background: '#fff',
                opacity: 0.6
            }
        });
    };

    const updateCartQuantity = (key, quantity, $counter) => {
        const $form = $('form.woocommerce-cart-form');
        loading.show();

        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                action: 'update_cart_item_quantity',
                security: wc_cart_params.update_cart_nonce,
                cart_item_key: key,
                quantity: quantity
            },
            success: function (response) {
                if (response.success) {
                    if (response.data.cart_total) {
                        $('.order-summary-list .values').last().html(response.data.cart_total);
                    }
                    if (response.data.subtotal) {
                        $('.order-summary-list .values').first().html(response.data.subtotal);
                    }

                    $counter.find('.adt-count').text(String(quantity).padStart(2, '0'));

                    $(document.body).trigger('updated_cart_totals');
                } else {
                    alert('Error updating cart');
                    location.reload();
                }
            },
            error: function () {
                alert('Error updating cart');
                location.reload();
            },
            complete: function () {
                loading.hide();
            }
        });
    };

    $('.adt-counter button').on('click', function (e) {
        e.preventDefault();

        const $counter = $(this).closest('.adt-counter');
        const $input = $counter.find('.qty');
        const currentVal = parseInt($input.val());
        const cartItemKey = $input.attr('name').match(/cart\[(.*?)\]/)[1];
        let newVal = currentVal;

        if ($(this).find('.fa-angle-left').length) {
            if (currentVal > 1) {
                newVal = currentVal - 1;
            }
        } else {
            newVal = currentVal + 1;
        }

        if (newVal !== currentVal) {
            $input.val(newVal);
            updateCartQuantity(cartItemKey, newVal, $counter);
        }
    });

    $('.adt-remove').on('click', function (e) {
        e.preventDefault();
        const $item = $(this).closest('.pro-list-item');
        const $form = $('form.woocommerce-cart-form');

        loading.show()

        const $removeLink = $item.find('.remove-item-link');
        if ($removeLink.length) {
            const removeUrl = $removeLink.attr('href');

            $.ajax({
                type: 'GET',
                url: removeUrl,
                success: function (response) {
                    $item.next('.adt-line').remove();
                    $item.remove();

                    $(document.body).trigger('updated_cart_totals');

                    location.reload();
                },
                error: function () {
                    alert('Error removing item');
                    location.reload();
                },
                complete: function () {
                    loading.hide();
                }
            });
        }
    });

    function initAutocomplete() {
        let input = $('#sb_user_address').get(0);
        if (input) {
            let autocomplete = new google.maps.places.Autocomplete(input, {
                types: ['geocode']
            });

            autocomplete.addListener('place_changed', function () {
                let place = autocomplete.getPlace();
                if (place.geometry) {
                    let latInput = $('#sb_user_address_lat');
                    let lngInput = $('#sb_user_address_long');
                    if (latInput && lngInput) {
                        latInput.value = place.geometry.location.lat();
                        lngInput.value = place.geometry.location.lng();
                    }
                }
            });
        }
    }

    if ($('#sb_user_address').length > 0) {
        // google.maps.event.addDomListener(window, 'load', initAutocomplete)
    }

    if ($("#sb_user_address_leaflet").length > 0) {
        document.getElementById('sb_user_address_leaflet').addEventListener('input', function () {
            console.log("This")
            let query = this.value;
            let suggestionsBox = document.getElementById('suggestions-box');

            if (query.length < 3) {
                suggestionsBox.innerHTML = "";
                return;
            }

            fetch("https://nominatim.openstreetmap.org/search?format=json&addressdetails=1&q=" + encodeURIComponent(query))
                .then(response => response.json())
                .then(data => {
                    suggestionsBox.innerHTML = "";
                    data.forEach(place => {
                        let suggestion = document.createElement('div');
                        suggestion.className = 'suggestion-item';
                        suggestion.textContent = place.display_name;
                        suggestion.addEventListener('click', function () {
                            document.getElementById('sb_user_address_leaflet').value = place.display_name;
                            let latInput = $('#sb_user_address_lat');
                            let lngInput = $('#sb_user_address_long');
                            if (latInput && lngInput) {
                                latInput.value = place.lat;
                                lngInput.value = place.lon;
                            }
                            suggestionsBox.innerHTML = "";
                        });
                        suggestionsBox.appendChild(suggestion);
                    });
                })
                .catch(error => {
                    //console.error("Error fetching location suggestions:", error);
                });
        });
    }

    $('#collapseOnez').on('show.bs.collapse', function () {
        $('a[href="#collapseOnez"]').find('.more-less').removeClass('fa-plus').addClass('fa-minus');
    }).on('hide.bs.collapse', function () {
        $('a[href="#collapseOnez"]').find('.more-less').removeClass('fa-minus').addClass('fa-plus');
    });

    /*image sortable for ad detail page*/
    if ($("#sortable").length > 0) {
        $("#sortable").sortable({
            stop: function (event, ui) {
                $("#post_img_ids").val("");
                var current_img = "";
                $(".ui-state-default img").each(function (index) {
                    current_img = current_img + $(this).attr("data-img-id") + ",";
                });
                $("#post_img_ids").val(current_img.replace(/,\s*$/, ""));
            },
        });
        $("#sortable").disableSelection();
    }

    $("#sb_sort_images").on("click", function () {
        $("#sb_loading").show();
        $.post(ajaxurl, {
            action: "sb_sort_images",
            ids: $("#post_img_ids").val(),
            ad_id: $("#current_pid").val(),
        }).done(function (response) {
            toastr.success($("#re-arrange-msg").val(), "", {
                timeOut: 4000,
                closeButton: true,
                positionClass: "toast-top-right",
            });
            location.reload();
            $("#sb_loading").hide();
        });
    });

    (function () {
        const countdownContainer = document.querySelector('.adt-deal-countdown-desc-clock');
        const countdownContainerMobile = document.querySelector('.adt-deal-countdown-desc-clock-mobile');

        if (!countdownContainer && !countdownContainerMobile) return;

        const bidDateString = (countdownContainer || countdownContainerMobile).getAttribute('data-biddate');
        if (!bidDateString) return;

        function parseCustomDate(dateStr) {
            const [shortYear, month, dayAndTime] = dateStr.split("-");
            const [day, time] = dayAndTime.split(" ");
            const fullYear = "20" + shortYear;
            return new Date(`${fullYear}-${month}-${day}T${time}`);
        }

        const targetDate = parseCustomDate(bidDateString);

        function updateCountdownAdBidding() {
            const now = new Date();
            const timeRemaining = targetDate - now;

            if (timeRemaining <= 0) {
                clearInterval(countdownInterval);
                if (countdownContainer) countdownContainer.innerHTML = "<p>Countdown ended!</p>";
                if (countdownContainerMobile) countdownContainerMobile.innerHTML = "<p>Countdown ended!</p>";
                return;
            }

            const days = Math.floor(timeRemaining / (1000 * 60 * 60 * 24));
            const hours = Math.floor((timeRemaining % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((timeRemaining % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((timeRemaining % (1000 * 60)) / 1000);

            [countdownContainer, countdownContainerMobile].forEach(container => {
                if (!container) return;
                container.querySelector("#days").textContent = days;
                container.querySelector("#hours").textContent = hours;
                container.querySelector("#minutes").textContent = minutes;
                container.querySelector("#seconds").textContent = seconds;
            });
        }

        const countdownInterval = setInterval(updateCountdownAdBidding, 1000);
        updateCountdownAdBidding();
    })();

    $('#scrollToMessageBox').on('click', function () {
        const $target = $('#message_box');
        if ($target.length) {
            $('html, body').animate({
                scrollTop: $target.offset().top
            }, 600);
        }
    });

    $(document).on('click', '.btn-adpost-start', function (e) {
        const isUpdate = new URLSearchParams(window.location.search).has('id');

        if (!isUpdate && sb_options.pay_per_post_option != 1) {
            const isAdminAllowed = sb_options.admin_allow_unlimited_ads != 1;
            const isNotAdmin = sb_options.is_current_user_admin == "not_admin";

            if ((isNotAdmin || isAdminAllowed) && $('input.ads-package-radio:checked').length === 0) {
                e.preventDefault();
                e.stopPropagation();

                toastr.error(
                    sb_options.pkg_error,
                    sb_options.pkg_required,
                    {
                        timeOut: 5000,
                        closeButton: true,
                        positionClass: "toast-top-right",
                    }
                );

                // if ($('#ad_post_packages_container').length) {
                //     $('html, body').animate({
                //         scrollTop: $('#ad_post_packages_container').offset().top - 100
                //     }, 500);
                // }

                return false;
            }
        }
    });

    const isUpdate = new URLSearchParams(window.location.search).has('id');

    if (!isUpdate && sb_options.pay_per_post_option != 1) {
        if (sb_options.is_current_user_admin == "not_admin") {
            if ($('input.ads-package-radio:checked').length === 0) {
                // $('.btn-adpost-start').attr('disabled', 'disabled');

                $('.btn-adpost-start').addClass('package-required');
            }
        }

        if (sb_options.admin_allow_unlimited_ads != 1) {
            if ($('input.ads-package-radio:checked').length === 0) {
                // $('.btn-adpost-start').attr('disabled', 'disabled');

                $('.btn-adpost-start').addClass('package-required');
            }
        }
    }

    $(document).on('change', 'input.ads-package-radio', function () {
        var jsonString = $(this).data('package');
        loading.show();

        try {
            var pkgData = typeof jsonString === 'object'
                ? jsonString
                : JSON.parse(jsonString);

            $("#v-pills-info-tab").show();
            $("#v-pills-images-tab").show();
            $("#v-pills-contact-tab").show();
            $('.ad_yvideo_container').show();
            $('.ad_tags_container').show();
            $('.bidding-content').show();

            if (pkgData.video_links !== "yes") {
                $('.ad_yvideo_container').html('');
            }

            if (pkgData.allow_tags !== "yes") {
                $('.ad_tags_container').html('');
            }

            if (pkgData.allow_bidding == 0 || pkgData.allow_bidding == "") {
                $('.bidding-content').hide();
                $('#biddingSection').html('');
            }

            updateFeaturedAdsCount(pkgData.featured_ads);

            $('.btn-adpost-start').removeClass('package-required');

            toastr.success(
                sb_options.pkg_success,
                sb_options.success,
                {
                    timeOut: 3000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                }
            );

            loading.hide();
        } catch (e) {
            console.error('Failed to parse package JSON:', e, jsonString);

            toastr.error(
                "Failed to load package details. Please try again.",
                "Error",
                {
                    timeOut: 5000,
                    closeButton: true,
                    positionClass: "toast-top-right",
                }
            );

            loading.hide();
        }
    });

    // $(document).ready(function() {
    //     $(document).on('mouseenter', '.btn-adpost-start.package-required', function() {
    //         if ($(this).is(':disabled')) {
    //             toastr.error(
    //                 sb_options.pkg_error,
    //                 sb_options.pkg_required,
    //                 {
    //                     timeOut: 2000,
    //                     closeButton: false,
    //                     positionClass: "toast-top-right",
    //                 }
    //             );
    //         }
    //     });
    // });

    function updateFeaturedAdsCount(featuredAdsCount) {
        var countText = '';

        if (featuredAdsCount === '-1') {
            countText = sb_options.remaining_featured_ads + ": " + sb_options.unlimited_string;
        } else if (featuredAdsCount > 0) {
            countText = sb_options.remaining_featured_ads + ': ' + featuredAdsCount;
        } else {
            countText = sb_options.no_featured_ads + ` <a href="${sb_options.packages_page_link}">${sb_options.here}</a>`;
        }

        if (featuredAdsCount > 0 || featuredAdsCount === '-1') {
            $('.make-feature h3 small').text(countText);
            $('.make-feature').show();
            $('.make_featured_box').show();
        } else {
            $('.make-feature h3 small').html(countText);
            $('.make-feature').show();
            $('.make_featured_box').hide();
        }
    }

    $('#mark-all-read').on('click', function (e) {
        e.preventDefault();

        var $btn = $(this), nonce = $btn.data('nonce');
        $btn.prop('disabled', true).text('Marking...');
        $.post(
            ajaxurl,
            {
                action: 'adforest_mark_all_read',
                nonce: nonce
            },
            function (response) {
                if (response.success) {
                    $('.notification-item.unread').removeClass('unread').addClass('read');
                    $('.msgs_count').text(0);
                    $btn.text('All Read');
                } else {
                    alert(response.data || 'Could not mark all as read.');
                    $btn.prop('disabled', false).text('Mark all as read');
                }
            }
        );
    });

    jQuery(document).ready(function ($) {
        let selects = [
            '#ad_country_states',
            '#ad_country_cities',
            '#ad_country_towns'
        ];

        selects.forEach(function (sel) {
            let $select = $(sel);

            let $realOptions = $select.find('option').filter(function () {
                return $.trim($(this).val()) !== '';
            });
            let realCount = $realOptions.length;

            if (realCount === 0) {
                $select.hide();
                $select.nextAll('.select2-container').first().hide();
                $select.closest('.col-md-6').hide();
            }
        });
    });
});