<?php
add_action('wp_ajax_sb_fav_remove_ad', 'adforest_sb_fav_remove_ad');
if (!function_exists('adforest_sb_fav_remove_ad')) {
    function adforest_sb_fav_remove_ad()
    {
        adforest_authenticate_check();

        $ad_id = $_POST['ad_id'];


        if (delete_user_meta(get_current_user_id(), '_sb_fav_id_' . $ad_id)) {
            echo '1|' . esc_html__("Ad removed successfully.", 'adforest');
        } else {
            echo '0|' . esc_html__("There'is some problem, please try again later.", 'adforest');
        }
        die();
    }
}

add_action('wp_ajax_sb_change_password', 'adforest_change_password');
if (!function_exists('adforest_change_password')) {
    function adforest_change_password()
    {
        adforest_authenticate_check();
        global $adforest_theme;
        // Getting values

        $is_demo = (isset($adforest_theme['is_demo'])) ? $adforest_theme['is_demo'] : false;

        if ($is_demo) {
            echo '0|' . esc_html__("Not allowed in demo mode", 'adforest');
            die();
        }


        $params = array();
        parse_str($_POST['sb_data'], $params);
        check_ajax_referer('sb_profile_reset_pass_secure', 'security');
        $current_pass = $params['current_pass'];
        $new_pass = $params['new_pass'];
        $con_new_pass = $params['con_new_pass'];
        if ($current_pass == "" || $new_pass == "" || $con_new_pass == "") {
            echo '0|' . esc_html__("All fields are required.", 'adforest');
            die();
        }
        if ($new_pass != $con_new_pass) {
            echo '0|' . esc_html__("New password not matched.", 'adforest');
            die();
        }
        $user = get_user_by('ID', get_current_user_id());
        if ($user && wp_check_password($current_pass, $user->data->user_pass, $user->ID)) {
            wp_set_password($new_pass, $user->ID);
            echo '1|' . esc_html__("Password changed successfully.", 'adforest');
        } else {
            echo '0|' . esc_html__("Current password not matched.", 'adforest');
        }

        die();
    }
}

add_action('wp_ajax_get_ad_counts', 'get_ad_counts');
add_action('wp_ajax_nopriv_get_ad_counts', 'get_ad_counts');
function get_ad_counts()
{
    $user_id = get_current_user_id();
    $period = isset($_GET['period']) ? sanitize_text_field($_GET['period']) : 'yearly';

    $posts = get_posts([
        'author' => $user_id,
        'post_type' => 'ad_post',
        'posts_per_page' => -1
    ]);

    $all_views = [];
    foreach ($posts as $p) {
        $meta = get_post_meta($p->ID, 'daily_ad_post_views', true);
        if (is_array($meta)) {
            foreach ($meta as $date => $cnt) {
                if (!isset($all_views[$date])) {
                    $all_views[$date] = 0;
                }
                $all_views[$date] += intval($cnt);
            }
        }
    }

    $data = [];
    $today = date('Y-m-d');
    $ts_today = strtotime($today);

    if ($period === 'yearly') {
        $data = array_fill(0, 12, 0);
        foreach ($all_views as $date => $cnt) {
            $ts = strtotime($date);
            if (date('Y', $ts) === date('Y', $ts_today)) {
                $month = intval(date('n', $ts)) - 1;
                $data[$month] += $cnt;
            }
        }
    } elseif ($period === 'monthly') {
        $days_in_month = intval(date('t', $ts_today));
        $data = array_fill(0, $days_in_month, 0);
        foreach ($all_views as $date => $cnt) {
            $ts = strtotime($date);
            if (date('Y-m', $ts) === date('Y-m', $ts_today)) {
                $day = intval(date('j', $ts)) - 1;
                $data[$day] += $cnt;
            }
        }
    } else {
        $weekday_index = intval(date('N', $ts_today)) - 1;
        $week_start_ts = $ts_today - $weekday_index * DAY_IN_SECONDS;
        $data = array_fill(0, 7, 0);
        foreach ($all_views as $date => $cnt) {
            $ts = strtotime($date);
            if ($ts >= $week_start_ts && $ts < $week_start_ts + 7 * DAY_IN_SECONDS) {
                $offset = intval(floor(($ts - $week_start_ts) / DAY_IN_SECONDS));
                $data[$offset] += $cnt;
            }
        }
    }

    wp_send_json([
        'success' => true,
        'data' => $data
    ]);
}

if (!function_exists('adforest_get_sold_ads_periodically')) {
    function adforest_get_sold_ads_periodically($user_id, $period = 'yearly')
    {
        global $wpdb;

        $results = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT post_date FROM $wpdb->posts 
                 INNER JOIN $wpdb->postmeta ON $wpdb->posts.ID = $wpdb->postmeta.post_id 
                 WHERE post_type = 'ad_post' 
                   AND post_author = %d 
                   AND post_status = 'draft' 
                   AND meta_key = '_adforest_ad_status_' 
                   AND meta_value = 'sold'",
                $user_id
            )
        );


        $data = [];
        $currentDate = strtotime(current_time('Y-m-d'));

        foreach ($results as $result) {
            $date = strtotime($result->post_date);

            if ($period === 'yearly') {
                $month = date('n', $date);
                $data[$month] = isset($data[$month]) ? $data[$month] + 1 : 1;
            } elseif ($period === 'monthly' && date('Y-m', $date) === date('Y-m', $currentDate)) {
                $day = date('j', $date);
                $data[$day] = isset($data[$day]) ? $data[$day] + 1 : 1;
            } elseif ($period === 'weekly' && date('W', $date) === date('W', $currentDate)) {
                $weekday = date('N', $date);
                $data[$weekday] = isset($data[$weekday]) ? $data[$weekday] + 1 : 1;
            }
        }

        $totalPeriods = ($period === 'yearly') ? 12 : (($period === 'monthly') ? 31 : 7);
        for ($i = 1; $i <= $totalPeriods; $i++) {
            $data[$i] = isset($data[$i]) ? $data[$i] : 0;
        }

        ksort($data);

        return array_values($data);
    }
}

add_action('wp_ajax_upload_user_pic', 'adforest_user_profile_pic');
if (!function_exists('adforest_user_profile_pic')) {

    function adforest_user_profile_pic()
    {
        /* img upload */

        $is_demo = adforest_is_demo();
        if ($is_demo) {

            echo '0|' . esc_html__("Not allowed in demo mode", 'adforest');
            die();
        }
        $condition_img = 7;
        $img_count = 1;
        if (!empty($_FILES["my_file_upload"])) {
            require_once ABSPATH . 'wp-admin/includes/image.php';
            require_once ABSPATH . 'wp-admin/includes/file.php';
            require_once ABSPATH . 'wp-admin/includes/media.php';
            $files = $_FILES["my_file_upload"];
            $attachment_ids = array();
            $attachment_idss = '';

            if ($img_count >= 1) {
                $imgcount = $img_count;
            } else {
                $imgcount = 1;
            }
            $ul_con = '';
            foreach ($files['name'] as $key => $value) {
                if ($files['name'][$key]) {
                    $file = array(
                        'name' => $files['name'][$key],
                        'type' => $files['type'][$key],
                        'tmp_name' => $files['tmp_name'][$key],
                        'error' => $files['error'][$key],
                        'size' => $files['size'][$key]
                    );

                    $_FILES = array("my_file_upload" => $file);

                    // Allow certain file formats
                    $imageFileType = strtolower(end(explode('.', $file['name'])));
                    if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
                        echo '0|' . esc_html__("Sorry, only JPG, JPEG, PNG & GIF files are allowed.", 'adforest');
                        die();
                    }

                    // Check file size
                    if ($file['size'] > 2097152) {
                        echo '0|' . esc_html__("Max allowd image size is 2MB", 'adforest');
                        die();
                    }


                    foreach ($_FILES as $file => $array) {

                        if ($imgcount >= $condition_img) {
                            break;
                        }
                        $attach_id = media_handle_upload($file, $post_id);
                        $attachment_ids[] = $attach_id;

                        $image_link = wp_get_attachment_image_src($attach_id, 'adforest-user-profile');
                    }
                    if ($imgcount > $condition_img) {
                        break;
                    }
                    $imgcount++;
                }
            }
        }
        /* img upload */
        $attachment_idss = array_filter($attachment_ids);
        $attachment_idss = implode(',', $attachment_idss);

        $arr = array();
        $arr['attachment_idss'] = $attachment_idss;
        $arr['ul_con'] = $ul_con;

        $uid = get_current_user_id();
        update_user_meta($uid, '_sb_user_pic', $attach_id);
        update_user_meta($uid, '_sb_user_linkedin_pic', '');
        echo '1|' . $image_link[0];
        die();
    }

}

add_action('wp_ajax_sb_verification_system', 'adforest_verification_system');
if (!function_exists('adforest_verification_system')) {
    function adforest_verification_system()
    {
        global $adforest_theme;
        $ph = sanitize_text_field($_POST['sb_phone_numer']);
        if (!preg_match("/\+[0-9]+$/", $ph)) {
            echo '0|' . esc_html__('Please update valid phone number +CountrycodePhonenumber in profile.', 'adforest');
            die();
        }

        $user_id = get_current_user_id();

        if (isset($adforest_theme['sb_resend_code']) && $adforest_theme['sb_resend_code'] != "" && get_user_meta($user_id, '_ph_code_', true) != "") {
            $timeFirst = strtotime(get_user_meta($user_id, '_ph_code_date_', true));
            $timeSecond = strtotime(date('Y-m-d H:i:s'));
            $differenceInSeconds = $timeSecond - $timeFirst;
            $adforest_theme['sb_resend_code'] . "<" . $differenceInSeconds;
            if ($adforest_theme['sb_resend_code'] > $differenceInSeconds) {
                $after_seconds = $adforest_theme['sb_resend_code'] - $differenceInSeconds;
                echo '0|' . esc_html__("You can't resend the verification code before", 'adforest') . " " . $after_seconds . '-' . esc_html__("seconds.", 'adforest');
                die();
            }
        }

        $code = mt_rand(100000, 500000);
        $res = adforest_send_sms($ph, $code);

        $gateway = adforest_verify_sms_gateway();
        $sms_sent = false;
        if ($gateway == "iletimerkezi-sms" && $res == true) {
            $sms_sent = true;
        }
        if ($gateway == "twilio" && $res->sid) {
            $sms_sent = true;
        }

        if ($sms_sent) {
            //if( true )
            update_user_meta($user_id, '_ph_code_', $code);
            echo esc_html($code);
            update_user_meta($user_id, '_sb_is_ph_verified', '0');
            update_user_meta($user_id, '_ph_code_date_', date('Y-m-d H:i:s'));
            echo '1|' . esc_html__("Verification code has been sent.", 'adforest');
        } else {
            echo '0|' . esc_html__("Server not responding.", 'adforest');
            update_user_meta($user_id, '_sb_is_ph_verified', '0');
        }
        die();
    }
}

if (!function_exists('adforest_send_sms')) {

    function adforest_send_sms($receiver_ph, $code)
    {
        global $adforest_theme;
        $message = esc_html__('Your verification code is', 'adforest') . " " . $code;
        $gateway = adforest_verify_sms_gateway();

        if ($gateway == "iletimerkezi-sms") {
            $ilt_data = get_option('ilt_option');

            $options = ilt_get_options();
            $options['number_to'] = $receiver_ph;
            $options['message'] = $message;
            $args = wp_parse_args($args, $options);
            $is_args_valid = ilt_validate_sms_args($args);

            if (!$is_args_valid) {
                extract($args);
                $message = apply_filters('ilt_sms_message', $message, $args);
                try {
                    $client = Emarka\Sms\Client::createClient(['api_key' => $args['public_key'], 'secret' => $args['private_key'], 'sender' => $args['sender'],]);
                    $response = $client->send($receiver_ph, $message);
                    if (!$response) {
                        $is_args_valid = ilt_log_entry_format(esc_html__('[Api Error] Connection error', 'adforest'), $args);
                        $return = false;
                    } else {
                        $is_args_valid = ilt_log_entry_format(sprintf(esc_html__('Success! Message ID: %s', 'adforest'), $response), $args);
                        $return = true;
                    }
                } catch (\Exception $e) {
                    $is_args_valid = ilt_log_entry_format(sprintf(esc_html__('[Api Error] %s ', 'adforest'), $e->getMessage()), $args);
                    $return = false;
                }
            } else {
                $return = false;
            }

            ilt_update_logs($is_args_valid, $args['logging']);
            return $return;
        }

        if ($gateway == "twilio") {
            $twl_data = get_option('twl_option');

            $account_sid = $twl_data['account_sid'];
            $auth_token = $twl_data['auth_token'];
            $twilio_phone_number = $twl_data['number_from'];
            $twilio_whatsapp_number = $adforest_theme['sb_twilio_whatsapp_number'];

            $client = new Twilio\Rest\Client($account_sid, $auth_token);
            try {
                if (isset($adforest_theme['sb_verify_whatsapp']) && $adforest_theme['sb_verify_whatsapp']) {
                    $response = $client->messages->create(
                        "whatsapp:" . $receiver_ph,
                        array(
                            "from" => "whatsapp:" . $twilio_whatsapp_number,
                            "body" => "Your verification code is:" . $code,
                        )
                    );
                } else {
                    $response = $client->messages->create($receiver_ph, array("from" => $twilio_phone_number, "body" => $message));
                }

                if ($response->sid) {
                    return $response;
                } else {
                    echo '0|' . esc_html__('Message not sent. Please check your Twilio configuration.', 'adforest');
                    die();
                }
            } catch (\Exception $e) {
                echo '0|' . $e->getMessage();
                die();
            }

        }
    }

}

// Ajax hander for update profile processing
add_action('wp_ajax_sb_update_profile', 'adforest_profile_update_ajax_processed');
if (!function_exists('adforest_profile_update_ajax_processed')) {
    function adforest_profile_update_ajax_processed()
    {
        // Getting values

        $is_demo = adforest_is_demo();
        if ($is_demo) {
            echo esc_html__('Not allowed in demo mode', 'adforest');
            die();
        }


        $params = array();
        parse_str($_POST['sb_data'], $params);
        check_ajax_referer('sb_profile_secure', 'security');

        $uid = get_current_user_id();
        $email = (isset($params['user_email']) && $params['user_email'] != "") ? $params['user_email'] : "";
        global $adforest_theme;
        $sms_gateway = adforest_verify_sms_gateway();
        if ($sms_gateway != "") {

        }
        $ph_num = sanitize_text_field($params['sb_user_contact']);
        if (!preg_match("/\+[0-9]+$/", $ph_num)) {
            echo esc_html__('Please enter valid phone number +CountrycodePhonenumber', 'adforest');
            die();
        }
        $saved_ph = get_user_meta($uid, '_sb_contact', true);
        if ($saved_ph != $ph_num) {
            update_user_meta($uid, '_sb_is_ph_verified', '0');
        }
        /* if (isset($adforest_theme['sb_phone_verification']) && $adforest_theme['sb_phone_verification'] && in_array('wp-twilio-core/core.php', apply_filters('active_plugins', get_option('active_plugins')))) {
          $ph_num = sanitize_text_field($params['sb_user_contact']);
          if (!preg_match("/\+[0-9]+$/", $ph_num)) {
          echo esc_html__('Please enter valid phone number +CountrycodePhonenumber', 'adforest');
          die();
          }

          $saved_ph = get_user_meta($uid, '_sb_contact', true);
          if ($saved_ph != $ph_num) {
          update_user_meta($uid, '_sb_is_ph_verified', '0');
          }
          } */
        wp_update_user(array('ID' => $uid, 'display_name' => sanitize_text_field($params['sb_user_name'])));
        update_user_meta($uid, '_sb_address', sanitize_text_field($params['sb_user_address']));
        update_user_meta($uid, '_sb_user_type', sanitize_text_field($params['sb_user_type']));
        update_user_meta($uid, '_sb_user_intro', sanitize_textarea_field($params['sb_user_intro']));
        update_user_meta($uid, '_sb_user_whatsapp_intro', sanitize_textarea_field($params['sb_user_whatsapp_intro']));
        $sb_disable_linkedin_edit = isset($adforest_theme['sb_disable_linkedin_edit']) && $adforest_theme['sb_disable_linkedin_edit'] ? TRUE : FALSE;
        $profiles = adforest_social_profiles();
        foreach ($profiles as $key => $value) {
            if ($key == 'linkedin' && $sb_disable_linkedin_edit) {
                continue;
            }
            update_user_meta($uid, '_sb_profile_' . $key, sanitize_textarea_field($params['_sb_profile_' . $key]));
        }
        do_action('adforest_directory_update_profile_opening_hours', $uid, $params);
        if ($email != "") {
            $args = array(
                'ID' => $uid,
                'user_email' => $email,
            );
            $update = wp_update_user($args);
            if (is_wp_error($update)) {
                echo adforest_return_echo($update->get_error_message());
                die();
            } else {
                echo '1';
                die();
            }
        }


        if (isset($params['sb_user_contact']) && $params['sb_user_contact'] != "") {
            global $wpdb;
            $user_contact = $params['sb_user_contact'];
            $query_user = "SELECT user_id FROM $wpdb->usermeta WHERE meta_key = '_sb_contact' AND meta_value  =  '$user_contact'";
            $result = $wpdb->get_results($query_user);

            if (is_array($result) && isset($result[0]->user_id) && $result[0]->user_id != $uid) {
                echo esc_html__('Phone Number already registered', 'adforest');
                die();
            }


            update_user_meta($uid, '_sb_contact', $user_contact);

        }
        echo '1';
        die();
    }
}

function load_more_ads_ajax_handler()
{
    $paged = isset($_POST['page']) ? intval($_POST['page']) : 1;

    $output = display_recently_viewed_ad_posts($paged);

    if ($paged == 1) {
        echo wp_kses_post($output);
    } else {
        preg_match('/<tbody>(.*?)<\/tbody>/s', $output, $matches);
        echo wp_kses_post($matches[1]);
    }

    wp_die();
}

add_action('wp_ajax_load_more_ads_dashboard_table', 'load_more_ads_ajax_handler');
add_action('wp_ajax_nopriv_load_more_ads_dashboard_table', 'load_more_ads_ajax_handler');
function adforest_load_more_dashboard_ads()
{
    $user_id = get_current_user_id();
    $paged = isset($_POST['paged']) ? intval($_POST['paged']) : 1;
    $ad_type = isset($_POST['ad_type']) ? $_POST['ad_type'] : "";

    $args = [];
    if ($ad_type != "" && $ad_type == 'my_ads') {
        $args = array(
            'post_type' => 'ad_post',
            'author' => $user_id,
            'post_status' => 'publish',
            'posts_per_page' => get_option('posts_per_page'),
            'paged' => $paged,
            'order' => 'DESC',
            'orderby' => 'date'
        );
    } elseif ($ad_type != "" && $ad_type == 'featured_ads') {
        $args = array(
            'post_type' => 'ad_post',
            'author' => $user_id,
            'post_status' => 'publish',
            'posts_per_page' => get_option('posts_per_page'),
            'meta_key' => '_adforest_is_feature',
            'meta_value' => '1',
            'paged' => $paged,
            'order' => 'DESC',
            'orderby' => 'ID'
        );
    } elseif ($ad_type != "" && $ad_type == 'rejected_ads') {
        $args = array(
            'post_type' => 'ad_post',
            'author' => $user_id,
            'post_status' => 'rejected',
            'posts_per_page' => get_option('posts_per_page'),
            'paged' => $paged,
            'order' => 'DESC',
            'orderby' => 'ID'
        );
    } elseif ($ad_type != "" && $ad_type == 'fav_ads') {
        global $wpdb;
        $uid = get_current_user_id();
        $rows = $wpdb->get_results("SELECT meta_value FROM $wpdb->usermeta WHERE user_id = '$uid' AND meta_key LIKE '_sb_fav_id_%'");
        $pids = array(0);
        foreach ($rows as $row) {
            $pids[] = $row->meta_value;
        }
        $args = array(
            'post_type' => 'ad_post',
            'post__in' => $pids,
            'post_status' => 'publish',
            'posts_per_page' => get_option('posts_per_page'),
            'paged' => $paged,
            'order' => 'DESC',
            'orderby' => 'date'
        );
    } elseif ($ad_type != "" && $ad_type == 'inactive_ads') {
        $args = array(
            'post_type' => 'ad_post',
            'author' => $user_id,
            'post_status' => array('pending'),
            'posts_per_page' => get_option('posts_per_page'),
            'paged' => $paged,
            'order' => 'DESC',
            'orderby' => 'ID'
        );
    } elseif ($ad_type != "" && $ad_type == 'expired_ads') {
        global $adforest_theme;
        $user_id = get_current_user_id();
        $args = array(
            'post_type' => 'ad_post',
            'author' => $user_id,
            'post_status' => array('draft'),
            'posts_per_page' => get_option('posts_per_page'),
            'paged' => $paged,
            'order' => 'DESC',
            'orderby' => 'ID'
        );

        $after_expired_ads = isset($adforest_theme['after_expired_ads']) ? $adforest_theme['after_expired_ads'] : "";
        if ($after_expired_ads == "published") {
            $args = array(
                'post_type' => 'ad_post',
                'author' => $user_id,
                'post_status' => array('draft', 'publish'),
                'posts_per_page' => get_option('posts_per_page'),
                'paged' => $paged,
                'order' => 'DESC',
                'orderby' => 'ID',
                'meta_query' => array(
                    'relation' => 'OR',
                    array(
                        'key' => '_adforest_ad_status_',
                        'value' => 'expired',
                        'compare' => '=',
                    ),
                    array(
                        'key' => '_adforest_ad_status_',
                        'value' => 'sold',
                        'compare' => '=',
                    ),
                )
            );
        }
    }

    $query = new WP_Query($args);

    if ($query->have_posts()) :
        while ($query->have_posts()) : $query->the_post();
            $ad_details = get_ad_post_details(get_the_ID());
            $first_img = $ad_details['img'];
            $title = $ad_details['ad_title'];
            $price = $ad_details['price'];
            $ad_permalink = $ad_details['ad_link'];
            $post_status = get_post_status(get_the_ID());
            $status_label = ucfirst($post_status);
            ?>
            <tr>
                <td>
                    <div class="product">
                        <div class="image">
                            <img src="<?php echo esc_url($first_img); ?>" alt="<?php echo esc_attr($title); ?>"/>
                        </div>
                        <p class="text-sm"><?php echo esc_html($title); ?></p>
                    </div>
                </td>
                <td>
                    <div class="table-price-dash">
                        <?php echo adforest_adPrice(get_the_ID(), 'negotiable', 'p'); ?>
                    </div>
                </td>
                <td>
                    <span class="status-btn <?php echo esc_attr($post_status); ?>-btn"><?php echo esc_html($status_label); ?></span>
                </td>
                <td>
                    <div class="action justify-content-end">
                        <?php
                        global $adforest_theme;
                        $sb_post_ad_page = apply_filters('adforest_language_page_id', $adforest_theme['sb_post_ad_page']);
                        $ad_update_url = adforest_set_url_param(get_the_permalink($sb_post_ad_page), 'id', get_the_ID());
                        $bump_ads = get_user_meta(get_current_user_id(), '_sb_bump_ads', true);
                        $bump_up_ads_class = '';
                        if ($bump_ads > 0 || $bump_ads == '-1' || (isset($adforest_theme['sb_allow_free_bump_up']) && $adforest_theme['sb_allow_free_bump_up'])) {
                            $bump_up_ads_class = 'bump_it_up_new_pkg';
                        } else {
                            $bump_up_ads_class = 'bump_it_up_new_pkg';
                        }

                        $featured_ads = get_user_meta(get_current_user_id(), '_sb_featured_ads', true);
                        $sb_expire_ads = get_user_meta(get_current_user_id(), '_sb_expire_ads', true);
                        if ($featured_ads != 0 && $featured_ads != "" && ($sb_expire_ads != '-1' || $sb_expire_ads < date('Y-m-d'))) {
                            $ad_featured = 'sb_make_feature_ad_new_pkg';
                        } else {
                            $ad_featured = 'sb_make_feature_ad_new_pkg';
                        }
                        $is_featured = get_post_meta(get_the_ID(), '_adforest_is_feature', true) == '1';
                        $star_class = $is_featured ? 'lni lni-star-filled' : 'lni lni-star';
                        $link_class = $ad_featured;
                        $inline_style = $is_featured ? 'style="pointer-events: none;"' : '';
                        ?>
                        <div class="ad_action_container d-flex justify-content-center align-items-center gap-4">
                            <a href="javascript:void(0)" class="<?php echo esc_attr($ad_featured); ?>"
                               title="Make Featured" data-aaa-id="<?php echo esc_attr(get_the_ID()); ?>" <?php echo esc_attr($inline_style); ?>>
                                <i class="<?php echo esc_attr($star_class) ?>"></i>
                            </a>
                            <a href="javascript:void(0)" class="<?php echo esc_attr($bump_up_ads_class); ?>"
                               title="Bump Up Ad" data-aaa-id="<?php echo esc_attr(get_the_ID()); ?>">
                                <i class="lni lni-arrow-up-circle"></i>
                            </a>
                            <a href="<?php echo esc_url($ad_update_url); ?>" class="edit"
                               title="Edit Ad">
                                <i class="lni lni-pencil"></i>
                            </a>
                        </div>
                        <button class="more-btn ml-10 dropdown-toggle"
                                id="moreAction<?php echo get_the_ID(); ?>" data-bs-toggle="dropdown"
                                aria-expanded="false">
                            <i class="lni lni-more-alt"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end"
                            aria-labelledby="moreAction<?php echo get_the_ID(); ?>">
                            <li class="dropdown-item">
                                <a href="javascript:void(0)"
                                   class="text-gray ad_package_info"
                                   data-adid='<?php echo get_the_ID(); ?>'><?php echo esc_html__("Info", "adforest"); ?></a>
                            </li>
                            <li class="dropdown-item">
                                <a href="javascript:void(0)"
                                   class="text-gray ad_status" data-adid='<?php echo get_the_ID(); ?>'
                                   data-value="active"><?php echo esc_html__("Active", "adforest"); ?></a>
                            </li>
                            <li class="dropdown-item">
                                <a href="javascript:void(0)"
                                   class="text-gray ad_status" data-adid='<?php echo get_the_ID(); ?>'
                                   data-value="expired"><?php echo esc_html__("Expire", "adforest"); ?></a>
                            </li>
                            <li class="dropdown-item">
                                <a href="javascript:void(0)"
                                   class="text-gray ad_status" data-adid='<?php echo get_the_ID(); ?>'
                                   data-value="sold"><?php echo esc_html__("Sold", "adforest"); ?></a>
                            </li>
                            <li class="dropdown-item">
                                <a href="javascript:void(0)"
                                   class="text-gray remove_ad" data-adid='<?php echo get_the_ID(); ?>'
                                   data-value="expired"><?php echo esc_html__("Delete", "adforest"); ?></a>
                            </li>
                        </ul>
                    </div>
                </td>
            </tr>
        <?php
        endwhile;
    else :
        echo 'no_more_posts';
    endif;

    wp_die();
}

add_action('wp_ajax_load_more_dashboard_ads', 'adforest_load_more_dashboard_ads');
add_action('wp_ajax_nopriv_load_more_dashboard_ads', 'adforest_load_more_dashboard_ads');

// Ajax handler my_ads_msgs
add_action('wp_ajax_received_msgs_ads_list', 'adforest_received_msgs_ads_list');
if (!function_exists('adforest_received_msgs_ads_list')) {
    function adforest_received_msgs_ads_list()
    {

        echo adforest_return_echo(adforest_get_user_ads_list());

        die();
    }
}

function adforest_get_user_ads_list()
{
    global $adforest_theme;
    $script = '<script type="text/javascript">jQuery(document).ready(function($){"use strict"; $(\'.message-history\').wrap(\'<div class="list-wrap"></div>\');function scrollbar() {var $scrollbar = $(\'.message-inbox .list-wrap\');$scrollbar.perfectScrollbar({maxScrollbarLength: 150,});$scrollbar.perfectScrollbar(\'update\');} ;$(\'.messages\').wrap(\'<div class="list-wraps"></div>\');function scrollbar1() {var $scrollbar1 = $(\'.message-details .list-wraps\');$scrollbar1.perfectScrollbar({maxScrollbarLength: 150,});$scrollbar1.perfectScrollbar(\'update\');}});</script>';

    global $wpdb;

    $args = array(
        'post_type' => 'ad_post',
        'author' => get_current_user_id(),
        'post_status' => 'publish',
        'posts_per_page' => -1,
        'paged' => $paged,
        'order' => 'DESC',
        'orderby' => 'ID',
    );

    $args = apply_filters('adforest_wpml_show_all_posts', $args);
    $args = apply_filters('adforest_site_location_ads', $args, 'ads');

    $ads = new WP_Query($args);
    if ($ads->have_posts()) {
        $number = 0;
        $ads_list = '';
        while ($ads->have_posts()) {
            $ads->the_post();
            $pid = get_the_ID();

            $ad_img = adforest_get_ad_default_image_url('adforest-ad-related');
            $media = adforest_get_ad_images($pid);
            if (count($media) > 0) {
                foreach ($media as $m) {
                    $mid = '';
                    if (isset($m->ID))
                        $mid = $m->ID;
                    else
                        $mid = $m;

                    $img = wp_get_attachment_image_src($mid, 'adforest-ad-related');
                    $ad_img = $img[0];
                    break;
                }
            }

            $is_unread_msgs = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->commentmeta WHERE comment_id = '" . get_current_user_id() . "' AND meta_value = '0' AND meta_key like '" . $pid . "_%'");

            $unread_html = '';

            $status = '';
            if ($is_unread_msgs > 0) {
                $status = '<i class="lni lni-envelope" aria-hidden="true"></i>';

                $unread_html .= '<li class="get_msgs" ad_msg="' . esc_attr($pid) . '"><a href="javascript:void(0);">
						<div class="image"><img src="' . $ad_img . '" alt="' . get_the_title($pid) . '"></div>
						<div class="user-name">
						   <div class="author"><span>' . get_the_title($pid) . '</span></div>
						   <div class="time">' . $status . '</div>
						</div>
					 </a>
					 </li>';
            } else {
                $ads_list .= '<li class="get_msgs" ad_msg="' . esc_attr($pid) . '"><a href="javascript:void(0);">
						<div class="image"><img src="' . $ad_img . '" alt="' . get_the_title($pid) . '"></div>
						<div class="user-name">
						   <div class="author"><span>' . get_the_title($pid) . '</span></div>
						   <div class="time">' . $status . '</div>
						</div>
					 </a>
					 </li>';
            }

            $ads_list = $unread_html . $ads_list;
        }
    }
    wp_reset_postdata();
    $msg = '<div class="text-center">' . esc_html__('Please click to your ad in order to see messages.', 'adforest') . '</div>';

    return $script . '<div >
               <div class="message-body row">
                 <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="message-inbox">
                       <div class="message-header">
                          <h4>' . esc_html__('Ads:', 'adforest') . '</h4>
                          <div class="message-tabs"> 
                              <span><a style="font-size: 12px" class="messages_actions" sb_action="my_msgs"><small>' . esc_html__(' Sent Offers', 'adforest') . '</small></a></span>
                              <span><a style="font-size: 12px" class="messages_actions active" sb_action="received_msgs_ads_list"><small>' . esc_html__('Received Offers', 'adforest') . '</small></a></span>
                              <span><a style="font-size: 12px" class="messages_actions" sb_action="adforest_all_blocked_users"><small>' . esc_html__('Blocked users', 'adforest') . ' </small></a></span>     
                          </div>
                       </div>
                       <ul class="message-history">' . $ads_list . '</ul>
                    </div>
                 </div>
                 <div class="col-md-8 clearfix col-sm-6 col-xs-12 message-content">
                    <div class="message-details">
                       <div class="chat-form ">' . $msg . '</div>
                    </div>
                 </div>
              </div>
           </div>';
}

// Ajax handler for messages
add_action('wp_ajax_adforest_all_blocked_users', 'adforest_all_blocked_users_callback');
if (!function_exists('adforest_all_blocked_users_callback')) {
    function adforest_all_blocked_users_callback()
    {
        echo adforest_return_echo(adforest_all_blocked_users_list(get_current_user_id()));
        die();
    }
}

function adforest_all_blocked_users_list($current_user_id)
{
    global $adforest_theme;

    $script = '<script type="text/javascript">jQuery(document).ready(function($){"use strict";$(\'.message-history\').wrap(\'<div class="list-wrap"></div>\');function scrollbar() {var $scrollbar = $(\'.message-inbox .list-wrap\');$scrollbar.perfectScrollbar({maxScrollbarLength: 150,});$scrollbar.perfectScrollbar(\'update\');}$(\'.messages\').wrap(\'<div class="list-wraps"></div>\');function scrollbar1() {var $scrollbar1 = $(\'.message-details .list-wraps\');$scrollbar1.perfectScrollbar({maxScrollbarLength: 150,});$scrollbar1.perfectScrollbar(\'update\');}});</script>';

    $script = apply_filters('adforest_blocked_user_scripts', $script);

    global $wpdb;

    $users = '';
    $messages = '';
    $messages = '<div class="text-center">' . esc_html__('No Blocked user.', 'adforest') . '</div>';
    $author_html = '';
    $turn = 1;
    $level_2 = '';
    $title_html = '<h2 class="padding-top-20 sb_ad_title">' . esc_html__('Blocked users', 'adforest') . '</h2>';

    $blocked_user_array = get_user_meta($current_user_id, 'adforest_blocked_users', true);

    if (isset($blocked_user_array) && !empty($blocked_user_array) && is_array($blocked_user_array)) {

        $messages = '';
        foreach ($blocked_user_array as $block_time => $block_user_id) {

            if ($turn == 1)
                $cls = 'message-history-active';

            $user_data = get_userdata($block_user_id);
            $ad_id = $row->comment_post_ID;
            $comment_author = get_userdata($author);

            $msg_status = get_comment_meta(get_current_user_id(), $ad_id . "_" . $author, true);

            $form = ' ';
            $form = apply_filters('adforest_blocked_button_html', $form, $block_user_id, get_current_user_id(), false);

            $user_pic = adforest_get_user_dp($block_user_id);
            $messages .= '<li class="friend-message clearfix">
                        <figure class="profile-picture"><a href="' . get_author_posts_url($comment->user_id) . '?type=ads" class="link" target="_blank"><img src="' . $user_pic . '" class="img-circle" alt="' . esc_html__('Profile Pic', 'adforest') . '"></a></figure>
                        <div class="message block-user-box">
                            <div class="user-detail-wrap">
                               <span class="block-user-name">' . $user_data->display_name . '</span>
                               <span class="block-user-date">' . esc_html__('Blocked on', 'adforest') . ' : ' . date('F j, Y', $block_time) . '</span>
                            </div>       
                              ' . $form . '    
                        </div>
                 </li>';
            $turn++;
        }
    }

    if ($users == '') {
        $users = '<li class="padding-top-30 padding-bottom-20"><div class="user-name">' . esc_html__('Nothing Found.', 'adforest') . '</div></li>';
    }
    return $script . '<div>
               <div class="message-body row">
                 <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="message-inbox">
                       <div class="message-header">
                          <h4>' . esc_html__('Ads:', 'adforest') . '</h4>
                            <div class="message-tabs">  
                          <span><a style="font-size: 12px" class="messages_actions" sb_action="my_msgs"><small>' . esc_html__(' Sent Offers', 'adforest') . '</small></a></span>
                          <span><a style="font-size: 12px" class="messages_actions" sb_action="received_msgs_ads_list"><small>' . esc_html__('Received Offers', 'adforest') . '</small></a></span>
                          <span><a style="font-size: 12px" class="messages_actions active" sb_action="adforest_all_blocked_users"><small>' . esc_html__('Blocked users', 'adforest') . ' </small></a></span>  
                               </div>
                       </div>
                       
                    </div>
                 </div>
                 <div class="col-md-8 clearfix col-sm-6 col-xs-12 message-content">
				 	' . $title_html . '
                    <div class="message-details">
                       <ul class="messages">' . $messages . '</ul>
                    </div>
                 </div>
              </div>
           </div>';
}

// Ajax handler for My ads
add_action('wp_ajax_sb_load_messages', 'adforest_load_messages');
if (!function_exists('adforest_load_messages')) {

    function adforest_load_messages()
    {
        $ad_id = isset($_POST['ad_id']) ? $_POST['ad_id'] : "";
        $args = array(
            'post_type' => 'ad_post',
            'author' => get_current_user_id(),
            'post_status' => 'publish',
            'posts_per_page' => get_option('posts_per_page'),
            'paged' => $paged,
            'order' => 'DESC',
            'orderby' => 'ID'
        );
        echo adforest_return_echo(adforest_load_ad_messages($ad_id));
        wp_die();
    }

}

function adforest_load_ad_messages($ad_id)
{


    global $adforest_theme;
    adforest_set_date_timezone();

    $script = '<script type="text/javascript"> jQuery(document).ready(function($){ "use strict";  $(\'.message-history\').wrap(\'<div class="list-wrap"></div>\'); function scrollbar() { var $scrollbar = $(\'.message-inbox .list-wrap\'); $scrollbar.perfectScrollbar({ maxScrollbarLength: 150, }); $scrollbar.perfectScrollbar(\'update\'); } $(\'.messages\').wrap(\'<div class="list-wraps"></div>\'); function scrollbar1() { var $scrollbar1 = $(\'.message-details .list-wraps\'); $scrollbar1.perfectScrollbar({ maxScrollbarLength: 150, }); $scrollbar1.perfectScrollbar(\'update\');}  });</script>';
    $script = apply_filters('adforest_blocked_user_scripts', $script);
    global $wpdb;
    $rows = $wpdb->get_results("SELECT comment_author, user_id FROM $wpdb->comments WHERE comment_post_ID = '$ad_id' AND comment_type = 'ad_post'  GROUP BY user_id ORDER BY MAX(comment_date) DESC");
    $users = '';
    $messages = '';
    $author_html = '';
    $form = '<div class="text-center">' . esc_html__('No message received on this ad yet.', 'adforest') . '</div>';
    $turn = 1;
    $level_2 = '';

    $block_user_html = "";
    $ran_once = false;
    foreach ($rows as $row) {
        if (get_current_user_id() == $row->user_id)
            continue;

        $user_dp = adforest_get_user_dp($row->user_id);

        $last_date = $wpdb->get_var("SELECT comment_date FROM $wpdb->comments WHERE comment_post_ID = '$ad_id' AND user_id = '" . $row->user_id . "' AND comment_type = 'ad_post' ORDER BY comment_date DESC LIMIT 1");


        $date = explode(' ', $last_date);
        $cls = '';
        $ext_class = "";
        $display = "";
        if ($turn == 1) {
            $cls = 'message-history-active';
        } else {
            $ext_class = "hidden_btn";
        }
        $msg_status = get_comment_meta(get_current_user_id(), $ad_id . "_" . $row->user_id, true);

        $status = '';
        if ($msg_status == '0') {
            $status = '<i class="lni lni-envelope" aria-hidden="true"></i>';
        }
        $users .= '<li class="user_list ' . $cls . '" cid="' . $ad_id . '" second_user="' . $row->user_id . '" id="sb_' . $row->user_id . '_' . $ad_id . '" sb_msg_token="' . wp_create_nonce('sb_msg_secure') . '">
					 <a href="javascript:void(0);">
						<div class="image"> <img src="' . $user_dp . '" alt="' . $row->comment_author . '"> </div>
						<div class="user-name">
						   <div class="author"> <span>' . $row->comment_author . '</span> </div>
						   <p>' . get_the_title($ad_id) . '</p>
						   <div class="time" id="' . $row->user_id . '_' . $ad_id . '"> ' . $status . ' </div>
						</div>
					 </a>
				  </li>';

        if (!$ran_once) {
            $block_user_html .= apply_filters('adforest_blocked_button_html', "", $row->user_id, get_current_user_id(), false, $ext_class, true);
            $ran_once = true;
        }

        $authors = array($row->user_id, get_current_user_id());

        if ($turn == 1) {
            //do_action('adforest_switch_language_code_from_id', $ad_id);
            $args = array(
                'author__in' => $authors,
                'post_id' => $ad_id,
                'parent' => $row->user_id,
                'orderby' => 'comment_date',
                'order' => 'ASC',
            );
            $comments = get_comments($args);

            if (count($comments) > 0) {

                $level_2 = '<input type="hidden" id="usr_id" name="usr_id" value="' . $row->user_id . '" />
                            <input type="hidden" id="user_id"  value="' . $row->user_id . '" />
                                <input type="hidden" id="rece_id" name="rece_id" value="' . $row->user_id . '" />
                                <input type="hidden" name="msg_receiver_id" id="msg_receiver_id" value="' . esc_attr($row->user_id) . '" />';

                foreach ($comments as $comment) {
                    $user_pic = '';
                    $class = 'friend-message';
                    if ($comment->user_id == get_current_user_id()) {
                        $class = 'my-message';
                    }


                    $images_meta = get_comment_meta($comment->comment_ID, 'comment_image_meta', true);
                    $images_meta = $images_meta != "" ? unserialize($images_meta) : array();
                    $images_html = "";
                    $counter = 0;
                    if (!empty($images_meta)) {

                        foreach ($images_meta as $attach_id) {

                            $img_src = wp_get_attachment_image_src($attach_id);
                            $images_html .= '<a class="sb_msg_image" href="' . esc_url(wp_get_attachment_url($attach_id)) . '" data-fancybox="gallery"><img src="' . $img_src[0] . '"></a>';

                            $counter++;
                        }
                    }

                    if ($counter > 4) {

                        $images_html .= '<div class="img_more">' . esc_html__('More', 'adforest') . '</div>';
                    }


                    $file_meta = get_comment_meta($comment->comment_ID, 'comment_file_meta', true);

                    $file_meta = $file_meta != "" ? unserialize($file_meta) : array();
                    $files_html = "";
                    if (!empty($file_meta)) {
                        $files_html .= '<div>';
                        foreach ($file_meta as $attach_id) {
                            if (wp_attachment_is_image($attach_id)) {
                                $img_src = wp_get_attachment_image_src($attach_id);
                                $files_html .= '<a class="sb_msg_image" href="' . esc_url(wp_get_attachment_url($attach_id)) . '" data-fancybox="gallery"><img src="' . $img_src[0] . '"></a>';
                            } else {
                                $file_url = wp_get_attachment_url($attach_id);
                                $files_html .= '<a class="sb_msg_file" href="' . $file_url . '" target="_blank">' . basename(get_attached_file($attach_id)) . '</a>';
                            }
                        }
                        $files_html .= '</div>';
                    }


                    $user_pic = adforest_get_user_dp($comment->user_id);
                    $messages .= '<li class="' . $class . ' clearfix">
								 <figure class="profile-picture"><a href="' . get_author_posts_url($comment->user_id) . '?type=ads" class="link" target="_blank"><img src="' . $user_pic . '" class="img-circle" alt="' . esc_html__('Profile Pic', 'adforest') . '"></a></figure>
								 <div class="message">
									' . $comment->comment_content . '
                                                                        ' . $images_html . '
                                                                            ' . $files_html . '
									<div class="time"><i class="lni lni-timer"></i> ' . adforest_timeago($comment->comment_date) . '</div>
								 </div>
							  </li>';
                }
            }

            $allow_attachment = isset($adforest_theme['allow_media_upload_messaging']) ? $adforest_theme['allow_media_upload_messaging'] : false;

            $attachment_html = "";
            if ($allow_attachment) {
                $attachment_html = '<div id="attachment-wrapper" class="attachment-wrapper"></div>           
                                       <div class="file_attacher" id="file_attacher">
                                         <a href="javascript:void(0)" class="msgAttachFile dz-clickable"><i class="fa fa-link"></i>' . esc_html__('Add Attachment', 'adforest') . '</a>
                                         
                                         </div>                             
                                    ';
            }
            // Message form


            $verifed_phone_number = adforest_check_if_phoneVerified();
            if ($verifed_phone_number) {
                $form = '<div role="alert" class="alert alert-info alert-dismissible">
                                ' . esc_html__("Please verify your phone number to send message.", "adforest") . ' 
                             </div>';
            } else {

                $user_info = get_userdata(get_current_user_id());
                $form = '<form class="form-inline" id="send_chat_message">
                            
                                  ' . $attachment_html . '
							 <input type="hidden" name="ad_post_id" id="ad_post_id" value="' . $ad_id . '" />
							 <input type="hidden" name="name" value="' . $user_info->display_name . '" />
							 <input type="hidden" name="email" value="' . $user_info->user_email . '" />
                                                                
							 ' . $level_2 . '
                             <div class="input-style-1">
                                <input name="message" id="sb_forest_message" placeholder="' . esc_html__('Type a message here...', 'adforest') . '" class="message-text" autocomplete="off" type="text" data-parsley-required="true" data-parsley-error-message="' . esc_html__('This field is required.', 'adforest') . '">
                             </div>
                             <button class="main-btn dark-btn square-btn btn-hover" id="send_msg" type="submit" inbox="no" sb_msg_token="' . wp_create_nonce('sb_msg_secure') . '">' . esc_html__('Send', 'adforest') . '</button>
                           
                          </form>';
            }
        }
        $turn++;
    }
    if ($users == '') {
        $users = '<li class="padding-top-30 padding-bottom-20"><div class="user-name">' . esc_html__('No message received on this ad yet.', 'adforest') . '</div></li>';
    }
    $title = '';
    if (isset($ad_id) && $ad_id != "") {
        $title = '<a href="' . get_the_permalink($ad_id) . '" target="_blank">' . get_the_title($ad_id) . '</a>';
    }
    $title_html = '<div class="message_header_chat"><h2 class="padding-top">' . $title . ' </h2> ' . $block_user_html . '</div>';

    return $script . '<div>
              <div class="message-body row">
                 <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="message-inbox">
                       <div class="message-header">
                          <h4>' . esc_html__('Users', 'adforest') . '</h4>
                              <div class="message-tabs"> 
                                <span><a style="font-size: 12px" class="messages_actions" sb_action="my_msgs"><small>' . esc_html__(' Sent Offers', 'adforest') . '</small></a></span>
                                <span><a style="font-size: 12px" class="messages_actions active" sb_action="received_msgs_ads_list"><small>' . esc_html__('Received Offers', 'adforest') . '</small></a></span>
                                <span><a style="font-size: 12px" class="messages_actions" sb_action="adforest_all_blocked_users"><small>' . esc_html__('Blocked users', 'adforest') . ' </small></a></span>  
                              </div>
                       </div>
                        <ul class="message-history"> ' . $users . ' </ul>
                    </div>
                 </div>
                 <div class="col-md-8 clearfix col-sm-6 col-xs-12 message-content">
				 	' . $title_html . '
                    <div class="message-details">
                       <ul class="messages" id="messages"> ' . $messages . ' </ul>
                       <div class="chat-form "> ' . $form . ' </div>
                    </div>
                 </div>
              </div>
     </div>';
}

// Get all messages of particular ad
add_action('wp_ajax_sb_get_messages', 'adforest_get_messages_all');
if (!function_exists('adforest_get_messages_all')) {

    function adforest_get_messages_all()
    {

        adforest_authenticate_check();
        check_ajax_referer('sb_msg_secure', 'security');
        $ad_id = $_POST['ad_id'];
        $user_id = $_POST['user_id'];
        $authors = array($user_id, get_current_user_id());

        //$blocked_user_array2 = get_user_meta(get_current_user_id(), 'adforest_blocked_users', true);
        //if (isset($blocked_user_array2) && !empty($blocked_user_array2) && is_array($blocked_user_array2) && in_array($user_id, $blocked_user_array2)) {
        //echo '0|' . esc_html__("Unblock this user to send message.", 'adforest');
        // die();
        //}
        // Mark as read conversation
        update_comment_meta(get_current_user_id(), $ad_id . "_" . $user_id, 1);

        // do_action('adforest_switch_language_code_from_id', $ad_id);


        $parent = $user_id;
        if ($_POST['inbox'] == 'yes') {
            $parent = get_current_user_id();
        }
        $args = array(
            'author__in' => $authors,
            'post_id' => $ad_id,
            'parent' => $parent,
            'orderby' => 'comment_date',
            'order' => 'ASC',
        );
        $comments = get_comments($args);
        $messages = '';
        $i = 1;
        $total = count($comments);
        if (count($comments) > 0) {
            foreach ($comments as $comment) {
                $user_pic = '';
                $class = 'friend-message';
                if ($comment->user_id == get_current_user_id()) {
                    $class = 'my-message';
                }
                $user_pic = adforest_get_user_dp($comment->user_id);
                $id = '';
                if ($i == $total) {
                    $id = 'id="last_li"';
                }
                $i++;

                $images_meta = get_comment_meta($comment->comment_ID, 'comment_image_meta', true);
                $images_meta = $images_meta != "" ? unserialize($images_meta) : array();
                $images_html = "";
                $counter = 0;
                if (!empty($images_meta)) {
                    foreach ($images_meta as $attach_id) {
                        $img_src = wp_get_attachment_image_src($attach_id);
                        $images_html .= '<a class="sb_msg_image" href="' . esc_url(wp_get_attachment_url($attach_id)) . '" data-fancybox = "gallery"><img src="' . $img_src[0] . '"></a>';
                        $counter++;
                    }
                }

                if ($counter > 4) {
                    $images_html .= '<div class="img_more">' . esc_html__('More', 'adforest') . '</div>';
                }

                $file_meta = get_comment_meta($comment->comment_ID, 'comment_file_meta', true);

                $file_meta = $file_meta != "" ? unserialize($file_meta) : array();
                $files_html = "";
                if (!empty($file_meta)) {
                    $files_html .= '<div>';
                    foreach ($file_meta as $attach_id) {
                        if (wp_attachment_is_image($attach_id)) {
                            $img_src = wp_get_attachment_image_src($attach_id);
                            $files_html .= '<a class="sb_msg_image" href="' . esc_url(wp_get_attachment_url($attach_id)) . '" data-fancybox="gallery"><img src="' . $img_src[0] . '"></a>';
                        } else {
                            $file_url = wp_get_attachment_url($attach_id);
                            $files_html .= '<a class="sb_msg_file" href="' . $file_url . '" target="_blank">' . basename(get_attached_file($attach_id)) . '</a>';
                        }
                    }
                    $files_html .= '</div>';
                }


                $messages .= '<li class="' . $class . ' clearfix" ' . $id . '>
							 <figure class="profile-picture">
                                                         <a href="' . get_author_posts_url($comment->user_id) . '?type=ads" class="link" target="_blank">
								<img src="' . $user_pic . '" class="img-circle" alt="' . esc_html__('Profile Pic', 'adforest') . '"  alt="image">
                                                          </a>          
							 </figure>
							 <div class="message">
								' . $comment->comment_content . '
                                                                   
                                                                    ' . $files_html . '
								<div class="time"><i class="lni lni-timer"></i> ' . adforest_timeago($comment->comment_date) . '</div>
							 </div>
						  </li>';
            }
        }
        echo adforest_return_echo($messages);
        die();
    }
}

// Get Ad Info Dashboard
add_action('wp_ajax_sb_get_ad_package_info', 'sb_get_ad_package_info_callback');
if (!function_exists('sb_get_ad_package_info_callback')) {
    function sb_get_ad_package_info_callback() {
        global $adforest_theme;

        $aid = isset($_POST['ad_id']) ? intval($_POST['ad_id']) : 0;
        if (! $aid) {
            wp_die(); // invalid
        }

        // Only author can view
        if ( get_post_field('post_author', $aid) != get_current_user_id() ) {
            echo esc_html__('Only ad author can view these details', 'adforest');
            wp_die();
        }

        // Expired status?
        $ad_status = get_post_meta($aid, '_adforest_ad_status_', true);
        if ( 'expired' === $ad_status ) {
            echo esc_html__('This ad is expired', 'adforest');
            wp_die();
        }

        // Determine expiry_days
        $expiry_days = get_post_meta($aid, 'package_ad_expiry_days', true);
        if ( $expiry_days === '' ) {
            $expiry_days = ! empty( $adforest_theme['simple_ad_removal'] )
                ? $adforest_theme['simple_ad_removal']
                : '-1';
        }

        // --- ORIGINAL POST DATE META ---
        $orig_date = get_post_meta( $aid, '_adforest_original_post_date', true );
        if ( ! $orig_date ) {
            // First time here: store it
            $current_post_date = get_post_field( 'post_date', $aid );
            update_post_meta( $aid, '_adforest_original_post_date', $current_post_date );
            $orig_date = $current_post_date;
        }
        // Standardize
        $posted_date = date( 'Y-m-d', strtotime( $orig_date ) );

        // Compute expiry date
        if ( $expiry_days === '-1' ) {
            $expiry_date = esc_html__('Unlimited days', 'adforest');
        } else {
            $expiry_date = date( 'Y-m-d', strtotime( "$posted_date +{$expiry_days} days" ) );
        }

        // --- FEATURED DATES ---
        $featured_expiry_days = get_post_meta($aid, 'package_adFeatured_expiry_days', true);
        if ( $featured_expiry_days === '' ) {
            $featured_expiry_days = ! empty( $adforest_theme['featured_expiry'] )
                ? $adforest_theme['featured_expiry']
                : '-1';
        }

        if ( get_post_meta( $aid, '_adforest_is_feature', true ) == '1' ) {
            $featured_date = get_post_meta( $aid, '_adforest_is_feature_date', true );
            if ( $featured_expiry_days === '-1' ) {
                $feature_expiry_date = esc_html__('Unlimited days', 'adforest');
            } else {
                $feature_expiry_date = date( 'Y-m-d', strtotime( "$featured_date +{$featured_expiry_days} days" ) );
            }
        } else {
            $featured_date        = esc_html__('Not featured ad', 'adforest');
            $feature_expiry_date  = esc_html__('Not featured ad', 'adforest');
        }
        if ( ! empty( $posted_date ) && strtotime( $posted_date ) ) {
            $readable = date_i18n( get_option( 'date_format' ), strtotime( $posted_date ) );
        } else {
            $readable = esc_html__( 'N/A', 'adforest' );
        }

        // Build response HTML
        $response  = '<ul>';
        $response .= '<li><label>' . esc_html__('Posted date:', 'adforest') . ' </label><span>' . esc_html($readable) . '</span></li>';
        $response .= '<li><label>' . esc_html__('Expiry date:', 'adforest') . ' </label><span>' . esc_html($expiry_date) . '</span></li>';
        $response .= '<li><label>' . esc_html__('Featured date:', 'adforest') . ' </label><span>' . esc_html($featured_date) . '</span></li>';
        $response .= '<li><label>' . esc_html__('Featured expiry date:', 'adforest') . ' </label><span>' . esc_html($feature_expiry_date) . '</span></li>';
        $response .= '</ul>';

        echo $response;
        wp_die();
    }
}

// Update Ad Status
add_action('wp_ajax_sb_update_ad_status', 'adforest_sb_update_ad_status');
if (!function_exists('adforest_sb_update_ad_status')) {
    function adforest_sb_update_ad_status()
    {
        adforest_authenticate_check();
        $is_demo = adforest_is_demo();
        if ($is_demo) {
            echo '0|' . esc_html__("Not allowed in demo mode", 'adforest');
            die();
        }

        global $adforest_theme;
        $ad_id = $_POST['ad_id'];
        $status = $_POST['status'];
        $previous_staus = get_post_meta($ad_id, '_adforest_ad_status_', true);
        if ($previous_staus == $status) {
            $message = esc_html__("Already ", 'adforest') . $previous_staus;
            echo '0| ' . $message;
            die();
        }

        /*if activating from inactive to active bump it up automatically*/

        if ($status == 'active' && $previous_staus != 'active') {

            $user_id = get_current_user_id();

            $simple_ads = get_user_meta($user_id, '_sb_simple_ads', true);
            $expiry = get_user_meta($user_id, '_sb_expire_ads', true);
            if ($simple_ads == -1) {

            } else if ($simple_ads <= 0) {
                echo '0|' . esc_html__("Please buy package first to reactivate.", 'adforest');
                die();
            }
            if ($expiry != '-1') {
                if ($expiry < date('Y-m-d')) {
                    echo '0|' . esc_html__("Please buy package first reactivate.", 'adforest');
                    die();
                }
            }

            wp_update_post(
                array(
                    'ID' => $ad_id, // ID of the post to update
                    'post_date' => current_time('mysql'),
                    'post_type' => 'ad_post',
                    'post_status' => 'publish',
                    'post_date_gmt' => get_gmt_from_date(current_time('mysql'))
                    // 'post_date_gmt' => get_gmt_from_date(date('Y-m-d H:i:s'))
                )
            );

            $package_ad_expiry_days = get_user_meta($user_id, 'package_ad_expiry_days', true);
            if ($package_ad_expiry_days != "") {
                update_post_meta($ad_id, 'package_ad_expiry_days', $package_ad_expiry_days);
                if ($simple_ads > 0) {
                    $simple_ads = $simple_ads - 1;
                    update_user_meta($user_id, '_sb_simple_ads', $simple_ads);
                }
            }
        }
        $after_expired_ads = isset($adforest_theme['after_expired_ads']) ? $adforest_theme['after_expired_ads'] : "";
        $after_sold_ads = isset($adforest_theme['after_sold_ads']) ? $adforest_theme['after_sold_ads'] : "";
        $expired = "draft";
        if ($after_expired_ads == 'published') {
            $expired = "publish";
        }
        $sold = "draft";
        if ($after_sold_ads == 'published') {
            $sold = "publish";
        }

        $sb_status_array = array(
            'expired' => $expired,
            'sold' => $sold,
            'active' => 'publish',
        );
        update_post_meta($ad_id, '_adforest_ad_status_', $status);
        $my_post = array(
            'ID' => $ad_id,
            'post_status' => $sb_status_array[$status],
            'post_type' => 'ad_post',
        );
        wp_update_post($my_post);


        echo '1|' . esc_html__("Updated successfully.", 'adforest');
        die();
    }
}

// Bump it up
add_action('wp_ajax_sb_bump_it_up', 'adforest_bump_it_up');
if (!function_exists('adforest_bump_it_up')) {

    function adforest_bump_it_up()
    {
        $is_demo = adforest_is_demo();
        if ($is_demo) {
            echo '0|' . esc_html__("Not allowed in demo mode", 'adforest');
            die();
        }
        $ad_id = $_POST['ad_id'];
        $user_id = get_current_user_id();
        $ads_package = $_POST['ads_package'];

        $packageDetails = get_user_meta($user_id, 'adforest_ads_package_details', true);
        $params_ads_package = $ads_package;

        if (isset($packageDetails[$params_ads_package]) && $packageDetails[$params_ads_package] != 0) {
            $package_single = $packageDetails[$params_ads_package];
        }

        $bump_ads_new = isset($package_single['bump_ads']) ? $package_single['bump_ads'] : '';
        $pkg_expiry_date = isset($package_single['pkg_expiry_days']) ? $package_single['pkg_expiry_days'] : '';

        adforest_set_date_timezone();
        if (get_post_field('post_author', $ad_id) == $user_id) {
            global $adforest_theme;
            // Uptaing remaining ads.
            $bump_ads = get_user_meta($user_id, '_sb_bump_ads', true);

            if (isset($adforest_theme['make_bump_up_paid']) && $adforest_theme['make_bump_up_paid'] == true) {
                $url = get_the_permalink($adforest_theme['sb_bump_up_template_page']);
                $redirect_url = $url . "?pid=" . $ad_id;
                wp_send_json_success(array("message" => esc_html__("Post Bumped up Submit.", 'adforest'), 'url' => $redirect_url));

            } else {
                if (!isset($packageDetails[$params_ads_package]) || $packageDetails[$params_ads_package] == 0) {
                    if ($bump_ads > 0 || $bump_ads == '-1' || (isset($adforest_theme['sb_allow_free_bump_up']) && $adforest_theme['sb_allow_free_bump_up'])) {
                        wp_update_post(
                            array(
                                'ID' => $ad_id, // ID of the post to update
                                'post_date' => current_time('mysql'),
                                'post_type' => 'ad_post',
                                'post_date_gmt' => get_gmt_from_date(current_time('mysql'))
                            )
                        );
                        do_action('adforest_wpml_bumpup_ads', $pid);

                        if (!$adforest_theme['sb_allow_free_bump_up'] && $bump_ads != '-1') {
                            $bump_ads = $bump_ads - 1;
                            update_user_meta($user_id, '_sb_bump_ads', $bump_ads);
                            wp_send_json_success(array("message" => esc_html__('Bumped up successfully.', 'adforest')));
                            die();
                        }

                    } else {
                        wp_send_json_error(array("message" => esc_html__('Buy package to make it bump.', 'adforest')));
                        die();
                    }
                } elseif ($bump_ads_new > 0 || $bump_ads_new == '-1') {
                    if ($pkg_expiry_date != '-1') {
                        if ($pkg_expiry_date < date('Y-m-d')) {
                            echo '0|' . esc_html__("Your package has expired", 'adforest');
                            die();
                        }
                        wp_update_post(
                            array(
                                'ID' => $ad_id, // ID of the post to update
                                'post_date' => current_time('mysql'),
                                'post_type' => 'ad_post',
                                'post_date_gmt' => get_gmt_from_date(current_time('mysql'))
                            )
                        );
                        do_action('adforest_wpml_bumpup_ads', $ad_id);

                        if (!$adforest_theme['sb_allow_free_bump_up'] && $bump_ads_new != '-1') {
                            $bump_ads_new = $bump_ads_new - 1;
                            $package_single['bump_ads'] = $bump_ads_new;
                            $packageDetails[$params_ads_package] = $package_single;
                            update_user_meta(get_current_user_id(), 'adforest_ads_package_details', $packageDetails);
                            wp_send_json_success(array("message" => esc_html__('Bumped up successfully.', 'adforest')));
                            die();
                        }
                    } else {
                        if (!$adforest_theme['sb_allow_free_bump_up'] && $bump_ads_new != '-1') {
                            $bump_ads_new = $bump_ads_new - 1;
                            $package_single['bump_ads'] = $bump_ads_new;
                            $packageDetails[$params_ads_package] = $package_single;
                            update_user_meta(get_current_user_id(), 'adforest_ads_package_details', $packageDetails);
                            wp_send_json_success(array("message" => esc_html__('Bumped up successfully.', 'adforest')));
                            die();
                        }
                    }


                } else {
                    wp_send_json_error(array("message" => esc_html__('Buy package to make it bump.', 'adforest')));
                    die();
                }

            }
        } else {
            wp_send_json_error(array("message" => esc_html__('You must be the Ad owner to make it featured.', 'adforest')));
        }

        die();
    }

}

/* Make ad featured  */
add_action('wp_ajax_sb_make_featured', 'adforest_make_featured');
if (!function_exists('adforest_make_featured')) {

    function adforest_make_featured()
    {
        global $adforest_theme;
        $ad_id = $_POST['ad_id'];
        $ads_package = $_POST['ads_package'];

        $packageDetails = get_user_meta(get_current_user_id(), 'adforest_ads_package_details', true);
        $params_ads_package = $ads_package;

        if (isset($packageDetails[$params_ads_package]) && $packageDetails[$params_ads_package] != 0) {
            $package_single = $packageDetails[$params_ads_package];
        }

        $featured_ad_new = isset($package_single['featured_ads']) ? $package_single['featured_ads'] : '';
        $pkg_expiry_date = isset($package_single['pkg_expiry_days']) ? $package_single['pkg_expiry_days'] : '';

        $user_id = get_current_user_id();
        $is_demo = adforest_is_demo();
        if ($is_demo) {
            echo '0|' . esc_html__("Not allowed in demo mode", 'adforest');
            die();
        }
        if (get_post_field('post_author', $ad_id) == $user_id) {
            if (get_post_meta($ad_id, '_adforest_is_feature', true) == '1') {
                wp_send_json_error(array("message" => esc_html__("This ad is featured already.", 'adforest')));
            }

            $featured_ads = get_user_meta($user_id, '_sb_featured_ads', true);
            if (isset($adforest_theme['make_feature_paid']) && $adforest_theme['make_feature_paid'] == true && get_post_meta($ad_id, '_adforest_is_feature', true) != "1") {
                $url = get_the_permalink($adforest_theme['sb_feature_template_page']);
                // ITHY
                $redirect_url = $url . "?pid=" . $ad_id;
                wp_send_json_success(array("message" => esc_html__("Redirecting....", 'adforest'), 'url' => $redirect_url));
                die();
            } else {
                if (!isset($packageDetails[$params_ads_package]) || $packageDetails[$params_ads_package] == 0) {
                    if ($featured_ads != 0 && $featured_ads != "") {

                        if (get_user_meta($user_id, '_sb_expire_ads', true) != '-1') {
                            if (get_user_meta($user_id, '_sb_expire_ads', true) < date('Y-m-d')) {
                                wp_send_json_error(array("message" => esc_html__("Your package has expired", 'adforest')));
                                // echo '0|' . esc_html__("Your package has expired", 'adforest');
                                die();
                            }
                        }
                        $feature_ads = get_user_meta($user_id, '_sb_featured_ads', true);
                        $feature_ads = (int)$feature_ads - 1;
                        update_user_meta($user_id, '_sb_featured_ads', $feature_ads);
                        update_post_meta($ad_id, '_adforest_is_feature', '1');
                        update_post_meta($ad_id, '_adforest_is_feature_date', date('Y-m-d'));

                        $package_adFeatured_expiry_days = get_user_meta($user_id, 'package_adFeatured_expiry_days', true);
                        if ($package_adFeatured_expiry_days) {
                            update_post_meta($ad_id, 'package_adFeatured_expiry_days', $package_adFeatured_expiry_days);
                        }

                        do_action('adforest_wpml_make_featured', $ad_id);
                        $ad_meta = get_post_meta($ad_id);

                        if ($ad_meta['_adforest_is_feature'][0] != 0) {
                            // echo '1|' . esc_html__("This ad has been featured successfullly", 'adforest');
                            wp_send_json_success(array("message" => esc_html__("This ad has been featured successfully.", 'adforest')));
                        } else {
                            wp_send_json_error(array("message" => esc_html__("Something Went Wrong", 'adforest')));
                        }
                    } else {
                        wp_send_json_error(array("message" => esc_html__("No Featured Ads in Selected Package", 'adforest')));
                    }
                } elseif ($featured_ad_new != 0 && $featured_ad_new != "") {

                    if ($pkg_expiry_date != '-1') {
                        if ($pkg_expiry_date < date('Y-m-d')) {
                            wp_send_json_error(array("message" => esc_html__("Your package has expired", 'adforest')));
                            die();
                        }
                    }
                    update_post_meta($ad_id, '_adforest_is_feature', '1');
                    update_post_meta($ad_id, '_adforest_is_feature_date', date('Y-m-d'));
                    $ad_meta = get_post_meta($ad_id);

                    if ($ad_meta['_adforest_is_feature'][0] != 0) {
                        $featured_ad_new = $featured_ad_new - 1;
                        $package_single['featured_ads'] = $featured_ad_new;
                        $packageDetails[$params_ads_package] = $package_single;
                        update_user_meta(get_current_user_id(), 'adforest_ads_package_details', $packageDetails);
                        wp_send_json_success(array("message" => esc_html__("This ad has been featured successfully.", 'adforest')));
                    } else {
                        wp_send_json_error(array("message" => esc_html__("Something Went Wrong", 'adforest')));
                    }
                } else {
                    wp_send_json_error(array("message" => esc_html__("No Featured Ads in Selected Package", 'adforest')));
                }
            }
        } else {
            wp_send_json_error(array("message" => esc_html__("You must be the Ad owner to make it featured.", 'adforest')));
        }
        die();
    }
}

// Ajax handler for messages
add_action('wp_ajax_my_msgs', 'adforest_my_msgs');
if (!function_exists('adforest_my_msgs')) {

    function adforest_my_msgs()
    {
        echo adforest_return_echo(adforest_get_messages(get_current_user_id()));
        die();
    }

}

if (!function_exists('adforest_get_messages')) {
    function adforest_get_messages($user_id)
    {
        global $adforest_theme;
        $script = '<script type="text/javascript">jQuery(document).ready(function($){"use strict";                   
              if ($("#file_attacher").length > 0) {
               var attachmentsDropzone = new Dropzone(document.getElementById(\'file_attacher\'), {
                    url: adforest_ajax_url,
                    autoProcessQueue: true,
                    previewsContainer: "#attachment-wrapper",
                    previewTemplate: \'<span class="dz-preview dz-file-preview"><span class="dz-details"><span class="dz-filename"><i class="fa fa-link"></i>&nbsp;&nbsp;&nbsp;<span data-dz-name></span></span>&nbsp;&nbsp;&nbsp;<span class="dz-size" data-dz-size></span>&nbsp;&nbsp;&nbsp;<i class="fa fa-times" style="cursor:pointer;font-size:15px;" data-dz-remove></i></span><span class="dz-progress"><span class="dz-upload" data-dz-uploadprogress></span></span><i class="ti ti-refresh ti-spin"></i></span>\',
                    clickable: "a.msgAttachFile",
                    acceptedFiles: $(\'#provided_format\').val(),
                    maxFilesize: 15,
                    maxFiles: 4
                });
                attachmentsDropzone.on("sending",function(){
                        console.log("eeeee");
			$("#send_msg ,#send_ad_message").attr("disabled",true);
		});
                attachmentsDropzone.on("queuecomplete",function(){
			$("#send_msg, #send_ad_message").attr("disabled",false);
		});                

                  } $(\'.message-history\').wrap(\'<div class="list-wrap"></div>\');function scrollbar() {var $scrollbar = $(\'.message-inbox .list-wrap\');$scrollbar.perfectScrollbar({maxScrollbarLength: 150,});$scrollbar.perfectScrollbar(\'update\');}scrollbar();$(\'.messages\').wrap(\'<div class="list-wraps"></div>\');function scrollbar1() {var $scrollbar1 = $(\'.message-details .list-wraps\');$scrollbar1.perfectScrollbar({maxScrollbarLength: 150,});$scrollbar1.perfectScrollbar(\'update\');}scrollbar1();});</script>';

        $script = apply_filters('adforest_blocked_user_scripts', $script);
        global $wpdb;
        $rows = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_type = 'ad_post' AND user_id = '$user_id' AND comment_parent = '$user_id' GROUP BY comment_post_ID ORDER BY comment_ID DESC");
        $users = '';
        $messages = '';
        $form = '<div class="text-center">' . esc_html__('No message received on this ad yet.', 'adforest') . '</div>';
        $author_html = '';
        $turn = 1;
        $level_2 = '';
        $title_html = '';
        foreach ($rows as $row) {
            $last_date = $row->comment_date;
            $date = explode(' ', $last_date);
            $author = get_post_field('post_author', $row->comment_post_ID);
            $cls = '';
            if ($turn == 1)
                $cls = 'message-history-active';
            $ad_img = adforest_get_ad_default_image_url('adforest-ad-related');
            $media = adforest_get_ad_images($row->comment_post_ID);
            if (count($media) > 0) {
                foreach ($media as $m) {
                    $mid = '';
                    if (isset($m->ID))
                        $mid = $m->ID;
                    else
                        $mid = $m;

                    $img = wp_get_attachment_image_src($mid, 'adforest-ad-related');
                    $ad_img = $img[0];
                    break;
                }
            }
            if (isset($row->comment_post_ID) && $row->comment_post_ID != "") {
                if ($turn == 1) {
                    $title_html .= '<h2 class="padding-top-20 sb_ad_title" id="title_for_' . esc_attr($row->comment_post_ID) . '"><a href="' . get_the_permalink($row->comment_post_ID) . '" target="_blank" >' . get_the_title($row->comment_post_ID) . '</a></h2>';
                } else {
                    $title_html .= '<h2 class="padding-top-20 sb_ad_title no-display" id="title_for_' . esc_attr($row->comment_post_ID) . '" ><a href="' . get_the_permalink($row->comment_post_ID) . '" target="_blank" >' . get_the_title($row->comment_post_ID) . '</a></h2>';
                }
            }
            $ad_id = $row->comment_post_ID;
            $comment_author = get_userdata($author);
            $msg_status = get_comment_meta(get_current_user_id(), $ad_id . "_" . $author, true);
            $status = '';
            if ($msg_status == '0') {
                $status = '<i class="fa fa-envelope" aria-hidden="true"></i>';
            }
            $users .= '<li class="user_list ad_title_show ' . $cls . '" cid="' . $row->comment_post_ID . '" second_user="' . $author . '" inbox="yes" id="sb_' . $author . '_' . $ad_id . '" sb_msg_token="' . wp_create_nonce('sb_msg_secure') . '">
					 <a href="javascript:void(0);">
						<div class="image"><img src="' . $ad_img . '" alt="' . $comment_author->display_name . '"></div>
						<div class="user-name">
						   <div class="author"><span>' . get_the_title($ad_id) . '</span></div>
						   <p>' . $comment_author->display_name . '</p>
						   <div class="time" id="' . $author . '_' . $ad_id . '">' . $status . '</div>
						</div>
					 </a>
				  </li>
';
            $authors = array($author, get_current_user_id());
            if ($turn == 1) {
                $block_user_html = '';
                // do_action('adforest_switch_language_code_from_id', $ad_id);
                $args = array(
                    'author__in' => $authors,
                    'post_id' => $ad_id,
                    'parent' => get_current_user_id(),
                    'post_type' => 'ad_post',
                    'orderby' => 'comment_date',
                    'order' => 'ASC',
                );
                $comments = get_comments($args);
                if (count($comments) > 0) {
                    foreach ($comments as $comment) {
                        $user_pic = '';
                        $class = 'friend-message';
                        if ($comment->user_id == get_current_user_id()) {
                            $class = 'my-message';
                        }
                        $user_pic = adforest_get_user_dp($comment->user_id);
                        $images_meta = get_comment_meta($comment->comment_ID, 'comment_image_meta', true);
                        $images_meta = $images_meta != "" ? unserialize($images_meta) : array();
                        $images_html = "";
                        $counter = 0;
                        if (!empty($images_meta)) {
                            foreach ($images_meta as $attach_id) {
                                $img_src = wp_get_attachment_image_src($attach_id);
                                $images_html .= '<a class="sb_msg_image" href="' . esc_url(wp_get_attachment_url($attach_id)) . '" data-fancybox = "gallery"><img src="' . $img_src[0] . '"></a>';
                                $counter++;
                            }
                        }
                        if ($counter > 4) {
                            $images_html .= '<div class="img_more">' . esc_html__('More', 'adforest') . '</div>';
                        }
                        $file_meta = get_comment_meta($comment->comment_ID, 'comment_file_meta', true);
                        $file_meta = $file_meta != "" ? unserialize($file_meta) : array();
                        $files_html = "";
                        if (!empty($file_meta)) {
                            $files_html .= '<div>';
                            foreach ($file_meta as $attach_id) {
                                if (wp_attachment_is_image($attach_id)) {
                                    $img_src = wp_get_attachment_image_src($attach_id);
                                    $files_html .= '<a class="sb_msg_image" href="' . esc_url(wp_get_attachment_url($attach_id)) . '" data-fancybox="gallery"><img src="' . $img_src[0] . '"></a>';
                                } else {
                                    $file_url = wp_get_attachment_url($attach_id);
                                    $files_html .= '<a class="sb_msg_file" href="' . $file_url . '" target="_blank">' . basename(get_attached_file($attach_id)) . '</a>';
                                }
                            }
                            $files_html .= '</div>';
                        }
                        $messages .= '<li class="' . $class . ' clearfix"><figure class="profile-picture"><a href="' . get_author_posts_url($comment->user_id) . '?type=ads" class="link" target="_blank"><img src="' . $user_pic . '" class="img-circle" alt="' . esc_html__('Profile Pic', 'adforest') . '"></a></figure><div class="message">' . $comment->comment_content . '' . $images_html . '                                                                ' . $files_html . '<div class="time"><i class="fa fa-clock-o"></i> ' . adforest_timeago($comment->comment_date) . '</div></div></li>';
                    }
                }
                $allow_attachment = isset($adforest_theme['allow_media_upload_messaging']) ? $adforest_theme['allow_media_upload_messaging'] : false;
                $attachment_html = "";
                if ($allow_attachment) {
                    $attachment_html = '<div id="attachment-wrapper" class="attachment-wrapper"></div>           
                                       <div class="file_attacher" id="file_attacher">
                                         <a href="javascript:void(0)" class="msgAttachFile dz-clickable"><i class="fa fa-link"></i>' . esc_html__('Add Attachment', 'adforest') . '</a>
                                         
                                         </div>                             
                                    ';
                }
                // Message form
                $level_2 = '<input type="hidden" name="usr_id" value="' . $user_id . '" id="user_id"/><input type="hidden" id="usr_id" value="' . $author . '" /><input type="hidden" id="rece_id" name="rece_id" value="' . $author . '" /><input type="hidden" name="msg_receiver_id" id="msg_receiver_id" value="' . esc_attr($author) . '" />';
                $block_user_html = apply_filters('adforest_blocked_button_html', $block_user_html, $author, $user_id);
                $verifed_phone_number = adforest_check_if_phoneVerified();
                if ($verifed_phone_number) {
                    $form = '<div role="alert" class="alert alert-info alert-dismissible">' . esc_html__("Please verify your phone number to send a message.", "adforest") . ' 
                 </div>';
                } else {
                    $user_info = get_userdata(get_current_user_id());
                    $form = '<form role="form" class="form-inline" id="send_message">
                            
                             <div class="form-group">
                            
                                <input type="hidden" name="ad_post_id" id="ad_post_id" value="' . $ad_id . '" />
                                <input type="hidden" name="name" value="' . $user_info->display_name . '" />
                                <input type="hidden" name="email" value="' . $user_info->user_email . '" />
							 ' . $level_2 . '
                                <input name="message" id="sb_forest_message" placeholder="' . esc_html__('Type a message here...', 'adforest') . '" class="form-control message-text" autocomplete="off" type="text" data-parsley-required="true" data-parsley-error-message="' . esc_html__('This field is required.', 'adforest') . '">
                             </div>

                             <button class="btn btn-theme" id="send_msg" type="submit" inbox="yes" sb_msg_token="' . wp_create_nonce('sb_msg_secure') . '">' . esc_html__('Send', 'adforest') . '</button>
                              ' . $attachment_html . '
                          </form>';
                }
            }
            $turn++;
        }
        if ($users == '') {
            $users = '<li class="padding-top-30 padding-bottom-20"><div class="user-name">' . esc_html__('Nothing Found.', 'adforest') . '</div></li>';
        }
        return $script . '<div>
               <div class="message-body row">
                 <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="message-inbox">
                       <div class="message-header">
                            <h4>' . esc_html__('Ads:', 'adforest') . '</h4>
                            <div class="message-tabs"> 
                              <span><a style="font-size: 12px" class="messages_actions active" sb_action="my_msgs"><small>' . esc_html__(' Sent Offers', 'adforest') . '</small></a></span>
                              <span><a style="font-size: 12px" class="messages_actions" sb_action="received_msgs_ads_list"><small>' . esc_html__('Received Offers', 'adforest') . '</small></a></span>
                              <span><a style="font-size: 12px" class="messages_actions" sb_action="adforest_all_blocked_users"><small>' . esc_html__('Blocked users', 'adforest') . ' </small></a></span>  
                            </div>   
                       </div>
                        <ul class="message-history">' . $users . '</ul>
                    </div>
                 </div>
                 <div class="col-md-8 clearfix col-sm-6 col-xs-12 message-content">
				 	' . $title_html . '
                    <div class="message-details">
                        ' . $block_user_html . '
                       <ul class="messages" id="messages">' . $messages . '</ul>
                       <div class="chat-form ">' . $form . '</div>
                    </div>
                 </div>
              </div>
           </div>';
    }
}

add_action('wp_ajax_del_job_alerts', 'adforest_del_job_alerts');
if (!function_exists('adforest_del_job_alerts')) {
    function adforest_del_job_alerts()
    {
        $is_demo = adforest_is_demo();
        if ($is_demo) {
            echo '0|' . esc_html__("Not allowed in demo mode", 'adforest');
            die();
        }
        global $nokri;
        $user_id = get_current_user_id();
        $alert_id = $_POST['alert_id'];
        /* demo check */
        if ($alert_id != "") {
            if (delete_user_meta($user_id, $alert_id)) {
                echo '1|' . esc_html__("Deleted successfully.", 'adforest');
                die();
            } else {
                echo '0|' . esc_html__("Unable to delete", 'adforest');
                die();
            }
        }
        echo '0|' . esc_html__("Unable to delete", 'adforest');
        die();
    }
}

// Remove Ad
add_action('wp_ajax_sb_remove_ad', 'adforest_sb_remove_ad');
if (!function_exists('adforest_sb_remove_ad')) {
    function adforest_sb_remove_ad()
    {
        $is_demo = adforest_is_demo();
        if ($is_demo) {
            echo '0|' . esc_html__("Not allowed in demo mode", 'adforest');
            die();
        }

        adforest_authenticate_check();

        $ad_id = $_POST['ad_id'];
        $stored_status = get_post_meta($ad_id, '_adforest_ad_status_', true);
        if (wp_trash_post($ad_id)) {
            echo '1|' . esc_html__("Ad removed successfully.", 'adforest');
        } else {
            echo '0|' . esc_html__("There's some problem, please try again later.", 'adforest');
        }

        die();
    }
}

if (!function_exists('adforest_pagination_ads')) {

    function adforest_pagination_ads($wp_query)
    {
        if (is_singular())
            //return;

            if ($wp_query->max_num_pages <= 1)
                return;

        if (get_query_var('paged')) {
            $paged = get_query_var('paged');
        } elseif (get_query_var('page')) {
            $paged = get_query_var('page');
        } else {
            $paged = 1;
        }

        $max = intval($wp_query->max_num_pages);
        if ($paged >= 1)
            $links[] = $paged;

        if ($paged >= 3) {
            $links[] = $paged - 1;
            $links[] = $paged - 2;
        }

        if (($paged + 2) <= $max) {
            $links[] = $paged + 2;
            $links[] = $paged + 1;
        }

        $pagination = "";

        $pagination .= '<ul class="pagination pagination-lg">' . "\n";

        if (get_previous_posts_link())
            $pagination .= '<li>' . get_previous_posts_link() . '</li>' . "\n";

        if (!in_array(1, $links)) {
            $class = 1 == $paged ? ' class="active"' : '';

            $pagination .= '<li  ' . $class . '><a href="' . esc_url(get_pagenum_link(1)) . '">1</a></li>' . "\n";

            if (!in_array(2, $links))
                $pagination .= '<li><a href="javascript:void(0);">...</a></li>';
        }
        sort($links);
        foreach ((array)$links as $link) {

            $class = $paged == $link ? ' class="active"' : '';
            $pagination .= '<li ' . $class . '><a href="' . esc_url(get_pagenum_link($link)) . '">' . $link . '</a></li>' . "\n";
        }
        if (!in_array($max, $links)) {
            if (!in_array($max - 1, $links))
                $pagination .= '<li><a href="javascript:void(0);">...</a></li>' . "\n";
            $class = $paged == $max ? ' class="active"' : '';
            $pagination .= '<li ' . $class . '><a href="' . esc_url(get_pagenum_link($max)) . '">' . $max . '</a></li>' . "\n";
        }

        if (get_next_posts_link_custom($wp_query))
            $pagination .= '<li>' . get_next_posts_link_custom($wp_query) . '</li>' . "\n";

        return $pagination .= '</ul>' . "\n";
    }
}

add_action('wp_ajax_adforest_mark_notification_message_as_read', 'adforest_mark_notification_message_as_read');
add_action('wp_ajax_nopriv_adforest_mark_notification_message_as_read', 'adforest_mark_notification_message_as_read'); // For non-logged-in users (if needed)

function adforest_mark_notification_message_as_read()
{
    global $wpdb;

    if (!isset($_POST['message_id']) || !is_numeric($_POST['message_id'])) {
        wp_send_json_error(esc_html__('Invalid request.', 'adforest'));
        wp_die();
    }

    $message_id = intval($_POST['message_id']);

    $updated = $wpdb->update(
        "{$wpdb->prefix}sb_chat_messages",
        array('read_status' => 1),
        array('id' => $message_id)
    );

    if ($updated !== false) {
        wp_send_json_success(esc_html__('Message marked as read.', 'adforest'));
    } else {
        wp_send_json_error(esc_html__('Failed to update message.', 'adforest'));
    }

    wp_die();
}

if (!function_exists("adforest_dashboard_breadcrumb")) {
    function adforest_dashboard_breadcrumb($page_title)
    {
        $breadcrumb = '
                        <div class="title-wrapper">
                            <div class="row align-items-center">
                                <div class="col-md-6">
                                    <div class="title">
                                        <h2>' . esc_html($page_title) . '</h2>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="breadcrumb-wrapper">
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb">
                                                <li class="breadcrumb-item">
                                                    <a href="' . get_the_permalink() . '">' . esc_html__("Dashboard", "adforest") . '</a>
                                                </li>
                                                <li class="breadcrumb-item active" aria-current="page">
                                                    ' . esc_html($page_title) . '
                                                </li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
        ';
        return $breadcrumb;
    }
}

/**
 * Ad Dashboard Templates
 *
 * A modular approach to display different types of ads in user dashboard
 */

/**
 * Get query arguments based on ad type
 *
 * @param string $ad_type Type of ads to display
 * @return array Query arguments for WP_Query
 */
function adforest_get_ads_query_args($ad_type)
{
    global $adforest_theme;
    $user_id = get_current_user_id();
    $paged = get_query_var('paged', 1);
    $posts_per_page = get_option('posts_per_page');

    $args = array(
        'post_type' => 'ad_post',
        'author' => $user_id,
        'posts_per_page' => $posts_per_page,
        'paged' => $paged,
        'order' => 'DESC',
    );

    switch ($ad_type) {
        case 'my_ads':
            $args['post_status'] = 'publish';
            $args['orderby'] = 'date';
            $args['meta_query'] = array(
                array(
                    'key'     => '_adforest_ad_status_',
                    'value'   => array( 'expired', 'sold' ),
                    'compare' => 'NOT IN',
                ),
            );
            break;

        case 'featured_ads':
            $args['post_status'] = 'publish';
            $args['meta_key'] = '_adforest_is_feature';
            $args['meta_value'] = '1';
            $args['orderby'] = 'ID';
            $args['meta_query'] = array(
                array(
                    'key'     => '_adforest_ad_status_',
                    'value'   => array( 'expired', 'sold' ),
                    'compare' => 'NOT IN',
                ),
            );
            break;

        case 'expired_ads':
            $after_expired_ads = isset($adforest_theme['after_expired_ads']) ? $adforest_theme['after_expired_ads'] : "";
            if ($after_expired_ads == "published") {
                $args['post_status'] = array('draft', 'publish');
                $args['orderby'] = 'ID';
                $args['meta_query'] = array(
                    'relation' => 'OR',
                    array(
                        'key' => '_adforest_ad_status_',
                        'value' => 'expired',
                        'compare' => '=',
                    ),
                    array(
                        'key' => '_adforest_ad_status_',
                        'value' => 'sold',
                        'compare' => '=',
                    ),
                );
            } else {
                $args['post_status'] = array('draft');
                $args['orderby'] = 'ID';
            }
            break;

        case 'inactive_ads':
            $args['post_status'] = array('pending');
            $args['orderby'] = 'ID';
            break;

        case 'rejected_ads':
            $args['post_status'] = 'rejected';
            $args['orderby'] = 'ID';
            break;

        case 'fav_ads':
            global $wpdb;
            $uid = get_current_user_id();
            $rows = $wpdb->get_results("SELECT meta_value FROM $wpdb->usermeta WHERE user_id = '$uid' AND meta_key LIKE '_sb_fav_id_%'");
            $pids = array(0);
            foreach ($rows as $row) {
                $pids[] = $row->meta_value;
            }
            $args['post__in'] = $pids;
            $args['post_status'] = 'publish';
            $args['orderby'] = 'date';
            $args['meta_query'] = array(
                array(
                    'key'     => '_adforest_ad_status_',
                    'value'   => array( 'expired', 'sold' ),
                    'compare' => 'NOT IN',
                ),
            );
            break;
    }

    return $args;
}

/**
 * Get page title based on ad type
 *
 * @param string $ad_type Type of ads
 * @return string Page title
 */
function adforest_get_page_title($ad_type)
{
    switch ($ad_type) {
        case 'my_ads':
            return esc_html__("My Ads", "adforest");
        case 'featured_ads':
            return esc_html__("Featured Ads", "adforest");
        case 'expired_ads':
            return esc_html__("Expired/Sold Ads", "adforest");
        case 'inactive_ads':
            return esc_html__("Inactive Ads", "adforest");
        case 'rejected_ads':
            return esc_html__("Rejected Ads", "adforest");
        case 'fav_ads':
            return esc_html__("Favourite Ads", "adforest");
        default:
            return esc_html__("My Ads", "adforest");
    }
}

/**
 * Get the actions/buttons to display for each ad based on type
 *
 * @param int $ad_id Post ID
 * @param string $ad_type Type of ad
 * @return string HTML for action buttons
 */
function adforest_get_ad_actions($ad_id, $ad_type)
{
    global $adforest_theme;
    $sb_post_ad_page = apply_filters('adforest_language_page_id', $adforest_theme['sb_post_ad_page']);
    $ad_update_url = adforest_set_url_param(get_the_permalink($sb_post_ad_page), 'id', $ad_id);
    $html = '';

    $bump_ads = get_user_meta(get_current_user_id(), '_sb_bump_ads', true);
    $bump_up_ads_class = '';
    if ($bump_ads > 0 || $bump_ads == '-1' || (isset($adforest_theme['sb_allow_free_bump_up']) && $adforest_theme['sb_allow_free_bump_up'])) {
        $bump_up_ads_class = 'bump_it_up_new_pkg';
    } else {
        $bump_up_ads_class = 'bump_it_up_new_pkg';
    }

    $make_bump_up_paid_url = "#";
    if (isset($adforest_theme['make_bump_up_paid']) && $adforest_theme['make_bump_up_paid'] &&
        isset($adforest_theme['sb_bump_up_template_page']) && $adforest_theme['sb_bump_up_template_page'] != 0) {
        $bump_up_ads_class = '';
        $make_bump_up_paid_url = (isset($adforest_theme['sb_bump_up_template_page']) && $adforest_theme['sb_bump_up_template_page'] != "")
            ? get_the_permalink($adforest_theme['sb_bump_up_template_page']) . '?pid=' . $ad_id
            : "javascript:void(0)";
    }

    $featured_ads = get_user_meta(get_current_user_id(), '_sb_featured_ads', true);
    $sb_expire_ads = get_user_meta(get_current_user_id(), '_sb_expire_ads', true);

    if ($featured_ads != 0 && $featured_ads != "" && ($sb_expire_ads != '-1' || $sb_expire_ads < date('Y-m-d'))) {
        $ad_featured = 'sb_make_feature_ad_new_pkg';
    } else {
        $ad_featured = 'sb_make_feature_ad_new_pkg';
    }

    $make_feature_paid_url = "#";
    if (isset($adforest_theme['make_feature_paid']) && $adforest_theme['make_feature_paid'] &&
        isset($adforest_theme['sb_feature_template_page']) && $adforest_theme['sb_feature_template_page'] != 0) {
        $ad_featured = '';
        $make_feature_paid_url = (isset($adforest_theme['sb_feature_template_page']) && $adforest_theme['sb_feature_template_page'] != "")
            ? get_the_permalink($adforest_theme['sb_feature_template_page']) . '?pid=' . $ad_id
            : "javascript:void(0)";
    }

    $html .= '<div class="action justify-content-end">';

    $html .= '<div class="ad_action_container d-flex justify-content-center align-items-center gap-4">';
    $is_featured = get_post_meta(get_the_ID(), '_adforest_is_feature', true) == '1';
    $star_class = $is_featured ? 'lni lni-star-filled' : 'lni lni-star';
    $inline_style = $is_featured ? 'pointer-events: none; cursor: default;' : '';
    $link_class = $is_featured ? '' : $ad_featured;

    if ($ad_type == 'my_ads') {
        if ($is_featured) {
            // Non-clickable span with tooltip "Already Featured"
            $html .= '<span class="non-clickable-featured" 
                   data-bs-toggle="tooltip" data-bs-placement="top" 
                   title="' . esc_html__("Already Featured", "adforest") . '" 
                   style="cursor: default;">
                   <i class="' . esc_attr($star_class) . '"></i>
              </span>';
        } else {
            // Clickable link to make featured
            $html .= '<a href="' . esc_url($make_feature_paid_url) . '" class="' . esc_attr($link_class) . '" 
               data-bs-toggle="tooltip" data-bs-placement="top"
               title="' . esc_html__("Make Featured", "adforest") . '" data-aaa-id="' . esc_attr(get_the_ID()) . '">
               <i class="' . esc_attr($star_class) . '"></i>
              </a>';
        }
        $html .= '<a href="' . esc_url($make_bump_up_paid_url, "adforest") . '" class="' . esc_attr($bump_up_ads_class) . '" 
                   data-bs-toggle="tooltip" data-bs-placement="top"
                   title="' . esc_html__("Bump up Ad", "adforest") . '" data-aaa-id="' . esc_attr($ad_id) . '">
                   <i class="lni lni-arrow-up-circle"></i>
                </a>';
    } elseif ($ad_type == 'featured_ads') {
        $html .= '<a href="javascript:void(0)" class="' . $bump_up_ads_class . '" 
                   data-bs-toggle="tooltip" data-bs-placement="top"
                   title="' . esc_html__("Bump Up Ad", "adforest") . '" data-aaa-id="' . esc_attr($ad_id) . '">
                   <i class="lni lni-arrow-up-circle"></i>
                </a>';
    } elseif ($ad_type == 'fav_ads') {
        $html .= '<a href="javascript:void(0)" class="remove_fav_ad" 
                   data-bs-toggle="tooltip" data-bs-placement="top"
                   title="' . esc_html__("Remove Favourite", "adforest") . '" data-aaa-id="' . esc_attr($ad_id) . '">
                   <i class="mdi mdi-tag-remove-outline"></i>
                </a>';
    }

    if ($ad_type != 'expired_ads' && $ad_type != 'inactive_ads' && $ad_type != 'rejected_ads') {
        $html .= '<a href="' . esc_url($ad_update_url) . '" class="edit" data-bs-toggle="tooltip" data-bs-placement="top"
                   title="' . esc_html__("Edit Ad", "adforest") . '">
                   <i class="lni lni-pencil"></i>
                </a>';
    } else {
        $html .= '<a href="' . esc_url($ad_update_url) . '" class="edit" data-bs-toggle="tooltip" data-bs-placement="top"
                   title="' . esc_html__("Edit Ad", "adforest") . '">
                   <i class="lni lni-pencil"></i>
                </a>';
    }

    $html .= '</div>';

    $html .= '<button class="more-btn ml-10 dropdown-toggle" 
                    id="moreAction' . $ad_id . '" data-bs-toggle="dropdown" 
                    aria-expanded="false">
                <i class="lni lni-more-alt"></i>
            </button>';

    $html .= '<ul class="dropdown-menu dropdown-menu-end" 
                aria-labelledby="moreAction' . $ad_id . '">';

    $html .= '<li class="dropdown-item">
                <a href="javascript:void(0)" class="text-gray ad_package_info" 
                   data-adid="' . $ad_id . '">' . esc_html__("Info", "adforest") . '</a>
            </li>';

    if ($ad_type != 'my_ads' && $ad_type != 'inactive_ads') {
        $html .= '<li class="dropdown-item">
                    <a href="javascript:void(0)" class="text-gray ad_status" 
                       data-adid="' . $ad_id . '" data-value="active">' . esc_html__("Active", "adforest") . '</a>
                </li>';
    }

    if ($ad_type != 'expired_ads' && $ad_type != 'inactive_ads') {
        $html .= '<li class="dropdown-item">
                    <a href="javascript:void(0)" class="text-gray ad_status" 
                       data-adid="' . $ad_id . '" data-value="expired">' . esc_html__("Expire", "adforest") . '</a>
                </li>';
    }

    if ($ad_type != 'inactive_ads') {
        $html .= '<li class="dropdown-item">
                <a href="javascript:void(0)" class="text-gray ad_status" 
                   data-adid="' . $ad_id . '" data-value="sold">' . esc_html__("Sold", "adforest") . '</a>
            </li>';
    }

    $html .= '<li class="dropdown-item">
                <a href="javascript:void(0)" class="text-gray remove_ad" 
                   data-adid="' . $ad_id . '" data-value="expired">' . esc_html__("Delete", "adforest") . '</a>
            </li>';

    $html .= '</ul></div>';

    return $html;
}

/**
 * Display the ads table
 *
 * @param string $ad_type Type of ads to display
 */
function adforest_display_ads_table($ad_type, $table_class)
{
    $args = adforest_get_ads_query_args($ad_type);
    $query = new WP_Query($args);

    $page_title = adforest_get_page_title($ad_type);
    echo adforest_dashboard_breadcrumb($page_title);

    ?>
    <div class="row">
        <!-- Ads Table -->
        <div class="col-12">
            <div class="card-style mb-30">
                <div class="table-responsive">
                    <table class="table top-selling-table dashboard-<?php echo esc_attr($table_class); ?>">
                        <thead>
                        <tr>
                            <th class="min-width">
                                <h6 class="text-sm text-medium"><?php echo esc_html__("Ad Title", "adforest"); ?></h6>
                            </th>
                            <th class="min-width">
                                <h6 class="text-sm text-medium"><?php echo esc_html__("Price", "adforest"); ?></h6>
                            </th>
                            <th class="min-width">
                                <h6 class="text-sm text-medium"><?php echo esc_html__("Status", "adforest"); ?></h6>
                            </th>
                            <th>
                                <h6 class="text-sm text-medium text-end"><?php echo esc_html__("Actions", "adforest"); ?></h6>
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if ($query->have_posts()) : ?>
                            <?php while ($query->have_posts()) : $query->the_post(); ?>
                                <?php
                                $ad_details = get_ad_post_details(get_the_ID());
                                $first_img = $ad_details['img'];
                                $title = $ad_details['ad_title'];
                                $price = $ad_details['price'];
                                $ad_permalink = $ad_details['ad_link'];
                                $post_status = get_post_status(get_the_ID());
                                $status_label = ucfirst($post_status);

                                $tr_class = ($ad_type == 'fav_ads') ? 'class="holder-' . get_the_ID() . '"' : '';
                                $posted_time = get_the_time('U', get_the_ID());
                                ?>
                                <tr <?php if ($tr_class) echo 'class="' . esc_attr($tr_class) . '"'; ?>>
                                    <td>
                                        <div class="product">
                                            <div class="image">
                                                <img src="<?php echo esc_url($first_img); ?>"
                                                     alt="<?php echo esc_attr($title); ?>"/>
                                            </div>
                                            <a href="<?php echo get_permalink(get_the_ID()); ?>">
                                                <p class="text-sm"><?php echo esc_html($title); ?></p>
                                                <p class="ad-date"><?php echo adforest_get_ad_posted_date($posted_time); ?></p>
                                            </a>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="table-price-dash">
                                            <?php
                                            $price_output = adforest_adPrice( get_the_ID(), 'negotiable', 'p' );
                                            if ( ! empty( $price_output ) ) {
                                                echo $price_output;
                                            } else {
                                                echo esc_html__( 'No Price', 'adforest' );
                                            }
                                            ?>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="status-btn <?php echo esc_attr($post_status); ?>-btn"><?php echo esc_html($status_label); ?></span>
                                    </td>
                                    <?php if ($ad_type == 'fav_ads') { ?>
                                        <td>
                                            <a href="javascript:void(0)" class="remove_fav_ad"
                                               data-bs-toggle="tooltip" data-bs-placement="top"
                                               title="<?php echo esc_attr__("Remove Favorite", "adforest"); ?>"
                                               data-aaa-id="<?php echo esc_attr(get_the_ID()) ?>">
                                                <i class="mdi mdi-tag-remove-outline"></i>
                                            </a>
                                        </td>
                                    <?php } else { ?>
                                        <td>
                                            <?php echo adforest_get_ad_actions(get_the_ID(), $ad_type); ?>
                                        </td>
                                    <?php } ?>
                                </tr>
                            <?php endwhile; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="4">
                                    <p><?php echo esc_html__("No ads found.", "adforest"); ?></p>
                                </td>
                            </tr>
                        <?php endif; ?>
                        <?php wp_reset_postdata(); ?>
                        </tbody>
                    </table>
                    <?php
                    $posts_per_page = get_option('posts_per_page');
                    if ($query->have_posts()) {
                        if ($query->found_posts > $posts_per_page) { ?>
                            <div class="d-flex justify-content-center align-items-center">
                                <button id="load-more-myads"
                                        class="btn dark-btn <?php echo (esc_attr($ad_type) == 'my_ads') ? 'adt-button-dark-1' : ''; ?>"
                                        data-ad-type="<?php echo esc_attr($ad_type); ?>">
                                    <?php echo esc_html__('Load More', 'adforest'); ?>
                                </button>
                            </div>
                        <?php }
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
}

add_action('wp_ajax_sb_verify_firebase_otp', 'sb_verify_firebase_otp_fun');
if (!function_exists('sb_verify_firebase_otp_fun')) {

    function sb_verify_firebase_otp_fun()
    {
        if (!isset($_POST['security']) || !wp_verify_nonce($_POST['security'], 'sb_login_otp_nonce')) {
//            wp_send_json_error(array("message" => esc_html__('Invalid security token', 'adforest')));
//            die();
        }

        $is_demo = adforest_is_demo();
        if ($is_demo) {
            wp_send_json_error(array("message" => esc_html__('Not allowed in demo mode', 'adforest')));
            die();
        }

        $user_id = get_current_user_id();
        $phone_number = isset($_POST['phone_number']) ? $_POST['phone_number'] : "";
        $saved_num = get_user_meta($user_id, '_sb_contact', true);
        if ($phone_number == "") {
            wp_send_json_error(array("message" => esc_html__('Phone Number not exist', 'adforest')));
        } else if ($phone_number != $saved_num) {
            wp_send_json_error(array("message" => esc_html__('Phone Number not match', 'adforest')));
        } else {
            update_user_meta($user_id, '_sb_is_ph_verified', "1");
            wp_send_json_success(array("message" => esc_html__('Verified succesfully', 'adforest')));
        }
    }
}

/* Delete USER */
add_action('wp_ajax_delete_site_user_func', 'adforest_delete_site_user_func');
if (!function_exists('adforest_delete_site_user_func')) {
    function adforest_delete_site_user_func()
    {
        $del_user_id = $_POST['del_user_id'];
        $current_user_id = get_current_user_id();
        require_once(ABSPATH . 'wp-admin/includes/user.php');
        $success = 0;
        $message = __("Something went wrong.", "adforest");
        $if_user_exists = adforest_user_id_exists($del_user_id);
        if ($current_user_id == $del_user_id && $if_user_exists) {
            if (current_user_can('administrator')) {

                $success = 0;
                $message = __("Admin can not delete his account from here.", "adforest");
            } else {
                adforestTheme_delete_userComments($current_user_id);
                $user_delete = wp_delete_user($current_user_id);
                if ($user_delete) {

                    $success = 1;
                    $message = __("Your account has been deleted successfully.", "adforest");
                    wp_logout();
                }
            }
        }
        echo adforest_return_echo($success . '|' . $message);
        die();
    }
}

if (!function_exists('adforestTheme_delete_userComments')) {
    function adforestTheme_delete_userComments($user_id)
    {
        $user = get_user_by('id', $user_id);

        $comments = get_comments('author_email=' . $user->user_email);
        foreach ($comments as $comment):
            wp_delete_comment($comment->$comment_id, true);
        endforeach;

        $comments = get_comments('user_id=' . $user_id);
        foreach ($comments as $comment):
            wp_delete_comment($comment->$comment_id, true);
        endforeach;
    }
}

if (!function_exists('adforest_user_id_exists')) {
    function adforest_user_id_exists($user)
    {
        global $wpdb;
        $count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $wpdb->users WHERE ID = %d", $user));

        if ($count == 1) {
            return true;
        } else {
            return false;
        }
    }
}