<?php echo adforest_dashboard_breadcrumb(esc_html__("Invoices", "adforest")); ?>

<?php
$args = array(
    'customer_id' => get_current_user_id(),
);
$history_html = "";
$orders = wc_get_orders($args);
if (count((array)$orders) > 0) {
    foreach ($orders as $order) {
        $items = $order->get_items();
        $product_name = '';
        foreach ($items as $item) {
            $product_name .= $item->get_name() . ',';
        }

        $history_html .= '<tr class="row-content">
                           <td></td>
			   <td>' . $order->get_id() . '</td>
			   <td>' . rtrim($product_name, ',') . '</td>
			   <td> <span class="label label-default"> ' . wc_get_order_status_name($order->get_status()) . ' </span></td>
			   <td>' . date_i18n(get_option('date_format'), strtotime($order->get_date_created())) . '</td>
			   <td>' . $order->get_total() . '</td>
			</tr>';
    }
} else {
    $history_html .= '<td colspan="5">' . esc_html__('There is no order history found.', 'adforest') . '</td>';
}
?>
<div class="main">
    <main class="content my_ads">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                    <div class="card-style mb-30">
                        <div class="table-responsive custom-tabel-label">
                            <table class="table top-selling-table">
                                <thead>
                                <tr>
                                    <th></th>
                                    <th><?php echo esc_html__('Order #', 'adforest') ?></th>
                                    <th><?php echo esc_html__('Packages', 'adforest') ?></th>
                                    <th><?php echo esc_html__('Status', 'adforest') ?></th>
                                    <th><?php echo esc_html__('Date', 'adforest') ?></th>
                                    <th><?php echo esc_html__('Order total', 'adforest') ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                echo wp_kses_post($history_html);
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>