<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<?php
if ( is_plugin_active( 'sb_framework/index.php' ) ) {
    deactivate_plugins( 'sb_framework/index.php', true );
}

if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
    deactivate_plugins( 'js_composer/js_composer.php', true );
}

if ( is_plugin_active( 'one-click-demo-import/one-click-demo-import.php' ) ) {
    deactivate_plugins( 'one-click-demo-import/one-click-demo-import.php', true );
}
?>
<div class="sb-welcome-panel">
<?php
if ( get_option( 'adforest_license_status' ) !== 'valid' ) {
    echo '<div class="notice notice-warning adforest-license-warning" style="width:100%; padding:15px; border-left:5px solid #e67e22; background:#fff8e1;">';
    echo '<p><strong>' . esc_html__('🔐 License Activation Required', 'adforest') . '</strong></p>';
    echo '<p>' . esc_html__('Please activate your license in the next step to continue using AdForest.', 'adforest') . '</p>';
    echo '<p>' . sprintf(
        esc_html__('Click %1$shere%2$s to begin the activation process.', 'adforest'),
        '<a class="licence-activation-start" href="javascript:void(0);" style="color:#e67e22; font-weight:bold;">',
        '</a>'
    ) . '</p>';
    echo '</div>';
    ?>
      <script>
        jQuery(document).ready(function($) {
            $('.licence-activation-start').on('click', function(e) {
                e.preventDefault();
                $('.sb-btn.sb-btn-primary.sb-btn-next').trigger('click');
            });
        });
      </script>
    <?php 
}
?>
<div class="adforest-update-warning">
  <h3><?php echo esc_html__('🚨 AdForest v6.0 – Major Update Warning', 'adforest'); ?></h3>

  <p><?php echo esc_html__('We’re excited to introduce AdForest v6.0 with major performance and builder enhancements. However, this update includes critical changes that require your attention.', 'adforest'); ?></p>

  <p><strong><?php echo esc_html__('Who should read this:', 'adforest'); ?></strong>
  <?php echo esc_html__('If your site is already live and using WPBakery, this update notice is for you.', 'adforest'); ?></p>

  <p><strong><?php echo esc_html__('Important:', 'adforest'); ?></strong>
  <?php echo esc_html__('WPBakery Page Builder is no longer supported in version 6.0. The theme now exclusively supports Elementor.', 'adforest'); ?></p>

  <p style="color:red; font-weight:bold;"><?php echo esc_html__('⚠️ WARNING: Never use Fresh Import on a live/existing website — it will erase all your data.', 'adforest'); ?></p>

  <ul>
    <li><?php echo esc_html__('✅ Always take a full backup of your website before updating.', 'adforest'); ?></li>
    <li><?php echo esc_html__('⚠️ If you are using WPBakery, do not update until you have migrated your pages to Elementor.', 'adforest'); ?></li>
    <li><?php echo esc_html__('🛠️ Test the update on a staging site first.', 'adforest'); ?></li>
    <li><?php echo esc_html__('💾 Use a plugin like UpdraftPlus or All-in-One WP Migration to back up your site.', 'adforest'); ?></li>
    <li><?php echo esc_html__('🔁 After updating, recheck all customizations, widgets, and page templates.', 'adforest'); ?></li>
  </ul>
  <p>
    <?php echo esc_html__('This update is a big leap forward, but it’s crucial to proceed with caution.', 'adforest'); ?>
    <?php echo sprintf(
      esc_html__('Need help? Visit our %1$sSupport Portal%2$s.', 'adforest'),
      '<a href="https://scriptsbundle.ticksy.com/" target="_blank" style="color:#d35400; font-weight:bold;">',
      '</a>'
    ); ?>
  </p>
</div>

<style>
.adforest-update-warning {
  background-color: #fff4e5;
  border-left: 5px solid #ff9900;
  padding: 20px;
  margin: 20px 0;
  font-family: Arial, sans-serif;
  border-radius: 6px;
  width: 100%;
}
.adforest-update-warning h3 {
  margin-top: 0;
  color: #d35400;
  font-size: 20px;
}
.adforest-update-warning p {
  margin: 10px 0;
  font-size: 15px;
}
.adforest-update-warning ul {
  margin: 10px 0 0 20px;
  padding-left: 0;
}
.adforest-update-warning ul li {
  margin-bottom: 5px;
  font-size: 15px;
}
</style>

  <aside class="sb-welcome-graphic">
    <img src="<?php echo esc_url( get_template_directory_uri() . '/screenshot.png' ); ?>"
         alt="<?php esc_attr_e( 'AdForest Preview', 'adforest' ); ?>" />
  </aside>
  
  <div class="sb-welcome-content">
    <h1 id="welcome-heading" class="sb-welcome-title">
      <?php _e( 'Welcome to AdForest Setup', 'adforest' ); ?>
    </h1>

    <p class="sb-welcome-version">
      <?php printf( __( 'Theme Version: %s', 'adforest' ), esc_html( wp_get_theme()->get( 'Version' ) ) ); ?>
    </p>

    <ul class="sb-welcome-list">
      <li><?php _e( 'Verify your license',       'adforest' ); ?></li>
      <li><?php _e( 'Check system requirements',  'adforest' ); ?></li>
      <li><?php _e( 'Install required plugins',   'adforest' ); ?></li>
      <li><?php _e( 'Import demo content',        'adforest' ); ?></li>
      <li><?php _e( 'Finish setup',               'adforest' ); ?></li>
    </ul>

    <div class="sb-welcome-actions">
      <button
        type="button"
        class="sb-btn sb-btn-primary sb-btn-next"
        data-step="welcome"
        data-next="license"
        aria-describedby="welcome-heading"
      >
        <?php _e( 'Let’s Get Started', 'adforest' ); ?>
      </button>
      <div class="sb-spinner" role="status" aria-hidden="true"></div>
    </div>
  </div>
</div>