<?php
/* Template Name: Notification */
/**
 * The template for displaying Notifications.
 *
 * @package Adforest
 */
get_header();
adforest_custom_breadcrumbs();
global $wpdb;
$sb_profile_page = isset($adforest_theme['sb_profile_page']) ? $adforest_theme['sb_profile_page'] : '';
$profile_page_link = get_permalink($sb_profile_page);

$current_user_id = get_current_user_id();

$notifications_query = $wpdb->get_results($wpdb->prepare("
       SELECT *
       FROM {$wpdb->prefix}sb_chat_messages
       WHERE receiver_id = %d
         AND read_status   = 0
       ORDER BY created DESC
       LIMIT 50
   ", $current_user_id));

$unread_notifications = $wpdb->get_var($wpdb->prepare("
    SELECT COUNT(*)
    FROM {$wpdb->prefix}sb_chat_messages
    WHERE receiver_id = %d AND read_status = 0
", $current_user_id));
?>

    <div class="main-content-area clearfix">
        <section class="section-padding notification-history">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="notification-header">
                            <div class="notification-left-content">
                                <h3 class="notification-heading">
                                    <?php echo __('Notifications', 'adforest'); ?>
                                    <i class="fa fa-bell text-muted"></i>
                                </h3>
                                <div class="notification-count">
                                    <?php
                                    printf(
                                        __('You have %s unread notifications', 'adforest'),
                                        '<span class="msgs_count">' . esc_html($unread_notifications) . '</span>'
                                    );
                                    ?>
                                </div>
                            </div>

                            <!-- Mark All as Read button -->
                            <?php if ($unread_notifications > 0) { ?>
                                <div class="notification-mark-btn-box">
                                    <button id="mark-all-read"
                                            class="adt-button-dark-1"
                                            data-nonce="<?php echo esc_attr(wp_create_nonce('adforest_mark_all_read')); ?>">
                                        <?php esc_html_e('Mark all as read', 'adforest'); ?>
                                    </button>
                                </div>
                            <?php } ?>
                        </div>


                        <div class="notification-list">
                            <?php if (!empty($notifications_query)) : ?>
                                <?php foreach ($notifications_query as $notification) :
                                    $sender = get_userdata($notification->sender_id);
                                    $sender_name = $sender ? esc_html($sender->display_name) : __('Unknown User', 'adforest');
                                    $sender_avatar = get_avatar_url($notification->sender_id);

                                    $notification_link = '#';
                                    $notification_message = '';
                                    $notification_context = '';

                                    switch ($notification->message_type) {
                                        case '0':
                                            $notification_link = esc_url($profile_page_link . "?page_type=msg&conversation_id=" . $notification->conversation_id);
                                            $notification_message = __('Sent you a message', 'adforest');
                                            $notification_context = wp_trim_words($notification->content, 10, '...');
                                            break;

                                        default:
                                            $notification_message = __('New Notification', 'adforest');
                                    }
                                    ?>
                                    <div class="notification-item <?php echo esc_attr__($notification->read_status) == 0 ? 'unread' : 'read'; ?>">
                                        <a href="<?php echo esc_url($notification_link); ?>" class="notification-link">
                                            <div class="notification-avatar">
                                                <img src="<?php echo esc_url($sender_avatar); ?>"
                                                     alt="<?php echo esc_attr($sender_name); ?>">
                                            </div>
                                            <div class="notification-content">
                                                <h6 class="notification-title">
                                                    <?php echo esc_html($sender_name); ?>
                                                    <?php echo esc_html($notification_message); ?>
                                                </h6>
                                                <?php if ($notification_context) : ?>
                                                    <p class="notification-context">
                                                        <?php echo esc_html($notification_context); ?>
                                                    </p>
                                                <?php endif; ?>
                                                <span class="notification-time">
                                            <?php
                                            echo esc_html(
                                                date_i18n(
                                                    'F j, Y \a\t g:i A',
                                                    strtotime($notification->created)
                                                )
                                            );
                                            ?>
                                        </span>
                                            </div>
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div class="no-notifications">
                                    <?php echo __('No notifications found.', 'adforest'); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

<?php get_footer(); ?>