<?php
global $adforest_theme;
$title = !empty($instance['title']) ? $instance['title'] : esc_html__('Categories', 'adforest');
$enable_show_more_cats = !empty($instance['show_more_cate']) ? $instance['show_more_cate'] : 0;
$no_of_cats_before_show_more = !empty($instance['no_of_cats']) ? $instance['no_of_cats'] : 0;

if (isset($adforest_theme['hide_cat_sidebar_map']) && $adforest_theme['hide_cat_sidebar_map'] == '1') {
    ?>
    <h3><?php echo esc_html($title); ?></h3>
    <div>
        <?php
        $adforest_search_page = apply_filters('adforest_language_page_id', $adforest_theme['sb_search_page']);
        $adforest_search_page = isset($adforest_search_page) && $adforest_search_page != '' ? get_the_permalink($adforest_search_page) : 'javascript:void(0)';
        $adforest_search_page = apply_filters('adforest_category_widget_form_action', $adforest_search_page, 'cat_page');
        ?>
        <form method="get" id="search_cats_w" action="<?php echo adforest_return_echo($adforest_search_page); ?>">
            <?php
            $ad_categories = adforest_get_ad_taxonomy_callback('ad_cats');
            if (is_array($ad_categories) && count($ad_categories) > 0) {
                if ($enable_show_more_cats && count($ad_categories) > $no_of_cats_before_show_more) {
                    $first_categories = array_slice($ad_categories, 0, $no_of_cats_before_show_more);
                    $rest_categories = array_slice($ad_categories, $no_of_cats_before_show_more);
                } else {
                    $first_categories = $ad_categories;
                    $rest_categories = [];
                }
                ?>
                <div class="adt-category-list-sidebar" style="padding: 0">
                    <?php
                    if (isset($_GET['cat_id']) && $_GET['cat_id'] != "") {
                        $selected_cats = adforest_get_taxonomy_parents($_GET['cat_id'], 'ad_cats', false);
                        $find = '&raquo;';
                        $replace = '';
                        $selected_cats = preg_replace("/$find/", $replace, $selected_cats, 1);
                        echo adforest_return_echo($selected_cats);
                    }
                    ?>
                    <ul>
                        <!-- Display first set of categories -->
                        <?php
                        if (is_array($first_categories) && count($first_categories) > 0) {
                            foreach ($first_categories as $category) {
                                $category_details = get_taxonomy_details($category);
                                $name = $category_details['name'];
                                $ad_count = $category_details['ad_count'];
                                $image = $category_details['image'];
                                $link = $category_details['link'];
                                $category_search_page = apply_filters('adforest_filter_taxonomy_popup_actions', 'javascript:void(0);', $category->term_id, 'ad_cats');
                                ?>
                                <li>
                                    <div class="adt-category-box">
                                        <div class="category-meta">
                                            <a href="<?php echo esc_url($category_search_page); ?>"
                                               class="img-box category_click_link"
                                               data-cat-id="<?php echo esc_attr($category->term_id); ?>">
                                                <img class="img-fluid" src="<?php echo esc_url($image); ?>"
                                                     alt="category">
                                            </a>
                                            <a href="<?php echo esc_url($category_search_page); ?>"
                                               class="category_click_link"
                                               data-cat-id="<?php echo esc_attr($category->term_id); ?>">
                                                <?php echo esc_html($name); ?>
                                            </a>
                                        </div>
                                        <span class="listing-count"><?php echo esc_html($ad_count . " ads"); ?></span>
                                    </div>
                                </li>
                            <?php }
                        } ?>

                        <!-- If there are extra categories, add Show More / Show Less links -->
                        <?php if (!empty($rest_categories)) { ?>
                            <?php foreach ($rest_categories as $category) {
                                $category_details = get_taxonomy_details($category);
                                $name = $category_details['name'];
                                $ad_count = $category_details['ad_count'];
                                $image = $category_details['image'];
                                $link = $category_details['link'];
                                $category_search_page = apply_filters('adforest_filter_taxonomy_popup_actions', 'javascript:void(0);', $category->term_id, 'ad_cats');
                                ?>
                                <li class="hidden-category" style="display: none;">
                                    <div class="adt-category-box">
                                        <div class="category-meta">
                                            <a href="<?php echo esc_url($category_search_page); ?>"
                                               class="img-box category_click_link"
                                               data-cat-id="<?php echo esc_attr($category->term_id); ?>">
                                                <img class="img-fluid" src="<?php echo esc_url($image); ?>"
                                                     alt="category">
                                            </a>
                                            <a href="<?php echo esc_url($category_search_page); ?>"
                                               class="category_click_link"
                                               data-cat-id="<?php echo esc_attr($category->term_id); ?>">
                                                <?php echo esc_html($name); ?>
                                            </a>
                                        </div>
                                        <span class="listing-count"><?php echo esc_html($ad_count . " ads"); ?></span>
                                    </div>
                                </li>
                            <?php } ?>
                            <!-- Wrapper for the toggle links -->
                            <li class="toggle-wrapper">
                                <a href="javascript:void(0);"
                                   id="showMoreCategories"><?php _e('Show More', 'adforest'); ?></a>
                                <a href="javascript:void(0);" id="showLessCategories"
                                   style="display: none;"><?php _e('Show Less', 'adforest'); ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            <?php } ?>
            <input type="hidden" name="cat_id" id="cat_id" value=""/>
            <?php echo adforest_search_params('cat_id'); ?>
            <?php apply_filters('adforest_form_lang_field', true); ?>
        </form>
    </div>
    <?php
}
?>