<?php
global $adforest_theme;
$title = !empty($instance['title']) ? $instance['title'] : __('Categories', 'adforest');
$ad_categories = adforest_get_ad_taxonomy_callback('ad_cats');

$selected_cat_id = "";
if (isset($_GET['cat_id'])) {
    $selected_cat_id = $_GET['cat_id'];
}
?>

    <div class="col-sm-6 col-md-4 col-lg-3">
        <?php
        $adforest_search_page = apply_filters('adforest_language_page_id', $adforest_theme['sb_search_page']);
        $adforest_search_page = isset($adforest_search_page) && $adforest_search_page != '' ? get_the_permalink($adforest_search_page) : 'javascript:void(0)';
        $adforest_search_page = apply_filters('adforest_category_widget_form_action', $adforest_search_page, 'cat_page');
        ?>
        <form method="get" id="search_cats_w" action="<?php echo adforest_return_echo($adforest_search_page); ?>">
            <div class="form-field">
                <label for="topbar_categories" class="form-label"><?php echo esc_html($title); ?></label>
                <select class="default-select" id="topbar_categories">
                    <option value=""><?php echo esc_html__('Select an Option', 'adforest'); ?></option>
                    <?php
                    if (is_array($ad_categories) && count($ad_categories) > 0) {
                        foreach ($ad_categories as $category) {
                            $category_details = get_taxonomy_details($category);
                            $name = $category_details['name'];
                            $category_id = $category->term_id;
                            $selected = ($category_id == $selected_cat_id) ? 'selected' : '';
                            ?>
                            <option value="<?php echo esc_attr($category_id); ?>"
                                    data-cat-id="<?php echo esc_attr($category_id); ?>"
                                    selected="<?php echo esc_attr($selected); ?>">
                                <?php echo esc_html($name); ?>
                            </option>
                        <?php }
                    } ?>
                </select>
            </div>
            <input type="hidden" name="cat_id" id="cat_id" value=""/>
            <?php echo adforest_search_params('cat_id'); ?>
            <?php apply_filters('adforest_form_lang_field', true); ?>
        </form>
        <?php adforest_widget_counter(); ?>
    </div>
<?php adforest_advance_search_container(); ?>