<?php
namespace ElementorAdforest\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class HorizontalAd extends Widget_Base
{
    public function get_name()
    {
        return 'adforest_horizontal_ad';
    }

    public function get_title()
    {
        return __("Horizontal AD", 'adforest-elementor');
    }

    public function get_icon()
    {
        return 'fa fa-audio-description';
    }

    public function get_categories()
    {
        return ['adforest_widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'basic', [
                'label' => esc_html__('Basic', 'adforest-elementor'),
            ]
        );

        $this->add_control(
            'ad_cats_ad',
            [
                'label' => __('Horizontal Advertisement image', 'adforest-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                "description" => __("1320×140", 'adforest-elementor'),
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $atts = $this->get_settings_for_display();
        $params = array();
        $params['ad_cats_ad'] = $atts['ad_cats_ad'] ?? "";
        $params['adforest_elementor'] = true;

        if (function_exists('adforest_horizontal_ad')) {
            echo adforest_horizontal_ad($params);
        }
    }
}