<?php
$data = c27()->merge_options([
	'icon' => '',
	'icon_style' => 1,
	'gallery_items' => [],
	'gallery_item_interface' => 'WP_IMAGE_OBJECT',
	'items_per_row' => 3,
	'items_per_row_mobile' => 2,
	'gallery_type' => 'carousel',
	'wrapper_class' => 'block-element',
	'wrapper_id' => '',
	'ref' => '',
    'is_edit_mode' => false,
], $data);

$gallery_items = [];

if ($data['gallery_item_interface'] == 'WP_IMAGE_OBJECT') {
	foreach ($data['gallery_items'] as $item) {
		$image_quality = ($data['gallery_type'] == 'carousel-with-preview') ? 'full' : 'medium';

		$image = wp_get_attachment_image_src($item['item']['id'], $image_quality);
		$large_image = wp_get_attachment_image_src($item['item']['id'], 'full');

		$image_id = $item['item']['id'];

		$gallery_items[] = [
			'image' => [
				'url' => $image ? $image[0] : false,
			],
			'large_image' => [
				'url' => $large_image ? $large_image[0] : false,
			],
            'alt' => get_post_meta($image_id, '_wp_attachment_image_alt', true),
			'title' => get_the_title($image_id),
			'caption' => wp_get_attachment_caption($image_id),
			'description' => get_post($image_id)->post_content
		];
	}
}

wp_enqueue_script( 'mylisting-owl' );
wp_enqueue_script( 'mylisting-photoswipe' );
wp_enqueue_script( 'mylisting-gallery-carousel-preview' );
wp_print_styles('mylisting-photoswipe');
wp_print_styles('mylisting-gallery-carousel-preview');


if ( count( $gallery_items ) === 2 ) {
	$data['items_per_row'] = 2;
}
?>

<div class="<?php echo esc_attr( $data['wrapper_class'] ) ?>" <?php echo $data['wrapper_id'] ? sprintf( 'id="%s"', $data['wrapper_id'] ) : '' ?>>
	<?php if (!$data['gallery_type'] || $data['gallery_type'] == 'carousel'): ?>
		<?php
		if ( count( $gallery_items ) === 1 ) {
			$data['items_per_row'] = 1;
			$data['items_per_row_mobile'] = 1;
			$gallery_items[0]['image']['url'] = $gallery_items[0]['large_image']['url'];
		}
		?>

		<div class="element gallery-carousel-block <?php echo 'carousel-items-' . count( $gallery_items ) ?>">
			<div class="pf-head">
				<div class="title-style-1 title-style-<?php echo esc_attr( $data['icon_style'] ) ?>">
					<?php if ($data['icon_style'] != 3): ?>
						<?php echo c27()->get_icon_markup($data['icon']) ?>
					<?php endif ?>
					<h5><?php echo esc_html( $data['title'] ) ?></h5>
				</div>

				<?php if ( count( $gallery_items ) > 2 ): ?>
					<div class="gallery-nav">
						<ul class="no-list-style">
							<li>
								<a aria-label="<?php echo esc_attr( _ex( 'Gallery navigation previous', 'Gallery block arrows - SR', 'my-listing' ) ) ?>" href="#" class="gallery-prev-btn">
									<i class="material-icons keyboard_arrow_left"></i>
								</a>
							</li>
							<li>
								<a aria-label="<?php echo esc_attr( _ex( 'Gallery navigation next', 'Gallery block arrows - SR', 'my-listing' ) ) ?>" href="#" class="gallery-next-btn">
									<i class="material-icons keyboard_arrow_right"></i>
								</a>
							</li>
						</ul>
					</div>
				<?php endif ?>

			</div>

			<div class="pf-body">
				<div class="gallery-carousel owl-carousel photoswipe-gallery" data-items="<?php echo esc_attr( $data['items_per_row'] ) ?>" data-items-mobile="<?php echo esc_attr( $data['items_per_row_mobile'] ) ?>">

					<?php foreach ((array) $gallery_items as $item): ?>
						<?php if ($item['image']['url']): ?>
							<a class="item photoswipe-item"
								aria-label="<?php echo esc_attr( _ex( 'Gallery image', 'Gallery block images - SR', 'my-listing' ) ) ?>"
							   href="<?php echo esc_url( $item['large_image'] ? $item['large_image']['url'] : $item['image']['url'] ) ?>"
							   style="background-image: url('<?php echo esc_url( $item['image']['url'] ) ?>')"
							   alt="<?php echo esc_attr( $item['alt'] ?? '' ) ?>" 
							   title="<?php echo esc_attr( $item['title'] ?? '' ) ?>" 
							   caption="<?php echo esc_attr( $item['caption'] ?? '' ) ?>" 
							   description="<?php echo esc_attr( $item['description'] ?? '' ) ?>"
							   >
							</a>
						<?php endif ?>
					<?php endforeach ?>

				</div>
			</div>
		</div>
	<?php endif ?>

	<?php if ($data['gallery_type'] == 'carousel-with-preview'): ?>
		<div class="element slider-padding gallery-block">
			<div class="pf-body">
				<div class="gallerySlider car-slider">
					<div class="owl-carousel galleryPreview photoswipe-gallery">
						<?php foreach ((array) $gallery_items as $item): ?>
							<?php if ($item['image']['url']): ?>
								<a aria-label="<?php echo esc_attr( _ex( 'Gallery image thumbnail', 'Gallery block images - SR', 'my-listing' ) ) ?>" class="item photoswipe-item" href="<?php echo esc_url( $item['large_image'] ? $item['large_image']['url'] : $item['image']['url'] ) ?>">
								   <img src="<?php echo esc_url( $item['image']['url'] ) ?>" alt="<?php echo esc_attr( $item['alt'] ?? '' ) ?>" title="<?php echo esc_attr( $item['title'] ?? '' ) ?>" caption="<?php echo esc_attr( $item['caption'] ?? '' ) ?>" description="<?php echo esc_attr( $item['description'] ?? '' ) ?>">
								</a>
							<?php endif ?>
						<?php endforeach ?>
					</div>
					<div class="gallery-thumb owl-carousel" data-items="<?php echo esc_attr( $data['items_per_row'] ) ?>" data-items-mobile="<?php echo esc_attr( $data['items_per_row_mobile'] ) 	?>">
						<?php $i = 0; ?>
						<?php foreach ((array) $gallery_items as $item): ?>
							<?php if ($item['image']['url']): ?>
								<a class="item slide-thumb"
									aria-label="<?php echo esc_attr( _ex( 'Gallery image', 'Gallery block images - SR', 'my-listing' ) ) ?>"
								   data-slide-no="<?php echo esc_attr( $i ) ?>"
								   href="<?php echo esc_url( $item['image']['url'] ) ?>"
								   style="background-image: url('<?php echo esc_url( $item['image']['url'] ) ?>')">
								</a>
							<?php $i++; endif; ?>
						<?php endforeach ?>
					</div>
					<div class="gallery-nav">
						<ul class="no-list-style">
							<li>
								<a aria-label="<?php echo esc_attr( _ex( 'Gallery navigation previous', 'Gallery block arrows - SR', 'my-listing' ) ) ?>" href="#" class="gallery-prev-btn">
									<i class="material-icons keyboard_arrow_left"></i>
								</a>
							</li>
							<li>
								<a aria-label="<?php echo esc_attr( _ex( 'Gallery navigation next', 'Gallery block arrows - SR', 'my-listing' ) ) ?>" href="#" class="gallery-next-btn">
									<i class="material-icons keyboard_arrow_right"></i>
								</a>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	<?php endif ?>

	<?php if ( $data['gallery_type'] === 'grid' ): ?>
		<div class="element gallery-grid-block <?php echo 'carousel-items-' . count( $gallery_items ) ?>">
			<div class="pf-head">
				<div class="title-style-1 title-style-<?php echo esc_attr( $data['icon_style'] ) ?>">
					<?php if ($data['icon_style'] != 3): ?>
						<?php echo c27()->get_icon_markup($data['icon']) ?>
					<?php endif ?>
					<h5><?php echo esc_html( $data['title'] ) ?></h5>
				</div>
			</div>

			<div class="pf-body">
				<div class="gallery-grid photoswipe-gallery">
					<?php foreach ((array) $gallery_items as $item): ?>
						<?php if ( $item['image']['url'] ): ?>
							<a class="gallery-item photoswipe-item" href="<?php echo esc_url( $item['large_image'] ? $item['large_image']['url'] : $item['image']['url'] ) ?>">
								<img src="<?php echo esc_url( $item['image']['url'] ) ?>" 
								alt="<?php echo esc_attr( $item['alt'] ?? '' ) ?>" 
							   	title="<?php echo esc_attr( $item['title'] ?? '' ) ?>" 
							   	caption="<?php echo esc_attr( $item['caption'] ?? '' ) ?>" 
							   	description="<?php echo esc_attr( $item['description'] ?? '' ) ?>"
								>
							</a>
						<?php endif ?>
					<?php endforeach ?>
				</div>
			</div>
		</div>
	<?php endif ?>
</div>

<?php if ($data['is_edit_mode']): ?>
    <script type="text/javascript">case27_ready_script(jQuery);</script>
<?php endif ?>