(function($) {
	"use strict";
	
	var $container = $('.active-search-form-support'),
		$html_select = '<select name="support_active_search" id="support_search" style="display: none;"><option value="search_theme">Documentation</option><option value="search_bb_forum">Support forum</option></select>';

	$container.find('.wpb_wrapper').append($html_select);

	var $select = $('#support_search'),
		$postsSearch = $('.widget_search', $container),
		$forumSearch = $('.widget_display_search', $container),
		formToggler = function() {

			if($select.val() == 'search_bb_forum') {
				$postsSearch.hide();
				$forumSearch.show();
			} else {
				$postsSearch.show();
				$forumSearch.hide();
			}
		},
		initTicketForm = function() {
			var unchecked = 0;
			$('.dfd-ticket-checkbox').each(function() {
				var $checkbox = $(this);

				if($checkbox.is(':checked')) {
					$checkbox.parent().removeClass('highlighted');
				} else {
					$checkbox.parent().addClass('highlighted');
					unchecked++;
				}
			});

			if(unchecked == 0) {
				$('#dfd-ticket-form-wrapper').removeClass('disabled').find('.submit-ticket input[type="submit"]').removeAttr('disabled');
			} else {
				$('#dfd-ticket-form-wrapper').addClass('disabled').find('.submit-ticket input[type="submit"]').attr('disabled',true);
			}
		};

	$(document).ready(function() {
		$('#support_search').dropkick({mobile: true});
		formToggler();
		
		initTicketForm();
		$('.dfd-ticket-checkbox').change(function() {
			initTicketForm();
		});
		
		if($('#dfd-clients-details-field').length > 0 && $('#dfd-clients-details-field').find('textarea').length > 0 && $('#dfd-clients-info-content').length > 0) {
			$('#dfd-clients-details-field').find('textarea').val($('#dfd-clients-info-content').text());
		}
	});
	
	$('body').on('change', $select, function() {
		formToggler();
	});
	
})(jQuery);