<?php

class td_woo_post_types {

    /**
     * Instance.
     *
     * @var null
     */
    public static $instance = null;

    /**
     * Instance.
     *
     * @return td_woo_post_types|null
     */
    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Constructor.
     */
    public function __construct() {
        add_action( 'init', array( $this, 'td_woo_linked_variations' ), 1 );
    }

    /**
     * Load td_woo_linked_variations
     */
    public function td_woo_linked_variations() {

        //echo var_export(td_util::get_option('td_woo_linked_variations', 'yes' ));
        //die('ttttt');
        if ( td_util::get_option('td_woo_linked_variations', 'yes' ) !== 'yes' ) {
            return;
        }

        register_post_type(
            'td_woo_lv',
            array(
                'label'              => 'Linked Variations',
                'labels'             => array(
                    'name'          => 'Linked Variations',
                    'singular_name' => 'Linked Variations',
                    'menu_name'     => 'Linked Variations',
                    'add_new'       => 'Add New',
                    'add_new_item'  => 'Add New',
                ),
                'supports'           => array( 'title' ),
                'hierarchical'       => false,
                'public'             => true,
                'show_in_menu'       => 'edit.php?post_type=product',
                'publicly_queryable' => false,
                'show_in_rest'       => true,
                'capability_type'    => 'product',
            )
        );

        /**
         * exclude td_woo_lv cpt from theme's cpt support
         */
        add_filter( 'td_custom_post_types', function ($td_cpts) {
            $td_woo_lv_post_type = array_search( 'td_woo_lv', $td_cpts );
            if( $td_woo_lv_post_type !== false ) {
                unset( $td_cpts[$td_woo_lv_post_type] );
            }
            return $td_cpts;
        }, 10, 1 );

        /**
         * add td_woo_lv_settings metabox on td_woo_lv post type
         */
        add_action( 'tdc_register_post_metaboxes', function() {

            new WPAlchemy_MetaBox([
                'id'       => 'td_woo_lv_settings',
                'title'    => 'Settings',
                'types'    => array( 'td_woo_lv' ), // this will appear just on td_woo_lv post type
                'priority' => 'high',
                'template' => TD_WOO_DIR . '/includes/metaboxes/td_woo_lv_settings.php',
            ]);

        });

        add_action( 'wp_ajax_td_get_post_by_query_autocomplete', [ $this, 'td_get_post_by_query_autocomplete' ] );
        add_action( 'wp_ajax_nopriv_td_get_post_by_query_autocomplete', [ $this, 'td_get_post_by_query_autocomplete' ] );

        add_action( 'woocommerce_after_edit_attribute_fields', [ $this, 'td_w_render_product_attrs_admin_options' ] );
        add_action( 'woocommerce_after_add_attribute_fields', [ $this, 'td_w_render_product_attrs_admin_options' ] );
        add_action( 'woocommerce_attribute_updated', [ $this, 'td_w_wc_attribute_update' ], 20, 3 );
        add_action( 'woocommerce_attribute_added', [ $this, 'td_w_wc_attribute_add' ], 20, 2 );

        // add tax meta
        add_filter( 'admin_init', function () {

            $attribute_taxonomies = wc_get_attribute_taxonomies();
            if ( $attribute_taxonomies ) {
                foreach ( $attribute_taxonomies as $tax ) {
                    $taxonomy = wc_attribute_taxonomy_name( $tax->attribute_name );

                    $fields = [
                        array(
                            'label' => 'Linked Variations Color',
                            'desc'  => 'Choose a color for linked variations.',
                            'id'    => 'lv_color',
                            'type'  => 'color'
                        ),
                        array(
                            'label' => 'Linked Variations Image',
                            'desc'  => 'Choose an image for linked variations.',
                            'id'    => 'lv_image',
                            'type'  => 'image'
                        )
                    ];

                    td_woo_util::add_term_meta( $taxonomy, 'product', $fields, false );

                }
            }

        });

    }

    /**
     * Autocomplete by post ajax callback
     */
    public function td_get_post_by_query_autocomplete() {

        $output = [];

        $args = [
            'post_type'   => $_POST['value'],
            's'           => isset( $_POST['params']['term'] ) ? $_POST['params']['term'] : '',
            'post_status' => 'publish',
            'numberposts' => 20,
            'exclude'     => isset( $_POST['selected'] ) ? $_POST['selected'] : array(),
        ];

        $posts = get_posts($args);

        if ( count($posts) > 0 ) {
            foreach ( $posts as $value ) {
                $output[] = array(
                    'id'   => $value->ID,
                    'text' => $value->post_title . ' ID:(' . $value->ID . ')',
                );
            }
        }

        echo wp_json_encode( $output );

        die();

    }

    /**
     * Add product attribute labels options
     */
    public function td_w_render_product_attrs_admin_options() {

        $lv_shape_list = [
            'round'   => 'Round',
            'rounded' => 'Rounded',
            'square'  => 'Square',
        ];
        $lv_size_list = [
            'xs'      => 'XS',
            'default' => 'S',
            'm'       => 'M',
            'large'   => 'L',
            'xlarge'  => 'XL',
            'xxl'     => 'XXL',
        ];
        $lv_style_list = [
            '1' => 'Style 1',
            '2' => 'Style 2',
            '3' => 'Style 3',
            '4' => 'Style 4',
        ];
        $lv_dis_style_list = [
            '1' => 'Style 1',
            '2' => 'Style 2',
            '3' => 'Style 3',
        ];

        if ( !empty($_GET['edit']) ) {
            $attribute_id   = sanitize_text_field( wp_unslash( $_GET['edit'] ) );
            $taxonomy_ids   = wc_get_attribute_taxonomy_ids();
            $attribute_name = 'pa_' . array_search( $attribute_id, $taxonomy_ids );

            $lv_shape     = get_option( 'td_w_' . $attribute_name . '_lv_shape' );
            $lv_size      = get_option( 'td_w_' . $attribute_name . '_lv_size' );
            $lv_style     = get_option( 'td_w_' . $attribute_name . '_lv_style' );
            $lv_dis_style = get_option( 'td_w_' . $attribute_name . '_lv_dis_style' );
        }

        $lv_shape     = !empty($lv_shape) ? $lv_shape : 'round';
        $lv_size      = !empty($lv_size) ? $lv_size : 'default';
        $lv_style     = !empty($lv_style) ? $lv_style : '1';
        $lv_dis_style = !empty($lv_dis_style) ? $lv_dis_style : '1';

        ?>
        <div class="tdw-box">
            <div class="tdw-sections">
                <div class="tdw-fields">
                    <div class="tdw-group-title">
                        <span>Linked Variations Options</span>
                    </div>
                    <div class="tdw-fields-group">
                        <div class="tdw-field tdw-buttons-control tdw-images-set">
                            <div class="tdw-option-title">
                                <label>
                                    <span>Style</span>
                                </label>
                            </div>
                            <div class="tdw-option-control">
                                <div class="tdw-btns-set">
                                    <?php foreach ( $lv_style_list as $value => $label ) : ?>
                                        <div class="tdw-set tdw-set-btn-img<?php echo (string) $value === $lv_style ? ' tdw-active' : ''; ?>" data-value="<?php echo esc_attr( $value ); ?>">
                                            <img src="<?php echo esc_url( TD_WOO_IMAGES_URL . '/lv/style-' . $value . '.jpg' ); ?>" title="<?php echo esc_attr( $label ); ?>" alt="<?php echo esc_attr( $label ); ?>">
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <input type="hidden" name="attribute_lv_style" value="<?php echo esc_attr( $lv_style ); ?>">
                            </div>
                        </div>
                        <div class="tdw-field tdw-buttons-control tdw-images-set">
                            <div class="tdw-option-title">
                                <label>
                                    <span>Disabled style</span>
                                </label>
                            </div>
                            <div class="tdw-option-control">
                                <div class="tdw-btns-set">
                                    <?php foreach ( $lv_dis_style_list as $value => $label ) : ?>
                                        <div class="tdw-set tdw-set-btn-img<?php echo (string) $value === $lv_dis_style ? ' tdw-active' : ''; ?>" data-value="<?php echo esc_attr( $value ); ?>">
                                            <img src="<?php echo esc_url( TD_WOO_IMAGES_URL . '/lv/disable-style-' . $value . '.jpg' ); ?>" title="<?php echo esc_attr( $label ); ?>" alt="<?php echo esc_attr( $label ); ?>">
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <input type="hidden" name="attribute_lv_dis_style" value="<?php echo esc_attr( $lv_dis_style ); ?>">
                            </div>
                        </div>
                        <div class="tdw-field tdw-buttons-control tdw-images-set">
                            <div class="tdw-option-title">
                                <label>
                                    <span>Shape</span>
                                </label>
                            </div>
                            <div class="tdw-option-control">
                                <div class="tdw-btns-set">
                                    <?php foreach ( $lv_shape_list as $value => $label ) : ?>
                                        <div class="tdw-set tdw-set-btn-img<?php echo $value === $lv_shape ? ' tdw-active' : ''; ?>" data-value="<?php echo esc_attr( $value ); ?>">
                                            <img src="<?php echo esc_url( TD_WOO_IMAGES_URL . '/lv/form-' . $value . '.jpg' ); ?>" title="<?php echo esc_attr( $label ); ?>" alt="<?php echo esc_attr( $label ); ?>">

                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <input type="hidden" name="attribute_lv_shape" value="<?php echo esc_attr( $lv_shape ); ?>">
                            </div>
                        </div>
                        <div class="tdw-field tdw-buttons-control">
                            <div class="tdw-option-title">
                                <label>
                                    <span>Size</span>
                                </label>
                            </div>
                            <div class="tdw-option-control">
                                <div class="tdw-btns-set">
                                    <?php foreach ( $lv_size_list as $value => $label ) : ?>
                                        <div class="tdw-set tdw-set-btn<?php echo $value === $lv_size ? ' tdw-active' : ''; ?>" data-value="<?php echo esc_attr( $value ); ?>">
                                            <span class="tdw-images-set-label"><?php echo esc_html( $label ); ?></span>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <input type="hidden" name="attribute_lv_size" value="<?php echo esc_attr( $lv_size ); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * This function save woocommerce attribute data after push 'update' button.
     *
     * @param mixed $attribute_id .
     * @param mixed $attribute .
     * @param mixed $old_attribute_name .
     */
    function td_w_wc_attribute_update( $attribute_id, $attribute, $old_attribute_name ) {

        $attribute_lv_size = $_POST['attribute_lv_size'] ?? '';
        update_option( 'td_w_pa_' . $attribute['attribute_name'] . '_lv_size', sanitize_text_field( $attribute_lv_size ) );

        $attribute_lv_bg_style = $_POST['attribute_lv_style'] ?? '';
        update_option( 'td_w_pa_' . $attribute['attribute_name'] . '_lv_style', sanitize_text_field( $attribute_lv_bg_style ) );

        $attribute_lv_dis_style = $_POST['attribute_lv_dis_style'] ?? '';
        update_option( 'td_w_pa_' . $attribute['attribute_name'] . '_lv_dis_style', sanitize_text_field( $attribute_lv_dis_style ) );

        $attribute_lv_shape = $_POST['attribute_lv_shape'] ?? '';
        update_option( 'td_w_pa_' . $attribute['attribute_name'] . '_lv_shape', sanitize_text_field( $attribute_lv_shape ) );

        //$attribute_show_on_product = $_POST['attribute_show_on_product'] ?? '';
        //update_option( 'td_w_pa_' . $attribute['attribute_name'] . '_show_on_product', sanitize_text_field( $attribute_show_on_product ) );
        //
        //$attribute_thumbnail = $_POST['product_attr_thumbnail_id'] ?? '';
        //update_option( 'td_w_pa_' . $attribute['attribute_name'] . '_thumbnail', sanitize_text_field( $attribute_thumbnail ) );
        //
        //$attribute_hint = $_POST['attribute_hint'] ?? '';
        //update_option( 'td_w_pa_' . $attribute['attribute_name'] . '_hint', sanitize_text_field( $attribute_hint ) );
        //
        //$attribute_change_image = $_POST['attribute_change_image'] ?? '';
        //update_option( 'td_w_pa_' . $attribute['attribute_name'] . '_change_image', sanitize_text_field( $attribute_change_image ) );
    }

    /**
     * This function save woocommerce attribute data after push 'Add attribute' button.
     *
     * @param mixed $attribute_id .
     * @param mixed $attribute .
     */
    function td_w_wc_attribute_add( $attribute_id, $attribute ) {

        $attribute_lv_size = $_POST['attribute_lv_size'] ?? '';
        add_option( 'td_w_pa_' . $attribute['attribute_name'] . '_lv_size', sanitize_text_field( $attribute_lv_size ) );

        $attribute_lv_bg_style = $_POST['attribute_lv_style'] ?? '';
        add_option( 'td_w_pa_' . $attribute['attribute_name'] . '_lv_style', sanitize_text_field( $attribute_lv_bg_style ) );

        $attribute_lv_dis_style = $_POST['attribute_lv_dis_style'] ?? '';
        add_option( 'td_w_pa_' . $attribute['attribute_name'] . '_lv_dis_style', sanitize_text_field( $attribute_lv_dis_style ) );

        $attribute_lv_shape = $_POST['attribute_lv_shape'] ?? '';
        add_option( 'td_w_pa_' . $attribute['attribute_name'] . '_lv_shape', sanitize_text_field( $attribute_lv_shape ) );

        //$attribute_show_on_product = $_POST['attribute_show_on_product'] ?? '';
        //add_option( 'td_w_pa_' . $attribute['attribute_name'] . '_show_on_product', sanitize_text_field( $attribute_show_on_product ) );
        //
        //$attribute_thumbnail = $_POST['product_attr_thumbnail_id'] ?? '';
        //add_option( 'td_w_pa_' . $attribute['attribute_name'] . '_thumbnail', sanitize_text_field( $attribute_thumbnail ) );
        //
        //$attribute_hint = $_POST['attribute_hint'] ?? '';
        //add_option( 'td_w_pa_' . $attribute['attribute_name'] . '_hint', sanitize_text_field( $attribute_hint ) );
        //
        //$attribute_change_image = $_POST['attribute_change_image'] ?? '';
        //add_option( 'td_w_pa_' . $attribute['attribute_name'] . '_change_image', sanitize_text_field( $attribute_change_image ) );

    }

}

td_woo_post_types::get_instance();