<?php

/**
 * Class td_woo_product_linked_variations - shortcode for linked products variations
 */
class td_woo_product_linked_variations extends td_block {

    private $unique_block_class;

    private $linked_data = [];

    public function get_custom_css() {

        $compiled_css = '';

        $raw_css =
            "<style>

                /* @general_style_td_woo_product_linked_variations */
                .td_woo_product_linked_variations .tdw-block-inner {}
                
            </style>";

        $td_css_res_compiler = new td_css_res_compiler( $raw_css );
        $td_css_res_compiler->load_settings( __CLASS__ . '::cssMedia', $this->get_all_atts() );

        $compiled_css .= $td_css_res_compiler->compile_css();

        return $compiled_css;

    }

    static function cssMedia( $res_ctx ) {

        /*-- GENERAL-- */
        $res_ctx->load_settings_raw( 'general_style_td_woo_product_linked_variations', 1 );

    }

    function __construct() {
        parent::disable_loop_block_features();
    }

    function render( $atts, $content = null ) {

        parent::render($atts);

        $this->unique_block_class = $this->block_uid;

        $td_woo_linked_variations = td_util::get_option( 'td_woo_linked_variations', 'yes' );

        $output = $this->output();

        $additional_classes = [];
        if ( empty($output) ) {
            $additional_classes[] = 'tdw-lv-no-content';
        }

        $buffy = '<div class="' . $this->get_block_classes($additional_classes) . '" ' . $this->get_block_html_atts() . '>';

	        // get the block css
	        $buffy .= $this->get_block_css();

	        // get the js for this block
	        $buffy .= $this->get_block_js();

            if ( $td_woo_linked_variations !== 'yes' ) {

                if ( td_util::tdc_is_live_editor_iframe() || td_util::tdc_is_live_editor_ajax() ) {

                    $buffy .= td_util::get_block_error('Woo Product Variations', 'Linked Variations feature is disabled. <a href="' . admin_url('admin.php?page=td_theme_panel#td-woo-plugin/box=woocommerce_settings') . '" target="_blank" title="Go to Theme\'s Panel > SHOP > WooCommerce settings section to enable linked variations.">Enable Linked Variations</a>' );

                }

                $buffy .= '</div>';
                return $buffy;

            }

            $buffy .= '<div class="tdw-block-inner td-fix-index">';
                $buffy .= $output;
            $buffy .= '</div>';

        $buffy .= '</div>';

        return $buffy;
    }

    /**
     * the shortcode output
     *
     * @return string
     */
    public function output() {

        global $td_woo_state_single_product_page;
        $product = $td_woo_state_single_product_page->get_product();

        if ( empty($product) ) {
            return '';
        }

        $this->set_linked_data( $product->get_id() );

        if ( td_util::tdc_is_live_editor_iframe() || td_util::tdc_is_live_editor_ajax() ) {
            return $this->get_block_dummy_data();
        }

        if ( empty( $this->linked_data ) ||
            !$this->linked_data['attrs'] ||
            1 === count( $this->linked_data['attrs'] ) &&
            empty( reset( $this->linked_data['attrs'] ) )
        ) {
            return '';
        }

        $current_attributes = $this->get_product_attributes( $product->get_id() );
        $linked_variations_data = $this->get_linked_variations( $product->get_id() );

        //echo '<pre>$linked_variations_data: ' . print_r( $linked_variations_data, true ) . '</pre>';
        //echo '<pre>linked_data: ' . print_r( $this->linked_data, true ) . '</pre>';

        ob_start();
        ?>
        <div class="variations_form-linked">
            <table class="variations">
                <tbody>
                <?php foreach ( $linked_variations_data as $attr_slug => $attr_data ) { ?>
                    <?php

                    //$is_primary = $this->linked_data['primary'] == $attr_slug;

                    $lv_shape     = get_option( 'td_w_' . $attr_slug . '_lv_shape' );
                    $lv_size      = get_option( 'td_w_' . $attr_slug . '_lv_size' );
                    $lv_style     = get_option( 'td_w_' . $attr_slug . '_lv_style' );
                    $lv_dis_style = get_option( 'td_w_' . $attr_slug . '_lv_dis_style' );

                    $add_classes = '';

                    if ( !$lv_style ) {
                        $lv_style = '1';
                    }
                    if ( !$lv_dis_style ) {
                        $lv_dis_style = '1';
                    }
                    if ( !$lv_size ) {
                        $lv_size = 'default';
                    }
                    if ( !$lv_shape ) {
                        $lv_shape = 'round';
                    }

                    $add_classes .= ' tdw-lv-bg-style-' . $lv_style;
                    $add_classes .= ' tdw-lv-text-style-' . $lv_style;
                    $add_classes .= ' tdw-lv-dis-style-' . $lv_dis_style;
                    $add_classes .= ' tdw-lv-size-' . $lv_size;
                    $add_classes .= ' tdw-lv-shape-' . $lv_shape;

                    $terms = [];
                    foreach ( $this->linked_data[$attr_slug . '_terms'] as $term ) {

                        if ( !empty($attr_data['terms'][$term->slug]) ) {
                            $terms[$term->slug] = $attr_data['terms'][$term->slug];
                        } else {
                            $linked_variation_data = $this->get_linked_variation_data_for_term( $product->get_id(), $attr_slug, $term->slug );

                            if ( $linked_variation_data ) {
                                $terms[$term->slug] = [
                                    'id'             => $linked_variation_data['id'],
                                    'permalink'      => '#',
                                    'image'          => '',
                                    'title'          => '',
                                    'stock_status'   => '',
                                    'is_purchasable' => false,
                                    'attributes'     => $linked_variation_data['attributes'],
                                ];
                            }

                        }

                    }

                    ?>
                    <tr>
                        <th class="label cell">
                            <label>
                                <?php echo esc_html( $current_attributes['taxonomy'][ $attr_slug ] ); ?>
                            </label>
                        </th>
                        <td class="value cell with-swatches">
                            <div class="tdw-swatches tdw-swatches-product <?php echo esc_attr($add_classes); ?>">
                                <?php

                                foreach ( $terms as $term_slug => $term_data ) {

                                    $term_meta = $term_data['attributes']['meta'][$attr_slug];
                                    $classes   = 'tdw-swatch tdw-enabled';
                                    $styles    = '';
                                    $image     = '';

                                    if ( $this->linked_data['use_image'] && in_array( $attr_slug, $this->linked_data['use_image'], true ) ) {
                                        $image   = wp_get_attachment_image( get_post_thumbnail_id( $term_data['id'] ), 'woocommerce_thumbnail' );
                                        $classes = $this->add_css_class( 'tdw-bg', $classes );
                                    } elseif ( !empty( $term_meta['color'] ) ) {
                                        $styles  = 'background-color:' . $term_meta['color'];
                                        $classes = $this->add_css_class( 'tdw-bg', $classes );
                                    } elseif ( ( !empty( $term_meta['image'] ) && !is_array( $term_meta['image'] ) ) || ( is_array( $term_meta['image'] ) && !empty( $term_meta['image']['id'] ) ) ) {
                                        $classes = $this->add_css_class( 'tdw-bg', $classes );

                                        if ( is_array( $term_meta['image'] ) ) {
                                            $image_id = $term_meta['image']['id'];
                                        } else {
                                            //$image_id = '<img src="' . $term_meta['image'] . '" alt="Swatch image">';
                                            $image_id = $term_meta['image'];
                                        }

                                        $image = wp_get_attachment_image( $image_id, 'full' );

                                    } else {
                                        $classes = $this->add_css_class( 'tdw-text', $classes );
                                    }

                                    if ( 'outofstock' === $term_data['stock_status'] || !$term_data['is_purchasable'] ) {
                                        $classes = $this->add_css_class( 'tdw-disabled tdw-linked', $classes );
                                    }

                                    if ( (string) $current_attributes['slugs'][ $attr_slug ] === (string) $term_slug ) {
                                        $classes = $this->add_css_class( 'tdw-active', $classes );
                                    }

                                    ?>

                                    <a class="<?php echo esc_attr( $classes ); ?>" href="<?php echo esc_url( $term_data['permalink'] ); ?>" title="<?php echo esc_html( $term_data['attributes']['labels'][$attr_slug] ); ?>">
                                        <?php if ( $styles || $image ) { ?>
                                            <span class="tdw-swatch-bg" style="<?php echo esc_attr($styles); ?>">
                                                <?php
                                                if ($image) {
                                                    echo $image;
                                                }
                                                ?>
                                            </span>
                                        <?php } ?>
                                        <span class="tdw-swatch-text">
                                            <?php echo esc_html( $term_data['attributes']['labels'][$attr_slug] ); ?>
                                        </span>
                                    </a>
                                <?php

                                }

                                ?>
                            </div>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
        <?php

        return ob_get_clean();

    }

    /**
     * Set data.
     *
     * @param int $product_id Product id.
     */
    private function set_linked_data( int $product_id ) {

        $post = new WP_Query(
            [
                'post_type'   => 'td_woo_lv',
                'numberposts' => 1,
                'meta_query'  => [
                    [
                        'key'     => 'td_woo_lv_settings',
                        'value'   => 's:15:"linked_products"',
                        'compare' => 'LIKE',
                    ],
                    [
                        'key'     => 'td_woo_lv_settings',
                        'value'   => sprintf( '"%d"', $product_id ),
                        'compare' => 'LIKE',
                    ],
                ],
            ]
        );

        if ( !$post->posts ) {
            return;
        }

        $td_woo_lv_settings = get_post_meta( $post->posts[0]->ID, 'td_woo_lv_settings', true );

        $this->linked_data = [
            'products'  => $td_woo_lv_settings['linked_products'] ?? [],
            'attrs'     => $td_woo_lv_settings['linked_attrs'] ?? [],
            'use_image' => $td_woo_lv_settings['linked_image_attr'] ?? [],
        ];
    }

    /**
     * Get product attributes.
     *
     * @param int $product_id Product id.
     *
     * @return array
     */
    private function get_product_attributes( int $product_id ) {

        $attributes = [];

        foreach ( $this->linked_data['attrs'] as $attribute ) {
            $terms = get_the_terms( $product_id, $attribute );

            if ( !$terms || is_wp_error( $terms ) ) {
                continue;
            }

            $first_term = array_pop( $terms );

            $attributes[$product_id]['slugs'][$attribute]    = $first_term->slug;
            $attributes[$product_id]['labels'][$attribute]   = $first_term->name;
            $attributes[$product_id]['taxonomy'][$attribute] = get_taxonomy($attribute)->labels->singular_name;
            $attributes[$product_id]['meta'][$attribute]     = [
                'color' => get_term_meta( $first_term->term_id, 'lv_color', true ),
                'image' => get_term_meta( $first_term->term_id, 'lv_image', true ),
            ];
        }

        return $attributes[$product_id] ?? $attributes;

    }

    /**
     * Get linked variations data.
     *
     * @param int $product_id Product id.
     *
     * @return array
     */
    public function get_linked_variations( $product_id ) {
        $attributes = $this->get_product_attributes( $product_id );

        $output     = array();

        if ( empty($attributes['slugs']) ) {
            return $output;
        }

        foreach ( $attributes['slugs'] as $taxonomy => $attribute ) {
            $taxonomy_ids = array();

            foreach ( $this->linked_data['products'] as $current_product_id ) {
                $current_product = wc_get_product( $current_product_id );

                if ( !$current_product || $current_product->get_status() !== 'publish' ) {
                    continue;
                }

                $current_product_attrs = $current_product->get_attributes();

                if ( is_wp_error( $current_product_attrs ) || empty( $current_product_attrs[ $taxonomy ] ) || !$current_product_attrs[ $taxonomy ]->get_options() ) {
                    continue;
                }

                $taxonomy_ids = array_merge( $taxonomy_ids, $current_product_attrs[ $taxonomy ]->get_options() );
            }

            $terms = get_terms(
                [
                    'taxonomy' => $taxonomy,
                    'include'  => array_unique( $taxonomy_ids ),
                ]
            );

            //echo '<pre>$taxonomy_ids: ' . print_r( array_unique( $taxonomy_ids ), true ) . '</pre>';
            //echo '<pre>$terms: ' . print_r( $terms, true ) . '</pre>';

            foreach ( $terms as $term ) {
                $data = $this->get_linked_variation_data_for_attribute( $product_id, $taxonomy, $term->slug );

                // save all taxonomy terms to linked data
                $this->linked_data[$taxonomy . '_terms'][$term->slug] = $term;

                if ( !$data ) {
                    continue;
                }

                $output[ $taxonomy ]['terms'][ $term->slug ] = $data;
                $output[ $taxonomy ]['label'][ $term->slug ] = $term->name;
            }
        }

        return $output;
    }

    /**
     * Get linked variation data for attribute.
     *
     * @param int $product_id Product id.
     * @param string $taxonomy Taxonomy.
     * @param string $term_slug Term slug.
     *
     * @return array
     */
    public function get_linked_variation_data_for_attribute( int $product_id, string $taxonomy, string $term_slug ) {
        $current_attributes = $this->get_product_attributes( $product_id );
        $linked_variations  = $this->get_linked_variations_data( $product_id );

        $current_attributes['slugs'][ $taxonomy ] = $term_slug;

        $output = [];
        foreach ( $linked_variations as $linked_variation ) {
            $linked_variation_attributes_slugs = $linked_variation['attributes']['slugs'] ?? [];

            if ( !array_diff_assoc( $current_attributes['slugs'], $linked_variation_attributes_slugs ) ) {
                $output = $linked_variation;
            }

        }

        return $output;
    }

    /**
     * Get linked variation data for attribute for a term.
     *
     * @param int $product_id Product id.
     * @param string $taxonomy Taxonomy.
     * @param string $term_slug Term slug.
     *
     * @return array
     */
    public function get_linked_variation_data_for_term( int $product_id, string $taxonomy, string $term_slug ) {
        $linked_variations  = $this->get_linked_variations_data( $product_id );

        $output = [];
        foreach ( $linked_variations as $linked_variation ) {
            $linked_variation_attributes_slugs_tax = $linked_variation['attributes']['slugs'][$taxonomy] ?? '';

            if ( $linked_variation_attributes_slugs_tax === $term_slug ) {
                $output = $linked_variation;
                break;
            }

        }

        return $output;
    }

    /**
     * Get product attributes.
     *
     * @param int $product_id Product id.
     *
     * @return array
     */
    private function get_linked_variations_data( int $product_id ) {
        $linked_products = [];

        foreach ( $this->linked_data['products'] as $linked_variation_id ) {
            $linked_variation = wc_get_product( $linked_variation_id );

            if ( !$linked_variation || $linked_variation->get_status() !== 'publish' ) {
                continue;
            }

            $linked_products[ $product_id ][ $linked_variation_id ] = [
                'id'             => $linked_variation_id,
                'permalink'      => $linked_variation->get_permalink(),
                'image'          => $linked_variation->get_image( 'shop_thumbnail' ),
                'title'          => $linked_variation->get_title(),
                'stock_status'   => $linked_variation->get_stock_status(),
                'is_purchasable' => $linked_variation->is_purchasable(),
                'attributes'     => $this->get_product_attributes( $linked_variation_id ),
            ];
        }

        return $linked_products[ $product_id ];
    }

    /**
     * Adds a CSS class to a string.
     *
     * @param string $class_to_add  The CSS class to add.
     * @param string $classes  The string to add the CSS class to.
     *
     * @return string The string with the CSS class added.
     */
    public function add_css_class( string $class_to_add, string $classes ): string {
        if ( empty($classes) ) {
            return $class_to_add;
        }

        return $classes . ' ' . $class_to_add;
    }

    /**
     * Returns blocks dummy data.
     *
     * @return string The block dummy data html.
     */
    public function get_block_dummy_data(): string {

        $sample_product_photo = TD_WOO_IMAGES_URL . '/sample_product_photo.png';

        ob_start();

        ?>

        <div>
            <table class="variations">
                <tbody>
                    <tr>
                        <th class="label cell">
                            <label>Attribute label</label>
                        </th>
                        <td class="value cell with-swatches">
                            <div class="tdw-swatches tdw-swatches-product tdw-lv-bg-style-1 tdw-lv-text-style-1 tdw-lv-dis-style-1 tdw-lv-size-large tdw-lv-shape-square">
                                <a class="tdw-swatch tdw-enabled tdw-bg" href="#">
                                    <span class="tdw-swatch-bg" style="">
                                        <img src="<?php echo $sample_product_photo ?>">
                                    </span>
                                    <span class="tdw-swatch-text">Attribute 1</span>
                                </a>
                                <a class="tdw-swatch tdw-enabled tdw-bg" href="#">
                                    <span class="tdw-swatch-bg" style="">
                                        <img src="<?php echo $sample_product_photo ?>">
                                    </span>
                                    <span class="tdw-swatch-text">Attribute 2</span>
                                </a>
                                <a class="tdw-swatch tdw-enabled tdw-bg" href="#">
                                    <span class="tdw-swatch-bg" style="">
                                        <img src="<?php echo $sample_product_photo ?>">
                                    </span>
                                    <span class="tdw-swatch-text">Attribute 3</span>
                                </a>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <?php

        return ob_get_clean();

    }

}

