<?php
/**
 * Real Estate Pro Demo Plugin Custom Modules & Styles Class
 */

class td_real_estate_pro_demo_cm_styles {

    var $td_demo_cmstyles_path = '';
	var $td_demo_cmstyles_url = '';

    function __construct( $plugin_path, $plugin_url ) {

		$this->td_demo_cmstyles_path = $plugin_path;
		$this->td_demo_cmstyles_url = $plugin_url;

        // Hook used to add or modify items via API, called early for registering styles
        add_action( 'td_global_after', function() {
            self::register_styles();
        }, 9 );

        // Hook used to add or modify items via API
        add_action( 'td_global_after', function() {

            /**
             * Modules
             */
            td_api_module::add('tds_module_real_estate_pro_1',
                array(
                    'file' => $this->td_demo_cmstyles_path . '/modules/tds_module_real_estate_pro_1.php',
                    'text' => 'Module Real Estate PRO 1',
                    'img' => '',
                    'used_on_blocks' => array(),
                    'excerpt_title' => 25,
                    'excerpt_content' => 25,
                    'enabled_excerpt_in_panel' => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops' => false,
                    'uses_columns' => false,
                    // if the module uses columns on the page template + loop
                    'category_label' => false,
                    'class' => 'td_module_wrap td-animation-stack',
                    'group' => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );

            td_api_module::add('tds_module_real_estate_pro_2',
                array(
                    'file' => $this->td_demo_cmstyles_path . '/modules/tds_module_real_estate_pro_2.php',
                    'text' => 'Module Real Estate PRO 2',
                    'img' => '',
                    'used_on_blocks' => array(),
                    'excerpt_title' => 25,
                    'excerpt_content' => 25,
                    'enabled_excerpt_in_panel' => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops' => false,
                    'uses_columns' => false,
                    // if the module uses columns on the page template + loop
                    'category_label' => false,
                    'class' => 'td_module_wrap td-animation-stack',
                    'group' => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );
        });

	}


    /**
     * Modules styles
     */
    public function register_styles() {
        
        td_api_style::add('tds_module_real_estate_pro_1_style', array(
            'group' => 'tds_module_loop_style',
            'title' => 'Module Real Estate PRO 1',
            'file' => $this->td_demo_cmstyles_path . '/styles/tds_module_loop_style/tds_module_real_estate_pro_1_style.php',
            'params' => array_merge(
                array(
                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Content length',
                        "value" => "",
                        "class" => "",
                        "group" => "Module"
                    ),
                    array(
                        "param_name" => "mc1_tl",
                        "type" => "textfield",
                        "value" => '',
                        "heading" => 'Title length',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => '25',
                        "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                        "group" => "Module"
                    ),
                    array(
                        "param_name" => "mc1_title_tag",
                        "type" => "dropdown",
                        "value" => array(
                            'Default - H3' => '',
                            'H1' => 'h1',
                            'H2' => 'h2',
                            'H4' => 'h4',
                            'Paragraph' => 'p'
                        ),
                        "heading" => 'Title tag (SEO)',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        "group" => "Module"
                    ),

                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'General',
                        "value" => "",
                        "class" => "",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "container_width",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Container width (0-100 percent)',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "100",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_container.png",
                    ),
                    array(
                        "param_name" => "modules_on_row",
                        "type" => "dropdown-responsive",
                        "value" => array(
                            '1' => '100%',
                            '2' => '50%',
                            '3' => '33.33333333%',
                            '4' => '25%',
                            '5' => '20%',
                            '6' => '16.66666667%',
                            '7' => '14.28571428%',
                            '8' => '12.5%',
                            '9' => '11.11111111%',
                            '10' => '10%',
                        ),
                        "heading" => 'Modules per row',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-small",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                    ),
                    array(
                        "param_name" => "modules_gap",
                        "type" => "textfield-responsive",
                        "value" => '48',
                        "heading" => 'Modules gap',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "40",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                    ),
                    array(
                        "param_name" => "m_padding",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Modules padding',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0px 0px 0px 0px",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                    ),
                    array(
                        "param_name" => "all_modules_space",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Modules bottom space',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "34",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Module background',
                        "param_name" => "m_bg",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                    ),
                ),
                td_config_helper::get_map_block_shadow_array('shadow', 'Module Shadow', 0, 0, 0, "Module", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_shadow.png', ''),
                array(
                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Modules border',
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "modules_border_size",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Border width',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0px 0px 0px 0px",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                    ),
                    array(
                        "param_name" => "modules_border_style",
                        "type" => "dropdown",
                        "value" => array(
                            'Solid' => '',
                            'Dotted' => 'dotted',
                            'Dashed' => 'dashed',
                        ),
                        "heading" => 'Border style',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border color',
                        "param_name" => "modules_border_color",
                        "value" => '#eaeaea',
                        "description" => '',
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                    ),
                    array(
                        "param_name" => "m_radius",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Border radius',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0px 0px 0px 0px",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Modules divider',
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "modules_divider",
                        "type" => "dropdown",
                        "value" => array(
                            'None' => '',
                            'Solid' => 'solid',
                            'Dotted' => 'dotted',
                            'Dashed' => 'dashed',
                        ),
                        "heading" => 'Modules divider',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Divider color',
                        "param_name" => "modules_divider_color",
                        "value" => '#eaeaea',
                        "description" => '',
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Hover',
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "h_effect",
                        "type" => "dropdown",
                        "value" => array(
                            'None' => '',
                            'Shadow' => 'shadow',
                            'Move up & shadow' => 'up-shadow',
                        ),
                        "heading" => 'Hover effect',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_hover_effect.png",
                    ),

                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Article image',
                        "value" => "",
                        "class" => "",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "image_size",
                        "type" => "dropdown",
                        "value" => array(
                            'Medium - Default - 696x0px' => '',
                            '-- [No crop] --' => '__',
                            'XSmall - 150x0px' => 'td_150x0',
                            'Small - 300x0px' => 'td_300x0',
                            'Large - 1068x0px' => 'td_1068x0',
                            'Full - 1920x0px' => 'td_1920x0',
                            '-- [Other sizes] --' => '__',
                            '218x150px' => 'td_218x150',
                            '324x400px' => 'td_324x400',
                            '485x360' => 'td_485x360'
                        ),
                        "heading" => 'Image size',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                    ),
                    array(
                        "param_name" => "image_height",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Image height (percent)',
                        "description" => "Default value in percent",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "50",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                    ),
                    array(
                        "param_name" => "image_width",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Image width (0-100 percent)',
                        "description" => "Default value in percent",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "100",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                    ),
                    array(
                        "param_name" => "image_floated",
                        "type" => "dropdown-responsive",
                        "value" => array(
                            'Normal' => 'no_float',
                            'Float left' => 'float_left',
                            'Float right' => 'float_right',
                            'Hidden' => 'hidden',
                        ),
                        "heading" => 'Image position',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_image_position.png",
                    ),
                    array(
                        "param_name" => "image_radius",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Image radius',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "0",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
                    ),
                    array(
                        "param_name" => "hide_image",
                        "type" => "checkbox",
                        "value" => '',
                        "heading" => "Hide image",
                        "description" => "",
                        "holder" => "div",
                        "class" => "",
                        "group" => 'Module',
                        "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
                    ),
                ),
                td_config_helper::mix_blend('Module'),
                td_config_helper::image_filters(),

                td_config::get_map_exclusive_label_array(),

                array(

                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Article meta info',
                        "value" => "",
                        "class" => "",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "meta_info_align",
                        "type" => "dropdown-responsive",
                        "value" => array(
                            'Default' => '',
                            'Top' => 'initial',
                            'Center' => 'center',
                            'Bottom' => 'flex-end',
                        ),
                        "heading" => 'Meta info alignment',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_vertical_align.png",
                    ),
                    array(
                        "param_name" => "meta_info_horiz",
                        "type" => "dropdown",
                        "value" => array(
                            'Left' => 'content-horiz-left',
                            'Center' => 'content-horiz-center',
                            'Right' => 'content-horiz-right'
                        ),
                        "heading" => 'Meta info horiz align',
                        "description" => "",
                        "holder" => "div",
                        'tdc_dropdown_images' => true,
                        "class" => "tdc-visual-selector tdc-add-class",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
                    ),
                    array(
                        "param_name" => "meta_width",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Meta info width',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "100%",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
                    ),
                    array(
                        "param_name" => "meta_margin",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Meta info margin',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0px 0px 0px 0px",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
                    ),
                    array(
                        "param_name" => "meta_padding",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Meta info padding',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "13px 0px 0px 0px",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
                    ),
                    array(
                        "param_name" => "meta_space",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Meta container space',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_meta_container_space.png",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module',
                    ),
                    array(
                        "type" => "gradient",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Meta info background',
                        "param_name" => "meta_bg",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                    ),
                ),
                td_config_helper::get_map_block_shadow_array('shadow_m', 'Meta info shadow', 0, 0, 0, "Module", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_meta_shadow.png', ''),
                array(
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => '',
                    ),
                ),
                td_config_helper::get_map_block_font_array('f_meta', false, 'Article meta info', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', ''),
                array(
                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Meta info border',
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Layout'
                    ),
                    array(
                        "param_name" => "meta_info_border_size",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Border width',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0px 0px 0px 0px",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/layout_meta_border_width.png",
                    ),
                    array(
                        "param_name" => "meta_info_border_style",
                        "type" => "dropdown",
                        "value" => array(
                            'Solid' => '',
                            'Dotted' => 'dotted',
                            'Dashed' => 'dashed',
                        ),
                        "heading" => 'Border style',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_style_general.png",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border color',
                        "param_name" => "meta_info_border_color",
                        "value" => '#eaeaea',
                        "description" => '',
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_color_general.png",
                    ),
                    array(
                        "param_name" => "meta_info_border_radius",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Border radius',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0px 0px 0px 0px",
                        "group" => "Module",
                        "info_img" => "",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Article title',
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Layout'
                    ),
                    array(
                        "param_name" => "art_title",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Article title space',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0px 0px 6px 0px",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Article title text color',
                        "param_name" => "title_txt",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Article title text hover',
                        "param_name" => "title_txt_hover",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "all_underline_height",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Underline size',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "0",
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Hover underline color',
                        "param_name" => "all_underline_color",
                        "value" => '#000',
                        "description" => '',
                        "group" => "Module",
                        "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                    ),
                    array(
                        "param_name" => "art_btn",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Article button space',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "20px 0px 0px 0px",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => '',
                    ),
                ),
                td_config_helper::get_map_block_font_array('f_title', true, 'Article title', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', ''),

                array(
                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Location',
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module'
                    ),
                    array(
                        "param_name" => "show_loc",
                        "type" => "dropdown-responsive",
                        "value" => array(
                            'Show' => 'flex',
                            'Hide' => 'none',
                        ),
                        "heading" => 'Show location',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "loc_margin",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Space',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "loc_padd",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Padding',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "loc_ico_size",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Icon size',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "10",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "loc_ico_space",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Icon space',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "5",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Icon color',
                        "param_name" => "loc_ico_color",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Text color',
                        "param_name" => "loc_txt_color",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module',
                    ),
                ),
                td_config_helper::get_map_block_font_array('f_loc', true, 'Location text', "Module"),

                array(
                    array(
                        "param_name" => "separator",
                        "type" => "text_separator",
                        'heading' => 'Custom fields',
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module'
                    ),
                    array(
                        "param_name" => "show_cf",
                        "type" => "dropdown-responsive",
                        "value" => array(
                            'Show' => 'flex',
                            'Hide' => 'none',
                        ),
                        "heading" => 'Show custom fields',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "cf_margin",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Space',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "cf_padd",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Padding',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "all_cf_border_size",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Border width',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "placeholder" => "0px 0px 0px 0px",
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "all_cf_border_style",
                        "type" => "dropdown-responsive",
                        "value" => array(
                            'Solid' => '',
                            'Dotted' => 'dotted',
                            'Dashed' => 'dashed',
                        ),
                        "heading" => 'Border style',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Module",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border color',
                        "param_name" => "all_cf_border_color",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Price text color',
                        "param_name" => "cf_price_color",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Price per text color',
                        "param_name" => "cf_price_per_color",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module',
                    ),
                    array(
                        "param_name" => "cf_star_size",
                        "type" => "textfield-responsive",
                        "value" => '',
                        "heading" => 'Reviews stars size',
                        "description" => "",
                        "holder" => "div",
                        "class" => "tdc-textfield-small",
                        "placeholder" => "",
                        "group" => "Module",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Empty reviews star color',
                        "param_name" => "cf_star_empty",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Half reviews star color',
                        "param_name" => "cf_star_half",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Full reviews star color',
                        "param_name" => "cf_star_full",
                        "value" => '',
                        "description" => '',
                        "group" => "Module",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => 'Module',
                    ),
                ),
                td_config_helper::get_map_block_font_array('f_cf_price', true, 'Price text', "Module"),
                td_config_helper::get_map_block_font_array('f_cf_price_per', false, 'Price per text', "Module")
            ),
        )
        );

        td_api_style::add('tds_module_real_estate_pro_2_style', array(
                'group' => 'tds_module_loop_style',
                'title' => 'Module Real Estate PRO 2',
                'file' => $this->td_demo_cmstyles_path . '/styles/tds_module_loop_style/tds_module_real_estate_pro_2_style.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Content length',
                            "value" => "",
                            "class" => "",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_tl",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Title length',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'General',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "container_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Container width (0-100 percent)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_container.png",
                        ),
                        array(
                            "param_name" => "modules_on_row",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                '1' => '100%',
                                '2' => '50%',
                                '3' => '33.33333333%',
                                '4' => '25%',
                                '5' => '20%',
                                '6' => '16.66666667%',
                                '7' => '14.28571428%',
                                '8' => '12.5%',
                                '9' => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading" => 'Modules per row',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-small",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name" => "modules_gap",
                            "type" => "textfield-responsive",
                            "value" => '48',
                            "heading" => 'Modules gap',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name" => "m_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Modules padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "all_modules_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Modules bottom space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "34",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Module background',
                            "param_name" => "m_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('shadow', 'Module Shadow', 0, 0, 0, "Module", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_shadow.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Modules border',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "modules_border_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name" => "modules_border_style",
                            "type" => "dropdown",
                            "value" => array(
                                'Solid' => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "modules_border_color",
                            "value" => '#eaeaea',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "m_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Modules divider',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "modules_divider",
                            "type" => "dropdown",
                            "value" => array(
                                'None' => '',
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Modules divider',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Divider color',
                            "param_name" => "modules_divider_color",
                            "value" => '#eaeaea',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Hover',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "h_effect",
                            "type" => "dropdown",
                            "value" => array(
                                'None' => '',
                                'Shadow' => 'shadow',
                                'Move up & shadow' => 'up-shadow',
                            ),
                            "heading" => 'Hover effect',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hover_effect.png",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article image',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "image_size",
                            "type" => "dropdown",
                            "value" => array(
                                'Medium - Default - 696x0px' => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px' => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px' => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading" => 'Image size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            "param_name" => "image_height",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name" => "image_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name" => "image_floated",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Normal' => 'no_float',
                                'Float left' => 'float_left',
                                'Float right' => 'float_right',
                                'Hidden' => 'hidden',
                            ),
                            "heading" => 'Image position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_position.png",
                        ),
                        array(
                            "param_name" => "image_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
                        ),
                        array(
                            "param_name" => "hide_image",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide image",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Module',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
                        ),
                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),

                    td_config::get_map_exclusive_label_array(),

                    array(

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article meta info',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "meta_info_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Default' => '',
                                'Top' => 'initial',
                                'Center' => 'center',
                                'Bottom' => 'flex-end',
                            ),
                            "heading" => 'Meta info alignment',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_vertical_align.png",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
                        ),
                        array(
                            "param_name" => "meta_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta info width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
                        ),
                        array(
                            "param_name" => "meta_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta info margin',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
                        ),
                        array(
                            "param_name" => "meta_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta info padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "13px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
                        ),
                        array(
                            "param_name" => "meta_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta container space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_container_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "gradient",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Meta info background',
                            "param_name" => "meta_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('shadow_m', 'Meta info shadow', 0, 0, 0, "Module", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_meta_shadow.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_meta', false, 'Article meta info', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Meta info border',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "meta_info_border_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_border_width.png",
                        ),
                        array(
                            "param_name" => "meta_info_border_style",
                            "type" => "dropdown",
                            "value" => array(
                                'Solid' => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_style_general.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "meta_info_border_color",
                            "value" => '#eaeaea',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_color_general.png",
                        ),
                        array(
                            "param_name" => "meta_info_border_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article title',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "art_title",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article title space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 6px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Article title text color',
                            "param_name" => "title_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Article title text hover',
                            "param_name" => "title_txt_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "all_underline_height",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Underline size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Hover underline color',
                            "param_name" => "all_underline_color",
                            "value" => '#000',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
                        array(
                            "param_name" => "art_btn",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article button space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "20px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_title', true, 'Article title', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', ''),

                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Location',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module'
                        ),
                        array(
                            "param_name" => "show_loc",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'flex',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show location',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "loc_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "loc_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "loc_ico_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Icon size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "10",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "loc_ico_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Icon space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "5",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "loc_ico_align",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Icon vertical align',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Icon color',
                            "param_name" => "loc_ico_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "param_name" => "loc_txt_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_loc', true, 'Location text', "Module"),

                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Custom fields',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module'
                        ),
                        array(
                            "param_name" => "show_cf",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'flex',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show custom fields',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "cf_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "cf_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "all_cf_border_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "all_cf_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_cf_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Icon color',
                            "param_name" => "cf_ico_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "cf_ico_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Icon size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "cf_ico_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Icon space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Value color',
                            "param_name" => "cf_val_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Label text color',
                            "param_name" => "cf_label_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "cf_label_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Label space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_cf_val', true, 'Value text', "Module"),
                    td_config_helper::get_map_block_font_array('f_cf_label', false, 'Label text', "Module"),

                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Price',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module'
                        ),
                        array(
                            "param_name" => "show_price",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'flex',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show price',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "price_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "price_padd",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "all_price_border_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "all_price_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "all_price_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Price text color',
                            "param_name" => "price_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Price per text color',
                            "param_name" => "price_per_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "param_name" => "star_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Reviews stars size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "",
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Empty reviews star color',
                            "param_name" => "star_empty",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Half reviews star color',
                            "param_name" => "star_half",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Full reviews star color',
                            "param_name" => "star_full",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_price', true, 'Price text', "Module"),
                    td_config_helper::get_map_block_font_array('f_price_per', false, 'Price per text', "Module")
                ),
            )
        );

    }

}