<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Contact_Info extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Contact Info', 'onelisting' );
		$this->wpwax_base = 'wpwaxtheme-contact-info';
		parent::__construct( $data, $args );
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'onelisting' ),
			),
			array(
				'type'        => Controls_Manager::TEXT,
				'id'          => 'heading',
				'label'       => esc_html__( 'Title', 'onelisting' ),
				'placeholder' => esc_html__( 'Contact Info', 'onelisting' ),
				'default'     => esc_html__( 'Contact Info', 'onelisting' ),

			),
			array(
				'type'        => Controls_Manager::TEXTAREA,
				'id'          => 'address',
				'label'       => esc_html__( 'Address', 'onelisting' ),
				'placeholder' => esc_html__( 'New Orleans', 'onelisting' ),
				'default'     => esc_html__( 'New Orleans', 'onelisting' ),

			),
			array(
				'type'        => Controls_Manager::TEXT,
				'id'          => 'phone',
				'label'       => esc_html__( 'Phone', 'onelisting' ),
				'placeholder' => esc_html__( '+66 2 246 022', 'onelisting' ),
				'default'     => esc_html__( '+66 2 246 022', 'onelisting' ),

			),
			array(
				'type'        => Controls_Manager::URL,
				'id'          => 'email',
				'label'       => esc_html__( 'Email Address', 'onelisting' ),
				'placeholder' => esc_html__( 'support@wpwax.com', 'onelisting' ),
			),
			array(
				'type'        => Controls_Manager::URL,
				'id'          => 'website',
				'label'       => esc_html__( 'Website URL', 'onelisting' ),
				'placeholder' => 'https://your-link.com',
			),

			// Socials
			array(
				'label' => esc_html__( 'Social Profiles', 'onelisting' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
				'id'    => 'address_heading',
			),
			array(
				'type'  => Controls_Manager::TEXT,
				'id'    => 'facebook',
				'label' => esc_html__( 'Facebook', 'onelisting' ),
			),
			array(
				'type'  => Controls_Manager::TEXT,
				'id'    => 'twitter',
				'label' => esc_html__( 'Twitter', 'onelisting' ),
			),
			array(
				'type'  => Controls_Manager::TEXT,
				'id'    => 'youtube',
				'label' => esc_html__( 'Youtube', 'onelisting' ),
			),
			array(
				'type'  => Controls_Manager::TEXT,
				'id'    => 'instagram',
				'label' => esc_html__( 'Instagram', 'onelisting' ),
			),
			array(
				'type'  => Controls_Manager::TEXT,
				'id'    => 'linkedin',
				'label' => esc_html__( 'Linkedin', 'onelisting' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Style Section

			array(
				'mode'  => 'section_start',
				'id'    => 'sec_color',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'onelisting' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => esc_html__( 'Title', 'onelisting' ),
				'selectors' => array( '{{WRAPPER}} .card.theme-card .card-header.theme-card-header h2' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_color',
				'label'     => esc_html__( 'Content', 'onelisting' ),
				'selectors' => array( 
					'{{WRAPPER}} .theme-contact-info__content' => 'color: {{VALUE}}',
					'{{WRAPPER}} .theme-contact-info__list .theme-contact-info i' => 'color: {{VALUE}}',
				 ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_hover_color',
				'label'     => esc_html__( 'Content Link Hover', 'onelisting' ),
				'selectors' => array( '{{WRAPPER}} a.theme-contact-info__content:hover' => 'color: {{VALUE}}' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typo',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'onelisting' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'content_typo',
				'label'    => esc_html__( 'Content Typography', 'onelisting' ),
				'selector' => '{{WRAPPER}} .theme-contact-info__content, {{WRAPPER}} .theme-contact-info__list .theme-contact-info i',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {

		$data = $this->get_settings();

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}