<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Counter extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = __( 'Counter', 'onelisting' );
		$this->wpwax_base = 'wpwax-counter';
		parent::__construct( $data, $args );
	}

	private function wpwax_load_scripts() {
		wp_enqueue_script( 'counter-up' );
		wp_enqueue_script( 'waypoints' );
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => __( 'General', 'onelisting' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => __( 'Title', 'onelisting' ),
				'default' => 'Lorem Number',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'number',
				'label'   => __( 'Number', 'onelisting' ),
				'default' => '55',
			),
			array(
				'type'        => Controls_Manager::TEXT,
				'id'          => 'number_prefix',
				'label'       => __( 'Number Prefix', 'onelisting' ),
				'placeholder' => '$',
			),
			array(
				'type'        => Controls_Manager::TEXT,
				'id'          => 'number_suffix',
				'label'       => __( 'Number Suffix', 'onelisting' ),
				'placeholder' => 'Plus',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'wpwax_animation_duration',
				'label'   => __( 'Animation Duration', 'onelisting' ),
				'default' => '2000',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'delay',
				'label'   => __( 'Delay', 'onelisting' ),
				'default' => '10',
			),
			array(
				'type'      => Controls_Manager::CHOOSE,
				'id'        => 'content_alginment',
				'label'     => __( 'Alignment', 'onelisting' ),
				'options'   => array(
					'left'   => array(
						'title' => __( 'Left', 'onelisting' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'onelisting' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => __( 'Right', 'onelisting' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => array( '{{WRAPPER}}' => 'text-align: {{VALUE}}' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => __( 'Color', 'onelisting' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'tilte_color',
				'label'     => __( 'Title', 'onelisting' ),
				'default'   => '#111111',
				'selectors' => array(
					'{{WRAPPER}} .theme-counter__title' => 'color: {{color}};',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'number_color',
				'label'     => __( 'Number', 'onelisting' ),
				'default'   => '#111111',
				'selectors' => array(
					'{{WRAPPER}} .theme-counter__number span' => 'color: {{color}};',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typography',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => __( 'Typography', 'onelisting' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => __( 'Title', 'onelisting' ),
				'selector' => '{{WRAPPER}} .theme-counter__title',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'number_typo',
				'label'    => __( 'Number', 'onelisting' ),
				'selector' => '{{WRAPPER}} .theme-counter__number span',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$counter_data = array(
			'time'  => $data['wpwax_animation_duration'],
			'delay' => $data['delay'],
		);

		$data['counter_data'] = json_encode( $counter_data );

		$this->wpwax_load_scripts();
		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}