<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CTA extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = __( 'Call to Action', 'onelisting' );
		$this->wpwax_base = 'wpwax-cta';
		parent::__construct( $data, $args );
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => __( 'General', 'onelisting' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => __( 'Title', 'onelisting' ),
				'default' => 'Lorem Ipsum',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'content',
				'label'   => __( 'Content', 'onelisting' ),
				'default' => 'Lorem Ipsum has been standard daand scrambled. Rimply dummy text of the printing and typesetting industry',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'buttontext',
				'label'   => __( 'Button Text', 'onelisting' ),
				'default' => 'Lorem Ipsum',
			),
			array(
				'type'        => Controls_Manager::TEXT,
				'id'          => 'buttonurl',
				'label'       => __( 'Button URL', 'onelisting' ),
				'placeholder' => 'https://your-link.com',
			),
			array(
				'type'      => Controls_Manager::CHOOSE,
				'id'        => 'content_alginment',
				'label'     => __( 'Alignment', 'onelisting' ),
				'options'   => array(
					'left'   => array(
						'title' => __( 'Left', 'onelisting' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'onelisting' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => __( 'Right', 'onelisting' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'center',
				'toggle'    => true,
				'selectors' => array(
					'{{WRAPPER}}' => 'text-align: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => __( 'Color', 'onelisting' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => __( 'Title', 'onelisting' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__title' => 'color: {{VALUE}}',
				),
				'default'   => '#CBCBCB',
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_color',
				'label'     => __( 'Content', 'onelisting' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__content' => 'color: {{VALUE}}',
				),
				'default'   => '#222222',
			),
			array(
				'label' => __( 'Button', 'onelisting' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
				'id'    => 'button_heading',
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_text_color',
				'label'     => __( 'Text', 'onelisting' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_text_color_hover',
				'label'     => __( 'Hover Text', 'onelisting' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_background_color',
				'label'     => __( 'Background', 'onelisting' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_background_color_hover',
				'label'     => __( 'Hover Background', 'onelisting' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a:hover' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_border_color',
				'label'     => __( 'Border', 'onelisting' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a' => 'border-color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_border_color_hover',
				'label'     => __( 'Hover Border', 'onelisting' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a:hover' => 'border-color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style_type',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => __( 'Typography', 'onelisting' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => __( 'Title', 'onelisting' ),
				'selector' => '{{WRAPPER}} .theme-cta__title',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'content_typo',
				'label'    => __( 'Content', 'onelisting' ),
				'selector' => '{{WRAPPER}} .theme-cta__content',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'btn_typo',
				'label'    => __( 'Button', 'onelisting' ),
				'selector' => '{{WRAPPER}} .theme-cta__button a',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}